// DocumentManager.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "DocumentManager.h"
#include "resource.h"

using namespace Alpha;
using namespace std;


// CDocumentManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDocumentManager::CDocumentManager() :
		m_iActiveDocument(-1), m_iLastActiveDocument(-1), m_pEventListener(0), m_hImageList(0) {
}

///	fXgN^
CDocumentManager::~CDocumentManager() {
	if(m_hImageList != 0) {
		const int	cIcons = ::ImageList_GetImageCount(m_hImageList);
		for(int i = 0; i < cIcons; ++i)
			::DestroyIcon(::ImageList_GetIcon(m_hImageList, i, ILD_NORMAL));
		::ImageList_Destroy(m_hImageList);
	}
}

/**
 *	hLgXg̖ɒǉ
 *	@param document	hLg
 */
void CDocumentManager::AddDocument(IDocumentContainer& document) {
	_AssertValid();
	for(size_t i = 0; i < m_documents.size(); ++i) {
		if(m_documents[i] == &document) {	// ̂ɂ
			SetActiveDocument(i);
			return;
		}
	}
	m_documents.push_back(&document);
	_ResetResources();
	if(m_documents.size() == 1)
		SetActiveDocument(0);
}

/**
 *	hLgXgňړ
 *	@param iDocument	ړhLg̔ԍ
 *	@param iInsertion	ړ
 *	@throw out_of_range	<var>iDocument</var> sȂƂX[
 */
void CDocumentManager::MoveDocument(size_t iDocument, size_t iInsertion) throw(out_of_range) {
	_AssertValid();
	if(iDocument >= m_documents.size())
		throw out_of_range("Specified index is out of range.");
	_ResetResources();
}

///	hLg̃XgɊÂăC[WXg () 쐬Aj[č\
void CDocumentManager::_ResetResources() {
	if(m_hImageList != 0) {
		const int	cIcons = ::ImageList_GetImageCount(m_hImageList);
		for(int i = 0; i < cIcons; ++i)
			::DestroyIcon(::ImageList_GetIcon(m_hImageList, i, ILD_NORMAL));
		::ImageList_Destroy(m_hImageList);
	}
	if(m_documents.empty()) {
		m_hImageList = 0;
		return;
	}
	m_hImageList = ::ImageList_Create(::GetSystemMetrics(SM_CXSMICON),
		::GetSystemMetrics(SM_CYSMICON), ILC_COLOR32 | ILC_MASK, 0, m_documents.size());
	while(m_bufferListMenu.GetItemCount() != 0)
		m_bufferListMenu.DeleteMenuItem(0, false);

	SHFILEINFOW	sfi;
	for(size_t i = 0; i < m_documents.size(); ++i) {
		::SHGetFileInfoW(m_documents[i]->GetFilePath().c_str(),
			0, &sfi, sizeof(SHFILEINFOW), SHGFI_ICON | SHGFI_SMALLICON);
		::ImageList_AddIcon(m_hImageList, sfi.hIcon);
		m_bufferListMenu.AppendMenuItem(i + CMD_VIEW_BUFFERLIST_START, MFT_OWNERDRAW,
			(i == m_iActiveDocument) ? MFS_CHECKED | MFS_ENABLED : MFS_ENABLED, 0);
	}
}

/**
 *	hLgXg폜āÃhLgANeBuɂB
 *	IDocumentContainer::DeleteInstance ͌ĂяoȂ
 *	@param iDocument	폜hLg̔ԍ
 *	@throw out_of_range	<var>iDocument</var> sȂƂX[
 */
void CDocumentManager::RemoveDocument(size_t iDocument) throw(out_of_range) {
	_AssertValid();
	if(iDocument >= m_documents.size())
		throw out_of_range("Specified index is out of range.");

	const bool	bRemovedActive = m_iActiveDocument == iDocument;

	m_documents.erase(m_documents.begin() + iDocument);
	if(m_iActiveDocument >= m_documents.size()) {
		assert(m_iActiveDocument != -1);
		--m_iActiveDocument;
	}
	if(m_iLastActiveDocument != -1 && m_iLastActiveDocument >= m_documents.size())
		--m_iLastActiveDocument;
	if(bRemovedActive) {
		m_iActiveDocument = -1;
		if(!m_documents.empty())
			SetActiveDocument((m_iLastActiveDocument != -1) ? m_iLastActiveDocument : m_documents.size() - 1);
	}
	_ResetResources();
}

/**
 *	w肵hLgANeBuɂ
 *	@param iDocument	hLg̔ԍ
 */
void CDocumentManager::SetActiveDocument(size_t iDocument) throw(out_of_range) {
//	_AssertValid();
	if(iDocument >= m_documents.size())
		throw out_of_range("Specified index is out of range.");
	if(iDocument == m_iActiveDocument)
		return;

	m_documents[iDocument]->OnActivate(true);
	if(m_iActiveDocument != -1)
		m_documents[m_iActiveDocument]->OnActivate(false);
	m_iLastActiveDocument = m_iActiveDocument;
	m_iActiveDocument = iDocument;

	if(m_iLastActiveDocument != -1)
		m_bufferListMenu.CheckMenuItem(m_iLastActiveDocument + CMD_VIEW_BUFFERLIST_START, false);
	m_bufferListMenu.CheckMenuItem(m_iActiveDocument + CMD_VIEW_BUFFERLIST_START, true);

	HWND	hWnd = m_documents[m_iActiveDocument]->GetWindow();
	if(::IsWindow/*Visible*/(hWnd) == TRUE)
		::SetFocus(hWnd);
	if(m_pEventListener != 0)
		m_pEventListener->OnActivatDocumentChanged();
}

/* [EOF] */