// CommandManager.h
// (c) 2004 exeal

#ifndef _COMMAND_MANAGER_H_
#define _COMMAND_MANAGER_H_

#include "AlphaInterfaces.h"
#include <map>


namespace Alpha {
	class CAlphaApp;

	///	Alpha ̑SR}hǗ
	class CCommandManager {
		// RXgN^
	public:
		CCommandManager(CAlphaApp& app);
		~CCommandManager();

		// \bh
	public:
		bool			CreateImageList(const std::wstring& strDirectory);
		void			ExecuteCommand(CommandId id, bool bUserContext);
		std::wstring	GetCaption(CommandId id) const;
		std::wstring	GetDescription(CommandId id) const;
		std::size_t		GetIconIndex(CommandId id) const;
		HIMAGELIST		GetImageList(bool bEnabled) const;
		CommandId		GetLastCommand() const;
		bool			IsChecked(CommandId id) const;
		bool			IsEnabled(CommandId id, bool bUserContext) const;

		// f[^o
	private:
		CAlphaApp&							m_app;
		HIMAGELIST							m_hImageListEnabled;
		HIMAGELIST							m_hImageListDisabled;
		std::map<CommandId, std::size_t>	m_iconIndices;
		CommandId							m_nLastCommandId;
		static const COLORREF				m_clrIconMask = RGB(0xFF, 0x00, 0xFF);
	};

	/**
	 *	R}hɑΉACR̃C[WXg̈ʒuԂ
	 *	@param id	R}h ID
	 *	@return		CfbNXBACRꍇ -1
	 */
	inline std::size_t CCommandManager::GetIconIndex(CommandId id) const {
		std::map<CommandId, std::size_t>::const_iterator	it;
		return (m_iconIndices.end() == (it = m_iconIndices.find(id))) ? -1 : it->second;
	}

	/**
	 *	C[WXgԂBԂꂽC[WXgjҏWĂ͂ȂȂ
	 *	@param bEnabled	p\ł邱Ƃ\ACR܂ރC[WXg擾ꍇ true
	 *	@return			C[WXg
	 */
	inline HIMAGELIST CCommandManager::GetImageList(bool bEnabled) const {
		return bEnabled ? m_hImageListEnabled : m_hImageListDisabled;
	}

	///	ŌɎsR}h̎ʒlԂ
	inline CommandId CCommandManager::GetLastCommand() const {
		return m_nLastCommandId;
	}
} // namespace Alpha

#endif /* _COMMAND_MANAGER_H_ */

/* [EOF] */