// CodePagesDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "CodePagesDlg.h"
#include "Alpha.h"
using Alpha::CCodePagesDlg;
using namespace Ascension::Encodings;


// CCodePagesDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CCodePagesDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LIST_CODEPAGES && wNotifyCode == LBN_DBLCLK) {
		OnOK();
		return true;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CCodePagesDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HWND			hwndCPList = GetDlgItem(IDC_LIST_CODEPAGES);
	set<CodePage>	cps;
	wchar_t			wszCpName[128];

	CEncoderFactory::GetInstance().EnumCodePages(cps);
	for(set<CodePage>::const_iterator it = cps.begin(); it != cps.end(); ++it) {
		const wchar_t*	pwsz = CAlphaApp::GetCodePageName(*it);
		if(pwsz != 0) {
			wcscpy(wszCpName, pwsz);
			if(m_nCodePage == *it)
				wcscat(wszCpName, L" *");
			const int	iItem = ::SendMessageW(hwndCPList, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(wszCpName));
			::SendMessageW(hwndCPList, LB_SETITEMDATA, iItem, *it);
		}
	}
	const int	cItems = ::SendMessageW(hwndCPList, LB_GETCOUNT, 0, 0L);
	for(int i = 0; i < cItems; ++i) {
		if(m_nCodePage == ::SendMessageW(hwndCPList, LB_GETITEMDATA, i, 0L)) {
			::SendMessageW(hwndCPList, LB_SETCURSEL, i, 0L);
			break;
		}
	}

	return true;
}

///	@see	CDialog::OnOK
void CCodePagesDlg::OnOK() {
	m_nCodePage = SendDlgItemMessage(IDC_LIST_CODEPAGES, LB_GETITEMDATA,
					SendDlgItemMessage(IDC_LIST_CODEPAGES, LB_GETCURSEL, 0, 0L), 0L);

	CDialog::OnOK();
}

/* [EOF] */