#!/usr/local/bin/perl

# bidi_class.pl (c) 2003-2004 exeal
# UnicodeData.txt ꤷ°
# ɥݥȤΥ޶ڤΥꥹ (8ĤȤ˲Ԥ) 롣
# 1Ĥ2:
#
#   unicat.pl <type> [-d:directory]
#
# type -- °
#
# ɸϡ

use strict;
use integer;

# show usage and abort
sub usage($) {
	die("\n" . shift() . "\nUsage: bidi_class.pl <type> [-d:directory]\n\n");
}

my $strFileName = 'UnicodeData.txt';

usage("Bad parameter number.") if($#ARGV != 0 and $#ARGV != 1);
if($#ARGV == 1) {
	usage("Parameter is illegal.") unless($ARGV[1] =~ /\-d\:(.+)/);
	my $strPath = $1;
	$strPath =~ tr/\"//;
	$strFileName = $strPath . "\\" . $strFileName;
}

my $strLine;
my $cMatch = 0;
my $strType = uc($ARGV[0]);

if(!open(FH, $strFileName)) {
	die("\nCannot open $strFileName.\nIf UnicodeData.txt is not current directory, you can use -d:<directory> switch to specify where the file is.\n");
}

while($strLine = <FH>) {
	if($strLine =~ m/^(.*?)\;.*?\;\w\w\;\d+?\;(\w+?)\;/) {
		my $cp = $1;
		if($2 eq $strType) {
			print(($cMatch++ % 8 == 0) ? "\n" : " ");
			print("0x$cp,");
		}
	}
}

close(FH);

# print "\n$cMatch characters output.\n\n";

__END__