// TextSearcher.h
// (c) 2004 exeal

#ifndef _TEXT_SEARCHER_H_
#define _TEXT_SEARCHER_H_
#include "AscensionCommon.h"
#include "../../Manah/Object.h"
#include <stdexcept>


namespace boost {
	template<class charT, class traits, class Allocator> class basic_regex;
}

namespace Ascension {

	namespace Private {
		class CAscensionRegExpTraits;
		typedef boost::basic_regex<char_t, CAscensionRegExpTraits, std::allocator<char_t> >	AscensionRegex;
	}

	/// K\̎sR
	enum SearchFailureReason {
		/// 
		SFR_SUCCEEDED,
		/// K\GW[hłȂ
		/// @see	EFailedToLoadRegExpEngine
		SFR_CANNOT_LOAD_ENGINE,
		/// KȂ
		/// @see	ERegExpPatternIsInvalid
		SFR_BAD_PATTERN,
		/// ̑̐K\G[
		/// @see	EMiscellaneousRegExpError
		SFR_SOMEWHAT_ERROR
	};

	/// 啶̓ꎋ
	enum CaseSensitivity {
		CS_NONE,	///< ʂ
		CS_ASCII,	///< ASCII At@xbĝ݋ʂȂ
		CS_SIMPLE,	///< Unicode P[XtHfBO (P)
		CS_FULL		///< Unicode P[XtHfBO (S)()
	};

	/// @
	enum SearchType {
		ST_LITERAL,		///< ʂ̌
		ST_REGEXP,		///< K\
		ST_WILDCARD,	///< ChJ[h ()
		ST_MIGEMO		///< Migemo
	};

	/// tHfBOIvV
	typedef ulong	FoldingOption;
	const FoldingOption
		FO_REMOVE_ACCENT		= 0x000001,	///< ANZgL̏
		FO_CANONICAL_DUPLICATES	= 0x000002,	///<
		FO_DASHES				= 0x000004,	///< _bV
		FO_GREEK_LETTERFORMS	= 0x000008,
		FO_HEBREW_ALTERNATES	= 0x000010,
		FO_JAMO					= 0x000020,
		FO_MATH_SYMBOL			= 0x000040,	///< wL
		FO_NATIVE_DIGIT			= 0x000080,	///< ̃XNvg
		FO_NOBREAK				= 0x000100,
		FO_OVERLINE				= 0x000200,
		FO_POSITIONAL_FORMS		= 0x000400,
		FO_SMALL_FORMS			= 0x000800,	///< `
		FO_SPACE				= 0x001000,	///< 󔒗ޕ
		FO_SPACING_ACCENTS		= 0x002000,
		FO_SUBSCRIPT			= 0x004000,	///< t
		FO_SYMBOL				= 0x008000,
		FO_UNDERLINE			= 0x010000,
		FO_VERTICAL_FORMS		= 0x020000;

	/// WJIvV
	typedef ushort	MultigraphExpansionOption;
	const MultigraphExpansionOption
		MEO_CIRCLED_SYMBOLS		= 0x0001,
		MEO_DOTTED				= 0x0002,
		MEO_ELLIPSIS			= 0x0004,
		MEO_FRACTION			= 0x0008,	///< 
		MEO_INTEGRAL			= 0x0010,
		MEO_LIGATURE			= 0x0020,
		MEO_PARENTHESIZED		= 0x0040,
		MEO_PRIMES				= 0x0080,
		MEO_ROMAN_NUMERALS		= 0x0100,
		MEO_SQUARED				= 0x0200,
		MEO_SQUARED_UNMARKED	= 0x0400,
		MEO_DIGRAPH				= 0x0800,
		MEO_OTHER_MULTIGRAPHS	= 0x1000;

	/// ătHfBOIvV
	typedef uchar	ProvisionalFoldingOption;
	const ProvisionalFoldingOption
		PFO_REMOVE_DIACRITIC	= 0x01,	///< 敪L
		PFO_HAN_RADICAL			= 0x02,	///< 
		PFO_KANA				= 0x04,	///< ƕЉ
		PFO_LETTER_FORMS		= 0x08,	///<
		PFO_SIMPLIFIED_HAN		= 0x10,	///< ȑ̎
		PFO_SUZHOU_NUMERAL		= 0x20,	///<
		PFO_WIDTH				= 0x40;	///< SpƔp

	/// 镶
	typedef uchar	CharacterSkipOption;
	const CharacterSkipOption
		CSO_PUNCTUATIONS	= 0x01,	///< ؂蕶
		CSO_SYMBOLS			= 0x02,	///< L
		CSO_WHITESPACES		= 0x04,	///< 󔒗ޕ
		CSO_DIACRITICS		= 0x08,	///< 敪L
		CSO_VOWELS			= 0x10,	///< ꉹ
		CSO_KASHIDA			= 0x20,	///< JV_
		CSO_CONTROLS		= 0x40;	///< 䕶

	/// IvV
	struct TSearchOption {
		bool						bForward;	///< 
		bool						bWholeWord;	///< PPʂŌ
		bool						bNoThrow;	///< K\sɗO𓊂Ȃ (SearchFailureReason g)
		SearchType					type;
		CaseSensitivity				caseSensitivity;
		FoldingOption				foldingOptions;
		MultigraphExpansionOption	multigraphExpansionOptions;
		ProvisionalFoldingOption	provisionalFoldingOptions;
		CharacterSkipOption			characterSkipOptions;

		TSearchOption() : bForward(true), bWholeWord(false), bNoThrow(true),
				type(ST_LITERAL), caseSensitivity(CS_NONE),
				foldingOptions(0), multigraphExpansionOptions(0), provisionalFoldingOptions(0), characterSkipOptions(0) {
		}
	};

/*	///	{BtO (ꎋ镶A\LȂǁBMS Word ̃pN)B
	///	̃tO͐K\ɂ͎gpłȂ
	typedef ushort	JapaneseFuzzySearchFlag;
	const JapaneseFuzzySearchFlag
		JFSF_KANATYPE					= 0x0001,	///< /Љ
		JFSF_YOUON_SOKUON				= 0x0002,	///< X/
		JFSF_MINUS_PROLONGEDMARK_DASH	= 0x0004,	///< }CiX//_bV
		JFSF_ITERATIONMARK				= 0x0008,	///< JԂL
		JFSF_UNUNIFIEDKANJI				= 0x0010,	///< \L̂
		JFSF_LEGACY_MODERN_KANAFIGURE	= 0x0020,	///< ̐V/
		JFSF_PROLONGEDMARK_VOWEL		= 0x0040,	///< ƕꉹ
		JFSF_DI_JI_DU_ZU				= 0x0080,	///< a/WAd/Y
		JFSF_BA_VA_HA_FA				= 0x0100,	///< o/@An/t@
		JFSF_TSI_THI_TI_DHI_JI			= 0x0200,	///< cB/eB/`AfB/W
		JFSF_HYU_FYU_BYU_VYU			= 0x0400,	///< q/tAr/
		JFSF_SE_SYE_ZE_JE				= 0x0800,	///< Z/VFA[/WF
		JFSF_A_YA_FOLLOWING_I_E			= 0x1000,	///< CiAGiɑA/
		JFSF_KI_KU_FOLLOWEDBY_S			= 0x2000;	///< Ts̑ÕL/N
*/

	/// K\GWpӂłȂƂ\O
	/// SearchFailureReason::SFR_CANNOT_LOAD_ENGINE
	class EFailedToLoadRegExpEngine : public std::runtime_error {
	public:
		///	RXgN^
		EFailedToLoadRegExpEngine()
				: std::runtime_error("Failed to load regular expression engine.") {
		}
	};

	/// K\p^[ȂƂ\O
	/// SearchFailureReason::SFR_BAD_PATTERN
	class ERegExpPatternIsInvalid : public std::logic_error {
	public:
		///	RXgN^
		ERegExpPatternIsInvalid(const std::string& str) : std::logic_error(str) {
		}
	};

	/// K\sɔ邻̗̑O
	/// SearchFailureReason::SFR_SOMEWHAT_ERROR
	class EMiscellaneousRegExpError : public std::runtime_error {
	public:
		///	RXgN^
		EMiscellaneousRegExpError(const std::string& strMessage) : std::runtime_error(strMessage) {
		}
	};

	class CLexer;
	class CBoundarySearcher;
#ifndef NO_REGEXP
	namespace Private {
		class CAscensionRegExpTraits;
	}
#endif /* !NO_REGEXP */

	///	eLXgs
	class CTextSearcher : public Manah::CObject {
		// RXgN^
	public:
		CTextSearcher();
		virtual ~CTextSearcher();
		NOCOPY(CTextSearcher);

		// \bh
	public:
		/*  */
		const string_t&			GetReplaceText() const;
		const string_t&			GetSearchText() const;
		const TSearchOption&	GetOptions() const;
		SearchFailureReason		GetFailureReason() const;
		static bool				IsMigemoAvailable();
		static bool				IsRegExpAvailable();
		void					SetCaseSensitivity(CaseSensitivity cs) const;
		void					SetOptions(const TSearchOption& options);
		void					SetReplaceText(const string_t& strText);
		void					SetSearchText(const string_t& strText);
		/*  */
		bool	Search(const string_t& strText, length_t iBegin,
					length_t& iFound, length_t& cchFound, const CBoundarySearcher& boundary)
					throw(EFailedToLoadRegExpEngine, ERegExpPatternIsInvalid, EMiscellaneousRegExpError);
	private:
		Manah::Text::CodePoint	_Fold(Manah::Text::CodePoint ch) const;

		// f[^o
	protected:
		string_t			m_strFindWhat;		// 
		string_t			m_strReplaceWith;	// u
		TSearchOption		m_options;			// IvV
		SearchFailureReason	m_failureReason;	// s̗R

#ifndef NO_REGEXP
		friend class Private::CAscensionRegExpTraits;
		Private::AscensionRegex*	m_pLastPattern;
#endif /* !NO_REGEXP */
	};


	///	CBoundarySearcher::SearchWordBoundary 
	///	CBoundarySearcher::SearchSentenceBoundary ŎgtO
	enum BoundaryPosition {
		BP_START			= 0x01,					///< 擪
		BP_END				= 0x02,					///< I[
		BP_AROUND			= BP_START | BP_END,	///< [
		BP_ALPHANUM			= 0x04,					///< P\̂
		BP_NOANOTHERLINE	= 0x08,					///< ݍŝ݂Ō
	};


	///	NX^EAPꋫEAE
	class CBoundarySearcher : public Manah::CObject {
	private:
		enum WBClass {
			format, aLetter, midLetter, midNumLet, midNum,
			numeric, space, other, uncalculated
		};

		// RXgN^
	public:
		explicit CBoundarySearcher(CEditView& view);

		// \bh
	public:
		static bool			AreSameScriptType(Manah::Text::CodePoint cp1, Manah::Text::CodePoint cp2);
		const CEditView&	GetView() const;
		static bool			IsFirstCharacterOfCluster(Manah::Text::CodePoint cp);
		bool				HasWordBoundaryAt(const string_t& str, length_t i) const;
		bool				HasSentenceBoundaryAt(const string_t& str, length_t i) const;
		CCharPos			SearchFirstCharacterOfCluster(const CCharPos& pos, bool bForward) const;
		CCharPos			SearchWordBoundary(const CCharPos& pos, bool bForward, BoundaryPosition bp) const;
		CCharPos			SearchSentenceBoundary(const CCharPos& pos, bool bForward, BoundaryPosition bp) const;
	private:
		WBClass	GetWordBoundaryClass(Manah::Text::CodePoint cp) const;

		// f[^o
	private:
		CEditView&	m_view;
	};


	/// Ǒ̎sRԂ
	inline SearchFailureReason CTextSearcher::GetFailureReason() const {
		AssertValid();
		return m_failureReason;
	}

	///	ݐݒ肳Ă錟Ԃ
	inline const TSearchOption& CTextSearcher::GetOptions() const {
		AssertValid();
		return m_options;
	}

	/// uԂ
	inline const string_t& CTextSearcher::GetReplaceText() const {
		AssertValid();
		return m_strReplaceWith;
	}

	/// Ԃ
	inline const string_t& CTextSearcher::GetSearchText() const {
		AssertValid();
		return m_strFindWhat;
	}

} // namespace Ascension

#endif /* _TEXT_SEARCHER_H_ */

/* [EOF] */