// LineLayout.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "LineLayout.h"
#include "EditView.h"
#include "KeywordManager.h"

using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah;
using namespace Manah::Text;
using namespace std;
using Manah::Windows::GDI::CDC;
//using CLineLayoutManager::BidiClass;


// InsertLine AInsertLines ŉ͂郌xB
// hLg̓ǂݍݑxƂ̌̍ŏ̍s̓I[o[wbhƂ̃g[hɂȂ
//#ifdef _DEBUG
//#define MINIMAL_PARSE_LEVEL	LPL_TOKEN
//#else
#define MINIMAL_PARSE_LEVEL	LPL_MULTILINEANNOTATION
//#endif /* _DEBUG */

// g[N͂s킸ɎRȑoeLXg̈ʒu͂s
//#define DONT_TOKENIZE_FOR_BIDI

#ifdef _DEBUG
#include "../../Manah/Timer.h"
using Manah::Windows::CTimer;
using Manah::Windows::dout;

namespace {
	template<typename T>
	void dumpArray(const T* arr, size_t c) {
		for(size_t i = 0; i < c; ++i)
			Manah::Windows::dout << arr[i] << L",";
		Manah::Windows::dout << L"\n";
	}
}
#endif /* _DEBUG */

/**
 *	@param freeLevel
 */
void CLineLayout::Free(LineParseLevel freeLevel) {
	if(freeLevel <= LPL_FULL) {
		delete[] m_caretPositions;
		m_caretPositions = 0;
		delete m_pWrappedOffsets;
		m_pWrappedOffsets = 0;
		m_lineParseLevel = LPL_TOKEN;
	}
	if(freeLevel <= LPL_TOKEN) {
		delete[] m_ppTokens;
		m_ppTokens = 0;
		m_lineParseLevel = LPL_MULTILINEANNOTATION;
	}
}


// CLineLayoutManager class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param view	r[
 */
CLineLayoutManager::CLineLayoutManager(CEditView& view)
		: m_view(view), m_pHead(0), m_pxMax(0), m_pMaxDisplayWidthLine(0), m_pLineCache(0) {
	m_pLexer = new CLexer(this);
}

///	fXgN^
CLineLayoutManager::~CLineLayoutManager() {
	DeleteAllLines();
	delete m_pLexer;
}

///	CAEgׂĔj
void CLineLayoutManager::DeleteAllLines() {
	AssertValid();

	CLineLayout*	pCurrent = m_pHead;
	CLineLayout*	pNext;

	while(pCurrent != 0) {
		pNext = pCurrent->m_pNext;
		delete pCurrent;
		pCurrent = pNext;
	}
	m_pHead = 0;
	m_pxMax = 0;
	m_pMaxDisplayWidthLine = 0;
	m_pLineCache = 0;
}

/**
 *	w肵s̃CAEg폜
 *	@param iLine			폜sԍ
 *	@exception out_of_range	<var>iLine</var> ݂Ȃsł΃X[
 */
void CLineLayoutManager::DeleteLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);

	if(pLine == 0)
		throw out_of_range("Specified line is not found.");
	m_pLineCache = 0;

	if(pLine->m_pNext == 0) {
		if(pLine->m_pPrev == 0)
			m_pHead = 0;
		else
			pLine->m_pPrev->m_pNext = 0;
		if(m_view.m_modeState.wrapMode == WPM_NONE && pLine == m_pMaxDisplayWidthLine)
			ModifyMaxDisplayWidth();
		if(pLine == m_view.m_layoutInfo.pAppDefinedSingleLine)
			m_view.m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pLine;
	} else {
		CLineLayout*	pTemp = pLine->m_pNext;
		if(pLine->m_pPrev == 0) {
			pLine->m_pNext->m_pPrev = 0;
			m_pHead = pLine->m_pNext;
		} else {
			pLine->m_pPrev->m_pNext = pLine->m_pNext;
			pLine->m_pNext->m_pPrev = pLine->m_pPrev;
		}
		if(m_view.m_modeState.wrapMode == WPM_NONE && pLine == m_pMaxDisplayWidthLine)
			ModifyMaxDisplayWidth();
		if(pLine == m_view.m_layoutInfo.pAppDefinedSingleLine)
			m_view.m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pLine;
		pLine = pTemp;
	}

	// 㑱̉e󂯂s`FbN (pLine  iLine ͊ɍ폜̍swĂ)
	if(pLine->m_pPrev == 0 && pLine->m_multilineAnnotationFromPrev == NullCookie)
		return;
	if(pLine->m_pPrev != 0 && pLine->m_pPrev->m_multilineAnnotationToNext == pLine->m_multilineAnnotationFromPrev)
		return;
	while(true) {
		ParseLineMultilineCommentContinue(iLine, pLine);
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_lineParseLevel < LPL_MULTILINEANNOTATION)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		++iLine;
	}
}

/**
 *	̍s̃CAEg폜
 *	@param iStart	폜Jns
 *	@param iEnd		폜Is (̍s폜)
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::DeleteLines(length_t iStart, length_t iEnd) throw(out_of_range) {
	AssertValid();
	assert(iStart <= iEnd);

	CLineLayout*	pLine = GetLineInternal(iStart);
	CLineLayout*	pLast = GetLineInternal(iEnd);

	if(pLine == 0 || pLast == 0)
		throw out_of_range("Specified lines are not found.");
	m_pLineCache = 0;

	CLineLayout*	pNext = 0;
	CLineLayout*	pBeginPrev = pLine->m_pPrev;
	CLineLayout*	pEndNext = pLast->m_pNext;
	bool			bMaxIsDeleted = false;

	if(pLine == m_pHead)
		m_pHead = pLast->m_pNext;

	while(true) {	// 폜
		pNext = pLine->m_pNext;
		if(pLine == m_pMaxDisplayWidthLine)
			bMaxIsDeleted = true;
		if(pLine == m_view.m_layoutInfo.pAppDefinedSingleLine)
			m_view.m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pLine;
		if(pNext == pEndNext)
			break;
		pLine = pNext;
	}

	if(pBeginPrev != 0)
		pBeginPrev->m_pNext = pEndNext;
	if(pEndNext != 0)
		pEndNext->m_pPrev = pBeginPrev;

	if(m_view.m_modeState.wrapMode == WPM_NONE && bMaxIsDeleted)
		ModifyMaxDisplayWidth();

	if(pEndNext == 0)
		return;
	pLine = pEndNext;

	// 㑱̉e󂯂s`FbN (pInfo  iLine ͊ɍ폜̍swĂ)
	if(pLine->m_pPrev == 0 && pLine->m_multilineAnnotationFromPrev == NullCookie)
		return;
	if(pLine->m_pPrev != 0 && pLine->m_pPrev->m_multilineAnnotationToNext == pLine->m_multilineAnnotationFromPrev)
		return;
	ulong	iLine = iStart;
	while(true) {
		ParseLineMultilineCommentContinue(iLine, pLine);
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_lineParseLevel < LPL_MULTILINEANNOTATION)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		++iLine;
	}
}
/*
///	w肵R[h|Cg̑oeLXgԂ
BidiClass CLineLayoutManager::GetBidiClass(ulong cp) {
	// bidi_class.pl 쐬
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error This method is based on old version of Unicode.
#endif
#include "Script\LineLayout_BidiClassList_4_0"
#define CHECK_BIDI_CLASS(klass)																	\
	if(binary_search(arr##klass, arr##klass + sizeof(arr##klass) / sizeof(ulong), cp))	\
		return BC_##klass

	switch(cp) {
	case 0x202A:	return BC_LRE;
	case 0x202B:	return BC_RLE;
	case 0x202C:	return BC_PDF;
	case 0x202D:	return BC_LRO;
	case 0x202E:	return BC_RLO;
	}
	CHECK_BIDI_CLASS(R);
	CHECK_BIDI_CLASS(AL);
	CHECK_BIDI_CLASS(EN);
	CHECK_BIDI_CLASS(ES);
	CHECK_BIDI_CLASS(ET);
	CHECK_BIDI_CLASS(AN);
	CHECK_BIDI_CLASS(CS);
	CHECK_BIDI_CLASS(NSM);
	CHECK_BIDI_CLASS(BN);
	CHECK_BIDI_CLASS(B);
	CHECK_BIDI_CLASS(S);
	CHECK_BIDI_CLASS(WS);
	CHECK_BIDI_CLASS(ON);
	return BC_L;
}*/

/**
 *	w肵s̃CAEgԂ
 *	@param iLine	s
 *	@return			CAEgB<var>iLine</var> Ȃ null
 */
CLineLayout* CLineLayoutManager::GetLine(length_t iLine) const {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);
	if(pLine != 0 && pLine->m_lineParseLevel != LPL_FULL)	// łĂȂ
		const_cast<CLineLayoutManager*>(this)->ParseLineCharacterPositions(iLine, pLine);
	assert(pLine == 0 || pLine->m_lineParseLevel == LPL_FULL);
	return pLine;
}

///	GetLine ̓ (Ԃs͖͂̏ꍇ)
CLineLayout* CLineLayoutManager::GetLineInternal(length_t iLine) const {
	AssertValid();

	CLineLayout*	pLine;
	length_t		iRest;
	bool			bForward;	// m_pNext ŌƂ^

	if(m_pLineCache == 0 || iLine <= dif(iLine, m_iLineCache)) {	// LbVgȂ or n_̕߂
		pLine = m_pHead;
		iRest = iLine;
		bForward = true;
	} else {	// LbV_̕߂Ƃ
		pLine = m_pLineCache;
		iRest = dif(m_iLineCache, iLine);
		bForward = m_iLineCache < iLine;
	}

	if(bForward) {
		while(pLine != 0) {
			if(iRest == 0) {
				m_iLineCache = iLine;
				m_pLineCache = pLine;
				return pLine;
			}
			pLine = pLine->m_pNext;
			--iRest;
		}
	} else {
		while(pLine != 0) {
			if(iRest == 0) {
				m_iLineCache = iLine;
				m_pLineCache = pLine;
				return pLine;
			}
			pLine = pLine->m_pPrev;
			--iRest;
		}
	}
	return 0;
}

/**
 *	ws̉͂ǂ̒xIĂ邩Ԃ
 *	@param iLine	_s
 *	@return			̓x
 */
LineParseLevel CLineLayoutManager::GetLineParseLevel(length_t iLine) const throw(out_of_range) {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);

	if(pLine == 0)
		throw out_of_range("Specified line is not found.");
	return pLine->m_lineParseLevel;
}

///	ő\s̕\Ԃ
int CLineLayoutManager::GetMaxDisplayWidth() const {
	AssertValid();
	return m_pxMax;
}

/**
 *	w肵s̃CAEg쐬AXgɒǉ
 *	@param iLine	sԍ
 *	@exception		iLine }s\ȍsԍł <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLine(length_t iLine) throw(out_of_range) {
	AssertValid();
	if(iLine > m_view.GetDocument()->GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayout*	pLine = 0;
	CLineLayout*	pPrev = 0;

	m_pLineCache = 0;

	// s̑}
	if(iLine == 0) {
		pLine = new CLineLayout();
		pLine->m_pNext = m_pHead;
		m_pHead->m_pPrev = pLine;
		m_pHead = pLine;
	} else {
		pPrev = GetLineInternal(iLine - 1);
		assert(pPrev != 0);
		pLine = new CLineLayout();
		pLine->m_pPrev = pPrev;
		pLine->m_pNext = pPrev->m_pNext;
		if(pPrev->m_pNext != 0)
			pPrev->m_pNext->m_pPrev = pLine;
		pPrev->m_pNext = pLine;
		pLine->m_multilineAnnotationFromPrev = pLine->m_pPrev->m_multilineAnnotationToNext;
	}
	if(MINIMAL_PARSE_LEVEL <= LPL_MULTILINEANNOTATION)
		ParseLineMultilineCommentContinue(iLine, pLine);
	else if(MINIMAL_PARSE_LEVEL == LPL_TOKEN)
		ParseLineTokens(iLine, pLine);
	else if(MINIMAL_PARSE_LEVEL == LPL_FULL)
		ParseLineCharacterPositions(iLine, pLine);
	else
		assert(false);

	if(pLine->m_pNext == 0)
		return;
	pLine = pLine->m_pNext;
	++iLine;

	// 㑱̉e󂯂s`FbN
	while(true) {
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_lineParseLevel < LPL_MULTILINEANNOTATION)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		ParseLineMultilineCommentContinue(++iLine, pLine);
	}
}

/**
 *	̍sCAEg쐬AXgɒǉ
 *	@param iStart	}Jns
 *	@param iEnd		}Is
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLines(length_t iStart, length_t iEnd) throw(out_of_range) {
	AssertValid();
	assert(iStart <= iEnd);

//	CTimer tm(L"InsertLines");
	if(iStart > m_view.GetDocument()->GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayout*	pBeginPrev = (iStart != 0) ? GetLineInternal(iStart - 1) : 0;
	CLineLayout*	pEndNext = GetLineInternal(iStart);
	CLineLayout*	pNewLine = 0;
	CLineLayout*	pNewPrevLine = 0;

	// s̑}
	for(length_t iLine = iStart; /* iLine <= iEnd */; ++iLine) {
		pNewLine = new CLineLayout();
		if(iLine == iStart) {
			pNewLine->m_pPrev = pBeginPrev;
			if(pBeginPrev == 0)
				m_pHead = pNewLine;
			else
				pBeginPrev->m_pNext = pNewLine;
		} else {
			pNewLine->m_pPrev = pNewPrevLine;
			pNewPrevLine->m_pNext = pNewLine;
		}
		if(iLine == iEnd) {
			pNewLine->m_pNext = pEndNext;
			if(pEndNext != 0)
				pEndNext->m_pPrev = pNewLine;
			break;
		}
		pNewPrevLine = pNewLine;
	}
	m_pLineCache = 0;

	// }s̏XV
	CLineLayout*	pLine = GetLineInternal(iStart);
	for(length_t iLine = iStart; iLine <= iEnd; ++iLine, pLine = pLine->m_pNext) {
		if(MINIMAL_PARSE_LEVEL <= LPL_MULTILINEANNOTATION)
			ParseLineMultilineCommentContinue(iLine, pLine);
		else if(MINIMAL_PARSE_LEVEL == LPL_TOKEN)
			ParseLineTokens(iLine, pLine);
		else if(MINIMAL_PARSE_LEVEL == LPL_FULL)
			ParseLineCharacterPositions(iLine, pLine);
		else
			assert(false);
	}

	// 㑱̉e󂯂s`FbN
	length_t	iLine_ = iEnd;
	pLine = pEndNext;
	if(pLine == 0)
		return;
	while(true) {
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_lineParseLevel < LPL_MULTILINEANNOTATION)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		ParseLineMultilineCommentContinue(++iLine_, pLine);
	}
}

/**
 *	SĂ̍sɑ΂Ďw肵x̉͂蒼Kv邱Ƃʒm
 *	@param lplInvalidity	̓x
 */
void CLineLayoutManager::Invalidate(LineParseLevel lplInvalidity) {
	AssertValid();

	CLineLayout*	pLine = m_pHead;

	while(pLine != 0) {
		if(pLine->m_lineParseLevel >= lplInvalidity)
			pLine->m_lineParseLevel = static_cast<LineParseLevel>(lplInvalidity - 1);
		pLine = pLine->m_pNext;
	}
}

/**
 *	w肵s̃CAEgXV
 *	@param iLine	(_) sԍ
 *	@return			es
 *	@exception		iLine ݂Ȃsł <code>out_of_range</code>
 */
length_t CLineLayoutManager::ModifyLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);

	if(pLine == 0)
		throw out_of_range("Specified line is not found.");
	m_pLineCache = 0;

	// ܂Ԃƍs̕\ɂ
	LineIterator		it = m_view.GetDocument()->GetLineIterator(iLine);
	const CEditDocLine*	pLineInfo = &(*it);
	const char_t*		pszLine = pLineInfo->GetLine().c_str();
	const length_t		cchLine = pLineInfo->GetLine().length();
	ulong				cxLine = 0;

	delete pLine->m_pWrappedOffsets;
	pLine->m_pWrappedOffsets = 0;
	pLine->m_lineParseLevel = LPL_UNPARSED;

//	hOldFont = m_pView->m_gdiObjects.oMemDC.SelectObject(m_pView->m_gdiObjects.hNormalFont);

//	if(m_pView->m_modeState.wpmWrapMode == WPM_NONE)
		ParseLineCharacterPositions(iLine, pLine);
/*	else {	// ܂Ԃ̌vZ
		ulong	cxWrap;
		uint	cxChar;

		pInfo->m_pvecWrappedOffsets = new WrappedOffsets;
		if(m_pView->m_modeState.wpmWrapMode == WPM_SPECIFIED)
			cxWrap = m_pView->m_modeState.nWrapWidth;
		else if(m_pView->m_modeState.wpmWrapMode == WPM_WINDOW) {
			RECT	rect;
			m_pView->GetClientRect(&rect);
			cxWrap = rect.right - rect.left
						- m_pView->m_layoutInfo.nLeftTabWidth - m_pView->m_layoutInfo.nLeftMargin;
		}
		for(ulong i = 0; i < cchLine; ++i) {
			if(*(pszLine + i) == L'\t')
				cxChar = m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth()
							- cxLine % (m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth());
			else
				cxChar = m_pView->m_gdiObjects.oMemDC.GetTextExtent(pszLine + i, 1).cx;
			if(cxLine + cxChar > cxWrap) {	// ܂Ԃ
				pInfo->m_pvecWrappedOffsets->push_back(i);
				cxLine = 0;
			}
			cxLine += cxChar;
		}
	}

	m_pView->m_gdiObjects.oMemDC.SelectObject(hOldFont);*/

	// 㑱s̕sRgɂ
	length_t	cModifiedLines = 1;
	while(true) {
		if(pLine->m_pNext == 0
				|| (pLine->m_pNext->m_lineParseLevel < LPL_MULTILINEANNOTATION)
				|| pLine->m_multilineAnnotationToNext == pLine->m_pNext->m_multilineAnnotationFromPrev) {
			break;	// e͂̍sŏI
		}
		pLine = pLine->m_pNext;
		ParseLineMultilineCommentContinue(iLine + cModifiedLines, pLine);
		++cModifiedLines;
	}
	return cModifiedLines;
}

///	ő\sT
void CLineLayoutManager::ModifyMaxDisplayWidth() {
	AssertValid();

	m_pxMax = 0;
	for(CLineLayout* pLine = m_pHead; pLine != 0; pLine = pLine->m_pNext) {
		if(pLine->m_cxPixel > m_pxMax) {
			m_pxMax = pLine->m_cxPixel;
			m_pMaxDisplayWidthLine = pLine;
		}
	}
}

///	@see	ILexerEventListener::OnLexerAddedIdentifiedToken
void CLineLayoutManager::OnLexerAddedIdentifiedToken(Ascension::TokenType type, TokenCookie nCookie) {
	AssertValid();
	m_view.m_pTokenFoundations->tfs[type].pmapTfs->insert(
		pair<TokenCookie, TTextFoundation>(nCookie, TTextFoundation()));
}

///	@see	ILexerEventListener::OnLexerChanged
void CLineLayoutManager::OnLexerChanged() {
	AssertValid();
	Invalidate(MINIMAL_PARSE_LEVEL);
	m_view.OnUpdate(this, 0, this);
}

///	@see	ILexerEventListener::OnLexerCleared
void CLineLayoutManager::OnLexerCleared() {
	AssertValid();
	m_view.m_pTokenFoundations->tfs[TT_KEYWORD].pmapTfs->clear();
	m_view.m_pTokenFoundations->tfs[TT_ANNOTATION].pmapTfs->clear();
	Invalidate(MINIMAL_PARSE_LEVEL);
	m_view.OnUpdate(this, 0, this);
}

///	@see	ILexerEventListener::OnLexerRemovedIdentifiedToken
void CLineLayoutManager::OnLexerRemovedIdentifiedToken(Ascension::TokenType type, TokenCookie nCookie) {
	AssertValid();
	map<TokenCookie, TTextFoundation>::iterator	itRemoved =
		m_view.m_pTokenFoundations->tfs[type].pmapTfs->find(nCookie);
	m_view.m_pTokenFoundations->tfs[type].pmapTfs->erase(itRemoved);
}

/**
 *	@brief	ws̉͂sB͍ς݂łΉȂ
 *
 *	CLineLayoutManager ̃NCAg GetLine
 *	gƂŉ͍ς݂̍s擾ł邪AGetLine
 *	ȊÕ\bh͍s͂sȂ̂ŁA
 *	̃\bhŗ\߉͂sƂŃI[owbhɘa邱Ƃł
 *
 *	@param iLine	_s
 */
void CLineLayoutManager::ParseLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pLine = GetLineInternal(iLine);

	if(pLine == 0)
		throw out_of_range("Specified line is not found.");
	if(pLine->m_lineParseLevel < LPL_FULL)
		ParseLineCharacterPositions(iLine, pLine);
}

/**
 *	ʒǔvZs
 *	@param iLine	_sԍ
 *	@param pLayout	s̃CAEg (ȗƍsԍ擾)
 */
void CLineLayoutManager::ParseLineCharacterPositions(length_t iLine, CLineLayout* pLayout /* = 0 */) {
	AssertValid();

	if(pLayout == 0)
		pLayout = GetLineInternal(iLine);

	// g[N؂oIĂȂ΂Ȃ
	if(pLayout->m_lineParseLevel < LPL_TOKEN)
		ParseLineTokens(iLine, pLayout);

	const bool		bIgnoreBidi	= m_view.m_options.displayOptions[DONT_CONSIDER_BIDIRECTION];
	const length_t	cchLine = m_view.GetDocument()->GetLineLength(iLine);

	delete[] pLayout->m_caretPositions;
	pLayout->m_caretPositions = new int[cchLine + 1];
	pLayout->m_caretPositions[0] = 0;

	if(cchLine == 0) {
		pLayout->m_cxPixel = 0;
		pLayout->m_lineParseLevel = LPL_FULL;
		return;
	}

	const string_t&	strLine = m_view.GetDocument()->GetLine(iLine);
	const char_t*	pwszLine = strLine.c_str();
	CDC<>&			dc = m_view.m_gdiObjects.memDC;
	HFONT			hOldFont = dc.SelectObject(m_view.m_gdiObjects.hNormalFont);
	size_t			iToken = 0;
	GCP_RESULTSW	gcpr;
	uint*			orders = !bIgnoreBidi ? new uint[cchLine + 1] : 0;
	char*			classes = !bIgnoreBidi ? new char[cchLine + 1] : 0;
	length_t		nOffset = 0;	// s̈ʒu

	dc.SetTextCharacterExtra(m_view.m_layoutInfo.nCharSpan);
	if(!bIgnoreBidi) {
		ZeroMemory(&gcpr, sizeof(GCP_RESULTSW));
		gcpr.lStructSize = sizeof(GCP_RESULTSW);
	}

	length_t	iStart = 0, iEnd = 0;
	const DWORD	dwGCPFlags = GCP_DIACRITIC | GCP_DISPLAYZWG | GCP_GLYPHSHAPE | GCP_REORDER | GCP_SYMSWAPOFF;

	while(iEnd < cchLine) {	// g[NƂ̃[v
		const length_t	cchToken = (iToken < pLayout->m_cTokens - 1) ?
							pLayout->m_ppTokens[iToken + 1]->GetIndex() - iEnd : cchLine - iEnd;
		CTokenLayout*	pToken = pLayout->m_ppTokens[iToken];

		iStart = iEnd;
		iEnd = /*m_pView->m_modeState.bResetDirByToken ?*/ (iStart + cchToken) /*: cchLine*/;
		TTextFoundation&	tf = m_view.GetTextFoundation(pToken->GetType(), pToken->GetCookie());

		// ԊuƃtHg̐ݒ
		if(m_view.m_pTokenFoundations->arrEnabled[pToken->GetType()]
				&& tf.bold && m_view.m_options.displayOptions[CLOSE_BOLD_CHARACTERS])
			dc.SetTextCharacterExtra(m_view.m_layoutInfo.nCharSpan - 1);
		dc.SelectObject(m_view.GetFontForRenderingToken(pToken->GetType(), pToken->GetCookie()));

		// g[N̍[
		pToken->m_nLeftEdge = nOffset;

		// oeLXĝ߂ɕ̓oꏇvZB
		// ̃ASY Win32 GetCharacterPlacementW ɈˑĂA
		// UAX #9 (http://www.unicode.org/reports/tr9/) Ƃ͖֌W
		if(!bIgnoreBidi) {
			// R[h|Cg̏oƕނ𓾂
			gcpr.nGlyphs = iEnd - iStart;
			gcpr.lpClass = classes + iStart;
			gcpr.lpOrder = orders + iStart;
			dc.GetCharacterPlacement(pwszLine + iStart, iEnd - iStart, 0, gcpr, dwGCPFlags);
//			dumpArray(arrOrder, gcpr.nGlyphs);

			// \AĂȂʒu𒲂ׂ
			TSubstringDirection	direction = {0, 0, false};
			pToken->m_pDirectionList = new DirectionList();
			pToken->m_pDirectionList->push_back(direction);
			for(length_t iChar = pToken->GetIndex() + 1;
					iChar < pToken->GetIndex() + cchToken; ++iChar) {
				if(orders[iChar] - orders[iChar - 1] != 1
						&& orders[iChar - 1] - orders[iChar] != 1
						&& orders[iChar] != orders[iChar - 1]) {
					direction.iStartChar = iChar - pToken->GetIndex();
					pToken->m_pDirectionList->push_back(direction);
				}
			}

			// ̕߂
			list<CDirectionMarker>	markers;
			DirectionList::iterator itDirs = pToken->m_pDirectionList->begin();
			CDirectionMarker		marker;
			while(itDirs != pToken->m_pDirectionList->end()) {
				DirectionList::iterator	itNext = itDirs;

				++itNext;
				const length_t	iDirStart = pToken->GetIndex() + itDirs->iStartChar;
				length_t		cch = (itNext != pToken->m_pDirectionList->end()) ?
					(itNext->iStartChar - itDirs->iStartChar) : (cchToken - itDirs->iStartChar);
				if(cch > 2) {
					if(orders[iDirStart + 1] - orders[iDirStart] == 1)	// LTR
						itDirs->bRightToLeft = false;
					else if(orders[iDirStart] - orders[iDirStart + 1] == 1)	// RTL
						itDirs->bRightToLeft = true;
					else if(orders[iDirStart] == orders[iDirStart + 1])
						itDirs->bRightToLeft =
							classes[iDirStart] == GCPCLASS_ARABIC
							|| classes[iDirStart] == GCPCLASS_HEBREW;
					else {	// 蓾
//						Manah::Windows::dout << arrOrder[iDirStart] << ","
//							<< arrOrder[iDirStart + 1] << "\n";
						assert(false);
					}
				} else if(cch == 2) {	// 2̏ꍇ͏sAȂł͕s\ȏꍇ
					const bool	bRtl0 =
						classes[iDirStart] == GCPCLASS_ARABIC || classes[iDirStart] == GCPCLASS_HEBREW;
					const bool	bRtl1 =
						classes[iDirStart + 1] == GCPCLASS_ARABIC || classes[iDirStart + 1] == GCPCLASS_HEBREW;

					if((bRtl0 && !bRtl1) || (!bRtl0 && bRtl1)) {
						direction.iStartChar = itDirs->iStartChar + 1;
						pToken->m_pDirectionList->insert(itNext, direction);
						cch = 1;
					}
					itDirs->bRightToLeft = bRtl0;
				} else	// 1̏ꍇ classes ̕ނg
					itDirs->bRightToLeft =
						classes[iDirStart] == GCPCLASS_ARABIC
						|| classes[iDirStart] == GCPCLASS_HEBREW;

				CDirectionMarker*	pLastAddedMarker = markers.empty() ? 0 : &(*(--markers.end()));
				if(pLastAddedMarker == 0 || itDirs->bRightToLeft != pLastAddedMarker->m_pDir->bRightToLeft) {
					marker.m_pDir = &(*itDirs);
					marker.m_iOrder = orders[iDirStart];
					marker.m_cch = cch;
					markers.push_back(marker);
					++itDirs;
				} else {	// ̕1OƓȂ獡Xg폜
					pLastAddedMarker->m_cch += cch;
					itDirs = pToken->m_pDirectionList->erase(itDirs);
				}
			}

			// ȏ񂩂l߂Ă
			markers.sort();
			for(list<CDirectionMarker>::const_iterator it = markers.begin(); it != markers.end(); ++it) {
				const length_t	iStart = pToken->GetIndex() + it->m_pDir->iStartChar;
				const length_t	cch = it->m_cch;
				length_t		iLastControl = iStart;	// ŌɌ䕶̍s̈ʒu ( while [vQ)
				SIZE			size;
				bool			bIsLast = ++it == markers.end();

				--it;
				if(!it->m_pDir->bRightToLeft)	// LTR ̏ꍇA`Jnʒu
					it->m_pDir->nLeadEdge = nOffset;

				// g[N̐䕶 (^u܂) 
				// API œ̂ƈقȂ镶ŕ`悷̂ŕʈ
				while(true) {
					// ̐䕶T
					length_t	iControl = string_t::npos;
					for(length_t i = iLastControl; i < iStart + cch; ++i) {
						if(CLexer::IsAsciiControl(pwszLine + i, 1) == 1) {
							iControl = i;
							break;
						}
					}

					// 䕶܂
					if(iControl == string_t::npos || iControl - iLastControl != 0) {
						const length_t	cchSubstring = (iControl != string_t::npos) ?
											iControl - iLastControl : iStart + cch - iLastControl;
//						if(iLastControl + cchSubstring == cchLine)
//							++cchSubstring;
//						const int	dxLastOrg = arrCaretPos[iLastControl + cchSubstring];
						dc.GetTextExtentExPoint(pwszLine + iLastControl,
							cchSubstring, 0, 0, pLayout->m_caretPositions + iLastControl + 1, &size);
//						if(!bIsLast)
//							pLayout->m_caretPositions[iLastControl + cchSubstring] = dxLastOrg;
						pLayout->m_caretPositions[iLastControl] = nOffset;
						if(nOffset != 0) {
							for(length_t i = iLastControl; i < iLastControl + cchSubstring; ++i)
								pLayout->m_caretPositions[i + 1] += nOffset;
						}
						nOffset += size.cx;
						if(iControl == string_t::npos)
							break;
					}

					// 䕶
					if(pwszLine[iControl] == L'\t')	// ^u
						nOffset = m_view.GetNextTabStop(nOffset, m_view.m_options.displayOptions[RIGHT_TO_LEFT_READING]);
					else {	// ^uȊO
						const string_t	strControl = CLexer::GetAsciiControlAlternateText(static_cast<uchar>(pwszLine[iControl]));
						nOffset += dc.GetTextExtent(strControl.data(), strControl.length()).cx;
					}
					pLayout->m_caretPositions[iControl + 1] = nOffset;
					iLastControl = iControl + 1;

					if(iLastControl == iStart + cch)
						break;
				}
				if(it->m_pDir->bRightToLeft)	// RTL ̏ꍇA`Jnʒu
					it->m_pDir->nLeadEdge = nOffset;

				// RTL ̌̕vZʂt܂ɂ
				if(it->m_pDir->bRightToLeft) {
					const length_t	iStart = pToken->GetIndex() + it->m_pDir->iStartChar;
					const int		nSubstringLeft = pLayout->m_caretPositions[iStart];
					const length_t	iEnd = iStart + it->m_cch + (bIsLast ? 1 : 0);

					for(length_t i = iStart; i < iEnd; ++i)
						pLayout->m_caretPositions[i] =
							pLayout->m_caretPositions[iStart + it->m_cch]
							- pLayout->m_caretPositions[i] + nSubstringLeft;
				}
			}

			// S LTR ̏ꍇ
			if(pToken->m_pDirectionList->size() == 1
					&& !pToken->m_pDirectionList->begin()->bRightToLeft) {
				delete pToken->m_pDirectionList;
				pToken->m_pDirectionList = 0;
			}
		} else {	// oeLXglȂꍇ̌vZ͂
			SIZE		size;
			length_t	iLast = iStart;

			pLayout->m_caretPositions[iStart] = nOffset;
			for(length_t i = iStart; i < iEnd; ++i) {	// ASCII 䕶TȂ
				if(CLexer::IsAsciiControl(pwszLine + i, 1) == 1) {
					// ŌɌ䕶玟̐䕶܂
					if(i != iLast) {
						dc.GetTextExtentExPoint(pwszLine + iLast,
							i - iLast, 0, 0, pLayout->m_caretPositions + iLast + 1, &size);
						if(nOffset != 0) {
							for(length_t j = iLast + 1; j < i + 1; ++j)
								pLayout->m_caretPositions[j] += nOffset;
						}
						nOffset += size.cx;
					}

					// 䕶
					pLayout->m_caretPositions[i] = nOffset;
					if(pwszLine[i] == L'\t')	// ^u
						nOffset = m_view.GetNextTabStop(nOffset, false);
					else {	// ^uȊO
						const string_t	strControl = CLexer::GetAsciiControlAlternateText(static_cast<uchar>(pwszLine[i]));
						nOffset += dc.GetTextExtent(strControl.data(), strControl.length()).cx;
					}
					iLast = i + 1;
					pLayout->m_caretPositions[iLast] = nOffset;
				}
			}
			if(iLast != iEnd) {	// 䕶̌낪cĂ
				dc.GetTextExtentExPoint(pwszLine + iLast,
					iEnd - iLast, 0, 0, pLayout->m_caretPositions + iLast + 1, &size);
				if(nOffset != 0) {
					for(length_t j = iLast + 1; j < iEnd + 1; ++j)
						pLayout->m_caretPositions[j] += nOffset;
				}
				nOffset += size.cx;
			}
		}

		// n
		if(m_view.m_pTokenFoundations->arrEnabled[pToken->GetType()]
				&& tf.bold && m_view.m_options.displayOptions[CLOSE_BOLD_CHARACTERS])
			dc.SetTextCharacterExtra(m_view.m_layoutInfo.nCharSpan);
		pToken->m_nTextWidth = nOffset - pToken->m_nLeftEdge;

		// ̃g[N
		++iToken;
	}

	pLayout->m_cxPixel = nOffset;
#ifdef _DEBUG
	if(false) {	// for trace
		dumpArray(orders, cchLine + 1);
		dumpArray(classes, cchLine + 1);
		dumpArray(pLayout->m_caretPositions, cchLine + 1);
	}
#endif
	if(!bIgnoreBidi) {
		delete[] orders;
		delete[] classes;
	}
	dc.SelectObject(hOldFont);

	// ő\̌vZ (ł͂Ȃ...)
	if(pLayout->m_cxPixel > m_pxMax) {
		m_pxMax = pLayout->m_cxPixel;
		m_pMaxDisplayWidthLine = pLayout;
		m_view.m_pOriginalView->ModifyScrollInfo(true, false);
	} else if(pLayout == m_pMaxDisplayWidthLine) {
		ModifyMaxDisplayWidth();
		m_view.m_pOriginalView->ModifyScrollInfo(true, false);
	}

	pLayout->m_lineParseLevel = LPL_FULL;
}

/**
 *	s̐擪A̕sRg
 *	@param iLine	_sԍ
 *	@param pLayout	sCAEg (ȗƍsԍ擾)
 */
void CLineLayoutManager::ParseLineMultilineCommentContinue(length_t iLine, CLineLayout* pLayout /* = 0 */) {
	AssertValid();

	if(pLayout == 0)
		pLayout = GetLineInternal(iLine);

	// O̍s̕sRgI󋵂g
	if(pLayout->m_pPrev == 0)
		pLayout->m_multilineAnnotationFromPrev = NullCookie;
	else {
		// O̍s͂Ȃ΍ċAIɉ͂
		CLineLayout*	pLine = pLayout;
		
		// ܂͂łŏ̍s܂Ŗ߂
		while(true) {
			if(pLine->m_pPrev == 0) {	// 擪s
				pLine->m_multilineAnnotationFromPrev = NullCookie;
				break;
			} else if(pLine->m_pPrev->m_lineParseLevel >= LPL_MULTILINEANNOTATION) {	// ͍ς݂̍sɓ
				pLine->m_multilineAnnotationFromPrev = pLine->m_pPrev->m_multilineAnnotationToNext;
				break;
			}
			pLine = pLine->m_pPrev;
			--iLine;
		}

		// ͂Ȑ擪s pLine ܂ł
		const CEditDoc*	pDocument = m_view.GetDocument();
		while(true) {
			pLine->m_multilineAnnotationToNext =
				m_pLexer->ParseMultilineAnnotation(pDocument->GetLine(iLine), pLine->m_multilineAnnotationFromPrev);
			pLine->m_lineParseLevel = LPL_MULTILINEANNOTATION;
			if(pLine == pLayout)	// ŏɉ͂悤ƂĂs
				break;
			pLine = pLine->m_pNext;
			++iLine;
			pLine->m_multilineAnnotationFromPrev = pLine->m_pPrev->m_multilineAnnotationToNext;
		}
	}
}

/**
 *	g[N؂os
 *	@param iLine	_sԍ
 *	@param pLayout	sCAEg (ȗƍsԍ擾)
 */
void CLineLayoutManager::ParseLineTokens(length_t iLine, CLineLayout* pLayout /* = 0 */) {
	AssertValid();

	if(pLayout == 0)
		pLayout = GetLineInternal(iLine);

	// O̍s畡sRgĂ邩ǂĂȂ΂Ȃ
	if(pLayout->m_pPrev != 0 && (pLayout->m_pPrev->m_lineParseLevel < LPL_MULTILINEANNOTATION))
		ParseLineMultilineCommentContinue(iLine - 1, pLayout->m_pPrev);
	pLayout->m_multilineAnnotationFromPrev =
		(pLayout->m_pPrev != 0) ? pLayout->m_pPrev->m_multilineAnnotationToNext : NullCookie;

	const string_t&	strLine = m_view.GetDocument()->GetLine(iLine);

	if(pLayout->m_ppTokens != 0) {
		for(size_t i = 0; i < pLayout->m_cTokens; ++i)
			delete pLayout->m_ppTokens[i];
		delete[] pLayout->m_ppTokens;
		pLayout->m_ppTokens = 0;
	}
	if(strLine.empty()) {
		pLayout->m_cTokens = 0;
		pLayout->m_multilineAnnotationToNext = pLayout->m_multilineAnnotationFromPrev;
		pLayout->m_lineParseLevel = LPL_TOKEN;
		return;
	}

	TokenList	tokens;
	TokenCookie	nCookie = pLayout->m_multilineAnnotationFromPrev;
#ifdef DONT_TOKENIZE_FOR_BIDI
	CToken	token(0, TT_UNSPECIFIED, NullCookie);
	tokens.push_back(token);
#else
	m_pLexer->Parse(strLine, nCookie, tokens);
#endif

	pLayout->m_cTokens = tokens.size();
	pLayout->m_ppTokens = new CTokenLayout*[pLayout->m_cTokens];

	size_t	iToken = 0;
	for(TokenList::const_iterator it = tokens.begin(); it != tokens.end(); ++it, ++iToken)
		pLayout->m_ppTokens[iToken] = new CTokenLayout(*it);
	pLayout->m_multilineAnnotationToNext = nCookie;
	pLayout->m_lineParseLevel = LPL_TOKEN;
}

void CLineLayoutManager::ReconstructAll() {
	AssertValid();
	DeleteAllLines();
	InsertLines(0, m_view.GetDocument()->GetLineCount() - 1);
}

/* [EOF] */