// Lexer.h
// (c) 2004 exeal

#ifndef _LEXER_H_
#define _LEXER_H_
#include "AscensionCommon.h"
#include "../../Manah/SmallObject.h"
#include <list>
#include <set>
#include <map>
#include <algorithm>	// std::binary_search


namespace Ascension {

	///	L[[hARgȂǕ݂ނ̃g[Nʂl
	typedef short	TokenCookie;
	///	ʂȃNbL[l
	const TokenCookie	NullCookie = 0;

	///	g[N̎
	///	@see	EmphaticTextType
	enum TokenType {
		TT_WHITESPACE,		///< 󔒗ޕ
		TT_TAB,				///< ^u
		TT_KEYWORD,			///< L[[h
		TT_ANNOTATION,		///<  (Rg)
		TT_OPERATOR,		///< Zq
		TT_IDENTIFIER,		///< ʎq
		TT_NUMERAL,			///< 
		TT_NUMBER,			///< l
		TT_SINGLEQUOTATION,	///< dp
		TT_DOUBLEQUOTATION,	///< dp
		TT_OTHERQUOTATION,	///< ̑ Unicode p
		TT_ASCII_CONTROL,	///< ASCII 䕶
		TT_UNICODE_CONTROL,	///< Unicode 䕶
		TT_UNSPECIFIED,		///< 
		TT_COUNT
	};

	///	ľ`
	enum NumberFormat {
		NF_NUMERAL_FOLLOWED_BY_ALPHANUMERAL,	///< ̌ɃAt@xbgAA܂͏_ ()
		NF_CPLUSPLUS,							///< C++ le
		NF_PERL,								///< Perl 5 le
		NF_RUBY,								///< Ruby 1.8 le
		NF_VBSCRIPT,							///< VBScript 5.6 le
		NF_JAVASCRIPT_15,						///< JavaScript 1.5 le
		NF_JAVASCRIPT_20,						///< JavaScript 2.0 le
		NF_COUNT,
	};

	///	߂̋K
	typedef uchar	AnnotationRestriction;
	const AnnotationRestriction	AR_NONE				= 0x00;	///< 
	const AnnotationRestriction	AR_ONLYSTARTOFLINE	= 0x01;	///< ŝ
	const AnnotationRestriction	AR_ONLYHEADOFLINE	= 0x02;	///< 󔒗ޕȊO̍ŏ̃g[N̂

	///	͊̃Cxgnh
	interface ILexerEventListener {
		///	fXgN^
		virtual			~ILexerEventListener() {}
		/**
		 *	@brief	L[[hRgǉꂽ
		 *
		 *	̌ OnLexerChanged Ăяo
		 *	@param type		g[N̎
		 *	@param nCookie	g[ÑNbL[
		 */
		virtual	void	OnLexerAddedIdentifiedToken(TokenType type, TokenCookie nCookie) = 0;
		///	͂̋Kς
		virtual void	OnLexerChanged() = 0;
		///	͂̋KSč폜ꂽ
		virtual void	OnLexerCleared() = 0;
		/**
		 *	@brief	L[[hRg폜ꂽ
		 *
		 *	̌ OnLexerChanged Ăяo
		 *	@param type		g[N̎
		 *	@param nCookie	g[ÑNbL[
		 */
		virtual	void	OnLexerRemovedIdentifiedToken(TokenType type, TokenCookie nCookie) = 0;
	};

	///	g[N
	///	@see	CTokenLayout
	class CToken : public Manah::Windows::CSmallObject<> {
		friend class CLexer;

		// RXgN^
	public:
		CToken();
		CToken(length_t i, TokenType type, TokenCookie nCookie);

		// \bh
	public:
		TokenCookie	GetCookie() const;
		length_t	GetIndex() const;
		TokenType	GetType() const;
	private:
		void	SetCookie(TokenCookie nCookie);
		void	SetType(TokenType type);

		// f[^o
	private:
		length_t	m_i;	// sł̈ʒu
		ushort		m_type;	// 4rbg (TokenType)A12rbgʒl (TokenCookie)
	};

	namespace Private {
		// L[[hr (XbhS͖)
		struct TKeywordComparer {
			bool operator()(const string_t& str1, const string_t& str2) const {
				if(bCaseSensitive)
					return wcscmp(str1.c_str(), str2.c_str()) < 0;
				else
					return ::StrCmpIW(str1.c_str(), str2.c_str()) < 0;
			}
			static bool	bCaseSensitive;
		};
	}

	typedef std::list<CToken>								TokenList;
	typedef std::set<string_t, Private::TKeywordComparer>	KeywordSet;
	typedef std::map<TokenCookie, KeywordSet>				KeywordsMap;

	/**
	 *	@brief	͊
	 *
	 *	L[[h̑啶ʂȂꍇ̃P[XtHfBO Unicode 4.0 ɂ͏]ĂȂB
	 *
	 *	AddXXXX œo^g[N̗D揇ʂ͕񒷂̒̂ȂB
	 */
	class CLexer : public Manah::CObject {
		// RXgN^
	public:
		CLexer(ILexerEventListener* pEventListener);
		virtual ~CLexer();
		NOCOPY(CLexer);

		// \bh ()
	public:
		TokenCookie	AddMultilineAnnotation(const string_t& strStartDelimiter,
						const string_t& strEndDelimiter, AnnotationRestriction ar = AR_NONE);
		TokenCookie	AddSinglelineAnnotation(const string_t& strStartDelimiter, AnnotationRestriction ar = AR_NONE);
		TokenCookie	AddSinglelineAnnotation(const string_t& strStartDelimiter,
						const string_t& strEndDelimiter, AnnotationRestriction ar = AR_NONE);
		TokenCookie	AddKeywords(const std::set<string_t>& keywords);
		void		EnableToken(TokenType type, bool bEnable);
		void		EnableUnicodeAlphabets(bool bEnable);
		void		EnableUnicodeWhiteSpaces(bool bEnable);
		void		Freeze();
		bool		GetBracketTraits(char_t chBracket, char_t& chPair, bool& bOpener) const;
		const KeywordsMap&	GetKeywords() const;
		NumberFormat		GetNumberFormat() const;
		void		IgnoreCase(bool bIgnore);
		bool		IsCaseSensitive() const;
		bool		IsFreezed() const;
		bool		IsTokenEnabled(TokenType type) const;
		bool		IsUnicodeAlphabetsEnabled() const;
		bool		IsUnicodeWhiteSpacesEnabled() const;
		void		RemoveAll();
		void		RemoveIdentifiedToken(TokenCookie nCookie) throw(std::invalid_argument);
		void		Reset();
		void		SetAdditionalAlphabets(const char_t* pwszAlphabets, length_t cch);
		void		SetAdditionalAlphabets(const std::set<Manah::Text::CodePoint>& alphabets);
		void		SetBrackets(const char_t* pwszBrackets)  throw(std::invalid_argument);
		void		SetNumberFormat(NumberFormat format) throw(std::invalid_argument);
		void		SetOperators(const std::set<string_t>& operators);
		void		Unfreeze();

		// \bh ()
	public:
		static string_t	GetAsciiControlAlternateText(uchar ch);
		static length_t	IsAsciiControl(const char_t* pwsz, length_t cch);
		static bool		IsDigitCodePoint(Manah::Text::CodePoint cp);
		length_t		IsIdentifier(const char_t* pwsz, length_t cch) const;
		bool			IsIdentifierContinueCodePoint(Manah::Text::CodePoint cp) const;
		bool			IsIdentifierStartCodePoint(Manah::Text::CodePoint cp) const;
		bool			IsKeyword(const string_t& str, TokenCookie& nCookie) const;
		length_t		IsOperator(const char_t* pwsz, length_t cch) const;
		static length_t	IsQuotation(const char_t* pwsz, length_t cch, char_t chOpen);
		length_t		IsMultilineAnnotation(const char_t* pwsz, length_t cch,
							AnnotationRestriction ar, TokenCookie& nCookie, bool& bContinued) const;
		static length_t	IsNumerals(const char_t* pwsz, length_t cch);
		length_t		IsNumber(const char_t* pwsz, length_t cch) const;
		length_t		IsSinglelineAnnotation(const char_t* pwsz, length_t cch,
							AnnotationRestriction ar, TokenCookie& nCookie) const;
		static bool		IsUnicodeControl(const char_t* pwsz, length_t cch);
		length_t		IsWhiteSpace(const char_t* pwsz, length_t cch, bool bIncludeTab) const;
		void			Parse(const string_t& str, TokenCookie& nCookie, TokenList& tokens) const;
		TokenCookie		ParseMultilineAnnotation(const string_t& str, TokenCookie nCookie) const;
	private:
		void	NotifyChange();

		// Jo萔
	public:
		static const char_t	m_wszDefaultOpeners[];
		static const char_t	m_wszUnicodeOpeners[];

		// Jf[^^
	private:
		///	sŏIPs
		struct TSinglelineAnnotationEndedByBreak {
			string_t	strStartDelimiter;	///< Jn
			AnnotationRestriction	ar;		///< 
		};

		///	wf~^ŏIPs
		struct TSinglelineAnnotationEndedByDelimiter {
			string_t	strStartDelimiter;	///< Jn
			string_t	strEndDelimiter;	///< I
			AnnotationRestriction	ar;		///<  (Jnf~^ɂ̂݉e)
		};

		///	s
		struct TMultilineAnnotation {
			string_t	strStartDelimiter;	///< Jn
			string_t	strEndDelimiter;	///< I
			AnnotationRestriction	ar;		///<  (Jnf~^ɂ̂݉e)
		};

		typedef std::map<TokenCookie, TSinglelineAnnotationEndedByBreak>		SAnnotationBMap;
		typedef std::map<TokenCookie, TSinglelineAnnotationEndedByDelimiter>	SAnnotationDMap;
		typedef std::map<TokenCookie, TMultilineAnnotation>						MAnnotationMap;
		typedef std::set<string_t, std::greater<string_t> >						OperatorSet;
		typedef std::map<char_t, OperatorSet>									OperatorMap;

		// f[^o
	private:
		bool				m_bFreezed;
		bool				m_bCaseSensitive;
		bool				m_bEnableUnicodeAlphabets;
		bool				m_bEnableUnicodeWhiteSpaces;
		bool				m_enabledTokenTypes[TT_COUNT];
		NumberFormat		m_numberFormat;
		char_t*				m_pwszBrackets;
		static TokenCookie	m_nCookie;
		ILexerEventListener*				m_pEventListener;
		std::set<Manah::Text::CodePoint>	m_additionalAlphabets;	// At@xbgƂ݂ȂR[h|Cg

		KeywordsMap		m_keywords;					// L[[hQ
		SAnnotationBMap	m_singlelineAnnotationBs;	// Ps
		SAnnotationDMap	m_singlelineAnnotationDs;	// Ps
		MAnnotationMap	m_multilineAnnotations;		// s
		OperatorMap		m_operators;				// Zq
	};


	namespace Private {
		// R[h|Cgނ̂߂̔zB
		// Unicode 4.0 ɊÂĂB
#if ASCENSION_UNICODE_VERSION != 0x0400
#error These array is based on old version of Unicode.
#endif
		// ʕނ Zs (Separator, Space) łR[h|Cg
		// unicat.pl 莩 (Unicode 4.0)
		// NOTE: ListProp.txt ɂ WhiteSpace ƂvpeB邪
		// ̔z͂̏W (Ⴆΐ䕶Ȃǂ͊OĂ)
		static const Manah::Text::CodePoint	zs[] = {
			0x0020, 0x00A0, 0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003,
			0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x200B,
			0x202F, 0x205F, 0x3000,
		};
		// ʕނ Cc (Other, Control) ACf (Other, Format) łR[h|Cg
		// unicat.pl 莩 (Unicode 4.0)
		static const Manah::Text::CodePoint	cc[] = {
			0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
			0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
			0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
			0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
			0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
			0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E,
			0x008F, 0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096,
			0x0097, 0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E,
			0x009F,
		};
		static const Manah::Text::CodePoint	cf[] = {
			0x00AD, 0x0600, 0x0601, 0x0602, 0x0603, 0x06DD, 0x070F, 0x17B4,
			0x17B5, 0x200C, 0x200D, 0x200E, 0x200F, 0x202A, 0x202B, 0x202C,
			0x202D, 0x202E, 0x2060, 0x2061, 0x2062, 0x2063, 0x206A, 0x206B,
			0x206C, 0x206D, 0x206E, 0x206F, 0xFEFF, 0xFFF9, 0xFFFA, 0xFFFB,
			0x1D173, 0x1D174, 0x1D175, 0x1D176, 0x1D177, 0x1D178, 0x1D179, 0x1D17A,
			0xE0001, 0xE0020, 0xE0021, 0xE0022, 0xE0023, 0xE0024, 0xE0025, 0xE0026,
			0xE0027, 0xE0028, 0xE0029, 0xE002A, 0xE002B, 0xE002C, 0xE002D, 0xE002E,
			0xE002F, 0xE0030, 0xE0031, 0xE0032, 0xE0033, 0xE0034, 0xE0035, 0xE0036,
			0xE0037, 0xE0038, 0xE0039, 0xE003A, 0xE003B, 0xE003C, 0xE003D, 0xE003E,
			0xE003F, 0xE0040, 0xE0041, 0xE0042, 0xE0043, 0xE0044, 0xE0045, 0xE0046,
			0xE0047, 0xE0048, 0xE0049, 0xE004A, 0xE004B, 0xE004C, 0xE004D, 0xE004E,
			0xE004F, 0xE0050, 0xE0051, 0xE0052, 0xE0053, 0xE0054, 0xE0055, 0xE0056,
			0xE0057, 0xE0058, 0xE0059, 0xE005A, 0xE005B, 0xE005C, 0xE005D, 0xE005E,
			0xE005F, 0xE0060, 0xE0061, 0xE0062, 0xE0063, 0xE0064, 0xE0065, 0xE0066,
			0xE0067, 0xE0068, 0xE0069, 0xE006A, 0xE006B, 0xE006C, 0xE006D, 0xE006E,
			0xE006F, 0xE0070, 0xE0071, 0xE0072, 0xE0073, 0xE0074, 0xE0075, 0xE0076,
			0xE0077, 0xE0078, 0xE0079, 0xE007A, 0xE007B, 0xE007C, 0xE007D, 0xE007E,
			0xE007F,
		};
} // namespace Private


	///	ftHgRXgN^
	inline CToken::CToken() {
	}

	///	RXgN^
	inline CToken::CToken(length_t i, TokenType type, TokenCookie nCookie)
			: m_i(i), m_type((type << 12) | nCookie) {
	}

	///	g[NɊ֘AtꂽNbL[lԂ (RgAL[[ĥݗL)
	inline TokenCookie CToken::GetCookie() const {
		AssertValid();
		return m_type & 0x0FFF;
	}

	///	͕̒ł̐擪̈ʒuԂ
	inline length_t CToken::GetIndex() const {
		AssertValid();
		return m_i;
	}

	///	g[N̎ނԂ
	inline TokenType CToken::GetType() const {
		AssertValid();
		return static_cast<TokenType>(m_type >> 12);
	}

	inline void CToken::SetCookie(TokenCookie nCookie) {
		AssertValid();
		m_type &= 0xF000;
		m_type |= 0x0FFF & nCookie;
	}

	inline void CToken::SetType(TokenType type) {
		AssertValid();
		m_type &= 0x0FFF;
		m_type |= (type & 0x000F) << 12;
	}


#define ENABLE_SWITCH(a, b)	\
	do {					\
		if(a != b) {		\
			a = b;			\
			NotifyChange();	\
		}					\
	} while(false)

	/**
	 *	g[NL/ɂ
	 *	@param type		g[N̎
	 *	@param bEnable	Lɂꍇ true
	 */
	inline void CLexer::EnableToken(TokenType type, bool bEnable) {
		AssertValid();
		if(type >= TT_COUNT)
			return;
		ENABLE_SWITCH(m_enabledTokenTypes[type], bEnable);
	}

	///	Unicode At@xbgAt@xbgƂĎgp邩ݒ肷
	inline void CLexer::EnableUnicodeAlphabets(bool bEnable) {
		AssertValid();
		ENABLE_SWITCH(m_bEnableUnicodeAlphabets, bEnable);
	}

	///	Unicode 󔒗ޕ󔒗ޕƂĎgp邩ݒ肷
	inline void CLexer::EnableUnicodeWhiteSpaces(bool bEnable) {
		AssertValid();
		ENABLE_SWITCH(m_bEnableUnicodeWhiteSpaces, bEnable);
	}

	///	ݒ肪ύXĂCxgnhɒʒmȂ悤ɂ
	inline void CLexer::Freeze() {
		AssertValid();
		m_bFreezed = true;
	}

	///	ASCII 䕶̑փeLXgԂ
	inline string_t CLexer::GetAsciiControlAlternateText(uchar ch) {
		string_t	str;
		str.reserve(2);
		str.push_back(L'^');
		str.push_back(ch + ((ch != 0x7F) ? 0x40 : -0x40));
		return str;
	}

	///	L[[hQԂ
	inline const KeywordsMap& CLexer::GetKeywords() const {
		AssertValid();
		return m_keywords;
	}

	/// ͂Ŏgl`Ԃ
	inline NumberFormat CLexer::GetNumberFormat() const {
		AssertValid();
		return m_numberFormat;
	}

	/**
	 *	ASCII 䕶̒ԂB^u䕶Ƃ݂Ȃ
	 *	@param pwsz	ׂ镶
	 *	@param cch	
	 *	@return		ASCII 䕶AĂ钷
	 */
	inline length_t CLexer::IsAsciiControl(const char_t* pwsz, length_t cch) {
		assert(pwsz != 0);

		for(length_t i = 0; i < cch; ++i) {
			if((pwsz[i] < 0x20) || (pwsz[i] == 0x7F))
				continue;
			return i;
		}
		return cch;
	}

	/**
	 *	𔻒肷
	 *	@param cp	ׂR[h|Cg
	 *	@return		ł true
	 *	@see		CLexer::IsNumerals
	 */
	inline bool CLexer::IsDigitCodePoint(Manah::Text::CodePoint cp) {
#if ASCENSION_UNICODE_VERSION != 0x0400
#error This code is based on old version of Unicode.
#endif
		return (cp >= L'0' && cp <= L'9') || Manah::Text::ToAsciiDigit(cp) != cp;
	}

	/**
	 *	ʎq̒Ԃ
	 *	@param pwsz	ׂ镶
	 *	@param cch	
	 *	@return		ʎq\AĂ钷BʎqłȂ0
	 *	@see		CLexer::IsIdentifierContinueChar, CLexer::IsIdentifierStartChar
	 */
	inline length_t CLexer::IsIdentifier(const char_t* pwsz, length_t cch) const {
		AssertValid();
		assert(pwsz != 0);

		using namespace Manah::Text;

		CodePoint	cp;
		for(length_t i = 0; i < cch; ++i) {
			if(IsUTF16HighSurrogate(pwsz[i])
					&& i < cch - 1
					&& IsUTF16LowSurrogate(pwsz[i + 1]))
				cp = DecodeUTF16SurrogatePairToCodePoint(pwsz + i, cch - i);
			else
				cp = pwsz[i];
			if((i == 0 && IsIdentifierStartCodePoint(cp))
					|| IsIdentifierContinueCodePoint(cp)) {
				if(cp >= 0x010000)
					++i;
				continue;
			}
			return i;
		}
		return cch;
	}

	/// L[[hő啶ʂ邩Ԃ
	inline bool CLexer::IsCaseSensitive() const {
		AssertValid();
		return m_bCaseSensitive;
	}

	/// ԂԂ
	inline bool CLexer::IsFreezed() const {
		AssertValid();
		return m_bFreezed;
	}

	/**
	 *	pň͂܂ꂽ̒Ԃ (pɓ)B
	 *	GXP[vɂ̓obNXbVgp
	 *	@param pwsz		ׂ镶
	 *	@param cch		
	 *	@param chOpen	Jp
	 *	@return			p̒BȂ0BĂȂ <var>cch</var> 𓯂lԂ
	 */
	inline length_t CLexer::IsQuotation(const char_t* pwsz, length_t cch, char_t chOpen) {
		assert(pwsz != 0);

		char_t	chClose;

#if ASCENSION_UNICODE_VERSION != 0x0400
#error This code is based on old version of Unicode.
#endif
		switch(chOpen) {
		case 0x0022:	chClose = 0x0022;	break;
		case 0x0027:	chClose = 0x0027;	break;
		case 0x00AB:	chClose = 0x00BB;	break;
		case 0x2018:	chClose = 0x2019;	break;
//		case 0x201A:	chClose = 0x????;	break;
		case 0x201C:	chClose = 0x201D;	break;
//		case 0x201E:	chClose = 0x????;	break;
//		case 0x201F:	chClose = 0x????;	break;
		case 0x2039:	chClose = 0x203A;	break;
		case 0x300C:	chClose = 0x300D;	break;
		case 0x300E:	chClose = 0x300F;	break;
//		case 0x301D:	chClose = 0x301E or 0x301F;	break;
		case 0xFE41:	chClose = 0xFE42;	break;
		case 0xFE43:	chClose = 0xFE44;	break;
		case 0xFF62:	chClose = 0xFF63;	break;
		default:		return 0;
		}

		if(*pwsz != chOpen)
			return 0;
		for(length_t i = 1; i < cch; ++i) {
			if(*(pwsz + i) == L'\\')	// ͖̕
				++i; 
			else if(*(pwsz + i) == chClose)
				return i + 1;
		}
		return cch;
	}

	/**
	 *	̒Ԃ
	 *	@param pwsz	ׂ镶
	 *	@param cch	
	 *	@return		p̒BȂ0
	 *	@see		CLexer::IsDigitCodePoint
	 */
	inline length_t CLexer::IsNumerals(const char_t* pwsz, length_t cch) {
		assert(pwsz != 0);

		using namespace Manah::Text;

		CodePoint	cp;
		for(length_t i = 0; i < cch; ++i) {
			if(IsUTF16HighSurrogate(pwsz[i])
					&& i < cch - 1
					&& IsUTF16LowSurrogate(pwsz[i + 1]))
				cp = DecodeUTF16SurrogatePairToCodePoint(pwsz + i, cch - i);
			else
				cp = pwsz[i];
			if(CLexer::IsDigitCodePoint(cp)) {
				if(cp >= 0x010000)
					++i;
				continue;
			}
			return i;
		}
		return cch;
	}

	/// g[NLԂ
	inline bool CLexer::IsTokenEnabled(TokenType type) const {
		AssertValid();
		return m_enabledTokenTypes[type];
	}

	/// Unicode At@xbgAt@xbgƂĎgp邩Ԃ
	inline bool CLexer::IsUnicodeAlphabetsEnabled() const {
		AssertValid();
		return m_bEnableUnicodeAlphabets;
	}

	/**
	 *	Unicode 䕶ǂԂ
	 *	@param pwsz	ׂ镶ւ̃|C^
	 *	@param cch	
	 *	@return		Unicode 䕶̏ꍇ true Ԃ
	 */
	inline bool CLexer::IsUnicodeControl(const char_t* pwsz, length_t cch) {
		assert(pwsz != 0);

		using namespace Manah::Text;
		using namespace Private;

		const CodePoint	cp = DecodeUTF16SurrogatePairToCodePoint(pwsz, cch);
		return std::binary_search(cc, cc + _countof(cc), cp)
			|| std::binary_search(cf, cf + _countof(cf), cp);
	}

	/// Unicode 󔒗ޕ󔒗ޕƂĎgp邩Ԃ
	inline bool CLexer::IsUnicodeWhiteSpacesEnabled() const {
		AssertValid();
		return m_bEnableUnicodeWhiteSpaces;
	}

	/**
	 *	󔒗ޕ̒Ԃ
	 *	@param pwsz			ׂ镶
	 *	@param cch			
	 *	@param bIncludeTab	^u󔒕Ƃ݂Ȃꍇ true
	 *	@return		󔒗ޕAĂ钷BzCgXy[XłȂ0
	 */
	inline length_t CLexer::IsWhiteSpace(const char_t* pwsz, length_t cch, bool bIncludeTab) const {
		AssertValid();
		assert(pwsz != 0);

		using Private::zs;

		if(!m_bEnableUnicodeWhiteSpaces) {	// Unicode 󔒗ޕFȂꍇ
			for(length_t i = 0; i < cch; ++i) {
				if(bIncludeTab && pwsz[i] == L'\t')
					continue;
				else if(pwsz[i] != L' ')
					return i;
			}
		} else {	// Unicode 󔒗ޕFꍇ
			for(length_t i = 0; i < cch; ++i) {
				if(bIncludeTab && pwsz[i] == L'\t')
					continue;
				if(!std::binary_search(zs, zs + _countof(zs), pwsz[i]))
					return i;
			}
		}
		return cch;
	}

	///	ύXCxgnhɒʒm
	inline void CLexer::NotifyChange() {
		AssertValid();
		if(!m_bFreezed && m_pEventListener != 0)
			m_pEventListener->OnLexerChanged();
	}

	/**
	 *	͂Ŏgl`ݒ肷
	 *	@param format	Vl`
	 */
	inline void CLexer::SetNumberFormat(NumberFormat format) throw(std::invalid_argument) {
		AssertValid();
		if(format >= NF_COUNT)
			throw std::invalid_argument("");
		ENABLE_SWITCH(m_numberFormat, format);
	}

	///	CLexer::Freeze ɂ铀ACxgnhɒʒm
	inline void CLexer::Unfreeze() {
		AssertValid();
		ENABLE_SWITCH(m_bFreezed, false);
	}

#undef ENABLE_SWITCH

} // namespace Ascension

#endif /* _LEXER_H_ */

/* [EOF] */