// KeyMacroPlayer.h
// (c) 2003-2004 exeal

#ifndef _KEY_MACRO_PLAYER_H_
#define _KEY_MACRO_PLAYER_H_

#include "../../Manah/Object.h"
#include <list>
#include <fstream>


namespace Ascension {

	class CEditView;
	enum CommandIdentifier;

	/// L[}N̏
	enum KeyMacroState {
		KMS_NONE,		///< 
		KMS_PLAYING,	///< Đ
		KMS_RECORDING,	///< L^
		KMS_PAUSING,	///< L^ꎞ~
	};

	/// L[}N̓e
	struct TKeymacroCommand {
		CommandIdentifier	id;		///< R}h
		ulong				nParam;	///< 
	};


	/// L[}N̎sȂ̂ő̑͂łȂƂ\O
	class EMacroIsAlreadyRunning : public std::logic_error {
		// RXgN^
	public:
		EMacroIsAlreadyRunning()
				: std::logic_error("This operation can not be achieved when the macro is running.") {
		}
	};


	/// L[}NǗNX
	class CKeyMacroPlayer : public Manah::CObject {
		// RXgN^
	private:
		CKeyMacroPlayer();
		NOCOPY(CKeyMacroPlayer);

		// \bh ()
	public:
		void					AddCommand(const TKeymacroCommand& command) throw(EMacroIsAlreadyRunning);
		void					CancelRecording();
		void					Clear() throw(EMacroIsAlreadyRunning);
		static CKeyMacroPlayer*	Create();
		bool					Load(const std::wstring& strPathName);
		void					Pause();
		void					Play(CEditView& view) throw(EMacroIsAlreadyRunning);
		bool					Save(const std::wstring& strPathName) const;
		void					StartRecording(CEditView& view) throw(EMacroIsAlreadyRunning);
		void					StopRecording();

		// \bh ()
	public:
		CEditView*				GetActiveView() const {
			return m_pActiveView;
		}
		KeyMacroState			GetState() const {
			return m_state;
		}

		// f[^o
	private:
		KeyMacroState				m_state;				// L[}N̏
		std::list<TKeymacroCommand>	m_commands;				// L^ĂR}h̃Xg
		std::list<TKeymacroCommand>	m_recordingCommands;	// L^̃R}h̃Xg
		CEditView*					m_pActiveView;			// L^AĐ̃r[
	};

} // namespace Ascension

#endif /* _KEY_MACRO_PLAYER_H_ */

/* [EOF] */