// KeyMacroPlayer.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "KeyMacroPlayer.h"
#include "EditView.h"

using namespace Ascension;
using namespace std;
using Manah::Windows::IO::CFile;


// CKeyMacroPlayer class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CKeyMacroPlayer::CKeyMacroPlayer() : m_state(KMS_NONE), m_pActiveView(0) {
}

/**
 *	L^̃}NɃR}hǉ
 *	@param command	R}h
 */
void CKeyMacroPlayer::AddCommand(const TKeymacroCommand& command) {
	AssertValid();

	if(m_state == KMS_RECORDING)
		m_recordingCommands.push_back(command);
	else
		throw EMacroIsAlreadyRunning();
}

///	L[}N̋L^𒆎~
void CKeyMacroPlayer::CancelRecording() {
	AssertValid();

	if(m_state == KMS_RECORDING || m_state == KMS_PAUSING) {
		m_recordingCommands.clear();
		StopRecording();
	}
}

///	L^Ă}N폜
void CKeyMacroPlayer::Clear() {
	AssertValid();

	if(m_state == KMS_NONE)
		m_commands.clear();
	else
		throw EMacroIsAlreadyRunning();
}

///	B̃CX^X擾
CKeyMacroPlayer* CKeyMacroPlayer::Create() {
	static CKeyMacroPlayer	singleton;
	return &singleton;
}

/**
 *	t@CR}hXgǂݍ
 *	@param strPathName	̓t@Cnh
 *	@return				
 */
bool CKeyMacroPlayer::Load(const wstring& strPathName) {
	AssertValid();

	CFile				inputFile;
	TKeymacroCommand	command;

	Clear();
	if(!inputFile.Open(strPathName.c_str(), CFile::modeRead, false))
		return false;
	while(inputFile.Read(&command.id, sizeof(command.id)) == sizeof(command.id)
			&& inputFile.Read(&command.nParam, sizeof(command.nParam)) == sizeof(command.nParam))
		m_commands.push_back(command);
	inputFile.Close();

	return true;
}

///	L^̈ꎞ~AĊJ
void CKeyMacroPlayer::Pause() {
	AssertValid();

	if(m_state == KMS_RECORDING)
		m_state = KMS_PAUSING;
	else if(m_state == KMS_PAUSING)
		m_state = KMS_RECORDING;
}

/**
 *	}N̍Đ
 *	@param view	Ώۃr[
 */
void CKeyMacroPlayer::Play(CEditView& view) {
	AssertValid();

	if(m_state == KMS_NONE) {
		m_state = KMS_PLAYING;
		m_pActiveView = &view;
		if(!view.GetDocument()->IsReadOnly()) {
			for(list<TKeymacroCommand>::const_iterator it = m_commands.begin(); it != m_commands.end(); ++it)
				view.ExecCommand(it->id, it->nParam);
		}
		m_state = KMS_NONE;
		m_pActiveView = 0;
	} else
		throw EMacroIsAlreadyRunning();
}

/**
 *	t@CɃR}hXg
 *	@param strPathName	o̓t@C
 *	@return				
 */
bool CKeyMacroPlayer::Save(const wstring& strPathName) const {
	AssertValid();

	CFile	outputFile;

	if(!outputFile.Open(strPathName.c_str(), CFile::modeWrite | CFile::modeCreate, false))
		return false;
	for(list<TKeymacroCommand>::const_iterator it = m_commands.begin(); it != m_commands.end(); ++it) {
		outputFile.Write(&it->id, sizeof(it->id));
		outputFile.Write(&it->nParam, sizeof(it->nParam));
	}
	outputFile.Close();

	return true;
}

/**
 *	}N̋L^Jn
 *	@param view	Ώۃr[
 */
void CKeyMacroPlayer::StartRecording(CEditView& view) {
	AssertValid();

	if(m_state == KMS_NONE) {
		m_state = KMS_RECORDING;
		m_pActiveView = &view;
	} else
		throw EMacroIsAlreadyRunning();
}

///	}N̋L^I
///	R}h1ǉɏIƋL^Ă̂͂̂܂܎c
void CKeyMacroPlayer::StopRecording() {
	AssertValid();

	if(m_state == KMS_RECORDING || m_state == KMS_PAUSING) {
		if(!m_recordingCommands.empty()) {
			m_commands = m_recordingCommands;
			m_recordingCommands.clear();
		}
		m_state = KMS_NONE;
		m_pActiveView = 0;
	}
}

/* [EOF] */