// Vietnamese.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "Encoder.h"
#include <map>

using namespace Ascension::Encodings;
using namespace std;


DEFINE_ENCODER_CLASS(CPEX_VIETNAMESE_TCVN, Vietnamese_Tcvn);
DEFINE_ENCODER_CLASS(CPEX_VIETNAMESE_VISCII, Vietnamese_Viscii);
DEFINE_ENCODER_CLASS(CPEX_VIETNAMESE_VPS, Vietnamese_Vps);

// ȉ̕ϊe[u Mozilla  Vietnamese Enabling Project ̎QƂ
// (http://www.vnet.org/vanlangsj/mozilla/)
namespace {
	const wchar_t	TCVNtoUCS[] = {
	/* 0x00 */	0x0000, 0x00DA, 0x1EE4, 0x0003, 0x1EEA, 0x1EEC, 0x1EEE, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x0010, 0x1EE8, 0x1EF0, 0x1EF2, 0x1EF6, 0x1EF8, 0x00DD, 0x1EF4,
				0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
	/* 0x20 */	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
				0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	/* 0x30 */	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
				0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	/* 0x40 */	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
				0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	/* 0x50 */	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
				0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
	/* 0x60 */	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
				0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	/* 0x70 */	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
				0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
	/* 0x80 */	0x00C0, 0x1EA2, 0x00C3, 0x00C1, 0x1EA0, 0x1EB6, 0x1EAC, 0x00C8,
				0x1EBA, 0x1EBC, 0x00C9, 0x1EB8, 0x1EC6, 0x00CC, 0x1EC8, 0x0128,
	/* 0x90 */	0x00CD, 0x1ECA, 0x00D2, 0x1ECE, 0x00D5, 0x00D3, 0x1ECC, 0x1ED8,
				0x1EDC, 0x1EDE, 0x1EE0, 0x1EDA, 0x1EE2, 0x00D9, 0x1EE6, 0x0168,
	/* 0xA0 */	0x00A0, 0x0102, 0x00C2, 0x00CA, 0x00D4, 0x01A0, 0x01AF, 0x0110,
				0x0103, 0x00E2, 0x00EA, 0x00F4, 0x01A1, 0x01B0, 0x0111, 0x1EB0,
	/* 0xB0 */	0x0300, 0x0309, 0x0303, 0x0301, 0x0323, 0x00E0, 0x1EA3, 0x00E3,
				0x00E1, 0x1EA1, 0x1EB2, 0x1EB1, 0x1EB3, 0x1EB5, 0x1EAF, 0x1EB4,
	/* 0xC0 */	0x1EAE, 0x1EA6, 0x1EA8, 0x1EAA, 0x1EA4, 0x1EC0, 0x1EB7, 0x1EA7,
				0x1EA9, 0x1EAB, 0x1EA5, 0x1EAD, 0x00E8, 0x1EC2, 0x1EBB, 0x1EBD,
	/* 0xD0 */	0x00E9, 0x1EB9, 0x1EC1, 0x1EC3, 0x1EC5, 0x1EBF, 0x1EC7, 0x00EC,
				0x1EC9, 0x1EC4, 0x1EBE, 0x1ED2, 0x0129, 0x00ED, 0x1ECB, 0x00F2,
	/* 0xE0 */	0x1ED4, 0x1ECF, 0x00F5, 0x00F3, 0x1ECD, 0x1ED3, 0x1ED5, 0x1ED7,
				0x1ED1, 0x1ED9, 0x1EDD, 0x1EDF, 0x1EE1, 0x1EDB, 0x1EE3, 0x00F9,
	/* 0xF0 */	0x1ED6, 0x1EE7, 0x0169, 0x00FA, 0x1EE5, 0x1EEB, 0x1EED, 0x1EEF,
				0x1EE9, 0x1EF1, 0x1EF3, 0x1EF7, 0x1EF9, 0x00FD, 0x1EF5, 0x1ED0
	};
	const wchar_t	VISCIItoUCS[] = {
	/* 0x00 */	0x0000, 0x0001, 0x1EB2, 0x0003, 0x0004, 0x1EB4, 0x1EAA, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x0010, 0x0011, 0x0012, 0x0013, 0x1EF6, 0x0015, 0x0016, 0x0017,
				0x0018, 0x1EF8, 0x001A, 0x001B, 0x001C, 0x001D, 0x1EF4, 0x001F,
	/* 0x20 */	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
				0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	/* 0x30 */	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
				0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	/* 0x40 */	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
				0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	/* 0x50 */	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
				0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
	/* 0x60 */	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
				0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	/* 0x70 */	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
				0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
	/* 0x80 */	0x1EA0, 0x1EAE, 0x1EB0, 0x1EB6, 0x1EA4, 0x1EA6, 0x1EA8, 0x1EAC,
				0x1EBC, 0x1EB8, 0x1EBE, 0x1EC0, 0x1EC2, 0x1EC4, 0x1EC6, 0x1ED0,
	/* 0x90 */	0x1ED2, 0x1ED4, 0x1ED6, 0x1ED8, 0x1EE2, 0x1EDA, 0x1EDC, 0x1EDE,
				0x1ECA, 0x1ECE, 0x1ECC, 0x1EC8, 0x1EE6, 0x0168, 0x1EE4, 0x1EF2,
	/* 0xA0 */	0x00D5, 0x1EAF, 0x1EB1, 0x1EB7, 0x1EA5, 0x1EA7, 0x1EA9, 0x1EAD,
				0x1EBD, 0x1EB9, 0x1EBF, 0x1EC1, 0x1EC3, 0x1EC5, 0x1EC7, 0x1ED1,
	/* 0xB0 */	0x1ED3, 0x1ED5, 0x1ED7, 0x1EE0, 0x01A0, 0x1ED9, 0x1EDD, 0x1EDF,
				0x1ECB, 0x1EF0, 0x1EE8, 0x1EEA, 0x1EEC, 0x01A1, 0x1EDB, 0x01AF,
	/* 0xC0 */	0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x1EA2, 0x0102, 0x1EB3, 0x1EB5,
				0x00C8, 0x00C9, 0x00CA, 0x1EBA, 0x00CC, 0x00CD, 0x0128, 0x1EF3,
	/* 0xD0 */	0x0110, 0x1EE9, 0x00D2, 0x00D3, 0x00D4, 0x1EA1, 0x1EF7, 0x1EEB,
				0x1EED, 0x00D9, 0x00DA, 0x1EF9, 0x1EF5, 0x00DD, 0x1EE1, 0x01B0,
	/* 0xE0 */	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x1EA3, 0x0103, 0x1EEF, 0x1EAB,
				0x00E8, 0x00E9, 0x00EA, 0x1EBB, 0x00EC, 0x00ED, 0x0129, 0x1EC9,
	/* 0xF0 */	0x0111, 0x1EF1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x1ECF, 0x1ECD,
				0x1EE5, 0x00F9, 0x00FA, 0x0169, 0x1EE7, 0x00FD, 0x1EE3, 0x1EEE
	};
	const wchar_t	VPStoUCS[] = {
	/* 0x00 */	0x0000, 0x0001, 0x1EA0, 0x1EAC, 0x1EB6, 0x1EB8, 0x1EC6, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x1ECA, 0x1ECC, 0x1ED8, 0x1EE2, 0x1EE4, 0x1EF0, 0x0016, 0x0017,
				0x0018, 0x1EF4, 0x001A, 0x001B, 0x1EAA, 0x1EEE, 0x001E, 0x001F,
	/* 0x20 */	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
				0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	/* 0x30 */	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
				0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	/* 0x40 */	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
				0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	/* 0x50 */	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
				0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
	/* 0x60 */	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
				0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	/* 0x70 */	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
				0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
	/* 0x80 */	0x00C0, 0x1EA2, 0x00C3, 0x1EA4, 0x1EA6, 0x1EA8, 0x1ECD, 0x1ED7,
				0x0102, 0x1EBF, 0x1EC1, 0x1EC3, 0x1EC7, 0x1EAE, 0x1EB0, 0x1EB2,
	/* 0x90 */	0x1EBE, 0x2018, 0x2019, 0x1EC0, 0x1EC2, 0x1EC4, 0x1ED0, 0x1ED2,
				0x1ED4, 0x1ED6, 0x00FD, 0x1EF7, 0x1EF5, 0x1EDA, 0x1EDC, 0x1EDE,
	/* 0xA0 */	0x00A0, 0x1EAF, 0x1EB1, 0x1EB3, 0x1EB5, 0x1EB7, 0x1EE0, 0x1EDB,
				0x00D9, 0x1EDD, 0x1EDF, 0x1EE1, 0x0168, 0x1EE8, 0x1EE3, 0x1EEA,
	/* 0xB0 */	0x1ED5, 0x1EEC, 0x1EF2, 0x1EF8, 0x00CD, 0x00CC, 0x1ED9, 0x1EC8,
				0x0128, 0x00D3, 0x1EED, 0x1EEF, 0x00D2, 0x1ECE, 0x00D5, 0x1EF1,
	/* 0xC0 */	0x1EA7, 0x00C1, 0x00C2, 0x1EA5, 0x1EA9, 0x1EAB, 0x1EAD, 0x0111,
				0x1EBB, 0x00C9, 0x00CA, 0x1EB9, 0x1EC9, 0x1EC5, 0x1ECB, 0x1EF9,
	/* 0xD0 */	0x01AF, 0x1EE6, 0x1ED3, 0x1ED1, 0x00D4, 0x1ECF, 0x01A1, 0x00C8,
				0x1EEB, 0x1EE9, 0x00DA, 0x0169, 0x01B0, 0x00DD, 0x1EBA, 0x00DF,
	/* 0xE0 */	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x1EA3, 0x1EA1, 0x0103, 0x00E7,
				0x00E8, 0x00E9, 0x00EA, 0x1EBD, 0x00EC, 0x00ED, 0x00EE, 0x0129,
	/* 0xF0 */	0x1EB4, 0x0110, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x01A0,
				0x1EE5, 0x00F9, 0x00FA, 0x1EE7, 0x00FC, 0x1EF6, 0x1EBC, 0x1EF3
	};
} // namespace `anonymous'


#define IMPLEMENT_V2U(encoding)							\
	CTU_CHECKARGS();									\
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i)	\
		pwszDest[i] = encoding##toUCS[pszSrc[i]];		\
	return min(cchSrc, cchDest)

// 蔲
#define IMPLEMENT_U2V(encoding)														\
	CFU_CHECKARGS();																\
	static map<wchar_t, char>	mb2ucs;												\
	if(mb2ucs.empty()) {															\
		for(size_t i = 0; i < _countof(encoding##toUCS); ++i)						\
			mb2ucs.insert(make_pair(encoding##toUCS[i], i));						\
	}																				\
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {								\
		const map<wchar_t, char>::const_iterator	it = mb2ucs.find(pwszSrc[i]);	\
		if(it != mb2ucs.end())														\
			pszDest[i] = it->second;												\
		else if(pCallBack == 0 || (*pCallBack)()) {									\
			pszDest[i] = __DEFAULT_CHAR;											\
			pCallBack = 0;															\
		} else																		\
			return 0;																\
	}																				\
	return min(cchSrc, cchDest)


// xgi (TCVN) ////////////////////////////////////////////////////////

CEncoder_Vietnamese_Tcvn::CEncoder_Vietnamese_Tcvn() {
}

size_t CEncoder_Vietnamese_Tcvn::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_U2V(TCVN);
}

size_t CEncoder_Vietnamese_Tcvn::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_V2U(TCVN);
}

uchar CEncoder_Vietnamese_Tcvn::GetMaxCharacterLength() const {
	return 1;
}

// xgi (VISCII) //////////////////////////////////////////////////////

CEncoder_Vietnamese_Viscii::CEncoder_Vietnamese_Viscii() {
}

size_t CEncoder_Vietnamese_Viscii::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_U2V(VISCII);
}

size_t CEncoder_Vietnamese_Viscii::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_V2U(VISCII);
}

uchar CEncoder_Vietnamese_Viscii::GetMaxCharacterLength() const {
	return 1;
}


// xgi (VPS) /////////////////////////////////////////////////////////

CEncoder_Vietnamese_Vps::CEncoder_Vietnamese_Vps() {
}

size_t CEncoder_Vietnamese_Vps::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_U2V(VPS);
}

size_t CEncoder_Vietnamese_Vps::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_V2U(VPS);
}

uchar CEncoder_Vietnamese_Vps::GetMaxCharacterLength() const {
	return 1;
}


#undef IMPLEMENT_U2V
#undef IMPLEMENT_V2U

/* [EOF] */