// Uncategorized.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


DEFINE_ENCODER_CLASS(CPEX_UNCATEGORIZED_BINARY, Uncategorized_Binary);


// Binary ///////////////////////////////////////////////////////////////////

CEncoder_Uncategorized_Binary::CEncoder_Uncategorized_Binary() {
}

size_t CEncoder_Uncategorized_Binary::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	size_t	iSrc = 0, iDest = 0;

	for(; iSrc < cchSrc && iDest < cchDest; ++iSrc, ++iDest) {
		if(pwszSrc[iSrc] > 0x00FF) {
			if(pCallBack == 0 || (*pCallBack)()) {
				pszDest[iDest] = __DEFAULT_CHAR;
				pCallBack = 0;
			} else
				return 0;
		}
		pszDest[iDest] = static_cast<uchar>(pwszSrc[iSrc]);
	}

	return iDest;
}

size_t CEncoder_Uncategorized_Binary::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	size_t	iSrc = 0, iDest = 0;

	for(; iSrc < cchSrc && iDest < cchDest; ++iSrc, ++iDest)
		pwszDest[iDest] = pszSrc[iSrc];
	return iDest;
}

uchar CEncoder_Uncategorized_Binary::GetMaxCharacterLength() const {
	return 1;
}

/* [EOF] */