// Lao.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


DEFINE_ENCODER_CLASS(CPEX_LAO_MULELAO, Lao_Mulelao);
DEFINE_ENCODER_CLASS(CPEX_LAO_CP1133, Lao_Cp1133);

namespace {
	const wchar_t	MULELAOtoUCS[] = {
	/* 0xA0 */	0x00A0, 0x0E81, 0x0E82, __RPCH, 0x0E84, __RPCH, __RPCH, 0x0E87,
				0x0E88, __RPCH, 0x0E8A, __RPCH, __RPCH, 0x0E8D, __RPCH, __RPCH,
	/* 0xB0 */	__RPCH, __RPCH, __RPCH, __RPCH, 0x0E94, 0x0E95, 0x0E96, 0x0E97,
				__RPCH, 0x0E99, 0x0E9A, 0x0E9B, 0x0E9C, 0x0E9D, 0x0E9E, 0x0E9F,
	/* 0xC0 */	__RPCH, 0x0EA1, 0x0EA2, 0x0EA3, __RPCH, 0x0EA5, __RPCH, 0x0EA7,
				__RPCH, __RPCH, 0x0EAA, 0x0EAB, __RPCH, 0x0EAD, 0x0EAE, 0x0EAF,
	/* 0xD0 */	0x0EB0, 0x0EB1, 0x0EB2, 0x0EB3, 0x0EB4, 0x0EB5, 0x0EB6, 0x0EB7,
				0x0EB8, 0x0EB9, __RPCH, 0x0EBB, 0x0EBC, 0x0EBD, __RPCH, __RPCH,
	/* 0xE0 */	0x0EC0, 0x0EC1, 0x0EC2, 0x0EC3, 0x0EC4, __RPCH, 0x0EC6, __RPCH,
				0x0EC8, 0x0EC9, 0x0ECA, 0x0ECB, 0x0ECC, 0x0ECD, __RPCH, __RPCH,
	/* 0xF0 */	0x0ED0, 0x0ED1, 0x0ED2, 0x0ED3, 0x0ED4, 0x0ED5, 0x0ED6, 0x0ED7,
				0x0ED8, 0x0ED9, __RPCH, __RPCH, 0x0EDC, 0x0EDD, __RPCH, __RPCH,
	};
	const uchar	UCStoMULELAO[] = {
	/* 0x80 */	0x00, 0xA1, 0xA2, 0x00, 0xA4, 0x00, 0x00, 0xA7,
				0xA8, 0x00, 0xAA, 0x00, 0x00, 0xAD, 0x00, 0x00,
	/* 0x90 */	0x00, 0x00, 0x00, 0x00, 0xB4, 0xB5, 0xB6, 0xB7,
				0x00, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
	/* 0xA0 */	0x00, 0xC1, 0xC2, 0xC3, 0x00, 0xC5, 0x00, 0xC7,
				0x00, 0x00, 0xCA, 0xCB, 0x00, 0xCD, 0xCE, 0xCF,
	/* 0xB0 */	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
				0xD8, 0xD9, 0x00, 0xDB, 0xDC, 0xDD, 0x00, 0x00,
	/* 0xC0 */	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0x00, 0xE6, 0x00,
				0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0x00, 0x00,
	/* 0xD0 */	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
				0xF8, 0xF9, 0x00, 0x00, 0xFC, 0xFD, 0x00, 0x00,
	};
	const wchar_t	CP1133toUCS[] = {
	/* 0xA0 */	0x00A0, 0x0E81, 0x0E82, 0x0E84, 0x0E87, 0x0E88, 0x0EAA, 0x0E8A,
				0x0E8D, 0x0E94, 0x0E95, 0x0E96, 0x0E97, 0x0E99, 0x0E9A, 0x0E9B,
	/* 0xB0 */	0x0E9C, 0x0E9D, 0x0E9E, 0x0E9F, 0x0EA1, 0x0EA2, 0x0EA3, 0x0EA5,
				0x0EA7, 0x0EAB, 0x0EAD, 0x0EAE, 0xFFFD, 0xFFFD, 0xFFFD, 0x0EAF,
	/* 0xC0 */	0x0EB0, 0x0EB2, 0x0EB3, 0x0EB4, 0x0EB5, 0x0EB6, 0x0EB7, 0x0EB8,
				0x0EB9, 0x0EBC, 0x0EB1, 0x0EBB, 0x0EBD, 0xFFFD, 0xFFFD, 0xFFFD,
	/* 0xD0 */	0x0EC0, 0x0EC1, 0x0EC2, 0x0EC3, 0x0EC4, 0x0EC8, 0x0EC9, 0x0ECA,
				0x0ECB, 0x0ECC, 0x0ECD, 0x0EC6, 0xFFFD, 0x0EDC, 0x0EDD, 0x20AD,
	/* 0xE0 */	__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
				__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
	/* 0xF0 */  0x0ED0, 0x0ED1, 0x0ED2, 0x0ED3, 0x0ED4, 0x0ED5, 0x0ED6, 0x0ED7,
				0x0ED8, 0x0ED9, 0xFFFD, 0xFFFD, 0x00A2, 0x00AC, 0x00A6, 0xFFFD,
	};
	const uchar		UCStoCP1133_1[] = {
	/* 0xA0 */	0xA0, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFE, 0x00,
				0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00,
	};
	const uchar		UCStoCP1133_2[] = {
	/* 0x80 */	0x00, 0xA1, 0xA2, 0x00, 0xA3, 0x00, 0x00, 0xA4,
				0xA5, 0x00, 0xA7, 0x00, 0x00, 0xA8, 0x00, 0x00,
	/* 0x90 */	0x00, 0x00, 0x00, 0x00, 0xA9, 0xAA, 0xAB, 0xAC,
				0x00, 0xAD, 0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3,
	/* 0xA0 */	0x00, 0xB4, 0xB5, 0xB6, 0x00, 0xB7, 0x00, 0xB8,
				0x00, 0x00, 0xA6, 0xB9, 0x00, 0xBA, 0xBB, 0xBF,
	/* 0xB0 */	0xC0, 0xCA, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6,
				0xC7, 0xC8, 0x00, 0xCB, 0xC9, 0xCC, 0x00, 0x00,
	/* 0xC0 */	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0x00, 0xDB, 0x00,
				0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0x00, 0x00,
	/* 0xD0 */	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
				0xF8, 0xF9, 0x00, 0x00, 0xDD, 0xDE, 0x00, 0x00,
	};
}


// I (MuleLao) /////////////////////////////////////////////////////////

CEncoder_Lao_Mulelao::CEncoder_Lao_Mulelao() {
}

size_t CEncoder_Lao_Mulelao::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pwszSrc[i] <= 0x00A0)
			pszDest[i] = static_cast<uchar>(pwszSrc[i]);
		else {
			pszDest[i] = (pwszSrc[i] >= 0x0E80 && pwszSrc[i] < 0x0EE0) ? UCStoMULELAO[pwszSrc[i] - 0x0E80] : 0x00;
			if(pszDest[i] == 0x00) {
				if(pCallBack == 0 || (*pCallBack)()) {
					pszDest[i] = __DEFAULT_CHAR;
					pCallBack = 0;
				} else
					return 0;
			}
		}
	}
	return min(cchSrc, cchDest);
}

size_t CEncoder_Lao_Mulelao::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pszSrc[i] < 0xA0)
			pwszDest[i] = pszSrc[i];
		else {
			pwszDest[i] = MULELAOtoUCS[pszSrc[i] - 0xA0];
			if(pwszDest[i] == __REPLACEMENT_CHARACTER) {
				if(pCallBack == 0 || (*pCallBack)()) {
					pwszDest[i] = __DEFAULT_CHAR;
					pCallBack = 0;
				} else
					return 0;
			}
		}
	}
	return min(cchSrc, cchDest);
}

uchar CEncoder_Lao_Mulelao::GetMaxCharacterLength() const {
	return 1;
}


// I (ibm-1133) ////////////////////////////////////////////////////////

CEncoder_Lao_Cp1133::CEncoder_Lao_Cp1133() {
}

size_t CEncoder_Lao_Cp1133::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pwszSrc[i] < 0x00A0)
			pszDest[i] = static_cast<uchar>(pwszSrc[i]);
		else {
			if(pwszSrc[i] < 0x00B0)
				pszDest[i] = UCStoCP1133_1[pwszSrc[i] - 0x00A0];
			else if(pwszSrc[i] >= 0x0E80 && pwszSrc[i] < 0x0EE0)
				pszDest[i] = UCStoCP1133_2[pwszSrc[i] - 0x0E80];
			else if(pwszSrc[i] == 0x20AD)
				pszDest[i] = static_cast<uchar>(0xDF);
			else
				pszDest[i] = 0x00;
			if(pszDest[i] == 0x00) {
				if(pCallBack == 0 || (*pCallBack)()) {
					pszDest[i] = __DEFAULT_CHAR;
					pCallBack = 0;
				} else
					return 0;
			}
		}
	}
	return min(cchSrc, cchDest);
}

size_t CEncoder_Lao_Cp1133::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pszSrc[i] < 0xA0)
			pwszDest[i] = pszSrc[i];
		else {
			pwszDest[i] = CP1133toUCS[pszSrc[i] - 0xA0];
			if(pwszDest[i] == __REPLACEMENT_CHARACTER) {
				if(pCallBack == 0 || (*pCallBack)()) {
					pwszDest[i] = __DEFAULT_CHAR;
					pCallBack = 0;
				} else
					return 0;
			}
		}
	}
	return min(cchSrc, cchDest);
}

uchar CEncoder_Lao_Cp1133::GetMaxCharacterLength() const {
	return 1;
}

/* [EOF] */