#!/usr/local/bin/perl

# make_table.pl
# (c) 2004 exeal
# JIS X0208 or X0212 <-> UCS ̕ϊ\쐬B
# o͕͐WóB
# A2U ̂Ƃ 0x2100  0x7EFF ܂ło͂B

use strict;
use integer;

sub showUsageAndExit($) {
	print(shift() . "\nusage: make_table.pl <table-file-name> <a2u|u2a> [1|2]\n");
	exit();
}

showUsageAndExit('bad parameter number.') if($#ARGV != 1 and $#ARGV != 2);
showUsageAndExit('bad parameter ' . $ARGV[1]) if($ARGV[1] ne 'a2u' and $ARGV[1] ne 'u2a');
showUsageAndExit('bad parameter ' . $ARGV[2]) if($#ARGV == 2 and $ARGV[2] ne '1' and $ARGV[2] ne '2');

my $tableFile = $ARGV[0];
my $jisToUcs = $ARGV[1] eq 'a2u';
my $targetPlane = ($ARGV[2] ne '') ? ord($ARGV[2]) - ord('0') : 0;

open(FH, $tableFile) or die('can not open table file.\n');

my @table;
my $line;
while($line = <FH>) {
	next if(length($line) == 0 or substr($line, 0, 1) eq '#');
	if($line =~ m/^(\d\-)?0x([A-F\d]+)\t[0U][x\+]([A-F\d]+)(\+[A-F\d]+)?\t\#\s(.+)$/) {
		my $plane = ($1 ne '') ? ord($1) - ord('0') : 0;
		next if($plane != $targetPlane);
		my $jis = hex($2);
		my $ucs = hex($3);
		$ucs = ($ucs << 16) | hex(substr($4, 1, 4)) if($4 ne '');
		$ucs = hex($1) if($5 =~ m/Fullwidth:\sU\+([\w\d]+)$/);
		$table[$jisToUcs ? $jis : $ucs] = $jisToUcs ? $ucs : $jis;
	}
}
close(FH);

my $i;
my $start = $jisToUcs ? 0x2100 : 0x0000;
my $end = $jisToUcs ? 0x7F00 : 0x10000;
for($i = $start; $i < $end; ++$i) {
	print(defined($table[$i]) ? sprintf('0x%04X', $table[$i]) : 0);
	print(($i % 0x10 == 0x0F) ? ",\n" : ',')
}

__END__