#!/usr/local/bin/perl

# make_table.pl
# (c) 2004 exeal
# ISO-8859-XX <-> UCS ̕ϊ\쐬B
# ISO-8859-XX  [0x00, 0xA1) ͈̔͂͏o͂Ȃ (UCS ƓlȂ)B
# o͕͐WóB

use strict;
use integer;

sub showUsageAndExit($) {
	print(shift() . "\nusage: make_table.pl <table-file-name> <a2u|u2a>\n");
	exit();
}

showUsageAndExit('bad parameter number.') if($#ARGV != 1);


open(FH, $ARGV[0]) or die('can not open table file.\n');

if($ARGV[1] eq 'a2u') {
	my $line;
	my $lastNative = -1;
	while($line = <FH>) {
		if($line =~ m/^(0x[A-F\d]{2})\t(0x[A-F\d]{4})/) {
			my $native = hex($1);
			if($native > 0xA0) {
				my $ucs = $2;
				while(++$lastNative < $native) {
					print('-1,');
					print("\n") if($lastNative % 0x10 == 0x0F);
				}
				print("$ucs,");
				print("\n") if($native % 0x10 == 0x0F);
			} else {
				++$lastNative;
			}
		}
	}
} elsif($ARGV[1] eq 'u2a') {
	my $line;
	my @codes;
	my $maxCodePoint = 0;
	while($line = <FH>) {
		if($line =~ m/^(0x[A-F\d]{2})\t(0x[A-F\d]{4})/) {
			my $ucs = hex($2);
			$codes[$ucs] = hex($1);
			$maxCodePoint = $ucs if($ucs > $maxCodePoint);
		}
	}
	my $i;
	for($i = 0xA1; $i <= $maxCodePoint; ++$i) {
		print(defined($codes[$i]) ? sprintf('0x%02X,', $codes[$i]) : '-1,');
		print("\n") if($i % 0x10 == 0x0F);
	}
} else {
	showUsageAndExit("unknown option: $ARGV[1].");
}

close(FH);


__END__