// Iso8859.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


DEFINE_ENCODER_CLASS(CPEX_ISO8859_1, Iso8859_1);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_2, Iso8859_2);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_3, Iso8859_3);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_4, Iso8859_4);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_5, Iso8859_5);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_6, Iso8859_6);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_7, Iso8859_7);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_8, Iso8859_8);
DEFINE_ENCODER_CLASS(CPEX_ISO8859_9, Iso8859_9);
//DEFINE_ENCODER_CLASS(CPEX_ISO8859_10, Iso8859_10);
// DEFINE_ENCODER_CLASS(CPEX_ISO8859_11, Iso8859_11);	// Thai.cpp Ŏ
//DEFINE_ENCODER_CLASS(CPEX_ISO8859_13, Iso8859_13);
//DEFINE_ENCODER_CLASS(CPEX_ISO8859_14, Iso8859_14);
//DEFINE_ENCODER_CLASS(CPEX_ISO8859_15, Iso8859_15);
//DEFINE_ENCODER_CLASS(CPEX_ISO8859_16, Iso8859_16);


#define IMPLEMENT_ISO8859_TO_UNICODE(number)								\
	CEncoder_Iso8859_##number::CEncoder_Iso8859_##number() {				\
	}																		\
	size_t CEncoder_Iso8859_##number::ConvertToUnicode(CTU_ARGLIST) {		\
		CTU_CHECKARGS();													\
		const size_t	cch = min(cchSrc, cchDest);							\
		for(size_t i = 0; i < cch; ++i) {									\
			if(pszSrc[i] < 0xA1)											\
				pwszDest[i] = pszSrc[i];									\
			else if(pszSrc[i] - 0xA1 < _countof(arrISO8859_A2U_##number)	\
					&& arrISO8859_A2U_##number[pszSrc[i] - 0xA1] != -1)		\
				pwszDest[i] = arrISO8859_A2U_##number[pszSrc[i] - 0xA1];	\
			else															\
				pwszDest[i] = pszSrc[i];									\
		}																	\
		return cch;															\
	}																		\
	uchar CEncoder_Iso8859_##number::GetMaxCharacterLength() const {		\
		return 1;															\
	}

#define IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(number)						\
	size_t CEncoder_Iso8859_##number::ConvertFromUnicode(CFU_ARGLIST) {	\
		CFU_CHECKARGS();												\
		const size_t	cch = min(cchSrc, cchDest);						\
		for(size_t i = 0; i < cch; ++i) {								\
			if(pwszSrc[i] < 0x00A1)										\
				pszDest[i] = static_cast<char>(pwszSrc[i]);				\

#define IMPLEMENT_UNICODE_TO_ISO8859_END()				\
			else {										\
				if(pCallBack == 0 || (*pCallBack)()) {	\
					pszDest[i] = __DEFAULT_CHAR;		\
					pCallBack = 0;						\
				} else									\
					return 0;							\
			}											\
		}												\
		return cch;										\
	}

#define MAP_CHAR_UCS_TO_ISO8859(ucs, native)	\
	else if(pwszSrc[i] == ucs)	pszDest[i] = static_cast<uchar>(native);

#define MAP_RANGE_UCS_TO_ISO8859(ucsLower, ucsUpper, diff)		\
	else if(pwszSrc[i] >= ucsLower && pwszSrc[i] <= ucsUpper)	\
		pszDest[i] = static_cast<char>(pwszSrc[i] - diff);

#define IMPLEMENT_UNICODE_TO_LATINBASE_ISO8859_(number)						\
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(number)								\
			else if(pwszSrc[i] - 0xA1 < _countof(arrISO8859_U2A_##number)	\
					&& arrISO8859_U2A_##number[pwszSrc[i] - 0xA1] != -1)	\
				pszDest[i] = arrISO8859_U2A_##number[pwszSrc[i] - 0xA1];	\
	IMPLEMENT_UNICODE_TO_ISO8859_END()

#define IMPLEMENT_LATINBASE_ISO8859_(number)		\
	IMPLEMENT_ISO8859_TO_UNICODE(number)			\
	IMPLEMENT_UNICODE_TO_LATINBASE_ISO8859_(number)


namespace {
	const wchar_t	arrISO8859_A2U_2[] = {
		#include "Iso8859_utils\ISO8859-2_A2U"
	};
	const uchar	arrISO8859_U2A_2[] = {
		#include "Iso8859_utils\ISO8859-2_U2A"
	};
	const wchar_t	arrISO8859_A2U_3[] = {
		#include "Iso8859_utils\ISO8859-3_A2U"
	};
	const uchar	arrISO8859_U2A_3[] = {
		#include "Iso8859_utils\ISO8859-3_U2A"
	};
	const wchar_t	arrISO8859_A2U_4[] = {
		#include "Iso8859_utils\ISO8859-4_A2U"
	};
	const uchar	arrISO8859_U2A_4[] = {
		#include "Iso8859_utils\ISO8859-4_U2A"
	};
	const wchar_t	arrISO8859_A2U_5[] = {
		#include "Iso8859_utils\ISO8859-5_A2U"
	};
	const wchar_t	arrISO8859_A2U_6[] = {
		#include "Iso8859_utils\ISO8859-6_A2U"
	};
	const wchar_t	arrISO8859_A2U_7[] = {
		#include "Iso8859_utils\ISO8859-7_A2U"
	};
	const wchar_t	arrISO8859_A2U_8[] = {
		#include "Iso8859_utils\ISO8859-8_A2U"
	};
	const wchar_t	arrISO8859_A2U_9[] = {
		#include "Iso8859_utils\ISO8859-9_A2U"
	};
	const uchar	arrISO8859_U2A_9[] = {
		#include "Iso8859_utils\ISO8859-9_U2A"
	};
	const wchar_t	arrISO8859_A2U_10[] = {
		#include "Iso8859_utils\ISO8859-10_A2U"
	};
	const wchar_t	arrISO8859_A2U_13[] = {
		#include "Iso8859_utils\ISO8859-13_A2U"
	};
	const wchar_t	arrISO8859_A2U_14[] = {
		#include "Iso8859_utils\ISO8859-14_A2U"
	};
	const wchar_t	arrISO8859_A2U_15[] = {
		#include "Iso8859_utils\ISO8859-15_A2U"
	};
	const wchar_t	arrISO8859_A2U_16[] = {
		#include "Iso8859_utils\ISO8859-16_A2U"
	};
} // namespace `anonymous'


// [bp (ISO-8859-1) //////////////////////////////////////////////////////

CEncoder_Iso8859_1::CEncoder_Iso8859_1() {
}

size_t CEncoder_Iso8859_1::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pwszSrc[i] > 0x00FF) {
			if(pCallBack == 0 || (*pCallBack)()) {
				pszDest[i] = __DEFAULT_CHAR;
				pCallBack = 0;
			} else
				return 0;
		} else
			pszDest[i] = static_cast<char>(pwszSrc[i]);
	}
	return cch;
}

size_t CEncoder_Iso8859_1::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i)
		pwszDest[i] = pszSrc[i];
	return cch;
}

uchar CEncoder_Iso8859_1::GetMaxCharacterLength() const {
	return 1;
}


// [bp (ISO-8859-2) //////////////////////////////////////////////

IMPLEMENT_LATINBASE_ISO8859_(2)


// 새[bp (ISO-8859-3) ////////////////////////////////////////////////

IMPLEMENT_LATINBASE_ISO8859_(3)


// og (ISO-8859-4) //////////////////////////////////////////////////

IMPLEMENT_LATINBASE_ISO8859_(4)


// L (ISO-8859-5) //////////////////////////////////////////////////

IMPLEMENT_ISO8859_TO_UNICODE(5)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(5)
	MAP_CHAR_UCS_TO_ISO8859(0x00AD, 0xAD)	// Soft Hyphen
	MAP_CHAR_UCS_TO_ISO8859(0x2116, 0xF0)	// Numero Sign
	MAP_CHAR_UCS_TO_ISO8859(0x00A7, 0xFD)	// Section Sign
	MAP_RANGE_UCS_TO_ISO8859(0x0401, 0x045F, 0x0360)
IMPLEMENT_UNICODE_TO_ISO8859_END()


// ArA (ISO-8859-6) //////////////////////////////////////////////////

IMPLEMENT_ISO8859_TO_UNICODE(6)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(6)
	MAP_CHAR_UCS_TO_ISO8859(0x060C, 0xAC)	// Arabic Comma
	MAP_CHAR_UCS_TO_ISO8859(0x00AD, 0xAD)	// Soft Hyphen
	MAP_CHAR_UCS_TO_ISO8859(0x061B, 0xBB)	// Arabic Semicolon
	MAP_CHAR_UCS_TO_ISO8859(0x061F, 0xBF)	// Arabic Question Mark
	MAP_RANGE_UCS_TO_ISO8859(0x0621, 0x063A, 0x0560)
	MAP_RANGE_UCS_TO_ISO8859(0x0640, 0x0652, 0x0560)
IMPLEMENT_UNICODE_TO_ISO8859_END()


// MV (ISO-8859-7) //////////////////////////////////////////////////

IMPLEMENT_ISO8859_TO_UNICODE(7)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(7)
	MAP_CHAR_UCS_TO_ISO8859(0x2018, 0xA1)	// Left Single Quotation Mark
	MAP_CHAR_UCS_TO_ISO8859(0x2019, 0xA2)	// Right Single Quotation Mark
	MAP_CHAR_UCS_TO_ISO8859(0x00A3, 0xA3)	// Pound Sign
	MAP_CHAR_UCS_TO_ISO8859(0x20AC, 0xA4)	// Euro Sign
	MAP_CHAR_UCS_TO_ISO8859(0x20AF, 0xA5)	// Drachma Sign
	MAP_CHAR_UCS_TO_ISO8859(0x037A, 0xAA)	// Greek Ypogegrammeni
	MAP_CHAR_UCS_TO_ISO8859(0x2015, 0xAF)	// Horizontal Bar
	MAP_RANGE_UCS_TO_ISO8859(0x00A6, 0x00B3, 0x0000)
	MAP_CHAR_UCS_TO_ISO8859(0x00B7, 0xB7)	// Middle Dot
	MAP_CHAR_UCS_TO_ISO8859(0x00BB, 0xBB)	// Right-Pointing Double Angle Quotation Mark
	MAP_CHAR_UCS_TO_ISO8859(0x00BD, 0xBD)	// Valgar Fraction One Half
	MAP_RANGE_UCS_TO_ISO8859(0x0384, 0x03CE, 0x02D0)
IMPLEMENT_UNICODE_TO_ISO8859_END()


// wuC (ISO-8859-8, o) //////////////////////////////////////////

IMPLEMENT_ISO8859_TO_UNICODE(8)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(8)
	MAP_CHAR_UCS_TO_ISO8859(0x00D7, 0xAA)	// Multiplication Sign
	MAP_CHAR_UCS_TO_ISO8859(0x00F7, 0xBA)	// Division Sign
	MAP_CHAR_UCS_TO_ISO8859(0x2017, 0xDF)	// Double Low Line
	MAP_RANGE_UCS_TO_ISO8859(0x00A2, 0x00BE, 0x0000)
	MAP_RANGE_UCS_TO_ISO8859(0x05D0, 0x05EA, 0x04F0)
	MAP_RANGE_UCS_TO_ISO8859(0x200E, 0x200F, 0x1F11)
IMPLEMENT_UNICODE_TO_ISO8859_END()


// gR (ISO-8859-9) ////////////////////////////////////////////////////

IMPLEMENT_ISO8859_TO_UNICODE(9)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(9)
	MAP_CHAR_UCS_TO_ISO8859(0x011E, 0xD0)	// Latin Capital Letter G With Breve
	MAP_CHAR_UCS_TO_ISO8859(0x0130, 0xDD)	// Latin Capital Letter I With Dot Above
	MAP_CHAR_UCS_TO_ISO8859(0x015E, 0xDE)	// Latin Capital Letter S With Cedilla
	MAP_CHAR_UCS_TO_ISO8859(0x011F, 0xF0)	// Latin Capital Small G With Breve
	MAP_CHAR_UCS_TO_ISO8859(0x0131, 0xFD)	// Latin Small Letter Dotless I
	MAP_CHAR_UCS_TO_ISO8859(0x015F, 0xFE)	// Latin Small Letter S With Cedilla
	MAP_RANGE_UCS_TO_ISO8859(0x00A1, 0x00FF, 0x0000)
IMPLEMENT_UNICODE_TO_ISO8859_END()


// k (ISO-8859-10) ///////////////////////////////////////////////////////
/*
IMPLEMENT_ISO8859_TO_UNICODE(10)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(10)
IMPLEMENT_UNICODE_TO_ISO8859_END()
*/

// og (ISO-8859-13) /////////////////////////////////////////////////
/*
IMPLEMENT_ISO8859_TO_UNICODE(13)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(13)
IMPLEMENT_UNICODE_TO_ISO8859_END()
*/

// Pg (ISO-8859-14) ///////////////////////////////////////////////////
/*
IMPLEMENT_ISO8859_TO_UNICODE(14)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(14)
IMPLEMENT_UNICODE_TO_ISO8859_END()
*/

// [bp (ISO-8859-15) ///////////////////////////////////////////////
/*
IMPLEMENT_ISO8859_TO_UNICODE(15)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(15)
IMPLEMENT_UNICODE_TO_ISO8859_END()
*/

// [bp (ISO-8859-16) /////////////////////////////////////////////
/*
IMPLEMENT_ISO8859_TO_UNICODE(16)
IMPLEMENT_UNICODE_TO_ISO8859_BEGIN(16)
IMPLEMENT_UNICODE_TO_ISO8859_END()
*/

#undef IMPLEMENT_ISO8859_TO_UNICODE
#undef IMPLEMENT_UNICODE_TO_ISO8859_BEGIN
#undef IMPLEMENT_UNICODE_TO_ISO8859_END
#undef IMPLEMENT_UNICODE_TO_LATINBASE_ISO8859_
#undef IMPLEMENT_LATINBASE_ISO8859_
#undef MAP_CHAR_UCS_TO_ISO8859
#undef MAP_RANGE_UCS_TO_ISO8859

/* [EOF] */