// Armenian.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "Encoder.h"
#include <map>

using namespace Ascension::Encodings;
using namespace std;


DEFINE_ENCODER_CLASS(CPEX_ARMENIAN_ARMSCII7, Armenian_Armscii7);
DEFINE_ENCODER_CLASS(CPEX_ARMENIAN_ARMSCII8, Armenian_Armscii8);
DEFINE_ENCODER_CLASS(CPEX_ARMENIAN_ARMSCII8A, Armenian_Armscii8a);

// ȉ̕ϊe[u Hovik Melikyan ̎QƂ
// (http://www.freenet.am/armscii/)
namespace {
	const wchar_t ARMSCII7toUCS[] = {
	/* 0x00 */	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
				0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
	/* 0x20 */	0x0020, __RPCH, 0x0587, 0x0589, 0x0029, 0x0028, 0x00BB, 0x00AB,
				0x2014, 0x002E, 0x055D, 0x002C, 0x002D, 0x058A, 0x2026, 0x055C,
	/* 0x30 */	0x055B, 0x055E, 0x0531, 0x0561, 0x0532, 0x0562, 0x0533, 0x0563,
				0x0534, 0x0564, 0x0535, 0x0565, 0x0536, 0x0566, 0x0537, 0x0567,
	/* 0x40 */	0x0538, 0x0568, 0x0539, 0x0569, 0x053A, 0x056A, 0x053B, 0x056B,
				0x053C, 0x056C, 0x053D, 0x056D, 0x053E, 0x056E, 0x053F, 0x056F,
	/* 0x50 */	0x053F, 0x056F, 0x0540, 0x0570, 0x0541, 0x0571, 0x0542, 0x0572,
				0x0544, 0x0574, 0x0545, 0x0575, 0x0546, 0x0576, 0x0547, 0x0577,
	/* 0x60 */	0x0548, 0x0578, 0x0549, 0x0579, 0x054A, 0x057A, 0x054B, 0x057B,
				0x054C, 0x057C, 0x054D, 0x057D, 0x054E, 0x057E, 0x054F, 0x057F,
	/* 0x70 */	0x0550, 0x0580, 0x0551, 0x0581, 0x0552, 0x0582, 0x0553, 0x0583,
				0x0554, 0x0584, 0x0555, 0x0585, 0x0556, 0x0586, 0x055A, 0x007F
	};
	const wchar_t ARMSCII8AtoUCS[] = {
	/* 0x00 */	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0587, 0x0016, 0x0017,
				0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
	/* 0x20 */	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x055B,
				0x0028, 0x0029, 0x0030, 0x0031, 0x002C, 0x2014, 0x002E, 0x0032,
	/* 0x30 */	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
				0x0038, 0x0039, 0x0589, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	/* 0x40 */	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
				0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	/* 0x50 */	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
				0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x002D,
	/* 0x60 */	0x055D, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
				0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	/* 0x70 */	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
				0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x055C, 0x007F,
	/* 0x80 */	0x0531, 0x0561, 0x0532, 0x0562, 0x0533, 0x0563, 0x0534, 0x0564,
				0x0535, 0x0565, 0x0536, 0x0566, 0x0537, 0x0567, 0x0538, 0x0568,
	/* 0x90 */	0x0539, 0x0569, 0x053A, 0x056A, 0x053B, 0x056B, 0x053C, 0x056C,
				0x053D, 0x056D, 0x053E, 0x056E, 0x053F, 0x056F, 0x0540, 0x0570,
	/* 0xA0 */	0x0541, 0x0571, 0x0542, 0x0572, 0x0543, 0x0573, 0x0544, 0x0574,
				0x0545, 0x0575, 0x0546, 0x0576, 0x0547, 0x0577, 0x00AB, 0x00BB,
	/* 0xB0 */	__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
				__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
	/* 0xC0 */	__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
				__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
	/* 0xD0 */	__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
				__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, 0x058A, 0x2026, 0x055E,
	/* 0xE0 */	0x0548, 0x0578, 0x0549, 0x0579, 0x054A, 0x057A, 0x054B, 0x057B,
				0x054C, 0x057C, 0x054D, 0x057D, 0x054E, 0x057E, 0x054F, 0x057F,
	/* 0xF0 */	0x0550, 0x0580, 0x0551, 0x0581, 0x0552, 0x0582, 0x0553, 0x0583,
				0x0554, 0x0584, 0x0555, 0x0585, 0x0556, 0x0586, 0x055A, __RPCH,
	};

	inline const wchar_t* DecomposeArmenianLigature(wchar_t ch) {
		switch(ch) {
		case 0x0587:	return L"\x0565\x0582";	// Ech Yiwn
		case 0xFB13:	return L"\x0574\x0576";	// Men Now
		case 0xFB14:	return L"\x0574\x0565";	// Men Ech
		case 0xFB15:	return L"\x0574\x056B";	// Men Ini
		case 0xFB16:	return L"\x057E\x0576";	// Vew Now
		case 0xFB17:	return L"\x0574\x056D";	// Men Xeh
		default:		return 0;
		}
	}
} // namespace `anonymous'


// AjA (ARMSCII-7) /////////////////////////////////////////////////

CEncoder_Armenian_Armscii7::CEncoder_Armenian_Armscii7() {
}

size_t CEncoder_Armenian_Armscii7::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	static map<wchar_t, char>	ucs_armscii;
	size_t						iSrc = 0, iDest = 0;

	if(ucs_armscii.empty()) {
		for(size_t i = 0; i < _countof(ARMSCII7toUCS); ++i)
			ucs_armscii.insert(make_pair(ARMSCII7toUCS[i], i));
	}

	while(iSrc < cchSrc && iDest < cchDest) {
		const map<wchar_t, char>::const_iterator	it = ucs_armscii.find(pwszSrc[iSrc]);
		if(it != ucs_armscii.end())
			pszDest[iDest++] = it->second;
		else if(const wchar_t* pwszDecomposed = DecomposeArmenianLigature(pwszSrc[iSrc])) {
			pszDest[iDest++] = ucs_armscii.find(pwszDecomposed[0])->second;
			pszDest[iDest++] = ucs_armscii.find(pwszDecomposed[1])->second;
		} else if(pCallBack == 0 || (*pCallBack)()) {
			pszDest[iDest++] = __DEFAULT_CHAR;
			pCallBack = 0;
		} else
			return 0;
		++iSrc;
	}
	return iDest;
}

size_t CEncoder_Armenian_Armscii7::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pszSrc[i] < 0x80 && ARMSCII7toUCS[pszSrc[i]] != __RPCH)
			pwszDest[i] = ARMSCII7toUCS[pszSrc[i]];
		else if(pCallBack == 0 || (*pCallBack)()) {
			pwszDest[i] = __DEFAULT_CHAR;
			pCallBack = 0;
		} else
			return 0;
	}
	return min(cchSrc, cchDest);
}

uchar CEncoder_Armenian_Armscii7::GetMaxCharacterLength() const {
	return 2;
}


// AjA (ARMSCII-8) /////////////////////////////////////////////////

CEncoder_Armenian_Armscii8::CEncoder_Armenian_Armscii8() {
}

size_t CEncoder_Armenian_Armscii8::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	static map<wchar_t, char>	ucs_armscii;
	size_t						iSrc = 0, iDest = 0;

	if(ucs_armscii.empty()) {
		for(size_t i = 0; i < _countof(ARMSCII7toUCS) && i != 0x7F; ++i)
			ucs_armscii.insert(make_pair(ARMSCII7toUCS[i], i + 0x80));
	}

	while(iSrc < cchSrc && iDest < cchDest) {
		if(pwszSrc[iSrc] < 0x80) {
			pszDest[iSrc++] = static_cast<char>(pwszSrc[iSrc++]);
			continue;
		}

		const map<wchar_t, char>::const_iterator	it = ucs_armscii.find(pwszSrc[iSrc]);
		if(it != ucs_armscii.end())
			pszDest[iDest++] = it->second;
		else if(const wchar_t* pwszDecomposed = DecomposeArmenianLigature(pwszSrc[iSrc])) {
			pszDest[iDest++] = ucs_armscii.find(pwszDecomposed[0])->second;
			pszDest[iDest++] = ucs_armscii.find(pwszDecomposed[1])->second;
		} else if(pCallBack == 0 || (*pCallBack)()) {
			pszDest[iDest++] = __DEFAULT_CHAR;
			pCallBack = 0;
		} else
			return 0;
		++iSrc;
	}
	return iDest;
}

size_t CEncoder_Armenian_Armscii8::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pszSrc[i] < 0x80)
			pwszDest[i] = pszSrc[i];
		else if(pszSrc[i] < 0xFF && ARMSCII7toUCS[pszSrc[i] - 0x80] != __RPCH)
			pwszDest[i] = ARMSCII7toUCS[pszSrc[i] - 0x80];
		else if(pCallBack == 0 || (*pCallBack)()) {
			pwszDest[i] = __DEFAULT_CHAR;
			pCallBack = 0;
		} else
			return 0;
	}
	return min(cchSrc, cchDest);
}

uchar CEncoder_Armenian_Armscii8::GetMaxCharacterLength() const {
	return 2;
}


// AjA (ARMSCII-8A) ////////////////////////////////////////////////

CEncoder_Armenian_Armscii8a::CEncoder_Armenian_Armscii8a() {
}

size_t CEncoder_Armenian_Armscii8a::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	static map<wchar_t, char>	ucs_armscii;
	size_t						iSrc = 0, iDest = 0;

	if(ucs_armscii.empty()) {
		for(size_t i = 0; i < _countof(ARMSCII8AtoUCS); ++i)
			ucs_armscii.insert(make_pair(ARMSCII8AtoUCS[i], i));
	}

	while(iSrc < cchSrc && iDest < cchDest) {
		const map<wchar_t, char>::const_iterator	it = ucs_armscii.find(pwszSrc[iSrc]);
		if(it != ucs_armscii.end())
			pszDest[iDest++] = it->second;
		else if(const wchar_t* pwszDecomposed = DecomposeArmenianLigature(pwszSrc[iSrc])) {
			pszDest[iDest++] = ucs_armscii.find(pwszDecomposed[0])->second;
			pszDest[iDest++] = ucs_armscii.find(pwszDecomposed[1])->second;
		} else if(pCallBack == 0 || (*pCallBack)()) {
			pszDest[iDest++] = __DEFAULT_CHAR;
			pCallBack = 0;
		} else
			return 0;
		++iSrc;
	}
	return iDest;
}

size_t CEncoder_Armenian_Armscii8a::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
		if(pszSrc[i] < 0x0100 && ARMSCII8AtoUCS[pszSrc[i]] != __RPCH)
			pwszDest[i] = ARMSCII8AtoUCS[pszSrc[i]];
		else if(pCallBack == 0 || (*pCallBack)()) {
			pwszDest[i] = __DEFAULT_CHAR;
			pCallBack = 0;
		} else
			return 0;
	}
	return min(cchSrc, cchDest);
}

uchar CEncoder_Armenian_Armscii8a::GetMaxCharacterLength() const {
	return 2;
}

/* [EOF] */