// EditPoint.h
// (c) 2003-2004 exeal

#ifndef _EDIT_POINT_H_
#define _EDIT_POINT_H_
#include "EditDoc.h"


#define VERIFY_VIEW()	\
	if(!IsAvailable())	\
		throw EViewIsAlreadyInavailable();


namespace Ascension {
	class CCharPos;
	class CEditDoc;
	class CEditView;

	///	JEg̎d
	enum UnitBehavior {
		UB_UTF16,	///< UTF-16 P
		UB_UTF32,	///< UTF-32 PʁBTQ[gyA1Ƃ݂Ȃ
		UB_CLUSTER,	///< NX^PʁBTQ[gyAA1Ƃ݂Ȃ
		UB_DEFAULT,	///<  (CEditPoint::Delete ł̂ݎgp)
	};

	///	͈͂̃eLXgϊ`
	enum RangeConvertType {
		RCT_UPPERCASE_SIMPLE,		///< 啶ɕϊ (P)
		RCT_LOWERCASE_SIMPLE,		///< ɕϊ (P)
		RCT_CAPITALIZE_SIMPLE,		///< Ls^CY (P)
		RCT_UPPERCASE_FULL,			///< 啶ɕϊ (S)
		RCT_LOWERCASE_FULL,			///< ɕϊ (S)
		RCT_CAPITALIZE_FULL,		///< Ls^CY (S)
		RCT_HIRAGANA,				///< ɕϊ
		RCT_KATAKANA,				///< Љɕϊ
		RCT_SIMPLIFIED_CHINESE,		///< ȑ̎ɕϊ
		RCT_TRADITIONAL_CHINESE,	///< ɑ̎ɕϊ
		RCT_FULLWIDTH,				///< Spɕϊ
		RCT_HALFWIDTH,				///< pɕϊ
		RCT_TABIFY,					///< 󔒕^uɕϊ
		RCT_UNTABIFY,				///< ^u󔒕ɕϊ
		RCT_ARABICDIGIT,			///< ArAɕϊ
		RCT_REMOVE_NONSPACE,		///< ꏊƂȂ폜
		RCT_REMOVE_ARABICKASHIDA,	///< ArÃJV_폜
		RCT_COMPOSE,				///< Ɍ
		RCT_DECOMPOSE,				///< 𕪉
	};

	///	 CEditDoc ɖ CEditPoint IuWFNgLłȂƂ\O
	class EViewIsAlreadyInavailable {
	public:
		///	Ԃ
		std::string	GetDescription() const {
			return "Target document is already inavailable. This object is no longer able to be used anyway.";
		}
	};

	/*
	 *	.:߂:.
	 *	CEditPoint NX CCharPos ɎĂ邪 CCharPos
	 *	̔hNXɂȂƂɂB݈͌ʒu\ CCharPos
	 *	2̃f[^oJĂ邩łB
	 *	CCharPos ̃f[^oJɂĂ悢ACCharPos
	 *	͌XPɈʒu\֐̗ǂf[^ɉ߂Ȃ̂ŁA
	 *	CEditPoint Ƃ͈قȂZ}eBNXB
	 *	ĉZqȂǂ͖ʓ|Vɒ`ȂB
	 *	̃NX CCharPos ւ̈Öق̕ϊZqB
	 */

	/**
	 *	@brief	GfB^ŕҏWAړ\ȁu_vB^Lbg
	 *
	 *	CEditView ̃NCAg͑I͈͂LbgʒuƂăeLXgҏWł邪A
	 *	̃NXɂCӂ̏ꏊ̕ҏW\ƂȂBNCAǵu_vҏWӏɈړA
	 *	CEditView ̑Ǝ@ŕҏWs
	 *
	 *	̃IuWFNg̕\_͑̕ҏWŕύX悤ɂ邱ƂA
	 *	ύXȂ悤ɂ邱ƂoB̏ꍇłʒu
	 *	(ႦΑ݂Ȃ񂩂ŏIցA폜ꂽsŏIs) ւ̈ړ͋N
	 *
	 *	ҏW_ɂhLg̕ύXsƁAAҏW_͓K؂ȈʒuɈړB
	 *	Ⴆ n ̕}ƌ݈ʒu n i߂
	 *
	 *	CEditPoint ɂhLg̃Z}eBNXɂĂ
	 *	CEditView::OnUpdate ̉
	 *
	 *	CEditPoint RXgN^͔JłBCX^X̍쐬ɂ
	 *	CEditView::CreateEditPoint \bhg
	 *
	 *	SẴ\bh̓hLg̃AhDO[v
	 *	\bhĂяos<strong>Ȃ</strong>
	 *
	 *	̃NX̂قƂǂ̃\bh͑Ώۃr[ɑ݂Ȃꍇ
	 *	EViewIsAlreadyInavailable X[
	 *
	 *	@see	CEditView, CEditDoc
	 */
	class CEditPoint : public Manah::Windows::CSmallObject<> {
		friend class CEditView;
		friend bool operator ==(const CCharPos&, const CEditPoint&);
		friend bool operator !=(const CCharPos&, const CEditPoint&);
		friend bool operator <(const CCharPos&, const CEditPoint&);
		friend bool operator <=(const CCharPos&, const CEditPoint&);
		friend bool operator >(const CCharPos&, const CEditPoint&);
		friend bool operator >=(const CCharPos&, const CEditPoint&);

		// RXgN^
	protected:
		CEditPoint(CEditView& view);
	public:
		virtual ~CEditPoint();

		NOCOPY(CEditPoint);

		// Zq
	public:
				operator CCharPos() const;
		bool	operator ==(const CCharPos& rhs) const;
		bool	operator ==(const CEditPoint& rhs) const;
		bool	operator !=(const CCharPos& rhs) const;
		bool	operator !=(const CEditPoint& rhs) const;
		bool	operator <(const CCharPos& rhs) const;
		bool	operator <(const CEditPoint& rhs) const;
		bool	operator <=(const CCharPos& rhs) const;
		bool	operator <=(const CEditPoint& rhs) const;
		bool	operator >(const CCharPos& rhs) const;
		bool	operator >(const CEditPoint& rhs) const;
		bool	operator >=(const CCharPos& rhs) const;
		bool	operator >=(const CEditPoint& rhs) const;
	protected:
		CEditPoint& operator =(const CCharPos& rhs);

		// \bh
	public:
		/*  */
		length_t				GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable);
		length_t				GetCharNumber() const throw(EViewIsAlreadyInavailable);
		Manah::Text::CodePoint	GetCodePoint() const throw(EViewIsAlreadyInavailable);
		length_t				GetColumnNumber() const throw(EViewIsAlreadyInavailable);
		length_t				GetLineLength() const throw(EViewIsAlreadyInavailable);
		length_t				GetLineNumber() const throw(EViewIsAlreadyInavailable);
		string_t				GetText(signed_length_t cch) const throw(EViewIsAlreadyInavailable);
		string_t				GetText(const CCharPos& pos) const throw(EViewIsAlreadyInavailable);
		UnitBehavior			GetUnitBehavior() const throw(EViewIsAlreadyInavailable);
		CEditView*				GetView() const;
		bool					IsEndOfDocument() const throw(EViewIsAlreadyInavailable);
		bool					IsEndOfLine() const throw(EViewIsAlreadyInavailable);
		bool					IsStartOfDocument() const throw(EViewIsAlreadyInavailable);
		bool					IsStartOfLine() const throw(EViewIsAlreadyInavailable);
		bool					IsAvailable() const;
		bool					IsSynchronousWithOtherEdit() const throw(EViewIsAlreadyInavailable);
		void					SetUnitBehavior(UnitBehavior ub);
		void					SynchronizeWithOtherEdit(bool bSync) throw(EViewIsAlreadyInavailable);

		/*  */
		CEditPoint*	Clone() const throw(EViewIsAlreadyInavailable);

		/*  (ړ) */
		void		CharNext(length_t cch = 1) throw(EViewIsAlreadyInavailable);
		void		CharPrev(length_t cch = 1) throw(EViewIsAlreadyInavailable);
		bool		EnsureCentered(signed_length_t cch = 0) throw(EViewIsAlreadyInavailable);
		bool		EnsureCentered(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		bool		EnsureVisible(signed_length_t cch = 0) throw(EViewIsAlreadyInavailable);
		bool		EnsureVisible(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		void		LineDown(length_t cLines = 1) throw(EViewIsAlreadyInavailable);
		void		LineUp(length_t cLines = 1) throw(EViewIsAlreadyInavailable);
		void		MoveToAbsoluteCharOffset(length_t nOffset) throw(EViewIsAlreadyInavailable);
		void		MoveToEndOfDocument() throw(EViewIsAlreadyInavailable);
		void		MoveToEndOfLine() throw(EViewIsAlreadyInavailable);
		void		MoveToNextBookmark() throw(EViewIsAlreadyInavailable);
		void		MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		void		MoveToPrevBookmark() throw(EViewIsAlreadyInavailable);
		void		MoveToStartOfDocument() throw(EViewIsAlreadyInavailable);
		void		MoveToStartOfLine(bool bToFirstText) throw(EViewIsAlreadyInavailable);
		void		PageDown(length_t cPages = 1) throw(EViewIsAlreadyInavailable);
		void		PageUp(length_t cPages = 1) throw(EViewIsAlreadyInavailable);
		void		WordEndNext(length_t cWords = 1) throw(EViewIsAlreadyInavailable);
		void		WordEndPrev(length_t cWords = 1) throw(EViewIsAlreadyInavailable);
		void		WordNext(length_t cWords = 1) throw(EViewIsAlreadyInavailable);
		void		WordPrev(length_t cWords = 1) throw(EViewIsAlreadyInavailable);

		/*  (ҏW) */
		void		Convert(signed_length_t cch, RangeConvertType type) throw(EViewIsAlreadyInavailable);
		void		Convert(const CCharPos& pos, RangeConvertType type) throw(EViewIsAlreadyInavailable);
		void		Copy(signed_length_t cch) throw(EViewIsAlreadyInavailable);
		void		Copy(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		void		Cut(signed_length_t cch) throw(EViewIsAlreadyInavailable);
		void		Cut(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		void		Delete(signed_length_t cch = 1, UnitBehavior ub = UB_DEFAULT) throw(EViewIsAlreadyInavailable);
		void		Delete(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		void		DestructiveInsert(const string_t& strText) throw(EViewIsAlreadyInavailable);
		void		Insert(const string_t& strText) throw(EViewIsAlreadyInavailable);
		void		InsertBox(const string_t& strText) throw(EViewIsAlreadyInavailable);
		void		NewLine() throw(EViewIsAlreadyInavailable);
		void		Paste(signed_length_t cch = 0) throw(EViewIsAlreadyInavailable);
		void		Paste(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
		CCharPos	SpaceIndent(const CCharPos& pos, long nLevel = 1) throw(EViewIsAlreadyInavailable);
		CCharPos	TabIndent(const CCharPos& pos, long nLevel = 1) throw(EViewIsAlreadyInavailable);
		bool		TransposeChars() throw(EViewIsAlreadyInavailable);
		bool		TransposeLines() throw(EViewIsAlreadyInavailable);
		bool		TransposeWords() throw(EViewIsAlreadyInavailable);
	protected:
		static CCharPos	GetNextCharPos(const CEditPoint& pt, length_t cch, UnitBehavior ub);
		static CCharPos	GetPrevCharPos(const CEditPoint& pt, length_t cch, UnitBehavior ub);
		CCharPos		Indent(const CCharPos& pos, char_t chIndent, long nLevel) throw(EViewIsAlreadyInavailable);

	protected:
		virtual void	OnUpdateDocument(const TUpdateInfo& udi);
		virtual void	OnViewDestroyed();

	protected:
		void	Normalize() const;
		void	UpdateLastCx();

		// f[^o
	public:
		UnitBehavior	m_unitBehavior;		// ̌vZ@ (^`Q)
	protected:
		length_t	m_iLine;				// sԍ
		length_t	m_iChar;				// ԍ
		CEditView*	m_pView;				// r[
		bool		m_bSyncWithOtherEdit;	// ̕ҏWł̓_ړ邩
		bool		m_bOwnedByView;			// r[̊ǗXgɓ邩 (j󎞂 CEditView::ReleaseEditPoint ĂԂ)
		ulong		m_cxLast;				// r[̐Ό_̋ (x W)
											// LineDown ALineUp ňړƂɕێ
	};

	/**
	 *	CEditView ̃AJ[|CgAANeBu|Cg\B
	 *	CEditView ȊÕNCAg̓CX^X̍쐬͕s
	 */
	class CVisibleEditPoint : public CEditPoint {
		friend class CEditView;

		// RXgN^
	private:
		CVisibleEditPoint(CEditView& view);
		CVisibleEditPoint(const CVisibleEditPoint& rhs);
	public:
		virtual ~CVisibleEditPoint();

		// Zq
	public:
							operator CCharPos() const;
		CVisibleEditPoint&	operator =(const CCharPos& rhs);
	private:
		operator =(const CVisibleEditPoint& rhs);

		// I[o[Ch\bh
	protected:
		virtual void	OnUpdateDocument(const TUpdateInfo& udi);
	private:
		CEditPoint*		Clone() const throw(EViewIsAlreadyInavailable);
	};


	// Global operators
	/////////////////////////////////////////////////////////////////////////////

	inline bool operator ==(const CCharPos& lhs, const CEditPoint& rhs) {
		return lhs.m_iLine == rhs.m_iLine && lhs.m_iChar == rhs.m_iChar;
	}

	inline bool operator !=(const CCharPos& lhs, const CEditPoint& rhs) {
		return lhs.m_iLine != rhs.m_iLine || lhs.m_iChar != rhs.m_iChar;
	}

	inline bool operator <(const CCharPos& lhs, const CEditPoint& rhs) {
		return lhs.m_iLine < rhs.m_iLine
			|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar < rhs.m_iChar);
	}

	inline bool operator <=(const CCharPos& lhs, const CEditPoint& rhs) {
		return lhs.m_iLine < rhs.m_iLine
			|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar <= rhs.m_iChar);
	}

	inline bool operator >(const CCharPos& lhs, const CEditPoint& rhs) {
		return lhs.m_iLine > rhs.m_iLine
			|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar > rhs.m_iChar);
	}

	inline bool operator >=(const CCharPos& lhs, const CEditPoint& rhs) {
		return lhs.m_iLine > rhs.m_iLine
			|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar >= rhs.m_iChar);
	}


	///	֐̂߂̌JZq
	inline CEditPoint& CEditPoint::operator =(const CCharPos& rhs) {
		m_iLine = rhs.m_iLine;
		m_iChar = rhs.m_iChar;
		return *this;
	}

	///	CCharPos ւ̕ϊZq
	inline CEditPoint::operator CCharPos() const {
		return CCharPos(m_iLine, m_iChar);
	}

	///	Zq
	inline bool CEditPoint::operator ==(const CCharPos& rhs) const {
		return m_iLine == rhs.m_iLine && m_iChar == rhs.m_iChar;
	}

	///	Zq
	inline bool CEditPoint::operator ==(const CEditPoint& rhs) const {
		assert(m_pView == rhs.m_pView);
		return m_iLine == rhs.m_iLine && m_iChar == rhs.m_iChar;
	}

	///	񓙉Zq
	inline bool CEditPoint::operator !=(const CCharPos& rhs) const {
		return m_iLine != rhs.m_iLine || m_iChar != rhs.m_iChar;
	}

	///	񓙉Zq
	inline bool CEditPoint::operator !=(const CEditPoint& rhs) const {
		assert(m_pView == rhs.m_pView);
		return m_iLine != rhs.m_iLine || m_iChar != rhs.m_iChar;
	}

	///	菬
	inline bool CEditPoint::operator <(const CCharPos& rhs) const {
		return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar < rhs.m_iChar);
	}

	///	菬
	inline bool CEditPoint::operator <(const CEditPoint& rhs) const {
		assert(m_pView == rhs.m_pView);
		return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar < rhs.m_iChar);
	}

	///	ȉ
	inline bool CEditPoint::operator <=(const CCharPos& rhs) const {
		return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar <= rhs.m_iChar);
	}

	///	ȉ
	inline bool CEditPoint::operator <=(const CEditPoint& rhs) const {
		assert(m_pView == rhs.m_pView);
		return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar <= rhs.m_iChar);
	}

	///	傫
	inline bool CEditPoint::operator >(const CCharPos& rhs) const {
		return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar > rhs.m_iChar);
	}

	///	傫
	inline bool CEditPoint::operator >(const CEditPoint& rhs) const {
		assert(m_pView == rhs.m_pView);
		return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar > rhs.m_iChar);
	}

	///	ȏ
	inline bool CEditPoint::operator >=(const CCharPos& rhs) const {
		return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar >= rhs.m_iChar);
	}

	///	ȏ
	inline bool CEditPoint::operator >=(const CEditPoint& rhs) const {
		assert(m_pView == rhs.m_pView);
		return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar >= rhs.m_iChar);
	}

	///	vZ@Ԃ
	inline UnitBehavior CEditPoint::GetUnitBehavior() const throw(EViewIsAlreadyInavailable) {
		AssertValid();
		VERIFY_VIEW();
		return m_unitBehavior;
	}

	///	Ώۃr[Ԃ
	inline CEditView* CEditPoint::GetView() const {
		AssertValid();
		return m_pView;
	}

	///	Ώۃr[Ă true Ԃ
	inline bool CEditPoint::IsAvailable() const {
		AssertValid();
		return m_pView != 0;
	}

	///	̕ҏWł̓_ړ邩ǂԂ
	inline bool CEditPoint::IsSynchronousWithOtherEdit() const throw(EViewIsAlreadyInavailable) {
		AssertValid();
		VERIFY_VIEW();
		return m_bSyncWithOtherEdit;
	}

	///	r[j󂳂ꂽƂɌĂяo
	inline void CEditPoint::OnViewDestroyed() {
		AssertValid();
		m_pView = 0;
	}

	///	vZ@̐ݒ
	inline void CEditPoint::SetUnitBehavior(UnitBehavior newBehavior) throw(EViewIsAlreadyInavailable) {
		AssertValid();
		VERIFY_VIEW();
		assert(m_unitBehavior != UB_DEFAULT);
		m_unitBehavior = newBehavior;
	}

	/**
	 *	̕ҏWɓ
	 *	@param bSync	true: Bfalse: 񓯊
	 */
	inline void CEditPoint::SynchronizeWithOtherEdit(bool bSync) throw(EViewIsAlreadyInavailable) {
		AssertValid();
		VERIFY_VIEW();
		m_bSyncWithOtherEdit = bSync;
	}

} /* namespace Ascension */

#endif /* _EDIT_POINT_H_ */

/* [EOF] */