// EditPoint.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditPoint.h"
#include "EditView.h"
#include "..\..\Manah\win_utils.h"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Text;
using namespace std;


// CEditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pView	Ώۂ̃r[
 */
CEditPoint::CEditPoint(CEditView& view)
		: m_iLine(0), m_iChar(0), m_pView(&view),
		m_bSyncWithOtherEdit(false), m_bOwnedByView(false), 
		m_unitBehavior(UB_CLUSTER), m_cxLast(0) {
}

///	fXgN^
CEditPoint::~CEditPoint() {
	if(m_pView != 0 && m_bOwnedByView)
		m_pView->ReleaseEditPoint(*this);
}

/**
 *	̕Ɉړ
 *	@param cch	ړ邩
 */
void CEditPoint::CharNext(length_t cch /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	const CCharPos	pos = GetNextCharPos(*this, cch, m_unitBehavior);
	m_iLine = pos.m_iLine;
	m_iChar = pos.m_iChar;
	UpdateLastCx();
}

/**
 *	O̕Ɉړ
 *	@param cch	ړ邩
 */
void CEditPoint::CharPrev(length_t cch /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	const CCharPos	pos = GetPrevCharPos(*this, cch, m_unitBehavior);
	m_iLine = pos.m_iLine;
	m_iChar = pos.m_iChar;
	UpdateLastCx();
}

///	ʒu\IuWFNgԂB߂l͌Ăяoō폜
CEditPoint* CEditPoint::Clone() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditPoint*	pClone = new CEditPoint(*m_pView);
	pClone->m_iLine = m_iLine;
	pClone->m_iChar = m_iChar;
	if(m_bOwnedByView)
		m_pView->m_editPoints.insert(pClone);
	return pClone;
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 *	@param type	ϊ̎
 */
void CEditPoint::Convert(signed_length_t cch, RangeConvertType type) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;

	CEditPoint	pt(*m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cch > 0)
		pt.CharNext(cch);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cch++ != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Convert(pt, type);
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param pos	1̈ʒu
 *	@param type	ϊ̎ށBw͕s
 */
void CEditPoint::Convert(const CCharPos& pos, RangeConvertType type) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || *this == pos)
		return;

//	if(type == RCT)
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param cch	Rs[镶 (ł悢)
 */
void CEditPoint::Copy(signed_length_t cch) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	const string_t	str = GetText(cch);
	CClipboard::SetClipboardText(m_pView->m_hWnd, str.data(), str.length());
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param pos	1̈ʒu
 */
void CEditPoint::Copy(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	const string_t	str = GetText(pos);
	CClipboard::SetClipboardText(m_pView->m_hWnd, str.data(), str.length());
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param cch	폜镶 (ł悢)
 */
void CEditPoint::Cut(signed_length_t cch) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	const string_t	str = GetText(cch);
	CClipboard::SetClipboardText(m_pView->m_hWnd, str.data(), str.length());
	Delete(cch);
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param pos	1̈ʒu
 */
void CEditPoint::Cut(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	const string_t	str = GetText(pos);
	CClipboard::SetClipboardText(m_pView->m_hWnd, str.data(), str.length());
	Delete(pos);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 *	@param ub	̌vZ@BUB_DEFAULT w肷ƌ݂̐ݒ肪gp
 */
void CEditPoint::Delete(signed_length_t cch /* = 1 */, UnitBehavior ub /* = UB_DEFAULT */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || cch == 0)
		return;

	CEditPoint	pt(*m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cch > 0)
		pt.CharNext(cch);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cch++ != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Delete(pt);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param pos	1̈ʒu
 */
void CEditPoint::Delete(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	if(pos == *this)
		return;
	*this = m_pView->GetDocument()->DeleteText(this, *this, pos);
	UpdateLastCx();
}

/**
 *	w͈͂r[̒ɂȂ悤ɃXN[BɉȂ牽Ȃ
 *	@param cch	͈͂\̓_܂ł̕
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ
 */
bool CEditPoint::EnsureCentered(signed_length_t cch /* = 0 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return EnsureCentered((cch >= 0) ?
		GetNextCharPos(*this, cch, m_unitBehavior) : GetPrevCharPos(*this, -cch, m_unitBehavior));
}

/**
 *	w͈͂r[̒ɂȂ悤ɃXN[BɉȂ牽Ȃ
 *	@param pos	͈͂\̓_
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool CEditPoint::EnsureCentered(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CCharPos	posDisplay = m_pView->DisplayCharFromLogicalChar(*this);
	const length_t	cVisibleLines = m_pView->GetVisibleLineCount();

	m_pView->OnHScroll(SB_LEFT, 0, 0);
	m_pView->OnVScroll(SB_SETPOS, posDisplay.m_iLine - cVisibleLines / 2, 0);

	return true;
}

/**
 *	w͈͂ɂȂ悤Ƀr[XN[
 *	@param cch	͈͂\̓_܂ł̕
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool CEditPoint::EnsureVisible(signed_length_t cch /* = 0 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return EnsureVisible((cch >= 0) ?
		GetNextCharPos(*this, cch, m_unitBehavior) : GetPrevCharPos(*this, -cch, m_unitBehavior));
}

/**
 *	_ɂȂ悤Ƀr[XN[
 *	@param	pos	͈͂\̓_
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool CEditPoint::EnsureVisible(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CCharPos	posDisplay = m_pView->DisplayCharFromLogicalChar(*this);
	const length_t	cVisibleLines = m_pView->GetVisibleLineCount();
	const length_t	cVisibleChars = m_pView->GetVisibleCharCount();

	if(posDisplay.m_iLine <
			m_pView->m_ptScroll.y * m_pView->m_layoutInfo.nVScrollRatio)	// ʂ
		m_pView->OnVScroll(SB_SETPOS, posDisplay.m_iLine, 0);
	else if(posDisplay.m_iLine -
			m_pView->m_ptScroll.y *
			m_pView->m_layoutInfo.nVScrollRatio > cVisibleLines - 1)	// ʂ艺
		m_pView->OnVScroll(SB_SETPOS, posDisplay.m_iLine - cVisibleLines + 1, 0);

	if(m_pView->m_modeState.wrapMode == WPM_NONE) {
		const ulong	nScrollOffset = m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio * m_pView->GetAvgCharWidth();
		const ulong	cx = m_pView->PosFromChar(*this).x + nScrollOffset
						- m_pView->m_layoutInfo.nLeftTabWidth - m_pView->m_layoutInfo.nLeftMargin + 1;
		if(cx <= nScrollOffset)	// ʂ荶
			m_pView->OnHScroll(SB_SETPOS, cx / m_pView->GetAvgCharWidth() - cVisibleChars / 4, 0);
		else if(cx > (m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio
				+ cVisibleChars) * m_pView->GetAvgCharWidth())	// ʂE
			m_pView->OnHScroll(SB_SETPOS, cx / m_pView->GetAvgCharWidth() - cVisibleChars * 3 / 4, 0);
	} else {
		// ...
	}

	return true;
}

///	hLg̐擪̕Ԃ
length_t CEditPoint::GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	length_t		nOffset = 0;
	LineIterator	itLines = m_pView->GetDocument()->GetLineIterator(0);

	Normalize();
	for(length_t iLine = 0; ; ++iLine, ++itLines) {
		if(iLine == m_iLine) {
			nOffset += m_iChar;
			break;
		} else
			nOffset += itLines->GetLine().length() + 1;	// +1 ͉s
	}
	return nOffset;
}

///	ԍԂ
length_t CEditPoint::GetCharNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_iChar;
}

///	݈ʒũR[h|CgԂBs̏ꍇ͎ۂ̉sR[hɊ֌W 0x000A A
///	̖̏ꍇ 0xFFFFFFFF Ԃ
CodePoint CEditPoint::GetCodePoint() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const string_t&	strLine = m_pView->GetDocument()->GetLine(m_iLine);

	if(m_iChar == strLine.length())
		return (m_iLine == m_pView->GetDocument()->GetLineCount() - 1) ? 0xFFFFFFFF : 0x000A;
	return DecodeUTF16SurrogatePairToCodePoint(strLine.data() + m_iChar, strLine.length() - m_iChar);
}

///	\̗ԍԂ
length_t CEditPoint::GetColumnNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_pView->ColumnFromChar(*this);
}

///	_s̒Ԃ
length_t CEditPoint::GetLineLength() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_pView->GetDocument()->GetLineLength(m_iLine);
}

///	sԍԂ
length_t CEditPoint::GetLineNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iLine;
}

/**
 *	^ꂽʒuw蕶i񂾈ʒuԂ
 *	@param pt	ʒu
 *	@param cch	
 *	@param ub	vZ@
 */
CCharPos CEditPoint::GetNextCharPos(const CEditPoint& pt, length_t cch, UnitBehavior ub) {
	length_t		cLines = pt.m_pView->GetDocument()->GetLineCount();
	string_t		strLine = pt.m_pView->GetDocument()->GetLine(pt.m_iLine);
	const char_t*	pwszLine = strLine.data();
	CCharPos		pos = pt;

	while(cch-- > 0) {
		if(pos.m_iChar == strLine.length()) {	// sȂ̂Ŏ̍sɈړ
			if(pos.m_iLine == cLines - 1)	// ŏIsłΈړȂ
				return pos;
			strLine = pt.m_pView->GetDocument()->GetLine(++pos.m_iLine);
			pwszLine = strLine.data();
			pos.m_iChar = 0;
		} else if(ub == UB_UTF16)
			++pos.m_iChar;
		else {
			CodePoint	cp;
			cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + pos.m_iChar, strLine.length() - pos.m_iChar);
			pos.m_iChar += (cp > 0xFFFF) ? 2 : 1;
			while(ub == UB_CLUSTER && pos.m_iChar < strLine.length()) {
				cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + pos.m_iChar, strLine.length() - pos.m_iChar);
				if(CBoundarySearcher::IsFirstCharacterOfCluster(cp))
					break;
				pos.m_iChar += (cp > 0xFFFF) ? 2 : 1;
			}
		}
	}
	return pos;
}

/**
 *	^ꂽʒuw蕶߂ʒuԂ
 *	@param pt	ʒu
 *	@param cch	
 *	@param ub	vZ@
 */
CCharPos CEditPoint::GetPrevCharPos(const CEditPoint& pt, length_t cch, UnitBehavior ub) {
	string_t		strLine = pt.m_pView->GetDocument()->GetLine(pt.m_iLine);
	const char_t*	pwszLine = strLine.data();
	CCharPos		pos = pt;

	while(cch-- > 0) {
		if(pos.m_iChar == 0) {	// sȂ̂őO̍sɈړ
			if(pos.m_iLine == 0)	// 擪słΈړȂ
				return pos;
			strLine = pt.m_pView->GetDocument()->GetLine(--pos.m_iLine);
			pwszLine = strLine.data();
			pos.m_iChar = strLine.length();
		} else if(ub == UB_UTF16 || pos.m_iChar == 0)
			--pos.m_iChar;
		else {
			CodePoint	cp;
			if(IsUTF16HighSurrogate(pwszLine[pos.m_iChar - 2])
					&& IsUTF16LowSurrogate(pwszLine[pos.m_iChar - 1]))
				cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + pos.m_iChar - 2, 2);
			else
				cp = pwszLine[pos.m_iChar - 1];
			pos.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
			while(ub == UB_CLUSTER
					&& pos.m_iChar != 0
					&& !CBoundarySearcher::IsFirstCharacterOfCluster(cp)) {
				if(pos.m_iChar != 1
						&& IsUTF16HighSurrogate(pwszLine[pos.m_iChar - 2])
						&& IsUTF16LowSurrogate(pwszLine[pos.m_iChar - 1])) {
					cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + pos.m_iChar - 2, 2);
					pos.m_iChar -= 2;
				} else {
					cp = pwszLine[pos.m_iChar - 1];
					--pos.m_iChar;
				}
			}
		}
	}
	return pos;
}

/**
 *	͈͓̃eLXgԂ
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 */
string_t CEditPoint::GetText(signed_length_t cch) const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	if(cch == 0)
		return L"";
	return GetText((cch > 0) ?
		GetNextCharPos(*this, cch, m_unitBehavior) : GetPrevCharPos(*this, -cch, m_unitBehavior));
}

/**
 *	͈͓̃eLXgԂ
 *	@param pos	1̈ʒu
 */
wstring CEditPoint::GetText(const CCharPos& pos) const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CCharPos	pos_ = pos;
	
	pos_.m_iLine = std::min(pos.m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	Normalize();
	if(*this == pos)
		return L"";

	const CEditDoc*	pDoc = m_pView->GetDocument();
	const CCharPos&	posStart = std::min<CCharPos>(*this, pos_);
	const CCharPos&	posEnd = std::max<CCharPos>(*this, pos_);

	if(posStart.m_iLine == posEnd.m_iLine)	// 1s̏ꍇ
		return pDoc->GetLine(posEnd.m_iLine).substr(
			posStart.m_iChar, posEnd.m_iChar - posStart.m_iChar);
	else {	// s̏ꍇ
		ostringstream_t	ssText;
		length_t		iLine = posStart.m_iLine;
		LineIterator	itLines = pDoc->GetLineIterator(iLine);

		while(true) {
			if(iLine == posStart.m_iLine)	// 擪s
				ssText << itLines->GetLine().substr(posStart.m_iChar)
						<< CEditDoc::GetBreakString(itLines->GetBreakType());
			else if(iLine == posEnd.m_iLine) {	// ŏIs
				ssText << itLines->GetLine().substr(0, posEnd.m_iChar);
				break;
			} else
				ssText << itLines->GetLine()
						<< CEditDoc::GetBreakString(itLines->GetBreakType());
			++iLine;
			++itLines;
		}
		return ssText.str();
	}
}

/**
 *	_̈ʒũeLXg폜ĕ}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 */
void CEditPoint::DestructiveInsert(const string_t& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();

	if(pDoc->IsReadOnly())
		return;

	CEditPoint	pos(*m_pView);

	pos.m_iLine = m_iLine;
	pos.m_iChar = m_iChar;
	pos.CharNext();
	pDoc->EndEditCollection();
	pDoc->BeginEditCollection();
	pDoc->DeleteText(this, *this, pos);
	*this = pDoc->InsertText(this, *this, strText);
	pDoc->EndEditCollection();
	UpdateLastCx();
}

/**
 *	͈͓̃eLXgCfg
 *	@param pos		1̈ʒu
 *	@param chIndent	CfgɎg
 *	@param nLevel	Cfgx
 */
CCharPos CEditPoint::Indent(const CCharPos& pos, char_t chIndent, long nLevel) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return pos;

	CEditDoc*		pDocument = m_pView->GetDocument();
	const CLexer&	lexer = m_pView->GetLexer();
	const string_t	strIndent = wstring(abs(nLevel), chIndent);
	const CCharPos	posTop = m_pView->GetSelTopPoint();
	const CCharPos	posBottom = m_pView->GetSelBottomPoint();
	CCharPos		posOtherRes = pos;
	length_t		iLine = posTop.m_iLine;
	length_t		cchIndent;	// s̋󔒕

	if(iLine < posBottom.m_iLine && nLevel != 0) {
		if(nLevel > 0) {
			pDocument->InsertText(this, CCharPos(iLine, 0), strIndent);
			if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
				posOtherRes.m_iChar += nLevel;
			else if(iLine == m_iLine && m_iChar != 0)
				m_iChar += nLevel;
		} else {
			cchIndent = lexer.IsWhiteSpace(pDocument->GetLine(iLine).data(), pDocument->GetLineLength(iLine), true);
			if(cchIndent > 0) {
				const length_t	cchDelete = min<length_t>(-nLevel, cchIndent);
				pDocument->DeleteText(this, CCharPos(iLine, 0), CCharPos(iLine, cchDelete));
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar -= cchDelete;
				else if(iLine == m_iLine && m_iChar != 0)
					m_iChar -= cchDelete;
			}
		}
	} else {	// I1sȓ -> Pȕ}
		if(nLevel > 0)
			m_pView->ReplaceSel(strIndent);
		return *this;
	}

	// ÎSĂ̍s (t) Cfg
	if(nLevel > 0) {
		for(++iLine; iLine <= posBottom.m_iLine; ++iLine) {
			if(pDocument->GetLineLength(iLine) != 0 && (iLine != posBottom.m_iLine || posBottom.m_iChar > 0)) {
				pDocument->InsertText(this, CCharPos(iLine, 0), strIndent);
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar += nLevel;
				else if(iLine == m_iLine && m_iChar != 0)
					m_iChar += nLevel;
			}
		}
	} else {
		for(++iLine; iLine <= posBottom.m_iLine; ++iLine) {
			cchIndent = lexer.IsWhiteSpace(pDocument->GetLine(iLine).data(), pDocument->GetLineLength(iLine), true);
			if(cchIndent > 0) {
				const length_t	cchDelete = min<length_t>(-nLevel, cchIndent);
				pDocument->DeleteText(this, CCharPos(iLine, 0), CCharPos(iLine, cchDelete));
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar -= cchDelete;
				else if(iLine == m_iLine && m_iChar != 0)
					m_iChar -= cchDelete;
			}
		}
	}
	return posOtherRes;
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 */
void CEditPoint::Insert(const wstring& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	*this = m_pView->GetDocument()->InsertText(this, *this, strText);
	UpdateLastCx();
}

/**
 *	_̈ʒuɕ`}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 */
void CEditPoint::InsertBox(const string_t& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || strText.empty())
		return;

	CEditDoc*		pDocument = m_pView->GetDocument();
	const length_t	cLines = pDocument->GetLineCount();
	const string_t	strBreaks = CEditDoc::GetBreakString(pDocument->GetBreakType());
	list<length_t>	lines;

	// sʒũXg
	length_t	iChar = 0, iLast = 0;
	while(true) {
		iChar = strText.find_first_of(CEditDoc::m_wszBreakChars, iLast);
		if(iChar == string_t::npos)
			break;
		iLast = iChar + ((iChar < strText.length() - 1
			&& strText[iChar] == L'\r' && strText[iChar == L'\n']) ? 2 : 1);
		lines.push_back(iLast);
	}

	if(*lines.begin() != 0)
		lines.push_front(0);

	length_t	iLine = m_iLine;	// }s
	string_t	strLine;			// }sƂȂ镔
	ulong		xFirstLineInsert;	// }擪s̑}ʒu (r[ x W)
	for(list<length_t>::const_iterator it = lines.begin(); it != lines.end(); ++it) {
		if(it == lines.begin())	// ŏ̍s
			xFirstLineInsert = m_pView->PosFromChar(*this).x - m_pView->m_layoutInfo.nLeftTabWidth;
		if(++it == lines.end())	// ŏIs
			strLine = strText.substr(*(--it), string_t::npos);
		else {
			length_t	cchLine = *it - ((strText[*it - 1] == L'\n' && strText[*it - 2] == L'\r') ? 2 : 1);
			cchLine -= *(--it);
			strLine = strText.substr(*it, cchLine);
		}
		++it;
		if(iLine >= cLines - 1 && it != lines.end())	// }ʒuɍs݂Ȃꍇ͍쐬
			strLine += strBreaks;
		--it;

		if(strLine.length() != 0) {
			strLine = m_pView->CalculateSpacesReachingVirtualPoint(iLine, xFirstLineInsert) + strLine;	// }ʒu̒
			*this = pDocument->InsertText(this, CCharPos(iLine,
				m_pView->CharFromPixel(iLine, xFirstLineInsert,
					!m_pView->m_options.behaviorOptions[BooleanOptions::ACCEPT_CARET_ON_EXTENDER_BY_MOUSE])), strLine);
		}
		++iLine;
	}
}

///	݈ʒuhLg̏I[ł邩ǂԂ
bool CEditPoint::IsEndOfDocument() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();

	Normalize();
	if(pDoc->GetLineCount() - 1 != m_iLine)
		return false;
	return pDoc->GetLineLength(m_iLine) == m_iChar;
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsEndOfLine() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_pView->GetDocument()->GetLineLength(m_iLine) == m_iChar;
}

///	݈ʒuhLg̐擪ł邩ǂԂ
bool CEditPoint::IsStartOfDocument() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iLine == 0 && m_iChar == 0;
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsStartOfLine() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iChar == 0;
}

/**
 *	̍sɈړ
 *	@param cLines	ړs
 */
void CEditPoint::LineDown(length_t cLines /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = min(m_iLine + cLines, m_pView->GetDocument()->GetLineCount() - 1);
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	O̍sɈړ
 *	@param cLines	ړs
 */
void CEditPoint::LineUp(length_t cLines /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = (m_iLine > cLines) ? m_iLine - cLines : 0;
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	hLg擪̕Ŏw肵ʒuɈړ
 *	@param nOffset	hLg擪̕
 */
void CEditPoint::MoveToAbsoluteCharOffset(length_t nOffset) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDoc = m_pView->GetDocument();
	length_t		cRead = 0;
	LineIterator	itLines = pDoc->GetLineIterator(0);
	length_t		cLines = pDoc->GetLineCount();

	for(length_t iLine = 0; iLine < cLines; ++iLine, ++itLines) {
		const length_t	cchLine = itLines->GetLine().length() + 1;
		if(cRead + cchLine >= nOffset) {
			m_iLine = iLine;
			m_iChar = cRead + cchLine - nOffset;
			return;
		}
		cRead += cchLine;
	}
	m_iLine = cLines - 1;
	m_iChar = itLines->GetLine().length();
	UpdateLastCx();
}

///	hLg̏I[Ɉړ
void CEditPoint::MoveToEndOfDocument() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDoc = m_pView->GetDocument();
	m_iLine = pDoc->GetLineCount() - 1;
	m_iChar = pDoc->GetLineLength(pDoc->GetLineCount() - 1);
	UpdateLastCx();
}

///	sɈړ
void CEditPoint::MoveToEndOfLine() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	m_iChar = m_pView->GetDocument()->GetLineLength(m_iLine);
	UpdateLastCx();
}

///	̃ubN}[Ns̍sɈړ
void CEditPoint::MoveToNextBookmark() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	length_t	iLine;
	length_t	cLines = m_pView->GetDocument()->GetLineCount();

	// T
	for(iLine = m_iLine + 1; iLine < cLines; ++iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			UpdateLastCx();
			return;
		}
	}

	// Ȃΐ܂Ԃ
	for(iLine = 0; iLine < m_iLine; ++iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			UpdateLastCx();
			return;
		}
	}
}

/**
 *	wʒuɈړ
 *	@param pos	ړ
 */
void CEditPoint::MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = pos.m_iLine;
	m_iChar = pos.m_iChar;
	Normalize();
	UpdateLastCx();
}

///	ÕubN}[Ns̍sɈړ
void CEditPoint::MoveToPrevBookmark() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	length_t	iLine = m_iLine - 1;

	// T
	while(true) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			return;
			UpdateLastCx();
		}
		if(--iLine == 0)
			break;
	}

	// Ȃΐ܂Ԃ
	CEditDoc*	pDoc = m_pView->GetDocument();
	for(iLine = pDoc->GetLineCount() - 1; iLine > m_iLine; --iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			UpdateLastCx();
			return;
		}
	}
}

///	hLg̐擪Ɉړ
void CEditPoint::MoveToStartOfDocument() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = m_iChar = 0;
	UpdateLastCx();
}

/**
 *	sɈړ
 *	@param bToFirstText	true: 󔒕łȂŏ̕ɈړAfalse: 0ڂɈړB
 *			݈ʒu󔒂Ŗŏ̕ł΁A0ڂɈړ
 */
void CEditPoint::MoveToStartOfLine(bool bToFirstText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDocument = m_pView->GetDocument();

	m_iLine = std::min(m_iLine, pDocument->GetLineCount() - 1);
	if(!bToFirstText)
		m_iChar = 0;
	else {
		const length_t	cchHeadSpace = m_pView->GetLexer().IsWhiteSpace(
			pDocument->GetLine(m_iLine).data(), pDocument->GetLineLength(m_iLine), true);
		m_iChar = (m_iChar != cchHeadSpace) ? cchHeadSpace : 0;
	}
	UpdateLastCx();
}

///	sBݒɂăX}[gCfgAubNCfgs
void CEditPoint::NewLine() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();
	string_t	strBreak = CEditDoc::GetBreakString(pDoc->GetBreakType());
	bool		bDoneSmartIndent = false;	// X}[gCfg

	if(pDoc->IsReadOnly())
		return;
//	if(m_modeState.aitAutoIndentType == AIT_SMART)
//		bDoneSmartIndent = SmartIndent(L'\n');
	if(!bDoneSmartIndent && m_pView->m_options.autoIndentType == AIT_BLOCK) {	// I[gCfg
		const string_t&	strCurrentLine = pDoc->GetLine(m_iLine);
		const length_t	cch = m_pView->GetLexer().IsWhiteSpace(strCurrentLine.data(), m_iChar, true);
		strBreak += strCurrentLine.substr(0, cch);
	}
	if(!bDoneSmartIndent)
		Insert(strBreak);
}

///	ʒuɈړ (const \bh悭Ăяô const ɂĂ)
void CEditPoint::Normalize() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const_cast<CEditPoint*>(this)->m_iLine =
		std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	const_cast<CEditPoint*>(this)->m_iChar =
		std::min(m_iChar, m_pView->GetDocument()->GetLineLength(m_iLine));
}

/**
 *	hLgύXꂽƂɌĂяo
 *	@param udi	XV̓e
 */
void CEditPoint::OnUpdateDocument(const TUpdateInfo& udi) {
	AssertValid();
	if(m_pView == 0)
		return;

//	Normalize();

	// hLg̕ύXɍ킹Ĉʒu𒲐
	if(udi.summary == US_OPERATION_INSERT) {	// }̏ꍇ
		if(*this < udi.posBegin)	// ݈ʒu
			return;
		else if(this->m_iLine > udi.posBegin.m_iLine)	// ݍsO
			m_iLine += udi.posResult.m_iLine - udi.posBegin.m_iLine;
		else {	// ݍsƓs
			m_iLine += udi.posResult.m_iLine - udi.posBegin.m_iLine;
			m_iChar += udi.posResult.m_iChar - udi.posBegin.m_iChar;
		}
	} else if(udi.summary == US_OPERATION_DELETE) {	// 폜̏ꍇ
		if(*this < udi.posEnd)	// ݈ʒu
			return;
		else if(this->m_iLine > udi.posEnd.m_iLine)	// ݍsO
			m_iLine -= udi.posEnd.m_iLine - udi.posBegin.m_iLine;
		else if(*this >= udi.posBegin && *this <= udi.posEnd) {	// ͈͓
			m_iLine = udi.posBegin.m_iLine;
			m_iChar = udi.posBegin.m_iChar;
		} else {	// I_ݍsƓs
			if(this->m_iLine == udi.posBegin.m_iLine)	// ͈͂1s
				m_iChar -= udi.posEnd.m_iChar - udi.posBegin.m_iChar;
			else {	// ͈͂s
				m_iLine -= udi.posEnd.m_iLine - udi.posBegin.m_iLine;
				m_iChar -= udi.posEnd.m_iChar - udi.posBegin.m_iChar;
			}
		}
	} else
		return;
	UpdateLastCx();
}

/**
 *	̃y[WɈړ
 *	@param cPages	ړy[W
 */
void CEditPoint::PageDown(length_t cPages /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = min(m_pView->GetDocument()->GetLineCount() - 1,
				m_iLine + (m_pView->GetVisibleLineCount() - 1) * cPages);
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	Õy[WɈړ
 *	@param cPages	ړy[W
 */
void CEditPoint::PageUp(length_t cPages /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = (m_iLine > (m_pView->GetVisibleLineCount() - 1) * cPages) ?
		m_iLine - (m_pView->GetVisibleLineCount() - 1) * cPages : 0;
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Paste(signed_length_t cch /* = 0 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || cch == 0) {
		Paste(*this);
		return;
	}

	CEditPoint	pt(*m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cch > 0)
		pt.CharNext(cch);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cch++ != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Paste(pt);
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param pos	1̈ʒu
 */
void CEditPoint::Paste(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;

	length_t	cch;
	char_t*		pwszText = 0;
	const UINT	nAvailableClipFormat = m_pView->CanPaste();

	if(nAvailableClipFormat == 0)
		return;
	if(pos != *this)
		Delete(pos);
	cch = (CClipboard::GetClipboardTextSize(m_pView->m_hWnd) - 1);
	pwszText = new wchar_t[cch + 1];
	CClipboard::ReadClipboardText(m_pView->m_hWnd, pwszText, cch + 1);

	if(nAvailableClipFormat == ::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT))
		InsertBox(pwszText);
	else
		Insert(pwszText);

	delete[] pwszText;
}

/**
 *	͈͓̃eLXgXy[XCfg
 *	@param pos		1̈ʒu
 *	@param nLevel	Cfgx
 *	@return			Cfg <var>pos</var> ړׂʒu
 */
CCharPos CEditPoint::SpaceIndent(const CCharPos& pos, long nLevel /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return Indent(pos, L' ', nLevel);
}

/**
 *	͈͓̃eLXg^uCfg
 *	@param pos		1̈ʒu
 *	@param nLevel	Cfgx
 *	@return			Cfg <var>pos</var> ړׂʒu
 */
CCharPos CEditPoint::TabIndent(const CCharPos& pos, long nLevel /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return Indent(pos, L'\t', nLevel);
}

/**
 *	@brief	O̕ւ
 *
 *	̃\bh͕NX^PʂŃeLXgւB
 *	݈ʒuNX^̐擪łȂΏ͎sB
 *	ւΏۂݍsɖꍇ͎s
 *
 *	@return	ւȂꍇ false
 */
bool CEditPoint::TransposeChars() {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return false;
	if(m_pView->GetDocument()->GetLineLength(m_iLine) < 2	// ւ镶A݈ʒuNX^̐擪łȂ
			|| !CBoundarySearcher::IsFirstCharacterOfCluster(GetCodePoint()))
		return false;

	const CCharPos	posNextCluster = m_pView->m_pBoundarySearcher->SearchFirstCharacterOfCluster(*this, true);
	if(posNextCluster.m_iLine != m_iLine	// ̃NX^sɖ
			|| posNextCluster == *this)		// ʒu
		return false;
	const CCharPos	posPrevCluster = m_pView->m_pBoundarySearcher->SearchFirstCharacterOfCluster(*this, false);
	if(posPrevCluster.m_iLine != m_iLine	// ÕNX^sɖ
			|| posPrevCluster == *this)		// ʒu
		return false;

	const string_t	str = GetText(posNextCluster);
	Delete(posNextCluster);
	m_iChar = posPrevCluster.m_iChar;
	Insert(str);

	return true;
}

/**
 *	ݍsƎ̍s (ݍsŏIs̏ꍇ͑O̍s) ւB
 *	sR[h͌Ȃ
 *	@param	ւȂꍇ false
 */
bool CEditPoint::TransposeLines() {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return false;

	const CEditDoc*	pDocument = m_pView->GetDocument();
	const length_t	cLines = pDocument->GetLineCount();

	if(cLines < 2)	// 1s
		return false;

	const length_t	iOrgLine = m_iLine;
	const length_t	iOrgChar = m_iChar;

	if(m_iLine == cLines - 1)
		--m_iLine;

	const string_t	str1 = pDocument->GetLine(m_iLine);
	const string_t	str2 = pDocument->GetLine(m_iLine + 1);

	m_iChar = 0;
	if(!str1.empty())
		Delete(str1.length(), UB_UTF16);
	if(!str2.empty()) {
		++m_iLine;
		Delete(str2.length(), UB_UTF16);
		--m_iLine;
	}
	if(!str2.empty())
		Insert(str2);
	++m_iLine;
	if(!str1.empty()) {
		m_iChar = 0;
		Insert(str1);
	}
	MoveToPoint(CCharPos((iOrgLine != cLines - 1) ? m_iLine : m_iLine - 1, iOrgChar));

	return true;
}

/**
 *	@brief	O̒Pւ
 *
 *	ւΏۂݍsɖꍇA͎s (̍s̒PƂ̌͋NȂ)
 *
 *	@return	ւȂꍇ false
 */
bool CEditPoint::TransposeWords() {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return false;
	const string_t	strLine = m_pView->GetDocument()->GetLine(m_iLine);
	if(strLine.length() < 2 || m_iChar == strLine.length())
		return false;

	// ւ2̒P̊JnʒuATPʒu߂B
	// O2_̓Aǂ炩1݈ʒuƓɂȂ\
	const BoundaryPosition	BP_WORDHEAD = static_cast<BoundaryPosition>(BP_START | BP_ALPHANUM | BP_NOANOTHERLINE);
	const BoundaryPosition	BP_WORDEND = static_cast<BoundaryPosition>(BP_END | BP_ALPHANUM | BP_NOANOTHERLINE);
	const CBoundarySearcher&	searcher = *m_pView->m_pBoundarySearcher;
	const CCharPos	pos1stWordHead = searcher.SearchWordBoundary(CCharPos(m_iLine, m_iChar), false, BP_WORDHEAD);
	const CCharPos	pos1stWordEnd = searcher.SearchWordBoundary(*this, true, BP_WORDEND);

	if(m_iLine != pos1stWordHead.m_iLine || m_iLine != pos1stWordEnd.m_iLine)	// PꋫEsɖ
		return false;
	if(*this < pos1stWordHead || *this > pos1stWordEnd)	// ݈ʒuPłȂ
		return false;

	const CCharPos	pos2ndWordEnd = searcher.SearchWordBoundary(pos1stWordEnd, true, BP_WORDEND);

	if(m_iLine != pos2ndWordEnd.m_iLine)	// Ώۂsɖ
		return false;

	const CCharPos	pos2ndWordHead = searcher.SearchWordBoundary(pos1stWordEnd, true, BP_WORDHEAD);

	const length_t	iOrgChar = m_iChar;
	m_iChar = pos1stWordHead.m_iChar;
	const string_t	str1 = GetText(pos1stWordEnd);
	Delete(pos1stWordEnd);
	m_iChar = pos2ndWordHead.m_iChar - (pos1stWordEnd.m_iChar - pos1stWordHead.m_iChar);
	Insert(str1);
	const string_t	str2 = GetText(CCharPos(m_iLine, m_iChar + (pos2ndWordEnd.m_iChar - pos2ndWordHead.m_iChar)));
	Delete(CCharPos(m_iLine, m_iChar + (pos2ndWordEnd.m_iChar - pos2ndWordHead.m_iChar)));
	m_iChar = pos1stWordHead.m_iChar;
	Insert(str2);
	MoveToPoint(CCharPos(m_iLine, iOrgChar + (pos2ndWordEnd.m_iChar - pos1stWordEnd.m_iChar)));

	return true;
}

///	m_cxLast ݈ʒuɍXV
void CEditPoint::UpdateLastCx() {
	AssertValid();
	m_cxLast = m_pView->PosFromChar(*this).x
				+ m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio * m_pView->GetAvgCharWidth()
				- m_pView->m_layoutInfo.nLeftTabWidth/* + 1*/;
}

/**
 *	̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordEndNext(length_t cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, true, BP_END);
	UpdateLastCx();
}

/**
 *	O̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordEndPrev(length_t cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, false, BP_END);
	UpdateLastCx();
}

/**
 *	̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordNext(length_t cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, true, BP_START);
	UpdateLastCx();
}

/**
 *	O̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordPrev(length_t cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, false, BP_START);
	UpdateLastCx();
}


// CVisibleEditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param view	Ώۂ̃r[
 */
CVisibleEditPoint::CVisibleEditPoint(CEditView& view) : CEditPoint(view) {
}

/**
 *	Rs[RXgN^
 *	@param rhs	E
 */
CVisibleEditPoint::CVisibleEditPoint(const CVisibleEditPoint& rhs) : CEditPoint(*rhs.m_pView) {
	m_iLine = rhs.m_iLine;
	m_iChar = rhs.m_iChar;
	m_bSyncWithOtherEdit = rhs.m_bSyncWithOtherEdit;
	m_cxLast = rhs.m_cxLast;
}

///	fXgN^
CVisibleEditPoint::~CVisibleEditPoint() {
}

///	CCharPos ւ̌^ϊZq
CVisibleEditPoint::operator CCharPos() const {
	AssertValid();
	return CCharPos(m_iLine, m_iChar);
}

///	Zq
CVisibleEditPoint& CVisibleEditPoint::operator =(const CCharPos& rhs) {
	AssertValid();

	m_iLine = rhs.m_iLine;
	m_iChar = rhs.m_iChar;
	return *this;
}

///	@see	CEditPoint::OnUpdateDocument
void CVisibleEditPoint::OnUpdateDocument(const TUpdateInfo& udi) {
	AssertValid();

	CEditPoint::OnUpdateDocument(udi);
}

/* [EOF] */