// EditDoc.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditDoc.h"
#include <MAPI.h>	// MAPISendMail
#include "../../Manah/WaitCursor.h"
#include "../../Armaiti/ComBasic.h"
#include <algorithm>	// std::for_each

using namespace Ascension;
using namespace Ascension::Private;
using namespace Ascension::Encodings;
using Ascension::CEditDoc::CUndoManager;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Windows::IO;
using namespace Manah::Text;
using namespace Armaiti;
using namespace std;


// CInsertOperation class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CInsertOperation::CInsertOperation(const CCharPos& pos, const string_t& strText) : m_pos(pos), m_strText(strText) {
}

/// }̍Đ
inline void CInsertOperation::Execute(CEditDoc& document) {
	AssertValid();

	VIEW_POSITION	pos = document.GetFirstViewPosition();
	CView*			pView;

	while(0 != (pView = document.GetNextView(pos))) {
		if(::GetFocus() == pView->GetSafeHwnd())
			break;
	}
	document.InsertText(pView, m_pos, m_strText);
}

/// 폜͏ɌłȂ
inline bool CInsertOperation::IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const {
	AssertValid();
	return false;
}

/// 폜͏ɌłȂ
inline bool CInsertOperation::IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const {
	AssertValid();
	return false;
}


// CDeleteOperation class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CDeleteOperation::CDeleteOperation(
		const CCharPos& posBegin, const CCharPos& posEnd) : m_posBegin(posBegin), m_posEnd(posEnd) {
}

/// 폜̍Đ
inline void CDeleteOperation::Execute(CEditDoc& document) {
	AssertValid();

	VIEW_POSITION	pos = document.GetFirstViewPosition();
	CView*			pView;

	while(0 != (pView = document.GetNextView(pos))) {
		if(::GetFocus() == pView->GetSafeHwnd())
			break;
	}
	document.DeleteText(pView, m_posBegin, m_posEnd);
}

/// ̑w肳ꂽPʂɌ
inline bool CDeleteOperation::IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const {
	AssertValid();
	return false;
}

/// ̑w肳ꂽPʂɌ
inline bool CDeleteOperation::IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const {
	AssertValid();

	if(m_posEnd.m_iChar == 0 || m_posEnd != postOperation.m_posBegin)
		return false;
	else {
/*		const CEditView*	pView = reinterpret_cast<CEditView*>(*document.GetFirstViewPosition());
		const CLexer*		pView->GetLexer();
		const string_t&		strLine = document.GetLine(m_posEnd.m_iLine);
		const CodePoint		cp = (m_posEnd.m_iChar == 1
				|| !IsUTF16LowSurrogate(strLine[m_posEnd.m_iChar])
				|| !IsUTF16LowSurrogate(strLine[m_posEnd.m_iChar - 1])) ? strLine[m_posEnd.m_iChar]
				: DecodeUTF16SurrogatePairToCodePoint(strLine.c_str() + m_posEnd.m_iChar - 1, 2);
		const CodePoint		cp = DecodeUTF16SurrogatePairToCodePoint(
				strLine.c_str() + m_posEnd.m_iChar, strLine.length() - m_posEnd.m_iChar);
*/
		// Ō̑Pʂ̍Ō̑Ɍ (폜͈͂g)
		const_cast<CDeleteOperation*>(this)->m_posEnd = postOperation.m_posEnd;
		return true;
	}
}


// COperationUnit class implementation
/////////////////////////////////////////////////////////////////////////////

/// fXgN^
inline COperationUnit::~COperationUnit() {
	while(!m_operations.empty()) {
		delete m_operations.top();
		m_operations.pop();
	}
}

/**
 *	Pʂ̎sB\bhďoケ̃IuWFNg͖ɂȂ
 *	@param document	ΏۃhLg
 */
inline void COperationUnit::Execute(CEditDoc& document) {
	AssertValid();
	while(!m_operations.empty()) {	// SĂ̑s
		m_operations.top()->Execute(document);
		delete m_operations.top();
		m_operations.pop();
	}
}

/// 1̑|bv
inline IOperation& COperationUnit::Pop() {
	AssertValid();
	IOperation*	p = m_operations.top();
	m_operations.pop();
	return *p;
}

/// 1̑vbV
inline void COperationUnit::Push(CInsertOperation& operation, const CEditDoc& document) {
	AssertValid();
	m_operations.push(&operation);
}

///	1̑vbV (<var>operation</var> ͂̃\bhj󂷂\̂Ōďo̓ANZX֎~)
inline void COperationUnit::Push(CDeleteOperation& operation, const CEditDoc& document) {
	AssertValid();

	// Ȏ폜ł΁A͈͂g傷邱Ƃ1ɂ܂Ƃ߂悤Ƃ
	if(!m_operations.empty() && m_operations.top()->IsConcatenatable(operation, document)) {
		delete &operation;
		return;
	}
	m_operations.push(&operation);
}

/// 擪̑擾
inline IOperation& COperationUnit::Top() const {
	AssertValid();
	return *m_operations.top();
}


// CUndoManager class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CUndoManager::CUndoManager(CEditDoc& document)
		: m_document(document), m_bVirtual(false), m_pVirtualUnit(0), m_pLastUnit(0), m_pSavedOperation(0) {
}

/// fXgN^
inline CUndoManager::~CUndoManager() {
	Clear();
}

/// AhD/hDX^bNɂ
inline void CUndoManager::Clear() {
	m_pLastUnit = 0;
	m_pSavedOperation = 0;
	while(!m_undoStack.empty()) {
		delete m_undoStack.top();
		m_undoStack.pop();
	}
	while(!m_redoStack.empty()) {
		delete m_redoStack.top();
		m_redoStack.pop();
	}
}

/// hD\ȉ񐔂Ԃ
inline size_t CUndoManager::GetRedoBufferLength() const {
	return m_redoStack.size();
}

/// AhD\ȉ񐔂Ԃ
inline size_t CUndoManager::GetUndoBufferLength() const {
	return m_undoStack.size();
}

/// Oۑ瑀삪ǉA폜ꂽԂ
inline bool CUndoManager::IsModifiedSinceLastSave() const {
	if(m_undoStack.empty())
		return m_pSavedOperation != 0;
	return m_pSavedOperation != &m_undoStack.top()->Top();
}

/// ۑꂽƂʒm
inline void CUndoManager::OnSave() {
	m_pSavedOperation = !m_undoStack.empty() ? &m_undoStack.top()->Top() : 0;
}

/**
 *	1̑AhDX^bNɒǉ
 *	@param operation	ǉ鑀
 *	@param bConcatPrev	Ȏƌ邩ǂ
 */
template<class Operation>
inline void CUndoManager::PushUndoBuffer(Operation& operation, bool bConcatPrev) {
	// hDX^bNɂ
	if(!m_bVirtual) {
		while(!m_redoStack.empty()) {
			delete m_redoStack.top();
			m_redoStack.pop();
		}
	}

	if(m_bVirtual) {	// z쎞̓X^bNւ̒ǉx
		if(m_pVirtualUnit == 0)	// 
			m_pVirtualUnit = new COperationUnit();
		m_pVirtualUnit->Push(operation, m_document);
	} else if(bConcatPrev && m_pLastUnit != 0)	// Ō̑PʂɌ
		m_pLastUnit->Push(operation, m_document);
	else {
		COperationUnit*	pUnit = new COperationUnit();
		pUnit->Push(operation, m_document);
		m_undoStack.push(pUnit);
		m_pLastUnit = pUnit;
	}
}

/// hD1s
inline void CUndoManager::Redo() {
	if(m_redoStack.empty())
		return;

	COperationUnit*	pUnit = m_redoStack.top();
	m_redoStack.pop();
	m_bVirtual = true;				// zJn
	pUnit->Execute(m_document);
	m_undoStack.push(m_pVirtualUnit);	// zPʂAhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	delete pUnit;
}

/// AhD1s
inline void CUndoManager::Undo() {
	if(m_undoStack.empty())
		return;

	COperationUnit*	pUnit = m_undoStack.top();
	m_undoStack.pop();
	m_bVirtual = true;				// zJn
	pUnit->Execute(m_document);
	m_redoStack.push(m_pVirtualUnit);	// zPʂhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	delete pUnit;
}


// CEditDoc class implementation
/////////////////////////////////////////////////////////////////////////////

const char_t CEditDoc::m_wszBreakChars[6] = {		// U+0085 Ƀeg VC6 ŃG[ɂȂ
	0x000A, 0x000D, 0x0085, 0x2028, 0x2029, 0x0000	// (C99 ł 0x00A0 ȉ̕ \uxxxx `Ŏw肷邱Ƃ
};													// oȂ炵 C++ Ƃ̊֘A͕s)

map<UINT, CEditDoc*> CEditDoc::m_documents;

/// RXgN^
CEditDoc::CEditDoc(Ascension::CEditController* pController /* = 0 */) :
		CDocument((CController*)pController), m_bIgnoreViews(false), m_bReadOnly(false),
			m_fileOpenMode(FOM_DENYNONE), m_nCodePage(::GetACP()), m_breakType(BT_CRLF), m_groupingState(UGS_NONE),
		m_bOnceUndoBufferCleared(false), m_bVirtualOperating(false),
		m_itCache_(m_lines.end()), m_itCache(m_lines.end()) {
	m_lines.push_back(CEditDocLine());
	m_pUndoManager = new CUndoManager(*this);
	m_nTimerId = ::SetTimer(0, 0, 1000, CEditDoc::TimerProc);
	CEditDoc::m_documents[m_nTimerId] = this;
}

/// fXgN^
CEditDoc::~CEditDoc() {
	CloseDocument();
	delete m_pUndoManager;
	::KillTimer(0, m_nTimerId);
	CEditDoc::m_documents.erase(m_nTimerId);
}

/// t@C̍ŏIXV`FbN
void CEditDoc::_CheckFileLastWriteTime() {
	AssertValid();

	static bool	bChecking = false;

	if(m_strPathName.empty() || bChecking)
		return;
	bChecking = true;

	HANDLE				hFind;
	WIN32_FIND_DATAW	wfd;

	hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
	if(hFind == INVALID_HANDLE_VALUE) {
		return;
		bChecking = false;
	}
	if(::CompareFileTime(&m_lastWriteTime, &wfd.ftLastWriteTime) == -1) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		for(set<IEditDocEventListener*>::iterator it
				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
			(*it)->OnDocumentOverwrittenByOtherProcess(this);
		// ʒmɃt@CXV邩Ȃ̂ŁA1xŐṼf[^
		::FindClose(hFind);
		hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
		m_lastWriteTime = wfd.ftLastWriteTime;
	}
	::FindClose(hFind);
	bChecking = false;
}

/**
 *	݊JĂt@CRs[
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
OperationStatus CEditDoc::CopyCurrentFile(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(toBoolean(::PathFileExistsW(pwszDestination)))
		return OPS_ALREADYEXISTS;

	OperationStatus	ops = OPS_OK;
	UINT			nReopenMode = CFile::modeNoTruncate;

	switch(static_cast<int>(m_fileOpenMode)) {
		case FOM_DENYWRITE:		nReopenMode |= CFile::modeRead | CFile::shareDenyWrite;		break;
		case FOM_DENYREAD:		nReopenMode |= CFile::modeReadWrite | CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:	nReopenMode |= CFile::modeRead | CFile::shareDenyNone;		break;
	}

	m_file.Close();
	if(!::CopyFileW(m_strPathName.c_str(), pwszDestination, true))
		ops = OPS_UNKNOWNERROR;

	// t@CJ
	if(m_bReadOnly) {
		if(m_file.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false))
			m_fileOpenMode = FOM_ASREADONLY;
		else
			return OPS_CANNOTOPEN;
	} else if(!m_file.Open(m_strPathName, nReopenMode, false)) {
		if(m_file.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
			m_fileOpenMode = FOM_ASREADONLY;
			if(!m_bReadOnly) {
				ops = OPS_OPENEDASREADONLY;
				m_bReadOnly = true;
			}
		} else
			return OPS_CANNOTOPEN;
	}
	return ops;
}

/**
 *	݊JĂt@CݔɈړ
 *
 *	̃\bhsƃt@C͕
 *	@return	
 */
OperationStatus CEditDoc::DeleteCurrentFile() {
	AssertValid();

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(m_bReadOnly)
		return OPS_MODEISREADONLY;

	OperationStatus	ops = OPS_OK;
	uint			nShareMode = 0;
	wchar_t			wszPath[MAX_PATH];
	SHFILEOPSTRUCTW	shfos = {::GetDesktopWindow(), FO_DELETE, wszPath, 0, FOF_ALLOWUNDO, 0, 0, 0};

	switch(static_cast<int>(m_fileOpenMode)) {
		case FOM_DENYWRITE:	nShareMode = CFile::shareDenyWrite;	break;
		case FOM_DENYREAD:	nShareMode = CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:nShareMode = CFile::shareDenyNone;	break;
	}

	wcscpy(wszPath, m_strPathName.c_str());
	*(wszPath + wcslen(wszPath) + 1) = 0;

	m_file.Close();
	::SHFileOperationW(&shfos);
	if(toBoolean(::PathFileExistsW(wszPath))) {	// s (SHFileExistsW ̖߂l͂ǂMpł)
		if(shfos.fAnyOperationsAborted)
			ops = OPS_ABORTED;

		// t@CJ
		if(!m_file.Open(m_strPathName, nShareMode | CFile::modeReadWrite | CFile::modeNoTruncate, false)) {
			if(m_file.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
				m_fileOpenMode = FOM_ASREADONLY;
				if(!m_bReadOnly) {
					ops = OPS_OPENEDASREADONLY;
					m_bReadOnly = true;
				}
			} else
				ops = OPS_CANNOTOPEN;
		}
	}

	return ops;
}

/**
 *	hLgeLXg̎w͈͂폜
 *
 *	̃\bh posBegin  posEnd ̓Lbguׂ
 *	UpdateAllViews Ăяȏ3ɁAłȂ2ɓnB
 *	̃\bhĂяoƍXVtOZbgB
 *	pSender ͂̃\bhĂяor[ null ł悢B
 *	̃r[ OnUpdate ͌ĂяoȂ
 *	@param pSender	hLgɏvr[
 *	@param posBegin	폜Jn_
 *	@param posEnd	폜I_
 *	@return			IɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::DeleteText(CObject* pSender,
		const CCharPos& posBegin, const CCharPos& posEnd) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();

	const CCharPos&	posABegin = min(posBegin, posEnd);	// n_
	const CCharPos&	posAEnd = max(posBegin, posEnd);	// I_
	string_t		strDeleted;							// 폜 (sɂȂƂ݂͌̉s})

	if(posBegin.m_iLine == posEnd.m_iLine) {	// Ώۂ1sȓ
		const CEditDocLine*	pLine = GetLineInfo(posEnd.m_iLine);
		string_t&			strLine = const_cast<string_t&>(GetLine(posEnd.m_iLine));

		++const_cast<CEditDocLine*>(pLine)->m_cOperationHistory;
		strDeleted = strLine.substr(posABegin.m_iChar, posAEnd.m_iChar - posABegin.m_iChar);
		strLine.erase(posABegin.m_iChar, posAEnd.m_iChar - posABegin.m_iChar);
	} else {							// Ώۂs
		string_t&	strLine = const_cast<string_t&>(GetLine(posABegin.m_iLine));
		string_t	strTail;
		strDeleted = strLine.substr(posABegin.m_iChar);
		strLine.erase(posABegin.m_iChar);

		// 폜镔ۑ폜
		CEditDocLineList::iterator	it = _GetInternalLineIterator(posABegin.m_iLine), itNext;
		CEditDocLineList::iterator	itFirstLine = it;
		BreakType					btLastLine;
		strDeleted += CEditDoc::GetBreakString(it->m_breakType);
		itNext = ++it;
		for(length_t iLine = posABegin.m_iLine + 1; iLine < posAEnd.m_iLine + 1; ++iLine) {
			strDeleted +=
				((iLine != posAEnd.m_iLine) ? it->m_strLine : it->m_strLine.substr(0, posAEnd.m_iChar));
			if(iLine != posAEnd.m_iLine)
				strDeleted += GetBreakString(it->m_breakType);
			++itNext;
			assert(itNext != 0);
			if(iLine == posAEnd.m_iLine) {	// 폜Is
				strTail = it->m_strLine.substr(posAEnd.m_iChar);
				btLastLine = it->m_breakType;
			}
			m_lines.erase(it);
			it = itNext;
		}

		// 폜̑Oq
		itFirstLine->m_breakType = btLastLine;
		++itFirstLine->m_cOperationHistory;
		if(!strTail.empty())
			strLine += strTail;
	}

	m_itCache_ = m_lines.end();	// ŃLbV𖳌ɂĂ
	m_itCache = m_lines.end();

	CInsertOperation*	pNewOperation = new CInsertOperation(posABegin, strDeleted);
	m_bModified = true;
	m_pUndoManager->PushUndoBuffer(*pNewOperation, m_groupingState == UGS_WAITFORCONTINUEEDIT);
	if(m_groupingState == UGS_WAITFORFIRSTEDIT)
		m_groupingState = UGS_WAITFORCONTINUEEDIT;

	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		m_updateInfo.summary = US_OPERATION_DELETE;
		m_updateInfo.posBegin = posABegin;
		m_updateInfo.posEnd = posAEnd;
		m_updateInfo.posResult = posABegin;
		UpdateAllViews(pSender, 0, this);
	}
	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();

	return posABegin;
}

/**
 *	Ss (hLgS) 擾
 *	@param strText	i[
 */
void CEditDoc::GetAllLines(string_t& strText) const {
	AssertValid();
	LineIterator	it;
	length_t		cchAllLines = 0;

	for(it = m_lines.begin(); it != m_lines.end(); ++it)
		cchAllLines += it->m_strLine.length() + CEditDoc::GetBreakString(it->m_breakType).length();
	strText.reserve(cchAllLines);
	for(it = m_lines.begin(); it != m_lines.end(); ++it)
		strText += it->m_strLine + CEditDoc::GetBreakString(it->m_breakType);
}

/// hLg̕ҏW̕ԂBsɂ݂͌̉sR[hgp
length_t CEditDoc::GetDocumentLength() const {
	AssertValid();

	length_t		cch = 0;
	LineIterator	it;
	int				cchBreak = (m_breakType == BT_CRLF) ? 2 : 1;

	for(it = m_lines.begin(); it != m_lines.end(); ++it)
		cch += it->m_strLine.length() + cchBreak;
	cch -= cchBreak;

	return cch;
}

/// ҏW\ȓpsCe[^̎擾
CEditDocLineList::iterator CEditDoc::_GetInternalLineIterator(length_t iLine) const throw(out_of_range) {
	AssertValid();

	CEditDocLineList&			lines = const_cast<CEditDoc*>(this)->m_lines;
	length_t					i, cch = m_lines.size();
	CEditDocLineList::iterator	it;

	if(iLine >= cch)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache_ == lines.end()) {	// LbVgȂꍇ
		if(iLine <= cch / 2)
			for(i = 0, it = lines.begin(); i < iLine; ++i, ++it);
		else
			for(i = cch, it = lines.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache_, iLine))
			for(i = 0, it = lines.begin(); i < iLine; ++i, ++it);
		else if(cch - iLine < dif(m_iLineCache_, iLine))
			for(i = cch, it = lines.end(); i > iLine; --i, --it);
		else if(m_iLineCache_ < iLine)
			for(i = m_iLineCache_, it = m_itCache_; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache_, it = m_itCache_; i > iLine; --i, --it);
	}

	m_iLineCache_ = iLine;
	m_itCache_ = it;
	return it;
}

/**
 *	ws牽ڂԂ
 *	@param iLine			ׂs
 *	@param bIncludeBreak	s𕶎ƂĐ邩ǂ
 *	@throw out_of_range		<var>iLine</var> ȂꍇX[
 */
length_t CEditDoc::GetLineIndex(length_t iLine, bool bIncludeBreak) const throw(out_of_range) {
	AssertValid();

	if(iLine >= m_lines.size())
		throw out_of_range("Specified line not found.");

	length_t							iOffset = 0;
	list<CEditDocLine>::const_iterator	it = m_lines.begin();
	for(length_t i = 0; i < iLine; ++it, ++i) {
		iOffset += it->m_strLine.length();
		iOffset += bIncludeBreak ? CEditDoc::GetBreakString(it->m_breakType).length() : 0;
	}
	return iOffset;
}

/// sCe[^̎擾
LineIterator CEditDoc::GetLineIterator(length_t iLine) const throw(out_of_range) {
	AssertValid();

	length_t		i, cch = m_lines.size();
	LineIterator	it;

	if(iLine >= cch)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache == m_lines.end()) {	// LbVgȂꍇ
		if(iLine <= cch / 2)
			for(i = 0, it = m_lines.begin(); i < iLine; ++i, ++it);
		else
			for(i = cch, it = m_lines.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache, iLine))
			for(i = 0, it = m_lines.begin(); i < iLine; ++i, ++it);
		else if(cch - iLine < dif(m_iLineCache, iLine))
			for(i = cch, it = m_lines.end(); i > iLine; --i, --it);
		else if(m_iLineCache < iLine)
			for(i = m_iLineCache, it = m_itCache; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache, it = m_itCache; i > iLine; --i, --it);
	}

	m_iLineCache = iLine;
	m_itCache = it;
	return it;
}

/// hLg
void CEditDoc::InitiateDocument() {
	AssertValid();

	m_lines.clear();
	m_lines.push_back(CEditDocLine());
	m_itCache_ = m_lines.end();
	m_itCache = m_lines.end();
	m_bModified = false;
	ClearUndoBuffer();
	m_groupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
}

/**
 *	wʒuɃeLXg}
 *
 *	̃\bh͑}eLXg̏I[ʒuԂB
 *	܂AI[ʒu͂̃\bh UpdateAllViews \bhĂяȏ2A3ɂgpB
 *	̃\bhĂяoƍXVtOZbgB
 *	pSender ͂̃\bhĂяor[ null ł悢B
 *	̃r[ OnUpdate ͌ĂяoȂ
 *	@param pSender	̏vr[
 *	@param pos		}ʒu
 *	@param strText	}镶
 *	@return			ɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::InsertText(CObject* pSender,
		const CCharPos& pos, const string_t& strText) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();

	length_t			iLast = strText.find_first_of(CEditDoc::m_wszBreakChars);
	length_t			iNext;
	CCharPos			posResult;
	const CEditDocLine*	pLastLine = GetLineInfo(pos.m_iLine);
	string_t&			strLine = const_cast<string_t&>(pLastLine->m_strLine);

	if(iLast == wstring::npos) {	// ͂ɉsꍇ
		strLine.insert(pos.m_iChar, strText);
		++const_cast<CEditDocLine*>(pLastLine)->m_cOperationHistory;
		posResult.m_iLine = pos.m_iLine;
		posResult.m_iChar = pos.m_iChar + strText.length();
	} else {	// ͂ɉsꍇ
		length_t		iLine = pos.m_iLine;
		CEditDocLineList::iterator	it = _GetInternalLineIterator(pos.m_iLine);
		string_t		strInsert = strText + it->m_strLine.substr(pos.m_iChar);
		BreakType		bt;
		BreakType		btFirstLine = it->m_breakType;	// 擪s̉s (}Ԍɕt)

		posResult.m_iLine = pos.m_iLine;
		posResult.m_iChar = strText.length() - strText.find_last_of(CEditDoc::m_wszBreakChars) - 1;

		// 擪s̒u
		strLine.replace(pos.m_iChar, strLine.length() - pos.m_iChar, strInsert.substr(0, iLast));
		if(strInsert[iLast] == L'\r' && iLast + 1 != strInsert.length() && strInsert[iLast + 1] == L'\n') {
			iLast += 2;
			it->m_breakType = BT_CRLF;
		} else {
			switch(strInsert[iLast]) {
			case L'\n':		it->m_breakType = BT_LF;	break;
			case L'\r':		it->m_breakType = BT_CR;	break;
			case 0x0085:	it->m_breakType = BT_NEL;	break;
			case L'\x2028':	it->m_breakType = BT_LS;	break;
			case L'\x2029':	it->m_breakType = BT_PS;	break;
			}
			++iLast;
		}
		++it->m_cOperationHistory;
		++iLine;
		++it;
		++posResult.m_iLine;

		while(true) {	// sƂɍs؂
			iNext = strInsert.find_first_of(CEditDoc::m_wszBreakChars, iLast);
			if(iNext != wstring::npos) {
				if(strInsert[iNext] == L'\r' && iNext + 1 != strInsert.length() && strInsert[iNext + 1] == L'\n') {
					iNext += 2;
					bt = BT_CRLF;
				} else {
					switch(strInsert[iNext]) {
					case L'\n':		bt = BT_LF;	break;
					case L'\r':		bt = BT_CR;	break;
					case 0x0085:	bt = BT_NEL;break;
					case L'\x2028':	bt = BT_LS;	break;
					case L'\x2029':	bt = BT_PS;	break;
					}
					++iNext;
				}
				// s쐬A}
				it = m_lines.insert(it,
					CEditDocLine(strInsert.substr(iLast, iNext - iLast - ((bt == BT_CRLF) ? 2 : 1)), bt, true));
				++it;
				++iLine;
				++posResult.m_iLine;
				iLast = iNext;
			} else {	// ̍sōŌ
				m_lines.insert(it, CEditDocLine(strInsert.substr(iLast), btFirstLine, true));
				break;
			}
		}

		m_itCache_ = m_lines.end();	// ŃLbV𖳌ɂĂ
		m_itCache = m_lines.end();
	}

	CDeleteOperation*	pNewOperation = new CDeleteOperation(pos, posResult);
	m_bModified = true;
	m_pUndoManager->PushUndoBuffer(*pNewOperation, m_groupingState == UGS_WAITFORCONTINUEEDIT);
	if(m_groupingState == UGS_WAITFORFIRSTEDIT)
		m_groupingState = UGS_WAITFORCONTINUEEDIT;

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		m_updateInfo.summary = US_OPERATION_INSERT;
		m_updateInfo.posBegin = pos;
		m_updateInfo.posEnd = pos;
		m_updateInfo.posResult = posResult;
		UpdateAllViews(pSender, 0, this);
	}

	return posResult;
}

/**
 *	@brief	t@ChLgǂݍ
 *
 *	̃\bh̓V[gJbgȂ
 *
 *	@param strPathName	t@CpX
 *	@param fom			r[hȂ
 *	@param cp			R[hy[W (ȗƎ)
 *	@return				ہBStreamStatus Q
 */
StreamStatus CEditDoc::LoadDocument(const wstring& strPathName,
		FileOpenMode fom, CodePage cp /* = CPEX_LOCALE_AUTODETECT */) {
//	CTimer tm(L"LoadDocument");	// 2.86s / 1MB
	AssertValid();

	CEncoderFactory&	encoderFactory = CEncoderFactory::GetInstance();

	if(!encoderFactory.IsValidCodePage(cp))
		return SS_ILLEGALCODEPAGE;

	CWaitCursor		wc;
	StreamStatus	ss = SS_OK;
	HGLOBAL			hGlobal = 0, hGlobal2 = 0;
	char*			pszBuffer = 0;		// obt@
	char_t*			pwszBuffer = 0;
	char_t*			pwszFirstBreak = 0;	// ŏɌꂽs
	DWORD			dwFileSize;			// t@CTCY
	DWORD			dwRead;				// ۂɓǂݎf[^
	CCharPos		posLast(0, 0);		// ɕǉʒu

	try {
		m_file.Close();
		m_bReadOnly = false;
		m_fileOpenMode = fom;
		if(fom == FOM_ASREADONLY) {
			m_file.Open(strPathName.c_str(), CFile::modeRead | CFile::shareDenyNone);
			m_bReadOnly = true;
		} else if(!m_file.Open(strPathName.c_str(), CFile::modeReadWrite | CFile::shareDenyNone, false)) {
			ss = SS_READ_READONLY;
			m_file.Open(strPathName.c_str(), CFile::modeRead | CFile::shareDenyNone);
			m_bReadOnly = true;
		}
		m_file.GetFileTime(0, 0, &m_lastWriteTime);
		dwFileSize = m_file.GetFileSize(0);	// 4GB ̃XNvgȂ񂩖낤
		hGlobal = ::GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
		pszBuffer = static_cast<char*>(::GlobalLock(hGlobal));

		if(dwFileSize != 0)
			dwRead = m_file.Read(pszBuffer, dwFileSize);
	} catch(CFileException&) {
		if(pszBuffer != 0)
			::GlobalUnlock(hGlobal);
		if(hGlobal != 0)
			::GlobalFree(hGlobal);
		return SS_READ_NOEXISTS;
	}

	m_file.Close();

	// R[hϊ
	if(dwFileSize != 0) {
		cp = encoderFactory.DetectCodePage(pszBuffer, min(dwRead, 4UL * 1024), cp);	// xƐM̃g[h͂

		CEncoder*		pEncoder = encoderFactory.CreateEncoder(cp);
		assert(pEncoder != 0);
		size_t			cchDest = 1 * dwRead;
		const uchar*	pszBom;
		size_t			cbBom;

		switch(cp) {
		case CP_UTF8:				pszBom = Encodings::szBom_Utf8; cbBom = 3; break;
		case CPEX_UNICODE_UTF16LE:	pszBom = Encodings::szBom_Utf16LE; cbBom = 2; break;
		case CPEX_UNICODE_UTF16BE:	pszBom = Encodings::szBom_Utf16BE; cbBom = 2; break;
		case CPEX_UNICODE_UTF32LE:	pszBom = Encodings::szBom_Utf32LE; cbBom = 4; break;
		case CPEX_UNICODE_UTF32BE:	pszBom = Encodings::szBom_Utf32BE; cbBom = 4; break;
		default:					pszBom = 0; cbBom = 0; break;
		}

		hGlobal2 = ::GlobalAlloc(GMEM_MOVEABLE, (cchDest + 1) * sizeof(char_t));
		pwszBuffer = static_cast<wchar_t*>(::GlobalLock(hGlobal2));
		if(cbBom != 0 && dwRead >= cbBom && memcmp(pszBuffer, pszBom, cbBom) == 0)
			cchDest = pEncoder->ConvertToUnicode(pwszBuffer, cchDest, pszBuffer + cbBom, dwRead - cbBom);
		else
			cchDest = pEncoder->ConvertToUnicode(pwszBuffer, cchDest, pszBuffer, dwRead);
		delete pEncoder;
		*(pwszBuffer + cchDest) = 0;

		// sƂɋ؂AXgɒǉĂ
		length_t	iNext, iLast = 0;
		BreakType	bt;
		m_lines.clear();
		m_breakType = BT_AUTO;
		while(true) {
			for(size_t i = iLast; ; ++i) {	// sT
				if(i == cchDest) {
					iNext = -1;
					break;
				} else if(binary_search(CEditDoc::m_wszBreakChars,
						CEditDoc::m_wszBreakChars + _countof(CEditDoc::m_wszBreakChars) - 1, pwszBuffer[i])) {
					iNext = i;
					break;
				}
			}
			if(iNext != -1) {
				// s̔
				switch(pwszBuffer[iNext]) {
				case L'\n':	bt = BT_LF;	break;
				case L'\r':
					bt = (iNext + 1 < cchDest && *(pwszBuffer + iNext + 1) == L'\n') ? BT_CRLF : BT_CR;
					break;
				case 0x0085:	bt = BT_NEL;break;
				case L'\x2028':	bt = BT_LS;	break;
				case L'\x2029':	bt = BT_PS;	break;
				}
				m_lines.push_back(CEditDocLine(wstring(pwszBuffer + iLast, iNext - iLast), bt));
				iLast = iNext + ((bt != BT_CRLF) ? 1 : 2);
				if(m_breakType == BT_AUTO)	// ŏɌꂽs̉sƂ
					m_breakType = bt;
			} else {	// ŏIs
				m_lines.push_back(CEditDocLine(wstring(pwszBuffer + iLast, cchDest - iLast)));
				break;
			}
		}
	} else {	// ̃t@C
		cp = ::GetACP();
		m_lines.clear();
		m_lines.push_back(CEditDocLine());
		InsertText(0, CCharPos(0, 0), L"");
		m_lines.begin()->m_cOperationHistory = 0;
	}

	if(m_breakType == BT_AUTO)
		m_breakType = BT_CRLF;	// [

	m_itCache_ = m_lines.end();
	m_itCache = m_lines.end();

	::GlobalUnlock(hGlobal2);
	::GlobalFree(hGlobal2);
	::GlobalUnlock(hGlobal);
	::GlobalFree(hGlobal);

	// t@C̃bN
	try {
		if(fom == FOM_DENYNONE || fom == FOM_ASREADONLY)
			m_file.Open(strPathName.c_str(), CFile::modeRead | CFile::shareDenyNone);
		else if(fom == FOM_DENYWRITE)
			m_file.Open(strPathName.c_str(), CFile::modeRead | CFile::shareDenyWrite);
		else	/* if(fom == FOM_DENYREAD) */
			m_file.Open(strPathName.c_str(),
				CFile::modeRead | CFile::modeWrite | CFile::shareDenyRead | CFile::shareDenyWrite);
	} catch(CFileException&) {
		ss = SS_LOCKDENIED;
	}

	m_nCodePage = cp;
	ClearUndoBuffer();
	m_bModified = false;
	m_groupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;
	m_strPathName = strPathName.c_str();
	m_strTitle = ::PathFindFileNameW(strPathName.c_str());

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentLoaded));

	SetupAllViews();	// r[ɒʒm

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();

	return ss;
}

/**
 *	݂̊JĂt@Cw肵@ŃbNBǂݎp͖
 *	@param fom	r[hBFOM_DENYWRITE AFOM_DENYREAD ̂ݗL
 *	@return		bNɐ true
 *	@see		CEditDoc::UnlockCurrentFile
 */
bool CEditDoc::LockCurrentFile(FileOpenMode fom) {
	AssertValid();

	if(fom != FOM_DENYWRITE && fom != FOM_DENYREAD)
		return false;
	if(m_strPathName.empty() || m_bReadOnly)
		return false;

	m_file.Close();
	if(m_file.Open(m_strPathName, CFile::modeReadWrite | ((fom == FOM_DENYWRITE) ?
			CFile::shareDenyWrite : CFile::shareDenyRead), false)) {
		m_fileOpenMode = fom;
		return true;
	} else
		return false;
}

/**
 *	݊JĂt@Cړ
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
OperationStatus CEditDoc::MoveCurrentFile(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(::PathFileExistsW(pwszDestination))
		return OPS_ALREADYEXISTS;
	if(m_bReadOnly)
		return OPS_MODEISREADONLY;

	OperationStatus	ops = OPS_OK;
	UINT			nReopenMode = CFile::modeNoTruncate;

	switch(static_cast<int>(m_fileOpenMode)) {
		case FOM_DENYWRITE:		nReopenMode |= CFile::modeRead | CFile::shareDenyWrite;		break;
		case FOM_DENYREAD:		nReopenMode |= CFile::modeReadWrite | CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:	nReopenMode |= CFile::modeRead | CFile::shareDenyNone;		break;
	}

	m_file.Close();
	if(!::MoveFileW(m_strPathName.c_str(), pwszDestination))
		ops = OPS_UNKNOWNERROR;
	else {
		m_strPathName = pwszDestination;
		m_strTitle = ::PathFindFileNameW(pwszDestination);
	}
	// bN悤Ƃ
	if(!m_file.Open(m_strPathName, nReopenMode, false)) {
		if(m_file.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
			m_fileOpenMode = FOM_ASREADONLY;
			if(!m_bReadOnly) {
				ops = OPS_OPENEDASREADONLY;
				m_bReadOnly = true;
			}
		} else
			return OPS_CANNOTOPEN;
	}
	return ops;
}

/**
 *	hD̎s
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
void CEditDoc::Redo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	if(m_pUndoManager->GetRedoBufferLength() == 0)
		return;

	BeginEditCollection();
	m_updateInfo.summary = US_BEGIN_UNDOGROUP;
	UpdateAllViews(this, 0, this);
	m_pUndoManager->Redo();
	EndEditCollection();
	m_updateInfo.summary = US_END_UNDOGROUP;
	UpdateAllViews(this, 0, this);

	if(!m_pUndoManager->IsModifiedSinceLastSave()) {
		m_bModified = false;
		for_each(m_eventListeners.begin(),
			m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//		for(set<IEditDocEventListener*>::iterator it
//				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//			(*it)->OnDocumentModified();
	}
}

/**
 *	hLg̕ۑ
 *	@param strPathName		t@C̃pX
 *	@param sdo				IvV
 *	@param bt				ꂷsR[h
 *	@param cp				R[hy[WBȗƌ݂̃R[hy[Wgp
 *	@return					݌ʁB SS_OK
 */
StreamStatus CEditDoc::SaveDocument(const wstring& strPathName,
		SaveDocumentOption sdo, BreakType bt, UINT cp /* = EXCP_AUTODETECT */) {
	AssertValid();

	CEncoderFactory&	encoderFactory = CEncoderFactory::GetInstance();

	// R[hy[WCXg[Ă邩
	if(!encoderFactory.IsValidCodePage(cp))
		return SS_ILLEGALCODEPAGE;
	if(encoderFactory.IsCodePageForAutoDetection(cp))	// ݂̃R[hy[Wg
		cp = m_nCodePage;

	CWaitCursor		wc;
	StreamStatus	ss = SS_OK;

	// fobOo[W͏ɃobNAbv (㏑̏ꍇ̂)
#ifdef _DEBUG
	if(toBoolean(::PathFileExistsW(strPathName.c_str()))) {
		wchar_t	wszBackupPath[MAX_PATH + 1];
		SHFILEOPSTRUCTW	shfos = {
			0, FO_DELETE, wszBackupPath, 0, FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT, false, 0
		};
		wcscpy(wszBackupPath, strPathName.c_str());
		wcscat(wszBackupPath, L".bak");
		*(wszBackupPath + wcslen(wszBackupPath) + 1) = 0;
		::CopyFileW(strPathName.c_str(), wszBackupPath, false);
		::SHFileOperationW(&shfos);	// ݔɎĂ
	}
#endif

	// Vt@CJ
	try {
		if(m_file.IsOpened())
			m_file.Close();
		m_file.Open(strPathName, CFile::modeReadWrite | CFile::shareDenyWrite | CFile::modeCreate);
	} catch(CFileException&) {	// ߂Ȃꍇ͈ȑÕt@CJȂ
		m_file.Open(m_strPathName, (m_bReadOnly ? CFile::modeRead : CFile::modeReadWrite)
			| CFile::shareDenyWrite | CFile::modeCreate | CFile::modeNoTruncate);
		return SS_UNKNOWNERROR;
	}

	CEncoder*	pEncoder = encoderFactory.CreateEncoder(cp);
	HGLOBAL		hGlobal = 0;
	char*		pszBuffer = 0;

	assert(pEncoder != 0);

	// BOM
	if(toBoolean(sdo & SDO_WRITE_BOM)) {
		switch(cp) {
		case CP_UTF8:				m_file.Write(Encodings::szBom_Utf8, 3); break;
		case CPEX_UNICODE_UTF16LE:	m_file.Write(Encodings::szBom_Utf16LE, 2); break;
		case CPEX_UNICODE_UTF16BE:	m_file.Write(Encodings::szBom_Utf16BE, 2); break;
		case CPEX_UNICODE_UTF32LE:	m_file.Write(Encodings::szBom_Utf32LE, 4); break;
		case CPEX_UNICODE_UTF32BE:	m_file.Write(Encodings::szBom_Utf32BE, 4); break;
		}
	}

	// sR[ȟ
	if(bt != BT_AUTO)
		m_breakType = bt;

	// 1sϊĂ珑
	CEditDocLineList::iterator	it = m_lines.begin();
	length_t					cLine = GetLineCount();	// s
	length_t					cchLine;				// R[hϊO̒
	length_t					len;					// R[hϊ̒
	wstring						strLine;				// 1s

	for(length_t iLine = 0; iLine < cLine; ++iLine, ++it) {
		it->m_cOperationHistory = 0;	// 엚
		if(bt != BT_AUTO)
			it->m_breakType = bt;		// sR[h㏑
		strLine = it->m_strLine;
		if(iLine != cLine - 1)
			strLine += GetBreakString(it->m_breakType);

		// R[h̕ϊ
		cchLine = GetLineLength(iLine);
		if(iLine == cLine - 1) {	// ŏIs
			if(cchLine == 0)
				break;
		} else
			cchLine += (((bt == BT_AUTO) ? it->m_breakType : m_breakType) == BT_CRLF) ? 2 : 1;

		const std::size_t	cBytes = pEncoder->GetMaxCharacterLength() * cchLine;

		hGlobal = ::GlobalAlloc(GHND, cBytes);
		pszBuffer = static_cast<char*>(::GlobalLock(hGlobal));
		len = pEncoder->ConvertFromUnicode(pszBuffer, cBytes, strLine.c_str(), cchLine);
		m_file.Write(pszBuffer, len);
		::GlobalUnlock(hGlobal);
		::GlobalFree(hGlobal);
	}
	delete pEncoder;

	m_file.Close();

	// t@C̃bN
	try {
		if(m_fileOpenMode == FOM_DENYWRITE || m_fileOpenMode == FOM_DENYREAD) {
			if(!LockCurrentFile(m_fileOpenMode))
				ss = SS_LOCKDENIED;
		}
	} catch(CFileException&) {
		ss = SS_LOCKDENIED;
	}

	m_pUndoManager->OnSave();
	m_bModified = false;
	m_bReadOnly = false;
	m_breakType = (bt != BT_AUTO) ? bt : m_breakType;
	m_nCodePage = cp;
	m_strPathName = strPathName;
	m_strTitle = m_strPathName.substr(m_strPathName.rfind(L'\\') + 1);

	// ŏIXV̍XV
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
	if(hFind != INVALID_HANDLE_VALUE) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		::FindClose(hFind);
	}

	// r[ɒʒm
	m_updateInfo.summary = US_SAVEDOCUMENT;
	UpdateAllViews(this, 0, this);

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
	return ss;
}

/**
 *	݂̃t@C[֑M
 *	@param bAsAttachment	Ytt@CƂđM邩ǂBYtt@Cɂꍇ
 *							݂̕ύX͔fȂB{ƂđMꍇ݂͌̃hLggp
 *	@param bShowDialog		[UI_CAO\邩ǂ
 *	@return					
 */
bool CEditDoc::SendCurrentFile(bool bAsAttachment, bool bShowDialog /* = true */) {
	AssertValid();

	if(bAsAttachment && m_strPathName.empty())
		return false;

	CWaitCursor	wc;
	HMODULE		hDll = ::LoadLibraryW(L"MAPI32.DLL");
	if(hDll == 0)
		return false;

	MAPISENDMAIL*	MAPISendMail = reinterpret_cast<MAPISENDMAIL*>(::GetProcAddress(hDll, "MAPISendMail"));
	if(MAPISendMail == 0) {
		::FreeLibrary(hDll);
		return false;
	}

	MapiMessage	message;
	ulong		nErr;

	memset(&message, 0, sizeof(MapiMessage));
	message.flFlags = MAPI_RECEIPT_REQUESTED;

	if(bAsAttachment) {	// Ytt@CɂƂ
		MapiFileDesc	fileDesc;
		const int		cb = ::WideCharToMultiByte(CP_ACP, 0,
								m_strPathName.data(), m_strPathName.length(), 0, 0, 0, 0);
		char* const		pszFilePath = new char[cb + 1];

		::WideCharToMultiByte(CP_ACP, 0, m_strPathName.data(), m_strPathName.length(), pszFilePath, cb, 0, 0);
		pszFilePath[cb] = 0;
		message.nFileCount = 1;
		message.lpFiles = &fileDesc;

		memset(&fileDesc, 0, sizeof(MapiFileDesc));
		fileDesc.lpszPathName = pszFilePath;
		fileDesc.nPosition = static_cast<ulong>(-1);
		nErr = MAPISendMail(0, 0, &message, MAPI_LOGON_UI | (bShowDialog ? MAPI_DIALOG : 0), 0);
		delete[] pszFilePath;
	} else {	// {ƂđMƂ
		const size_t	cchDocument = GetDocumentLength();
		wchar_t* const	pwszContent = new wchar_t[cchDocument + 1];

		length_t	i = 0, iLine = 0;
		for(LineIterator it = m_lines.begin(); ; ++it, ++iLine) {
			const CEditDocLine&	line = *it;
			wcsncpy(pwszContent + i, line.m_strLine.data(), line.m_strLine.length());
			i += line.m_strLine.length();
			if(iLine != m_lines.size() - 1) {
				wcscpy(pwszContent + i, GetBreakString(line.m_breakType).c_str());
				i += GetBreakString(line.m_breakType).length();
			} else
				break;
		}
		pwszContent[cchDocument] = 0;

		// [Ũ}`oCgɕϊ
		const int	cbContent = ::WideCharToMultiByte(CP_ACP, 0, pwszContent, cchDocument, 0, 0, 0, 0);
		char* const	pszContent = new char[cbContent + 1];
		::WideCharToMultiByte(CP_ACP, 0, pwszContent, cchDocument, pszContent, cbContent, 0, 0);
		pszContent[cbContent] = 0;
		message.lpszNoteText = pszContent;
		delete[] pwszContent;
		nErr = MAPISendMail(0, 0, &message, MAPI_LOGON_UI | (bShowDialog ? MAPI_DIALOG : 0), 0);
		delete[] pszContent;
	}

	::FreeLibrary(hDll);
	return nErr == SUCCESS_SUCCESS || nErr == MAPI_USER_ABORT || nErr == MAPI_E_LOGIN_FAILURE;
}

/// ::SetTimer ̃R[obN֐B1000~bƂɌĂяoA
/// t@CvZXŕύXĂȂĎ
void CALLBACK CEditDoc::TimerProc(HWND hWnd, UINT nMsg, TIMERPROC_3RD_PARAM_TYPE idEvent, DWORD dwTime) {
	map<UINT, CEditDoc*>::iterator	it = CEditDoc::m_documents.find(idEvent);
	if(it != CEditDoc::m_documents.end())
		it->second->_CheckFileLastWriteTime();
}

/**
 *	AhD̎s
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
void CEditDoc::Undo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	if(m_pUndoManager->GetUndoBufferLength() == 0)
		return;

	BeginEditCollection();
	m_updateInfo.summary = US_BEGIN_UNDOGROUP;
	UpdateAllViews(this, 0, this);
	m_pUndoManager->Undo();
	EndEditCollection();
	m_updateInfo.summary = US_END_UNDOGROUP;
	UpdateAllViews(this, 0, this);

	if(!m_pUndoManager->IsModifiedSinceLastSave()) {
		m_bModified = false;
		for_each(m_eventListeners.begin(),
			m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//		for(set<IEditDocEventListener*>::iterator it
//				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//			(*it)->OnDocumentModified();
	}
}

/* [EOF] */