// EditController.h
// (c) 2003-2004 exeal

#ifndef _EDIT_CONTROLLER_H_
#define _EDIT_CONTROLLER_H_
#include "../../Manah/DocumentView.h"

namespace Ascension {

#define WC_ASCENSIONCONTROLLER	L"AscensionController"

	class CEditDoc;
	class CEditView;

	/**
	 *	@brief	Ascension eLXgGfB^̃Rg[
	 *
	 *	ehLg1B̃NX͎̍쐬r[ CDocument::AddView
	 *	găhLgɒǉ邪AhLgƂ͕ʂɓƎɎ̍쐬r[ǗB
	 *	ANCAg͂̃NXʂēhLgɑ΂ăr[Xg̕ύXvȂق悢...
	 *
	 *	@see	CEditView, CEditDoc
	 */
	class CEditController : public Manah::Windows::CController {
		friend class CEditView;

		// RXgN^
	public:
		CEditController();
		virtual ~CEditController();

		NOCOPY(CEditController);

		// \bh
	public:
		/* ̐ݒ */
		void	SetSplitterWidth(int nWidth);

		/* ̎擾 */
		CEditView*	GetActiveView() const;	// hNX͂̃\bhI[o[Chł
		CEditDoc*	GetDocument() const;
		CEditView*	GetPrimaryView() const;
		int			GetSplitterWidth() const;
		bool		IsSplit() const;

		/*  */
		virtual void	SplitView(int nFirstViewHeight = -1);

		/* wp */
	protected:	// _New Ŏn܂郁\bh͔hNXŃI[o[ChȂ΂ȂȂ
		void								_AdjustView();
		virtual Manah::Windows::CDocument*	_NewDocumentInstance();
		virtual Manah::Windows::CView*		_NewViewInstance();
		virtual CEditView*					_NewViewInstance(const CEditView& rhs);
		virtual void						_OnViewGetFocus(const CEditView& view);

		/* bZ[Wnh */
	protected:
		virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);
		virtual void	OnLButtonDblClk(UINT nFlags, POINT pt);
		virtual void	OnLButtonDown(UINT nFlags, POINT pt);
		virtual void	OnLButtonUp(UINT nFlags, POINT pt);
		virtual void	OnMouseMove(UINT nFlags, POINT pt);
		virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);
		virtual void	OnSetFocus(HWND hwndOld);
		virtual void	OnSize(UINT nType, int cx, int cy);

		// f[^o
	protected:
		CEditView*	m_p2ndView;			// 2Ԗڂ̃r[
		uchar		m_iLastActive;		// ŌɃtH[JXĂr[̔ԍ
		int			m_nFirstViewHeight;	// ŏ̃r[̍ (r[ĂȂƂ0ɂȂ)
		double		m_nSplitRatio;		// (Rg[yC̍) / m_nFirstViewHeight
		int			m_nSplitterWidth;
	private:
		bool		m_bMovingSplitter;
	};


	///	@see	CController::GetDocument
	inline CEditDoc* CEditController::GetDocument() const {
		AssertValid();
		return reinterpret_cast<CEditDoc*>(m_pDocument);
	}

	///	Ǘr[̂AL̂ԂB
	///	L̊TOɂĂ CEditView ̒`Q
	inline CEditView* CEditController::GetPrimaryView() const {
		AssertValid();
		return reinterpret_cast<CEditView*>(m_pView);
	}

	///	ꂽr[Ԃ̋Ԃ
	inline int CEditController::GetSplitterWidth() const {
		AssertValid();
		return m_nSplitterWidth;
	}

	///	r[Ă邩Ԃ
	inline bool CEditController::IsSplit() const {
		AssertValid();
		return m_nFirstViewHeight != 0;
	}
} // namespace Ascension


#endif /* _EDIT_CONTROLLER_H_ */

/* [EOF] */