// AutoCompleteWnd.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "AutoCompleteWnd.h"
#include "EditView.h"	// CEditView
#include "EditPoint.h"

using namespace Ascension;
using namespace std;


/// RXgN^
CAutoCompleteWindow::CAutoCompleteWindow(CEditView* pView) : m_pView(pView), m_hFont(0) {
	assert(m_pView != 0);
}

/// ⊮
void CAutoCompleteWindow::Complete() {
	AssertValid();

	const int	iSel = GetCurSel();

	if(iSel != LB_ERR) {
		CEditDoc* const	pDocument = m_pView->GetDocument();
		const length_t	cchItem = GetTextLen(iSel);
		char_t*			pwszItem = new char_t[cchItem + 1];
		const string_t	strLeftWord = m_pView->GetPrecedingWord(AUTO_COMPLETION_MAX_TRACKBACK_CCH);

		GetText(iSel, pwszItem);
		if(*m_pView->m_pAnchorPoint < *m_pView->m_pActivePoint)
			m_pView->m_pAnchorPoint->CharPrev(strLeftWord.length());
		else
			m_pView->m_pActivePoint->CharPrev(strLeftWord.length());
		m_pView->Freeze();
		pDocument->BeginEditCollection();
		pDocument->DeleteText(m_pView, *m_pView->m_pAnchorPoint, *m_pView->m_pActivePoint);
		pDocument->InsertText(m_pView, *m_pView->m_pActivePoint, string_t(pwszItem, cchItem));
		pDocument->EndEditCollection();
		m_pView->Unfreeze();

		delete[] pwszItem;
	}
	ShowWindow(SW_HIDE);
}

/**
 *	EBhE쐬
 *	@return	
 */
bool CAutoCompleteWindow::Create() {
	AssertValid();

	RECT	rect = {0, 0, 0, 0};
	// using Manah::Windows::Controls::CListBox;	// VC6
	// if(this->CListBox::CreateEx(true,
	if(Manah::Windows::Controls::CListBox::CreateEx(true,
			WS_EX_DLGMODALFRAME | WS_EX_NOPARENTNOTIFY,
			WS_POPUP | WS_TABSTOP | WS_VSCROLL | LBS_NOTIFY | LBS_SORT,
			rect, m_pView->m_hWnd, 0)) {
		NONCLIENTMETRICSW	ncm;

		ncm.cbSize = sizeof(NONCLIENTMETRICSW);
		::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
		m_hFont = ::CreateFontIndirectW(&ncm.lfStatusFont);
		SetFont(m_hFont);

		const ULONG_PTR	nStyleBits = ::GetClassLongPtrW(m_hWnd, GCL_STYLE);
		::SetClassLongPtrW(m_hWnd, GCL_STYLE, nStyleBits | CS_DROPSHADOW/*0x00020000*/);
		return true;
	}
	return false;
}

/// @see	CListBox::DispatchEvent
LRESULT CAutoCompleteWindow::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_CHAR:
		if(wParam == 0x0008 ||	// BkSp P\̓GfB^ɑł
				m_pView->GetLexer().IsIdentifierContinueCodePoint(wParam))
			m_pView->ExecCommand(CMDID_EDIT_CHAR, wParam);
		else {	// ȊȌꍇ͓͕⊮sA󎚉\ȕ̓GfB^ɑł
			Complete();
			if(toBoolean(iswprint(wParam)))
				m_pView->SendMessage(WM_CHAR, wParam, lParam);
		}
		return true;
	case WM_DESTROY:
		::DeleteObject(m_hFont);
		break;
	case WM_KEYDOWN:
		if(OnKeyDown(wParam, lParam))
			return false;
		break;
	case WM_KILLFOCUS:
		ShowWindow(SW_HIDE);
		break;
	case WM_LBUTTONDBLCLK:	// _uNbNł⊮
		Complete();
		return true;
	case WM_LBUTTONDOWN: {	// ŎȂȂ̂
			POINT		pt = {LOWORD(lParam), HIWORD(lParam)};
			bool		bOutside;
			const int	iSel = ItemFromPoint(pt, bOutside);
			if(!bOutside)
				SetCurSel(iSel);
		}
		return true;
	case WM_SHOWWINDOW:
		if(!wParam)
			ResetContent();
		break;
	}

	return CListBox::DispatchEvent(message, wParam, lParam);
}

/// CEditView::OnKeyDown ƓlAAvP[VŃL[蓖Ăsꍇ̓I[o[ChƂ悢
/// @see	WM_KEYDOWN
bool CAutoCompleteWindow::OnKeyDown(UINT nChar, UINT nFlags) {
	switch(nChar) {
	case VK_LBUTTON:	// Xg{bNX̊̑
	case VK_UP:
	case VK_DOWN:
	case VK_NEXT:
	case VK_PRIOR:
		return false;
	case VK_DELETE:	// ⊮EBhEăGfB^̊̓
		ShowWindow(SW_HIDE);
		m_pView->SendMessage(WM_KEYDOWN, VK_DELETE, nFlags);
		return true;
	case VK_ESCAPE:	// ⊮ɓ͌EBhE
		ShowWindow(SW_HIDE);
		return true;
	case VK_RETURN: {	// I΂̃eLXg}ĕBI΃r[ɑ
		const int	iSel = GetCurSel();
		if(iSel == LB_ERR) {
			m_pView->SendMessage(WM_KEYDOWN, VK_RETURN, nFlags);
			ShowWindow(SW_HIDE);
		} else
			Complete();
		return true;
	}
	case VK_TAB:
	case VK_SPACE:
		Complete();
		m_pView->SendMessage(WM_KEYDOWN, nChar, nFlags);
		return true;
	default:	// c̃L[͂͑Săr[ɑ
		m_pView->SendMessage(WM_KEYDOWN, nChar, nFlags);
		return true;
	}

	return false;
}

/// ͌⃊Xg̃Zbg
void CAutoCompleteWindow::SetCandidateWords(const set<string_t>& words) {
	AssertValidAsWindow();

	ResetContent();
	for(set<string_t>::const_iterator it = words.begin(); it != words.end(); ++it) {
		if(!it->empty())
			AddString(it->c_str());
	}
}

/**
 *	r[̏󋵂ɍ킹ăXg̑IXV
 *	@return	₪ɍiꂽꍇ true
 */
bool CAutoCompleteWindow::UpdateListCursel() {
	AssertValidAsWindow();

	const string_t	strLeftWord = m_pView->GetPrecedingWord(AUTO_COMPLETION_MAX_TRACKBACK_CCH);

	if(!strLeftWord.empty()) {
		const int	iFound = FindString(-1, strLeftWord.c_str());
		SetCurSel((iFound != LB_ERR) ? iFound : -1);
		if(iFound != LB_ERR) {
			if(iFound != 0)	// ̂܂܂Ə񂾂IڂsɂȂ݂
				SetCurSel(iFound - 1);
			SetCurSel(iFound);
			if(iFound != GetCount()) {
				const size_t	cchCompare = min<int>(strLeftWord.length(), GetTextLen(iFound + 1));
				wchar_t*		pwszLeftWord = new wchar_t[cchCompare];
				wchar_t*		pwszNextCand = new wchar_t[GetTextLen(iFound + 1) + 1];

				wcsncpy(pwszLeftWord, strLeftWord.data(), cchCompare);
				GetText(iFound + 1, pwszNextCand);
				::CharLowerBuff(pwszLeftWord, cchCompare);
				::CharLowerBuff(pwszNextCand, cchCompare);
				const bool	bUnique = wcsncmp(pwszLeftWord, pwszNextCand, cchCompare) != 0;

				delete[] pwszLeftWord;
				delete[] pwszNextCand;
				return bUnique;
			}
		}
	} else
		SetCurSel(-1);
	return false;
}

/* [EOF] */