// Ambient.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "Ambient.h"
#include "AmbientIdl_i.c"	// IID, LIBID
#include "AlphaScriptHost.h"
#include "AlphaView.h"
#include "CommandManager.h"
#include "Ascension\EditPoint.h"
#include <limits>
#include "../Armaiti/OleTypeWrapper.h"
#include "../Armaiti/EnumImpl.h"

#pragma warning(disable : 4390)	// u䂪̕܂B...v

using namespace Alpha;
using namespace Alpha::Ambient;
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah::Windows::Controls;
using namespace Armaiti;
using namespace Armaiti::OLE;
using namespace std;


// IDispatch::Invoke Ɏg}NA֐A
/////////////////////////////////////////////////////////////////////////////

// ̐`FbNAȂ DISP_E_BADPARAMCOUNT ԂƂ
#define VERIFY_ARGUMENTS_COUNT(c)	\
	if(pDispParams->cArgs != (c))	\
		return DISP_E_BADPARAMCOUNT

// ߂ľ^ type ɐݒ肷
// ([Jϐ pVarResult 邱ƂO)
#define COERCE_RETURN(type)	\
	if(pVarResult != 0)		\
		pVarResult->vt = type

// iArg Ԗڂ̌^ type ɕϊBϊłȂ΃G[R[hԂƂ
// ([Jϐ pDispParams AwFlags Ahr ApuArgErr Aargs[] 邱ƂO)
#define COERCE_ARGUMENT_AT(iArg, type)										\
	do {																	\
		if(type == VT_VARIANT) {											\
			if(pDispParams->rgvarg[iArg].vt == (VT_VARIANT | VT_BYREF))		\
				args[iArg] = *pDispParams->rgvarg[iArg].pvarVal;			\
			else															\
				args[iArg] = pDispParams->rgvarg[iArg];						\
			hr = (args[iArg].vt != VT_ERROR) ? S_OK : args[iArg].scode;		\
		} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT) && iArg == 0)	\
			hr = ::DispGetParam(pDispParams,								\
					DISPID_PROPERTYPUT, type,								\
					&args[iArg], puArgErr);									\
		else																\
			hr = ::DispGetParam(pDispParams,								\
					pDispParams->cArgs - iArg - 1, type,					\
					&args[iArg], puArgErr);									\
		if(FAILED(hr))														\
			return hr;														\
	} while(false)

namespace {
	template<VARTYPE varType> struct VarType2CppType;
	template<> struct VarType2CppType<VT_BOOL> {typedef VARIANT_BOOL CppType;};
	template<> struct VarType2CppType<VT_BSTR> {typedef BSTR CppType;};
	template<> struct VarType2CppType<VT_I2> {typedef short CppType;};
	template<> struct VarType2CppType<VT_I4> {typedef long CppType;};
	template<> struct VarType2CppType<VT_INT> {typedef int CppType;};
	template<> struct VarType2CppType<VT_UNKNOWN> {typedef IUnknown* CppType;};
	template<> struct VarType2CppType<VT_DISPATCH> {typedef IDispatch* CppType;};
	template<> struct VarType2CppType<VT_VARIANT> {typedef VARIANT CppType;};

	template<VARTYPE type> struct VariantTypeDescriminator {
		typedef typename VarType2CppType<type>::CppType CppType;
		typedef CppType(VARIANT::*MemberType);
		static MemberType member;
		static CppType& Value(VARIANT& var);
	};
	template<VARTYPE type> typename VariantTypeDescriminator<type>::MemberType VariantTypeDescriminator<type>::member = 0;
	template<> inline VariantTypeDescriminator<VT_BOOL>::CppType& VariantTypeDescriminator<VT_BOOL>::Value(VARIANT& var) {
		return (member = &VARIANT::boolVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_BSTR>::CppType& VariantTypeDescriminator<VT_BSTR>::Value(VARIANT& var) {
		return (member = &VARIANT::bstrVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_I2>::CppType& VariantTypeDescriminator<VT_I2>::Value(VARIANT& var) {
		return (member = &VARIANT::iVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_I4>::CppType& VariantTypeDescriminator<VT_I4>::Value(VARIANT& var) {
		return (member = &VARIANT::lVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_INT>::CppType& VariantTypeDescriminator<VT_INT>::Value(VARIANT& var) {
		return (member = &VARIANT::intVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_UNKNOWN>::CppType& VariantTypeDescriminator<VT_UNKNOWN>::Value(VARIANT& var) {
		return (member = &VARIANT::punkVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_DISPATCH>::CppType& VariantTypeDescriminator<VT_DISPATCH>::Value(VARIANT& var) {
		return (member = &VARIANT::pdispVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_VARIANT>::CppType& VariantTypeDescriminator<VT_VARIANT>::Value(VARIANT& var) {
		return var;
	}
} // namespace `anonymous'

// Qb^Ăяo̎
#define CALL_GETTER(name, type)	\
	pVarResult->vt = type;		\
	return get_##name(&VariantTypeDescriminator<type>::Value(*pVarResult))
#define CALL_GETTER_1(name, type, type0)								\
	VERIFY_ARGUMENTS_COUNT(1);											\
	COERCE_ARGUMENT_AT(0, type0);										\
	pVarResult->vt = type;												\
	return get_##name(VariantTypeDescriminator<type0>::Value(args[0]),	\
		&VariantTypeDescriminator<type>::Value(*pVarResult))
#define CALL_GETTER_ACTX(name, itf)	\
	pVarResult->vt = VT_DISPATCH;	\
	return get_##name(reinterpret_cast<itf**>(&pVarResult->pdispVal))
#define CALL_GETTER_ENUM(name, type)	\
	pVarResult->vt = VT_INT;			\
	return get_##name(reinterpret_cast<type*>(&pVarResult->intVal))

// vb^Ăяo̎
#define CALL_PUTTER(name, type)		\
	VERIFY_ARGUMENTS_COUNT(1);		\
	COERCE_ARGUMENT_AT(0, type);	\
	return put_##name(VariantTypeDescriminator<type>::Value(args[0]));
#define CALL_PUTTER_1(name, type, type0)								\
	VERIFY_ARGUMENTS_COUNT(2);											\
	COERCE_ARGUMENT_AT(1, type0);										\
	COERCE_ARGUMENT_AT(0, type);										\
	return put_##name(VariantTypeDescriminator<type0>::Value(args[1]),	\
		VariantTypeDescriminator<type>::Value(args[0]));
#define CALL_PUTTER_ENUM(name, type)	\
	VERIFY_ARGUMENTS_COUNT(1);			\
	COERCE_ARGUMENT_AT(0, VT_INT);		\
	return put_##name(static_cast<type>(args[0].intVal));

// \bhĂяo̎
#define CALL_METHOD_0(name)		\
	VERIFY_ARGUMENTS_COUNT(0);	\
	return name()
#define CALL_METHOD_1(name, type0)	\
	VERIFY_ARGUMENTS_COUNT(1);				\
	COERCE_ARGUMENT_AT(0, type0);			\
	return name(VariantTypeDescriminator<type0>::Value(args[0]))
#define CALL_METHOD_2(name, type0, type1)							\
	VERIFY_ARGUMENTS_COUNT(2);										\
	COERCE_ARGUMENT_AT(1, type0);									\
	COERCE_ARGUMENT_AT(0, type1);									\
	return name(VariantTypeDescriminator<type0>::Value(args[1]),	\
		VariantTypeDescriminator<type1>::Value(args[0]))
#define CALL_METHOD_3(name, type0, type1, type2)					\
	VERIFY_ARGUMENTS_COUNT(3);										\
	COERCE_ARGUMENT_AT(2, type0);									\
	COERCE_ARGUMENT_AT(1, type1);									\
	COERCE_ARGUMENT_AT(0, type2);									\
	return name(VariantTypeDescriminator<type0>::Value(args[2]),	\
		VariantTypeDescriminator<type1>::Value(args[1]),			\
		VariantTypeDescriminator<type2>::Value(args[0]))
#define CALL_METHOD_4(name, type0, type1, type2, type3)				\
	VERIFY_ARGUMENTS_COUNT(4);										\
	COERCE_ARGUMENT_AT(3, type0);									\
	COERCE_ARGUMENT_AT(2, type1);									\
	COERCE_ARGUMENT_AT(1, type2);									\
	COERCE_ARGUMENT_AT(0, type3);									\
	return name(VariantTypeDescriminator<type0>::Value(args[3]),	\
		VariantTypeDescriminator<type1>::Value(args[2]),			\
		VariantTypeDescriminator<type2>::Value(args[1]),			\
		VariantTypeDescriminator<type3>::Value(args[0]))
#define CALL_METHOD_RET_0(name, retType)	\
	VERIFY_ARGUMENTS_COUNT(0);				\
	COERCE_RETURN(retType);					\
	return name((pVarResult != 0) ? &VariantTypeDescriminator<retType>::Value(*pVarResult) : 0)
#define CALL_METHOD_RET_1(name, retType, type1)						\
	VERIFY_ARGUMENTS_COUNT(1);										\
	COERCE_ARGUMENT_AT(0, type1);									\
	COERCE_RETURN(retType);											\
	return name(VariantTypeDescriminator<type1>::Value(args[0]),	\
		(pVarResult != 0) ? &VariantTypeDescriminator<retType>::Value(*pVarResult) : 0)

// S}[N
#define SAFE_MARK	\
	IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(INTERFACESAFE_FOR_UNTRUSTED_CALLER)

// 댯}[N
#define UNSAFE_MARK	\
	IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(0)

// ȂȂ
#define VERIFY_SAFETY()														\
	if(toBoolean(m_dwEnabledSafety & INTERFACESAFE_FOR_UNTRUSTED_CALLER))	\
		return E_ACCESSDENIED

// _Xbhx̃G[ pExcepInfo ɃZbgA
// DISP_E_EXCEPTION ԂB
// (ʎq pException Ahr Lł邱ƂO)
#define RETURN_WITH_EXCEPTION()										\
	do {															\
		IErrorInfo*	pErrorInfo = 0;									\
		assert(SUCCEEDED(::GetErrorInfo(0, &pErrorInfo)));			\
		pExcepInfo->wCode = 0;										\
		pExcepInfo->scode = hr;										\
		pErrorInfo->GetSource(&pExcepInfo->bstrSource);				\
		pErrorInfo->GetDescription(&pExcepInfo->bstrDescription);	\
		pErrorInfo->GetHelpFile(&pExcepInfo->bstrHelpFile);			\
		pErrorInfo->GetHelpContext(&pExcepInfo->dwHelpContext);		\
		pExcepInfo->pvReserved = 0;									\
		pExcepInfo->pfnDeferredFillIn = 0;							\
		::SetErrorInfo(0, pErrorInfo);								\
		pErrorInfo->Release();										\
		return DISP_E_EXCEPTION;									\
	} while(false)

// CTextPoint ̊̃\bhɎgp
#define GENERATE_CHARPOS_FROM_TEXTPOINT()			\
	CComPtr<ITextPoint>	pTextPoint;					\
	long				iLine, iChar;				\
	var = varOther;									\
	if(FAILED(var.pdispVal->QueryInterface(			\
			IID_ITextPoint,							\
			reinterpret_cast<void**>(&pTextPoint))))\
		return DISP_E_TYPEMISMATCH;					\
	pTextPoint->get_Line(&iLine);					\
	pTextPoint->get_Char(&iChar);					\
	CCharPos	pos = CCharPos(iLine, iChar);

namespace {
	// 󔒂ŋ؂ăXgɂ
	template <class T>
	inline void SplitBySpace(const wchar_t* pwsz, T& dest) {
		assert(pwsz != 0);

		const wchar_t*	pwszSpace;
		const wchar_t*	pwszLast = pwsz;
		while(true) {
			pwszSpace = wcschr(pwszLast, L' ');
			if(pwszSpace != 0) {
				dest.push_back(wstring(pwszLast, pwszSpace - pwszLast));
				pwszLast = pwszSpace + 1;
			} else {
				dest.push_back(wstring(pwszLast));
				break;
			}
		}
	}
	// K\Ȃ
	const HRESULT	SCRIPT_E_BADREGEXP = 0x800A1399;
} // namespace `anonymous'


// CApplication class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CApplication::CApplication(Alpha::CAlphaApp& app, const vector<wstring>* pArguments /* = 0 */) : SAFE_MARK, m_app(app) {
}

/// fXgN^
CApplication::~CApplication() {
}

/// @see	IApplication::ClearOutput
STDMETHODIMP CApplication::ClearOutput() {
//	m_pApp->m_wndOutput.Clear(OTT_GENERAL, false);
	return S_OK;
}

/// @see	IApplication::get_Abbreviations
STDMETHODIMP CApplication::get_Abbreviations(IAbbreviations** ppAbbreviations) {
	VERIFY_POINTER(ppAbbreviations);

	if(0 == (*ppAbbreviations = new CAutomationAbbreviations))
		return E_OUTOFMEMORY;
	(*ppAbbreviations)->AddRef();
	return S_OK;
}

/// @see	IApplication::get_Active
STDMETHODIMP CApplication::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	*pbActive = m_app.GetMainWindow()->GetSafeHwnd() == CWindow::GetActiveWindow();
	return S_OK;
}

/// @see	IApplication::get_ActiveDocument
STDMETHODIMP CApplication::get_ActiveDocument(IDocument** ppActiveDocument) {
	VERIFY_POINTER(ppActiveDocument);

	if(IDocumentContainer* pActiveContainer = m_app.GetDocumentManager().GetActiveDocument()) {
		if(CAlphaEditController* pEditor = pActiveContainer->GetTextEditor()) {
			if(0 == (*ppActiveDocument = new CTextDocument(m_app, *pEditor->GetDocument())))
				return E_OUTOFMEMORY;
			(*ppActiveDocument)->AddRef();
			return S_OK;
		}
	}
    *ppActiveDocument = 0;
	return E_UNEXPECTED;
}

/// @see	IApplication::get_Configurations
STDMETHODIMP CApplication::get_Configurations(IConfigurations** ppConfigurations) {
	VERIFY_POINTER(ppConfigurations);

	if(0 == (*ppConfigurations = new CConfigurations(m_app)))
		return E_OUTOFMEMORY;
	(*ppConfigurations)->AddRef();
	return S_OK;
}

/// @see	IApplication::get_CurrentDirectory
STDMETHODIMP CApplication::get_CurrentDirectory(BSTR* pbstrDirectory) {
	VERIFY_POINTER(pbstrDirectory);
	OLECHAR	wszPath[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, wszPath);
	*pbstrDirectory = ::SysAllocString(wszPath);
	return (*pbstrDirectory != 0) ? S_OK : E_OUTOFMEMORY;
}
/*
/// @see	IApplication::get_Debugger
STDMETHODIMP CApplication::get_Debugger(IDebugger** ppDebugger) {
	VERIFY_POINTER(ppDebugger);
	*ppDebugger = 0;
	return E_NOTIMPL;
}*/

/// @see	IApplication::get_Documents
STDMETHODIMP CApplication::get_Documents(IDocuments** ppDocuments) {
	VERIFY_POINTER(ppDocuments);

	CDocuments*	pDocuments;
	m_app.GetAutomation(0, &pDocuments);
	*ppDocuments = pDocuments;
	return S_OK;
}

/// @see	IApplication::get_FullName
STDMETHODIMP CApplication::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszFileName[MAX_PATH];

	::GetModuleFileName(0, wszFileName, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszFileName);
	return (*pbstrFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_Height
STDMETHODIMP CApplication::get_Height(long* pnHeight) {
	VERIFY_POINTER(pnHeight);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	*pnHeight = rect.bottom - rect.top;
	return S_OK;
}

/// @see	IApplication::get_Left
STDMETHODIMP CApplication::get_Left(long* pnLeft) {
	VERIFY_POINTER(pnLeft);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	*pnLeft = rect.left;
	return S_OK;
}

/// @see	IApplication::get_Name
STDMETHODIMP CApplication::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(IDS_APPNAME OLESTR(" ") IDS_APPVERSION OLESTR(" ") IDS_APPVERSIONINFO);
	return (*pbstrName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_Top
STDMETHODIMP CApplication::get_Top(long* pnTop) {
	VERIFY_POINTER(pnTop);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	*pnTop = rect.top;
	return S_OK;
}

/// @see	IApplication::get_Version
STDMETHODIMP CApplication::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = ::SysAllocString(IDS_APPVERSION);
	return (*pbstrVersion != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_Visible
STDMETHODIMP CApplication::get_Visible(VARIANT_BOOL* pbVisible) {
	VERIFY_POINTER(pbVisible);
	*pbVisible = m_app.GetMainWindow()->IsWindowVisible();
	return S_OK;
}

/// @see	IApplication::get_Width
STDMETHODIMP CApplication::get_Width(long* pnWidth) {
	VERIFY_POINTER(pnWidth);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	*pnWidth = rect.right - rect.left;
	return S_OK;
}

/// @see	IApplication::get_WindowState
STDMETHODIMP CApplication::get_WindowState(AmbientWindowState* pWindowState) {
	VERIFY_POINTER(pWindowState);

	if(m_app.GetMainWindow()->IsIconic())		*pWindowState = AWS_MINIMIZED;
	else if(m_app.GetMainWindow()->IsZoomed())	*pWindowState = AWS_MAXIMIZED;
	else										*pWindowState = AWS_NORMAL;
	return S_OK;
}

/// @see	IApplication::GetCommandById
STDMETHODIMP CApplication::GetCommandById(long nCommandId, ICommand** ppCommand) {
	if(ppCommand != 0) {
		if(0 == (*ppCommand = new CAutomationCommand(m_app, static_cast<CommandId>(nCommandId))))
			return E_OUTOFMEMORY;
		(*ppCommand)->AddRef();
	}
	return S_OK;
}

/// O[oȗ񋓂ԂB|C^͌Ăяo Release 
void CApplication::GetEnumerations(set<pair<wstring, CEnumImpl*> >& enums) {
#define PROP(name, value)	p->AddProperty(OLESTR(name), (value))

	CEnumImpl*	p = new CEnumImpl(true);
	p->AddRef();
	PROP("MAXIMIZED",	AWS_MAXIMIZED);
	PROP("MINIMIZED",	AWS_MINIMIZED);
	PROP("NORMAL",		AWS_NORMAL);
	enums.insert(make_pair(OLESTR("WindowsState"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("DENY_NONE",	AFSM_DENYNONE);
	PROP("DENY_WRITE",	AFSM_DENYWRITE);
	PROP("DENY_READ",	AFSM_DENYREADWRITE);
	enums.insert(make_pair(OLESTR("FileShareMode"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("AUTO",	ABT_AUTO);
	PROP("LF",		ABT_LF);
	PROP("CR",		ABT_CR);
	PROP("CRLF",	ABT_CRLF);
	PROP("NEL",		ABT_NEL);
	PROP("LS",		ABT_LS);
	PROP("PS",		ABT_PS);
	enums.insert(make_pair(OLESTR("BreakType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("UPPERCASE_ASCII",			ACT_UPPERCASE_ASCII);
	PROP("UPPERCASE_SIMPLE",		ACT_UPPERCASE_SIMPLE);
	PROP("UPPERCASE_FULL",			ACT_UPPERCASE_FULL);
	PROP("LOWERCASE_ASCII",			ACT_LOWERCASE_ASCII);
	PROP("LOWERCASE_SIMPLE",		ACT_LOWERCASE_SIMPLE);
	PROP("LOWERCASE_FULL",			ACT_LOWERCASE_FULL);
	PROP("CAPITALIZE_ASCII",		ACT_CAPITALIZE_ASCII);
	PROP("CAPITALIZE_SIMPLE",		ACT_CAPITALIZE_SIMPLE);
	PROP("CAPITALIZE_FULL",			ACT_CAPITALIZE_FULL);
	PROP("HIRAGANA",				ACT_HIRAGANA);
	PROP("KATAKANA",				ACT_KATAKANA);
	PROP("SIMPLIFIED_CHINESE",		ACT_SIMPLIFIED_CHINESE);
	PROP("TRADITIONAL_CHINESE",		ACT_TRADITIONAL_CHINESE);
	PROP("FULLWIDTH",				ACT_FULLWIDTH);
	PROP("HALFWIDTH",				ACT_HALFWIDTH);
	PROP("ARABICDIGIT",				ACT_ARABICDIGIT);
	PROP("REMOVE_NONSPACE",			ACT_REMOVE_NONSPACE);
	PROP("REMOVE_ARABIC_KASHIDA",	ACT_REMOVE_ARABICKASHIDA);
	PROP("COMPOSE",					ACT_COMPOSE);
	PROP("DECOMPOSE",				ACT_DECOMPOSE);
	enums.insert(make_pair(OLESTR("ConvertType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("UTF16",	ACCB_UTF16);
	PROP("UTF32",	ACCB_UTF32);
	PROP("CLUSTER",	ACCB_CLUSTER);
	PROP("DEFAULT",	ACCB_DEFAULT);
	enums.insert(make_pair(OLESTR("CharCountBehavior"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("LITERAL",		AST_LITERAL);
	PROP("REGEXP",		AST_REGEXP);
	PROP("WILDCARD",	AST_WILDCARD);
	PROP("MIGEMO",		AST_MIGEMO);

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("MATCH_CASE",				ACFT_MATCH_CASE);
	PROP("IGNORE_ASCII_ALPHABETS",	ACFT_IGNORE_ASCII_ALPHABETS);
	PROP("UNICODE_SIMPLE",			ACFT_UNICODE_SIMPLE);
	PROP("UNICODE_FULL",			ACFT_UNICODE_FULL);
	enums.insert(make_pair(OLESTR("CaseFoldingType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("DEFAULT",			ANF_DEFAULT);
	PROP("CPP",				ANF_CPLUSPLUS);
	PROP("PERL",			ANF_PERL);
	PROP("RUBY",			ANF_RUBY);
	PROP("VBSCRIPT",		ANF_VBSCRIPT);
	PROP("JAVASCRIPT_1_5",	ANF_JAVASCRIPT_15);
	PROP("JAVASCRIPT_2_0",	ANF_JAVASCRIPT_20);
	enums.insert(make_pair(OLESTR("NumberFormat"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NONE",				AAR_NONE);
	PROP("ONLY_START_OF_LINE",	AAR_ONLYSTARTOFLINE);
	PROP("ONLY_HEAD_OF_LINE",	AAR_ONLYHEADOFLINE);
	enums.insert(make_pair(OLESTR("AnnotationRestriction"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NONE",	ALNBS_NONE);
	PROP("SOLID",	ALNBS_SOLID);
	PROP("DASHED",	ALNBS_DASHED);
	PROP("DOTTED",	ALNBS_DOTTED);
	enums.insert(make_pair(OLESTR("LineNumberBorderStyle"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NOWRAP",				AWM_NOWRAP);
	PROP("BY_SPECIFIED_WIDTH",	AWM_BYSPECIFIEDWIDTH);
	PROP("BY_WINDOW_WIDTH",		AWM_BYWINDOWWIDTH);
	enums.insert(make_pair(OLESTR("WrapMode"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NONE",					ABT_NONE);
	PROP("UNDERLINE_SOLID",			ABT_UNDERLINE_SOLID);
	PROP("UNDERLINE_BOLD",			ABT_UNDERLINE_BOLD);
	PROP("UNDERLINE_DASHED",		ABT_UNDERLINE_DASHED);
	PROP("UNDERLINE_BOLD_DASHED",	ABT_UNDERLINE_BOLDDASHED);
	PROP("UNDERLINE_DOTTED",		ABT_UNDERLINE_DOTTED);
	PROP("UNDERLINE_BOLD_DOTTED",	ABT_UNDERLINE_BOLDTOTTED);
	PROP("UNDERLINE_WAVED",			ABT_UNDERLINE_WAVED);
	PROP("BORDER_SOLID",			ABT_BORDER_SOLID);
	PROP("BORDER_DASHED",			ABT_BORDER_DASHED);
	PROP("BORDER_DOTTED",			ABT_BORDER_DOTTED);
	enums.insert(make_pair(OLESTR("BorderType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("ACTIVE_BORDER",					ASC_ACTIVEBORDER);
	PROP("ACTIVE_CAPTION",					ASC_ACTIVECAPTION);
	PROP("ACTIVE_CAPTION_GRADIENT_RIGHT",	ASC_ACTIVECAPTIONGRADIENTRIGHT);
	PROP("ACTIVE_CAPTION_TEXT",				ASC_ACTIVECAPTIONTEXT);
	PROP("APP_WORKSPACE",					ASC_APPWORKSPACE);
	PROP("CONTROL",							ASC_CONTROL);
	PROP("CONTROL_DARK",					ASC_CONTROLDARK);
	PROP("CONTROL_DARK_DARK",				ASC_CONTROLDARKDARK);
	PROP("CONTROL_LIGHT",					ASC_CONTROLLIGHT);
	PROP("CONTROL_LIGHT_LIGHT",				ASC_CONTROLLIGHTLIGHT);
	PROP("CONTROL_TEXT",					ASC_CONTROLTEXT);
	PROP("DEFAULT",							ASC_DEFAULT);
	PROP("DESKTOP",							ASC_DESKTOP);
	PROP("GRAY_TEXT",						ASC_GRAYTEXT);
	PROP("HIGHLIGHT",						ASC_HIGHLIGHT);
	PROP("HIGHLIGHT_TEXT",					ASC_HIGHLIGHTTEXT);
	PROP("HOT_TRACK",						ASC_HOTTRACK);
	PROP("INACTIVE_BORDER",					ASC_INACTIVEBORDER);
	PROP("INACTIVE_CAPTION",				ASC_INACTIVECAPTION);
	PROP("INACTIVE_CAPTION_GRADIENT_RIGHT",	ASC_INACTIVECAPTIONGRADIENTRIGHT);
	PROP("INACTIVE_CAPTION_TEXT",			ASC_INACTIVECAPTIONTEXT);
	PROP("INFO",							ASC_INFO);
	PROP("INFO_TEXT",						ASC_INFOTEXT);
	PROP("MENU",							ASC_MENU);
	PROP("MENUBAR",							ASC_MENUBAR);
	PROP("MENU_HIGHLIGHT",					ASC_MENUHIGHLIGHT);
	PROP("MENU_TEXT",						ASC_MENUTEXT);
	PROP("SCROLLBAR",						ASC_SCROLLBAR);
	PROP("WINDOW",							ASC_WINDOW);
	PROP("WINDOW_FRAME",					ASC_WINDOWFRAME);
	PROP("WINDOW_TEXT",						ASC_WINDOWTEXT);
	PROP("BLACK",							RGB(0x00, 0x00, 0x00));
	PROP("BLUE",							RGB(0x00, 0x00, 0xFF));
	PROP("CYAN",							RGB(0x00, 0xFF, 0xFF));
	PROP("GREEN",							RGB(0x00, 0xFF, 0x00));
	PROP("MAGENDA",							RGB(0xFF, 0x00, 0xFF));
	PROP("RED",								RGB(0xFF, 0x00, 0x00));
	PROP("WHITE",							RGB(0xFF, 0xFF, 0xFF));
	PROP("YELLOW",							RGB(0xFF, 0xFF, 0x00));
	enums.insert(make_pair(OLESTR("SystemColors"), p));
#undef PROP
}

/// @see	IDispatch::Invoke
STDMETHODIMP CApplication::Invoke(DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ABBREVIATIONS:		CALL_GETTER_ACTX(Abbreviations, IAbbreviations);
		case DISPID_APPLICATION_ACTIVE:				CALL_GETTER(Active, VT_BOOL);
		case DISPID_APPLICATION_ACTIVEDOCUMENT:		CALL_GETTER_ACTX(ActiveDocument, IDocument);
		case DISPID_APPLICATION_CONFIGURATIONS:		CALL_GETTER_ACTX(Configurations, IConfigurations);
		case DISPID_APPLICATION_CURRENTDIRECTORY:	CALL_GETTER(CurrentDirectory, VT_BSTR);
		case DISPID_APPLICATION_DOCUMENTS: {
			IDocuments*	pDocuments;
			pVarResult->vt = VT_DISPATCH;
			hr = get_Documents(&pDocuments);
			if(SUCCEEDED(hr) && pDispParams->cArgs != 0) {	// "Ambient.Documents(i)" ̂悤ȏꍇ
				hr = pDocuments->Invoke(DISPID_VALUE, IID_NULL,
						LOCALE_USER_DEFAULT, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
				pDocuments->Release();
				return hr;
			} else {	// "Ambient.Documents" ̂悤ȏꍇ
				pVarResult->pdispVal = pDocuments;
				return hr;
			}
		}
		case DISPID_APPLICATION_FULLNAME:		CALL_GETTER(FullName, VT_BSTR);
		case DISPID_APPLICATION_HEIGHT:			CALL_GETTER(Height, VT_I4);
		case DISPID_APPLICATION_LEFT:			CALL_GETTER(Left, VT_I4);
		case DISPID_APPLICATION_NAME:			CALL_GETTER(Name, VT_BSTR);
		case DISPID_APPLICATION_TOP:			CALL_GETTER(Top, VT_I4);
		case DISPID_APPLICATION_VERSION:		CALL_GETTER(Version, VT_BSTR);
		case DISPID_APPLICATION_VISIBLE:		CALL_GETTER(Visible, VT_BOOL);
		case DISPID_APPLICATION_WIDTH:			CALL_GETTER(Width, VT_I4);
		case DISPID_APPLICATION_WINDOWSTATE:	CALL_GETTER_ENUM(WindowState, AmbientWindowState);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:				CALL_PUTTER(Active, VT_BOOL);
		case DISPID_APPLICATION_CURRENTDIRECTORY:	CALL_PUTTER(CurrentDirectory, VT_BSTR);
		case DISPID_APPLICATION_HEIGHT:				CALL_PUTTER(Height, VT_I4);
		case DISPID_APPLICATION_LEFT:				CALL_PUTTER(Left, VT_I4);
		case DISPID_APPLICATION_TOP:				CALL_PUTTER(Top, VT_I4);
		case DISPID_APPLICATION_VISIBLE:			CALL_PUTTER(Visible, VT_BOOL);
		case DISPID_APPLICATION_WIDTH:				CALL_PUTTER(Width, VT_I4);
		case DISPID_APPLICATION_WINDOWSTATE:		CALL_PUTTER_ENUM(WindowState, AmbientWindowState);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF) {	// Zb^
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_APPLICATION_CLEAROUTPUT:	CALL_METHOD_0(ClearOutput);
		case DISPID_APPLICATION_GETCOMMANDBYID:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			return GetCommandById(args[0].lVal,
				(pVarResult != 0) ? reinterpret_cast<ICommand**>(&pVarResult->pdispVal) : 0);
		case DISPID_APPLICATION_QUIT:
			if(pDispParams->cArgs == 1) {
				CALL_METHOD_1(Quit, VT_I2);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_APPLICATION_WRITETOOUTPUT:		CALL_METHOD_2(WriteToOutput, VT_BSTR, VT_BOOL);
		case DISPID_APPLICATION_WRITELINETOOUTPUT:	CALL_METHOD_2(WriteLineToOutput, VT_BSTR, VT_BOOL);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

void CApplication::_CallHook(DISPID idHook, const DISPPARAMS* pArguments) {
/*	if(m_pHook == 0)
		return;

	CComPtr<IDispatchEx>	px;
	DISPPARAMS				params = {0, 0, 0, 0};
	EXCEPINFO				exception;
	HRESULT					hr;

	if(S_OK == m_pHook->QueryInterface(IID_IDispatchEx, reinterpret_cast<void**>(&px))) {
		VARIANTARG	arg;
		DISPID		id = DISPID_THIS;

		params.cArgs = params.cNamedArgs = 1;
		arg.vt = VT_DISPATCH;
		hr = QueryInterface(IID_IDispatch, reinterpret_cast<void**>(&arg.pdispVal));
		params.rgdispidNamedArgs = &id;
		hr = px->InvokeEx(DISPID_VALUE, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, 0);
	} else {
		unsigned int	iArgErr;
		hr = m_pHook->Invoke(DISPID_VALUE, IID_NULL,
			LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, &iArgErr);
	}*/
}

/// @see	IApplication::put_Active
STDMETHODIMP CApplication::put_Active(VARIANT_BOOL bActive) {
	if(bActive)
		m_app.GetMainWindow()->SetActiveWindow();
	else
		::SetActiveWindow(::GetDesktopWindow());
	return S_OK;
}

/// @see	IApplication::put_CurrentDirectory
STDMETHODIMP CApplication::put_CurrentDirectory(BSTR bstrDirectory) {
	::SetCurrentDirectoryW((bstrDirectory != 0) ? bstrDirectory : L"");
	return S_OK;
}

/// @see	IApplication::put_Height
STDMETHODIMP CApplication::put_Height(long nHeight) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	m_app.GetMainWindow()->SetWindowPos(0, 0, 0,
		rect.right - rect.left, nHeight, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_Left
STDMETHODIMP CApplication::put_Left(long nLeft) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	m_app.GetMainWindow()->SetWindowPos(0, nLeft, rect.top,
		0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_Top
STDMETHODIMP CApplication::put_Top(long nTop) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	m_app.GetMainWindow()->SetWindowPos(0, rect.left, nTop,
		0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_Visible
STDMETHODIMP CApplication::put_Visible(VARIANT_BOOL bVisible) {
	m_app.GetMainWindow()->ShowWindow(bVisible ? SW_SHOW : SW_HIDE);
	return S_OK;
}

/// @see	IApplication::put_Width
STDMETHODIMP CApplication::put_Width(long nWidth) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(rect);
	m_app.GetMainWindow()->SetWindowPos(0, 0, 0,
		nWidth, rect.bottom - rect.top, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_WindowState
STDMETHODIMP CApplication::put_WindowState(AmbientWindowState windowState) {
	switch(windowState) {
	case AWS_MINIMIZED:
		m_app.GetMainWindow()->ShowWindow(SW_MINIMIZE);
		break;
	case AWS_MAXIMIZED:
		m_app.GetMainWindow()->ShowWindow(SW_MAXIMIZE);
		break;
	case AWS_NORMAL:
		m_app.GetMainWindow()->ShowWindow(SW_RESTORE);
		break;
	default:
		return E_INVALIDARG;
		break;
	}
	return S_OK;
}

/// @see	IApplication::Quit
STDMETHODIMP CApplication::Quit(short nErrorCode) {
	m_app.GetMainWindow()->SendMessage(WM_CLOSE);
	return S_OK;
}

/// @see	IApplication::WriteToOutput
STDMETHODIMP CApplication::WriteToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_app.m_wndOutput.Write(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}

/// @see	IApplication::WriteLineToOutput
STDMETHODIMP CApplication::WriteLineToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_app.m_wndOutput.WriteLine(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}


// CDocuments class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CDocuments::CDocuments(Alpha::CAlphaApp& app) : UNSAFE_MARK, m_app(app) {
}

/// @see	IDocuments::AddNew
STDMETHODIMP CDocuments::AddNew() {
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, CMD_FILE_NEW);
	return S_OK;
}

/// @see	IDocuments::CloseAll
STDMETHODIMP CDocuments::CloseAll() {
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, CMD_FILE_CLOSEALL);
	return S_OK;
}

/// @see	IDocuments::get__NewEnum
STDMETHODIMP CDocuments::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);

	const CDocumentManager&	documents = m_app.GetDocumentManager();
	const size_t			cDocuments = documents.GetCount();
	VARIANT* const			pDocuments = new VARIANT[cDocuments];

	try {
		for(size_t i = 0; i < cDocuments; ++i) {
			::VariantInit(&pDocuments[i]);
			if(CAlphaEditController* pEditor = documents.GetDocument(i)->GetTextEditor()) {
				IDocument*	pDocument = 0;
				pEditor->GetDocument()->GetAutomation(m_app, &pDocument);
				pDocuments[i].vt = VT_DISPATCH;
				pDocuments[i].pdispVal = pDocument;
			}
		}
	} catch(out_of_range& /* e */) {
		for(size_t i = 0; i < cDocuments; ++i)
			::VariantClear(&pDocuments[i]);
		delete[] pDocuments;
		*ppEnum = 0;
		return E_FAIL;
	}
	*ppEnum = new IEnumVARIANTImpl(pDocuments, cDocuments);
	if(*ppEnum != 0)
		(*ppEnum)->AddRef();
	for(size_t i = 0; i < cDocuments; ++i)
		::VariantClear(&pDocuments[i]);
	delete[] pDocuments;

	return (*ppEnum != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IDocuments::get_Count
STDMETHODIMP CDocuments::get_Count(long* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_app.GetDocumentManager().GetCount();
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CDocuments::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[4];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENTS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_DOCUMENTS_COUNT:	CALL_GETTER(Count, VT_I4);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_DOCUMENTS_ADDNEW:	CALL_METHOD_0(AddNew);
		case DISPID_DOCUMENTS_CLOSEALL:	CALL_METHOD_0(CloseAll);
		case DISPID_DOCUMENTS_ITEM:
//		case 0:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			hr = Item(args[0].lVal, (pVarResult != 0) ?
					reinterpret_cast<IDocument**>(&pVarResult->pdispVal) : 0);
			return hr;
		case DISPID_DOCUMENTS_OPEN:
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Open(args[1].bstrVal, static_cast<AmbientFileShareMode>(args[0].iVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I2);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return Open(args[2].bstrVal,
					static_cast<AmbientFileShareMode>(args[1].iVal), args[0].lVal);
			} else if(pDispParams->cArgs == 4) {
				COERCE_ARGUMENT_AT(3, VT_BSTR);
				COERCE_ARGUMENT_AT(2, VT_I2);
				COERCE_ARGUMENT_AT(1, VT_I4);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Open(args[3].bstrVal,
					static_cast<AmbientFileShareMode>(args[2].iVal), args[1].lVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENTS_SAVEALL:	CALL_METHOD_0(SaveAll);
		}
	}

	return hr;
}

/// @see	IDocuments::Item
STDMETHODIMP CDocuments::Item(long iDocument, IDocument** ppDocument) {
	VERIFY_POINTER(ppDocument);
	try {
		if(CAlphaEditController* pEditor = m_app.GetDocumentManager().GetDocument(iDocument)->GetTextEditor())
			pEditor->GetDocument()->GetAutomation(m_app, ppDocument);
		else {
			*ppDocument = 0;
			return E_UNEXPECTED;
		}
	} catch(out_of_range& /* e */) {
		*ppDocument = 0;
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IDocuments::Open
STDMETHODIMP CDocuments::Open(BSTR bstrPathName,
		AmbientFileShareMode nShareMode, long nCodePage /* = 0 */, VARIANT_BOOL bAddToMRU /* = true */) {
	VERIFY_SAFETY();
	if(bstrPathName == 0)
		return E_INVALIDARG;
	CComCriticalSection<>	cs;
	cs.Lock();
	m_app.OpenFile(bstrPathName, (nCodePage != 0) ? nCodePage : ::GetACP(), toBoolean(bAddToMRU));
	cs.Unlock();
	return S_OK;
}

/// @see	IDocuments::SaveAll
STDMETHODIMP CDocuments::SaveAll() {
	VERIFY_SAFETY();
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, CMD_FILE_SAVEALL);
	return S_OK;
}


// CTextDocument class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CTextDocument::CTextDocument(CAlphaApp& app, CAlphaDoc& document) : UNSAFE_MARK, m_app(app), m_document(document) {
}

/// @see	IDocument::ClearUndoBuffer
STDMETHODIMP CTextDocument::ClearUndoBuffer() {
	m_document.ClearUndoBuffer();
	return S_OK;
}

/// @see	IDocument::Close
STDMETHODIMP CTextDocument::Close(VARIANT_BOOL bConfirm /* = VARIANT_TRUE */) {
	m_app.GetDocumentManager().SetActiveDocument(FindDocument());
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, MAKEWPARAM(CMD_FILE_CLOSE, !bConfirm));
	return S_OK;
}

/**
 *	AvP[VIuWFNg (CAlphaApp) 玩̃^uԍT
 *	@return	^uԍ
 */
unsigned int CTextDocument::FindDocument() const {
	const CDocumentManager&	documents = m_app.GetDocumentManager();
	for(size_t iDocument = 0; iDocument < documents.GetCount(); ++iDocument) {
		if(documents.GetDocument(iDocument)->GetTextEditor() == m_document.GetController())
			return iDocument;
	}
	assert(false);	//tȂ͖͂
	return -1;
}

/// @see	IDocument::get_Active
STDMETHODIMP CTextDocument::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	if(CAlphaEditController* pEditor = m_app.GetDocumentManager().GetActiveDocument()->GetTextEditor())
		*pbActive = toVariantBoolean(pEditor->GetDocument() == &m_document);
	else
		*pbActive = VARIANT_FALSE;
	return S_OK;
}

/// @see	IDocument::get_BreakType
STDMETHODIMP CTextDocument::get_BreakType(AmbientBreakType* pBreakType) {
	VERIFY_POINTER(pBreakType);
	*pBreakType = static_cast<AmbientBreakType>(m_document.GetBreakType());
	return S_OK;
}

/// @see	IDocument::get_CodePage
STDMETHODIMP CTextDocument::get_CodePage(long* pnCodePage) {
	VERIFY_POINTER(pnCodePage);
	*pnCodePage = m_document.GetCodePage();
	return S_OK;
}

/// @see	ITextDocument::get_EndPoint
STDMETHODIMP CTextDocument::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);

	CEditPoint*	pEndPoint = m_document.GetController()->GetActiveView()->CreateEditPoint();

	pEndPoint->MoveToEndOfDocument();
	*ppEndPoint = new CTextPoint(*pEndPoint, false);
	(*ppEndPoint)->AddRef();
	return S_OK;
}

/// @see	IDocument::get_FileName
STDMETHODIMP CTextDocument::get_FileName(BSTR* pbstrFileName) {
	VERIFY_POINTER(pbstrFileName);
	*pbstrFileName = ::SysAllocString(m_document.GetTitle().c_str());
	return (*pbstrFileName) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IDocument::get_FilePath
STDMETHODIMP CTextDocument::get_FilePath(BSTR* pbstrFilePath) {
	VERIFY_POINTER(pbstrFilePath);
	*pbstrFilePath = ::SysAllocString(m_document.GetPathName().c_str());
	return (*pbstrFilePath != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	ITextDocument::get_Line
STDMETHODIMP CTextDocument::get_Line(long iLine, BSTR* pbstrLine) {
	VERIFY_POINTER(pbstrLine);
	try {
		*pbstrLine = ::SysAllocString(m_document.GetLine(iLine).c_str());
	} catch(out_of_range&) {
		*pbstrLine = 0;
		return E_INVALIDARG;
	}
	return (*pbstrLine != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	ITextDocument::get_LineCount
STDMETHODIMP CTextDocument::get_LineCount(long* pcLines) {
	VERIFY_POINTER(pcLines);
	*pcLines = m_document.GetLineCount();
	return S_OK;
}

/// @see	IDocument::get_Modified
STDMETHODIMP CTextDocument::get_Modified(VARIANT_BOOL* pbModified) {
	VERIFY_POINTER(pbModified);
	*pbModified = m_document.IsModified();
	return S_OK;
}

/// @see	IDocument::get_ReadOnly
STDMETHODIMP CTextDocument::get_ReadOnly(VARIANT_BOOL* pbReadOnly) {
	VERIFY_POINTER(pbReadOnly);
	*pbReadOnly = m_document.IsReadOnly();
	return S_OK;
}

/// @see	ITextDocument::get_StartPoint
STDMETHODIMP CTextDocument::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
	*ppStartPoint = new CTextPoint(
		*m_document.GetController()->GetActiveView()->CreateEditPoint(), false);
	(*ppStartPoint)->AddRef();
	return S_OK;
}

/// @see	ITextDocument::get_TextProcessor
STDMETHODIMP CTextDocument::get_TextProcessor(ITextProcessor** ppTextProcessor) {
	VERIFY_POINTER(ppTextProcessor);
	*ppTextProcessor = new CTextProcessor(m_app, *m_document.GetController());
	(*ppTextProcessor)->AddRef();
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CTextDocument::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENT_ACTIVE:			CALL_GETTER(Active, VT_BOOL);
		case DISPID_DOCUMENT_BREAKTYPE:			CALL_GETTER_ENUM(BreakType, AmbientBreakType);
		case DISPID_DOCUMENT_CODEPAGE:			CALL_GETTER(CodePage, VT_I4);
		case DISPID_TEXTDOCUMENT_ENDPOINT:		CALL_GETTER_ACTX(EndPoint, ITextPoint);
		case DISPID_DOCUMENT_FILENAME:			CALL_GETTER(FileName, VT_BSTR);
		case DISPID_DOCUMENT_FILEPATH:			CALL_GETTER(FilePath, VT_BSTR);
		case DISPID_TEXTDOCUMENT_LINE:			CALL_GETTER_1(Line, VT_BSTR, VT_I4);
		case DISPID_TEXTDOCUMENT_LINECOUNT:		CALL_GETTER(LineCount, VT_I4);
		case DISPID_DOCUMENT_MODIFIED:			CALL_GETTER(Modified, VT_BOOL);
		case DISPID_DOCUMENT_READONLY:			CALL_GETTER(ReadOnly, VT_BOOL);
		case DISPID_TEXTDOCUMENT_STARTPOINT:	CALL_GETTER_ACTX(StartPoint, ITextPoint);
		case DISPID_TEXTDOCUMENT_TEXTPROCESSOR:	CALL_GETTER_ACTX(TextProcessor, ITextProcessor);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_DOCUMENT_ACTIVE:	CALL_PUTTER(Active, VT_BOOL);
		case DISPID_DOCUMENT_BREAKTYPE:	CALL_PUTTER_ENUM(BreakType, AmbientBreakType);
		case DISPID_DOCUMENT_CODEPAGE:	CALL_PUTTER(CodePage, VT_I4);
		case DISPID_DOCUMENT_MODIFIED:	CALL_PUTTER(Modified, VT_BOOL);
		case DISPID_DOCUMENT_READONLY:	CALL_PUTTER(ReadOnly, VT_BOOL);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_DOCUMENT_CLEARUNDOBUFFER:	CALL_METHOD_0(ClearUndoBuffer);
		case DISPID_DOCUMENT_CLOSE:
			if(pDispParams->cArgs == 0)
				return Close();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Close(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENT_REDO:	CALL_METHOD_0(Redo);
		case DISPID_DOCUMENT_SAVE:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return Save(args[0].bstrVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Save(args[1].bstrVal, static_cast<AmbientBreakType>(args[0].iVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I2);
				COERCE_ARGUMENT_AT(0, VT_UI2);
				return Save(args[2].bstrVal,
					static_cast<AmbientBreakType>(args[1].iVal), args[0].uiVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENT_UNDO:	CALL_METHOD_0(Undo);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	IDocument::put_Active
STDMETHODIMP CTextDocument::put_Active(VARIANT_BOOL bActive) {
	m_app.GetDocumentManager().SetActiveDocument(FindDocument());
	return S_OK;
}

/// @see	IDocument::put_BreakType
STDMETHODIMP CTextDocument::put_BreakType(AmbientBreakType breakType) {
	try {
		m_document.SetBreakType(static_cast<BreakType>(breakType));
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IDocument::put_CodePage
STDMETHODIMP CTextDocument::put_CodePage(long nCodePage) {
	try {
		m_document.SetCodePage(nCodePage);
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IDocument::put_Modified
STDMETHODIMP CTextDocument::put_Modified(VARIANT_BOOL bModified) {
	m_document.SetModified(toBoolean(bModified));
	return S_OK;
}

/// @see	IDocument::put_ReadOnly
STDMETHODIMP CTextDocument::put_ReadOnly(VARIANT_BOOL bReadOnly) {
	m_document.SetReadOnly(toBoolean(bReadOnly));
	return S_OK;
}

/// @see	IDocument::Redo
STDMETHODIMP CTextDocument::Redo() {
	m_document.Redo();
	return S_OK;
}

/// @see	IDocument::Save
STDMETHODIMP CTextDocument::Save(
		BSTR bstrFileName, AmbientBreakType breakType /* = ABT_AUTO */, long nCodePage /* = 0 */) {
	VERIFY_SAFETY();
	if(bstrFileName == 0)
		return E_INVALIDARG;
	if(SS_OK == m_document.SaveDocument(bstrFileName,
						SDO_IGNORE_NOFITCHARS,
						static_cast<BreakType>(breakType), nCodePage))
		return S_OK;
	return S_FALSE;
}

/// @see	IDocument::Undo
STDMETHODIMP CTextDocument::Undo() {
	m_document.Undo();
	return S_OK;
}


// CTextProcessor class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CTextProcessor::CTextProcessor(CAlphaApp& app, CAlphaEditController& editor) : SAFE_MARK, m_app(app), m_editor(editor) {
}

/// @see	ITextProcessor::BackSpace
STDMETHODIMP CTextProcessor::BackSpace() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_BACKSPACE, 0L);
	return S_OK;
}

/// @see	ITextProcessor::BeginEditCollection
STDMETHODIMP CTextProcessor::BeginEditCollection() {
	m_editor.GetDocument()->BeginEditCollection();
	return S_OK;
}

/// @see	ITextProcessor::CreateEditPoint
STDMETHODIMP CTextProcessor::CreateEditPoint(ITextPoint* pTextPoint, IEditPoint** ppEditPoint) {
	if(ppEditPoint != 0) {
		if(pTextPoint == 0)
			return E_INVALIDARG;

		long	iLine, iChar;

		*ppEditPoint = new CTextPoint(*m_editor.GetActiveView()->CreateEditPoint(), true);
		(*ppEditPoint)->AddRef();
		pTextPoint->get_Line(&iLine);
		pTextPoint->get_Char(&iChar);
		(*ppEditPoint)->MoveTo(iLine, iChar);
	}
	return S_OK;
}

/// @see	ITextProcessor::Delete
STDMETHODIMP CTextProcessor::Delete() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_DELETE, 0L);
	return S_OK;
}

/// @see	ITextProcessor::EndEditCollection
STDMETHODIMP CTextProcessor::EndEditCollection() {
	m_editor.GetDocument()->EndEditCollection();
	return S_OK;
}

/// @see	ITextProcessor::FindText
STDMETHODIMP CTextProcessor::FindText(BSTR bstrFindWhat, VARIANT_BOOL* pbFound) {
	if(bstrFindWhat == 0)
		return E_INVALIDARG;

	CAlphaView&	view = *m_editor.GetActiveView();
	bool		bFound;

	if(pbFound != 0)
		*pbFound = VARIANT_FALSE;
	view.SetSearchText(bstrFindWhat);
	try {
		bFound = toBoolean(view.ExecCommand(CMDID_SEARCH_FINDNEXT));
	} catch(ERegExpPatternIsInvalid&) {
		CComException	e(SCRIPT_E_BADREGEXP, IID_ITextProcessor, OLESTR("Ambient.TextProcessor.FindText"));
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	} catch(EMiscellaneousRegExpError&) {
	}
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

/// @see	ITextProcessor::Freeze
STDMETHODIMP CTextProcessor::Freeze() {
	if(CAlphaView* pView = m_editor.GetActiveView())
		pView->Freeze();
	return S_OK;
}

/// @see	ITextProcessor::get_ClipboardRing
STDMETHODIMP CTextProcessor::get_ClipboardRing(IClipboardRing** ppClipboardRing) {
	VERIFY_POINTER(ppClipboardRing);

	if(0 == (*ppClipboardRing = new CAutomationClipboardRing(CEditView::GetClipboardRing())))
		return E_OUTOFMEMORY;
	(*ppClipboardRing)->AddRef();
	return S_OK;
}

/// @see	ITextProcessor::get_Document
STDMETHODIMP CTextProcessor::get_Document(ITextDocument** ppDocument) {
	VERIFY_POINTER(ppDocument);

	if(0 == (*ppDocument = new CTextDocument(m_app, *m_editor.GetDocument())))
		return E_OUTOFMEMORY;
	(*ppDocument)->AddRef();
	return S_OK;
}

/// @see	ITextProcessor::get_Lexer
STDMETHODIMP CTextProcessor::get_Lexer(ILexer** ppLexer) {
	VERIFY_POINTER(ppLexer);
	if(0 == (*ppLexer = new CAutomationLexer(m_editor.GetActiveView()->GetLexer())))
		return E_OUTOFMEMORY;
	(*ppLexer)->AddRef();
	return S_OK;
}

/// @see	ITextProcessor::get_OvertypeMode
STDMETHODIMP CTextProcessor::get_OvertypeMode(VARIANT_BOOL* pbOvertypeMode) {
	VERIFY_POINTER(pbOvertypeMode);
	*pbOvertypeMode = toVariantBoolean(m_editor.GetActiveView()->IsOvertypeMode());
	return S_OK;
}

/// @see	ITextProcessor::get_Preferences
STDMETHODIMP CTextProcessor::get_Preferences(IEditorPreferences** ppPreferences) {
	VERIFY_POINTER(ppPreferences);

	if(0 == (*ppPreferences = new CEditorPreferences(*m_editor.GetActiveView())))
		return E_OUTOFMEMORY;
	(*ppPreferences)->AddRef();
	return S_OK;
}

/// @see	ITextProcessor::get_Selection
STDMETHODIMP CTextProcessor::get_Selection(ITextSelection** ppSelection) {
	VERIFY_POINTER(ppSelection);
	return m_editor.GetAutomation(m_app, IID_ITextSelection, reinterpret_cast<IDispatch**>(ppSelection));
}

/// @see	ITextProcessor::get_TextSearcher
STDMETHODIMP CTextProcessor::get_TextSearcher(ITextSearcher** ppTextSearcher) {
	VERIFY_POINTER(ppTextSearcher);

	if(0 == (*ppTextSearcher = new CAutomationTextSearcher(m_editor)))
		return E_OUTOFMEMORY;
	(*ppTextSearcher)->AddRef();
	return S_OK;
}

/// @see	ITextProcessor::Indent
STDMETHODIMP CTextProcessor::Indent() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_TABINDENT, false);
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CTextProcessor::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_CLIPBOARDRING:	CALL_GETTER_ACTX(ClipboardRing, IClipboardRing);
		case DISPID_TEXTPROCESSOR_DOCUMENT:			CALL_GETTER_ACTX(Document, ITextDocument);
		case DISPID_TEXTPROCESSOR_LEXER:			CALL_GETTER_ACTX(Lexer, ILexer);
		case DISPID_TEXTPROCESSOR_OVERTYPEMODE:		CALL_GETTER(OvertypeMode, VT_BOOL);
		case DISPID_TEXTPROCESSOR_PREFERENCES:		CALL_GETTER_ACTX(Preferences, IEditorPreferences);
		case DISPID_TEXTPROCESSOR_SELECTION:		CALL_GETTER_ACTX(Selection, ITextSelection);
		case DISPID_TEXTPROCESSOR_TEXTSEARCHER:		CALL_GETTER_ACTX(TextSearcher, ITextSearcher);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_OVERTYPEMODE:	CALL_PUTTER(OvertypeMode, VT_BOOL);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_BACKSPACE:			CALL_METHOD_0(BackSpace);
		case DISPID_TEXTPROCESSOR_BEGINEDITCOLLECTION:	CALL_METHOD_0(BeginEditCollection);
		case DISPID_TEXTPROCESSOR_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint(
				reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTPROCESSOR_DELETE:				CALL_METHOD_0(Delete);
		case DISPID_TEXTPROCESSOR_ENDEDITCOLLECTION:	CALL_METHOD_0(EndEditCollection);
		case DISPID_TEXTPROCESSOR_FINDTEXT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			COERCE_RETURN(VT_BOOL);
			hr = FindText(args[0].bstrVal, (pVarResult != 0) ? &pVarResult->boolVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_TEXTPROCESSOR_FREEZE:					CALL_METHOD_0(Freeze);
		case DISPID_TEXTPROCESSOR_INDENT:					CALL_METHOD_0(Indent);
		case DISPID_TEXTPROCESSOR_NEWLINE:					CALL_METHOD_0(NewLine);
		case DISPID_TEXTPROCESSOR_PASTE:					CALL_METHOD_0(Paste);
		case DISPID_TEXTPROCESSOR_PASTEFROMCLIPBOARDRING:	CALL_METHOD_0(PasteFromClipboardRing);
		case DISPID_TEXTPROCESSOR_UNFREEZE:					CALL_METHOD_0(Unfreeze);
		case DISPID_TEXTPROCESSOR_UNINDENT:					CALL_METHOD_0(Unindent);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	ITextProcessor::NewLine
STDMETHODIMP CTextProcessor::NewLine() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_BREAK, 0L);
	return S_OK;
}

/// @see	ITextProcessor::Paste
STDMETHODIMP CTextProcessor::Paste() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTE, 0L);
	return S_OK;
}

/// @see	ITextProcessor::PasteFromClipboardRing
STDMETHODIMP CTextProcessor::PasteFromClipboardRing() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTEFROMCLIPBOARDRING, 0L);
	return S_OK;
}

/// @see	ITextProcessor::put_OvertypeMode
STDMETHODIMP CTextProcessor::put_OvertypeMode(VARIANT_BOOL bOvertypeMode) {
	m_editor.GetActiveView()->SetOvertypeMode(toBoolean(bOvertypeMode));
	return S_OK;
}

/// @see	ITextProcessor::Unfreeze
STDMETHODIMP CTextProcessor::Unfreeze() {
	if(CAlphaView* pView = m_editor.GetActiveView())
		pView->Unfreeze();
	return S_OK;
}

/// @see	ITextProcessor::Unindent
STDMETHODIMP CTextProcessor::Unindent() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_TABINDENT, true);
	return S_OK;
}


// CTextSelection class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSelection::CTextSelection(CAlphaEditController& editor) : SAFE_MARK, m_editor(editor) {
}

/// @see	ITextSelection::Cancel
STDMETHODIMP CTextSelection::Cancel() {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_CANCELSELECTION);
	return S_OK;
}

/// @see	ITextSelection::CharNext
STDMETHODIMP CTextSelection::CharNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return CharPrev(bExtend, -cOffset);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_CHARNEXTEXTEND : CMDID_MOVE_CHARNEXT, cOffset);
	return S_OK;
}

/// @see	ITextSelection::CharPrev
STDMETHODIMP CTextSelection::CharPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return CharNext(bExtend, -cOffset);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_CHARPREVEXTEND : CMDID_MOVE_CHARPREV, cOffset);
	return S_OK;
}

/// @see	ITextSelection::Convert
STDMETHODIMP CTextSelection::Convert(AmbientConvertType ct) {
	return E_NOTIMPL;
}

/// @see	ITextSelection::Copy
STDMETHODIMP CTextSelection::Copy(VARIANT_BOOL bAlsoSendToClipboardRing /* = VARIANT_TRUE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_COPY, toBoolean(bAlsoSendToClipboardRing));
	return S_OK;
}

/// @see	ITextSelection::Cut
STDMETHODIMP CTextSelection::Cut(VARIANT_BOOL bAlsoSendToClipboardRing /* = VARIANT_TRUE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_CUT, toBoolean(bAlsoSendToClipboardRing));
	return S_OK;
}

/// @see	ITextSelection::get_ActiveEndGreater
STDMETHODIMP CTextSelection::get_ActiveEndGreater(VARIANT_BOOL* pbActiveEndGreater) {
	VERIFY_POINTER(pbActiveEndGreater);
	CCharPos	posBegin, posEnd;
	m_editor.GetActiveView()->GetSel(posBegin, posEnd);
	*pbActiveEndGreater = toVariantBoolean(posBegin < posEnd);
	return S_OK;
}

/// @see	ITextSelection::get_ActivePoint
STDMETHODIMP CTextSelection::get_ActivePoint(ITextPoint** ppActivePoint) {
	VERIFY_POINTER(ppActivePoint);

	CEditPoint*	pActivePoint = m_editor.GetActiveView()->CreateEditPoint();

	pActivePoint->MoveToPoint(m_editor.GetActiveView()->GetActivePoint());
	*ppActivePoint = new CTextPoint(*pActivePoint, false);
	(*ppActivePoint)->AddRef();
	return S_OK;
}

/// @see	ITextSelection::get_AnchorPoint
STDMETHODIMP CTextSelection::get_AnchorPoint(ITextPoint** ppAnchorPoint) {
	VERIFY_POINTER(ppAnchorPoint);

	CEditPoint*	pAnchorPoint = m_editor.GetActiveView()->CreateEditPoint();

	pAnchorPoint->MoveToPoint(m_editor.GetActiveView()->GetActivePoint());
	*ppAnchorPoint = new CTextPoint(*pAnchorPoint, false);
	(*ppAnchorPoint)->AddRef();
	return S_OK;
}

/// @see	ITextSelection::get_BottomPoint
STDMETHODIMP CTextSelection::get_BottomPoint(ITextPoint** ppBottomPoint) {
	VERIFY_POINTER(ppBottomPoint);

	CEditPoint*	pBottomPoint = m_editor.GetActiveView()->CreateEditPoint();
	CCharPos	posAnchor, posActive;

	m_editor.GetActiveView()->GetSel(posAnchor, posActive);
	pBottomPoint->MoveToPoint(max(posAnchor, posActive));
	*ppBottomPoint = new CTextPoint(*pBottomPoint, false);
	(*ppBottomPoint)->AddRef();
	return S_OK;
}

/// @see	ITextSelection::get_Empty
STDMETHODIMP CTextSelection::get_Empty(VARIANT_BOOL* pbEmpty) {
	VERIFY_POINTER(pbEmpty);
	*pbEmpty = toVariantBoolean(!m_editor.GetActiveView()->HasSelection());
	return S_OK;
}

/// @see	ITextSelection::get_Text
STDMETHODIMP CTextSelection::get_Text(BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	*pbstrText = ::SysAllocString(m_editor.GetActiveView()->GetSelection().c_str());
	return (*pbstrText != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	ITextSelection::get_TextRanges
STDMETHODIMP CTextSelection::get_TextRanges(ITextRanges** ppTextRanges) {
	VERIFY_POINTER(ppTextRanges);
	*ppTextRanges = 0;
	return E_NOTIMPL;
}

/// @see	ITextSelection::get_TopPoint
STDMETHODIMP CTextSelection::get_TopPoint(ITextPoint** ppTopPoint) {
	VERIFY_POINTER(ppTopPoint);

	CEditPoint*	pTopPoint = m_editor.GetActiveView()->CreateEditPoint();
	CCharPos	posAnchor, posActive;

	m_editor.GetActiveView()->GetSel(posAnchor, posActive);
	pTopPoint->MoveToPoint(min(posAnchor, posActive));
	*ppTopPoint = new CTextPoint(*pTopPoint, false);
	(*ppTopPoint)->AddRef();
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CTextSelection::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_ACTIVEENDGREATER:	CALL_GETTER(ActiveEndGreater, VT_BOOL);
		case DISPID_TEXTSELECTION_ACTIVEPOINT:		CALL_GETTER_ACTX(ActivePoint, ITextPoint);
		case DISPID_TEXTSELECTION_ANCHORPOINT:		CALL_GETTER_ACTX(AnchorPoint, ITextPoint);
		case DISPID_TEXTSELECTION_BOTTOMPOINT:		CALL_GETTER_ACTX(BottomPoint, ITextPoint);
		case DISPID_TEXTSELECTION_EMPTY:			CALL_GETTER(Empty, VT_BOOL);
		case DISPID_TEXTSELECTION_TEXT:				CALL_GETTER(Text, VT_BSTR);
		case DISPID_TEXTSELECTION_TEXTRANGES:		CALL_GETTER_ACTX(TextRanges, ITextRanges);
		case DISPID_TEXTSELECTION_TOPPOINT:			CALL_GETTER_ACTX(TopPoint, ITextPoint);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_CANCEL:	CALL_METHOD_0(Cancel);
		case DISPID_TEXTSELECTION_CHARNEXT:
			if(pDispParams->cArgs == 0)
				return CharNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return CharNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return CharNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CHARPREV:
			if(pDispParams->cArgs == 0)
				return CharPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return CharPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return CharPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CONVERT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return Convert(static_cast<AmbientConvertType>(args[0].iVal));
		case DISPID_TEXTSELECTION_COPY:
			if(pDispParams->cArgs == 0)
				return Copy();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Copy(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CUT:
			if(pDispParams->cArgs == 0)
				return Cut();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Cut(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEDOWN:
			if(pDispParams->cArgs == 0)
				return LineDown();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return LineDown(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return LineDown(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEUP:
			if(pDispParams->cArgs == 0)
				return LineUp();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return LineUp(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return LineUp(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETO:
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_UI4);
				COERCE_ARGUMENT_AT(0, VT_UI4);
				return MoveTo(args[1].ulVal, args[0].ulVal);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_UI4);
				COERCE_ARGUMENT_AT(1, VT_UI4);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveTo(args[2].ulVal, args[1].ulVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOENDOFDOCUMENT:
			if(pDispParams->cArgs == 0)
				return MoveToEndOfDocument();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToEndOfDocument(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOENDOFLINE:
			if(pDispParams->cArgs == 0)
				return MoveToEndOfLine();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToEndOfLine(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETONEXTBOOKMARK:
			if(pDispParams->cArgs == 0)
				return MoveToNextBookmark();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToNextBookmark(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOPREVIOUSBOOKMARK:
			if(pDispParams->cArgs == 0)
				return MoveToPreviousBookmark();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToPreviousBookmark(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOSTARTOFDOCUMENT:
			if(pDispParams->cArgs == 0)
				return MoveToStartOfDocument();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToStartOfDocument(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOSTARTOFLINE:
			if(pDispParams->cArgs == 0)
				return MoveToStartOfLine();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToStartOfLine(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToStartOfLine(args[1].boolVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEDOWN:
			if(pDispParams->cArgs == 0)
				return PageDown();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return PageDown(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return PageDown(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEUP:
			if(pDispParams->cArgs == 0)
				return PageUp();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return PageUp(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return PageUp(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PASTE:					CALL_METHOD_0(Paste);
		case DISPID_TEXTSELECTION_PASTEFROMCLIPBOARDRING:	CALL_METHOD_0(PasteFromClipboardRing);
		case DISPID_TEXTSELECTION_REPLACE:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return Replace(args[0].bstrVal);
			} else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				return Replace(args[1].bstrVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_SELECTALL:	CALL_METHOD_0(SelectAll);
		case DISPID_TEXTSELECTION_SELECTLINE:	CALL_METHOD_1(SelectLine, VT_I4);
		case DISPID_TEXTSELECTION_SWAPANCHOR:	CALL_METHOD_0(SwapAnchor);
		case DISPID_TEXTSELECTION_WORDENDNEXT:
			if(pDispParams->cArgs == 0)
				return WordEndNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordEndNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordEndNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDENDPREV:
			if(pDispParams->cArgs == 0)
				return WordEndPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordEndPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordEndPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDNEXT:
			if(pDispParams->cArgs == 0)
				return WordNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDPREV:
			if(pDispParams->cArgs == 0)
				return WordPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	ITextSelection::LineDown
STDMETHODIMP CTextSelection::LineDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineUp(bExtend, -cLines);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEDOWNEXTEND : CMDID_MOVE_LINEDOWN, cLines);
	return S_OK;
}

/// @see	ITextSelection::LineUp
STDMETHODIMP CTextSelection::LineUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineDown(bExtend, -cLines);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEUPEXTEND : CMDID_MOVE_LINEUP, cLines);
	return S_OK;
}

/// @see	ITextSelection::MoveTo
STDMETHODIMP CTextSelection::MoveTo(
		long iLine, long iChar, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	if(bExtend) {
		CCharPos	posBegin, posEnd;
		m_editor.GetActiveView()->GetSel(posBegin, posEnd);
		m_editor.GetActiveView()->SetSel(posBegin, CCharPos(iLine, iChar));
	} else
		m_editor.GetActiveView()->SetSelWithoutSelection(iLine, iChar);
	return S_OK;
}

/// @see	ITextSelection::MoveToEndOfDocument
STDMETHODIMP CTextSelection::MoveToEndOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_ENDEXTEND : CMDID_MOVE_END);
	return S_OK;
}

/// @see	ITextSelection::MoveToEndOfLine
STDMETHODIMP CTextSelection::MoveToEndOfLine(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEENDEXTEND : CMDID_MOVE_LINEEND);
	return S_OK;
}

/// @see	ITextSelection::MoveToNextBookmark
STDMETHODIMP CTextSelection::MoveToNextBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_BOOKMARKNEXT);
	return S_OK;
}

/// @see	ITextSelection::MoveToPreviousBookmark
STDMETHODIMP CTextSelection::MoveToPreviousBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_BOOKMARKPREV);
	return S_OK;
}

/// @see	ITextSelection::MoveToStartOfDocument
STDMETHODIMP CTextSelection::MoveToStartOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_HOMEEXTEND : CMDID_MOVE_HOME);
	return S_OK;
}

/// @see	ITextSelection::MoveToStartOfLine
STDMETHODIMP CTextSelection::MoveToStartOfLine(
		VARIANT_BOOL bToFirstText /* = VARIANT_FALSE */, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEHOMEEXTEND : CMDID_MOVE_LINEHOME, bToFirstText);
	return S_OK;
}

/// @see	ITextSelection::PageDown
STDMETHODIMP CTextSelection::PageDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageUp(bExtend, cPages);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_PAGEDOWNEXTEND : CMDID_MOVE_PAGEDOWN, cPages);
	return S_OK;
}

/// @see	ITextSelection::PageUp
STDMETHODIMP CTextSelection::PageUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageDown(bExtend, cPages);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_PAGEUPEXTEND : CMDID_MOVE_PAGEUP, cPages);
	return S_OK;
}

/// @see	ITextSelection::Paste
STDMETHODIMP CTextSelection::Paste() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTE);
	return S_OK;
}

/// @see	ITextSelection::PasteFromClipboardRing
STDMETHODIMP CTextSelection::PasteFromClipboardRing() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTEFROMCLIPBOARDRING);
	return S_OK;
}

/// @see	ITextSelection::Replace
STDMETHODIMP CTextSelection::Replace(BSTR bstrText) {
	m_editor.GetActiveView()->ReplaceSel((bstrText != 0) ? bstrText : L"");
	return S_OK;
}

/// @see	ITextSelection::SelectAll
STDMETHODIMP CTextSelection::SelectAll() {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_SELECTALL);
	return S_OK;
}

/// @see	ITextSelection::SelectLine
STDMETHODIMP CTextSelection::SelectLine(long iLine) {
	m_editor.GetActiveView()->SetSel(CCharPos(iLine, 0), CCharPos(iLine, -1));
	return S_OK;
}

/// @see	ITextSelection::SwapAnchor
STDMETHODIMP CTextSelection::SwapAnchor() {
	CCharPos	posBegin, posEnd;
	m_editor.GetActiveView()->GetSel(posBegin, posEnd);
	m_editor.GetActiveView()->SetSel(posEnd, posBegin);
	return S_OK;
}

/// @see	ITextSelection::Tabify
STDMETHODIMP CTextSelection::Tabify() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_TABIFY);
	return S_OK;
}

/// @see	ITextSelection::Untabify
STDMETHODIMP CTextSelection::Untabify() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_UNTABIFY);
	return S_OK;
}

/// @see	ITextSelection::WordEndNext
STDMETHODIMP CTextSelection::WordEndNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndPrev(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDENDNEXTEXTEND : CMDID_MOVE_WORDENDNEXT, cWords);
	return S_OK;
}

/// @see	ITextSelection::WordEndPrev
STDMETHODIMP CTextSelection::WordEndPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndNext(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDENDPREVEXTEND : CMDID_MOVE_WORDENDPREV, cWords);
	return S_OK;
}

/// @see	ITextSelection::WordNext
STDMETHODIMP CTextSelection::WordNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordPrev(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDNEXTEXTEND : CMDID_MOVE_WORDNEXT, cWords);
	return S_OK;
}

/// @see	ITextSelection::WordPrev
STDMETHODIMP CTextSelection::WordPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordNext(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDPREVEXTEND : CMDID_MOVE_WORDPREV, cWords);
	return S_OK;
}


// CTextPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pos			ɂȂҏW_B̕ҏW_̓fXgN^Ŕj󂷂
 *	@param bIsEditPoint	IEditPoint ̏ꍇ trueBITextPoint ̏ꍇ false
 */
CTextPoint::CTextPoint(CEditPoint& pos, bool bIsEditPoint) : SAFE_MARK, m_pos(pos), m_bIsEditPoint(bIsEditPoint) {
}

/// fXgN^
CTextPoint::~CTextPoint() {
	delete &m_pos;
}

/// @see	ITextPoint::CharNext
STDMETHODIMP CTextPoint::CharNext(long cch /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.CharNext(cch);
	return S_OK;
}

/// @see	ITextPoint::CharRight
STDMETHODIMP CTextPoint::CharPrev(long cch /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.CharPrev(cch);
	return S_OK;
}

/// @see	IEditPoint::Convert
STDMETHODIMP CTextPoint::Convert(AmbientConvertType ct, VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Convert(CCharPos(iLine, iChar), static_cast<RangeConvertType>(ct));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Convert(var.lVal, static_cast<RangeConvertType>(ct));
	else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::Copy
STDMETHODIMP CTextPoint::Copy(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Copy(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Copy(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::CreateEditPoint
STDMETHODIMP CTextPoint::CreateEditPoint(IEditPoint** ppEditPoint) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(ppEditPoint != 0) {
		*ppEditPoint = new CTextPoint(*m_pos.GetView()->CreateEditPoint(), true);
		(*ppEditPoint)->AddRef();
		(*ppEditPoint)->MoveTo(m_pos.GetLineNumber(), m_pos.GetCharNumber());
	}
	return S_OK;
}

/// @see	IEditPoint::Cut
STDMETHODIMP CTextPoint::Cut(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Cut(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Cut(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	IEditPoint::Delete
STDMETHODIMP CTextPoint::Delete(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Delete(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Delete(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	IEditPoint:DestructiveInsert
STDMETHODIMP CTextPoint::DestructiveInsert(BSTR bstrText) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.DestructiveInsert(bstrText);
	return S_OK;
}

/// @see	ITextPoint::EnsureCentered
STDMETHODIMP CTextPoint::EnsureCentered(VARIANT varOther, VARIANT_BOOL* pbInEditorRect) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*pbInEditorRect = m_pos.EnsureCentered(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4))) {
		if(pbInEditorRect != 0)
			*pbInEditorRect = m_pos.EnsureCentered(var.lVal);
	} else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::EnsureVisible
STDMETHODIMP CTextPoint::EnsureVisible(VARIANT varOther, VARIANT_BOOL* pbInEditorRect) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*pbInEditorRect = m_pos.EnsureVisible(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4))) {
		if(pbInEditorRect != 0)
			*pbInEditorRect = m_pos.EnsureVisible(var.lVal);
	} else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::EqualTo
STDMETHODIMP CTextPoint::EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbEqual != 0) {
		long	iLine, iChar;

		pTextPoint->get_Line(&iLine);
		pTextPoint->get_Char(&iChar);
		*pbEqual = toVariantBoolean(
			m_pos.GetLineNumber() == iLine && m_pos.GetCharNumber() == iChar);
	}
	return S_OK;
}

/// @see	ITextPoint::get_AbsoluteCharOffset
STDMETHODIMP CTextPoint::get_AbsoluteCharOffset(long* pnAbsoluteCharOffset) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnAbsoluteCharOffset);
	*pnAbsoluteCharOffset = m_pos.GetAbsoluteCharOffset();
	return S_OK;
}

/// @see	ITextPoint::get_AtEndOfDocument
STDMETHODIMP CTextPoint::get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtEndOfDocument);
	*pbAtEndOfDocument = toVariantBoolean(m_pos.IsEndOfDocument());
	return S_OK;
}

/// @see	ITextPoint::get_AtEndOfLine
STDMETHODIMP CTextPoint::get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtEndOfLine);
	*pbAtEndOfLine = toVariantBoolean(m_pos.IsEndOfLine());
	return S_OK;
}

/// @see	ITextPoint::get_AtStartOfDocument
STDMETHODIMP CTextPoint::get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtStartOfDocument);
	*pbAtStartOfDocument = toVariantBoolean(m_pos.IsStartOfDocument());
	return S_OK;
}

/// @see	ITextPoint::get_AtStartOfLine
STDMETHODIMP CTextPoint::get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtStartOfLine);
	*pbAtStartOfLine = toVariantBoolean(m_pos.IsStartOfLine());
	return S_OK;
}

/// @see	ITextPoint::get_Char
STDMETHODIMP CTextPoint::get_Char(long* pnChar) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnChar);
	*pnChar = m_pos.GetCharNumber();
	return S_OK;
}

/// @see	IEditPoint::get_CharCountBehavior
STDMETHODIMP CTextPoint::get_CharCountBehavior(AmbientCharCountBehavior* pCharCountBehavior) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pCharCountBehavior);
	*pCharCountBehavior = static_cast<AmbientCharCountBehavior>(m_pos.GetUnitBehavior());
	return S_OK;
}

/// @see	ITextPoint::get_Column
STDMETHODIMP CTextPoint::get_Column(long* pnColumn) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnColumn);
	*pnColumn = m_pos.GetColumnNumber();
	return S_OK;
}

/// @see	ITextPoint::get_Line
STDMETHODIMP CTextPoint::get_Line(long* pnLine) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnLine);
	*pnLine = m_pos.GetLineNumber();
	return S_OK;
}

/// @see	ITextPoint::get_LineLength
STDMETHODIMP CTextPoint::get_LineLength(long* pnLineLength) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnLineLength);
	*pnLineLength = m_pos.GetLineLength();
	return S_OK;
}

/// @see	IEditPoint::put_CharCountBehavior
STDMETHODIMP CTextPoint::put_CharCountBehavior(AmbientCharCountBehavior charCountBehavior) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.SetUnitBehavior(static_cast<UnitBehavior>(charCountBehavior));
	return S_OK;
}

/// @see	IEditPoint::GetText
STDMETHODIMP CTextPoint::GetText(VARIANT varOther, BSTR* pbstrText) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pbstrText != 0) {
		CComVariant	var;
		HRESULT		hr;

		::VariantInit(&var);

		if(varOther.vt == VT_DISPATCH) {
			GENERATE_CHARPOS_FROM_TEXTPOINT();
			*pbstrText = ::SysAllocString(m_pos.GetText(CCharPos(iLine, iChar)).c_str());
		} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
			*pbstrText = ::SysAllocString(m_pos.GetText(var.lVal).c_str());
		else {
			*pbstrText = 0;
			return hr;
		}
	}
	return (*pbstrText != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	ITextPoint::GreaterThan
STDMETHODIMP CTextPoint::GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbGreater != 0) {
		unsigned long	iLine, iChar;

		pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
		if(m_pos.GetLineNumber() > iLine)
			*pbGreater = VARIANT_TRUE;
		else if(m_pos.GetLineNumber() < iLine)
			*pbGreater = VARIANT_FALSE;
		else {
			pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
			*pbGreater = toVariantBoolean(m_pos.GetCharNumber() > iChar);
		}
	}
	return S_OK;
}

/// @see	IEditPoint::Indent
STDMETHODIMP CTextPoint::Indent(VARIANT varOther, short nLevel /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.TabIndent(CCharPos(iLine, iChar), nLevel);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

/// @see	IEditPoint::Insert
STDMETHODIMP CTextPoint::Insert(BSTR bstrText) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.Insert(bstrText);
	return S_OK;
}

/// @see	ITextPoint::Invoke
STDMETHODIMP CTextPoint::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPOINT_ABSOLUTECHAROFFSET:	CALL_GETTER(AbsoluteCharOffset, VT_I4);
		case DISPID_TEXTPOINT_ATENDOFDOCUMENT:		CALL_GETTER(AtEndOfDocument, VT_BOOL);
		case DISPID_TEXTPOINT_ATENDOFLINE:			CALL_GETTER(AtEndOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATSTARTOFDOCUMENT:	CALL_GETTER(AtStartOfDocument, VT_BOOL);
		case DISPID_TEXTPOINT_ATSTARTOFLINE:		CALL_GETTER(AtStartOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_CHAR:					CALL_GETTER(Char, VT_I4);
		case DISPID_TEXTPOINT_COLUMN:				CALL_GETTER(Column, VT_I4);
		case DISPID_TEXTPOINT_LINE:					CALL_GETTER(Line, VT_I4);
		case DISPID_TEXTPOINT_LINELENGTH:			CALL_GETTER(LineLength, VT_I4);
		default:
			if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_CHARCOUNTBEHAVIOR) {
				CALL_GETTER_ENUM(CharCountBehavior, AmbientCharCountBehavior);
			}
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_CHARCOUNTBEHAVIOR) {
			CALL_PUTTER_ENUM(CharCountBehavior, AmbientCharCountBehavior);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPOINT_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint((pVarResult != 0) ?
				reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTPOINT_ENSURECENTERED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_VARIANT);
			COERCE_RETURN(VT_BOOL);
			return EnsureCentered(args[0], (pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_ENSUREVISIBLE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_VARIANT);
			COERCE_RETURN(VT_BOOL);
			return EnsureVisible(args[0], (pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_EQUALTO:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return EqualTo(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_GREATERTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return GreaterThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_LESSTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return LessThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		default:
			if(m_bIsEditPoint) {
				switch(dispidMember) {
				case DISPID_EDITPOINT_CHARNEXT:
					if(pDispParams->cArgs == 0)
						return CharNext();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return CharNext(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CHARPREV:
					if(pDispParams->cArgs == 0)
						return CharPrev();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return CharPrev(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CONVERT:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_I2);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Convert(
						static_cast<AmbientConvertType>(args[1].iVal), args[0]);
				case DISPID_EDITPOINT_COPY:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Copy(args[0]);
				case DISPID_EDITPOINT_CUT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Cut(args[0]);
				case DISPID_EDITPOINT_DELETE:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Delete(args[0]);
				case DISPID_EDITPOINT_DESTRUCTIVEINSERT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_BSTR);
					return DestructiveInsert(args[0].bstrVal);
				case DISPID_EDITPOINT_GETTEXT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					COERCE_RETURN(VT_BSTR);
					return GetText(args[0], (pVarResult != 0) ? &pVarResult->bstrVal : 0);
				case DISPID_EDITPOINT_INDENT:
					if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_VARIANT);
						return Indent(args[0]);
					} else if(pDispParams->cArgs == 2) {
						COERCE_ARGUMENT_AT(1, VT_VARIANT);
						COERCE_ARGUMENT_AT(0, VT_I2);
						return Indent(args[1], args[0].iVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_INSERT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_BSTR);
					return Insert(args[0].bstrVal);
				case DISPID_EDITPOINT_LINEDOWN:
					if(pDispParams->cArgs == 0)
						return LineDown();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return LineDown(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_LINEUP:
					if(pDispParams->cArgs == 0)
						return LineUp();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return LineUp(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_MOVETO:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_I4);
					COERCE_ARGUMENT_AT(0, VT_I4);
					return MoveTo(args[1].lVal, args[0].lVal);
				case DISPID_EDITPOINT_MOVETOABSOLUTEOFFSET:		CALL_METHOD_1(MoveToAbsoluteOffset, VT_I4);
				case DISPID_EDITPOINT_MOVETOENDOFDOCUMENT:		CALL_METHOD_0(MoveToEndOfDocument);
				case DISPID_EDITPOINT_MOVETOENDOFLINE:			CALL_METHOD_0(MoveToEndOfLine);
				case DISPID_EDITPOINT_MOVETONEXTBOOKMARK:		CALL_METHOD_0(MoveToNextBookmark);
				case DISPID_EDITPOINT_MOVETOPREVIOUSBOOKMARK:	CALL_METHOD_0(MoveToPreviousBookmark);
				case DISPID_EDITPOINT_MOVETOSTARTOFDOCUMENT:	CALL_METHOD_0(MoveToStartOfDocument);
				case DISPID_EDITPOINT_MOVETOSTARTOFLINE:
					if(pDispParams->cArgs == 0)
						return MoveToStartOfLine();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_BOOL);
						return MoveToStartOfLine(args[0].boolVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_NEWLINE:					CALL_METHOD_0(NewLine);
				case DISPID_EDITPOINT_PAGEDOWN:
					if(pDispParams->cArgs == 0)
						return PageDown();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return PageDown(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PAGEUP:
					if(pDispParams->cArgs == 0)
						return PageUp();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return PageUp(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PASTE:
					if(pDispParams->cArgs == 0) {
						args[0] = 0;
						return Paste(args[0]);
					} else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_VARIANT);
						return Paste(args[0]);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_REPLACE:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_BSTR);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Replace(args[1].bstrVal, args[0]);
				case DISPID_EDITPOINT_TRANSPOSECHARS:		CALL_METHOD_0(TransposeChars);
				case DISPID_EDITPOINT_TRANSPOSELINES:		CALL_METHOD_0(TransposeLines);
				case DISPID_EDITPOINT_TRANSPOSEPARAGRAPHS:	CALL_METHOD_0(TransposeParagraphs);
				case DISPID_EDITPOINT_TRANSPOSEWORDS:		CALL_METHOD_0(TransposeWords);
				case DISPID_EDITPOINT_UNINDENT:
					if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_VARIANT);
						return Unindent(args[0]);
					} else if(pDispParams->cArgs == 2) {
						COERCE_ARGUMENT_AT(1, VT_VARIANT);
						COERCE_ARGUMENT_AT(0, VT_I2);
						return Unindent(args[1], args[0].iVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDNEXT:
					if(pDispParams->cArgs == 0)
						return WordEndNext();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordEndNext(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDPREV:
					if(pDispParams->cArgs == 0)
						return WordEndPrev();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordEndPrev(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDNEXT:
					if(pDispParams->cArgs == 0)
						return WordNext();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordNext(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDPREV:
					if(pDispParams->cArgs == 0)
						return WordPrev();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordPrev(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				}
			}
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	ITextPoint::LessThan
STDMETHODIMP CTextPoint::LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbLess != 0) {
		unsigned long	iLine, iChar;

		pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
		if(m_pos.GetLineNumber() < iLine)
			*pbLess = VARIANT_TRUE;
		else if(m_pos.GetLineNumber() > iLine)
			*pbLess = VARIANT_FALSE;
		else {
			pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
			*pbLess = toVariantBoolean(m_pos.GetCharNumber() < iChar);
		}
	}
	return S_OK;
}

/// @see	ITextPoint::LineDown
STDMETHODIMP CTextPoint::LineDown(long cLines /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.LineDown(cLines);
	return S_OK;
}

/// @see	ITextPoint::LineUp
STDMETHODIMP CTextPoint::LineUp(long cLines /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.LineUp(cLines);
	return S_OK;
}

/// @see	ITextPoint::MoveTo
STDMETHODIMP CTextPoint::MoveTo(long iLine, long iChar) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToPoint(CCharPos(iLine, iChar));
	return S_OK;
}

/// @see	ITextPoint::MoveToAbsoluteOffset
STDMETHODIMP CTextPoint::MoveToAbsoluteOffset(long nOffset) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToAbsoluteCharOffset(nOffset);
	return S_OK;
}

/// @see	ITextPoint::MoveToEndOfDocument
STDMETHODIMP CTextPoint::MoveToEndOfDocument() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToEndOfDocument();
	return S_OK;
}

/// @see	ITextPoint::MoveToEndOfLine
STDMETHODIMP CTextPoint::MoveToEndOfLine() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToEndOfLine();
	return S_OK;
}

/// @see	ITextPoint::MoveToNextBookmark
STDMETHODIMP CTextPoint::MoveToNextBookmark() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToNextBookmark();
	return S_OK;
}

/// @see	ITextPoint::MoveToPreviousBookmark
STDMETHODIMP CTextPoint::MoveToPreviousBookmark() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToPrevBookmark();
	return S_OK;
}

/// @see	ITextPoint::MoveToStartOfDocument
STDMETHODIMP CTextPoint::MoveToStartOfDocument() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToStartOfDocument();
	return S_OK;
}

/// @see	ITextPoint::MoveToStartOfLine
STDMETHODIMP CTextPoint::MoveToStartOfLine(VARIANT_BOOL bToFirstText /* = VARIANT_FALSE */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToStartOfLine(toBoolean(bToFirstText));
	return S_OK;
}

/// @see	IEditPoint::NewLine
STDMETHODIMP CTextPoint::NewLine() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.NewLine();
	return S_OK;
}

/// @see	ITextPoint::PageDown
STDMETHODIMP CTextPoint::PageDown(long cPages /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.PageDown(cPages);
	return S_OK;
}

/// @see	ITextPoint::PageUp
STDMETHODIMP CTextPoint::PageUp(long cPages /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.PageUp(cPages);
	return S_OK;
}

/// @see	IEditPoint::Paste
STDMETHODIMP CTextPoint::Paste(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Paste(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Paste(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	IEditPoint::Replace
STDMETHODIMP CTextPoint::Replace(BSTR bstrText, VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	HRESULT	hr;

	m_pos.GetView()->GetDocument()->BeginEditCollection();
	if(FAILED(hr = Delete(varOther))
			|| FAILED(hr = Insert(bstrText))) {
		m_pos.GetView()->GetDocument()->EndEditCollection();
		return hr;
	}
	m_pos.GetView()->GetDocument()->EndEditCollection();
	return S_OK;
}

/// @see	IEditPoint::TransposeChars
STDMETHODIMP CTextPoint::TransposeChars() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.TransposeChars();
	return S_OK;
}

/// @see	IEditPoint::TransposeLines
STDMETHODIMP CTextPoint::TransposeLines() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.TransposeLines();
	return S_OK;
}

/// @see	IEditPoint::TransposeParagraphs
STDMETHODIMP CTextPoint::TransposeParagraphs() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
//	m_pos.TransposeParagraphs();
//	return S_OK;
	return E_NOTIMPL;
}

/// @see	IEditPoint::TransposeWords
STDMETHODIMP CTextPoint::TransposeWords() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.TransposeWords();
	return S_OK;
}

/// @see	IEditPoint::Unindent
STDMETHODIMP CTextPoint::Unindent(VARIANT varOther, short nLevel /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	VARIANT	var;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.TabIndent(CCharPos(iLine, iChar), -nLevel);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

/// @see	ITextPoint::WordEndNext
STDMETHODIMP CTextPoint::WordEndNext(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordEndNext(cWords);
	return S_OK;
}

/// @see	ITextPoint::WordEndPrev
STDMETHODIMP CTextPoint::WordEndPrev(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordEndPrev(cWords);
	return S_OK;
}

/// @see	ITextPoint::WordNext
STDMETHODIMP CTextPoint::WordNext(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordNext(cWords);
	return S_OK;
}

/// @see	ITextPoint::WordPrev
STDMETHODIMP CTextPoint::WordPrev(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordPrev(cWords);
	return S_OK;
}


// CTextRange class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CTextRange::CTextRange(CEditPoint& pos1, CEditPoint& pos2) : SAFE_MARK, m_pos1(pos1), m_pos2(pos2) {
}

/// @see	ITextRange::get_EndPoint
STDMETHODIMP CTextRange::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);
//	*ppEndPoint = new CTextPoint(m_app, m_pRange->GetEndPoint());
//	(*ppEndPoint)->AddRef();
	return E_NOTIMPL;
}

/// @see	ITextRange::get_StartPoint
STDMETHODIMP CTextRange::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
//	*ppStartPoint = new CTextPoint(m_app, m_pRange->GetStartPoint());
//	(*ppStartPoint)->AddRef();
	return E_NOTIMPL;
}

/// @see	ITextRange::Invoke
STDMETHODIMP CTextRange::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTRANGE_ENDPOINT:		CALL_GETTER_ACTX(EndPoint, ITextPoint);
		case DISPID_TEXTRANGE_STARTPOINT:	CALL_GETTER_ACTX(StartPoint, ITextPoint);
		}
	}
	return DISP_E_MEMBERNOTFOUND;
}


// CAutomationLexer class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {
	Ascension::TokenType GetTokenTypeByName(BSTR bstrName) {
		static map<wstring, Ascension::TokenType>	ids;

		if(ids.empty()) {
			ids[L"whiteSpace"]			= TT_WHITESPACE;
			ids[L"tab"]					= TT_TAB;
			ids[L"keyword"]				= TT_KEYWORD;
			ids[L"annotation"]			= TT_ANNOTATION;
			ids[L"operator"]			= TT_OPERATOR;
			ids[L"identifier"]			= TT_IDENTIFIER;
			ids[L"numeral"]				= TT_NUMERAL;
			ids[L"number"]				= TT_NUMBER;
			ids[L"singleQuotation"]		= TT_SINGLEQUOTATION;
			ids[L"doubleQuotation"]		= TT_DOUBLEQUOTATION;
			ids[L"otherQuotation"]		= TT_OTHERQUOTATION;
			ids[L"asciiControl"]		= TT_ASCII_CONTROL;
			ids[L"unicodeControl"]		= TT_UNICODE_CONTROL;
			ids[L"unspecified"]			= TT_UNSPECIFIED;
/*			ids[L"normal"]				= ETT_NORMAL;
			ids[L"selection"]			= ETT_SELECTION;
			ids[L"inactiveSelection"]	= ETT_INACTIVE_SELECTION;
			ids[L"indicatorMargin"]		= ETT_INDICATOR_MARGIN;
			ids[L"lineNumber"]			= ETT_LINENUMBER;
			ids[L"emphaticLineNumber"]	= ETT_EMPHATIC_LINENUMBER;
			ids[L"matchBrackets"]		= ETT_MATCH_BRACKETS;
			ids[L"endOfLine"]			= ETT_END_OF_LINE;
			ids[L"endOfFile"]			= ETT_END_OF_FILE;
			ids[L"link"]				= ETT_LINK;
			ids[L"matchText"]			= ETT_MATCHTEXT;
*/		}
		if(bstrName == 0)
			return static_cast<Ascension::TokenType>(-1);
		map<wstring, Ascension::TokenType>::const_iterator	it = ids.find(bstrName);
		return (it != ids.end()) ? it->second : static_cast<Ascension::TokenType>(-1);
	}
}

/**
 *	RXgN^
 *	@param impl	Ϗ
 */
CAutomationLexer::CAutomationLexer(CLexer& impl) : SAFE_MARK, m_impl(impl) {
}

///	@see	ILexer::AddKeywords
STDMETHODIMP CAutomationLexer::AddKeywords(BSTR bstrKeywords, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(bstrKeywords == 0)
		return E_INVALIDARG;

	set<string_t>	setKeywords;
	wchar_t*		pCurrent = bstrKeywords;
	wchar_t*		pNext;

	while(*pCurrent != 0) {
		if(*pCurrent == L' ') {
			++pCurrent;
			continue;
		}
		pNext = wcschr(pCurrent, L' ');
		if(pNext != 0) {
			setKeywords.insert(string_t(pCurrent, pNext - pCurrent));
			pCurrent = pNext + 1;
		} else {
			setKeywords.insert(string_t(pCurrent));
			break;
		}
	}
	if(pnIdentifier != 0)
		*pnIdentifier = m_impl.AddKeywords(setKeywords);
	else
		m_impl.AddKeywords(setKeywords);
	return S_OK;
}

///	@see	ILexer::AddMultilineAnnotation
STDMETHODIMP CAutomationLexer::AddMultilineAnnotation(BSTR bstrStartDelimiter,
		BSTR bstrEndDelimiter, AmbientAnnotationRestriction ar, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(bstrStartDelimiter == 0 || bstrEndDelimiter == 0)
		return E_INVALIDARG;

	if(pnIdentifier != 0)
		*pnIdentifier = m_impl.AddMultilineAnnotation(bstrStartDelimiter,
							bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
	else
		m_impl.AddMultilineAnnotation(bstrStartDelimiter,
			bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
	return S_OK;
}

///	@see	ILexer::AddSinglelineAnnotation
STDMETHODIMP CAutomationLexer::AddSinglelineAnnotation(BSTR bstrStartDelimiter,
		BSTR bstrEndDelimiter, AmbientAnnotationRestriction ar, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(bstrStartDelimiter == 0)
		return E_INVALIDARG;

	if(bstrEndDelimiter == 0) {
		if(pnIdentifier != 0)
			*pnIdentifier = m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, static_cast<AnnotationRestriction>(ar));
		else
			m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, static_cast<AnnotationRestriction>(ar));
	} else {
		if(pnIdentifier != 0)
			*pnIdentifier = m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
		else
			m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
	}
	return S_OK;
}

/// @see	ILexer::get_CaseSensitive
STDMETHODIMP CAutomationLexer::get_CaseSensitive(VARIANT_BOOL* pbCaseSensitive) {
	VERIFY_POINTER(pbCaseSensitive);
	*pbCaseSensitive = toVariantBoolean(m_impl.IsCaseSensitive());
	return S_OK;
}

/// @see	ILexer::get_Freezed
STDMETHODIMP CAutomationLexer::get_Freezed(VARIANT_BOOL* pbFreezed) {
	VERIFY_POINTER(pbFreezed);
	*pbFreezed = toVariantBoolean(m_impl.IsFreezed());
	return S_OK;
}

/// @see	ILexer::get_NumberFormat
STDMETHODIMP CAutomationLexer::get_NumberFormat(AmbientNumberFormat* pNumberFormat) {
	VERIFY_POINTER(pNumberFormat);
	*pNumberFormat = static_cast<AmbientNumberFormat>(m_impl.GetNumberFormat());
	return S_OK;
}

/// @see	ILexer::get_TokenEnabled
STDMETHODIMP CAutomationLexer::get_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);

	const Ascension::TokenType	type = GetTokenTypeByName(bstrTokenName);
	if(type == -1)
		return E_INVALIDARG;
	*pbEnabled = toVariantBoolean(m_impl.IsTokenEnabled(type));
	return S_OK;
}

/// @see	ILexer::get_UnicodeAlphabetsEnabled
STDMETHODIMP CAutomationLexer::get_UnicodeAlphabetsEnabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_impl.IsUnicodeAlphabetsEnabled());
	return S_OK;
}

/// @see	ILexer::get_UnicodeWhiteSpacesEnabled
STDMETHODIMP CAutomationLexer::get_UnicodeWhiteSpacesEnabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_impl.IsUnicodeWhiteSpacesEnabled());
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationLexer::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	bool		bCreatedResult = false;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_LEXER_CASESENSITIVE:				CALL_GETTER(CaseSensitive, VT_BOOL);
		case DISPID_LEXER_FREEZED:						CALL_GETTER(Freezed, VT_BOOL);
		case DISPID_LEXER_NUMBERFORMAT:					CALL_GETTER_ENUM(NumberFormat, AmbientNumberFormat);
		case DISPID_LEXER_TOKENENABLED:					CALL_GETTER_1(TokenEnabled, VT_BOOL, VT_BSTR);
		case DISPID_LEXER_UNICODEALPHABETSENABLED:		CALL_GETTER(UnicodeAlphabetsEnabled, VT_BOOL);
		case DISPID_LEXER_UNICODEWHITESPACESENABLED:	CALL_GETTER(UnicodeWhiteSpacesEnabled, VT_BOOL);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_LEXER_CASESENSITIVE:				CALL_PUTTER(CaseSensitive, VT_BOOL);
		case DISPID_LEXER_FREEZED:						CALL_PUTTER(Freezed, VT_BOOL);
		case DISPID_LEXER_NUMBERFORMAT:					CALL_PUTTER_ENUM(NumberFormat, AmbientNumberFormat);
		case DISPID_LEXER_TOKENENABLED:					CALL_PUTTER_1(TokenEnabled, VT_BOOL, VT_BSTR);
		case DISPID_LEXER_UNICODEALPHABETSENABLED:		CALL_PUTTER(UnicodeAlphabetsEnabled, VT_BOOL);
		case DISPID_LEXER_UNICODEWHITESPACESENABLED:	CALL_PUTTER(UnicodeWhiteSpacesEnabled, VT_BOOL);
		}
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_LEXER_ADDKEYWORDS:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			COERCE_RETURN(VT_I4);
			return AddKeywords(args[0].bstrVal, (pVarResult != 0) ? &pVarResult->lVal : 0);
		case DISPID_LEXER_ADDMULTILINEANNOTATION:
			if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_INT);
				COERCE_RETURN(VT_I4);
				return AddMultilineAnnotation(
					args[2].bstrVal, args[1].bstrVal,
					static_cast<AmbientAnnotationRestriction>(args[0].intVal),
					(pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddMultilineAnnotation(
					args[1].bstrVal, args[0].bstrVal,
					AAR_NONE, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_LEXER_ADDSINGLELINEANNOTATION:
			if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_INT);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[2].bstrVal, args[1].bstrVal,
					static_cast<AmbientAnnotationRestriction>(args[0].intVal),
					(pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[1].bstrVal, args[0].bstrVal,
					AAR_NONE, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[0].bstrVal, 0,
					AAR_NONE, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_LEXER_REMOVEALL:				CALL_METHOD_0(RemoveAll);
		case DISPID_LEXER_REMOVEIDENTIFIEDTOKEN:	CALL_METHOD_1(RemoveIdentifiedToken, VT_I4);
		case DISPID_LEXER_SETADDITIONALALPHABETS:	CALL_METHOD_1(SetAdditionalAlphabets, VT_BSTR);
		case DISPID_LEXER_SETBRACKETS:				CALL_METHOD_1(SetBrackets, VT_BSTR);
		case DISPID_LEXER_SETOPERATORS:				CALL_METHOD_1(SetOperators, VT_BSTR);
		}
		return DISP_E_MEMBERNOTFOUND;
	}

	return hr;
}

///	@see	ILexer::put_CaseSensitive
STDMETHODIMP CAutomationLexer::put_CaseSensitive(VARIANT_BOOL bCaseSensitive) {
	m_impl.IgnoreCase(!toBoolean(bCaseSensitive));
	return S_OK;
}

///	@see	ILexer::put_Freezed
STDMETHODIMP CAutomationLexer::put_Freezed(VARIANT_BOOL bFreeze) {
	if(toBoolean(bFreeze))
		m_impl.Freeze();
	else
		m_impl.Unfreeze();
	return S_OK;
}

///	@see	ILexer::put_NumberFormat
STDMETHODIMP CAutomationLexer::put_NumberFormat(AmbientNumberFormat numberFormat) {
	try {
		if(numberFormat != ANF_DEFAULT)
			return E_NOTIMPL;
		m_impl.SetNumberFormat(static_cast<NumberFormat>(numberFormat));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::put_TokenEnabled
STDMETHODIMP CAutomationLexer::put_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL bEnabled) {
	const Ascension::TokenType	type = GetTokenTypeByName(bstrTokenName);
	if(type == -1)
		return E_INVALIDARG;
	m_impl.EnableToken(type, toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::put_UnicodeAlphabetsEnabled
STDMETHODIMP CAutomationLexer::put_UnicodeAlphabetsEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableUnicodeAlphabets(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::put_UnicodeWhiteSpacesEnabled
STDMETHODIMP CAutomationLexer::put_UnicodeWhiteSpacesEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableUnicodeWhiteSpaces(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::RemoveAll
STDMETHODIMP CAutomationLexer::RemoveAll() {
	m_impl.RemoveAll();
	return S_OK;
}

///	@see	ILexer::RemoveIdentifiedToken
STDMETHODIMP CAutomationLexer::RemoveIdentifiedToken(long nIdentifier) {
	try {
		m_impl.RemoveIdentifiedToken(static_cast<TokenCookie>(nIdentifier));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::SetAdditionalAlphabets
STDMETHODIMP CAutomationLexer::SetAdditionalAlphabets(BSTR bstrAlphabets) {
	if(bstrAlphabets != 0)
		m_impl.SetAdditionalAlphabets(bstrAlphabets, ::SysStringLen(bstrAlphabets));
	else
		m_impl.SetAdditionalAlphabets(L"", 0);
	return S_OK;
}

///	@see	ILexer::SetBrackets
STDMETHODIMP CAutomationLexer::SetBrackets(BSTR bstrOpeners) {
	try {
		m_impl.SetBrackets((bstrOpeners != 0) ? bstrOpeners : L"");
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::SetOperators
STDMETHODIMP CAutomationLexer::SetOperators(BSTR bstrOperators) {
	set<string_t>	setOperators;

	if(bstrOperators != 0) {
		wchar_t*	pCurrent = bstrOperators;
		wchar_t*	pNext;

		while(true) {
			pNext = wcschr(pCurrent, L' ');
			if(pNext != 0) {
				setOperators.insert(string_t(pCurrent, pNext - pCurrent));
				pCurrent = pNext + 1;
			} else {
				setOperators.insert(string_t(pCurrent));
				break;
			}
		}
	}
	m_impl.SetOperators(setOperators);
	return S_OK;
}


// CEditorPreferences class implementation
/////////////////////////////////////////////////////////////////////////////

#define GET_DISPLAY_OPTION(lhs, id)							\
	VERIFY_POINTER(lhs);									\
	CEditView::TOptions	options;							\
	m_view.GetOptions(options);								\
	*lhs = toVariantBoolean(options.displayOptions[id]);	\
	return S_OK
#define PUT_DISPLAY_OPTION(id, rhs)						\
	CEditView::TOptions	options;						\
	m_view.GetOptions(options);							\
	if(options.displayOptions[id] != toBoolean(rhs)) {	\
		options.displayOptions[id] = toBoolean(rhs);	\
		m_view.SetOptions(options);						\
	}													\
	return S_OK

/**
 *	RXgN^
 *	@param view	r[
 */
CEditorPreferences::CEditorPreferences(CEditView& view) : SAFE_MARK, m_view(view) {
}

/// @see	IEditorPreferences::get_CharSpan
STDMETHODIMP CEditorPreferences::get_CharSpan(short* pnCharSpan) {
	VERIFY_POINTER(pnCharSpan);
	uint	nSpan;
	m_view.GetCharSpaces(0, &nSpan);
	*pnCharSpan = static_cast<short>(nSpan);
	return S_OK;
}

/// @see	IEditorPreferences::get_CloseBoldChars
STDMETHODIMP CEditorPreferences::get_CloseBoldChars(VARIANT_BOOL* pbCloseBoldChars) {
	GET_DISPLAY_OPTION(pbCloseBoldChars, CLOSE_BOLD_CHARACTERS);
}

/// @see	IEditorPreferences::get_EndOfFileLabel
STDMETHODIMP CEditorPreferences::get_EndOfFileLabel(BSTR* pbstrEndOfFileLabel) {
	VERIFY_POINTER(pbstrEndOfFileLabel);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	return toBoolean(*pbstrEndOfFileLabel = ::SysAllocString(options.strEndOfFile.c_str())) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IEditorPreferences::get_IdeographicSpaceAlternativeChar
STDMETHODIMP CEditorPreferences::get_IdeographicSpaceAlternativeChar(long* pcp) {
	VERIFY_POINTER(pcp);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pcp = options.chIdeographicSpaceAlternative;
	return S_OK;
}

/// @see	IEditorPreferences::get_LeftMargin
STDMETHODIMP CEditorPreferences::get_LeftMargin(short* pnLeftMargin) {
	VERIFY_POINTER(pnLeftMargin);
	uint	nLeft;
	m_view.GetMargins(&nLeft, 0);
	*pnLeftMargin = static_cast<short>(nLeft);
	return S_OK;
}

/// @see	IEditorPreferences::get_LineNumberBorderStyle
STDMETHODIMP CEditorPreferences::get_LineNumberBorderStyle(AmbientLineNumberBorderStyle* pStyle) {
	VERIFY_POINTER(pStyle);
	TLineNumberLayout	layout;
	m_view.GetLineNumberLayout(layout);
	*pStyle = static_cast<AmbientLineNumberBorderStyle>(layout.borderStyle);
	return S_OK;
}

/// @see	IEditorPreferences::get_LineNumberBorderWidth
STDMETHODIMP CEditorPreferences::get_LineNumberBorderWidth(short* pnWidth) {
	VERIFY_POINTER(pnWidth);
	TLineNumberLayout	layout;
	m_view.GetLineNumberLayout(layout);
	*pnWidth = layout.nBorderWidth;
	return S_OK;
}

/// @see	IEditorPreferences::get_LineSpan
STDMETHODIMP CEditorPreferences::get_LineSpan(short* pnLineSpan) {
	VERIFY_POINTER(pnLineSpan);
	uint	nSpan;
	m_view.GetCharSpaces(&nSpan, 0);
	*pnLineSpan = static_cast<short>(nSpan);
	return S_OK;
}

/// @see	IEditorPreferences::get_MatchBracketScanLines
STDMETHODIMP CEditorPreferences::get_MatchBracketScanLines(long* pcLines) {
	VERIFY_POINTER(pcLines);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pcLines = options.cRecognizingLines;
	return S_OK;
}

/// @see	IEditorPreferences::get_PerformBidirection
STDMETHODIMP CEditorPreferences::get_PerformBidirection(VARIANT_BOOL* pbPerform) {
	VERIFY_POINTER(pbPerform);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pbPerform = !toVariantBoolean(options.displayOptions[DONT_CONSIDER_BIDIRECTION]);
	return S_OK;
}

///	@see	IEditorPreferences::get_ResetDirectionByTokens
STDMETHODIMP CEditorPreferences::get_ResetDirectionByTokens(VARIANT_BOOL* pbResetDirByTokens) {
	GET_DISPLAY_OPTION(pbResetDirByTokens, RESET_DIRECTION_BY_TOKEN);
}

/// @see	IEditorPreferences::get_RightToLeftReading
STDMETHODIMP CEditorPreferences::get_RightToLeftReading(VARIANT_BOOL* pbRightToLeft) {
	GET_DISPLAY_OPTION(pbRightToLeft, RIGHT_TO_LEFT_READING);
}

///	@see	IEditorPreferences::get_SelectEndOfLine
STDMETHODIMP CEditorPreferences::get_SelectEndOfLine(VARIANT_BOOL* pbSelectEndOfLine) {
	GET_DISPLAY_OPTION(pbSelectEndOfLine, SHOW_SELECTION_ON_BREAK);
}

///	@see	IEditorPreferences::get_ShowCurrentUnderline
STDMETHODIMP CEditorPreferences::get_ShowCurrentUnderline(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_CURRENT_UNDERLINE);
}

///	@see	IEditorPreferences::get_ShowEndOfFile
STDMETHODIMP CEditorPreferences::get_ShowEndOfFile(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_END_OF_FILE);
}

///	@see	IEditorPreferences::get_ShowEndOfLine
STDMETHODIMP CEditorPreferences::get_ShowEndOfLine(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_BREAK_ARROWS);
}

///	@see	IEditorPreferences::get_ShowHandOnLink
STDMETHODIMP CEditorPreferences::get_ShowHandOnLink(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_HAND_ON_LINK);
}

///	@see	IEditorPreferences::get_ShowHintOnLink
STDMETHODIMP CEditorPreferences::get_ShowHintOnLink(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_HINT_ON_LINK);
}

///	@see	IEditorPreferences::get_ShowIndicatorMargin
STDMETHODIMP CEditorPreferences::get_ShowIndicatorMargin(VARIANT_BOOL* pbShow) {
	VERIFY_POINTER(pbShow);
	TLineNumberLayout	layout;
	m_view.GetLineNumberLayout(layout);
	*pbShow = toVariantBoolean(layout.bShowIndicatorMargin);
	return S_OK;
}

///	@see	IEditorPreferences::get_ShowLineNumber
STDMETHODIMP CEditorPreferences::get_ShowLineNumber(VARIANT_BOOL* pbShow) {
	VERIFY_POINTER(pbShow);
	TLineNumberLayout	layout;
	m_view.GetLineNumberLayout(layout);
	*pbShow = toVariantBoolean(layout.bShowLineNumbers);
	return S_OK;
}

///	@see	IEditorPreferences::get_ShowUnicodeDirectionFormatter
STDMETHODIMP CEditorPreferences::get_ShowUnicodeDirectionFormatter(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_UNICODE_CONTROLS);
}

///	@see	IEditorPreferences::get_ShowWhiteSpaceAlternative
STDMETHODIMP CEditorPreferences::get_ShowWhiteSpaceAlternative(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_WHITESPACE_ALTERNATIVE);
}

///	@see	IEditorPreferences::get_StartCharNumber
STDMETHODIMP CEditorPreferences::get_StartCharNumber(long* pnStartCharNumber) {
	VERIFY_POINTER(pnStartCharNumber);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pnStartCharNumber = options.iStartChar;
	return S_OK;
}

///	@see	IEditorPreferences::get_StartLineNumber
STDMETHODIMP CEditorPreferences::get_StartLineNumber(long* pnStartLineNumber) {
	VERIFY_POINTER(pnStartLineNumber);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pnStartLineNumber = options.iStartLine;
	return S_OK;
}

///	@see	IEditorPreferences::get_TabAlternativeChar
STDMETHODIMP CEditorPreferences::get_TabAlternativeChar(long* pcp) {
	VERIFY_POINTER(pcp);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pcp = options.chTabAlternative;
	return S_OK;
}

///	@see	IEditorPreferences::get_TabWidth
STDMETHODIMP CEditorPreferences::get_TabWidth(short* pnWidth) {
	VERIFY_POINTER(pnWidth);
	*pnWidth = m_view.GetTabWidth();
	return S_OK;
}

///	@see	IEditorPreferences::get_ThinCaret
STDMETHODIMP CEditorPreferences::get_ThinCaret(VARIANT_BOOL* pbThinCaret) {
	GET_DISPLAY_OPTION(pbThinCaret, THIN_CARET);
}

///	@see	IEditorPreferences::get_TokenDecoration
STDMETHODIMP CEditorPreferences::get_TokenDecoration(BSTR bstrTokenTypeName, ITokenDecoration** ppTokenDecoration) {
	VERIFY_POINTER(ppTokenDecoration);
	if(bstrTokenTypeName == 0)
		return E_INVALIDARG;
	if(wcscmp(bstrTokenTypeName, L"whiteSpace") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_WHITESPACE);
	else if(wcscmp(bstrTokenTypeName, L"tab") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_TAB);
	else if(wcscmp(bstrTokenTypeName, L"operator") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_OPERATOR);
	else if(wcscmp(bstrTokenTypeName, L"identifier") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_IDENTIFIER);
	else if(wcscmp(bstrTokenTypeName, L"numeral") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_NUMERAL);
	else if(wcscmp(bstrTokenTypeName, L"number") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_NUMBER);
	else if(wcscmp(bstrTokenTypeName, L"singleQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_SINGLEQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"doubleQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_DOUBLEQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"otherQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_OTHERQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"asciiControl") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_ASCII_CONTROL);
	else if(wcscmp(bstrTokenTypeName, L"unicodeControl") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_UNICODE_CONTROL);
	else if(wcscmp(bstrTokenTypeName, L"unspecified") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_UNSPECIFIED);
	else if(wcscmp(bstrTokenTypeName, L"normal") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_NORMAL);
	else if(wcscmp(bstrTokenTypeName, L"selection") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_SELECTION);
	else if(wcscmp(bstrTokenTypeName, L"inactiveSelection") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_INACTIVE_SELECTION);
	else if(wcscmp(bstrTokenTypeName, L"indicatorMargin") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_INDICATOR_MARGIN);
	else if(wcscmp(bstrTokenTypeName, L"lineNumber") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_LINENUMBER);
	else if(wcscmp(bstrTokenTypeName, L"emphaticLineNumber") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_EMPHATIC_LINENUMBER);
	else if(wcscmp(bstrTokenTypeName, L"matchBrackets") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_MATCH_BRACKETS);
	else if(wcscmp(bstrTokenTypeName, L"endOfLine") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_END_OF_LINE);
	else if(wcscmp(bstrTokenTypeName, L"endOfFile") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_END_OF_FILE);
	else if(wcscmp(bstrTokenTypeName, L"link") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_LINK);
	else if(wcscmp(bstrTokenTypeName, L"matchText") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_MATCHTEXT);
	else {	// L[[hƃRgɂ̓NbL[lKv
		if(::SysStringLen(bstrTokenTypeName) >= 9 && wcsncmp(bstrTokenTypeName, L"keyword_", 8) == 0)
			*ppTokenDecoration = new CTokenDecoration(m_view,
				TT_KEYWORD, static_cast<TokenCookie>(wcstol(bstrTokenTypeName + 8, 0, 10)));
		else if(::SysStringLen(bstrTokenTypeName) >= 12 && wcsncmp(bstrTokenTypeName, L"annotation_", 11) == 0)
			*ppTokenDecoration = new CTokenDecoration(m_view,
				TT_ANNOTATION, static_cast<TokenCookie>(wcstol(bstrTokenTypeName + 11, 0, 10)));
		else {
			*ppTokenDecoration = 0;
			return E_INVALIDARG;
		}

	}
	(*ppTokenDecoration)->AddRef();

	return S_OK;
}

/// @see	IEditorPreferences::get_TopMargin
STDMETHODIMP CEditorPreferences::get_TopMargin(short* pnTopMargin) {
	VERIFY_POINTER(pnTopMargin);
	uint	nTop;
	m_view.GetMargins(0, &nTop);
	*pnTopMargin = static_cast<short>(nTop);
	return S_OK;
}

///	@see	IEditorPreferences::get_WhiteSpaceAlternativeChar
STDMETHODIMP CEditorPreferences::get_WhiteSpaceAlternativeChar(long* pcp) {
	VERIFY_POINTER(pcp);
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	*pcp = options.chWhitespaceAlternative;
	return S_OK;
}

///	@see	IEditorPreferences::get_WrapMode
STDMETHODIMP CEditorPreferences::get_WrapMode(AmbientWrapMode* pWrapMode) {
	VERIFY_POINTER(pWrapMode);
	*pWrapMode = static_cast<AmbientWrapMode>(m_view.GetWrapMode());
	return S_OK;
}

///	@see	IEditorPreferences::get_WrapWidth
STDMETHODIMP CEditorPreferences::get_WrapWidth(short* pnWrapWidth) {
	VERIFY_POINTER(pnWrapWidth);
	return E_NOTIMPL;
//	*pnWrapWidth = m_view.GetWrapWidth();
//	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CEditorPreferences::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {
		switch(dispidMember) {
		case DISPID_EDITORPREFERENCES_CHARSPAN:							CALL_GETTER(CharSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_CLOSEBOLDCHARS:					CALL_GETTER(CloseBoldChars, VT_BOOL);
		case DISPID_EDITORPREFERENCES_ENDOFFILELABEL:					CALL_GETTER(EndOfFileLabel, VT_BSTR);
		case DISPID_EDITORPREFERENCES_IDEOGRAPHICSPACEALTERNATIVECHAR:	CALL_GETTER(IdeographicSpaceAlternativeChar, VT_I4);
		case DISPID_EDITORPREFERENCES_LEFTMARGIN:						CALL_GETTER(LeftMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERSTYLE:			CALL_GETTER_ENUM(LineNumberBorderStyle, AmbientLineNumberBorderStyle);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERWIDTH:			CALL_GETTER(LineNumberBorderWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_LINESPAN:							CALL_GETTER(LineSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_MATCHBRACKETSCANLINES:			CALL_GETTER(MatchBracketScanLines, VT_I4);
		case DISPID_EDITORPREFERENCES_PERFORMBIDIRECTION:				CALL_GETTER(PerformBidirection, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RESETDIRECTIONBYTOKENS:			CALL_GETTER(ResetDirectionByTokens, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RIGHTTOLEFTREADING:				CALL_GETTER(RightToLeftReading, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SELECTENDOFLINE:					CALL_GETTER(SelectEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWCURRENTUNDERLINE:				CALL_GETTER(ShowCurrentUnderline, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFFILE:					CALL_GETTER(ShowEndOfFile, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFLINE:					CALL_GETTER(ShowEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHANDONLINK:					CALL_GETTER(ShowHandOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHINTONLINK:					CALL_GETTER(ShowHintOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWINDICATORMARGIN:				CALL_GETTER(ShowIndicatorMargin, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWLINENUMBER:					CALL_GETTER(ShowLineNumber, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWUNICODEDIRECTIONFORMATTER:	CALL_GETTER(ShowUnicodeDirectionFormatter, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWWHITESPACEALTERNATIVE:		CALL_GETTER(ShowWhiteSpaceAlternative, VT_BOOL);
		case DISPID_EDITORPREFERENCES_STARTCHARNUMBER:					CALL_GETTER(StartCharNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_STARTLINENUMBER:					CALL_GETTER(StartLineNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_TABALTERNATIVECHAR:				CALL_GETTER(TabAlternativeChar, VT_I4);
		case DISPID_EDITORPREFERENCES_TABWIDTH:							CALL_GETTER(TabWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_THINCARET:						CALL_GETTER(ThinCaret, VT_BOOL);
		case DISPID_EDITORPREFERENCES_TOKENDECORATION:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_DISPATCH;
			return get_TokenDecoration(args[0].bstrVal, reinterpret_cast<ITokenDecoration**>(&pVarResult->pdispVal));
		case DISPID_EDITORPREFERENCES_TOPMARGIN:						CALL_GETTER(TopMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_WHITESPACEALTERNATIVECHAR:		CALL_GETTER(WhiteSpaceAlternativeChar, VT_I4);
		case DISPID_EDITORPREFERENCES_WRAPMODE:							CALL_GETTER_ENUM(WrapMode, AmbientWrapMode);
		case DISPID_EDITORPREFERENCES_WRAPWIDTH:						CALL_GETTER(WrapWidth, VT_I2);
		}
	} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT)) {
		switch(dispidMember) {
		case DISPID_EDITORPREFERENCES_CHARSPAN:							CALL_PUTTER(CharSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_CLOSEBOLDCHARS:					CALL_PUTTER(CloseBoldChars, VT_BOOL);
		case DISPID_EDITORPREFERENCES_ENDOFFILELABEL:					CALL_PUTTER(EndOfFileLabel, VT_BSTR);
		case DISPID_EDITORPREFERENCES_IDEOGRAPHICSPACEALTERNATIVECHAR:	CALL_PUTTER(IdeographicSpaceAlternativeChar, VT_I4);
		case DISPID_EDITORPREFERENCES_LEFTMARGIN:						CALL_PUTTER(LeftMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERSTYLE:			CALL_PUTTER_ENUM(LineNumberBorderStyle, AmbientLineNumberBorderStyle);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERWIDTH:			CALL_PUTTER(LineNumberBorderWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_LINESPAN:							CALL_PUTTER(LineSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_MATCHBRACKETSCANLINES:			CALL_PUTTER(MatchBracketScanLines, VT_I4);
		case DISPID_EDITORPREFERENCES_PERFORMBIDIRECTION:				CALL_PUTTER(PerformBidirection, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RESETDIRECTIONBYTOKENS:			CALL_PUTTER(ResetDirectionByTokens, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RIGHTTOLEFTREADING:				CALL_PUTTER(RightToLeftReading, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SELECTENDOFLINE:					CALL_PUTTER(SelectEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWCURRENTUNDERLINE:				CALL_PUTTER(ShowCurrentUnderline, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFFILE:					CALL_PUTTER(ShowEndOfFile, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFLINE:					CALL_PUTTER(ShowEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHANDONLINK:					CALL_PUTTER(ShowHandOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHINTONLINK:					CALL_PUTTER(ShowHintOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWINDICATORMARGIN:				CALL_PUTTER(ShowIndicatorMargin, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWLINENUMBER:					CALL_PUTTER(ShowLineNumber, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWUNICODEDIRECTIONFORMATTER:	CALL_PUTTER(ShowUnicodeDirectionFormatter, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWWHITESPACEALTERNATIVE:		CALL_PUTTER(ShowWhiteSpaceAlternative, VT_BOOL);
		case DISPID_EDITORPREFERENCES_STARTCHARNUMBER:					CALL_PUTTER(StartCharNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_STARTLINENUMBER:					CALL_PUTTER(StartLineNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_TABALTERNATIVECHAR:				CALL_PUTTER(TabAlternativeChar, VT_I4);
		case DISPID_EDITORPREFERENCES_TABWIDTH:							CALL_PUTTER(TabWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_THINCARET:						CALL_PUTTER(ThinCaret, VT_BOOL);
		case DISPID_EDITORPREFERENCES_TOPMARGIN:						CALL_PUTTER(TopMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_WHITESPACEALTERNATIVECHAR:		CALL_PUTTER(WhiteSpaceAlternativeChar, VT_I4);
		case DISPID_EDITORPREFERENCES_WRAPMODE:							CALL_PUTTER_ENUM(WrapMode, AmbientWrapMode);
		case DISPID_EDITORPREFERENCES_WRAPWIDTH:						CALL_PUTTER(WrapWidth, VT_I2);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {
		if(dispidMember == DISPID_EDITORPREFERENCES_RESET)
			CALL_METHOD_0(Reset);
	}

	return hr;
}

///	@see	IEditorPreferences::put_CharSpan
STDMETHODIMP CEditorPreferences::put_CharSpan(short nCharSpan) {
	if(nCharSpan < 0)
		return E_INVALIDARG;

	uint	nLineSpanOrg, nCharSpanOrg;
	m_view.GetCharSpaces(&nLineSpanOrg, &nCharSpanOrg);
	if(nCharSpanOrg != nCharSpan)
		m_view.SetCharSpaces(nLineSpanOrg, nCharSpan);
	return S_OK;
}

///	@see	IEditorPreferences::put_CloseBoldChars
STDMETHODIMP CEditorPreferences::put_CloseBoldChars(VARIANT_BOOL bCloseBoldChars) {
	PUT_DISPLAY_OPTION(CLOSE_BOLD_CHARACTERS, bCloseBoldChars);
}

///	@see	IEditorPreferences::put_EndOfFileLabel
STDMETHODIMP CEditorPreferences::put_EndOfFileLabel(BSTR bstrEndOfFileLabel) {
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	options.strEndOfFile = (bstrEndOfFileLabel != 0) ? bstrEndOfFileLabel : L"";
	m_view.SetOptions(options);
	return S_OK;
}

///	@see	IEditorPreferences::put_IdeographicSpaceAlternativeChar
STDMETHODIMP CEditorPreferences::put_IdeographicSpaceAlternativeChar(long cp) {
	if(cp < 0 || cp > 0x10000)
		return E_INVALIDARG;

	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.chIdeographicSpaceAlternative != static_cast<char_t>(cp)) {
		options.chIdeographicSpaceAlternative = static_cast<char_t>(cp);
		m_view.SetOptions(options);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_LeftMargin
STDMETHODIMP CEditorPreferences::put_LeftMargin(short nLeftMargin) {
	if(nLeftMargin < 0)
		return E_INVALIDARG;

	uint	nLeftMarginOrg, nTopMarginOrg;
	m_view.GetMargins(&nLeftMarginOrg, &nTopMarginOrg);
	if(nLeftMargin != nLeftMarginOrg)
		m_view.SetMargins(nLeftMargin, nTopMarginOrg);
	return S_OK;
}

///	@see	IEditorPreferences::put_LineNumberBorderStyle
STDMETHODIMP CEditorPreferences::put_LineNumberBorderStyle(AmbientLineNumberBorderStyle style) {
	TLineNumberLayout	layout;

	m_view.GetLineNumberLayout(layout);
	if(layout.borderStyle != static_cast<TLineNumberLayout::BorderStyle>(style)) {
		layout.borderStyle = static_cast<TLineNumberLayout::BorderStyle>(style);
		m_view.SetLineNumberLayout(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_LineNumberBorderWidth
STDMETHODIMP CEditorPreferences::put_LineNumberBorderWidth(short nWidth) {
	TLineNumberLayout	layout;

	m_view.GetLineNumberLayout(layout);
	if(layout.nBorderWidth != nWidth) {
		layout.nBorderWidth = nWidth;
		m_view.SetLineNumberLayout(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_LineSpan
STDMETHODIMP CEditorPreferences::put_LineSpan(short nLineSpan) {
	if(nLineSpan < 0)
		return E_INVALIDARG;

	uint	nLineSpanOrg, nCharSpanOrg;
	m_view.GetCharSpaces(&nLineSpanOrg, &nCharSpanOrg);
	if(nLineSpan != nLineSpanOrg)
		m_view.SetCharSpaces(nLineSpan, nCharSpanOrg);
	return S_OK;
}

///	@see	IEditorPreferences::put_MatchBracketScanLines
STDMETHODIMP CEditorPreferences::put_MatchBracketScanLines(long cLines) {
	if(cLines < 0)
		return E_INVALIDARG;

	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.cRecognizingLines != cLines) {
		options.cRecognizingLines = cLines;
		m_view.SetOptions(options);
	}
	return S_OK;
}

/// @see	IEditorPreferences::put_PerformBidirection
STDMETHODIMP CEditorPreferences::put_PerformBidirection(VARIANT_BOOL bPerform) {
	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.displayOptions[DONT_CONSIDER_BIDIRECTION] == toBoolean(bPerform)) {
		options.displayOptions[DONT_CONSIDER_BIDIRECTION] = !toBoolean(bPerform);
		m_view.SetOptions(options);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_ResetDirectionByTokens
STDMETHODIMP CEditorPreferences::put_ResetDirectionByTokens(VARIANT_BOOL bResetDirByTokens) {
	return E_NOTIMPL;
//	PUT_DISPLAY_OPTION(RESET_DIRECTION_BY_TOKEN, bResetDirByTokens);
}

///	@see	IEditorPreferences::put_RightToLeftReading
STDMETHODIMP CEditorPreferences::put_RightToLeftReading(VARIANT_BOOL bRightToLeft) {
	return E_NOTIMPL;
//	PUT_DISPLAY_OPTION(RIGHT_TO_LEFT_READING, bResetDirByTokens);
}

///	@see	IEditorPreferences::put_SelectEndOfLine
STDMETHODIMP CEditorPreferences::put_SelectEndOfLine(VARIANT_BOOL bSelectEndOfLine) {
	PUT_DISPLAY_OPTION(SHOW_SELECTION_ON_BREAK, bSelectEndOfLine);
}

///	@see	IEditorPreferences::put_ShowCurrentUnderline
STDMETHODIMP CEditorPreferences::put_ShowCurrentUnderline(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_CURRENT_UNDERLINE, bShow);
}

///	@see	IEditorPreferences::put_ShowEndOfFile
STDMETHODIMP CEditorPreferences::put_ShowEndOfFile(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_END_OF_FILE, bShow);
}

///	@see	IEditorPreferences::put_ShowEndOfLine
STDMETHODIMP CEditorPreferences::put_ShowEndOfLine(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_BREAK_ARROWS, bShow);
}

///	@see	IEditorPreferences::put_ShowHandOnLink
STDMETHODIMP CEditorPreferences::put_ShowHandOnLink(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_HAND_ON_LINK, bShow);
}

///	@see	IEditorPreferences::put_ShowHintOnLink
STDMETHODIMP CEditorPreferences::put_ShowHintOnLink(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_HINT_ON_LINK, bShow);
}

///	@see	IEditorPreferences::put_ShowIndicatorMargin
STDMETHODIMP CEditorPreferences::put_ShowIndicatorMargin(VARIANT_BOOL bShow) {
	TLineNumberLayout	layout;
	m_view.GetLineNumberLayout(layout);
	if(layout.bShowIndicatorMargin != toBoolean(bShow)) {
		layout.bShowIndicatorMargin = toBoolean(bShow);
		m_view.SetLineNumberLayout(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowLineNumber
STDMETHODIMP CEditorPreferences::put_ShowLineNumber(VARIANT_BOOL bShow) {
	TLineNumberLayout	layout;
	m_view.GetLineNumberLayout(layout);
	if(layout.bShowLineNumbers != toBoolean(bShow)) {
		layout.bShowLineNumbers = toBoolean(bShow);
		m_view.SetLineNumberLayout(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowUnicodeDirectionFormatter
STDMETHODIMP CEditorPreferences::put_ShowUnicodeDirectionFormatter(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_UNICODE_CONTROLS, bShow);
}

///	@see	IEditorPreferences::put_ShowWhiteSpaceAlternative
STDMETHODIMP CEditorPreferences::put_ShowWhiteSpaceAlternative(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_WHITESPACE_ALTERNATIVE, bShow);
}

///	@see	IEditorPreferences::put_StartCharNumber
STDMETHODIMP CEditorPreferences::put_StartCharNumber(long nStartCharNumber) {
	if(nStartCharNumber < 0)
		return E_INVALIDARG;

	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.iStartChar != nStartCharNumber) {
		options.iStartChar = nStartCharNumber;
		m_view.SetOptions(options);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_StartLineNumber
STDMETHODIMP CEditorPreferences::put_StartLineNumber(long nStartLineNumber) {
	if(nStartLineNumber < 0)
		return E_INVALIDARG;

	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.iStartLine != nStartLineNumber) {
		options.iStartLine = nStartLineNumber;
		m_view.SetOptions(options);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_TabAlternativeChar
STDMETHODIMP CEditorPreferences::put_TabAlternativeChar(long cp) {
	if(cp < 0 || cp > 0x10000)
		return E_INVALIDARG;

	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.chTabAlternative != static_cast<char_t>(cp)) {
		options.chTabAlternative = static_cast<char_t>(cp);
		m_view.SetOptions(options);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_TabWidth
STDMETHODIMP CEditorPreferences::put_TabWidth(short nTabWidth) {
	if(nTabWidth < 0)
		return E_INVALIDARG;
	m_view.SetTabWidth(nTabWidth);
	return S_OK;
}

///	@see	IEditorPreferences::put_ThinCaret
STDMETHODIMP CEditorPreferences::put_ThinCaret(VARIANT_BOOL bThinCaret) {
	PUT_DISPLAY_OPTION(THIN_CARET, bThinCaret);
}

///	@see	IEditorPreferences::put_TopMargin
STDMETHODIMP CEditorPreferences::put_TopMargin(short nTopMargin) {
	if(nTopMargin < 0)
		return E_INVALIDARG;

	uint	nLeftMarginOrg, nTopMarginOrg;
	m_view.GetMargins(&nLeftMarginOrg, &nTopMarginOrg);
	if(nTopMarginOrg != nTopMargin)
		m_view.SetMargins(nLeftMarginOrg, nTopMargin);
	return S_OK;
}

///	@see	IEditorPreferences::put_WhiteSpaceAlternativeChar
STDMETHODIMP CEditorPreferences::put_WhiteSpaceAlternativeChar(long cp) {
	if(cp < 0 || cp > 0x10000)
		return E_INVALIDARG;

	CEditView::TOptions	options;
	m_view.GetOptions(options);
	if(options.chWhitespaceAlternative!= static_cast<char_t>(cp)) {
		options.chWhitespaceAlternative = static_cast<char_t>(cp);
		m_view.SetOptions(options);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_WrapMode
STDMETHODIMP CEditorPreferences::put_WrapMode(AmbientWrapMode wrapMode) {
//	m_view.SetWrapMode(static_cast<WrapMode>(wrapMode));
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::put_WrapWidth
STDMETHODIMP CEditorPreferences::put_WrapWidth(short nWrapWidth) {
//	m_view.SetWrapWidth(nWrapWidth);
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::Reset
STDMETHODIMP CEditorPreferences::Reset() {
	CEditView::TOptions	options;
	TTextFoundation	tf;

	m_view.SetCharSpaces(0, 0);
	m_view.SetMargins(5, 1);
	m_view.SetTabWidth(4);
	m_view.SetLineNumberLayout(TLineNumberLayout());
	m_view.SetOptions(options);
	for(int type = TT_WHITESPACE; type < ETT_COUNT; ++type) {
		if(type != TT_KEYWORD && type != TT_ANNOTATION)
			m_view.SetTextFoundation(type, NullCookie, tf);
	}

	return S_OK;
}

#undef GET_DISPLAY_OPTION
#undef PUT_DISPLAY_OPTION


// CTokenDecoration class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {	// Win32 API ƃXNvgnŐF̕\
	inline long WinRGBToScriptRGB(COLORREF clr) {
		return (clr == -1) ? -1 : (GetBValue(clr) | (GetGValue(clr) << 8) | (GetRValue(clr) << 16));
	}
	inline COLORREF ScriptRGBToWinRGB(long clr) {
		return (clr == -1) ? -1 : RGB((clr & 0xFF0000) >> 16, (clr & 0x00FF00) >> 8, clr & 0x0000FF);
	}
}

// CEditView::GetTextFoundation ͗O𓊂̂łňꊇ
#define GET_TF()															\
	TTextFoundation	_tf;													\
	try {																	\
		_tf = m_view.GetTextFoundation(m_nTokenType, m_nTokenCookie, true);	\
	} catch(invalid_argument&) {											\
		return E_UNEXPECTED;												\
	}

/**
 *	RXgN^
 *	@param view			r[
 *	@param nTokenType	g[N̎
 *	@param nTokenCookie	g[ÑNbL[l
 */
CTokenDecoration::CTokenDecoration(CEditView& view, int nTokenType, TokenCookie nTokenCookie)
		: SAFE_MARK, m_view(view), m_nTokenType(nTokenType), m_nTokenCookie(nTokenCookie) {
}

///	@see	ITokenDecoration::get_BackgroundColor
STDMETHODIMP CTokenDecoration::get_BackgroundColor(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = WinRGBToScriptRGB(_tf.bgColor);
	return S_OK;
}

///	@see	ITokenDecoration::get_BoldFont
STDMETHODIMP CTokenDecoration::get_BoldFont(VARIANT_BOOL* pbBold) {
	VERIFY_POINTER(pbBold);
	GET_TF();
	*pbBold = toVariantBoolean(_tf.bold);
	return S_OK;
}

///	@see	ITokenDecoration::get_BorderColor
STDMETHODIMP CTokenDecoration::get_BorderColor(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = _tf.borderColor;
	return S_OK;
}

///	@see	ITokenDecoration::get_BorderStyle
STDMETHODIMP CTokenDecoration::get_BorderStyle(AmbientBorderType* pBorderType) {
	VERIFY_POINTER(pBorderType);
	GET_TF();
	*pBorderType = static_cast<AmbientBorderType>(_tf.border);
	return S_OK;
}

///	@see	ITokenDecoration::get_Color
STDMETHODIMP CTokenDecoration::get_Color(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = WinRGBToScriptRGB(_tf.fgColor);
	return S_OK;
}

///	@see	ITokenDecoration::get_ItalicFont
STDMETHODIMP CTokenDecoration::get_ItalicFont(VARIANT_BOOL* pbItalic) {
	VERIFY_POINTER(pbItalic);
	GET_TF();
	*pbItalic = toVariantBoolean(_tf.italic);
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTokenDecoration::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TOKENDECORATION_BACKGROUNDCOLOR:	CALL_GETTER(BackgroundColor, VT_I4);
		case DISPID_TOKENDECORATION_BOLDFONT:			CALL_GETTER(BoldFont, VT_BOOL);
		case DISPID_TOKENDECORATION_COLOR:				CALL_GETTER(Color, VT_I4);
		case DISPID_TOKENDECORATION_ITALICFONT:			CALL_GETTER(ItalicFont, VT_BOOL);
		case DISPID_TOKENDECORATION_BORDERSTYLE:		CALL_GETTER_ENUM(BorderStyle, AmbientBorderType);
		case DISPID_TOKENDECORATION_BORDERCOLOR:		CALL_GETTER(BorderColor, VT_I4);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_TOKENDECORATION_BACKGROUNDCOLOR:	CALL_PUTTER(BackgroundColor, VT_I4);
		case DISPID_TOKENDECORATION_BOLDFONT:			CALL_PUTTER(BoldFont, VT_BOOL);
		case DISPID_TOKENDECORATION_COLOR:				CALL_PUTTER(Color, VT_I4);
		case DISPID_TOKENDECORATION_ITALICFONT:			CALL_PUTTER(ItalicFont, VT_BOOL);
		case DISPID_TOKENDECORATION_BORDERSTYLE:		CALL_PUTTER_ENUM(BorderStyle, AmbientBorderType);
		case DISPID_TOKENDECORATION_BORDERCOLOR:		CALL_PUTTER(BorderColor, VT_I4);
		}
	}
	return hr;
}

///	@see	ITokenDecoration::put_BackgroundColor
STDMETHODIMP CTokenDecoration::put_BackgroundColor(long nColor) {
	GET_TF();
	const COLORREF	clr = ScriptRGBToWinRGB(nColor);

	if(clr != _tf.bgColor) {
		_tf.bgColor = clr;
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BoldFont
STDMETHODIMP CTokenDecoration::put_BoldFont(VARIANT_BOOL bBold) {
	GET_TF();
	if(_tf.bold != toBoolean(bBold)) {
		_tf.bold = toBoolean(bBold);
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BorderColor
STDMETHODIMP CTokenDecoration::put_BorderColor(long nColor) {
	GET_TF();
	const COLORREF	clr = ScriptRGBToWinRGB(nColor);

	if(clr != _tf.borderColor) {
		_tf.borderColor = clr;
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BorderStyle
STDMETHODIMP CTokenDecoration::put_BorderStyle(AmbientBorderType borderType) {
	GET_TF();
	if(_tf.border != static_cast<BorderType>(borderType)) {
		_tf.border = static_cast<BorderType>(borderType);
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_Color
STDMETHODIMP CTokenDecoration::put_Color(long nColor) {
	GET_TF();
	const COLORREF	clr = ScriptRGBToWinRGB(nColor);

	if(clr != _tf.fgColor) {
		_tf.fgColor = clr;
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_ItalicFont
STDMETHODIMP CTokenDecoration::put_ItalicFont(VARIANT_BOOL bItalic) {
	GET_TF();
	if(_tf.italic != toBoolean(bItalic)) {
		_tf.italic = toBoolean(bItalic);
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

#undef GET_TF


// CAutomationTextSearcher class implementation
/////////////////////////////////////////////////////////////////////////////

#define BEGIN_REGEXP_ERROR_HANDLER()	try {
#define END_REGEXP_ERROR_HANDLER(methodName)										\
	} catch(ERegExpPatternIsInvalid&) {												\
		CComException	e(SCRIPT_E_BADREGEXP, IID_ITextSearcher,					\
							OLESTR("Ambient.TextSearcher.") OLESTR(methodName));	\
		e.ThrowLogicalThreadError();												\
		return e.GetSCode();														\
	} catch(EMiscellaneousRegExpError&) {											\
		CComException	e(SCRIPT_E_BADREGEXP, IID_ITextSearcher,					\
							OLESTR("Ambient.TextSearcher.") OLESTR(methodName));	\
		e.ThrowLogicalThreadError();												\
		return e.GetSCode();														\
	}

///	RXgN^
CAutomationTextSearcher::CAutomationTextSearcher(CAlphaEditController& editor) : SAFE_MARK, m_editor(editor) {
}

///	@see	ITextSearcher::BookmarkAll
STDMETHODIMP CAutomationTextSearcher::BookmarkAll(long* pcFound) {
	ulong	cFound;
	if(pcFound != 0)
		*pcFound = 0;
	BEGIN_REGEXP_ERROR_HANDLER()
		cFound = m_editor.GetActiveView()->ExecCommand(CMDID_SEARCH_BOOKMARKALL);
	END_REGEXP_ERROR_HANDLER("BookmarkAll")
	if(pcFound != 0)
		*pcFound = static_cast<long>(cFound);
	return S_OK;
}

///	@see	ITextSearcher::FindNext
STDMETHODIMP CAutomationTextSearcher::FindNext(VARIANT_BOOL* pbFound) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();
	bool			bFound;

	if(pbFound != 0)
		*pbFound = VARIANT_FALSE;
	options.bForward = true;
	m_editor.GetActiveView()->SetSearchOptions(options);
	BEGIN_REGEXP_ERROR_HANDLER()
		bFound = toBoolean(m_editor.GetActiveView()->ExecCommand(CMDID_SEARCH_FINDNEXT));
	END_REGEXP_ERROR_HANDLER("FindNext")
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

///	@see	ITextSearcher::FindPrev
STDMETHODIMP CAutomationTextSearcher::FindPrev(VARIANT_BOOL* pbFound) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();
	bool			bFound;

	if(pbFound != 0)
		*pbFound = VARIANT_FALSE;
	options.bForward = false;
	m_editor.GetActiveView()->SetSearchOptions(options);
	BEGIN_REGEXP_ERROR_HANDLER()
		bFound = toBoolean(m_editor.GetActiveView()->ExecCommand(CMDID_SEARCH_FINDNEXT));
	END_REGEXP_ERROR_HANDLER("FindPrev")
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

/// @see	ITextSearcher::get_FindWhat
STDMETHODIMP CAutomationTextSearcher::get_FindWhat(BSTR* pbstrFindWhat) {
	VERIFY_POINTER(pbstrFindWhat);
	*pbstrFindWhat = ::SysAllocString(m_editor.GetActiveView()->GetSearchText().c_str());
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreCase
STDMETHODIMP CAutomationTextSearcher::get_IgnoreCase(AmbientCaseFoldingType* pCaseFoldingType) {
	VERIFY_POINTER(pCaseFoldingType);
	*pCaseFoldingType = static_cast<AmbientCaseFoldingType>(m_editor.GetActiveView()->GetSearchOptions().caseSensitivity);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreControls
STDMETHODIMP CAutomationTextSearcher::get_IgnoreControls(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_CONTROLS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreDiacritics
STDMETHODIMP CAutomationTextSearcher::get_IgnoreDiacritics(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_DIACRITICS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreDigitScript
STDMETHODIMP CAutomationTextSearcher::get_IgnoreDigitScript(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().foldingOptions & FO_NATIVE_DIGIT);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreKashida
STDMETHODIMP CAutomationTextSearcher::get_IgnoreKashida(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_KASHIDA);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnorePunctuations
STDMETHODIMP CAutomationTextSearcher::get_IgnorePunctuations(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_PUNCTUATIONS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreSymbols
STDMETHODIMP CAutomationTextSearcher::get_IgnoreSymbols(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_SYMBOLS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreVowels
STDMETHODIMP CAutomationTextSearcher::get_IgnoreVowels(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_VOWELS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreWhitespaces
STDMETHODIMP CAutomationTextSearcher::get_IgnoreWhitespaces(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().characterSkipOptions & CSO_WHITESPACES);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreWidth
STDMETHODIMP CAutomationTextSearcher::get_IgnoreWidth(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().provisionalFoldingOptions & PFO_WIDTH);
	return S_OK;
}

///	@see	ITextSearcher::get_OnlyIdentifier
STDMETHODIMP CAutomationTextSearcher::get_OnlyIdentifiers(VARIANT_BOOL* pbOnlyIdentifiers) {
	VERIFY_POINTER(pbOnlyIdentifiers);
//	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions() & SF_ONLYIDENTIFIERS);
//	return S_OK;
	return E_NOTIMPL;
}

/// @see	ITextSearcher::get_ReplaceWith
STDMETHODIMP CAutomationTextSearcher::get_ReplaceWith(BSTR* pbstrReplaceWith) {
	VERIFY_POINTER(pbstrReplaceWith);
	*pbstrReplaceWith = ::SysAllocString(m_editor.GetActiveView()->GetReplaceText().c_str());
	return S_OK;
}

///	@see	ITextSearcher::get_SearchType
STDMETHODIMP CAutomationTextSearcher::get_SearchType(AmbientSearchType* pType) {
	VERIFY_POINTER(pType);
	const TSearchOption&	options = m_editor.GetActiveView()->GetSearchOptions();
	switch(options.type) {
	case ST_LITERAL:	*pType = AST_LITERAL;	break;
	case ST_REGEXP:		*pType = AST_REGEXP;	break;
	case ST_WILDCARD:	*pType = AST_WILDCARD;	break;
	case ST_MIGEMO:		*pType = AST_MIGEMO;	break;
	}
	return S_OK;
}

///	@see	ITextSearcher::get_WholeWord
STDMETHODIMP CAutomationTextSearcher::get_WholeWord(VARIANT_BOOL* pbWholeWord) {
	VERIFY_POINTER(pbWholeWord);
	*pbWholeWord = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions().bWholeWord);
	return S_OK;
}

///	@see	ITextSearcher::Invoke
STDMETHODIMP CAutomationTextSearcher::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	bool			bCreatedResult = false;
	CComVariant		args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTSEARCHER_FINDWHAT:				CALL_GETTER(FindWhat, VT_BSTR);
		case DISPID_TEXTSEARCHER_IGNORECASE:			CALL_GETTER_ENUM(IgnoreCase, AmbientCaseFoldingType);
		case DISPID_TEXTSEARCHER_IGNORECONTROLS:		CALL_GETTER(IgnoreControls, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREDIACRITICS:		CALL_GETTER(IgnoreDiacritics, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREDIGITSCRIPT:		CALL_GETTER(IgnoreDigitScript, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREKASHIDA:			CALL_GETTER(IgnoreKashida, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREPUNCTUATIONS:	CALL_GETTER(IgnorePunctuations, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNORESYMBOLS:			CALL_GETTER(IgnoreSymbols, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREVOWELS:			CALL_GETTER(IgnoreVowels, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREWHITESPACES:		CALL_GETTER(IgnoreWhitespaces, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREWIDTH:			CALL_GETTER(IgnoreWidth, VT_BOOL);
		case DISPID_TEXTSEARCHER_ONLYIDENTIFIERS:		CALL_GETTER(OnlyIdentifiers, VT_BOOL);
		case DISPID_TEXTSEARCHER_REPLACEWITH:			CALL_GETTER(ReplaceWith, VT_BSTR);
		case DISPID_TEXTSEARCHER_SEARCHTYPE:			CALL_GETTER_ENUM(SearchType, AmbientSearchType);
		case DISPID_TEXTSEARCHER_WHOLEWORD:				CALL_GETTER(WholeWord, VT_BOOL);
		}
	} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT)) {	// vb^
		switch(dispidMember) {
		case DISPID_TEXTSEARCHER_FINDWHAT:				CALL_PUTTER(FindWhat, VT_BSTR);
		case DISPID_TEXTSEARCHER_IGNORECASE:			CALL_PUTTER_ENUM(IgnoreCase, AmbientCaseFoldingType);
		case DISPID_TEXTSEARCHER_IGNORECONTROLS:		CALL_PUTTER(IgnoreControls, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREDIACRITICS:		CALL_PUTTER(IgnoreDiacritics, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREDIGITSCRIPT:		CALL_PUTTER(IgnoreDigitScript, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREKASHIDA:			CALL_PUTTER(IgnoreKashida, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREPUNCTUATIONS:	CALL_PUTTER(IgnorePunctuations, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNORESYMBOLS:			CALL_PUTTER(IgnoreSymbols, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREVOWELS:			CALL_PUTTER(IgnoreVowels, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREWHITESPACES:		CALL_PUTTER(IgnoreWhitespaces, VT_BOOL);
		case DISPID_TEXTSEARCHER_IGNOREWIDTH:			CALL_PUTTER(IgnoreWidth, VT_BOOL);
		case DISPID_TEXTSEARCHER_ONLYIDENTIFIERS:		CALL_PUTTER(OnlyIdentifiers, VT_BOOL);
		case DISPID_TEXTSEARCHER_REPLACEWITH:			CALL_PUTTER(ReplaceWith, VT_BSTR);
		case DISPID_TEXTSEARCHER_SEARCHTYPE:			CALL_PUTTER_ENUM(SearchType, AmbientSearchType);
		case DISPID_TEXTSEARCHER_WHOLEWORD:				CALL_PUTTER(WholeWord, VT_BOOL);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTSEARCHER_BOOKMARKALL:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_I4);
			hr = BookmarkAll((pVarResult != 0) ? &pVarResult->lVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_TEXTSEARCHER_FINDNEXT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_BOOL);
			hr = FindNext((pVarResult != 0) ? &pVarResult->boolVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_TEXTSEARCHER_FINDPREV:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_BOOL);
			hr = FindPrev((pVarResult != 0) ? &pVarResult->boolVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_TEXTSEARCHER_REPLACEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_I4);
			hr = ReplaceAll((pVarResult != 0) ? &pVarResult->lVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_TEXTSEARCHER_REPLACEANDNEXT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_BOOL);
			hr = ReplaceAndNext((pVarResult != 0) ? &pVarResult->boolVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_TEXTSEARCHER_REPLACEANDPREV:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_BOOL);
			hr = ReplaceAndPrev((pVarResult != 0) ? &pVarResult->boolVal : 0);
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		}
	}
	return hr;

#undef IMPLEMENT_BOOLEAN_GETTER
#undef IMPLEMENT_BOOLEAN_PUTTER
}

///	@see	ITextSearcher::put_FindWhat
STDMETHODIMP CAutomationTextSearcher::put_FindWhat(BSTR bstrFindWhat) {
	if(bstrFindWhat == 0)
		return E_INVALIDARG;
	m_editor.GetActiveView()->SetSearchText(bstrFindWhat);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreCase
STDMETHODIMP CAutomationTextSearcher::put_IgnoreCase(AmbientCaseFoldingType caseFoldingType) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	switch(caseFoldingType) {
	case ACFT_MATCH_CASE:				options.caseSensitivity = CS_NONE;		break;
	case ACFT_IGNORE_ASCII_ALPHABETS:	options.caseSensitivity = CS_ASCII;		break;
	case ACFT_UNICODE_SIMPLE:			options.caseSensitivity = CS_SIMPLE;	break;
	case ACFT_UNICODE_FULL:				options.caseSensitivity = CS_FULL;		break;
	default:							return E_INVALIDARG;
	}
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreControls
STDMETHODIMP CAutomationTextSearcher::put_IgnoreControls(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_CONTROLS;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_CONTROLS;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreDiacritics
STDMETHODIMP CAutomationTextSearcher::put_IgnoreDiacritics(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_DIACRITICS;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_DIACRITICS;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreDigitScript
STDMETHODIMP CAutomationTextSearcher::put_IgnoreDigitScript(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.foldingOptions &= ~FO_NATIVE_DIGIT;
	if(toBoolean(bIgnore))
		options.foldingOptions |= FO_NATIVE_DIGIT;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreKashida
STDMETHODIMP CAutomationTextSearcher::put_IgnoreKashida(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_KASHIDA;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_KASHIDA;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnorePunctuations
STDMETHODIMP CAutomationTextSearcher::put_IgnorePunctuations(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_PUNCTUATIONS;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_PUNCTUATIONS;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreSymbols
STDMETHODIMP CAutomationTextSearcher::put_IgnoreSymbols(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_SYMBOLS;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_SYMBOLS;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreVowels
STDMETHODIMP CAutomationTextSearcher::put_IgnoreVowels(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_VOWELS;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_VOWELS;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreWhitespaces
STDMETHODIMP CAutomationTextSearcher::put_IgnoreWhitespaces(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.characterSkipOptions &= ~CSO_WHITESPACES;
	if(toBoolean(bIgnore))
		options.characterSkipOptions |= CSO_WHITESPACES;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreWidth
STDMETHODIMP CAutomationTextSearcher::put_IgnoreWidth(VARIANT_BOOL bIgnore) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	options.provisionalFoldingOptions &= ~PFO_WIDTH;
	if(toBoolean(bIgnore))
		options.provisionalFoldingOptions|= PFO_WIDTH;
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_OnlyIdentifiers
STDMETHODIMP CAutomationTextSearcher::put_OnlyIdentifiers(VARIANT_BOOL bOnlyIdentifiers) {
///	SET_SEARCH_OPTION_(SF_ONLYIDENTIFIERS, bOnlyIdentifiers);
	return E_NOTIMPL;
}

/// @see	ITextSearcher::put_ReplaceWith
STDMETHODIMP CAutomationTextSearcher::put_ReplaceWith(BSTR bstrReplaceWith) {
	m_editor.GetActiveView()->SetReplaceText(SAFE_BSTR(bstrReplaceWith));
	return S_OK;
}

///	@see	ITextSearcher::put_SearchType
STDMETHODIMP CAutomationTextSearcher::put_SearchType(AmbientSearchType type) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();

	switch(type) {
	case AST_LITERAL:	options.type = ST_LITERAL;	break;
	case AST_REGEXP:	options.type = ST_REGEXP;	break;
	case AST_WILDCARD:	return E_NOTIMPL;
	case AST_MIGEMO:	options.type = ST_MIGEMO;	break;
	default:			return E_INVALIDARG;
	}

	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

///	@see	ITextSearcher::put_WholeWord
STDMETHODIMP CAutomationTextSearcher::put_WholeWord(VARIANT_BOOL bWholeWord) {
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();
	options.bWholeWord = toBoolean(bWholeWord);
	m_editor.GetActiveView()->SetSearchOptions(options);
	return S_OK;
}

/// @see	ITextSearcher::ReplaceAll
STDMETHODIMP CAutomationTextSearcher::ReplaceAll(long* pcReplaced) {
	ulong	cReplaced;
	if(pcReplaced != 0)
		*pcReplaced = 0;
	BEGIN_REGEXP_ERROR_HANDLER()
		cReplaced = m_editor.GetActiveView()->ExecCommand(CMDID_SEARCH_REPLACEALL);
	END_REGEXP_ERROR_HANDLER("ReplaceAll")
	if(pcReplaced != 0)
		*pcReplaced = static_cast<long>(cReplaced);
	return S_OK;
}

///	@see	ITextSearcher::ReplaceAndNext
STDMETHODIMP CAutomationTextSearcher::ReplaceAndNext(VARIANT_BOOL* pbFound) {
	CAlphaView*		pView = m_editor.GetActiveView();
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();
	bool			bFound;

	if(pbFound != 0)
		*pbFound = VARIANT_FALSE;
	options.bForward = true;
	pView->SetSearchOptions(options);
	BEGIN_REGEXP_ERROR_HANDLER()
		bFound = toBoolean(pView->ExecCommand(CMDID_SEARCH_REPLACEANDFINDNEXT));
	END_REGEXP_ERROR_HANDLER("ReplaceAndNext")
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

///	@see	ITextSearcher::ReplaceAndPrev
STDMETHODIMP CAutomationTextSearcher::ReplaceAndPrev(VARIANT_BOOL* pbFound) {
	CAlphaView*		pView = m_editor.GetActiveView();
	TSearchOption	options = m_editor.GetActiveView()->GetSearchOptions();
	bool			bFound;

	if(pbFound != 0)
		*pbFound = VARIANT_FALSE;
	options.bForward = false;
	pView->SetSearchOptions(options);
	BEGIN_REGEXP_ERROR_HANDLER()
		bFound = toBoolean(pView->ExecCommand(CMDID_SEARCH_REPLACEANDFINDNEXT));
	END_REGEXP_ERROR_HANDLER("ReplaceAndPrev")
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

#undef BEGIN_REGEXP_ERROR_HANDLER
#undef END_REGEXP_ERROR_HANDLER


// CConfigurations class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CConfigurations::CConfigurations(CAlphaApp& app) : SAFE_MARK, m_app(app) {
}

///	@see	IConfigurations::AddDocumentType
STDMETHODIMP CConfigurations::AddDocumentType(BSTR bstrName, BSTR bstrFileSpec,
		BSTR bstrCommand /* = 0 */, VARIANT_BOOL bPrivate /* = VARIANT_FALSE */) {
	if(bstrName == 0 || bstrFileSpec == 0 || ::SysStringLen(bstrFileSpec) >= MAX_PATH)
		return E_INVALIDARG;

	TDocumentType	type;

	type.strName = bstrName;
	wcscpy(type.wszFileSpec, bstrFileSpec);
	type.strCommand = (bstrCommand != 0) ? bstrCommand : L"";
	type.bPrivate = toBoolean(bPrivate);
	m_app.GetDocumentTypeManager().Add(type);
	return S_OK;
}

///	@see	IConfigurations::Apply
STDMETHODIMP CConfigurations::Apply() {
	m_app.LoadKeyBinds(L"");
	return S_OK;
}

///	@see	IConfigurations::get__NewEnum
STDMETHODIMP CConfigurations::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);
	*ppEnum = 0;
	return E_NOTIMPL;
}

///	@see	IConfigurations::get_KeyboardScheme
STDMETHODIMP CConfigurations::get_KeyboardSchemes(BSTR bstrScopeName, IKeyboardScheme** ppKeyboardScheme) {
	VERIFY_POINTER(ppKeyboardScheme);
	*ppKeyboardScheme = 0;
	if(bstrScopeName == 0)
		return E_INVALIDARG;
	else if(wcscmp(bstrScopeName, L"basic") != 0)	// ̂Ƃ1
		return E_INVALIDARG;

	if(0 == (*ppKeyboardScheme = new CKeyboardScheme(m_app.GetKeyboardMap())))
		return E_OUTOFMEMORY;
	(*ppKeyboardScheme)->AddRef();
	return S_OK;
}

///	@see	IConfigurations::get_Property
STDMETHODIMP CConfigurations::get_Property(BSTR bstrName, BSTR* pbstrValue) {
	VERIFY_POINTER(pbstrValue);
	if(bstrName == 0)
		return E_INVALIDARG;
	*pbstrValue = 0;
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CConfigurations::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[4];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_CONFIGURATIONS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_CONFIGURATIONS_KEYBOARDSCHEMES:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_DISPATCH;
			return get_KeyboardSchemes(args[0].bstrVal,
				reinterpret_cast<IKeyboardScheme**>(&pVarResult->pdispVal));
		case DISPID_CONFIGURATIONS_PROPERTY:	CALL_GETTER_1(Property, VT_BSTR, VT_BSTR);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		if(dispidMember == DISPID_CONFIGURATIONS_PROPERTY) {
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return put_Property(args[1].bstrVal, args[0].bstrVal);
		}
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_CONFIGURATIONS_ADDDOCUMENTTYPE:
			if(pDispParams->cArgs == 4) {
				CALL_METHOD_4(AddDocumentType, VT_BSTR, VT_BSTR, VT_BSTR, VT_BOOL);
			} else if(pDispParams->cArgs == 3) {
				CALL_METHOD_3(AddDocumentType, VT_BSTR, VT_BSTR, VT_BSTR);
			} else if(pDispParams->cArgs == 2) {
				CALL_METHOD_2(AddDocumentType, VT_BSTR, VT_BSTR);
			}
				return DISP_E_BADPARAMCOUNT;
		case DISPID_CONFIGURATIONS_APPLY:					CALL_METHOD_0(Apply);
		case DISPID_CONFIGURATIONS_REMOVEALLDOCUMENTTYPES:	CALL_METHOD_0(RemoveAllDocumentTypes);
		}
	}
	return hr;
}

///	@see	IConfigurations::put_Property
STDMETHODIMP CConfigurations::put_Property(BSTR bstrName, BSTR bstrValue) {
	if(bstrName == 0)
		return E_INVALIDARG;

	m_modifiedProperties[bstrName] = (bstrValue != 0) ? bstrValue : L"";
	return S_OK;
}

///	@see	IConfigurations::RemoveAllDocumentTypes
STDMETHODIMP CConfigurations::RemoveAllDocumentTypes() {
	m_app.GetDocumentTypeManager().RemoveAll();
	return S_OK;
}


// CKeyboardScheme class implementation
/////////////////////////////////////////////////////////////////////////////

map<wstring, VirtualKey> CKeyboardScheme::m_keyValues;

///	RXgN^
CKeyboardScheme::CKeyboardScheme(CKeyboardMap& impl) : SAFE_MARK, m_impl(impl) {
}

///	@see	IKeyboardScheme::Assign
STDMETHODIMP CKeyboardScheme::Assign(BSTR bstrKeyCombination, long nCommandId) {
	if(bstrKeyCombination == 0 || ::SysStringLen(bstrKeyCombination) > 100)
		return E_INVALIDARG;

	if(CKeyboardScheme::m_keyValues.empty()) {
		wchar_t	wsz[4] = {0, 0, 0, 0};
		CKeyboardScheme::m_keyValues[L"bs"]
		= CKeyboardScheme::m_keyValues[L"backspace"] = VK_BACK;
		CKeyboardScheme::m_keyValues[L"tab"] = VK_TAB;
		CKeyboardScheme::m_keyValues[L"del"]
		= CKeyboardScheme::m_keyValues[L"delete"] = VK_CLEAR;
		CKeyboardScheme::m_keyValues[L"enter"] = VK_RETURN;
		CKeyboardScheme::m_keyValues[L"esc"]
		= CKeyboardScheme::m_keyValues[L"escape"] = VK_ESCAPE;
		CKeyboardScheme::m_keyValues[L"sp"]
		= CKeyboardScheme::m_keyValues[L"space"] = VK_SPACE;
		CKeyboardScheme::m_keyValues[L"pgup"]
		= CKeyboardScheme::m_keyValues[L"pageup"] = VK_PRIOR;
		CKeyboardScheme::m_keyValues[L"pgdn"]
		= CKeyboardScheme::m_keyValues[L"pagedown"] = VK_NEXT;
		CKeyboardScheme::m_keyValues[L"end"] = VK_END;
		CKeyboardScheme::m_keyValues[L"home"] = VK_HOME;
		CKeyboardScheme::m_keyValues[L"left"] = VK_LEFT;
		CKeyboardScheme::m_keyValues[L"up"] = VK_UP;
		CKeyboardScheme::m_keyValues[L"right"] = VK_RIGHT;
		CKeyboardScheme::m_keyValues[L"down"] = VK_DOWN;
		CKeyboardScheme::m_keyValues[L"ins"]
		= CKeyboardScheme::m_keyValues[L"insert"] = VK_INSERT;
		for(size_t i = 0; i < 10; ++i) {
			wsz[0] = L'0' + i;
			CKeyboardScheme::m_keyValues[wsz] = '0' + i;
		}
		for(size_t i = 0; i < 26; ++i) {
			wsz[0] = L'a' + i;
			CKeyboardScheme::m_keyValues[wsz] = 'A' + i;
		}
		wsz[0] = L'f';
		for(size_t i = 0; i < 10; ++i) {
			wsz[1] = L'0' + i + 1;
			CKeyboardScheme::m_keyValues[wsz] = VK_F1 + i;
		}
		wsz[1] = L'1';
		for(size_t i = 0; i < 10; ++i) {
			wsz[2] = L'0' + i;
			CKeyboardScheme::m_keyValues[wsz] = VK_F10 + i;
		}
		wsz[1] = L'2';
		for(size_t i = 0; i < 4; ++i) {
			wsz[2] = L'0' + i;
			CKeyboardScheme::m_keyValues[wsz] = VK_F20 + i;
		}
		CKeyboardScheme::m_keyValues[L":"] = VK_OEM_1;
		CKeyboardScheme::m_keyValues[L";"] = VK_OEM_PLUS;
		CKeyboardScheme::m_keyValues[L","] = VK_OEM_COMMA;
		CKeyboardScheme::m_keyValues[L"-"] = VK_OEM_MINUS;
		CKeyboardScheme::m_keyValues[L"."] = VK_OEM_PERIOD;
		CKeyboardScheme::m_keyValues[L"/"] = VK_OEM_2;
		CKeyboardScheme::m_keyValues[L"@"] = VK_OEM_3;
		CKeyboardScheme::m_keyValues[L"["] = VK_OEM_4;
		CKeyboardScheme::m_keyValues[L"\\"] = VK_OEM_5;
		CKeyboardScheme::m_keyValues[L"]"] = VK_OEM_6;
		CKeyboardScheme::m_keyValues[L"^"] = VK_OEM_7;
	}

	wchar_t		wszKeys[120];	// wcsncmp ĝő߂...
	VirtualKey	firstKey = VK_NULL, secondKey = VK_NULL;
	KeyModifier	firstModifiers, secondModifiers;
	KeyModifier	modifiers = 0;
	wchar_t*	p = wszKeys;

	wcscpy(wszKeys, bstrKeyCombination);
	::CharLowerBuffW(wszKeys, wcslen(wszKeys));

	// ͂ŏCL[ƃCL[o
	while(*p != 0) {
		if(wcsncmp(p, L"c-", 2) == 0)			{modifiers |= KM_CTRL; p += 2;}
		else if(wcsncmp(p, L"ctrl+", 5) == 0)	{modifiers |= KM_CTRL; p += 5;}
		else if(wcsncmp(p, L"s-", 2) == 0)		{modifiers |= KM_SHIFT; p += 2;}
		else if(wcsncmp(p, L"shift+", 6) == 0)	{modifiers |= KM_SHIFT; p += 6;}
		else if(wcsncmp(p, L"m-", 2) == 0)		{modifiers |= KM_ALT; p += 2;}
		else if(wcsncmp(p, L"alt+", 4) == 0)	{modifiers |= KM_ALT; p += 4;}
		else {	// CL[
			wchar_t*	pwszSp = wcschr(p, L' ');
			if(pwszSp == p)
				return E_INVALIDARG;	// 擪ɋ󔒂
			if(pwszSp != 0) {
				if(firstKey != VK_NULL)
					return E_INVALIDARG;	// 󔒂2ȏ゠
				*pwszSp = 0;
			}
			map<wstring, VirtualKey>::const_iterator	it = CKeyboardScheme::m_keyValues.find(p);
			if(it == CKeyboardScheme::m_keyValues.end())
				return E_INVALIDARG;	// CL[Ȃ
			if(firstKey == VK_NULL) {
				firstKey = it->second;
				firstModifiers = modifiers;
			} else {
				secondKey = it->second;
				secondModifiers = modifiers;
			}
			if(pwszSp != 0) {
				p = pwszSp + 1;
				modifiers = 0;
			} else
				break;
		}
	}
	if(firstKey == VK_NULL)
		return E_INVALIDARG;	// CL[1

	try {
		if(secondKey == VK_NULL)
			m_impl.Assign(static_cast<CommandId>(nCommandId), firstKey, firstModifiers);
		else
			m_impl.Assign(static_cast<CommandId>(nCommandId), firstKey, firstModifiers, secondKey, secondModifiers);
	} catch(out_of_range&) {
		return E_FAIL;	// Ǝv
	}
	return S_OK;
}

///	@see	IKeyboardScheme::CopyAllMaps
STDMETHODIMP CKeyboardScheme::CopyAllMaps() {
	return E_NOTIMPL;
}

///	@see	IKeyboardScheme::get_Name
STDMETHODIMP CKeyboardScheme::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(m_strSchemeName.c_str());
	return (*pbstrName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CKeyboardScheme::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {
		if(dispidMember == DISPID_KEYBOARDSCHEME_NAME)
			CALL_GETTER(Name, VT_BSTR);
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {
		switch(dispidMember) {
		case DISPID_KEYBOARDSCHEME_ASSIGN:		CALL_METHOD_2(Assign, VT_BSTR, VT_I4);
		case DISPID_KEYBOARDSCHEME_COPYALLMAPS:	CALL_METHOD_0(CopyAllMaps);
		case DISPID_KEYBOARDSCHEME_LOAD:		CALL_METHOD_1(Load, VT_BSTR);
		case DISPID_KEYBOARDSCHEME_SAVE:		CALL_METHOD_1(Save, VT_BSTR);
		}
	}
	return hr;
}

///	@see	IKeyboardScheme::Load
STDMETHODIMP CKeyboardScheme::Load(BSTR bstrSchemeName) {
	if(bstrSchemeName == 0)
		return E_INVALIDARG;

	wchar_t	wszPath[MAX_PATH];

	::GetModuleFileName(0, wszPath, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPath), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(wszPath) + ::SysStringLen(bstrSchemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(wszPath, bstrSchemeName);
	wcscat(wszPath, L".akm");
	if(m_impl.Load(wszPath)) {
		m_strSchemeName = bstrSchemeName;
		return S_OK;
	}
	return E_FAIL;
}

///	@see	IKeyboardScheme::Save
STDMETHODIMP CKeyboardScheme::Save(BSTR bstrSchemeName) {
	if(bstrSchemeName == 0)
		return E_INVALIDARG;

	wchar_t	wszPath[MAX_PATH];

	::GetModuleFileName(0, wszPath, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPath), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(wszPath) + ::SysStringLen(bstrSchemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(wszPath, bstrSchemeName);
	wcscat(wszPath, L".akm");
	if(m_impl.Save(wszPath)) {
		m_strSchemeName = bstrSchemeName;
		return S_OK;
	}
	return E_FAIL;
}


// CAutomationCommand class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param app	AvP[VIuWFNg
 *	@param id	R}hʎq
 */
CAutomationCommand::CAutomationCommand(CAlphaApp& app, CommandId id) : SAFE_MARK, m_app(app), m_id(id) {
}

///	@see	ICommand::Execute
STDMETHODIMP CAutomationCommand::Execute() {
	const_cast<CCommandManager&>(m_app.GetCommandManager()).ExecuteCommand(m_id, false);	// Y
	return S_OK;
}

///	@see	ICommand::get_Checked
STDMETHODIMP CAutomationCommand::get_Checked(VARIANT_BOOL* pbChecked) {
	VERIFY_POINTER(pbChecked);
	*pbChecked = toVariantBoolean(m_app.GetCommandManager().IsChecked(m_id));
	return S_OK;
}

///	@see	ICommand::get_Description
STDMETHODIMP CAutomationCommand::get_Description(BSTR* pbstrDescription) {
	VERIFY_POINTER(pbstrDescription);
	*pbstrDescription = ::SysAllocString(m_app.GetCommandManager().GetDescription(m_id).c_str());
	return (*pbstrDescription != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	ICommand::get_Enabled
STDMETHODIMP CAutomationCommand::get_Enabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_app.GetCommandManager().IsEnabled(m_id, false));
	return S_OK;
}

///	@see	ICommand::get_KeyCombination
STDMETHODIMP CAutomationCommand::get_KeyCombination(BSTR* pbstrKeys) {
	VERIFY_POINTER(pbstrKeys);
	*pbstrKeys = ::SysAllocString(m_app.GetKeyboardMap().GetKeyString(m_id, false).c_str());
	return (*pbstrKeys != 0) ? S_OK  : E_OUTOFMEMORY;
}

///	@see	ICommand::get_Name
STDMETHODIMP CAutomationCommand::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wstring	strName = m_app.GetCommandManager().GetCaption(m_id);
	size_t	i = strName.find(L'(');

	if(i != wstring::npos) {
		strName = strName.substr(0, i);
		i = strName.find(L'&');
		if(i != wstring::npos)
			strName.erase(i, 1);
	}
	*pbstrName = ::SysAllocString(strName.c_str());
	return (*pbstrName != 0) ? S_OK  : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationCommand::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
//	CComVariant		args[3];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_COMMAND_CHECKED:		CALL_GETTER(Checked, VT_BOOL);
		case DISPID_COMMAND_DESCRIPTION:	CALL_GETTER(Description, VT_BSTR);
		case DISPID_COMMAND_ENABLED:		CALL_GETTER(Enabled, VT_BOOL);
		case DISPID_COMMAND_KEYCOMBINATION:	CALL_GETTER(KeyCombination, VT_BSTR);
		case DISPID_COMMAND_NAME:			CALL_GETTER(Name, VT_BSTR);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		if(dispidMember == DISPID_COMMAND_EXECUTE)
			CALL_METHOD_0(Execute);
	}
	return hr;
}


// CAutomationClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAutomationClipboardRing::CAutomationClipboardRing(CClipboardRing& impl) : SAFE_MARK, m_impl(impl) {
}

///	@see	IClipboardRing::Add
STDMETHODIMP CAutomationClipboardRing::Add(BSTR bstrText) {
	if(bstrText == 0)
		return E_INVALIDARG;
	m_impl.Add(bstrText, false);
	return S_OK;
}

///	@see	IClipboardRing::Delete
STDMETHODIMP CAutomationClipboardRing::Delete(short nIndex) {
	if(nIndex < 0 || nIndex > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;
	try {
		m_impl.Delete(static_cast<unsigned char>(nIndex));
	} catch(...) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IClipboardRing::DeleteAll
STDMETHODIMP CAutomationClipboardRing::DeleteAll() {
	m_impl.DeleteAll();
	return S_OK;
}

///	@see	IClipboardRing::get_Count
STDMETHODIMP CAutomationClipboardRing::get_Count(short* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_impl.GetCount();
	return S_OK;
}

///	@see	IClipboardRing::get_Text
STDMETHODIMP CAutomationClipboardRing::get_Text(short nIndex, BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	if(nIndex < 0 || nIndex > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;

	wstring	str;
	bool	b;

	try {
		m_impl.GetText(static_cast<unsigned char>(nIndex), str, b);
	} catch(...) {
		return E_INVALIDARG;
	}
	*pbstrText = ::SysAllocString(str.c_str());
	return (*pbstrText != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationClipboardRing::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	CComVariant		args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_CLIPBOARDRING_COUNT:	CALL_GETTER(Count, VT_I2);
		case DISPID_CLIPBOARDRING_TEXT:		CALL_GETTER_1(Text, VT_BSTR, VT_I2);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_CLIPBOARDRING_ADD:			CALL_METHOD_1(Add, VT_BSTR);
		case DISPID_CLIPBOARDRING_DELETE:		CALL_METHOD_1(Delete, VT_I2);
		case DISPID_CLIPBOARDRING_DELETEALL:	CALL_METHOD_0(DeleteAll);
		case DISPID_CLIPBOARDRING_LIMITCOUNT:	CALL_METHOD_1(LimitCount, VT_I2);
		}
	}
	return hr;
}

///	@see	IClipboardRing::LimitCount
STDMETHODIMP CAutomationClipboardRing::LimitCount(short nLimit) {
	if(nLimit < 0 || nLimit > numeric_limits<uchar>::max())
		return E_INVALIDARG;
	m_impl.LimitCount(static_cast<uchar>(nLimit));
	return S_OK;
}


// CAutomationAbbreviations class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	IAbbreviations::Expand
STDMETHODIMP CAutomationAbbreviations::Expand(BSTR bstrAbbrev, BSTR* pbstrExpanded) {
	VERIFY_POINTER(pbstrExpanded);
	*pbstrExpanded = 0;
	if(bstrAbbrev == 0 || *bstrAbbrev == 0)
		return E_INVALIDARG;
	const string_t	str = CEditView::ExpandAbbreviation(bstrAbbrev);
	*pbstrExpanded = ::SysAllocString(str.c_str());
	return (*pbstrExpanded != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IAbbreviations::get__NewEnum
STDMETHODIMP CAutomationAbbreviations::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);

	list<string_t>	abbreviations;

	CEditView::GetAbbreviationList(abbreviations);

	VARIANT* const	pAbbreviations = new VARIANT[abbreviations.size()];

	list<string_t>::const_iterator	it = abbreviations.begin();
	for(size_t i = 0; i < abbreviations.size(); ++i, ++it) {
		::VariantInit(&pAbbreviations[i]);
		pAbbreviations[i].vt = VT_BSTR;
		pAbbreviations[i].bstrVal = ::SysAllocString(it->c_str());
	}
	*ppEnum = new IEnumVARIANTImpl(pAbbreviations, abbreviations.size());
	if(*ppEnum != 0)
		(*ppEnum)->AddRef();

	for(size_t i = 0; i < abbreviations.size(); ++i)
		::VariantClear(&pAbbreviations[i]);
	delete[] pAbbreviations;

	return (*ppEnum != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationAbbreviations::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENTS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_ABBREVIATIONS_EXPAND:		CALL_METHOD_RET_1(Expand, VT_BSTR, VT_BSTR);
		case DISPID_ABBREVIATIONS_REGISTER:		CALL_METHOD_2(Register, VT_BSTR, VT_BSTR);
		case DISPID_ABBREVIATIONS_REVOKE:		CALL_METHOD_1(Revoke, VT_BSTR);
		case DISPID_ABBREVIATIONS_REVOKEALL:	CALL_METHOD_0(RevokeAll);
		}
	}

	return hr;
}

///	@see	IAbbreviations::Register
STDMETHODIMP CAutomationAbbreviations::Register(BSTR bstrAbbrev, BSTR bstrExpanded) {
	if(bstrAbbrev == 0 || bstrExpanded == 0)
		return E_INVALIDARG;
	try {
		CEditView::RegisterAbbreviation(bstrAbbrev, bstrExpanded);
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IAutomationAbbreviations::Revoke
STDMETHODIMP CAutomationAbbreviations::Revoke(BSTR bstrAbbrev) {
	if(bstrAbbrev == 0 || *bstrAbbrev == 0)
		return E_INVALIDARG;
	CEditView::RevokeAbbreviation(bstrAbbrev);
	return S_OK;
}

///	@see	IAutomationAbbreviations::RevokeAll
STDMETHODIMP CAutomationAbbreviations::RevokeAll() {
	CEditView::RevokeAllAbbreviations();
	return S_OK;
}


// CScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CScriptHost::CScriptHost(CAlphaScriptHost* pImpl) : SAFE_MARK, m_pImpl(pImpl) {
	assert(m_pImpl != 0);
	m_pImpl->AddRef();
}

///	fXgN^
CScriptHost::~CScriptHost() {
	m_pImpl->Release();
}

///	@see	IScriptHost::ConnectObject
STDMETHODIMP CScriptHost::ConnectObject(IDispatch* pObject, BSTR bstrPrefix) {
	VERIFY_POINTER(pObject);
	if(bstrPrefix == 0)
		return E_INVALIDARG;

	try {
		HRESULT	hr;
		if(FAILED(hr = m_pImpl->ConnectObject(pObject, bstrPrefix)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.ConnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}
	return S_OK;
}

///	@see	IScriptHost::CreateObject
STDMETHODIMP CScriptHost::CreateObject(
		BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	if(ppObject == 0)
		return S_OK;
	*ppObject = 0;
	if(bstrProgId == 0)
		return E_INVALIDARG;

	CLSID	clsidObject;
	HRESULT	hr;

	try {
		if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsidObject)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
		if(URLPOLICY_ALLOW != VerifyCreationObject(clsidObject)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
		}
		if(FAILED(hr = ::CoCreateInstance(clsidObject, 0,
				CLSCTX_ALL, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	if(URLPOLICY_ALLOW != VerifyRunningObject(*ppObject, clsidObject)) {
		(*ppObject)->Release();
		*ppObject = 0;
		return 0x800A01AD;
	}
	return (bstrPrefix == 0) ? S_OK : ConnectObject(*ppObject, bstrPrefix);
}

///	@see	IScriptHost::DisconnectObject
STDMETHODIMP CScriptHost::DisconnectObject(IDispatch* pObject) {
	VERIFY_POINTER(pObject);

	try {
		const HRESULT	hr = m_pImpl->DisconnectObject(pObject);
		if(FAILED(hr))
			throw CComException(hr, IID_IScriptHost,
				OLESTR("Ambient.ScriptHost.DisconnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}
	return S_OK;
}

///	@see	IScriptHost::Echo
STDMETHODIMP CScriptHost::Echo(SAFEARRAY/*<VARIANT>*/* pArguments) {
	if(pArguments == 0 && ::SafeArrayGetDim(pArguments) != 1)
		return E_INVALIDARG;
	if(!m_pImpl->IsInteractive())
		return S_OK;

	wostringstream	ss;
	long			cArguments;
	VARIANT**		argumentsArray = 0;
	HWND			hWnd;

	::SafeArrayGetUBound(pArguments, 1, &cArguments);
	++cArguments;
	::SafeArrayAccessData(pArguments, reinterpret_cast<void**>(&argumentsArray));
	for(long i = 0; i < cArguments; ++i) {
		CComVariant	argument;
		argument.ChangeType(VT_BSTR, argumentsArray[i]);
		ss << SAFE_BSTR(argument.bstrVal);
		if(i != cArguments - 1)
			ss << L" ";
	}
	::SafeArrayUnaccessData(pArguments);
	m_pImpl->GetWindow(&hWnd);
	::MessageBox(hWnd, ss.str().c_str(), CAlphaScriptHost::m_pwszName, 0);

	return S_OK;
}

///	@see	IScriptHost::get_Arguments
STDMETHODIMP CScriptHost::get_Arguments(IArguments** ppArguments) {
	VERIFY_POINTER(ppArguments);

	vector<wstring>	vecArgs;
	if(0 == (*ppArguments = new CArguments(vecArgs)))
		return E_OUTOFMEMORY;
	(*ppArguments)->AddRef();
	return S_OK;
}

///	@see	IScriptHost::get_BuildVersion
STDMETHODIMP CScriptHost::get_BuildVersion(short* pnBuildVersion) {
	VERIFY_POINTER(pnBuildVersion);
	*pnBuildVersion = CAlphaScriptHost::m_nBuildVersion;
	return S_OK;
}

///	@see	IScriptHost::get_FullName
STDMETHODIMP CScriptHost::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszPath);
	return (*pbstrFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_Interactive
STDMETHODIMP CScriptHost::get_Interactive(VARIANT_BOOL* pbInteractive) {
	VERIFY_POINTER(pbInteractive);
	*pbInteractive = toVariantBoolean(m_pImpl->IsInteractive());
	return S_OK;
}

///	@see	IScriptHost::get_Name
STDMETHODIMP CScriptHost::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrName = ::SysAllocString(::PathFindFileNameW(wszPath));
	return (*pbstrName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_Path
STDMETHODIMP CScriptHost::get_Path(BSTR* pbstrPath) {
	VERIFY_POINTER(pbstrPath);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrPath = ::SysAllocStringLen(wszPath, wszPath - ::PathFindFileNameW(wszPath) - 1);
	return (*pbstrPath != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_ScriptFullName
STDMETHODIMP CScriptHost::get_ScriptFullName(BSTR* pbstrScriptFullName) {
	VERIFY_POINTER(pbstrScriptFullName);
	*pbstrScriptFullName = ::SysAllocString(m_pImpl->GetScriptPath().c_str());
	return (*pbstrScriptFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_ScriptName
STDMETHODIMP CScriptHost::get_ScriptName(BSTR* pbstrScriptName) {
	VERIFY_POINTER(pbstrScriptName);
	*pbstrScriptName = ::SysAllocString(::PathFindFileNameW(m_pImpl->GetScriptPath().c_str()));
	return (*pbstrScriptName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_StdErr
STDMETHODIMP CScriptHost::get_StdErr(IDispatch** ppStdErr) {
	VERIFY_POINTER(ppStdErr);
	*ppStdErr = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdIn
STDMETHODIMP CScriptHost::get_StdIn(IDispatch** ppStdIn) {
	VERIFY_POINTER(ppStdIn);
	*ppStdIn = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdOut
STDMETHODIMP CScriptHost::get_StdOut(IDispatch** ppStdOut) {
	VERIFY_POINTER(ppStdOut);
	*ppStdOut = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_Timeout
STDMETHODIMP CScriptHost::get_Timeout(long* pnMilliseconds) {
	VERIFY_POINTER(pnMilliseconds);
	*pnMilliseconds = static_cast<long>(m_pImpl->GetTimeout());
	return S_OK;
}

///	@see	IScriptHost::get_Version
STDMETHODIMP CScriptHost::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);

	wchar_t	wszVersion[10];
	swprintf(wszVersion, L"%u.%u",
		CAlphaScriptHost::m_nMajorVersion, CAlphaScriptHost::m_nMinorVersion);
	*pbstrVersion = ::SysAllocString(wszVersion);
	return (*pbstrVersion != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::GetObject
STDMETHODIMP CScriptHost::GetObject(
		BSTR bstrPathName, BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	if(ppObject == 0)
		return S_OK;

	HRESULT	hr = S_OK;
	CLSID	clsid = CLSID_NULL;

	*ppObject = 0;
	try {
		if(bstrProgId != 0) {
			if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsid)))
				throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
		if(URLPOLICY_ALLOW != VerifyCreationObject(clsid)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return hr;
	}

	try {
		if(bstrProgId == 0) {
			if(FAILED(hr = ::CoGetObject(bstrPathName, 0, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
				throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		} else {	// GetInstanceFromFile g
			MULTI_QI	mq = {&IID_IDispatch, 0, 0};

			if(FAILED(hr = ::CoGetInstanceFromFile(0, &clsid, 0,
					CLSCTX_ALL, STGM_READWRITE, bstrPathName, 1, &mq)))
				throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
			hr = mq.pItf->QueryInterface(IID_IDispatch, reinterpret_cast<void**>(ppObject));
		}
		if(URLPOLICY_ALLOW != VerifyRunningObject(*ppObject, clsid)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	return hr;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CScriptHost::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	bool		bCreatedResult = false;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_ARGUMENTS:		CALL_GETTER_ACTX(Arguments, IArguments);
		case DISPID_SCRIPTHOST_BUILDVERSION:	CALL_GETTER(BuildVersion, VT_I2);
		case DISPID_SCRIPTHOST_FULLNAME:		CALL_GETTER(FullName, VT_BSTR);
		case DISPID_SCRIPTHOST_INTERACTIVE:		CALL_GETTER(Interactive, VT_BOOL);
		case DISPID_SCRIPTHOST_NAME:			CALL_GETTER(Name, VT_BSTR);
		case DISPID_SCRIPTHOST_SCRIPTFULLNAME:	CALL_GETTER(ScriptFullName, VT_BSTR);
		case DISPID_SCRIPTHOST_SCRIPTNAME:		CALL_GETTER(ScriptName, VT_BSTR);
		case DISPID_SCRIPTHOST_STDERR:			CALL_GETTER(StdErr, VT_DISPATCH);
		case DISPID_SCRIPTHOST_STDIN:			CALL_GETTER(StdIn, VT_DISPATCH);
		case DISPID_SCRIPTHOST_STDOUT:			CALL_GETTER(StdOut, VT_DISPATCH);
		case DISPID_SCRIPTHOST_TIMEOUT:			CALL_GETTER(Timeout, VT_I4);
		case DISPID_SCRIPTHOST_VERSION:			CALL_GETTER(Version, VT_BSTR);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_INTERACTIVE:	CALL_PUTTER(Interactive, VT_BOOL);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
			;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_CONNECTOBJECT:	CALL_METHOD_2(ConnectObject, VT_DISPATCH, VT_BSTR);
		case DISPID_SCRIPTHOST_CREATEOBJECT:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[1].bstrVal, args[0].bstrVal,
						(pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return S_OK;
		case DISPID_SCRIPTHOST_DISCONNECTOBJECT:	CALL_METHOD_1(DisconnectObject, VT_DISPATCH);
		case DISPID_SCRIPTHOST_ECHO:
			if(pDispParams->cArgs == 1 && pDispParams->rgvarg[0].vt == VT_SAFEARRAY)
				return Echo(pDispParams->rgvarg[0].parray);
			else {
				SAFEARRAY* const	pArray = ::SafeArrayCreateVector(VT_VARIANT, 0, pDispParams->cArgs);
				VARIANTARG**		ppArguments = 0;

				hr = ::SafeArrayAccessData(pArray, reinterpret_cast<void**>(&ppArguments));
				for(unsigned int i = 0; i < pDispParams->cArgs; ++i)
					ppArguments[i] = &pDispParams->rgvarg[pDispParams->cArgs - i - 1];
				hr = ::SafeArrayUnaccessData(pArray);
				hr = Echo(pArray);
				::SafeArrayDestroy(pArray);
				return hr;
			}
		case DISPID_SCRIPTHOST_GETOBJECT:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[0].bstrVal, 0, 0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[1].bstrVal, args[0].bstrVal,
						0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[2].bstrVal, args[1].bstrVal,
						args[0].bstrVal, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_SCRIPTHOST_QUIT:
			if(pDispParams->cArgs == 1) {
				CALL_METHOD_1(Quit, VT_I2);
			} else if(pDispParams->cArgs == 0) {
				CALL_METHOD_0(Quit);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_SCRIPTHOST_SLEEP:	CALL_METHOD_1(Sleep, VT_I4);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IScriptHost::put_Interactive
STDMETHODIMP CScriptHost::put_Interactive(VARIANT_BOOL bInteractive) {
	m_pImpl->SetInteractiveMode(toBoolean(bInteractive));
	return S_OK;
}

///	@see	IScriptHost::Quit
STDMETHODIMP CScriptHost::Quit(short nExitCode /* = 0 */) {
	IActiveScript*	pScriptEngine = 0;
	EXCEPINFO		ei;

	m_pImpl->GetScriptEngine(pScriptEngine);
	ZeroMemory(&ei, sizeof(EXCEPINFO));
	HRESULT	hr = pScriptEngine->InterruptScriptThread(SCRIPTTHREADID_ALL, &ei, 0);
	pScriptEngine->Release();
	return hr;
}

///	@see	IScriptHost::Sleep
STDMETHODIMP CScriptHost::Sleep(long nMilliseconds) {
	if(nMilliseconds < 0)
		return E_INVALIDARG;
	m_pImpl->Sleep(static_cast<unsigned long>(nMilliseconds));
	return S_OK;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param clsid	쐬悤ƂĂIuWFNg CLSID
 *	@return			|V[
 */
DWORD CScriptHost::VerifyCreationObject(CLSID& clsid) {
	IActiveScript*			pScriptEngine = 0;
	CComPtr<IObjectSafety>	pObjectSafety;
	DWORD					dwSupportedOpts, dwEnabledOpts;

	m_pImpl->GetScriptEngine(pScriptEngine);
	if(FAILED(pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety)))) {
		pScriptEngine->Release();
		return URLPOLICY_DISALLOW;
	}
	pScriptEngine->Release();
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pImpl->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD	dwPolicy;
		if(FAILED(pSecurityManager->ProcessUrlAction(URLACTION_ACTIVEX_RUN,
				reinterpret_cast<BYTE*>(&dwPolicy), sizeof(DWORD),
				reinterpret_cast<BYTE*>(&clsid), sizeof(CLSID), 0, 0)))
			return URLPOLICY_DISALLOW;
		return dwPolicy;
	} else
		return toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW : URLPOLICY_ALLOW;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param pUnk		IuWFNg
 *	@param clsid	IuWFNg CLSID
 *	@return			|V[
 */
DWORD CScriptHost::VerifyRunningObject(IUnknown* pUnk, CLSID& clsid) {
/*	CComPtr<IActiveScriptSite>	pScriptHost;
	CComPtr<IObjectSafety>		pObjectSafety;
	DWORD						dwSupportedOpts, dwEnabledOpts;

	if(FAILED(m_pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety))))
		return URLPOLICY_DISALLOW;
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pScriptEngine->GetScriptSite(IID_IActiveScriptSite, reinterpret_cast<void**>(&pScriptHost))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pScriptHost->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD			dwPolicy, cbPolicy;
		DWORD*			pdwPolicy;
		CONFIRMSAFETY	cs = {clsid, pUnk, 0};

		cs.pUnk->AddRef();
		if(FAILED(pSecurityManager->QueryCustomPolicy(GUID_CUSTOM_CONFIRMOBJECTSAFETY,
				reinterpret_cast<BYTE**>(&pdwPolicy), &cbPolicy,
				reinterpret_cast<BYTE*>(&cs), sizeof(CONFIRMSAFETY), 0)))
			return URLPOLICY_DISALLOW;
		dwPolicy = URLPOLICY_DISALLOW;
		if (pdwPolicy != 0) {
			if (sizeof(DWORD) <= cbPolicy)
			dwPolicy = *pdwPolicy;
			::CoTaskMemFree(pdwPolicy);
		}
		return dwPolicy;
	} else*/
		return /*toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW :*/ URLPOLICY_ALLOW;
}


// CArguments class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CArguments::CArguments(const vector<wstring>& args) : SAFE_MARK, m_arguments(args) {
}

///	@see	IArguments::Count
STDMETHODIMP CArguments::Count(long* pcArgs) {
	if(pcArgs != 0)
		*pcArgs = m_arguments.size();
	return S_OK;
}

///	@see	IArguments::get__NewEnum
STDMETHODIMP CArguments::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);
	*ppEnum = 0;
	return E_NOTIMPL;
}

///	@see	IArguments::get_Item
STDMETHODIMP CArguments::get_Item(long nIndex, BSTR* pbstrArgs) {
	VERIFY_POINTER(pbstrArgs);

	if(nIndex < 0 || nIndex >= static_cast<long>(m_arguments.size()))
		return 0x800A0009;
	*pbstrArgs = ::SysAllocString(m_arguments[nIndex].c_str());
	return (*pbstrArgs != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IArguments::get_Length
STDMETHODIMP CArguments::get_Length(long* pcArgs) {
	VERIFY_POINTER(pcArgs);
	*pcArgs = m_arguments.size();
	return S_OK;
}

///	@see	IArguments::get_Named
STDMETHODIMP CArguments::get_Named(IDispatch** ppNamed) {
	VERIFY_POINTER(ppNamed);
	*ppNamed = 0;
	return E_NOTIMPL;
}

///	@see	IArguments::get_Unamed
STDMETHODIMP CArguments::get_Unnamed(IDispatch** ppUnnamed) {
	VERIFY_POINTER(ppUnnamed);
	*ppUnnamed = 0;
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CArguments::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pDispParams,
		VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENTS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_ARGUMENTS_ITEM:		CALL_GETTER_1(Item, VT_BSTR, VT_I4);
		case DISPID_ARGUMENTS_LENGTH:	CALL_GETTER(Length, VT_I4);
		case DISPID_ARGUMENTS_NAMED:	CALL_GETTER(Named, VT_DISPATCH);
		case DISPID_ARGUMENTS_UNNAMED:	CALL_GETTER(Unnamed, VT_DISPATCH);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	else if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_ARGUMENTS_COUNT:		CALL_METHOD_RET_0(Count, VT_I4);
		case DISPID_ARGUMENTS_SHOWUSAGE:	CALL_METHOD_0(ShowUsage);
		default:
			DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IArguments::ShowUsage
STDMETHODIMP CArguments::ShowUsage() {
	return E_NOTIMPL;
}


#undef VERIFY_ARGUMENTS_COUNT
#undef COERCE_ARGUMENT_AT
#undef SAFE_MARK
#undef UNSAFE_MARK

#pragma warning(default : 4390)

/* [EOF] */