// AlphaView.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "AlphaView.h"
#include "Alpha.h"
#include "resource.h"
using Alpha::CAlphaView;
using Alpha::CAlphaDoc;
using namespace Ascension;


// CAlphaView class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CAlphaView::CAlphaView() : m_nLastChar(0) {
}

///	݈ʒu\Ԃ
const wchar_t* CAlphaView::GetCurrentPositionString() const {
	AssertValid();

	static wchar_t		wsz[100];
	wchar_t				wszTempl[100];
	CCharPos			posBegin, posEnd;
	CEditView::TOptions	options;
	SCROLLINFO			si;

	GetOptions(options);
	GetSel(posBegin, posEnd);
	si.cbSize = sizeof(SCROLLINFO);
	GetScrollInfo(SB_VERT, si, SIF_POS | SIF_RANGE);
	::LoadStringW(::GetModuleHandle(0), MSG_CARETPOSITION, wszTempl, 100);
	swprintf(wsz,
		wszTempl,
		posEnd.m_iLine + options.iStartLine,
		ColumnFromChar(posEnd) + options.iStartChar,
		posEnd.m_iChar + options.iStartChar);
	return wsz;
}

///	@see	CView::GetDocument
CAlphaDoc* CAlphaView::GetDocument() const {
	AssertValid();
	return reinterpret_cast<CAlphaDoc*>(m_pDocument);
}

/// @see	CWindow::OnChar
void CAlphaView::OnChar(UINT nChar, UINT nFlags) {
	if(m_nLastChar == 0 || nFlags != m_nLastChar)
		CEditView::OnChar(nChar, nFlags);
}

///	@see	CWindow::OnKeyDown
bool CAlphaView::OnKeyDown(UINT nChar, UINT nFlags) {
	if(CAlphaApp* pApp = CAlphaApp::GetInstance()) {
		if(pApp->OnKeyDown(nChar, nFlags)) {
			m_nLastChar = nFlags;
			return true;
		}
	}
	m_nLastChar = 0;
	return CEditView::OnKeyDown(nChar, nFlags);
}

///	@see	CWindow::OnSysChar
bool CAlphaView::OnSysChar(UINT nChar, UINT nFlags) {
	if(CAlphaApp* pApp = CAlphaApp::GetInstance()) {
		if(pApp->OnSysChar(nChar, nFlags)) {
			m_nLastChar = nChar;
			return true;
		}
	}
	m_nLastChar = 0;
	return CEditView::OnSysChar(nChar, nFlags);
}

///	@see	CWindow::OnSysKeyDown
bool CAlphaView::OnSysKeyDown(UINT nChar, UINT nFlags) {
	if(CAlphaApp* pApp = CAlphaApp::GetInstance()) {
		if(pApp->OnSysKeyDown(nChar, nFlags)) {
			m_nLastChar = nChar;
			return true;
		}
	}
	m_nLastChar = 0;
	return CEditView::OnSysKeyDown(nChar, nFlags);
}

/* [EOF] */