// AlphaScriptHost.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "AlphaScriptHost.h"
#include <objsafe.h>	// IObjectSafety
using Alpha::CAlphaScriptHost;
using Alpha::ScriptSiteSecurityLevel;
using Alpha::CEnumImpl;
using namespace std;
using namespace Armaiti;


// ɂĂ͊ CLSID AIID `ɂȂB
// ȉ̐錾IIɗLɂƂ悢 (Ǝv)

// static const CLSID CLSID_ProcessDebugManager = {
//		0x78a51822, 0x51f4, 0x11d0, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
static const IID	IID_IActiveScriptDebug = {
	0x51973C10, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID	IID_IActiveScriptSiteDebug = {
	0x51973C11, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID	IID_IProcessDebugManager = {
	0x51973C2f, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID	IID_IDebugApplication = {
	0x51973C32, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};

namespace {
	/// CxgVNIuWFNg쐬̂ɕKvȏ
	struct TConnectionInfo {
		IStream*	pScriptEngine;				///< XNvgzXg
		HANDLE		hConnectionCompletionEvent;	///< ڑ/sƂ̃Cxg
		HRESULT		hr;							///< ڑ̌
		IStream*	pConnectionPoint;			///< ڑ|Cg
		IID			iidEvent;					///< CxgVN IID
		wstring		strPrefix;					///< bZ[Wnh̐ړ
	};
	/// CxgnhĂяo
	struct TEventHandlerInvocation {
		OLECHAR*	pwszProcedureName;	///< vVW
		DISPPARAMS*	pArguments;			///< 
		LCID		lcid;				///< LCID
		IStream**	ppObjectArguments;	///< pArguments ̃}[VOꂽA̔z
	};
}


// CAlphaScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

const wchar_t* 			CAlphaScriptHost::m_pwszName = L"Alpha Script Host";
const unsigned short	CAlphaScriptHost::m_nMajorVersion = 0;	///< W[o[W
const unsigned short	CAlphaScriptHost::m_nMinorVersion = 6;	///< }Ci[o[W
const unsigned short	CAlphaScriptHost::m_nBuildVersion = 2;	///< rhԍ

/**
 *	RXgN^
 *	@param hWnd							TCgEBhE
 *	@param pScriptEngine				GW
 *	@param bIgnoreCaseOnPropertySearch	vpeBTɑ啶ʂȂ
 */
CAlphaScriptHost::CAlphaScriptHost(HWND hWnd, IActiveScript* pScriptEngine, bool bIgnoreCaseOnPropertySearch)
		: m_hOwnerWindow(hWnd), m_pScriptEngine(pScriptEngine),
		m_nSecurityLevelForSafeObject(SSSL_ALLOW), m_nSecurityLevelForUnsafeObject(SSSL_QUERYUSER),
		m_bAllowedErrorReport(true), m_bIgnoreCaseOnPropertySearch(bIgnoreCaseOnPropertySearch),
		m_bEnteredScript(false), m_bInteractive(true), m_nTimeout(0) {
	assert(m_hOwnerWindow == 0 || ::IsWindow(m_hOwnerWindow));
	assert(m_pScriptEngine != 0);

	wcscpy(m_wszScriptPath, L"");
	m_pScriptEngine->AddRef();

	// GWɎZLeB}l[WƂĎg킹
	CComPtr<IObjectSafety>	pObjectSafety;
	if(SUCCEEDED(m_pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety)))) {
		DWORD	dwSupportedOpts, dwEnabledOpts;
		if(SUCCEEDED(pObjectSafety->GetInterfaceSafetyOptions(
				IID_NULL, &dwSupportedOpts, &dwEnabledOpts))) {
			if(toBoolean(dwSupportedOpts & INTERFACE_USES_SECURITY_MANAGER))
				pObjectSafety->SetInterfaceSafetyOptions(IID_NULL, dwSupportedOpts, INTERFACE_USES_SECURITY_MANAGER);
			else {
				SetSecurityLevel(true, m_nSecurityLevelForSafeObject);
				SetSecurityLevel(false, m_nSecurityLevelForUnsafeObject);
			}
		}
	}
}

///	fXgN^
CAlphaScriptHost::~CAlphaScriptHost() {
	for(EventSinkTable::iterator it = m_eventSinks.begin(); it != m_eventSinks.end(); ++it)
		DisconnectObject(it->first);
	m_pScriptEngine->Close();
	m_pScriptEngine->Release();
	_ReleaseTopLevelObjects();
}

/**
 *	ŏʃIuWFNg̐ݒ
 *	@param pwszObjectName			ŏʃIuWFNg̖O
 *	@param pObject					ŏʃIuWFNg
 *	@param dwItemTraits				IActiveScript::AddNamedItem Ɠ
 *	@throw std::invalid_argument	ɓ̃IuWFNg݂ꍇ
 */
void CAlphaScriptHost::AddTopLevelObject(const OLECHAR* pwszObjectName, IDispatch* pObject, DWORD dwItemTraits) {
	assert(pwszObjectName != 0);
	assert(pObject != 0);

	if(!m_bIgnoreCaseOnPropertySearch)
		m_topLevelObjects[pwszObjectName] = pObject;
	else {
		wchar_t*	pwsz = new wchar_t[wcslen(pwszObjectName) + 1];
		wcscpy(pwsz, pwszObjectName);
		m_topLevelObjects[::CharLowerW(pwsz)] = pObject;
		delete[] pwsz;
	}
	pObject->AddRef();
	m_pScriptEngine->AddNamedItem(pwszObjectName, dwItemTraits);
}

/**
 *
 *	@param pObject		ڑmIuWFNg
 *	@param pwszPrefix	Cxgnh̐ړ
 *	@return				SCODE
 */
HRESULT CAlphaScriptHost::ConnectObject(IDispatch* pObject, const OLECHAR* pwszPrefix) {
	assert(pObject != 0 && pwszPrefix != 0);

	HRESULT								hr;
	CComPtr<IConnectionPointContainer>	pCPContainer;
	CComPtr<IEnumConnectionPoints>		pCPEnumerator;
	CComPtr<IConnectionPoint>			pConnectionPoint;
	CComPtr<IProvideClassInfo2>			pClassInfoProvider;
	IID									iidEvent;

	// ڑ|CgT
	if(FAILED(pObject->QueryInterface(IID_IConnectionPointContainer, reinterpret_cast<void**>(&pCPContainer))))
		return E_NOINTERFACE;
	if(S_OK == pObject->QueryInterface(
			IID_IProvideClassInfo2, reinterpret_cast<void**>(&pClassInfoProvider))) {
		// IProvideClassInfo2::GetGUID Ŏ擾łꍇ
		if(FAILED(hr = pClassInfoProvider->GetGUID(GUIDKIND_DEFAULT_SOURCE_DISP_IID, &iidEvent)))
			return hr;
		if(FAILED(hr = pCPContainer->FindConnectionPoint(iidEvent, &pConnectionPoint)))
			return hr;
	} else if(SUCCEEDED(hr = pCPContainer->EnumConnectionPoints(&pCPEnumerator))) {
		// SẴCxgɑΉ
		if(S_OK == pCPEnumerator->Next(1, &pConnectionPoint, 0)) {
			if(FAILED(hr = pConnectionPoint->GetConnectionInterface(&iidEvent)))
				return hr;
		}
	}
	if(pConnectionPoint == 0)
		return E_FAIL/*CONNECT_E_CANNOTCONNECT*/;

	CAdhocEventSink*	pSink = new CAdhocEventSink(*m_pScriptEngine, iidEvent, pwszPrefix);
	pObject->AddRef();
	pSink->AddRef();
	m_eventSinks.insert(make_pair(pObject, pSink));
	hr = pSink->Connect(pConnectionPoint);

	if(FAILED(hr)) {
		m_eventSinks.erase(pObject);
		pObject->Release();
		pSink->Release();
	}
	return hr;
}

/**
 *	
 *	@param pObject	ڑIuWFNg
 *	@return			SCODE
 */
HRESULT CAlphaScriptHost::DisconnectObject(IDispatch* pObject) {
	assert(pObject != 0);
	
	EventSinkTable::iterator	it = m_eventSinks.find(pObject);

	if(it == m_eventSinks.end())
		return E_INVALIDARG;
	const HRESULT	hr = it->second->Disconnect();

	it->first->Release();
	it->second->Release();
	m_eventSinks.erase(it);
	return hr;
}

/// @see	IActiveScriptSiteWindow::EnableModeless
STDMETHODIMP CAlphaScriptHost::EnableModeless(BOOL fEnable) {
/*	if(!fEnable)	return m_bInteractive ? S_OK : E_FAIL;
	else	*/		return S_OK;
}

/**
 *	@brief	XNvg猾GW肵A CLSID Ԃ
 *
 *	̃\bh̓WXg̊gq̐ݒ肩猾GWoA
 *	gq̐ݒ肪sĂȂꍇ (Ⴆ΃XNvgGWCXg[
 *	̃vO̊gqēo^ꍇ) ͌Ȃ\B
 *	gqƌGW̑Ή̓AvP[Vxōŝ
 *
 *	@param pwszFileName	XNvg
 *	@param clsid		[out] GW CLSIDBɎsꍇ CLSID_NULL
 */
void CAlphaScriptHost::FindScriptEngine(const wchar_t* pwszFileName, CLSID& clsid) {
	assert(pwszFileName != 0);
	clsid = CLSID_NULL;

	wchar_t*	pwszExt = ::PathFindExtensionW(pwszFileName);
	HKEY		hKey;
	wchar_t		wszFileType[100], wszProgId[100], wszScriptEngine[100];
	DWORD		cbData;
	long		err;

	if(*pwszExt == 0)
		return;
	if(ERROR_SUCCESS != ::RegOpenKeyExW(HKEY_CLASSES_ROOT, pwszExt, 0, KEY_READ, &hKey))
		return;
	cbData = sizeof(wszFileType);
	err = ::RegQueryValueExW(hKey, 0, 0, 0, reinterpret_cast<BYTE*>(wszFileType), &cbData);
	::RegCloseKey(hKey);
	if(err != ERROR_SUCCESS)
		return;

	wcscpy(wszScriptEngine, wszFileType);
	wcscat(wszScriptEngine, L"\\ScriptEngine");
	err = ::RegOpenKeyExW(HKEY_CLASSES_ROOT, wszScriptEngine, 0, KEY_READ, &hKey);
	cbData = sizeof(wszProgId);
	if(err == ERROR_SUCCESS) {
		err = ::RegQueryValueExW(hKey, 0, 0, 0, reinterpret_cast<BYTE*>(wszProgId), &cbData);
		::RegCloseKey(hKey);
	} else {
		::RegCloseKey(hKey);
		// L[ "ScriptFile" tčĒ (PerlScript Ƃ)
		wcscpy(wszScriptEngine, wszFileType);
		wcscat(wszScriptEngine, L"ScriptFile\\ScriptEngine");
		if(ERROR_SUCCESS != ::RegOpenKeyExW(HKEY_CLASSES_ROOT, wszScriptEngine, 0, KEY_READ, &hKey))
			return;
		err = ::RegQueryValueExW(hKey, 0, 0, 0, reinterpret_cast<BYTE*>(wszProgId), &cbData);
		::RegCloseKey(hKey);
		if(err != ERROR_SUCCESS)
			return;
	}
	::CLSIDFromProgID(wszProgId, &clsid);
}

///	@see	IActiveScriptSite::GetItemInfo
STDMETHODIMP CAlphaScriptHost::GetItemInfo(LPCOLESTR pstrName,
		DWORD dwReturnMask, IUnknown** ppunkItem, ITypeInfo** ppTypeInfo) {
	IDispatch*	pItemObject = 0;
	wchar_t*	pwsz = const_cast<OLECHAR*>(pstrName);

	if(m_bIgnoreCaseOnPropertySearch) {
		if(pwsz = new wchar_t[wcslen(pstrName) + 1]) {
			wcscpy(pwsz, pstrName);
			::CharLowerW(pwsz);
		} else
			return E_OUTOFMEMORY;
	}

	MemberTable::const_iterator	it = m_topLevelObjects.find(pwsz);

	if(it != m_topLevelObjects.end())
		pItemObject = it->second;
	else {
		if(toBoolean(dwReturnMask & SCRIPTINFO_IUNKNOWN)) {
			VERIFY_POINTER(ppunkItem);
			*ppunkItem = 0;
		}
		if(toBoolean(dwReturnMask & SCRIPTINFO_ITYPEINFO)) {
			VERIFY_POINTER(ppTypeInfo);
			*ppTypeInfo = 0;
		}
		if(m_bIgnoreCaseOnPropertySearch)
			delete[] pwsz;
		return TYPE_E_ELEMENTNOTFOUND;
	}

	if(toBoolean(dwReturnMask & SCRIPTINFO_IUNKNOWN)) {
		VERIFY_POINTER(ppunkItem);
		(*ppunkItem = pItemObject)->AddRef();
	}
	if(toBoolean(dwReturnMask & SCRIPTINFO_ITYPEINFO)) {
		VERIFY_POINTER(ppTypeInfo);
		pItemObject->GetTypeInfo(0, 0, ppTypeInfo);
	}

	if(m_bIgnoreCaseOnPropertySearch)
		delete[] pwsz;
	return S_OK;
}

/**
 *	XNvg̔Cӂ̃vVWĂяo
 *	@param pwszName	vVW
 *	@param lcid		ĂяoP[
 *	@param pParams		
 */
HRESULT CAlphaScriptHost::_InvokeScriptGlobalProcedure(const OLECHAR* pwszName, LCID lcid, DISPPARAMS* pParams) {
	if(pwszName == 0 || pParams == 0)
		return E_INVALIDARG;
	if(m_pScriptEngine == 0)
		return E_UNEXPECTED;

	CComPtr<IDispatch>	pTopLevel;
	DISPID				id;
	HRESULT				hr;

	if(m_bEnteredScript)
		hr = m_pScriptEngine->SetScriptState(SCRIPTSTATE_DISCONNECTED);
	if(FAILED(hr = m_pScriptEngine->GetScriptDispatch(0, &pTopLevel)))
		return hr;
	if(FAILED(hr = pTopLevel->GetIDsOfNames(IID_NULL, const_cast<OLECHAR**>(&pwszName), 1, lcid, &id)))
		return hr;

	VARIANT			result;
	EXCEPINFO		exception;
	unsigned int	iArgErr;

	::VariantInit(&result);
	memset(&exception, 0, sizeof(EXCEPINFO));
	hr = pTopLevel->Invoke(id, IID_NULL, lcid, DISPATCH_METHOD, pParams, &result, &exception, &iArgErr);
	::VariantClear(&result);
	return hr;
}

///	@see	IActiveScriptSite::OnEnterScript
STDMETHODIMP CAlphaScriptHost::OnEnterScript() {
//	if(m_pDebugApplication != 0)
//		HRESULT	hr = m_pDebugApplication->CauseBreak();	// fobKu[N|CgZbg邽߂Ɏ~߂
	m_bEnteredScript = true;
	return S_OK;
}

///	@see	IActiveScriptSite::OnScriptError
STDMETHODIMP CAlphaScriptHost::OnScriptError(IActiveScriptError* pscripterror) {
	if(pscripterror == 0)
		return E_INVALIDARG;

	EXCEPINFO	ei;

	ZeroMemory(&ei, sizeof(EXCEPINFO));	// Python ł͕K{
	pscripterror->GetExceptionInfo(&ei);
	if(ei.scode == S_OK)	// G[ł͂Ȃ
		return S_OK;

	DWORD			dwSrcCtx;
	unsigned long	iLine;
	long			iChar;

	m_bIsErrorReported = true;

	// G[bZ[Wo
	if(m_bAllowedErrorReport) {
		wostringstream	ss;

		pscripterror->GetSourcePosition(&dwSrcCtx, &iLine, &iChar);
		if(PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE) {
			ss << L"XNvgG[܂B"
				<< L"\n\nXNvg:\t" << ((m_wszScriptPath[0] != 0) ? m_wszScriptPath : L"(s)")
				<< L"\ns:\t" << iLine + 1
				<< L"\n:\t" << iChar + 1
				<< L"\nG[:\t" << ((ei.bstrDescription != 0) ? ei.bstrDescription : L"(s)")
				<< L"\nSCODE:\t" << hex << uppercase << ei.scode
				<< L"\nG[:\t" << ((ei.bstrSource != 0) ? ei.bstrSource : L"(s)");
		} else {
			ss << L"Script error occured."
				<< L"\n\nscript:\t" <<  ((m_wszScriptPath[0] != 0) ? m_wszScriptPath : L"(unknown)")
				<< L"\nline:\t" << iLine + 1
				<< L"\ncharacter:\t" << iChar + 1
				<< L"\nerror:\t" << ((ei.bstrDescription != 0) ? ei.bstrDescription : L"(unknown)")
				<< L"\nscode:\t" << hex << uppercase << ei.scode
				<< L"\nsource:\t" << ((ei.bstrSource != 0) ? ei.bstrSource : L"(unknown)");
		}
		::MessageBoxW(m_hOwnerWindow, ss.str().c_str(), m_pwszName, MB_ICONHAND);
		::SysFreeString(ei.bstrSource);
		::SysFreeString(ei.bstrDescription);
		::SysFreeString(ei.bstrHelpFile);
	}

	return S_OK;
}

///	@see	IInternetHostSecurityManager::ProcessUrlAction
STDMETHODIMP CAlphaScriptHost::ProcessUrlAction(DWORD dwAction,
		BYTE* pPolicy, DWORD cbPolicy, BYTE* pContext, DWORD cbContext, DWORD dwFlags, DWORD dwReserved) {
	VERIFY_POINTER(pPolicy);
	if(dwReserved != 0)
		return (*pPolicy = URLPOLICY_DISALLOW), E_INVALIDARG;

	// Java ۂBASR  URLACTION_JAVA_IObjIObjCURR_MAX g悤 (Mar. 2004)
	if(dwAction >= URLACTION_JAVA_MIN && dwAction <= URLACTION_JAVA_MAX && cbPolicy >= sizeof(DWORD))
		return (*reinterpret_cast<DWORD*>(pPolicy) = URLPOLICY_JAVA_MEDIUM), S_FALSE;
	else if(dwAction != URLACTION_ACTIVEX_RUN)	// Active X IuWFNg̍쐬ȊO͖
		return (*pPolicy = URLPOLICY_ALLOW), S_OK;

	// ȉAΏۂ Active X IuWFNĝ
	ScriptSiteSecurityLevel	nSecurityLevel = m_nSecurityLevelForUnsafeObject;
	CComPtr<ICatInformation>	pci;

	// KpZLeBx肷̂Ɏ\ɂIuWFNgSǂ𒲂ׂB
	// R|[lgJeS "Controls that are safely scripable" g
	if(cbContext == sizeof(CLSID)
			&& SUCCEEDED(::CoCreateInstance(CLSID_StdComponentCategoriesMgr,
			0, CLSCTX_ALL, IID_ICatInformation, reinterpret_cast<void**>(&pci)))) {
		CATID	id = CATID_SafeForScripting;
		if(S_OK == pci->IsClassOfCategories(*reinterpret_cast<CLSID*>(pContext), 1, &id, -1, 0))
			nSecurityLevel = m_nSecurityLevelForSafeObject;
	}

	// ȉAΏۂ͈SłȂ\̂ Active X IuWFNĝ
	memset(pPolicy, 0, cbPolicy);

	if(nSecurityLevel <= SSSL_ALLOW) {
		*pPolicy = URLPOLICY_ALLOW;
		return S_OK;
	} else if(nSecurityLevel == SSSL_QUERYUSER
			&& toBoolean(::IsWindow(m_hOwnerWindow))
			&& !toBoolean(dwFlags & PUAF_NOUI)) {
		// x_CAOo
		wostringstream	ss;
		UINT		nDialogType = MB_YESNO | MB_ICONEXCLAMATION | MB_DEFBUTTON2;
		OLECHAR*	pwszProgID = 0;
		OLECHAR*	pwszCLSID = 0;

		if(dwFlags & PUAF_FORCEUI_FOREGROUND)
			nDialogType |= MB_SETFOREGROUND;

		if(cbContext == sizeof(CLSID)) {
			::ProgIDFromCLSID(*reinterpret_cast<CLSID*>(pContext), &pwszProgID);
			::StringFromCLSID(*reinterpret_cast<CLSID*>(pContext), &pwszCLSID);
		}
		if(PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE)
			ss << m_wszScriptPath
				<< L"\n\nL̃XNvg͈SłȂ\̂IuWFNg쐬悤ƂĂ܂B"
				<< L"\nIuWFNg̍쐬܂?\n\nvꂽIuWFNg:"
				<< L"\n  ProgID:\t" << ((pwszProgID != 0) ? pwszProgID : L"(擾ł܂ł)")
				<< L"\n  IID:\t" << ((pwszCLSID != 0) ? pwszCLSID : L"(擾ł܂ł)");
		else
			ss << m_wszScriptPath
				<< L"\n\nAbove script is about to create the object possibly unsafe."
				<< L"\nDo you allow this?\n\nRequired object is:"
				<< L"\n  ProgID:\t" << ((pwszProgID != 0) ? pwszProgID : L"(failed to obtain)")
				<< L"\n  IID:\t" << ((pwszCLSID != 0) ? pwszCLSID : L"(failed to obtain)");
		*pPolicy = (::MessageBoxW(m_hOwnerWindow, ss.str().c_str(), m_pwszName,
						nDialogType) == IDYES) ? URLPOLICY_ALLOW : URLPOLICY_DISALLOW;

		if(pwszProgID != 0)	::CoTaskMemFree(pwszProgID);
		if(pwszCLSID != 0)	::CoTaskMemFree(pwszCLSID);

		return (*pPolicy == URLPOLICY_ALLOW) ? S_OK : S_FALSE;
	} else /*if(nSecurityLevel >= SSSL_DISALLOW)*/ {
		*pPolicy = URLPOLICY_DISALLOW;
		return S_FALSE;
	}
}

///	@see	IInternetHostSecurityManager::QueryCustomPolicy
STDMETHODIMP CAlphaScriptHost::QueryCustomPolicy(REFGUID guidKey,
		BYTE** ppPolicy, DWORD* pcbPolicy, BYTE* pContext, DWORD cbContext, DWORD dwReserved) {
	VERIFY_POINTER(ppPolicy);
	VERIFY_POINTER(pcbPolicy);

	*ppPolicy = 0;
	*pcbPolicy = 0;
	if(dwReserved != 0)
		return E_INVALIDARG;
//	if(guidKey = GUID_CUSTOM_CONFIRMSAFETY && cbContext >= sizeof(CONFIRMSAFETY*)) {
//		CONFIRMSAFETY*	pcs = reinterpret_cast<CONFIRMSAFETY*>(pContext);
//	}
	*ppPolicy = static_cast<BYTE*>(::CoTaskMemAlloc(sizeof(DWORD)));
	if(*ppPolicy == 0)
		return E_OUTOFMEMORY;
	*pcbPolicy = sizeof(DWORD);
	**ppPolicy = URLPOLICY_ALLOW;
	return S_OK;
}

///	ŏʃIuWFNgSč폜
void CAlphaScriptHost::_ReleaseTopLevelObjects() {
	for(MemberTable::iterator it = m_topLevelObjects.begin(); it != m_topLevelObjects.end(); ++it)
		it->second->Release();
	m_topLevelObjects.clear();
}

/**
 *	ActiveX IuWFNg쐬ɑ΂ZLeBx̐ݒ
 *	@param bForSafeObject	Sƃ}[NĂIuWFNgɂĐݒ肷ꍇ
 *							trueB}[NĂȂIuWFNg̏ꍇ false
 *	@param nLevel			ZLeBx
 */
void CAlphaScriptHost::SetSecurityLevel(bool bForSafeObject, ScriptSiteSecurityLevel nLevel) {
	if(bForSafeObject)
		m_nSecurityLevelForSafeObject = nLevel;
	else {
		CComPtr<IObjectSafety>	pSafety;

		m_nSecurityLevelForUnsafeObject = nLevel;
		if(SUCCEEDED(m_pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pSafety)))) {
			DWORD	dwSupportedOpts, dwEnabledOpts;
			if(SUCCEEDED(pSafety->GetInterfaceSafetyOptions(IID_NULL, &dwSupportedOpts, &dwEnabledOpts))
					&& !toBoolean(dwSupportedOpts & INTERFACE_USES_SECURITY_MANAGER)
					&& toBoolean(dwSupportedOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER))
				pSafety->SetInterfaceSafetyOptions(IID_NULL,
					dwSupportedOpts, (nLevel == SSSL_DISALLOW) ? INTERFACESAFE_FOR_UNTRUSTED_CALLER : 0);
		}
	}
}

/**
 *	XNvgw莞Ԓ~ (Cxg̃nhO͌p)
 *	@param nMilliseconds	~~b (0ł)
 */
void CAlphaScriptHost::Sleep(unsigned long nMilliseconds) {
	::Sleep(nMilliseconds);
}


// CAdhocEventSink class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param scriptEngine	GW
 *	@param iidEvent		CxgC^[tFCX IID
 *	@param strPrefix	Cxgnh̐ړ
 */
CAlphaScriptHost::CAdhocEventSink::CAdhocEventSink(
		IActiveScript& scriptEngine, const IID& iidEvent, const wstring& strPrefix)
		: m_pScriptEngine(&scriptEngine), m_pConnectionPointContainer(0), m_iidEvent(iidEvent), m_strPrefix(strPrefix) {
	m_pScriptEngine->AddRef();
}

///	fXgN^
CAlphaScriptHost::CAdhocEventSink::~CAdhocEventSink() {
	if(m_pConnectionPointContainer != 0)
		Disconnect();
	m_pScriptEngine->Release();
}

/**
 *	CxgVNƂĐڑ
 *	@param pConnectionPoint	ڑ|Cg
 *	@return					IConnectionPoint::Advise Ɠ
 */
HRESULT CAlphaScriptHost::CAdhocEventSink::Connect(IConnectionPoint* pConnectionPoint) {
	if(pConnectionPoint == 0)
		return E_INVALIDARG;
	if(m_pConnectionPointContainer != 0)
		return E_UNEXPECTED;

	HRESULT	hr;

	if(FAILED(hr = pConnectionPoint->Advise(static_cast<IUnknown*>(this), &m_dwCookie)))
		return hr;
	pConnectionPoint->GetConnectionPointContainer(&m_pConnectionPointContainer);

	// \bh̃G~[g
	// (̓G[NĂ S_OK Ԃ)
	CComPtr<IProvideClassInfo>	pClassInfoProvider;
	CComPtr<ITypeInfo>			pTypeInfo;
	CComPtr<IDispatch>			pActiveXObject;
	if((SUCCEEDED(m_pConnectionPointContainer->QueryInterface(
			IID_IProvideClassInfo, reinterpret_cast<void**>(&pClassInfoProvider)))
			&& SUCCEEDED(pClassInfoProvider->GetClassInfo(&pTypeInfo)))
			|| (SUCCEEDED(m_pConnectionPointContainer->QueryInterface(
			IID_IDispatch, reinterpret_cast<void**>(&pActiveXObject)))
			&& SUCCEEDED(pActiveXObject->GetTypeInfo(0, LOCALE_USER_DEFAULT, &pTypeInfo)))) {
		CComPtr<ITypeLib>	pTypeLib;
		UINT				i;
		if(SUCCEEDED(pTypeInfo->GetContainingTypeLib(&pTypeLib, &i))) {
			pTypeInfo = 0;
			if(SUCCEEDED(pTypeLib->GetTypeInfoOfGuid(m_iidEvent, &pTypeInfo))) {
				TYPEATTR*	pTypeAttribute;
				if(SUCCEEDED(pTypeInfo->GetTypeAttr(&pTypeAttribute))) {
					for(WORD i = 0; i < pTypeAttribute->cFuncs; ++i) {
						FUNCDESC*	pMethodDescription;
						if(SUCCEEDED(pTypeInfo->GetFuncDesc(i, &pMethodDescription))) {
							BSTR	bstrName;
							if(SUCCEEDED(pTypeInfo->GetDocumentation(
									pMethodDescription->memid, &bstrName, 0, 0, 0))) {
								m_events[bstrName] = pMethodDescription->memid;
								m_handlers[pMethodDescription->memid] = m_strPrefix + bstrName;
								::SysFreeString(bstrName);
							}
							pTypeInfo->ReleaseFuncDesc(pMethodDescription);
						}
					}
					pTypeInfo->ReleaseTypeAttr(pTypeAttribute);
				}
			}
		}
	}

	return S_OK;
}

/**
 *	ڑ
 *	@return	IConnectionPoint::Unadvise Ɠ
 */
HRESULT CAlphaScriptHost::CAdhocEventSink::Disconnect() {
	if(m_pConnectionPointContainer == 0)
		return E_UNEXPECTED;

	HRESULT						hr;
	CComPtr<IConnectionPoint>	pConnectionPoint;

	if(FAILED(hr = m_pConnectionPointContainer->FindConnectionPoint(m_iidEvent, &pConnectionPoint)))
		return hr;
	m_events.clear();
	m_handlers.clear();
	return pConnectionPoint->Unadvise(m_dwCookie);
}

///	@see	IDispatch::GetIDsOfNames
STDMETHODIMP CAlphaScriptHost::CAdhocEventSink::GetIDsOfNames(
		REFIID riid, OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId) {
	if(riid != IID_NULL)
		return E_INVALIDARG;
	VERIFY_POINTER(rgDispId);

	for(unsigned int i = 0; i < cNames; ++i) {
		map<wstring, DISPID>::const_iterator	it = m_events.find(rgszNames[i]);
		if(it == m_events.end())
			return DISP_E_UNKNOWNNAME;
		rgDispId[i] = it->second;
	}
	return S_OK;
}

///	@see	IDispatch::GetTypeInfo
STDMETHODIMP CAlphaScriptHost::CAdhocEventSink::GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
	VERIFY_POINTER(ppTypeInfo);
	*ppTypeInfo = 0;
	return TYPE_E_ELEMENTNOTFOUND;
}

///	@see	IDispatch::GetTypeInfoCount
STDMETHODIMP CAlphaScriptHost::CAdhocEventSink::GetTypeInfoCount(UINT* pcTypeInfo) {
	VERIFY_POINTER(pcTypeInfo);
	*pcTypeInfo = 0;
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAlphaScriptHost::CAdhocEventSink::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pDispParams,
		VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return E_INVALIDARG;

	map<DISPID, wstring>::const_iterator	it = m_handlers.find(dispidMember);

	if(it == m_handlers.end())
		return DISP_E_MEMBERNOTFOUND;

	HRESULT				hr;
	CComPtr<IDispatch>	pTopLevel;
	DISPID				id;
	OLECHAR*			pstrName = const_cast<OLECHAR*>(it->second.c_str());

	if(FAILED(hr = m_pScriptEngine->GetScriptDispatch(0, &pTopLevel)))
		return hr;
	if(FAILED(hr = pTopLevel->GetIDsOfNames(riid, &pstrName, 1, lcid, &id)))
		return hr;
	return pTopLevel->Invoke(id, riid, lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
}

///	@see	IUnknown::QueryInterface
STDMETHODIMP CAlphaScriptHost::CAdhocEventSink::QueryInterface(REFIID riid, void** ppvObject) {
	VERIFY_POINTER(ppvObject);

	if(riid == m_iidEvent || riid == IID_IDispatch || riid == IID_IUnknown)
		*ppvObject = static_cast<IDispatch*>(this);
	else
		return (*ppvObject = 0), E_NOINTERFACE;
	reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
	return S_OK;
}


// CEnumImpl class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param bIgnoreCaseOnPropertySearch	vpeBTɑ啶ʂ邩
 */
CEnumImpl::CEnumImpl(bool bIgnoreCaseOnPropertySearch) : m_bIgnoreCase(bIgnoreCaseOnPropertySearch) {
}

/**
 *	vpeBǉ
 *	@param pwszName					vpeB
 *	@param value					l
 *	@throw std::invalid_argument	ɓ̃vpeB݂ƂX[
 */
void CEnumImpl::AddProperty(const OLECHAR* pwszName, long value) throw(invalid_argument) {
	assert(pwszName != 0);

	static DISPID	id = 100;
	wchar_t*		pwsz = m_bIgnoreCase ? new wchar_t[wcslen(pwszName) + 1] : const_cast<OLECHAR*>(pwszName);

	if(m_bIgnoreCase) {
		wcscpy(pwsz, pwszName);
		::CharLowerW(pwsz);
	}
	const NameToIdTable::const_iterator	it = m_mapNameTable.find(pwsz);
	if(it != m_mapNameTable.end())
		throw std::invalid_argument("There is a property has same name.");
	m_mapNameTable[pwsz] = id;
	m_mapIdTable[id++] = value;
	if(m_bIgnoreCase)
		delete[] pwsz;
}

///	IDispatch::GetTypeInfo
STDMETHODIMP CEnumImpl::GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
	VERIFY_POINTER(ppTypeInfo);
	*ppTypeInfo = 0;
	return E_NOTIMPL;
}

///	IDispatch::GetTypeInfoCount
STDMETHODIMP CEnumImpl::GetTypeInfoCount(UINT* pcTypeInfo) {
	VERIFY_POINTER(pcTypeInfo);
	*pcTypeInfo = 0;
	return S_OK;
}

///	IDispatch::GetIDsOfNames
STDMETHODIMP CEnumImpl::GetIDsOfNames(REFIID riid, LPOLESTR* rgszNames, UINT cNames, LCID lcid, DISPID* rgDispId) {
	VERIFY_POINTER(rgDispId);
	if(riid != IID_NULL || rgszNames == 0)
		return E_INVALIDARG;

	wchar_t*	pwsz = m_bIgnoreCase ? new wchar_t[wcslen(rgszNames[0]) + 1] : rgszNames[0];

	if(m_bIgnoreCase) {
		wcscpy(pwsz, rgszNames[0]);
		::CharLowerW(pwsz);
	}
	NameToIdTable::const_iterator it = m_mapNameTable.find(pwsz);
	if(m_bIgnoreCase)
		delete[] pwsz;
	if(it == m_mapNameTable.end())
		return DISP_E_UNKNOWNNAME;
	rgDispId[0] = it->second;
	return S_OK;
}

///	IDispatch::Invoke
STDMETHODIMP CEnumImpl::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS *pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, UINT* puArgErr) {
	if(riid != IID_NULL)
		return E_INVALIDARG;
	else if(pVarResult == 0)
		return S_OK;
	else if((wFlags & DISPATCH_PROPERTYGET) == 0)
		return DISP_E_MEMBERNOTFOUND;

	const IdToValueTable::const_iterator	it = m_mapIdTable.find(dispidMember);
	if(it == m_mapIdTable.end())
		return DISP_E_MEMBERNOTFOUND;

	pVarResult->vt = VT_I4;
	pVarResult->lVal = it->second;
	return S_OK;
}

/* [EOF] */