// Alpha.h
// (c) 2003-2004 exeal

#ifndef _ALPHA_H_
#define _ALPHA_H_
#include "resource.h"
#include "DocumentManager.h"
#include "AlphaEditController.h"
#include "AlphaView.h"
//#include "Ambient.h"
#include "OutputWnd.h"
//#include "OutlineParserDlg.h"
#include "KeyboardMap.h"
#include "ScriptMacroManager.h"
//#include "AlphaApplicationDebugger.h"
#include "../Manah/WinApp.h"
#include "../Manah/Menu.h"
#include "../Manah/Rebar.h"
#include "../Manah/Toolbar.h"
#include "../Manah/StatusBar.h"
#include <map>
#include <sstream>


// Literals
/////////////////////////////////////////////////////////////////////////////

#define IDN_TOOLIMAGECOUNT	(32 * 7)

#define IDS_UNTITLED			L"Untitled"
#define IDS_DEFAULTSTATUSTEXT	L""
#define IDS_FILEFILTERW			L"ׂẴt@C\0*.*\0\0"
#define IDS_KEYMACROFILENAME	L"keymacro"
#define IDS_EVENTSCRIPTFILENAME	L"events.*"
#define IDS_MACRO_DIRECTORY_NAME			L"macros\\"
#define IDS_KEYBOARDSCHEME_DIRECTORY_NAME	L"keyboardSchemes\\"
#define IDS_ICON_DIRECTORY_NAME				L"icons\\"
#define IDS_BREAK_CR	L"CR (Macintosh)"
#define IDS_BREAK_LF	L"LF (Unix)"
#define IDS_BREAK_CRLF	L"CR+LF (Windows)"
#define IDS_BREAK_NEL	L"NEL (U+0085)"
#define IDS_BREAK_LS	L"LS (U+2028)"
#define IDS_BREAK_PS	L"PS (U+2029)"

// INI sections
#define INI_SECTION_SCRIPTENGINES	L"ScriptEngines"

// Timer ID
#define ID_TIMER_QUERYCOMMAND	1	// c[o[ACe̗L
#define ID_TIMER_MOUSEMOVE		2	// J[\~1bɔ (qg\ȂǂɎgp)

// message ID
#define WM_EVENTHANDLER		WM_APP + 1	// CXbhCxgnhXNvgĂяo
										// wParam => unused
										// lParam => std::pair<const OLECHAR*, DISPPARAMS*>*
										// lParam->first => Cxgnh
										// lParam->second => 
#define WM_CREATENEWBUFFER	WM_APP + 2	// OnFileNew() Ăяo
										// wParam => 1
										// lParam => 2
#define WM_ENDSCRIPTMACRO	WM_APP + 3	// }NXNvgIɑĂ
										// wParam, lParam => unused


namespace Alpha {

// O錾
class CScriptManager;
class CEventHandlerScript;
class CCommandManager;
class CMRUManager;
class CFindDlg;
class CGotoLineDlg;
class CBookmarkDlg;
/*class CDebugBreakPointsDlg;
class CDebugCallStackDlg;
class CDebugImmediateDlg;
class CDebugRunningDocumentsDlg;
class CDebugThreadsDlg;
class CDebugVariablesDlg;*/

namespace Ambient {
	class CApplication;
	class CDocuments;
}


///	s̑BCEditView::SetLineParam Ŏg
enum LineAttribute {
	LA_NONE					= 0x00,	///< ɂȂ
	LA_BREAKPOINT_ENABLED	= 0x01,	///< Lȃu[N|Cg
	LA_BREAKPOINT_DISABLED	= 0x02,	///< ȃu[N|Cg
	LA_BREAKPOINT_MASK		= 0x03,	///< SetLineParam p}XN
};


// CAlphaApp class definition
/////////////////////////////////////////////////////////////////////////////

/// Alpha ̃AvP[VNX
class CAlphaApp :
		public Manah::Windows::CWinApp,
		public Ascension::CEditViewEventAdapter,
		virtual public IDocumentManagerEventListener,
		virtual public Ascension::IEditDocEventListener,
		virtual public Ascension::IClipboardRingEventListener/*,
		virtual public IAlphaApplicationDebuggerEventListener*/ {
	friend class CAlphaApplication;
	friend class CCommandManager;
	friend class CAlphaView;

	// RXgN^
public:
	CAlphaApp();
	virtual ~CAlphaApp();

	// \bh
public:
	void					ApplyDocumentType(std::size_t iDocument,
								const std::wstring& strTypeName = L"") throw(std::out_of_range);
	HRESULT					GetAutomation(
								Alpha::Ambient::CApplication** ppApplication,
								Alpha::Ambient::CDocuments** ppDocuments) const;
	static const wchar_t*	GetCodePageName(Ascension::Encodings::CodePage cp);
	const CCommandManager&	GetCommandManager() const;
	CDocumentManager&		GetDocumentManager() const;
	CDocumentTypeManager&	GetDocumentTypeManager() const;
	CKeyboardMap&			GetKeyboardMap() const;
	static CAlphaApp*		GetInstance();
	void					GetScriptLanguageByFileName(const wchar_t* pwszFileName, CLSID& clsid) const;
	CScriptManager&			GetScriptManager() const;
	virtual bool			InitApplication(HINSTANCE hInstance);
	virtual bool			InitInstance();
	void					LoadKeyBinds(const std::wstring& strSchemeName);
	int						MessageBox(DWORD wID, UINT nType,
								Manah::Windows::CMessageArguments& args = Manah::Windows::CMessageArguments());
	bool					OpenFile(const std::wstring& strPathName,
								Ascension::Encodings::CodePage cp = Ascension::Encodings::CPEX_AUTODETECT_USERLANG,
								bool bAddToMRU = true);
	void					ParseCommandLine(const std::vector<std::wstring>& args);
	void					SetFont(const LOGFONTW& lf);

	// IDocumentManagerEventListener C^[tFCX
	void	OnActivatDocumentChanged();

	// IEditViewEventListener C^[tFCX
	void	OnChangedAbbreviationExpansionReadyState(bool bReady, const Ascension::string_t& strAbbrev);
	void	OnDrawIndicatorMargin(Ascension::length_t iLine, Manah::Windows::GDI::CDC<>& dc,
				const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis);
	void	OnIncrementalSearchEvent(Ascension::IncrementalSearchEvent event, const Ascension::char_t* pwsz);
	void	OnInvokeUriLink(const Ascension::char_t* pwszUri);
	void	OnMatchBracketFoundOutOfView(const Ascension::CCharPos& pos);
	void	OnMoveCaret(const Ascension::CCharPos& pos);
	void	OnMoveCursor(const POINT& pt);
	void	OnQueryLineColor(Ascension::length_t iLine, bool bBookmarked,
				DWORD dwParam, bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack);

	// IEditDocEventListener C^[tFCX
	bool	OnDocumentFoundUnconvertableChar();
	void	OnDocumentLoaded();
	void	OnDocumentModified();
	void	OnDocumentOverwrittenByOtherProcess(Ascension::CEditDoc* pDocument);

	// IClipboardRingEventListener C^[tFCX
	void	OnClipboardRingChanged();
	void	OnClipboardRingDeniedAdding();
/*
	// IAlphaApplicationDebuggerEventListener C^[tFCX
	void	OnDebugStart();
	void	OnDebugEnd();
	void	OnDebugStopAtBreakPoint(unsigned long iLine);
	void	OnDebugStopByError(unsigned long iLine);
	void	OnDebugStepTo(unsigned long iLine);
	void	OnDebugIllegalStatus(DebugStatus ds);
*/
private:
	const wchar_t*	_GetMenuLabel(CommandId id) const;
	void			_GetProfileList(const wchar_t* pwszSectionName, const wchar_t* pwszKeyName,
						std::list<std::wstring>& items, const wchar_t* pwszDefault = 0);
	void			_GetProfileSet(const wchar_t* pwszSectionName, const wchar_t* pwszKeyName,
						std::set<std::wstring>& items, const wchar_t* pwszDefault = 0);
	bool			_HandleFileOpenError(Ascension::StreamStatus ss);
	bool			_HandleKeyDown(VirtualKey key, KeyModifier modifiers);
	void			_LoadINISettings();
	void			_ResetBufferBarIcons();
	void			_SaveINISettings();
	void			_SetupMenus();
	void			_SetupToolbar();
	void			_UpdateStatusBar();
	void			_UpdateTitleBar();
protected:
	virtual LRESULT	DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	void			GetModelessDialogList(std::list<HWND>& listDlgs) const;

	// bZ[Wnh
protected:
	virtual bool	OnFileClose(bool bConfirm = true);
	virtual bool	OnFileCloseAll(bool bExceptCurrent);
	virtual void	OnFileNew(Ascension::Encodings::CodePage cp = -1, Ascension::BreakType bt = Ascension::BT_AUTO);
	virtual void	OnFileNewWithFormat();
	virtual bool	OnFileOpen();
	virtual void	OnFileReopen();
	virtual void	OnFileReopenWithCodepage();
	virtual bool	OnFileSave(std::size_t iDocument = -1) throw(std::out_of_range);
	virtual bool	OnFileSaveAs(std::size_t iDocument = -1) throw(std::out_of_range);
	virtual bool	OnFileSaveAll();
	virtual void	OnFileProperty();
	virtual void	OnFileOperation(UINT id);
	virtual void	OnEditReloadPlugin();
	virtual void	OnFindFind();
	virtual void	OnFindFindNext(bool bPrevious = false, bool bNotice = true);
	virtual void	OnFindBookmarkAll();
	virtual void	OnFindToggleBookmark();
	virtual void	OnFindReplaceAll();
	virtual void	OnFindReplaceAndNext();
	virtual void	OnFindParseOutline();
	virtual void	OnToolCommonOption();
	virtual void	OnToolDocTypeOption();
	virtual void	OnToolFont();
	virtual void	OnToolExecute();
	virtual void	OnToolExecuteCommand();
	virtual void	OnToolDebugStart();
	virtual void	OnToolDebugInsertBreakPoint();
	virtual void	OnToolDebugBreakPoints();
	virtual void	OnToolDebugCallStack();
	virtual void	OnToolDebugImmediate();
	virtual void	OnToolDebugVariables();
	virtual void	OnToolDebugThreads();
	virtual void	OnHelpAbout();

protected:
	virtual bool	OnClose();																		// WM_CLOSE
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);							// WM_COMMAND
	virtual void	OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds);									// WM_COPYDATA
	virtual void	OnDestroy();																	// WM_DESTROY
	virtual void	OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem);							// WM_DRAWITEM
	virtual void	OnDropFiles(HDROP hDrop);														// WM_DROPFILES
	virtual void	OnEnterMenuLoop(bool bIsTrackPopup);											// WM_ENTERMENULOOP
	virtual void	OnExitMenuLoop(bool bIsTrackPopup);												// WM_EXITMENULOOP
	virtual void	OnInitMenu(HMENU hMenu);														// WM_INITMENU
	virtual void	OnInitMenuPopup(HMENU hMenu, UINT nIndex, bool bSysMenu);						// WM_INITMENUPOPUP
	virtual bool	OnKeyDown(UINT nChar, UINT nFlags);												// WM_KEYDOWN
	virtual void	OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI);							// WM_MEASUREITEM
	virtual LRESULT	OnMenuChar(wchar_t ch, UINT nFlags, Manah::Windows::Controls::CMenu* pMenu);	// WM_MENUCHAR
	virtual void	OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);						// WM_MENUSELECT
	virtual void	OnMouseMove(UINT nFlags, POINT pt);												// WM_MOUSEMOVE
	virtual bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);											// WM_NOTIFY
	virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);							// WM_SETCURSOR
	virtual void	OnSize(UINT nType, int cx, int cy);												// WM_SIZE
	virtual bool	OnSysChar(UINT nChar, UINT nFlags);												// WM_SYSCHAR
	virtual bool	OnSysKeyDown(UINT nChar, UINT nFlags);											// WM_SYSKEYDOWN
	virtual void	OnTimer(UINT nIDTimer);															// WM_TIMER

protected:
	void	OnRebarChevronPushed(LPNMREBARCHEVRON lpNMRebarChevron);	// RBN_CHEVRONPUSHED

	// hLgAr[̕ύXĎ
protected:
	static void OnUpdateDocument();

protected:
	/* EBhEvVW */
	static LRESULT CALLBACK AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// f[^o
protected:
	/* CX^X */
	static CAlphaApp*	m_pInstance;	// 1̃CX^X

private:
	/* EBhE */
	Manah::Windows::Controls::CMenu*		m_pMenu;			// Cj[
	Manah::Windows::Controls::CMenu*		m_pFileOpeMenu;		// [t@C] |bvAbvj[
	Manah::Windows::Controls::CMenu*		m_pNewDocTypeMenu;	// VKhLg^Cv|bvAbvj[
	Manah::Windows::Controls::CMenu*		m_pAppDocTypeMenu;	// KphLg^Cv|bvAbvj[
	Manah::Windows::Controls::CMenu*		m_pBufferBarMenu;	// obt@o[̃|bvAbvj[
	Manah::Windows::Controls::CRebar		m_rebar;			// o[
	Manah::Windows::Controls::CToolbar		m_toolbar;			// Wc[o[
	Manah::Windows::Controls::CToolbar		m_bufferBar;		// obt@o[
	Manah::Windows::Controls::CStatusBar	m_statusBar;		// Xe[^Xo[
	COutputWnd								m_wndOutput;		// [o] EBhE
	CFindDlg*								m_pdlgSearch;		// [ƒu]_CAO
	CGotoLineDlg*							m_pdlgGotoLine;		// [wsֈړ]_CAO
	CBookmarkDlg*							m_pdlgBookmark;		// [ubN}[N]_CAO
//	COutlineParserDlg						m_dlgOutline;		// [AEgC]_CAO
	WNDPROC									m_wndprocTab;		// ^ǔ̃EBhEvVW
	int										m_nOutputWndHeight;	// o̓EBhE̍
	bool									m_bSizingOutputWnd;	// o̓EBhE̍ύX

	/* GDI IuWFNg */
	HFONT	m_hCommonFont;

	/* @\ƃR}h */
	CScriptManager*				m_pScriptManager;
	CEventHandlerScript*		m_pEventHandlerScript;	// events.* s錾GW
//	CAlphaApplicationDebugger*	m_pActiveDebugger;		// ANeBuȃfobK
	CAlphaEditController*		m_pDebuggingEditor;		// fobÕGfB^
	CCommandManager*			m_pCommandManager;		// R}h̊Ǘ
	CKeyboardMap				m_keyboardMap;			// gp̃L[{[h}bv
	CMRUManager*				m_pMRUManager;			// MRU Xg̊Ǘ
	CDocumentManager			m_documents;			// Xg̊Ǘ
	CDocumentTypeManager		m_documentTypes;		// ^Cv̊Ǘ
	CScriptMacroManager*		m_pScriptMacroManager;	// XNvg}N̊Ǘ
	VirtualKey					m_2Stroke1stKey;		// ͒2Xg[NV[PX1Xg[Nڂ̃L[
	KeyModifier					m_2Stroke1stModifiers;	// ͒2Xg[NV[PX1Xg[Nڂ̏CL[

	/* fobO_CAO */
/*	CDebugBreakPointsDlg*		m_pdlgDebugBreakPoints;			// [u[N|Cg] _CAO
	CDebugCallStackDlg*			m_pdlgDebugCallStack;			// [Ăяo] _CAO
	CDebugImmediateDlg*			m_pdlgDebugImmediate;			// [C~fBGCg] _CAO
	CDebugRunningDocumentsDlg*	m_pdlgDebugRunningDocuments;	// [s̃hLg] _CAO
	CDebugThreadsDlg*			m_pdlgDebugThreads;				// [Xbh] _CAO
	CDebugVariablesDlg*			m_pdlgDebugVariables;			// [ϐ] _CAO
*/
	/* I[g[VpC^[tFCX */
	Alpha::Ambient::CApplication*	m_pApplication;
	Alpha::Ambient::CDocuments*		m_pDocuments;

	/* IvV */
	bool	m_bUseShortKeyNames;				// Z`̃L[̖Og
	bool	m_bShowMessageBoxOnFind;			// ŃbZ[W{bNX\
	bool	m_bInitializeFindTextFromEditor;	// [ƒu] _CAOJƂ
												// eLXgGfB^珉
};


///	R}hǗIuWFNgԂ
inline const CCommandManager& CAlphaApp::GetCommandManager() const {
	AssertValid();
	return *m_pCommandManager;
}

///	}l[WԂ
inline CDocumentManager& CAlphaApp::GetDocumentManager() const {
	return const_cast<CAlphaApp*>(this)->m_documents;
}

///	^Cv}l[WԂ
inline CDocumentTypeManager& CAlphaApp::GetDocumentTypeManager() const {
	AssertValid();
	return const_cast<CAlphaApp*>(this)->m_documentTypes;
}

///	B̃AvP[VIuWFNgԂ
inline CAlphaApp* CAlphaApp::GetInstance() {
	return CAlphaApp::m_pInstance;
}

///	L[蓖ăIuWFNgԂ
inline CKeyboardMap& CAlphaApp::GetKeyboardMap() const {
	AssertValid();
	return const_cast<CAlphaApp*>(this)->m_keyboardMap;
}

/**
 *	INI 當񃊃Xgǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param items			[out] Xg
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void CAlphaApp::_GetProfileList(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, std::list<std::wstring>& items, const wchar_t* pwszDefault /* = 0 */) {
	const std::wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	std::wstring		strItem;

	items.clear();
	if(strList.empty())
		return;
	std::wistringstream	ss(strList);
	while(ss >> strItem)
		items.push_back(strItem);
}


/**
 *	INI 當̏Wǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param items			[out] W
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void	CAlphaApp::_GetProfileSet(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, std::set<std::wstring>& items, const wchar_t* pwszDefault /* = 0 */) {
	std::wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	std::wstring	strItem;

	items.clear();
	if(strList.empty())
		return;
	std::wistringstream	ss(strList);
	while(ss >> strItem)
		items.insert(strItem);
}

} /* namespace Alpha */

#endif /* _ALPHA_H_ */

/* [EOF] */