// Alpha.cpp : AvP[Vp̃Gg |Cg̒`
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "Ambient.h"
#include "CommandManager.h"
#include "EventHandlerScript.h"
#include "MRUManager.h"
#include "AboutDlg.h"
#include "FindDlg.h"
#include "GotoLineDlg.h"
#include "BookmarkDlg.h"
#include "CodePagesDlg.h"
#include "FilePropertyDlg.h"
#include "FileOperationDlg.h"
#include "ExecuteCommandDlg.h"
//#include "DebugDlg.h"
#include "SelectLanguageDlg.h"
#include "ConfirmUnsavedDocumentDlg.h"
#include "NewFileFormatDlg.h"
#include "../Manah/WaitCursor.h"
#include "../Manah/DC.h"
#include "../Manah/GDIObject.h"
#include <algorithm>
#include <fstream>
#include <dlgs.h>
#include <crtdbg.h>	// _CrtCheckMemory
//#include "Msxml3.tlh"	// MSXML2::IXMLDOMDocument
using namespace Alpha;
using namespace Ascension;
using namespace Ascension::Encodings;
using namespace Manah::Windows;
using namespace Manah::Windows::GDI;
using namespace Manah::Windows::Controls;
using namespace Manah::Text;
using namespace Armaiti;


// O[o֐
/////////////////////////////////////////////////////////////////////////////

///	Gg|Cg
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE /* hPrevInstance */, LPSTR /* lpCmdLine */, int /* nCmdShow */) {
	OSVERSIONINFOA	osvi;

	// NT nׂ
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOA);
	::GetVersionExA(&osvi);
	if(!toBoolean(osvi.dwPlatformId & VER_PLATFORM_WIN32_NT)) {
		if(PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE)
			::MessageBoxA(0, "gp̃o[W OS ł Alpha s邱Ƃ͂ł܂B", "Alpha", MB_ICONHAND);
		else
			::MessageBoxA(0, "This application runs on only WinNT platform.", "Alpha", MB_ICONHAND);
		return -1;
	}

	int	nExitCode = 0/*EXIT_SUCCESS*/;

	// ȒPȑdN}~
	HWND	hExistWnd = ::FindWindowW(L"Alpha", 0);
	if(!toBoolean(::IsWindow(hExistWnd))) {	// B Alpha vZX
		CAlphaApp*				pApplication = new CAlphaApp();
		INITCOMMONCONTROLSEX	iccex;

		::OleInitialize(0);	// STA ɓ + T[rX̏
		ZeroMemory(&iccex, sizeof(INITCOMMONCONTROLSEX));
		iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
		iccex.dwICC = ICC_WIN95_CLASSES | ICC_COOL_CLASSES;
		::InitCommonControlsEx(&iccex);
		pApplication->InitApplication(hInstance);
		pApplication->InitInstance();
		nExitCode = pApplication->Run();
		::OleUninitialize();
		delete pApplication;
	} else {	// ̃vZXɃR}hCn
		COPYDATASTRUCT	cd = {0,
			(wcslen(::GetCommandLineW()) + 1) * sizeof(wchar_t), ::GetCommandLineW()};
		::SendMessageW(hExistWnd, WM_COPYDATA, 0, reinterpret_cast<LPARAM>(&cd));
		::Sleep(300);
		::SetForegroundWindow(hExistWnd);
	}

	assert(_CrtCheckMemory());

	return nExitCode;
}

namespace {
	///	ChooseFontW ̂߂̃tbNvVW
	UINT CALLBACK CFHookProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {
		if(message == WM_COMMAND && LOWORD(wParam) == psh3) {	// [Kp] {^
			LOGFONTW	lf;
			::SendMessageW(hDlg, WM_CHOOSEFONT_GETLOGFONT, 0, reinterpret_cast<LPARAM>(&lf));
			CAlphaApp::GetInstance()->SetFont(lf);
			return TRUE;
		} else if(message == WM_INITDIALOG) {
			::EnableWindow(::GetDlgItem(hDlg, stc2), false);	// [X^C] 𖳌
			::EnableWindow(::GetDlgItem(hDlg, cmb2), false);
		}
		return 0;
	}

	///	GetOpenFileNameW AGetSaveFileNameW ̂߂̃tbNvVW
	UINT CALLBACK OFNHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
		static HWND		hCharCodeCombo, hCharCodeStatic;
		static HWND		hBreakCodeCombo, hBreakCodeStatic;
		unsigned int	iCharCode;
		int				iBreakCode;

		switch(message) {
		case WM_INITDIALOG: {
			LPOPENFILENAMEW	lpOFN = reinterpret_cast<LPOPENFILENAMEW>(lParam);
			set<CodePage>	codePages;

			hCharCodeCombo = ::GetDlgItem(hWnd, IDC_COMBO_CHARCODE);
			hCharCodeStatic = ::GetDlgItem(hWnd, IDC_STATIC_1);
			hBreakCodeCombo = ::GetDlgItem(hWnd, IDC_COMBO_BREAKCODE);
			hBreakCodeStatic = ::GetDlgItem(hWnd, IDC_STATIC_2);
			CEncoderFactory::GetInstance().EnumCodePages(codePages);
			for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
				if(::IsWindow(hBreakCodeCombo) && CEncoderFactory::GetInstance().IsCodePageForAutoDetection(*it))
					continue;
				const wchar_t*	pwszCPName = CAlphaApp::GetCodePageName(*it);
				if(pwszCPName == 0)
					continue;
				iCharCode = ::SendMessageW(hCharCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszCPName));
				::SendMessageW(hCharCodeCombo, CB_SETITEMDATA, iCharCode, *it);
			}
			const UINT	cCharCode = ::SendMessageW(hCharCodeCombo, CB_GETCOUNT, 0, 0L);
			::SendMessageW(hCharCodeCombo, CB_SETCURSEL, 0, 0L);
			for(iCharCode = 0; iCharCode < cCharCode; ++iCharCode) {
				if((lpOFN->lCustData & 0x00FFFFFF) == ::SendMessage(hCharCodeCombo, CB_GETITEMDATA, iCharCode, 0L)) {
					::SendMessageW(hCharCodeCombo, CB_SETCURSEL, iCharCode, 0L);
					break;
				}
			}
			if(::IsWindow(hBreakCodeCombo)) {
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ꂵȂ"));
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_CRLF));
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_LF));
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_CR));
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_NEL));
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_LS));
				::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_PS));
				switch(lpOFN->lCustData >> 24) {
				case BT_AUTO:	::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 0, 0L);	break;
				case BT_CRLF:	::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 1, 0L);	break;
				case BT_LF:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 2, 0L);	break;
				case BT_CR:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 3, 0L);	break;
				case BT_NEL:	::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 4, 0L);	break;
				case BT_LS:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 5, 0L);	break;
				case BT_PS:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 6, 0L);	break;
				}
			}
		}
			break;
		case WM_NOTIFY: {
			if(reinterpret_cast<LPNMHDR>(lParam)->code == CDN_FILEOK) {
				LPOFNOTIFYW	lpOFNOIFY = reinterpret_cast<LPOFNOTIFYW>(lParam);

				iCharCode = ::SendMessageW(hCharCodeCombo, CB_GETCURSEL, 0, 0L);
				lpOFNOIFY->lpOFN->lCustData = ::SendMessageW(hCharCodeCombo, CB_GETITEMDATA, iCharCode, 0L);
				if(::IsWindow(hBreakCodeCombo)) {
					iBreakCode = ::SendMessageW(hBreakCodeCombo, CB_GETCURSEL, 0, 0L);
					switch(iBreakCode) {
					case 0:	lpOFNOIFY->lpOFN->lCustData |= BT_AUTO << 24;	break;
					case 1:	lpOFNOIFY->lpOFN->lCustData |= BT_CRLF << 24;	break;
					case 2:	lpOFNOIFY->lpOFN->lCustData |= BT_LF << 24;		break;
					case 3:	lpOFNOIFY->lpOFN->lCustData |= BT_CR << 24;		break;
					case 4:	lpOFNOIFY->lpOFN->lCustData |= BT_NEL << 24;	break;
					case 5:	lpOFNOIFY->lpOFN->lCustData |= BT_LS << 24;		break;
					case 6:	lpOFNOIFY->lpOFN->lCustData |= BT_PS << 24;		break;
					}
				}
			}
		}
			break;
		case WM_SIZE:
			// Rg[̈ʒuTCYς...
			break;
		}

		return 0L;
	}
} // namespace `anonymous'


// CDocumentTypeManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDocumentTypeManager::CDocumentTypeManager() {
	TDocumentType	type;

	wcscpy(type.wszFileSpec, L"");
	type.strName = L"default";
	type.bPrivate = false;
	m_documentTypes.push_back(type);
}

/**
 *	^Cv̒ǉ
 *	@param type	o^镶^Cv
 */
void CDocumentTypeManager::Add(const TDocumentType& type) throw(invalid_argument) {
	if(type.strName.empty())
		throw invalid_argument("Document type name can not be empty.");
	else if(wcslen(type.wszFileSpec) == 0)
		throw invalid_argument("File name specification can not be empty.");
	m_documentTypes.push_back(type);
}

/**
 *	w肵O̕^Cv̔ԍԂ
 *	@param strName	^Cv
 *	@return			ԍBȂꍇ0
 */
size_t CDocumentTypeManager::Find(const wstring& strName) const {
	for(size_t i = 1; i < m_documentTypes.size(); ++i) {
		if(m_documentTypes[i].strName == strName)
			return i;
	}
	return 0;
}

/**
 *	wʒu̕^CvԂ
 *	@param iType	ʒu
 *	@return			^Cv
 */
const TDocumentType& CDocumentTypeManager::GetAt(size_t iType) const throw(out_of_range) {
	try {
		return m_documentTypes.at(iType);
	} catch(...) {
		throw out_of_range("Specified index is invalid.");
	}
}

/**
 *	gqɓK镶^CvԂ
 *	@param strFileName	t@C
 *	@return				^CvBK镶^CvȂꍇ0Ԗ () Ԃ
 */
const TDocumentType& CDocumentTypeManager::GetByFileName(const wstring& strFileName) const {
	if(strFileName.empty())
		return m_documentTypes[0];
	for(size_t i = 1; i < m_documentTypes.size(); ++i) {
		if(toBoolean(::PathMatchSpecW(strFileName.c_str(), m_documentTypes[i].wszFileSpec)))
			return m_documentTypes[i];
	}
	return m_documentTypes[0];
}

///	o^Ă镶^Cv̑Ԃ
size_t CDocumentTypeManager::GetCount() const {
	return m_documentTypes.size();
}

///	o^Ă镶Sč폜
void CDocumentTypeManager::RemoveAll() {
	m_documentTypes.clear();
	CDocumentTypeManager();
}


// CAlphaApp class implementation
/////////////////////////////////////////////////////////////////////////////

CAlphaApp* CAlphaApp::m_pInstance = 0;

///	RXgN^
CAlphaApp::CAlphaApp()
		: m_pMenu(0), m_pFileOpeMenu(0), m_pNewDocTypeMenu(0), m_pAppDocTypeMenu(0), m_pBufferBarMenu(0),
		m_bSizingOutputWnd(false), m_hCommonFont(0),
		m_pEventHandlerScript(0), /*m_pActiveDebugger(0),*/ m_pDebuggingEditor(0),
		m_pMRUManager(0), m_pScriptMacroManager(0), m_pApplication(0), m_pDocuments(0),
		m_2Stroke1stKey(VK_NULL), m_2Stroke1stModifiers(0) {
	assert(CAlphaApp::m_pInstance == 0);
	CAlphaApp::m_pInstance = this;
	m_pNewDocTypeMenu = new CMenu();
	m_pCommandManager = new CCommandManager(*this);
	m_pScriptMacroManager = new CScriptMacroManager(*this);
	m_pdlgSearch = new CFindDlg(*this);
	m_pdlgGotoLine = new CGotoLineDlg(*this);
	m_pdlgBookmark = new CBookmarkDlg(*this);
/*	m_pdlgDebugBreakPoints = new CDebugBreakPointsDlg;
	m_pdlgDebugCallStack = new CDebugCallStackDlg;
	m_pdlgDebugImmediate = new CDebugImmediateDlg;
	m_pdlgDebugRunningDocuments = new CDebugRunningDocumentsDlg;
	m_pdlgDebugThreads = new CDebugThreadsDlg;
	m_pdlgDebugVariables = new CDebugVariablesDlg;*/
}

///	fXgN^
CAlphaApp::~CAlphaApp() {
	::DestroyAcceleratorTable(m_hAcceleratorTable);
//	delete m_pMenu;
//	delete m_pFileOpeMenu;
	delete m_pNewDocTypeMenu;
	delete m_pAppDocTypeMenu;
	delete m_pBufferBarMenu;
	delete m_pEventHandlerScript;
	delete m_pCommandManager;
	delete m_pScriptMacroManager;
	delete m_pdlgSearch;
	delete m_pdlgGotoLine;
	delete m_pdlgBookmark;
/*	delete m_pdlgDebugBreakPoints;
	delete m_pdlgDebugCallStack;
	delete m_pdlgDebugImmediate;
	delete m_pdlgDebugRunningDocuments;
	delete m_pdlgDebugThreads;
	delete m_pdlgDebugVariables;*/
	if(m_pApplication != 0)
		m_pApplication->Release();
	if(m_pDocuments != 0)
		m_pDocuments->Release();
	CAlphaApp::m_pInstance = 0;
}

/**
 *	w肵r[ɃhLg^CvKp
 *	@param iTab			^u
 *	@param strTypeName	Kp镶^CvB󕶎w肷Ɗgqɍ̂Kp
 */
void CAlphaApp::ApplyDocumentType(unsigned int iTab, const wstring& strTypeName /* = L"" */) {
	AssertValid();

	Manah::Windows::CWaitCursor	wc;
	CAlphaEditController*		pEditor = m_documents.GetDocument(iTab)->GetTextEditor();

	if(pEditor == 0)
		return;

	// CxgnhĂяo
	CAlphaView*		pView = pEditor->GetPrimaryView();
	const wstring	strDocTypeName = strTypeName.empty() ?
		m_documentTypes.GetByFileName(pView->GetDocument()->GetTitle()).strName : strTypeName;

	if(strDocTypeName.empty()
			|| strDocTypeName != pView->GetDocument()->m_strDocType) {
		DISPPARAMS		params;

		pView->Freeze();
		pView->GetLexer().Freeze();
		pView->GetLexer().Reset();
		params.cArgs = 2;
		params.cNamedArgs = 0;
		params.rgvarg = new VARIANTARG[2];
		params.rgdispidNamedArgs = 0;
		params.rgvarg[1].vt = VT_BSTR;
		params.rgvarg[1].bstrVal = ::SysAllocString(strDocTypeName.c_str());
		params.rgvarg[0].vt = VT_DISPATCH;
		pEditor->GetAutomation(*this, IID_ITextProcessor, &params.rgvarg[0].pdispVal);
		m_pEventHandlerScript->Invoke(OLESTR("OnApplyDocumentType"), &params);
		::SysFreeString(params.rgvarg[1].bstrVal);
		params.rgvarg[0].pdispVal->Release();
		delete[] params.rgvarg;
		pView->GetLexer().Unfreeze();
		pView->GetDocument()->m_strDocType = strDocTypeName;
		pView->Unfreeze();
	}
	_UpdateStatusBar();
}

LRESULT CALLBACK CAlphaApp::AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	if(CAlphaApp::m_pInstance != 0)
		return CAlphaApp::m_pInstance->DispatchEvent(hWnd, message, wParam, lParam);
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

LRESULT	CAlphaApp::DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_ACTIVATE:
//		if(wParam != WA_INACTIVE && !m_vecDocuments.empty() && m_iActiveTab != -1)
//			::SetFocus(GetActiveTab()->GetWindow());
		return 0L;
//	case WM_ACTIVATEAPP:
//		if(toBoolean(wParam) && m_pMainWindow != 0)
//			m_pMainWindow->SetFocus();
//		return 0L;
	case WM_COMMAND:
		return OnCommand(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
	case WM_CLOSE:
		OnClose();
		return 0;
	case WM_COPYDATA:
		OnCopyData(reinterpret_cast<HWND>(wParam), reinterpret_cast<PCOPYDATASTRUCT>(lParam));
		break;
	case WM_CREATE:
		break;
	case WM_CREATENEWBUFFER:
		OnFileNew(wParam, static_cast<BreakType>(lParam));
		return true;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_DRAWITEM:
		OnDrawItem(wParam, reinterpret_cast<LPDRAWITEMSTRUCT>(lParam));
		break;
	case WM_DROPFILES:
		OnDropFiles(reinterpret_cast<HDROP>(wParam));
		break;
	case WM_ENTERMENULOOP:
		OnEnterMenuLoop(toBoolean(wParam));
		break;
	case WM_ENDSCRIPTMACRO:
		if(IDocumentContainer* pDocument = m_documents.GetActiveDocument()) {
			pDocument->RefreshWindow();
			::EnableWindow(pDocument->GetWindow(), true);	// [ (ScriptMacroManager.cpp  _InputBlocker Q)
			::SetFocus(pDocument->GetWindow());
		}
		break;
	case WM_EVENTHANDLER:
		m_pEventHandlerScript->Invoke(
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->first,
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->second);
	case WM_EXITMENULOOP:
		OnExitMenuLoop(toBoolean(wParam));
		break;
	case WM_INITMENU:
		OnInitMenu(reinterpret_cast<HMENU>(wParam));
		break;
	case WM_INITMENUPOPUP:
		OnInitMenuPopup(reinterpret_cast<HMENU>(wParam), LOWORD(lParam), toBoolean(HIWORD(lParam)));
		break;
	case WM_KEYDOWN:
		if(OnKeyDown(wParam, lParam))
			return false;
		break;
//	case WM_KILLFOCUS:
//		// r[ɓ]
//		if(!m_vecDocuments.empty())
//			return ::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
//		return 0L;
	case WM_MEASUREITEM:
		OnMeasureItem(wParam, reinterpret_cast<LPMEASUREITEMSTRUCT>(lParam));
		break;
	case WM_MENUCHAR: {
		CMenu*	pActivePopup = new CMenu(reinterpret_cast<HMENU>(lParam));
		LRESULT	res = OnMenuChar(LOWORD(wParam), HIWORD(wParam), pActivePopup);
//		res = pActivePopup->ExecuteMenuChar(LOWORD(wParam), HIWORD(wParam));
		delete pActivePopup;
		return res;
	}
	case WM_MENUSELECT:
		OnMenuSelect(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HMENU>(lParam));
		break;
	case WM_MOUSEMOVE: {
		POINT	pt = {LOWORD(lParam), HIWORD(lParam)};
		OnMouseMove(wParam, pt);
		return 0L;
	}
	case WM_NOTIFY:
		OnNotify(wParam, reinterpret_cast<LPNMHDR>(lParam));
		break;
	case WM_SETCURSOR:
		if(OnSetCursor(reinterpret_cast<HWND>(wParam),
				static_cast<UINT>(LOWORD(lParam)), static_cast<UINT>(HIWORD(lParam))))
			return false;
		break;
	case WM_SETFOCUS:
		// m_iActiveView 悤ƂĂr[w\
		if(m_documents.GetCount() != 0 && m_documents.GetActiveDocumentIndex() != -1
				&& reinterpret_cast<HWND>(wParam) != m_documents.GetActiveDocument()->GetWindow())
			::SendMessage(m_documents.GetActiveDocument()->GetWindow(), message, wParam, lParam);
		return 0L;
	case WM_SIZE:
		OnSize(wParam, LOWORD(lParam), HIWORD(lParam));
		break;
	case WM_SYSCHAR:
		if(OnSysChar(wParam, lParam))
			return true;
		break;
	case WM_SYSKEYDOWN:
		if(OnSysKeyDown(wParam, lParam))
			return true;
		break;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	}
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 *	I[g[VpC^[tFCXIuWFNgԂ
 *	@param ppApplication	[out] AvP[V (KvȂ null ł悢)
 *	@param ppDocuments		[out] RNV (KvȂ null ł悢)
 */
HRESULT CAlphaApp::GetAutomation(
		Alpha::Ambient::CApplication** ppApplication, Alpha::Ambient::CDocuments** ppDocuments) const {
	AssertValid();

	CAlphaApp*	pThis = const_cast<CAlphaApp*>(this);

	if(ppApplication != 0)	*ppApplication = 0;
	if(ppDocuments != 0)	*ppDocuments = 0;

	if(ppApplication != 0) {
		if(m_pApplication == 0) {
			pThis->m_pApplication = new Alpha::Ambient::CApplication(*pThis);
			if(m_pApplication == 0)
				return E_OUTOFMEMORY;
			pThis->m_pApplication->AddRef();
		}
		*ppApplication = m_pApplication;
		(*ppApplication)->AddRef();
	}
	if(ppDocuments != 0) {
		if(m_pDocuments == 0) {
			pThis->m_pDocuments = new Alpha::Ambient::CDocuments(*pThis);
			if(m_pDocuments == 0)
				return E_OUTOFMEMORY;
			pThis->m_pDocuments->AddRef();
		}
		*ppDocuments = m_pDocuments;
		(*ppDocuments)->AddRef();
	}
	return S_OK;
}

/**
 *	R[hy[W̖OԂBR[hy[WȂ null
 *	@param cp	R[hy[W
 */
const wchar_t* CAlphaApp::GetCodePageName(CodePage cp) {
	static map<CodePage, const wchar_t*>	names;

	if(names.empty()) {
		names[37] = L"č/Ji_ (IBM EBCDIC)";
		names[437] = L"č (ibm-437)";
		names[500] = L"C^[iVi (IBM EBCDIC)";
		names[708] = L"ArA (ASMO)";
		names[709] = L"ArA (ASMO 449+, BCON V4)";	// [*]
		names[710] = L"ArA (Transparent Arabic)";	// [*]
		names[720] = L"ArA (Transparent ASMO)";
		names[737] = L"MV (437G, ibm-737)";
		names[775] = L"og (ibm-775)";
		names[850] = L"[bp (ibm-850)";
		names[852] = L"[bp (ibm-852)";
		names[855] = L"L (ibm-855)";
		names[857] = L"gR (ibm-857)";
		names[858] = L"ꃉe I + [bp (ibm-858)";
		names[860] = L"|gK (ibm-860)";
		names[861] = L"ACXh (ibm-861)";
		names[862] = L"wuC (ibm-862)";
		names[863] = L"Ji_/tX (ibm-863)";
		names[864] = L"ArA (ibm-864)";
		names[865] = L"k (ibm-865)";
		names[866] = L"VA (ibm-866)";
		names[869] = L"MV (ibm-869)";
		names[870] = L"}`K/ROECE (e-2, IBM EBCDIC)";
		names[874] = L"^C (ibm-874)";
		names[875] = L"MV (IBM EBCDIC)";
		names[932] = L"{ (Vtg JIS, windows-932)";
		names[936] = L"ȑ̎ (GBK, windows-936)";
		names[949] = L"؍ (windows-949)";
		names[950] = L"ɑ̎ (Big5, windows-950)";
		names[1026] = L"gR (IBM EBCDIC)";
		names[1047] = L"e-1/Open System (IBM EBCDIC)";
		names[1140] = L"č/Ji_ (37 + [, IBM EBCDIC)";
		names[1141] = L"hCc (20273 + [, IBM EBCDIC)";
		names[1142] = L"f}[N/mEF[ (20277 + [, IBM EBCDIC)";
		names[1143] = L"tBh/XEF[f (20278 + [, IBM EBCDIC)";
		names[1144] = L"C^A (20280 + [, IBM EBCDIC)";
		names[1145] = L"e AJ/XyC (20284 + [, IBM EBCDIC)";
		names[1146] = L"p (20285 + [, IBM EBCDIC)";
		names[1147] = L"tX (20297 + [, IBM EBCDIC)";
		names[1148] = L"C^[iVi (500 + [, IBM EBCDIC)";
		names[1149] = L"ACXh (20871 + [, IBM EBCDIC)";
		names[1200] = L"Unicode (UTF-16)";
		names[1201] = L"Unicode (UTF-16 big endian)";
		names[1250] = L"[bp (windows-1250)";
		names[1251] = L"L (windows-1251)";
		names[1252] = L"[bp (windows-1252)";
		names[1253] = L"MV (windows-1253)";
		names[1254] = L"gR (windows-1254)";
		names[1255] = L"wuC (windows-1255)";
		names[1256] = L"ArA (windows-1256)";
		names[1257] = L"og (windows-1257)";
		names[1258] = L"xgi (windows-1258)";
		names[1361] = L"؍ (Johab)";
		names[10000] = L"[} (Macintosh)";
		names[10001] = L"{ (Macintosh)";
		names[10002] = L"ɑ̎ (Big5, Macintosh)";
		names[10003] = L"؍ (Macintosh)";
		names[10004] = L"ArA (Macintosh)";
		names[10005] = L"wuC (Macintosh)";
		names[10006] = L"MV I (Macintosh)";
		names[10007] = L"L (Macintosh)";
		names[10008] = L"ȑ̎ (GB2312, Macintosh)";
		names[10010] = L"[}jA (Macintosh)";
		names[10017] = L"ENCi (Macintosh)";
		names[10021] = L"^C (Macintosh)";
		names[10029] = L"[bp (Macintosh)";
		names[10079] = L"ACXh (Macintosh)";
		names[10081] = L"gR (Macintosh)";
		names[10082] = L"NA`A (Macintosh)";
		names[12000] = L"Unicode (UTF-32)";
		names[12001] = L"Unicode (UTF-32 big endian)";
		names[20000] = L"p (CNS)";
		names[20001] = L"p (TCA)";
		names[20002] = L"p (Eten)";
		names[20003] = L"p (IBM5550)";
		names[20004] = L"p (TeleText)";
		names[20005] = L"p (Wang)";
		names[20105] = L"IRV C^[iVi At@xbg No.5 (IA5)";
		names[20106] = L"hCc (IA5)";
		names[20107] = L"XEF[f (IA5)";
		names[20108] = L"mEF[ (IA5)";
		names[20127] = L"US-ASCII";
		names[20261] = L"T.61";
		names[20269] = L"Non-Spacing Accent (ISO 6937)";
		names[20273] = L"hCc (IBM EBCDIC)";
		names[20277] = L"f}[N/mEF[ (IBM EBCDIC)";
		names[20278] = L"tBh/XEF[f (IBM EBCDIC)";
		names[20280] = L"C^A (IBM EBCDIC)";
		names[20284] = L"e AJ/XyC (IBM EBCDIC)";
		names[20285] = L"p (IBM EBCDIC)";
		names[20290] = L"{ (J^Jig, IBM EBCDIC)";
		names[20297] = L"tX (IBM EBCDIC)";
		names[20420] = L"ArA (IBM EBCDIC)";
		names[20423] = L"MV (IBM EBCDIC)";
		names[20424] = L"wuC (IBM EBCDIC)";
		names[20833] = L"؍g (IBM EBCDIC)";
		names[20838] = L"^C (IBM EBCDIC)";
		names[20866] = L"VA (KOI8)";
		names[20871] = L"ACXh (IBM EBCDIC)";
		names[20880] = L"L (VA, IBM EBCDIC)";
		names[20905] = L"gR (IBM EBCDIC)";
		names[20924] = L"e-1/Open System (1047 + [, IBM EBCDIC)";
		names[20932] = L"{ (JIS X 0208-1990 & 0212-1990, windows-20932)";
		names[20936] = L"ȑ̎ (GB2312)";
		names[21025] = L"L (ZrAAuKA, IBM EBCDIC)";
		names[21027] = L"Ext Alpha Lowercase";
		names[21866] = L"ENCi (KOI8-U)";
		names[28591] = L"[bp (ISO-8859-1)";
		names[28592] = L"[bp (ISO-8859-2)";
		names[28593] = L"새[bp (ISO-8859-3)";
		names[28594] = L"og (ISO-8859-4)";
		names[28595] = L"L (ISO-8859-5)";
		names[28596] = L"ArA (ISO-8859-6)";
		names[28597] = L"MV (ISO-8859-7)";
		names[28598] = L"wuC (ISO-8859-8, o)";
		names[28599] = L"gR (ISO-8859-9)";
		names[28600] = L"k (ISO-8859-10)";	// [Ǝ]
		names[28601] = L"^C (ISO-8859-11)";	// [Ǝ]
		names[28603] = L"og (ISO-8859-13)";	// [Ǝ]
		names[28604] = L"Pg (ISO-8859-14)";	// [Ǝ]
		names[28605] = L"[bp (ISO-8859-15)";
		names[28606] = L"[bp (ISO-8859-16)";	// [Ǝ]
		names[29001] = L"[bp 3";	// [*]
		names[38598] = L"wuC (ISO-8859-8, _)";
		names[50001] = L"I";	// [*]
		names[50220] = L"{ (ISO-2022-JP, pJ^JiȂ, windows-50220)";
		names[50221] = L"{ (ISO-2022-JP, pJ^Ji, windows-50221)";
		names[50222] = L"{ (ISO-2022-JP, JIS X 0201-1989, windows-50222)";
		names[50225] = L"؍ (ISO-2022-KR)";
		names[50227] = L"ȑ̎ (ISO-2022-CN)";
		names[50229] = L"ɑ̎ (ISO-2022-CN)";
		names[50930] = L"{ (J^Jig)";	// [*]
		names[50931] = L"{ + č/Ji_";	// [*]
		names[50932] = L"{ (I)";	// [*]
		names[50933] = L"؍ + ؍g";	// [*]
		names[50935] = L"ȑ̎ + ȑ̎g";	// [*]
		names[50936] = L"ȑ̎";	// [*]
		names[50937] = L"ɑ̎ + č/Ji_";	// [*]
		names[50939] = L"{ + {ꃉeg";	// [*]
		names[50949] = L"؍ (I)";	// [*]
		names[51932] = L"{ (EUC, windows-51932)";	// [*]
		names[51936] = L"ȑ̎ (EUC, windows-51936)";	// [*]
		names[51949] = L"؍ (EUC, windows-51949)";
		names[51950] = L"ɑ̎ (EUC, windows-51950)";	// [*]
		names[52936] = L"ȑ̎ (HZ-GB2312)";
		names[54936] = L"ȑ̎ (GB18030)";	// [WinXP ̂]
		names[57002] = L"foiK (ISCII)";
		names[57003] = L"xK (ISCII)";
		names[57004] = L"^~[ (ISCII)";
		names[57005] = L"eO (ISCII)";
		names[57006] = L"AbT (ISCII)";
		names[57007] = L"I[ (ISCII)";
		names[57008] = L"Ji_ (ISCII)";
		names[57009] = L"} (ISCII)";
		names[57010] = L"OW[g (ISCII)";
		names[57011] = L"pWu (ISCII, OL[)";
		names[65000] = L"Unicode (UTF-7)";
		names[65001] = L"Unicode (UTF-8)";
		names[CPEX_AUTODETECT_SYSTEMLANG] = L"I (VXě)";
		names[CPEX_AUTODETECT_USERLANG] = L"I ([Ǔ)";
		names[CPEX_UNICODE_AUTODETECT] = L"Unicode (I)";
		names[CPEX_UNICODE_UTF5] = L"Unicode (UTF-5)";
		names[CPEX_ARMENIAN_AUTODETECT] = L"AjA (I)";
		names[CPEX_ARMENIAN_ARMSCII7] = L"AjA (ARMSCII-7)";
		names[CPEX_ARMENIAN_ARMSCII8] = L"AjA (ARMSCII-8)";
		names[CPEX_ARMENIAN_ARMSCII8A] = L"AjA (ARMSCII-8A)";
		names[CPEX_VIETNAMESE_AUTODETECT] = L"xgi (I)";
		names[CPEX_VIETNAMESE_TCVN] = L"xgi (TCVN)";
		names[CPEX_VIETNAMESE_VISCII] = L"xgi (VISCII)";
		names[CPEX_VIETNAMESE_VPS] = L"xgi (VPS)";
		names[CPEX_JAPANESE_ISO2022JP] = L"{ (ISO-2022-JP)";
		names[CPEX_JAPANESE_SHIFTJIS] = L"{ (Vtg JIS)";
		names[CPEX_JAPANESE_ISO2022JP1] = L"{ (ISO-2022-JP-1)";
		names[CPEX_JAPANESE_ISO2022JP2] = L"{ (ISO-2022-JP-2)";
		names[CPEX_JAPANESE_EUC] = L"{ (EUC)";
		names[CPEX_JAPANESE_ISO2022JP2004] = L"{ (ISO-2022-JP-2004)";
		names[CPEX_JAPANESE_SHIFTJIS2004] = L"{ (Shift_JIS-2004)";
		names[CPEX_JAPANESE_EUCJIS2004] = L"{ (EUC-JIS-2004)";
		names[CPEX_MULTILINGUAL_ISO2022] = L"}`K (ISO-2022)";
		names[CPEX_UNCATEGORIZED_BINARY] = L"oCi";
		names[CPEX_THAI_TIS620] = L"^C (TIS 620-2533:1990)";
		names[CPEX_LAO_MULELAO] = L"I (MuleLao-1)";
		names[CPEX_LAO_CP1133] = L"I (ibm-1133)";
	}

	const map<CodePage, const wchar_t*>::const_iterator	it = names.find(cp);
	return (it != names.end()) ? it->second : 0;
}

/**
 *	R}h̃j[LvVԂ
 *	@param id	R}h ID
 */
const wchar_t* CAlphaApp::_GetMenuLabel(CommandId id) const {

	static wchar_t	wsz[MAX_PATH + 8];
	wchar_t*		psz = 0;

	if(id >= CMD_EDIT_PLUGINLIST_START && id < CMD_EDIT_PLUGINLIST_END) {
		if(m_pScriptMacroManager->GetCount() != 0) { 
			wcscpy(wsz, m_pScriptMacroManager->GetName(id - CMD_EDIT_PLUGINLIST_START).c_str());
			wcscat(wsz, L"\t");
			wcscat(wsz, m_keyboardMap.GetKeyString(id, m_bUseShortKeyNames).c_str());
		} else
			wcscpy(wsz, LoadString(MSG_FAILEDTOLOAD).c_str());
		return wsz;
	} else if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {
		const TMRU&	file = m_pMRUManager->GetFileInfoAt(id - CMD_FILE_MRULIST_START);
		swprintf(wsz, L"&%X  %s", id - CMD_FILE_MRULIST_START, file.strFileName.c_str());
		return wsz;
	} else if(id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END) {
		assert(static_cast<size_t>(id - CMD_VIEW_BUFFERLIST_START) < m_documents.GetCount());
		if(id - CMD_VIEW_BUFFERLIST_START < 0x10)
			swprintf(wsz, L"&%X  %s", id - CMD_VIEW_BUFFERLIST_START,
				m_documents.GetDocument(id - CMD_VIEW_BUFFERLIST_START)->GetTitle().c_str());
		else
			wcscpy(wsz, m_documents.GetDocument(id - CMD_VIEW_BUFFERLIST_START)->GetTitle().c_str());
		return wsz;
	}
	LoadString(id, wsz, MAX_PATH + 8);
	psz = wcschr(wsz, L'\n');
	if(psz != 0)
		*psz = 0;
	wcscat(wsz, L"\t");
	wcscat(wsz, m_keyboardMap.GetKeyString(id, m_bUseShortKeyNames).c_str());
	return wsz;
}

///	@see	CWinApp::GetModelessDialogList
void CAlphaApp::GetModelessDialogList(list<HWND>& listDlgs) const {
	listDlgs.clear();

	// [hX_CAO炱ɒǉ
	listDlgs.push_back(m_pdlgSearch->GetSafeHwnd());
	listDlgs.push_back(m_pdlgBookmark->GetSafeHwnd());
	listDlgs.push_back(m_pdlgGotoLine->GetSafeHwnd());
/*	listDlgs.push_back(m_pdlgDebugCallStack->GetSafeHwnd());
	listDlgs.push_back(m_pdlgDebugImmediate->GetSafeHwnd());
	listDlgs.push_back(m_pdlgDebugRunningDocuments->GetSafeHwnd());
	listDlgs.push_back(m_pdlgDebugThreads->GetSafeHwnd());
	listDlgs.push_back(m_pdlgDebugVariables->GetSafeHwnd());*/
}

/**
 *	XNvgt@CɑΉtĂ錾GW CLSID Ԃ
 *	@param pwszFileName	XNvgt@C
 *	@param clsid		[out] GW CLSIDBȂꍇ CLSID_NULL
 */
void CAlphaApp::GetScriptLanguageByFileName(const wchar_t* pwszFileName, CLSID& clsid) const {
	assert(pwszFileName != 0);
	clsid = CLSID_NULL;

	static map<wstring, CLSID>	registeredEngines;
	static const CATID	CATID_ActiveScript = {
							0xf0b7a1a1, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	static const CATID	CATID_ActiveScriptParse = {
							0xf0b7a1a2, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	const wchar_t*		pwszExtension = ::PathFindExtensionW(pwszFileName);

	if(*pwszExtension == 0)
		return;
	++pwszExtension;
	if(registeredEngines.empty()) {
		// R|[lgJeSXNvgGW񋓂AINI gqE
		CComPtr<ICatInformation>	pCatInfo;

		if(SUCCEEDED(pCatInfo.CreateInstance(CLSID_StdComponentCategoriesMgr))) {
			CComPtr<IEnumCLSID>	pClsidEnumerator;

			if(SUCCEEDED(pCatInfo->EnumClassesOfCategories(
					1, const_cast<CATID*>(&CATID_ActiveScript),
					1, const_cast<CATID*>(&CATID_ActiveScriptParse), &pClsidEnumerator))) {
				CLSID		clsid;
				OLECHAR*	pwszProgId;

				for(pClsidEnumerator->Reset(); pClsidEnumerator->Next(1, &clsid, 0) == S_OK; ) {
					if(SUCCEEDED(::ProgIDFromCLSID(clsid, &pwszProgId))) {
						set<wstring>	extensions;

						if(wchar_t* pwszFirstPeriod = wcschr(pwszProgId, L'.'))	// ProgID ꖼɕϊ
							*pwszFirstPeriod = 0;
						const_cast<CAlphaApp*>(this)->_GetProfileSet(INI_SECTION_SCRIPTENGINES, pwszProgId, extensions);
						for(set<wstring>::const_iterator it = extensions.begin(); it != extensions.end(); ++it)
							registeredEngines.insert(make_pair(*it, clsid));
						::CoTaskMemFree(pwszProgId);
					}
				}
			}
		}
	}
	map<wstring, CLSID>::const_iterator	it = registeredEngines.find(pwszExtension);
	if(it != registeredEngines.end())
		clsid = it->second;
}

/**
 *	t@CĴɎsƂ̏
 *	@param ss	G[e
 *	@return		ʓIɃG[łꍇ (CAlphaApp::OpenFile ̖߂lƓ)
 */
bool CAlphaApp::_HandleFileOpenError(Ascension::StreamStatus ss) {
	AssertValid();

	const IDocumentContainer*	pActiveDocument = m_documents.GetActiveDocument();
	assert(pActiveDocument != 0);

	if(ss == SS_OK) {
		_ResetBufferBarIcons();
		return true;
	} else if(ss == SS_READ_READONLY) {
		MessageBox(MSG_OPENEDASREADONLY,
			MB_ICONEXCLAMATION, __MARGS__ % pActiveDocument->GetFilePath());
		_ResetBufferBarIcons();
		return true;
	} else if(ss == SS_READ_UNKNOWNCHARCODE) {
		MessageBox(MSG_FAILEDTODETECTCODEPAGE,
			MB_ICONEXCLAMATION, __MARGS__ % pActiveDocument->GetFilePath());
		_ResetBufferBarIcons();
		return true;
	} else if(ss == SS_READ_ILLEGALCHAR) {
		MessageBox(MSG_FOUNDILLEGALCHARACTER,
			MB_ICONEXCLAMATION, __MARGS__ % pActiveDocument->GetFilePath());
		_ResetBufferBarIcons();
		return true;
	} else {
		DWORD	dwMesId;
		switch(ss) {
		case SS_ACCESSDENIED:			dwMesId = MSG_FILEACCESSDENIED;	break;
		case SS_ILLEGALCODEPAGE:		dwMesId = MSG_ILLEGALCODEPAGE;	break;
		case SS_UNKNOWNERROR:			dwMesId = MSG_UNKNOWNERROR;		break;
		case SS_READ_HUGEFILE:			dwMesId = MSG_TOOLARGEFILE;		break;
		case SS_READ_NOEXISTS:			dwMesId = MSG_FILENOTFOUND;		break;
		}
		MessageBox(dwMesId, MB_ICONHAND, __MARGS__ % pActiveDocument->GetFilePath());
		OnFileClose(false);
		return false;
	}
}

///	L[
bool CAlphaApp::_HandleKeyDown(VirtualKey key, KeyModifier modifiers) {
	if(key == VK_MENU && modifiers == 0) {
		m_pMainWindow->SendMessage(WM_INITMENU, reinterpret_cast<WPARAM>(m_pMenu->GetSafeHmenu()), 0);
		return true;
	}
	if(key == VK_CONTROL || key == VK_MENU || key == VK_SHIFT)
		return false;

	if(m_2Stroke1stKey == VK_NULL) {	// 1Xg[N
		const CommandId	id = m_keyboardMap.GetCommandID(key, modifiers);
		if(id == 0)
			return false;
		else if(id == CMD_SPECIAL_WAITFOR2NDKEYS) {
			m_2Stroke1stKey = key;
			m_2Stroke1stModifiers = modifiers;
			const wstring	str = LoadString(MSG_WAITINGFOR2NDKEYS,
				__MARGS__ % CKeyboardMap::GetStrokeString(key, modifiers, m_bUseShortKeyNames));
			m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
		} else
			OnCommand(id, 0, 0);
	} else {	// 2Xg[N
		const CommandId	id = m_keyboardMap.GetCommandID(m_2Stroke1stKey, m_2Stroke1stModifiers, key, modifiers);
		if(id != 0) {
			m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
			OnCommand(id, 0, 0);
		} else {
			const wstring	str = LoadString(MSG_ILLEGAL2STROKECOMBINATION,
				__MARGS__ % CKeyboardMap::GetStrokeString(m_2Stroke1stKey,
				m_2Stroke1stModifiers, key, modifiers, m_bUseShortKeyNames));
			::MessageBeep(MB_OK);
			m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
		}
		m_2Stroke1stKey = VK_NULL;
	}
	return true;
}

///	@see	CWinApp::InitApplication
bool CAlphaApp::InitApplication(HINSTANCE hInstance) {
	AssertValid();

	WNDCLASSEXW	windowClass;

	windowClass.cbSize			= sizeof(WNDCLASSEXW);
	windowClass.style			= CS_DBLCLKS/* | CS_HREDRAW | CS_VREDRAW | CS_DROPSHADOW*/;
	windowClass.lpfnWndProc		= reinterpret_cast<WNDPROC>(CAlphaApp::AppWndProc);
	windowClass.cbClsExtra		= 0;
	windowClass.cbWndExtra		= 0;
	windowClass.hInstance		= hInstance;
	windowClass.hIcon			= ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	windowClass.hIconSm			= ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	windowClass.hCursor			= ::LoadCursor(0, IDC_ARROW);
	windowClass.hbrBackground	= ::GetSysColorBrush(COLOR_BTNFACE);
	windowClass.lpszClassName	= IDS_APPNAME;
	windowClass.lpszMenuName	= MAKEINTRESOURCE(IDR_MENU);

	return toBoolean(::RegisterClassEx(&windowClass));
}

/**
 *	CX^X̏
 *	@see	CWinApp::InitInstance
 */
bool CAlphaApp::InitInstance() {
	AssertValid();

	static CWindow	wndApp;

	wndApp.Create(false, IDS_APPNAME, L"", /*WS_VISIBLE |*/ WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		reinterpret_cast<HWND>(::GetModuleHandle(0)), 0, 0);

	if(!wndApp.IsWindow())
		return false;
	m_pMainWindow = &wndApp;

	// ʐݒ̓ǂݍ
	_LoadINISettings();

	// XNvgɂݒ
	wchar_t									wszScriptName[MAX_PATH];
	wchar_t*								pwszFileName = 0;
	CComPtr<Alpha::Ambient::CApplication>	pApplication;

	GetAutomation(&pApplication, 0);
	::GetModuleFileNameW(0, wszScriptName, MAX_PATH);
	pwszFileName = ::PathFindFileNameW(wszScriptName);
	wcscpy(pwszFileName, IDS_MACRO_DIRECTORY_NAME IDS_EVENTSCRIPTFILENAME);
	m_pEventHandlerScript = new CEventHandlerScript(m_pMainWindow->GetSafeHwnd(), *this);
	m_pEventHandlerScript->LoadScript(wszScriptName);

	// MRU Xg̍쐬
	m_pMRUManager = new CMRUManager(GetProfileInt(L"File", L"mruLimit", 8), CMD_FILE_MRULIST_START, true);
	unsigned int	iMRU = 0;
	wchar_t			szKeyName[30];
	stack<TMRU>		stkFiles;
	while(true) {
		TMRU	file;
		swprintf(szKeyName, L"strPath(%u)", iMRU);
		file.strFileName = GetProfileString(L"MRU", szKeyName, L"");
		if(file.strFileName.empty())
			break;
		swprintf(szKeyName, L"nCodePage(%u)", iMRU);
		file.nCodePage = GetProfileInt(L"MRU", szKeyName, CPEX_AUTODETECT_USERLANG);
		stkFiles.push(file);
		++iMRU;
	}
	while(!stkFiles.empty()) {
		m_pMRUManager->Add(stkFiles.top().strFileName, stkFiles.top().nCodePage);
		stkFiles.pop();
	}

	// vOC̃[h
	OnEditReloadPlugin();

	// o[̍쐬
	const RECT	rect = {CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT};
	REBARINFO	rbi = {sizeof(REBARINFO), 0, 0};
	m_rebar.CreateEx(WS_EX_TOOLWINDOW,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN
		| RBS_BANDBORDERS | RBS_VARHEIGHT | CCS_NODIVIDER,
		rect, wndApp, 0);
	m_rebar.SetBarInfo(rbi);

	// c[o[̍쐬
	_SetupToolbar();

	// Xe[^Xo[̍쐬
	m_statusBar.Create(
		WS_CHILD | WS_VISIBLE | CCS_BOTTOM | CCS_NODIVIDER | SBARS_SIZEGRIP | SBT_TOOLTIPS,
		rect, m_pMainWindow->GetSafeHwnd(), IDC_STATUSBAR);
//	m_statusBar.SetMinHeight(4);

	// AEgvbgEBhE̍쐬
	m_wndOutput.Create(m_pMainWindow);
	m_wndOutput.WriteLine(OTT_GENERAL, IDS_APPFULLVERSION);

	// c[_CAO̍쐬
	m_pdlgSearch->Create(m_hInstance, IDD_DLG_SEARCH, m_pMainWindow->GetSafeHwnd());
	m_pdlgSearch->DoModeless(false);
	if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1))) {
		m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_FINDWHAT,
			WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
		m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_REPLACEWITH,
			WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
	}
	m_pdlgGotoLine->Create(m_hInstance, IDD_DLG_GOTOLINE, m_pMainWindow->GetSafeHwnd());
	m_pdlgBookmark->Create(m_hInstance, IDD_DLG_BOOKMARKS, m_pMainWindow->GetSafeHwnd());
//	m_pdlgDebugBreakPoints->Create(m_hInstance, IDD_DLG_DEBUGBREAKPOINTS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugCallStack->Create(m_hInstance, IDD_DLG_DEBUGCALLSTACK, m_pMainWindow->m_hWnd);
//	m_pdlgDebugImmediate->Create(m_hInstance, IDD_DLG_DEBUGIMMEDIATE, m_pMainWindow->m_hWnd);
//	m_pdlgDebugRunningDocuments->Create(m_hInstance, IDD_DLG_DEBUGACTIVEDOCUMENTS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugThreads->Create(m_hInstance, IDD_DLG_DEBUGTHREADS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugVariables->Create(m_hInstance, IDD_DLG_DEBUGVARIABLES, m_pMainWindow->m_hWnd);

	// ̑̏
	wndApp.DragAcceptFiles(true);
	wndApp.SetTimer(ID_TIMER_QUERYCOMMAND, 200, 0);

	wndApp.SetWindowPos(0, 0, 0, 760, 560, SWP_NOMOVE | SWP_NOZORDER);
	wndApp.CenterWindow();

	// R}hC̉
	vector<wstring>	arguments;
	GetCommandLineArguments(arguments);

	// OnApplicationInitialized Cxg
	DISPPARAMS		params;
	VARIANTARG		arg0;

	arg0.vt = VT_DISPATCH;
	arg0.pdispVal = new Ambient::CArguments(arguments);
	arg0.pdispVal->AddRef();
	params.cArgs = 1;
	params.rgvarg = &arg0;
	params.cNamedArgs = 0;
	params.rgdispidNamedArgs = 0;
	m_pEventHandlerScript->Invoke(OLESTR("OnApplicationInitialized"), &params);
	arg0.pdispVal->Release();

	// ̃r[̍쐬
	m_documents.SetEventListener(this);
	OnFileNew();

	_SetupMenus();
	if(!toBoolean(GetProfileInt(L"View", L"visibleToolbar", true)))
		m_rebar.ShowBand(m_rebar.IdToIndex(IDC_TOOLBAR), false);
	if(!toBoolean(GetProfileInt(L"View", L"visibleStatusBar", true)))
		m_statusBar.ShowWindow(SW_HIDE);
	if(!toBoolean(GetProfileInt(L"View", L"visibleBufferBar", true)))
		m_rebar.ShowBand(m_rebar.IdToIndex(IDC_BUFFERBAR), false);
	wndApp.ShowWindow(SW_SHOW);

	// R}hC^ꂽt@CJ
	ParseCommandLine(arguments);

	// ...
	m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);

	return true;
}

///	INI t@Cݒǂݍ
void CAlphaApp::_LoadINISettings() {
	AssertValid();

	// \Ɋւݒ
	LOGFONTW	lf;
	if(!GetProfileStruct(L"View", L"oFont.pLogfont", &lf, sizeof(LOGFONTW))) {
		ZeroMemory(&lf, sizeof(LOGFONTW));
		lf.lfCharSet = ANSI_CHARSET;
		lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
		lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		lf.lfQuality = DEFAULT_QUALITY;
		lf.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
		wcscpy(lf.lfFaceName, L"FixedSys");
	}
	SetFont(lf);
	m_nOutputWndHeight = 0;//GetProfileInt(L"View", L"nOutputWindowHeight", 98);

	// Migemo DLL pX
	const wchar_t*	pwszMigemoPath = GetProfileString(L"Find", L"migemoRuntimePath", L"");
	if(pwszMigemoPath[0] != 0) {
		wchar_t*	pwsz = new wchar_t[wcslen(pwszMigemoPath) + 1];
		wcscpy(pwsz, pwszMigemoPath);
		for(size_t i = 0; ; ++i) {
			if(pwsz[i] == 0)
				break;
			else if(pwsz[i] == L'/')
				pwsz[i] = L'\\';
		}
		CEditView::SetMigemoPath(pwsz, true);
	}

	// Migemo  pX
	pwszMigemoPath = GetProfileString(L"Find", L"migemoDictionaryPath", L"");
	if(pwszMigemoPath[0] != 0) {
		wchar_t*	pwsz = new wchar_t[wcslen(pwszMigemoPath) + 1];
		wcscpy(pwsz, pwszMigemoPath);
		for(size_t i = 0; ; ++i) {
			if(pwsz[i] == 0)
				break;
			else if(pwsz[i] == L'/')
				pwsz[i] = L'\\';
		}
		CEditView::SetMigemoPath(pwsz, false);
	}

	// ̗
	wchar_t	wszKeyName[30];
	wstring	strValue;
	list<wstring>	listFindWhats, listReplacesWiths;
	for(unsigned short iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		listFindWhats.push_back(strValue);
	}
	for(unsigned short iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		listReplacesWiths.push_back(strValue);
	}
	m_pdlgSearch->ClearHistory(false);
	m_pdlgSearch->ClearHistory(true);
	m_pdlgSearch->SetHistory(listFindWhats, listReplacesWiths);

	// ̑
	m_bUseShortKeyNames = toBoolean(GetProfileInt(L"Edit", L"useShortKeyNames", 0));
	m_bShowMessageBoxOnFind = toBoolean(GetProfileInt(L"Find", L"showMessageBox", 1));
	m_bInitializeFindTextFromEditor = toBoolean(GetProfileInt(L"Find", L"initializeFromEditor", 1));
}

/**
 *	L[ () 蓖
 *	@param strSchemeName	gpL[{[h}bvXL[̖OB
 *	󕶎w肷ƃAvP[VɌѕtĂL[蓖ăIuWFNgANZ[^e[uč\z
 */
void CAlphaApp::LoadKeyBinds(const wstring& strSchemeName) {
	AssertValid();

	if(!strSchemeName.empty()) {
		wchar_t	wszPathName[MAX_PATH];
		::GetModuleFileNameW(0, wszPathName, MAX_PATH);
		wcscpy(::PathFindFileNameW(wszPathName), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
		if(wcslen(wszPathName) + strSchemeName.length() + 4 >= MAX_PATH)
			return;
		wcscat(wszPathName, strSchemeName.c_str());
		wcscat(wszPathName, L".akm");
		m_keyboardMap.Load(wszPathName);
	}

	// j[̍č\z
	if(m_pMenu != 0)
		_SetupMenus();
}

/**
 *	bZ[We[u̕bZ[W{bNXɕ\
 *	@param dwID		bZ[Wʎq
 *	@param nType	_CAÕ^Cv (::MessageBox Ɠ)
 *	@param args		bZ[Ẅ
 *	@return			[U̕ԓ (::MessageBox Ɠ)
 */
int CAlphaApp::MessageBox(DWORD dwID, UINT nType, Manah::Windows::CMessageArguments& args /* = CMessageArguments() */) {
	AssertValid();
	assert(m_pMainWindow != 0);
	return m_pMainWindow->MessageBox(LoadString(dwID, args).c_str(), IDS_APPNAME, nType);
}

/**
 *	t@CeLXgGfB^ŐVr[ɊJÃr[ANeBuɂB
 *	܂AgqɉăhLg^CvKpB̃\bh̓t@CI[v
 *	ʂ_CAO\邱Ƃ
 *	@param strPathName	t@C̃pX
 *	@param nCodePage	t@C̃R[hy[WBȗƎ
 *	@param strDocType	Kp镶^CvBȗ󕶎̏ꍇ͊gq画
 *	@param bAddToMRU	Jt@Cŋߎgt@Cɒǉ邩
 *	@return				t@CJƂł true
 */
bool CAlphaApp::OpenFile(const wstring& strPathName, UINT nCodePage /* = EXTCP_AUTOSELECT */, bool bAddToMRU /* = true */) {
	AssertValid();

	wchar_t	wszPathName[MAX_PATH];

	// V[gJbg̉
	const wchar_t*	pwszExtension = ::PathFindExtensionW(strPathName.c_str());
	if(wcslen(pwszExtension) != 0 && (
			(::StrCmpIW(pwszExtension + 1, L"lnk") == 0)
			/*|| (::StrCmpIW(pwszExtension + 1, L"url") == 0)*/)) {
		CComPtr<IShellLink>		pShellLink;
		CComPtr<IPersistFile>	pFile;
		HRESULT					hr;

		try {
			if(FAILED(hr = pShellLink.CreateInstance(CLSID_ShellLink)))
				throw hr;
			if(FAILED(hr = pShellLink->QueryInterface(IID_IPersistFile, reinterpret_cast<void**>(&pFile))))
				throw hr;
			if(FAILED(hr = pFile->Load(strPathName.c_str(), STGM_READ)))
				throw hr;
			if(FAILED(hr = pShellLink->Resolve(0, SLR_ANY_MATCH | SLR_NO_UI)))
				throw hr;
			if(FAILED(hr = pShellLink->GetPath(wszPathName, MAX_PATH, 0, 0)))
				throw hr;
		} catch(HRESULT /*hr_*/) {
			MessageBox(MSG_FAILEDTORESOLVESHORTCUT, MB_ICONHAND, __MARGS__ % strPathName);
			return false;
		}
	} else
		wcscpy(wszPathName, strPathName.c_str());

	// (eLXgGfB^) ɊJĂ邩ׂ
	for(size_t i = 0; i < m_documents.GetCount(); ++i) {
		IDocumentContainer*	pDocument = m_documents.GetDocument(i);
		if(CAlphaEditController* pEditor = pDocument->GetTextEditor()) {
			if(::StrCmpIW(pEditor->GetFilePath().c_str(), wszPathName) == 0) {	// ł͕sS
				m_documents.SetActiveDocument(i);
				return true;
			}
		}
	}

	CAlphaEditController*	pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor();
	if(pActiveEditor == 0)
		return false;
	CAlphaDoc*				pActiveDoc = pActiveEditor->GetDocument();
	Ascension::FileOpenMode	fom;

	// bN
	switch(GetProfileInt(L"File", L"shareMode", 0)) {
	case 0:	fom = Ascension::FOM_DENYNONE;	break;
	case 1:	fom = Ascension::FOM_DENYWRITE;	break;
	case 2:	fom = Ascension::FOM_DENYREAD;	break;
	}

	if(pActiveDoc->IsModified()
			|| !pActiveDoc->GetPathName().empty()) {	// VReiŊJ
		OnFileNew(nCodePage);
		pActiveDoc = m_documents.GetActiveDocument()->GetTextEditor()->GetDocument();
	} else if(pActiveDoc->GetController()->IsSplit())	// ̃Reigꍇ͕
		pActiveDoc->GetController()->SplitView(0);

	if(!CEncoderFactory::GetInstance().IsCodePageForAutoDetection(nCodePage)) {
		try {
			pActiveDoc->SetCodePage(nCodePage);
		} catch(invalid_argument& /* e */) {
			if(IDNO == MessageBox(MSG_ILLEGALCODEPAGE, MB_YESNO | MB_ICONEXCLAMATION))
				return false;
			nCodePage = ::GetACP();
			pActiveDoc->SetCodePage(nCodePage);
		}
	}

	const wstring	str = LoadString(MSG_LOADINGFILE, __MARGS__ % wszPathName);
	CWaitCursor*	pwc = new CWaitCursor;
	m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
	m_pMainWindow->LockWindowUpdate();
	pActiveDoc->SetPathName(wszPathName);

	// ł̂Ńt@CJ
	const StreamStatus	ss = pActiveDoc->LoadDocument(wszPathName, fom, nCodePage);
	delete pwc;
	m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
	_UpdateStatusBar();
	m_pMainWindow->UnlockWindowUpdate();
	m_pMainWindow->ShowWindow(m_pMainWindow->IsWindowVisible() ? SW_SHOW : SW_RESTORE);
	m_documents.UpdateList();

	if(_HandleFileOpenError(ss)) {
		if(bAddToMRU) {
			m_pMRUManager->Add(pActiveDoc->GetPathName(), pActiveDoc->GetCodePage());
			m_pMenu->GetSubMenu(0).SetChildPopup(*m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);
		}
		return true;
	}
	return false;
}

/**
 *	R}hC͂ĎsBȈ͖
 *	@param arguments	eR}hCIvVBCWinApp::GetCommandLineArguments ̏o͂g
 *	@see				CWinApp::GetCommandLineArguments
 */
void CAlphaApp::ParseCommandLine(const vector<wstring>& arguments) {
	AssertValid();

	list<wstring>	paths;	// t@CpX̃Xg
	CodePage		cp = CPEX_AUTODETECT_USERLANG;
	unsigned long	iLine = 0;
	unsigned long	iChar = 0;
	bool			bReadOnly = false;

	for(vector<wstring>::size_type i = 0; i < arguments.size(); ++i) {
		const wstring& strArgument = arguments[i];
		if(strArgument.empty())
			continue;
		if(strArgument[0] == L'-') {	// IvV
			if(strArgument == L"-r")
				bReadOnly = true;
			else if(strArgument.compare(1, 2, L"cp:") == 0)
				cp = wcstoul(strArgument.c_str() + 3, 0, 0);
			else if(strArgument.compare(1, 5, L"line:") == 0)
				iLine = wcstoul(strArgument.c_str() + 6, 0, 0);
			else if(strArgument.compare(1, 5, L"char:") == 0)
				iChar = wcstoul(strArgument.c_str() + 6, 0, 0);
		} else	// t@CpX
			paths.push_back(strArgument);
	}

	// ԂɃt@CJ
	for(list<wstring>::const_iterator it = paths.begin(); it != paths.end(); ++it) {
		if(OpenFile(*it, cp))
			if(iLine != 0 || iChar != 0)
				m_documents.GetActiveDocument()->GetTextEditor()->GetActiveView()->SetSelWithoutSelection(iLine, iChar);
	}
}

///	obt@o[̃ACRXV
void CAlphaApp::_ResetBufferBarIcons() {
	m_bufferBar.SetImageList(m_documents.GetImageList());
}

///	INI t@Cɐݒۑ
void CAlphaApp::_SaveINISettings() {
	wchar_t			wszKeyName[30];
	unsigned short	iItem;

	// o[̉̕ۑ
	REBARBANDINFOW	rbbi;
	ZeroMemory(&rbbi, sizeof(REBARBANDINFOW));
	rbbi.cbSize = sizeof(REBARBANDINFOW);
	rbbi.fMask = RBBIM_STYLE;
	m_rebar.GetBandInfo(m_rebar.IdToIndex(IDC_TOOLBAR), rbbi);
	WriteProfileInt(L"View", L"visibleToolbar", toBoolean(rbbi.fStyle & RBBS_HIDDEN) ? 0 : 1);
	m_rebar.GetBandInfo(m_rebar.IdToIndex(IDC_BUFFERBAR), rbbi);
	WriteProfileInt(L"View", L"visibleBufferBar", toBoolean(rbbi.fStyle & RBBS_HIDDEN) ? 0 : 1);
	WriteProfileInt(L"View", L"visibleStatusBar", m_statusBar.IsWindowVisible() ? 1 : 0);

	// MRU Xg̕ۑ
	for(iItem = 0; ; ++iItem) {
		swprintf(wszKeyName, L"strPath(%u)", iItem);
		if(iItem == m_pMRUManager->GetCount()) {
			WriteProfileString(L"MRU", wszKeyName, L"");	// Xg̏I[\
			break;
		} else {
			const TMRU&	file = m_pMRUManager->GetFileInfoAt(iItem);
			WriteProfileString(L"MRU", wszKeyName, file.strFileName.c_str());
			swprintf(wszKeyName, L"nCodePage(%u)", iItem);
			WriteProfileInt(L"MRU", wszKeyName, file.nCodePage);
		}
	}

	// 񗚗̕ۑ
	list<wstring>					listFindWhat, listReplaceWith;
	list<wstring>::const_iterator	it;
	m_pdlgSearch->GetHistory(listFindWhat, listReplaceWith);
	for(iItem = 0, it = listFindWhat.begin(); it != listFindWhat.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");
	for(iItem = 0, it = listReplaceWith.begin(); it != listReplaceWith.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");
}

///	SẴGfB^ƈꕔ̃Rg[ɐVtHgݒ
void CAlphaApp::SetFont(const LOGFONTW& lf) {
	LOGFONTW	lf_ = lf;

	lf_.lfWeight = FW_NORMAL;
	::DeleteObject(m_hCommonFont);
	m_hCommonFont = ::CreateFontIndirectW(&lf_);

	// SẴr[̃tHgXV
	CAlphaView*	pView = 0;
	for(size_t i = 0; i < m_documents.GetCount(); ++i) {
		if(CAlphaEditController* pEditor = m_documents.GetDocument(i)->GetTextEditor())
			pEditor->GetPrimaryView()->SetFont(lf_, true);
	}

	// ꕔ̃Rg[ɂݒ
	if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1))) {
		if(m_pdlgBookmark != 0 && m_pdlgBookmark->IsWindow())
			m_pdlgBookmark->SendDlgItemMessage(IDC_LIST_BOOKMARKS,
				WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
		if(m_pdlgSearch != 0 && m_pdlgSearch->IsWindow()) {
			m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_FINDWHAT,
				WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
			m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_REPLACEWITH,
				WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
		}
	}

	// INI t@Cɕۑ
	WriteProfileStruct(L"View", L"oFont.pLogfont", &lf_, sizeof(LOGFONTW));

	//  <-> ϕŕ\LςKv
	_UpdateStatusBar();
}

///	j[̏
void CAlphaApp::_SetupMenus() {
	AssertValid();

	if(m_pMenu != 0) {
		while(true) {
			const UINT	cItems = m_pMenu->GetItemCount();
			if(cItems == 0 || cItems == -1)
				break;
			m_pMenu->RemoveMenuItem(0, false);
		}
		delete m_pMenu;
	}
	m_pMenu = new CMenu(m_pMainWindow->GetMenu());
	m_pMenu->DeleteMenuItem(0, false);	// _~[ (Ӗ̂͏̂)

	// j[o[
	m_pMenu->AppendMenuItem(CMD_FILE_TOP, MFT_STRING, LoadString(CMD_FILE_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_EDIT_TOP, MFT_STRING, LoadString(CMD_EDIT_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_SEARCH_TOP, MFT_STRING, LoadString(CMD_SEARCH_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_VIEW_TOP, MFT_STRING, LoadString(CMD_VIEW_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_MACRO_TOP, MFT_STRING, LoadString(CMD_MACRO_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_TOOL_TOP, MFT_STRING, LoadString(CMD_TOOL_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_HELP_TOP, MFT_STRING, LoadString(CMD_HELP_TOP).c_str());

	// [t@C]
	CMenu* pFileMenu = new CMenu();
	pFileMenu->AppendMenuItem(CMD_FILE_NEW, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_NEWWITHFORMAT, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_OPEN, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_REOPEN, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_REOPENWITHCODEPAGE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_MRU, MFT_OWNERDRAW);
	pFileMenu->SetChildPopup(*m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSEALL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSEOTHERS, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVEAS, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVEALL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_PROPERTY, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_OPERATE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SENDMAIL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_EXIT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pFileMenu, CMD_FILE_TOP, true, true);

	// [t@C]-[t@C]
	delete m_pFileOpeMenu;
	m_pFileOpeMenu = new CMenu();
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_RENAME, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_COPY, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_MOVE, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_DELETE, MFT_OWNERDRAW);
	pFileMenu->SetChildPopup(*m_pFileOpeMenu, CMD_FILE_OPERATE, false, true);

	// [ҏW]
	CMenu* pEditMenu = new CMenu();
	pEditMenu->AppendMenuItem(CMD_EDIT_UNDO, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_REDO, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_CUT, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_COPY, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_PASTE, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_PASTEFROMCLIPBOARDRING, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_DELETE, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_SELECTALL, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_ADVANCED, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_OPENCANDIDATEWINDOW, MF_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_SHOWABBREVIATIONDLG, MF_OWNERDRAW);
	m_pMenu->SetChildPopup(*pEditMenu, CMD_EDIT_TOP, true, true);

	// [ҏW]-[xȑ]
	CMenu* pAdvEditMenu = new CMenu();
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_CHARTOCODEPOINT, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_CODEPOINTTOCHAR, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTGRAVE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTACUTE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCIRCUMFLEX, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTTILDE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTMACRON, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTBREVE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTDIAERESIS, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCARON, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCEDILLA, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTSUPER, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTSUB, MFT_OWNERDRAW);
	pEditMenu->SetChildPopup(*pAdvEditMenu, CMD_EDIT_ADVANCED, true, true);

	// []
	CMenu* pFindMenu = new CMenu();
	pFindMenu->AppendMenuItem(CMD_SEARCH_FIND, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_FINDNEXT, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_FINDPREV, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCH, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHRF, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHRR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHMF, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHMR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_REVOKEMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_GOTOLINE, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_TOGGLEBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_NEXTBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_PREVBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_CLEARBOOKMARKS, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_MANAGEBOOKMARKS, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_GOTOMATCHBRACKET, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_EXTENDTOMATCHBRACKET, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pFindMenu, CMD_SEARCH_TOP, true, true);

	// [\]
	CMenu*	pViewMenu = new CMenu();
	pViewMenu->AppendMenuItem(CMD_VIEW_TOOLBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_STATUSBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_BUFFERBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_BUFFERS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_NEXTBUFFER, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_PREVBUFFER, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_SPLIT, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPNO, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPBYSPECIFIEDWIDTH, MFT_OWNERDRAW, MFS_GRAYED);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPBYWINDOWWIDTH, MFT_OWNERDRAW, MFS_GRAYED);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_TOPMOSTALWAYS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_REFRESH, MFT_OWNERDRAW);
	pViewMenu->SetChildPopup(m_documents.GetBufferListMenu(), CMD_VIEW_BUFFERS, false, true);
	m_pMenu->SetChildPopup(*pViewMenu, CMD_VIEW_TOP, true, true);

	// [}N]
	CMenu*	pMacroMenu = new CMenu();
	pMacroMenu->AppendMenuItem(CMD_MACRO_RECORD, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_PLAY, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_STOP, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_ABORT, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_PAUSERESTART, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_SAVEAS, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_SCRIPTS, MFT_OWNERDRAW);
/*	pDebugMenu->AppendMenuItem(CMD_DEBUG_INSERTBREAKPOINT, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_INSERTBREAKPOINT));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_BREAKPOINTS, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_BREAKPOINTS));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_ACTIVEDOCUMENTS, MF_OWNERDRAW | MF_GRAYED, GetMenuLabel(CMD_DEBUG_ACTIVEDOCUMENTS));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_START, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_START));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_RESTART, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_RESTART));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STOP, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STOP));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPINTO, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPINTO));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPOVER, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPOVER));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPOUT, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPOUT));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_CALLSTACK, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_CALLSTACK));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_VARIABLES, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_VARIABLES));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_IMMEDIATE, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_IMMEDIATE));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_THREADS, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_THREADS));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_EXCEPTION, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_EXCEPTION));
*/	m_pMenu->SetChildPopup(*pMacroMenu, CMD_MACRO_TOP, true, true);

	// [}N]-[XNvg] (b)
	CMenu*	pScriptMenu = new CMenu();
//	pScriptMenu->AppendMenuItem(CMD_EDIT_RELOADPLUGIN, MF_OWNERDRAW, GetMenuLabel(CMD_EDIT_RELOADPLUGIN));
//	pScriptMenu->AppendMenuItem(0, MFT_SEPARATOR, 0);
	const size_t	cScripts = m_pScriptMacroManager->GetCount();
	if(cScripts != 0) {
//		pScriptMenu->AppendMenuItem(CMD_MACRO_INTERRUPT, MFT_OWNERDRAW);
//		pScriptMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
		for(size_t i = 0; i < cScripts; ++i)
			pScriptMenu->AppendMenuItem(CMD_EDIT_PLUGINLIST_START + i, MFT_OWNERDRAW);
	} else
		pScriptMenu->AppendMenuItem(CMD_EDIT_PLUGINLIST_START, MFT_OWNERDRAW, MF_GRAYED | MF_DISABLED);
	pMacroMenu->SetChildPopup(*pScriptMenu, CMD_MACRO_SCRIPTS, true, true);

	// [c[]
	CMenu* pToolMenu = new CMenu();
	pToolMenu->AppendMenuItem(CMD_TOOL_EXECUTE, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_EXECUTECOMMAND, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_APPDOCTYPES, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_DOCTYPEOPTION, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_COMMONOPTION, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_FONT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pToolMenu, CMD_TOOL_TOP, true, true);
	delete m_pAppDocTypeMenu;
	m_pAppDocTypeMenu = new CMenu();	// [Kp^Cv]
	pToolMenu->SetChildPopup(*m_pAppDocTypeMenu, CMD_TOOL_APPDOCTYPES, false, true);

	// [wv]
	CMenu* pHelpMenu = new CMenu();
	pHelpMenu->AppendMenuItem(CMD_HELP_ABOUT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pHelpMenu, CMD_HELP_TOP, true, true);

	// ^u
	delete m_pBufferBarMenu;
	m_pBufferBarMenu = new CMenu();
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_CLOSE, MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_CLOSEOTHERS, MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_PROPERTY, MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_OPERATE, MFT_OWNERDRAW);
	m_pBufferBarMenu->SetDefaultMenuItem(CMD_FILE_CLOSE);
	m_pBufferBarMenu->SetChildPopup(*m_pFileOpeMenu, CMD_FILE_OPERATE, false, true);

	m_pMainWindow->DrawMenuBar();
}

///	c[o[̏
void CAlphaApp::_SetupToolbar() {
	AssertValid();

	// Wc[o[
	CommandId*		pCommands = 0;	// c[o[ɏ悹{^ɑΉR}h
	size_t			cButtons;		// {^
	list<wstring>	listButtons;

	// ݒǂݍ
	_GetProfileList(L"ToolbarButtons", L"standard", listButtons, L"");

	if(!listButtons.empty()) {	// Ggꍇ
		list<wstring>::const_iterator	it;
		size_t							i = 0;

		cButtons = listButtons.size();
		pCommands = new CommandId[cButtons];
		for(i = 0, it = listButtons.begin(); it != listButtons.end(); ++i, ++it)
			pCommands[i] = static_cast<CommandId>(wcstoul(it->c_str(), 0, 10));
	} else {	// ftHg̐ݒg
		cButtons = 16;
		pCommands = new CommandId[cButtons];
		pCommands[0] = CMD_FILE_NEW;			pCommands[1] = CMD_FILE_OPEN;
		pCommands[2] = CMD_FILE_SAVE;			pCommands[3] = CMD_FILE_SAVEAS;
		pCommands[4] = CMD_FILE_SAVEALL;		pCommands[5] = 0;
		pCommands[6] = CMD_EDIT_CUT;			pCommands[7] = CMD_EDIT_COPY;
		pCommands[8] = CMD_EDIT_PASTE;			pCommands[9] = 0;
		pCommands[10] = CMD_EDIT_UNDO;			pCommands[11] = CMD_EDIT_REDO;
		pCommands[12] = 0;						pCommands[13] = CMD_SEARCH_FIND;
		pCommands[14] = CMD_SEARCH_FINDNEXT;	pCommands[15] = CMD_SEARCH_FINDPREV;
	}

	// C[WXg쐬
	wchar_t		wszIconDir[MAX_PATH];

	::GetModuleFileNameW(0, wszIconDir, MAX_PATH);
	::PathFindFileNameW(wszIconDir)[0] = 0;
	wcscat(wszIconDir, IDS_ICON_DIRECTORY_NAME);
	m_pCommandManager->CreateImageList(wszIconDir);

	// {^
	TBBUTTON*	pButtons = new TBBUTTON[cButtons];
	bool		bHasDropArrow;
	for(size_t i = 0; i < cButtons; ++i) {
		bHasDropArrow = pCommands[i] == CMD_FILE_NEW || pCommands[i] == CMD_FILE_OPEN;
		ZeroMemory(pButtons + i, sizeof(TBBUTTON));
		pButtons[i].fsState = TBSTATE_ENABLED;
		if(pCommands[i] == 0)
			pButtons[i].fsStyle = BTNS_SEP;
		else {
			size_t	iIcon = m_pCommandManager->GetIconIndex(pCommands[i]);

			if(bHasDropArrow)		pButtons[i].fsStyle = BTNS_BUTTON | BTNS_DROPDOWN;
			else if(iIcon == -1)	pButtons[i].fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON;
			else					pButtons[i].fsStyle = BTNS_BUTTON;
			if(iIcon != -1 /*&& !bHasDropArrow*/)
				pButtons[i].iBitmap = iIcon;
			else {
				const wstring	strCaption = m_pCommandManager->GetCaption(pCommands[i]);
				wchar_t*		pwszCaption = new wchar_t[strCaption.length() + 1];
				wcscpy(pwszCaption, strCaption.c_str());
				pButtons[i].iString = reinterpret_cast<INT_PTR>(pwszCaption);
				pButtons[i].iBitmap = bHasDropArrow ? iIcon : I_IMAGENONE;
			}
		}
		pButtons[i].idCommand = pCommands[i];
	}

	if(!m_toolbar.IsWindow()) {
		RECT	rect = {0, 0, 0, 0};
		m_toolbar.CreateEx(WS_EX_TOOLWINDOW,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE
			| CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE | CCS_TOP
			| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT,
			rect, m_rebar, IDC_TOOLBAR);
		HWND	hTooltip = m_toolbar.GetToolTips();
		m_toolbar.SetButtonStructSize();
		m_toolbar.SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS /*| TBSTYLE_EX_HIDECLIPPEDBUTTONS*/);
		::SetWindowLongPtrW(hTooltip, GWL_STYLE, ::GetWindowLongPtrW(hTooltip, GWL_STYLE) | TTS_NOPREFIX);
	} else {
		m_toolbar.SetImageList(0);
		m_toolbar.SetDisabledImageList(0);
		while(m_toolbar.GetButtonCount() != 0)
			m_toolbar.DeleteButton(0);
	}
	m_toolbar.AddButtons(cButtons, pButtons);
	m_toolbar.SetImageList(m_pCommandManager->GetImageList(true));
	m_toolbar.SetDisabledImageList(m_pCommandManager->GetImageList(false));
//	m_toolbar.SetPadding(6, 6);

	for(size_t i = 0; i < cButtons; ++i) {
		delete[] reinterpret_cast<wchar_t*>(pButtons[i].iString);
		if(pButtons[i].fsStyle != BTNS_SEP
				&& pButtons[i].iBitmap != I_IMAGENONE) {	// ACRt{^̕ŌŒ肷
			TBBUTTONINFOW	tbi;

			tbi.cbSize = sizeof(TBBUTTONINFOW);
			tbi.dwMask = TBIF_SIZE;
			tbi.cx = (pButtons[i].idCommand != CMD_FILE_NEW && pButtons[i].idCommand != CMD_FILE_OPEN) ? 22 : 38;
			m_toolbar.SetButtonInfo(pButtons[i].idCommand, tbi);
		}
	}
	delete[] pCommands;
	delete[] pButtons;

	// obt@o[
	if(!m_bufferBar.IsWindow()) {
		RECT	rect = {0, 0, 0, 0};
		m_bufferBar.CreateEx(WS_EX_TOOLWINDOW,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE
			| CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE | CCS_TOP
			| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_REGISTERDROP | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT,
			rect, m_rebar, IDC_BUFFERBAR);
		HWND	hTooltip = m_bufferBar.GetToolTips();
		m_bufferBar.SetButtonStructSize();
		::SetWindowLongPtrW(hTooltip, GWL_STYLE, ::GetWindowLongPtrW(hTooltip, GWL_STYLE) | TTS_NOPREFIX);
	}

	// o[ɏ悹
	if(m_rebar.GetBandCount() == 0) {
		REBARBANDINFOW	rbbi;

		ZeroMemory(&rbbi, sizeof(REBARBANDINFOW));
		rbbi.cbSize = sizeof(REBARBANDINFOW);
		rbbi.fMask = RBBIM_CHILD | RBBIM_CHILDSIZE | RBBIM_ID | RBBIM_STYLE;
		rbbi.fStyle = /*RBBS_CHILDEDGE |*/ RBBS_GRIPPERALWAYS | RBBS_USECHEVRON;
		rbbi.wID = IDC_TOOLBAR;
		rbbi.hwndChild = m_toolbar.GetSafeHwnd();
		rbbi.cxMinChild = 0;
		rbbi.cyMinChild = 22;
		m_rebar.InsertBand(0, rbbi);
		rbbi.fMask |= RBBIM_TEXT;
		rbbi.fStyle |= RBBS_BREAK;
		rbbi.wID = IDC_BUFFERBAR;
		rbbi.lpText = L"obt@";
		rbbi.hwndChild = m_bufferBar.GetSafeHwnd();
		m_rebar.InsertBand(1, rbbi);
	}

	// c[o[̃VFu镝̐ݒ
	REBARBANDINFOW	rbbi;
	RECT			rect;
	m_toolbar.GetItemRect(m_toolbar.GetButtonCount() - 1, rect);
	ZeroMemory(&rbbi, sizeof(REBARBANDINFOW));
	rbbi.cbSize = sizeof(REBARBANDINFOW);
	rbbi.fMask = RBBIM_IDEALSIZE;
	rbbi.cxIdeal = rect.right;
	m_rebar.SetBandInfo(m_rebar.IdToIndex(IDC_TOOLBAR), rbbi);
}

///	Xe[^Xo[̍XV
void CAlphaApp::_UpdateStatusBar() {
	AssertValid();

	IDocumentContainer*			pActiveContainer = m_documents.GetActiveDocument();
	if(pActiveContainer == 0)
		return;
	const CAlphaEditController*	pActiveEditor = pActiveContainer->GetTextEditor();
	const CAlphaDoc*			pActiveDoc = 0;

	if(!m_statusBar.IsWindow())
		return;
	if(pActiveEditor == 0) {
		m_statusBar.SetSimple(true);
		return;
	} else {
		m_statusBar.SetSimple(false);
		pActiveDoc = pActiveEditor->GetDocument();
	}

	// Xe[^Xo[̃yC͍
	// ėpA݈ʒuA^Cv̖OAR[hAfobOԁAL[}NԁAҏW[hA_~[
	// UpdateStatusBar Q
	int					arrParts[8];
	RECT				rect;
	NONCLIENTMETRICSW	ncm;
	CWindowDC			dc = m_statusBar.GetDC();
	HFONT				hOldFont;
	const CAlphaView*	pView = pActiveEditor->GetActiveView();
	CCharPos		pos1, pos2;
	const wchar_t*	pwszPosition = pView->GetCurrentPositionString();
	const wchar_t*	pwszDocType = pActiveDoc->m_strDocType.c_str();
	const wchar_t*	pwszCharCode = CAlphaApp::GetCodePageName(pView->GetDocument()->GetCodePage());
	const wstring	strKeymacroRec = (CEditView::GetViewKeyMacroRecording() == pView) ? LoadString(MSG_MACRORECORDING) : L"";
	const wstring	strDebugging = (false/*m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging()*/) ? LoadString(MSG_DEBUGGING) : L"";
	const wstring	strOvertype = LoadString(pView->IsOvertypeMode() ? MSG_OVERTYPEMODE : MSG_INSERTMODE);

	// Xe[^Xo[̃tHg擾
	ZeroMemory(&ncm, sizeof(NONCLIENTMETRICSW));
	ncm.cbSize = sizeof(NONCLIENTMETRICSW);
	::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICSW), &ncm, 0);
	hOldFont = static_cast<HFONT>(dc.SelectObject(::CreateFontIndirectW(&ncm.lfStatusFont)));

	// eyC̕߂
	m_statusBar.GetWindowRect(rect);
	arrParts[7] = rect.right - rect.left;
	arrParts[6] = arrParts[7] - (m_pMainWindow->IsZoomed() ? 0 : (rect.bottom - rect.top - 4));
	dc.DrawText(strOvertype.c_str(), -1, rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[5] = arrParts[6] - rect.right + rect.left - 8;
	dc.DrawText(strDebugging.c_str(), -1, rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[4] = arrParts[5] - rect.right + rect.left - 8;
	dc.DrawText(strKeymacroRec.c_str(), -1, rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[3] = arrParts[4] - rect.right + rect.left - 8;
	dc.DrawText(pwszCharCode, -1, rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[2] = arrParts[3] - rect.right + rect.left - 12;
	dc.DrawText(pwszDocType, -1, rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[1] = arrParts[2] - rect.right + rect.left - 10;
	dc.DrawText(pwszPosition, -1, rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[0] = arrParts[1] - rect.right + rect.left - 6;
	m_statusBar.SetParts(7, arrParts);

	m_statusBar.SetText(1, pwszPosition);
	m_statusBar.SetText(2, pwszDocType);
	m_statusBar.SetText(3, pwszCharCode);
	m_statusBar.SetText(4, strKeymacroRec.c_str());
	m_statusBar.SetText(5, strDebugging.c_str());
	m_statusBar.SetText(6, strOvertype.c_str());

	::DeleteObject(dc.SelectObject(hOldFont));
}

///	^Cgo[ƃobt@o[{^LvV̍XV
void CAlphaApp::_UpdateTitleBar() {
	AssertValid();

	static wstring	strTitleCache;

	if(!m_pMainWindow->IsWindow())
		return;

	if(const IDocumentContainer* pActiveDocument = m_documents.GetActiveDocument()) {
		wstring	strTitle = pActiveDocument->GetTitle();

		if(strTitle == strTitleCache)
			return;
		strTitleCache = strTitle;

		// obt@o[
		if(m_bufferBar.IsWindow()) {
			TBBUTTONINFOW	button;
			ZeroMemory(&button, sizeof(TBBUTTONINFOW));
			button.cbSize = sizeof(TBBUTTONINFOW);
			button.dwMask = TBIF_TEXT;
			button.pszText = const_cast<wchar_t*>(strTitle.c_str());
			m_bufferBar.SetButtonInfo(CMD_VIEW_BUFFERLIST_START + m_documents.GetActiveDocumentIndex(), button);
		}

		// ^Cgo[
		strTitle += L" - " IDS_APPFULLVERSION;
		m_pMainWindow->SetWindowText(strTitle.c_str());
	}
}

///	vOC () [h
void CAlphaApp::OnEditReloadPlugin() {
	wchar_t	wszPluginPath[MAX_PATH];

	wcscpy(wszPluginPath, m_szModulePath);
	wcscpy(::PathFindFileNameW(wszPluginPath), IDS_MACRO_DIRECTORY_NAME L"macros.xml");
	try {
		m_pScriptMacroManager->Load(wszPluginPath);
	} catch(CScriptMacroManager::EFailedToParseXml& /* e */) {
		// }l[W_CAOo...
	}
}

/**
 *	ANeBuȃ^u폜
 *	@return	{Ƀ^u폜Ƃ true
 */
bool CAlphaApp::OnFileClose(bool bConfirm /* = true */) {
	IDocumentContainer*		pActiveContainer = m_documents.GetActiveDocument();
	CAlphaEditController*	pActiveEditor = pActiveContainer->GetTextEditor();
	CAlphaDoc*				pActiveDoc = 0;

	if(bConfirm && pActiveEditor != 0) {
		wstring		strPrompt;
		int			nAnswer;

		pActiveDoc = pActiveEditor->GetDocument();

		// fobO~̊mF
/*		if(m_pDebuggingEditor != 0 && pActiveEditor == m_pDebuggingEditor) {
			nAnswer = MessageBox(MSG_DEBUG_DOCUMENTISDEBUGGING, MB_YESNO | MB_ICONQUESTION);
			if(nAnswer == IDNO)
				return false;
			m_pActiveDebugger->Abort();
		}
*/
		// ۑ̊mF
		if(pActiveDoc->IsModified()) {
			nAnswer = MessageBox(MSG_FILEISDIRTY,
				MB_YESNOCANCEL | MB_ICONQUESTION, __MARGS__ % pActiveDoc->GetTitle().c_str());
			if(nAnswer == IDCANCEL)
				return false;
			else if(nAnswer == IDYES) {
				if(!OnFileSave())
					return false;
			}
		}
	}

	// mFȂƂ̂
/*	if(m_pDebuggingEditor != 0 && pActiveEditor == m_pDebuggingEditor) {
		if(m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging())
			m_pActiveDebugger->Abort();
	}*/

	const size_t	iActive = m_documents.GetActiveDocumentIndex();
	m_documents.RemoveDocument(iActive);
	pActiveContainer->DeleteInstance();
	m_bufferBar.DeleteButton(m_documents.GetCount());

	// ʂ̃r[ANeBuɂ
	if(m_documents.GetCount() == 0)
		OnFileNew();
	else
		_ResetBufferBarIcons();

	return true;
}

/**
 *	SāA͔ANeBuȑSẴ^u폜
 *	@param bExceptCurrent	݂̃^ucꍇ true
 *	@return					^u̍폜1[UɋۂȂ true
 */
bool CAlphaApp::OnFileCloseAll(bool bExceptCurrent) {
	// TODO: eLXgGfB^ȊO^uɊ܂܂悤ɂȂC
	CConfirmUnsavedDocumentDlg	dlg;
	const unsigned int			iCurrent = m_documents.GetActiveDocumentIndex();

	// ۑ̕Kv̖hLgS
	for(size_t iDoc = m_documents.GetCount(); iDoc != 0; --iDoc) {
		if(bExceptCurrent && iDoc - 1 == iCurrent)
			continue;
		if(CAlphaEditController* pEditor = m_documents.GetDocument(iDoc - 1)->GetTextEditor()) {
			if(!pEditor->GetDocument()->IsModified()) {
				m_documents.SetActiveDocument(iDoc - 1);
				OnFileClose(false);
			}
		}
	}

	// ۑ̃t@CΏI
	if(m_documents.GetCount() == 1) {
		const CAlphaEditController*	pEditor = m_documents.GetDocument(0)->GetTextEditor();
		if(bExceptCurrent || pEditor == 0 || !pEditor->GetDocument()->IsModified())
			return true;
	}

	// ۑ̃t@C1Ȃʏ̊mF_CAOoďI
	if(m_documents.GetCount() - (bExceptCurrent ? 1 : 0) == 1) {
		unsigned int	iDirtyDoc;

		if(!bExceptCurrent)
			iDirtyDoc = 0;
		else
			iDirtyDoc = (iCurrent == 0) ? 1 : 0;
		if(m_documents.GetDocument(iDirtyDoc)->GetTextEditor() != 0
				&& m_documents.GetDocument(iDirtyDoc)->GetTextEditor()->GetDocument()->IsModified()) {
			if(bExceptCurrent)
				m_documents.SetActiveDocument(iDirtyDoc);
			return OnFileClose();
		}
	}

	// ̃t@Cۑ邩ǂmF_CAOo
	for(size_t iDoc = 0; iDoc < m_documents.GetCount(); ++iDoc) {
		if(bExceptCurrent && iDoc == iCurrent)
			continue;
		if(CAlphaEditController* pEditor = m_documents.GetDocument(iDoc)->GetTextEditor()) {
			TDirtyFile	tf;
			tf.iTab = iDoc;
			tf.strFileName = pEditor->GetDocument()->GetTitle();
			tf.bSave = true;
			dlg.m_files.push_back(tf);
		}
	}
	dlg.Create(m_hInstance, IDD_DLG_CONFIRMUNSAVEDDOCUMENTS, m_pMainWindow->GetSafeHwnd());
	if(IDOK != dlg.DoModal())
		return false;

	// ۑ
	for(vector<TDirtyFile>::reverse_iterator it = dlg.m_files.rbegin(); it != dlg.m_files.rend(); ++it) {
		m_documents.SetActiveDocument(it->iTab);
		if(it->bSave) {
			if(!OnFileSave())
				return false;
		}
		if(!OnFileClose(false))
			return false;
	}

	return true;
}

/**
 *	V^u쐬
 *	@param cp	R[hy[W (ȗƃ[ŨR[hy[W)
 *	@param bt	sR[h (ȗƃ[ỦsR[h)
 */
void CAlphaApp::OnFileNew(CodePage cp /* = -1 */, BreakType bt /* = BT_AUTO */) {
	if(::GetCurrentThreadId() != ::GetWindowThreadProcessId(m_pMainWindow->GetSafeHwnd(), 0)) {
		// EBhE̍쐬CXbhɈϏ
		m_pMainWindow->SendMessage(WM_CREATENEWBUFFER, cp, bt);
		return;
	}

	RECT					rect;
	CAlphaEditController*	pEditor = new CAlphaEditController();
	bool					bSucceededToCreate;
	static bool				bLoadedKeyMacro = false;

	m_pMainWindow->GetClientRect(rect);	// 쐬シ OnSize Ă΂邪Ah~̂߂ɃZbg
	pEditor->SetSplitterWidth(3);
	bSucceededToCreate = pEditor->Create(m_pMainWindow->GetSafeHwnd(),
		rect, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE, 0,
		WS_CHILD | WS_CLIPSIBLINGS | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_STATICEDGE);
	assert(bSucceededToCreate);
	if(!bLoadedKeyMacro) {
		pEditor->GetPrimaryView()->CmdKeymacroLoad(IDS_KEYMACROFILENAME);
		bLoadedKeyMacro = true;
	}

	if(!CEncoderFactory::GetInstance().IsCodePageForAutoDetection(cp)) {
		CAlphaDoc*	pDocument = pEditor->GetDocument();

		if(cp == 0)			cp = ::GetACP();
		else if(cp == -1)	cp = GetProfileInt(L"File", L"defaultCodePage", ::GetACP());
		if(bt == BT_AUTO)	bt = static_cast<BreakType>(GetProfileInt(L"File", L"defaultBreakType", BT_CRLF));
		try {
			pDocument->SetCodePage(cp);
			pDocument->SetBreakType(bt);
		} catch(invalid_argument&) {
			// Ȃ
		}
	}

	LOGFONTW	lf;
	::GetObject(m_hCommonFont, sizeof(LOGFONTW), &lf);
	pEditor->GetPrimaryView()->AddEventListener(this);
	pEditor->GetDocument()->AddEventListener(this);
	pEditor->GetPrimaryView()->SetFont(lf, false);
	pEditor->GetDocument()->SetTitle(IDS_UNTITLED);

	// obt@o[Ƀ{^ǉ
	TBBUTTON	button;
	ZeroMemory(&button, sizeof(TBBUTTON));
	button.idCommand = CMD_VIEW_BUFFERLIST_START + m_bufferBar.GetButtonCount();
	button.iBitmap = m_documents.GetCount();
	button.fsState = TBSTATE_ENABLED;
	button.fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON | BTNS_GROUP | BTNS_NOPREFIX;
	button.iString = reinterpret_cast<INT_PTR>(IDS_UNTITLED);
	m_bufferBar.InsertButton(m_bufferBar.GetButtonCount(), button);

	m_documents.AddDocument(*pEditor);
	_ResetBufferBarIcons();
	m_documents.SetActiveDocument(m_documents.GetCount() - 1);
	ApplyDocumentType(m_documents.GetActiveDocumentIndex(), L"");
}

///	[w肵ĐVK] _CAOJ
void CAlphaApp::OnFileNewWithFormat() {
	RECT					rect;
	CAlphaEditController*	pEditor = 0;
	CNewFileFormatDlg		dlg;
	bool					bSucceededToCreate;

	dlg.Create(m_hInstance, IDD_DLG_FILENEWWITHFORMAT, m_pMainWindow->GetSafeHwnd());
	dlg.m_nCodePage = GetProfileInt(L"File", L"defaultCodePage", 0);
	if(dlg.m_nCodePage == 0)
		dlg.m_nCodePage = ::GetACP();
	dlg.m_breakType = static_cast<BreakType>(GetProfileInt(L"file", L"defaultBreakType", BT_AUTO));
	if(dlg.m_breakType == BT_AUTO)
		dlg.m_breakType = BT_CRLF;
	dlg.m_iDocumentType = 0;
	dlg.m_documentTypes.clear();
	for(size_t i = 0; i < m_documentTypes.GetCount(); ++i)
		dlg.m_documentTypes.push_back(m_documentTypes.GetAt(i).strName);

	if(dlg.DoModal() != IDOK)
		return;

	m_pMainWindow->GetClientRect(rect);
	pEditor = new CAlphaEditController();
	pEditor->SetSplitterWidth(3);
	bSucceededToCreate = pEditor->Create(m_pMainWindow->GetSafeHwnd(),
		rect, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE, 0,
		WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_STATICEDGE);
	assert(bSucceededToCreate);
	try {
		pEditor->GetDocument()->SetCodePage(dlg.m_nCodePage);
		pEditor->GetDocument()->SetBreakType(dlg.m_breakType);
	} catch(invalid_argument&) {
		// Ȃ
	}

	// ^CvȊO͌ OnFileNew Ɠ...
	LOGFONTW	lf;
	::GetObject(m_hCommonFont, sizeof(LOGFONTW), &lf);
	pEditor->GetPrimaryView()->AddEventListener(this);
	pEditor->GetDocument()->AddEventListener(this);
	pEditor->GetPrimaryView()->SetFont(lf, false);
	pEditor->GetDocument()->SetTitle(IDS_UNTITLED);

	TBBUTTON	button;
	ZeroMemory(&button, sizeof(TBBUTTON));
	button.idCommand = CMD_VIEW_BUFFERLIST_START + m_bufferBar.GetButtonCount();
	button.iBitmap = m_documents.GetCount();
	button.fsState = TBSTATE_ENABLED;
	button.fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON | BTNS_GROUP | BTNS_NOPREFIX;
	button.iString = reinterpret_cast<INT_PTR>(IDS_UNTITLED);
	m_bufferBar.InsertButton(m_bufferBar.GetButtonCount(), button);

	m_documents.AddDocument(*pEditor);
	_ResetBufferBarIcons();
	m_documents.SetActiveDocument(m_documents.GetCount() - 1);
	ApplyDocumentType(m_documents.GetActiveDocumentIndex(),
		m_documentTypes.GetAt(dlg.m_iDocumentType).strName);	// Ⴄ
}

///	t@CJ
bool CAlphaApp::OnFileOpen() {
	OPENFILENAMEW	ofn;
	wstring			strFilter = GetProfileString(L"File", L"filter", LoadString(MSG_DEFAULTFILEFILTER).c_str());
	wchar_t*		pwszFilter = new wchar_t[strFilter.length() + 2];
	wchar_t			wszFileName[MAX_PATH + 1] = L"";
	wstring			strErrorMessage;

	// tB^𐮌`
	wstring::size_type	iFound = 0;
	while(true) {
		iFound = strFilter.find(L':', iFound + 1);
		if(iFound == wstring::npos)
			break;
		strFilter[iFound] = L'\0';
	}
	strFilter.copy(pwszFilter, strFilter.length());
	pwszFilter[strFilter.length()] = L'\0';
	pwszFilter[strFilter.length() + 1] = L'\0';

	ZeroMemory(&ofn, sizeof(OPENFILENAMEW));
	ofn.lStructSize = sizeof(OPENFILENAMEW);
	ofn.hwndOwner = m_pMainWindow->GetSafeHwnd();
	ofn.hInstance = m_hInstance;
	ofn.lpstrFilter = pwszFilter;
	ofn.lpstrFile = wszFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ALLOWMULTISELECT | OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST/* | OFN_SHOWHELP*/;
	ofn.lCustData = CPEX_AUTODETECT_USERLANG | 0;
	ofn.lpfnHook = OFNHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_OPENFILE);

	const bool	bSucceeded = toBoolean(::GetOpenFileNameW(&ofn));
	delete[] pwszFilter;

	if(bSucceeded) {
		const CodePage	cp = ofn.lCustData & 0x00FFFFFF;
		const wstring	strDirectory = ofn.lpstrFile;

		if(strDirectory.length() > ofn.nFileOffset)	// Jt@C1
			return OpenFile(strDirectory, cp);	// ofn.lpstrFile ͊St@C
		else {	// ̃t@CJꍇ
			wchar_t*	pwszFileName = ofn.lpstrFile + ofn.nFileOffset;
			bool		bFailedOnce = false;

			while(*pwszFileName != 0) {
				const size_t	cchFileName = wcslen(pwszFileName);

				if(!OpenFile(strDirectory + L"\\" + wstring(pwszFileName, cchFileName), cp))
					bFailedOnce = true;
				pwszFileName += cchFileName + 1;
			}
			return !bFailedOnce;
		}
	} else
		return false;
}

/**
 *	[t@C]_CAO̕\
 *	@param id	R}h ID
 */
void CAlphaApp::OnFileOperation(UINT id) {
	assert(id >= CMD_FILE_RENAME && id <= CMD_FILE_DELETE);

	CAlphaEditController*	pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*		pActiveDoc = pActiveEditor->GetDocument();
	OperationStatus	ops = OPS_OK;

	if(id != CMD_FILE_DELETE) {
		CFileOperationDlg	dlg(id, pActiveDoc->GetPathName());
		dlg.Create(m_hInstance, IDD_DLG_FILEOPERATION, m_pMainWindow->GetSafeHwnd());
		if(dlg.DoModal() == IDOK) {
			switch(id) {
			case CMD_FILE_COPY:
				ops = pActiveDoc->CopyCurrentFile(dlg.m_strFilePath.c_str());
				break;
			case CMD_FILE_MOVE:
			case CMD_FILE_RENAME:
				ops = pActiveDoc->MoveCurrentFile(dlg.m_strFilePath.c_str());
				break;
			}
		}
	} else {
		ops = pActiveDoc->DeleteCurrentFile();
		if(ops == OPS_OK)
			OnFileClose();
	}

	// ^Cgo[ƃ^uXV
	_UpdateTitleBar();

	// G[bZ[W̐
	switch(ops) {
	case OPS_OK:
	case OPS_ABORTED:
		return;
	case OPS_ALREADYEXISTS:
		MessageBox(MSG_FAILEDTOOPERATEFILE, MB_ICONEXCLAMATION);
		break;
	case OPS_OPENEDASREADONLY:
		MessageBox(MSG_REOPENEDASREADONLY, MB_ICONEXCLAMATION);
		break;
	case OPS_CANNOTOPEN:
		// ...
		break;
	case OPS_UNKNOWNERROR:
		// ...
//		::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, 0, ::GetLastError(),
//			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), wszError + wcslen(wszError), 200, 0);
		break;
	}
}

///	[vpeB] _CAO̕\
void CAlphaApp::OnFileProperty() {
	CAlphaEditController*	pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*			pActiveDoc = pActiveEditor->GetDocument();
	CFilePropertyDlg	dlg;

	if(pActiveDoc == 0) {
		::MessageBeep(MB_OK);
		return;
	}

	dlg.m_pDocument = pActiveDoc;
	dlg.m_strDocTypeName = pActiveDoc->m_strDocType;
	dlg.Create(m_hInstance, IDD_DLG_FILEPROPERTY, m_pMainWindow->GetSafeHwnd());
	dlg.DoModal();
}

///	݊JĂt@CۑɕAJ
void CAlphaApp::OnFileReopen() {
	CAlphaEditController*	pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*		pActiveDoc = pActiveEditor->GetDocument();
	const wstring	strPathName = pActiveDoc->GetPathName();

	if(strPathName.empty())
		return;

	if(!pActiveDoc->IsModified()
			|| IDYES == MessageBox(MSG_ASKREOPENINDIRTY, MB_YESNO | MB_ICONQUESTION)) {
		pActiveEditor->SplitView(0);
		Ascension::StreamStatus	ss = pActiveDoc->LoadDocument(
			strPathName, pActiveDoc->GetShareMode(), pActiveDoc->GetCodePage());
		_UpdateStatusBar();
		if(_HandleFileOpenError(ss))
			m_pMRUManager->Add(pActiveDoc->GetPathName(), pActiveDoc->GetCodePage());
	}
}

///	݊JĂt@CۑɕAR[hy[Ww肵ĊJ
void CAlphaApp::OnFileReopenWithCodepage() {
	CAlphaEditController*	pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*	pActiveDoc = pActiveEditor->GetDocument();

	if(pActiveDoc->GetPathName().empty())
		return;
	if(pActiveDoc->IsModified() &&
			IDNO == MessageBox(MSG_ASKREOPENINDIRTY, MB_YESNO | MB_ICONQUESTION))
		return;

	CCodePagesDlg	dlg;

	dlg.Create(m_hInstance, IDD_DLG_CODEPAGES, m_pMainWindow->GetSafeHwnd());
	dlg.m_nCodePage = pActiveDoc->GetCodePage();
	if(dlg.DoModal() == IDOK) {
		pActiveEditor->SplitView(0);
		Ascension::StreamStatus	ss = pActiveDoc->LoadDocument(
			pActiveDoc->GetPathName(), pActiveDoc->GetShareMode(), dlg.m_nCodePage);
		_UpdateStatusBar();
		if(_HandleFileOpenError(ss))
			m_pMRUManager->Add(pActiveDoc->GetPathName(), pActiveDoc->GetCodePage());
	}
}

/**
 *	t@C㏑ۑBt@C݂ȂƂ CAlphaApp::OnFileSaveAs Ăяo
 *	@param iDocument	hLg̔ԍB-1ƃANeBuȃhLg
 *	@return				 (ۑKvꍇ true)
 *	@throw out_of_range	<var>iTab</var> ȂƂX[
 */
bool CAlphaApp::OnFileSave(unsigned int iDocument /* = -1 */) throw(out_of_range) {
	IDocumentContainer*	pContainer = 0;
	CAlphaDoc*			pDocument = 0;
	StreamStatus		ss;
	UINT				nCurrentCP;
	bool				bWriteBOM = false;

	if(iDocument == -1)
		iDocument = m_documents.GetActiveDocumentIndex();
	try {
		pContainer = m_documents.GetDocument(iDocument);
	} catch(out_of_range&) {
		throw;
	}
	if(pContainer->GetTextEditor() == 0)
		return false;
	pDocument = pContainer->GetTextEditor()->GetDocument();
	if(!pDocument->GetPathName().empty() && !pDocument->IsModified())
		return true;

	// t@C݂邩
	if(!::PathFileExistsW(pDocument->GetPathName().c_str()))
		return OnFileSaveAs(iDocument);

	nCurrentCP = pDocument->GetCodePage();
	switch(nCurrentCP) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
		break;
	case CPEX_UNICODE_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
		break;
	case CPEX_UNICODE_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16bE", 1));
		break;
	case CPEX_UNICODE_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
		break;
	case CPEX_UNICODE_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
		break;
	case 50227:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022CN", 0));
		break;
	case 50225:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022KR", 0));
		break;
	}

	SaveDocumentOption	sdo = bWriteBOM ? SDO_WRITE_BOM : 0;
	do {
		ss = pDocument->SaveDocument(pDocument->GetPathName(), sdo, BT_AUTO, nCurrentCP);
		if(ss == SS_OK)
			m_pMRUManager->Add(pDocument->GetPathName(), pDocument->GetCodePage());
		else if(ss == SS_WRITE_CONTAININVALIDCHAR) {
			const wstring	strPrompt = LoadString(MSG_FILECONTAINSILLEGALCHARS, __MARGS__ % pDocument->GetPathName());
			if(IDYES == m_pMainWindow->MessageBox(strPrompt.c_str(), IDS_APPNAME, MB_YESNO | MB_ICONEXCLAMATION)) {
				sdo |= SDO_IGNORE_NOFITCHARS;
				continue;
			}
			return false;
		}
	} while(false);

	if(iDocument != m_documents.GetActiveDocumentIndex()) {	// ANeBułȂ^uۑ
		const wstring	strTitle = pContainer->GetTitle();
		TBBUTTONINFOW	button;

		ZeroMemory(&button, sizeof(TBBUTTONINFOW));
		button.cbSize = sizeof(TBBUTTONINFOW);
		button.dwMask = TBIF_TEXT;
		button.pszText = const_cast<wchar_t*>(strTitle.c_str());
		m_bufferBar.SetButtonInfo(iDocument, button);
	}

	return true;
}

/**
 *	t@CSĕۑ
 *	@return	rŒfȂ true
 */
bool CAlphaApp::OnFileSaveAll() {
	for(size_t i = 0; i < m_documents.GetCount(); ++i) {	// SẴhLgۑ
		if(!OnFileSave(i))
			return false;
	}
	return true;
}

/**
 *	t@Cw肵Oŕۑ
 *	@param iDocument	hLgԍB-1ƃANeBuȃhLg
 *	@return				
 *	@throw out_of_range	<var>iTab</var> ȂƂX[
 */
bool CAlphaApp::OnFileSaveAs(unsigned int iDocument /* = -1 */) throw(out_of_range) {
	IDocumentContainer*	pContainer = 0;
	CAlphaDoc*			pDocument = 0;
	StreamStatus		ss;
	OPENFILENAMEW		ofn;
	wchar_t				wszFilter[] = IDS_FILEFILTERW;
	wchar_t				wszFileName[MAX_PATH + 1] = L"";
	BreakType			bc = BT_AUTO;						// sR[h
	bool				bWriteBOM = false;

	if(iDocument == -1)
		iDocument = m_documents.GetActiveDocumentIndex();
	try {
		pContainer = m_documents.GetDocument(iDocument);
	} catch(out_of_range&) {
		throw;
	}
	if(pContainer->GetTextEditor() == 0)
		return false;
	pDocument = pContainer->GetTextEditor()->GetDocument();

	if(!pDocument->GetPathName().empty())
		wcscpy(wszFileName, pDocument->GetPathName().c_str());

	ZeroMemory(&ofn, sizeof(OPENFILENAMEW));
	ofn.lStructSize = sizeof(OPENFILENAMEW);
	ofn.hwndOwner = m_pMainWindow->GetSafeHwnd();
	ofn.hInstance = m_hInstance;
	ofn.lpstrFilter = wszFilter;
	ofn.lpstrFile = wszFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT /* | OFN_SHOWHELP*/;
	ofn.lCustData = pDocument->GetCodePage() | (bc << 24);
	ofn.lpfnHook = OFNHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_SAVEFILE);

	if(!toBoolean(::GetSaveFileNameW(&ofn)))
		return false;

	switch(ofn.lCustData & 0x00FFFFFF) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
		break;
	case CPEX_UNICODE_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
		break;
	case CPEX_UNICODE_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16BE", 1));
		break;
	case CPEX_UNICODE_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
		break;
	case CPEX_UNICODE_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
		break;
	case 50227:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022CN", 0));
		break;
	case 50225:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022KR", 0));
		break;
	}

	SaveDocumentOption	sdo = bWriteBOM ? SDO_WRITE_BOM : 0;
	const wstring		strDocType = pDocument->m_strDocType;
	do {
		ss = pDocument->SaveDocument(ofn.lpstrFile, sdo,
				static_cast<BreakType>(ofn.lCustData >> 24), ofn.lCustData & 0x00FFFFFF);
		if(ss == SS_OK)
			m_pMRUManager->Add(pDocument->GetPathName(), pDocument->GetCodePage());
		else if(ss == SS_WRITE_CONTAININVALIDCHAR) {
			const wstring	strPrompt = LoadString(MSG_FILECONTAINSILLEGALCHARS, __MARGS__ % ofn.lpstrFile);
			if(IDYES == m_pMainWindow->MessageBox(strPrompt.c_str(), IDS_APPNAME, MB_YESNO | MB_ICONEXCLAMATION)) {
				sdo |= SDO_IGNORE_NOFITCHARS;
				continue;
			}
			return false;
		}
	} while(false);

	const TDocumentType&	type = m_documentTypes.GetByFileName(pDocument->GetTitle());
	if(type.strName != m_documentTypes.GetAt(m_documentTypes.Find(strDocType)).strName)
		ApplyDocumentType(m_documents.GetActiveDocumentIndex(), type.strName);
	if(iDocument != m_documents.GetActiveDocumentIndex()) {	// ANeBułȂ^uۑ
		const wstring	strTitle = pContainer->GetTitle();
		TBBUTTONINFOW	button;

		ZeroMemory(&button, sizeof(TBBUTTONINFOW));
		button.cbSize = sizeof(TBBUTTONINFOW);
		button.dwMask = TBIF_TEXT;
		button.pszText = const_cast<wchar_t*>(strTitle.c_str());
		m_bufferBar.SetButtonInfo(iDocument, button);
	}
	m_documents.UpdateList();
	_ResetBufferBarIcons();
	_UpdateStatusBar();
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();

	return true;
}

///	[ׂă}[N]
void CAlphaApp::OnFindBookmarkAll() {
	CAlphaEditController*	pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor();
	unsigned long			cFound;

	if(pActiveEditor == 0)
		return;
	CAlphaView*	pView = pActiveEditor->GetPrimaryView();

	try {
		m_pdlgSearch->UpdateOptions();
		pView->SetSearchText(m_pdlgSearch->GetFindText());
		cFound = pView->ExecCommand(CMDID_SEARCH_BOOKMARKALL);
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
		return;
	} catch(ERegExpPatternIsInvalid& e) {
		MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
		return;
	} catch(EMiscellaneousRegExpError& e) {
		MessageBox(MSG_REGEXPRUNTIMEERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
		return;
	}
	if(cFound != 0)
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
}

///	[ƒu] _CAO̕\/\
void CAlphaApp::OnFindFind() {
	if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		const CAlphaView*	pActiveView = pActiveEditor->GetActiveView();

		if(!m_pdlgSearch->IsWindowVisible()) {
			CCharPos	pos1, pos2;

			pActiveView->GetSel(pos1, pos2);
			if(pos1 == pos2) {
				string_t	str;
				pActiveView->GetNearestWordFromCaret(0, 0, &str);
				m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, str.c_str());
			} else if(pos1.m_iLine != pos2.m_iLine)
				m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, L"");
			else
				m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, pActiveView->GetSelection().c_str());
			m_pdlgSearch->ShowWindow(SW_SHOW);
		} else
			m_pdlgSearch->ShowWindow(SW_HIDE);
	}
}

/**
 *	݂̌ɏ]ĎA͑O̕B
 *	̃\bh̓qbgIԂɂB
 *	܂A_CAO\ł@\
 *	@param bPrevious	true ɂƑO
 *	@param bNotice		true ɂƌsƂɃvvg\
 */
void CAlphaApp::OnFindFindNext(bool bPrevious /* = false */, bool bNotice /* = true */) {
	if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		m_pdlgSearch->UpdateOptions();

		CAlphaView*		pView = pActiveEditor->GetActiveView();
		TSearchOption	options = pView->GetSearchOptions();

		options.bForward = !bPrevious;
		pView->SetSearchOptions(options);
		pView->SetSearchText(m_pdlgSearch->GetFindText());

		try {
			// try ubNƂȂ񂩒xȂ
			if(pView->ExecCommand(CMDID_SEARCH_FINDNEXT))
				m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
			else if(bNotice && m_bShowMessageBoxOnFind)
				MessageBox(MSG_TEXTNOTFOUND, MB_ICONINFORMATION);
		} catch(EFailedToLoadRegExpEngine& /* e */) {
			if(bNotice)
				MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
			return;
		} catch(ERegExpPatternIsInvalid& e) {
			if(bNotice)
				MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
			return;
		} catch(EMiscellaneousRegExpError& e) {
			if(bNotice)
				MessageBox(MSG_REGEXPRUNTIMEERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
			return;
		}
		if(m_pdlgSearch->IsWindowVisible()) {
			if(m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
				m_pMainWindow->SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
			else
				::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
		}
	}
}

/**
 *	AEgC͂s_CAO\B
 *	݂̃hLg^CvɌꂪݒ肳ĂȂꍇ̓G[bZ[Wo
 */
void CAlphaApp::OnFindParseOutline() {
/*	CAlphaDoc*		pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	const wstring&	strLanguage = m_vecDocumentTypes[pActiveDoc->m_iDocType].strLanguageForOutlineParsing;

	if(m_dlgOutline.IsWindow()) {	// _CAOJĂΕ邾
		m_dlgOutline.EndDialog(IDCANCEL);
		return;
	}

	if(strLanguage == L"JScript")
		m_dlgOutline.m_oplLanguage = OPL_JSCRIPT;
	else if(strLanguage == L"VBScript")
		m_dlgOutline.m_oplLanguage = OPL_VBSCRIPT;
	else {
		wchar_t	wszMessage[256];
		LoadString(116, wszMessage, 256);
		m_pMainWindow->MessageBox(wszMessage, IDS_APPNAME, MB_ICONEXCLAMATION);
		return;
	}

	m_dlgOutline.Create(m_hInstance, IDD_DLG_OUTLINE, m_pMainWindow->m_hWnd);
	m_dlgOutline.Parse(pActiveDoc);*/
}

/**
 *	݈ʒuȍ~̌SĒuB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::OnFindReplaceAll() {
	if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		unsigned int	cReplaced;
		CAlphaDoc*		pActiveDoc = pActiveEditor->GetDocument();
		CAlphaView*		pActiveView = pActiveDoc->GetController()->GetActiveView();

		try {
			m_pdlgSearch->UpdateOptions();
			pActiveView->SetSearchText(m_pdlgSearch->GetFindText());
			pActiveView->SetReplaceText(m_pdlgSearch->GetReplaceText());
			cReplaced = pActiveView->ExecCommand(CMDID_SEARCH_REPLACEALL);
		} catch(EFailedToLoadRegExpEngine& /* e */) {
			MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
			return;
		} catch(ERegExpPatternIsInvalid& e) {
			MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
			return;
		} catch(EMiscellaneousRegExpError& e) {
			MessageBox(MSG_REGEXPRUNTIMEERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
			return;
		}

		// ʂ̏o
		if(m_bShowMessageBoxOnFind) {
			if(cReplaced != 0)
				MessageBox(MSG_REPLACESUCCEEDED, MB_ICONINFORMATION, __MARGS__ % cReplaced);
			else
				MessageBox(MSG_TEXTNOTFOUND, MB_ICONINFORMATION);
		}

		if(cReplaced != 0) {	// ɒǉ
			m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
			m_pdlgSearch->AddToHistory(m_pdlgSearch->GetReplaceText(), true);
		}
		if(m_pdlgSearch->IsWindow()) {
			if(m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [ׂĒu_CAO]
				m_pMainWindow->SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
			else
				::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
		}
	}
}

/**
 *	݂̑I͈͂łΒusB
 *	uA͑I͈͂Ŗꍇ͎̌IԂɂB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::OnFindReplaceAndNext() {
	if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		CAlphaView*	pActiveView = pActiveEditor->GetActiveView();

		m_pdlgSearch->UpdateOptions();
		pActiveView->SetSearchText(m_pdlgSearch->GetFindText());
		pActiveView->SetReplaceText(m_pdlgSearch->GetReplaceText());
		try {
			if(pActiveView->ExecCommand(CMDID_SEARCH_REPLACEANDFINDNEXT))	// u
				m_pdlgSearch->AddToHistory(m_pdlgSearch->GetReplaceText(), true);
			else if(m_bShowMessageBoxOnFind)
				MessageBox(MSG_TEXTNOTFOUND, MB_ICONINFORMATION);
		} catch(EFailedToLoadRegExpEngine& /* e */) {
			MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
			return;
		} catch(ERegExpPatternIsInvalid& e) {
			MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
			return;
		} catch(EMiscellaneousRegExpError& e) {
			MessageBox(MSG_REGEXPRUNTIMEERROR, MB_ICONEXCLAMATION, __MARGS__ % e.what());
			return;
		}

		if(m_pdlgSearch->IsWindowVisible()) {
//			if(m_dlgFind.IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
//				m_pMainWindow->SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
//			else
				::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
		}
	}
}

///	[ubN}[N̐ݒ/]
void CAlphaApp::OnFindToggleBookmark() {
	if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		if(CAlphaView* pActiveView = pActiveEditor->GetPrimaryView())
			pActiveView->ExecCommand(CMDID_BOOKMARK_TOGGLE);
	}
}

///	[o[W] _CAO̕\
void CAlphaApp::OnHelpAbout() {
	CAboutDlg	dlg;
	dlg.Create(m_hInstance, IDD_DLG_ABOUT, /*m_pMainWindow->GetSafeHwnd()*/0);
	dlg.DoModal();
}

///	@see	IEditViewEventListener::OnIncrementalSearchEvent
void CAlphaApp::OnIncrementalSearchEvent(IncrementalSearchEvent event, const char_t* pwsz) {
	if(event == ISE_ABORTED || event == ISE_COMPLETED) {
		m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
		if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1)))
			m_statusBar.SetFont(0);
	} else if(event == ISE_STARTED) {
		if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1)))
			m_statusBar.SetFont(m_hCommonFont);
	} else if(event == ISE_STRING_CHANGED || event == ISE_STRING_NOT_FOUND) {
		const CAlphaView*				pView = m_documents.GetActiveDocument()->GetTextEditor()->GetActiveView();
		const IncrementalSearchState	state = pView->GetIncrementalSearchState();

		if(event == ISE_STRING_NOT_FOUND && pwsz[0] == 0)	// E[
			event = ISE_STRING_CHANGED;
		if(event == ISE_STRING_CHANGED && pwsz[0] == 0)
			m_statusBar.SetText(0,
				LoadString((state == ISS_FORWARD || state == ISS_REGEXP_FORWARD || state == ISS_MIGEMO_FORWARD) ?
					MSG_ISEARCHTEXTISEMPTY : MSG_RISEARCHTEXTISEMPTY).c_str(), SBT_NOBORDERS);
		else {
			UINT	msg;

			if(event == ISE_STRING_CHANGED)
				msg = (state == ISS_FORWARD || state == ISS_REGEXP_FORWARD
						|| state == ISS_MIGEMO_FORWARD) ? MSG_ISEARCHPROMPT : MSG_RISEARCHPROMPT;
			else
				msg = (state == ISS_FORWARD || state == ISS_REGEXP_FORWARD
						|| state == ISS_MIGEMO_FORWARD) ? MSG_ISEARCHNOTFOUNDPROMPT : MSG_RISEARCHNOTFOUNDPROMPT;

			string_t	strPrompt = LoadString(msg, __MARGS__ % pwsz);
			length_t	iTab = 0;
			while(string_t::npos != (iTab = strPrompt.find(L'\t', iTab))) {
				strPrompt[iTab] = L' ';
				++iTab;
			}
			m_statusBar.SetText(0, strPrompt.c_str(), SBT_NOBORDERS);
		}
	} else if(event == ISE_BAD_REGEXP || event == ISE_REGEXP_ERROR) {
		const CAlphaView*				pView = m_documents.GetActiveDocument()->GetTextEditor()->GetActiveView();
		const IncrementalSearchState	state = pView->GetIncrementalSearchState();
		UINT							msg;

		if(pwsz[0] == 0)
			msg = MSG_ISEARCHTEXTISEMPTY;
		else if(state == ISS_REGEXP_FORWARD)
			msg = MSG_ISEARCHBADREGEXP;
		else
			msg = MSG_RISEARCHBADREGEXP;

		string_t	strPrompt = LoadString(msg, __MARGS__ % pwsz);
		length_t	iTab = 0;
		while(string_t::npos != (iTab = strPrompt.find(L'\t', iTab))) {
			strPrompt[iTab] = L' ';
			++iTab;
		}
		m_statusBar.SetText(0, strPrompt.c_str(), SBT_NOBORDERS);
	}
}

///	@see	IEditViewEventListener::OnInvokeUriLink
void CAlphaApp::OnInvokeUriLink(const char_t* pwszUri) {
	::ShellExecuteW(0, 0, pwszUri, 0, 0, SW_SHOWNORMAL);
}

///	[ʐݒ] _CAO̕\
void CAlphaApp::OnToolCommonOption() {
/*	CCommonOptionSheet	oSheet(L"ʐݒ(܂܂)", m_pMainWindow->m_hWnd);
	CFileOptionDlg		oFileOptionPG;
	CEditOptionDlg		oEditOptionPG;
	CFindOptionDlg		oFindOptionPG;
	CViewOptionDlg		oViewOptionPG;
	CStyleOptionDlg		oStyleOptionPG;
	CKeyBindsOptionDlg	oKeyBindsOptionPG(this, &m_oKeyboardMap);
	CCodePageOptionDlg	oCodePagesOptionPG;
	CScriptOptionDlg	oScriptOptionPG(&m_oScriptLanguages);

	// [t@C] ^u
	oFileOptionPG.m_nShareMode = GetProfileInt(L"File", L"shareMode", 1);
	oFileOptionPG.m_bWriteBOMAsUTF8 = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
	oFileOptionPG.m_bWriteBOMAsUTF16LE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF16BE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16BE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF32LE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF32BE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
	oFileOptionPG.m_bWriteBOMAsISO2022CN = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022CN", 0));
	oFileOptionPG.m_bWriteBOMAsISO2022KR = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022KR", 0));
	oFileOptionPG.m_bUseSystemACP = toBoolean(GetProfileInt(L"File", L"bUseSystemCP", 1));
	oFileOptionPG.m_nCustomCP = GetProfileInt(L"File", L"nCustomCP", 65001);
	oFileOptionPG.m_breakType = static_cast<BreakType>(GetProfileInt(L"File", L"nBreakType", BT_CRLF));
	oFileOptionPG.m_bAutoSave = toBoolean(GetProfileInt(L"File", L"bUseAutoSave", 0));
	oFileOptionPG.m_nInterval = GetProfileInt(L"File", L"nAutoSaveInterval", 300);
	oFileOptionPG.m_nMRULimit = GetProfileInt(L"File", L"mruLimit", 8);
	oFileOptionPG.m_bSendAsAttachment = toBoolean(GetProfileInt(L"File", L"sendMailAsAttachment", 1));
	oFileOptionPG.Construct(IDD_DLGPAGE_OPTION_FILE, L"t@C");
	oSheet.AddPage(&oFileOptionPG);

	// [ҏW] ^u
	oEditOptionPG.m_bCancelAfterCopy = m_bCancelSelAfterCopy;
	oEditOptionPG.m_bUseCurrentBreak = toBoolean(GetProfileInt(L"Edit", L"bUseCurrentBreakAsCopy", 0));
	oEditOptionPG.m_bLimitUndoHistory = toBoolean(GetProfileInt(L"Edit", L"bLimitUndoHistoryLength", 0));
	oEditOptionPG.m_bConcatSuccessiveChars = toBoolean(GetProfileInt(L"Edit", L"bConcatSuccessiveChars", 1));
	oEditOptionPG.m_nUndoLimit = GetProfileInt(L"Edit", L"nUndoLimit", 100);
	oEditOptionPG.Construct(IDD_DLGPAGE_OPTION_EDIT, L"ҏW");
	oSheet.AddPage(&oEditOptionPG);

	// [] ^u
	oFindOptionPG.m_bShowMessageBox = m_bShowMessageBoxOnFind;
	oFindOptionPG.m_bInitializeFromEditor = m_bInitializeFindTextFromEditor;
	oFindOptionPG.Construct(IDD_DLGPAGE_OPTION_FIND, L"");
	oSheet.AddPage(&oFindOptionPG);

	// [\] ^u
	oViewOptionPG.m_bVisibleToolbar = toBoolean(::IsWindowVisible(m_hRebar));
	oViewOptionPG.m_bVisibleStatusBar = toBoolean(::IsWindowVisible(m_hStatusBar));
	oViewOptionPG.m_nLeftMargin = m_nLeftMargin;
	oViewOptionPG.m_nTopMargin = m_nTopMargin;
	oViewOptionPG.m_nStartupWindowPos = GetProfileInt(L"View", L"nStartupWindowPos", 0);
	if(!GetProfileStruct(L"View", L"rectSpecified", &oViewOptionPG.m_rectSpecifiedWindow, sizeof(RECT)))
		::SetRect(&oViewOptionPG.m_rectSpecifiedWindow, 0, 0, 760, 480);
	oViewOptionPG.Construct(IDD_DLGPAGE_OPTION_VIEW, L"\");
	oSheet.AddPage(&oViewOptionPG);

	// [X^C] ^u
	oStyleOptionPG.m_vecDocStyles = m_vecDocStyleTypes;
	oStyleOptionPG.Construct(IDD_DLGPAGE_OPTION_STYLE, L"X^C");
	oSheet.AddPage(&oStyleOptionPG);

	// [L[蓖] ^u
	oKeyBindsOptionPG.Construct(IDD_DLGPAGE_OPTION_KEYBINDS, L"L[蓖");
	oSheet.AddPage(&oKeyBindsOptionPG);

	// [R[hy[W]
	oCodePagesOptionPG.Construct(IDD_DLGPAGE_OPTION_CODEPAGE, L"R[hy[W");
	oSheet.AddPage(&oCodePagesOptionPG);

	// [XNvg] ^u
	oScriptOptionPG.Construct(IDD_DLGPAGE_OPTION_SCRIPT, L"XNvg");
	oSheet.AddPage(&oScriptOptionPG);

	if(oSheet.DoModal() == IDOK) {	// ݒ INI t@Cɕۑ
		WriteProfileInt(L"File", L"shareMode", oFileOptionPG.m_nShareMode);
		WriteProfileInt(L"File", L"bUseAutoSave", oFileOptionPG.m_bAutoSave);
		WriteProfileInt(L"File", L"nAutoSaveInterval", oFileOptionPG.m_nInterval);
		WriteProfileInt(L"File", L"writeBomAsUTF8", oFileOptionPG.m_bWriteBOMAsUTF8 ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF16LE", oFileOptionPG.m_bWriteBOMAsUTF16LE ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF16BE", oFileOptionPG.m_bWriteBOMAsUTF16BE ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF32LE", oFileOptionPG.m_bWriteBOMAsUTF32LE ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF32BE", oFileOptionPG.m_bWriteBOMAsUTF32BE ? 1 : 0);
		WriteProfileInt(L"File", L"mruLimit", oFileOptionPG.m_nMRULimit);
		WriteProfileInt(L"File", L"sendMailAsAttachment", oFileOptionPG.m_bSendAsAttachment ? 1 : 0);

		WriteProfileInt(L"Edit", L"bCancelSelectionAfterCopy", oEditOptionPG.m_bCancelAfterCopy);

		WriteProfileInt(L"View", L"nLeftMargin", oViewOptionPG.m_nLeftMargin);
		WriteProfileInt(L"View", L"nTopMargin", oViewOptionPG.m_nTopMargin);
		WriteProfileInt(L"View", L"bVisibleToolbar", oViewOptionPG.m_bVisibleToolbar);
		WriteProfileInt(L"View", L"bVisibleStatusBar", oViewOptionPG.m_bVisibleStatusBar);

		WriteProfileInt(L"Find", L"bShowMessageBox", oFindOptionPG.m_bShowMessageBox ? 1 : 0);
		WriteProfileInt(L"Find", L"bInitializeFromEditor", oFindOptionPG.m_bInitializeFromEditor ? 1 : 0);

		if(oFileOptionPG.m_bClearedMRU)
			m_pMRUManager->Clear();

		LoadINISettings();	// INI t@C̐ݒAvP[Vɔf
	}*/
}

///	[c[]-[fobO]-[u[N|Cg̊Ǘ]
void CAlphaApp::OnToolDebugBreakPoints() {
/*	BreakPointList							listBreakPoints;
	list<TAppDefinedLine>					listLineAttrs;
	list<TAppDefinedLine>::const_iterator	it;

	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		// AvP[Vsu[N|Cgɕϊ
		CAlphaView*		pActiveView = pActiveEditor->GetPrimaryView();
		TBreakPointInfo	bpi;

		pActiveView->GetAllLineParams(listLineAttrs);
		for(it = listLineAttrs.begin(); it != listLineAttrs.end(); ++it) {
			if(it->dwParam & LA_BREAKPOINT_ENABLED)
				bpi.bEnabled = true;
			else if(it->dwParam & LA_BREAKPOINT_DISABLED)
				bpi.bEnabled = false;
			else
				continue;
			bpi.iLine = it->iLine;
			listBreakPoints.push_back(bpi);
		}

		m_pdlgDebugBreakPoints->m_listBreakPoints = listBreakPoints;
		if(IDOK == m_pdlgDebugBreakPoints->DoModal()) {
			// u[N|Cgݒ肵
			unsigned long	cLines = pActiveView->GetDocument()->GetLineCount();

			for(unsigned long iLine = 0; iLine < cLines; ++iLine)	// xSĉ
				pActiveView->SetLineParam(iLine, LA_NONE, LA_BREAKPOINT_MASK);
			for(BreakPointList::const_iterator it
					= m_pdlgDebugBreakPoints->m_listBreakPoints.begin();
					it != m_pdlgDebugBreakPoints->m_listBreakPoints.end(); ++it)	// ݒ肷
				pActiveView->SetLineParam(it->iLine, it->bEnabled ?
					LA_BREAKPOINT_ENABLED : LA_BREAKPOINT_DISABLED, LA_BREAKPOINT_MASK);
		}
	}*/
}


///	[c[]-[fobO]-[R[X^bN]
void CAlphaApp::OnToolDebugCallStack() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugCallStack->IsWindow()) {
			m_pdlgDebugCallStack->DoModeless();
			m_pdlgDebugCallStack->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[C~fBGCg]
void CAlphaApp::OnToolDebugImmediate() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugImmediate->IsWindow()) {
			m_pdlgDebugImmediate->DoModeless();
			m_pdlgDebugImmediate->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[u[N|Cg̑}//폜]
void CAlphaApp::OnToolDebugInsertBreakPoint() {
/*	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		CCharPos	posBegin, posEnd;
		CAlphaView*	pView = pActiveEditor->GetPrimaryView();
		DWORD		dwLineAttr;

		pView->GetSel(posBegin, posEnd);
		dwLineAttr= pView->GetLineParam(posEnd.m_iLine);
		if(toBoolean(dwLineAttr & LA_BREAKPOINT_ENABLED)) {	// L -> 
			dwLineAttr &= ~LA_BREAKPOINT_ENABLED;
			dwLineAttr |= LA_BREAKPOINT_DISABLED;
		} else if(toBoolean(dwLineAttr & LA_BREAKPOINT_DISABLED))	//  -> 폜
			dwLineAttr &= ~LA_BREAKPOINT_DISABLED;
		else	//  -> L
			dwLineAttr |= LA_BREAKPOINT_ENABLED;
		pView->SetLineParam(posEnd.m_iLine, dwLineAttr);
	}*/
}

///	[c[]-[fobO]-[Jn]
void CAlphaApp::OnToolDebugStart() {
/*	if(GetActiveTab()->GetTextEditor() == 0)
		return;
	if(m_pActiveDebugger != 0) {	// fobOłΑs
		m_pActiveDebugger->Continue();
		return;
	}

	Alpha::BreakPointList	listBreakPoints;
	list<TAppDefinedLine>	listLines;
	CAlphaDoc*				pActiveDoc = GetActiveTab()->GetTextEditor()->GetDocument();
	Alpha::TBreakPointInfo	bpi;
	wstring					strLanguageName = m_oScriptLanguages.LanguageNameFromExtension(pActiveDoc->GetExtensionName());

	// GWŶꍇ̓_CAOŐu
	if(strLanguageName.empty()) {
		CSelectLanguageDlg	oDlg;

		oDlg.m_setLanguages = m_oScriptLanguages.GetLanguages();
		oDlg.Create(m_hInstance, IDD_DLG_SELECTLANGUAGE, m_pMainWindow->m_hWnd);
		if(IDOK != oDlg.DoModal())
			return;
		strLanguageName = oDlg.m_strSelection;
	}

	// fobOT|[gĂȂꍇɑs邩q˂
	if(!CScriptLanguageManager::QueryDebuggable(strLanguageName)
			&& IDNO == MessageBox(MSG_DEBUG_ENGINENOTSUPPORTDEBUGGING, MB_YESNO | MB_ICONQUESTION))
		return;

	m_pDebuggingEditor = GetActiveTab()->GetTextEditor();
	m_pDebuggingEditor->GetPrimaryView()->GetAllLineParams(listLines);
	for(list<TAppDefinedLine>::const_iterator it = listLines.begin(); it != listLines.end(); ++it) {
		if(it->dwParam & LA_BREAKPOINT_ENABLED)
			bpi.bEnabled = true;
		else if(it->dwParam & LA_BREAKPOINT_DISABLED)
			bpi.bEnabled = false;
		else
			continue;
		bpi.iLine = it->iLine;
		listBreakPoints.push_back(bpi);
	}

	m_pActiveDebugger = new CAlphaApplicationDebugger(m_pMainWindow->m_hWnd, listBreakPoints);
	m_pActiveDebugger->AddRef();
	m_pActiveDebugger->SetEventListener(static_cast<IAlphaApplicationDebuggerEventListener*>(this));
	m_pActiveDebugger->StartDebugging(pActiveDoc, strLanguageName);*/
}

///	[c[]-[fobO]-[Xbh]
void CAlphaApp::OnToolDebugThreads() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugThreads->IsWindow()) {
			CComPtr<IRemoteDebugApplication>	pApplication;
			m_pActiveDebugger->GetDebuggingApplication(&pApplication);
			m_pdlgDebugThreads->DoModeless();
			m_pdlgDebugThreads->Update(pApplication);
		} else
			m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[ϐ]
void CAlphaApp::OnToolDebugVariables() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugVariables->IsWindow()) {
			m_pdlgDebugVariables->DoModeless();
			m_pdlgDebugVariables->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugVariables->SendMessage(WM_CLOSE);
	}*/
}

///	[^Cvʐݒ] _CAO̕\
void CAlphaApp::OnToolDocTypeOption() {
/*	CAlphaDoc*					pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	CPropertySheet		oSheet(L"^Cvʐݒ(܂܂)", m_pMainWindow->m_hWnd);
	CDocTypeOptionDlg	oDocTypeOptionPG;

	oDocTypeOptionPG.m_vecDocTypes = m_vecDocumentTypes;
	oDocTypeOptionPG.m_iActiveType = 0;
	oDocTypeOptionPG.Construct(IDD_DLGPAGE_DOCTYPEOPTION, L"C\ƃCAEg");
	oSheet.AddPage(&oDocTypeOptionPG);

	if(oSheet.DoModal()) {
	}*/
}

///	[s]
void CAlphaApp::OnToolExecute() {
	if(IDocumentContainer*	pActiveContainer = m_documents.GetActiveDocument()) {
		const CAlphaDoc*	pActiveDoc = pActiveContainer->GetTextEditor()->GetDocument();
		wstring				strCommand = m_documentTypes.GetAt(m_documentTypes.Find(pActiveDoc->m_strDocType)).strCommand;
		if(strCommand.empty()) {	// pXݒ肳ĂȂ
			MessageBox(MSG_EXENOTREGISTERED, MB_ICONEXCLAMATION, __MARGS__ % pActiveDoc->m_strDocType);
			return;
		}

		size_t				i = 0;
		bool				bSucceeded;
		STARTUPINFOW		si;
		PROCESS_INFORMATION	pi;

		// '$F' WJ
		while(wstring::npos != (i = strCommand.find(L"$F", i))) {
			strCommand.replace(i, 2, L"\"" + pActiveDoc->GetPathName() + L"\"");
			i += pActiveDoc->GetPathName().length() + 2;
		}
		ZeroMemory(&si, sizeof(STARTUPINFOW));
		si.cb = sizeof(STARTUPINFOW);
		bSucceeded = toBoolean(::CreateProcessW(0,
			const_cast<wchar_t*>(strCommand.c_str()), 0, 0, false, NORMAL_PRIORITY_CLASS, 0, 0, &si, &pi));
		if(!bSucceeded)
			MessageBox(MSG_FAILEDTORUNEXE, MB_ICONEXCLAMATION);
	}
}

///	[R}h̎s]
void CAlphaApp::OnToolExecuteCommand() {
	CExecuteCommandDlg	dlg(this);

	dlg.m_bHijackConsole = toBoolean(GetProfileInt(L"CommandExecuting", L"bHijackConsole", 1));
	dlg.m_bUseUnicode = toBoolean(GetProfileInt(L"CommandExecuting", L"bUseUnicode", 0));
	dlg.Create(m_hInstance, IDD_DLG_EXECUTECOMMAND, m_pMainWindow->GetSafeHwnd());
	dlg.DoModal();
}

///	[tHg] _CAO̕\
void CAlphaApp::OnToolFont() {
	CHOOSEFONTW	cf;
	if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		LOGFONTW	lf;

		::GetObject(m_hCommonFont, sizeof(LOGFONTW), &lf);
		ZeroMemory(&cf, sizeof(CHOOSEFONTW));
		cf.lStructSize = sizeof(CHOOSEFONTW);
		cf.hwndOwner = m_pMainWindow->GetSafeHwnd();
		cf.lpLogFont = &lf;
		cf.lpfnHook = CFHookProc;
		cf.Flags = CF_APPLY | CF_ENABLEHOOK | CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS;
		cf.hInstance = m_hInstance;

		if(toBoolean(::ChooseFontW(&cf)))
			SetFont(lf);
	}
}

///	@see	IDocumentManagerEventListener::OnActivatDocumentChanged
void CAlphaApp::OnActivatDocumentChanged() {
	const size_t	iActiveDoc = m_documents.GetActiveDocumentIndex();
	for(size_t i = 0; i < m_documents.GetCount(); ++i) {
		if(i == iActiveDoc && !m_bufferBar.IsButtonChecked(i + CMD_VIEW_BUFFERLIST_START))
			m_bufferBar.CheckButton(i + CMD_VIEW_BUFFERLIST_START, true);
		else if(i != iActiveDoc && m_bufferBar.IsButtonChecked(i + CMD_VIEW_BUFFERLIST_START))
			m_bufferBar.CheckButton(i + CMD_VIEW_BUFFERLIST_START, false);
	}

	RECT	rect;

	_UpdateTitleBar();
	m_pMainWindow->GetClientRect(rect);
	OnSize(SIZE_RESTORED, rect.right - rect.left, rect.bottom - rect.top);
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();
}

///	@see	IEditViewEventListener::OnChangedAbbreviationExpansionReadyState
void CAlphaApp::OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) {
	if(!m_statusBar.IsWindow())
		return;
	if(bReady) {
		if(const CAlphaEditController* pEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
			if(!strAbbrev.empty()) {
				const wstring	str = LoadString(MSG_INDICATECANEXPANDABBREV,
						__MARGS__ % strAbbrev % CEditView::ExpandAbbreviation(strAbbrev));
				m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
			}
		}
	} else
		m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
}

///	@see	IClipboardRingEventListener::OnClipboardRingChanged
void CAlphaApp::OnClipboardRingChanged() {
}

///	@see	IClipboardRingEventListener::OnClipboardRingDeniedAdding
void CAlphaApp::OnClipboardRingDeniedAdding() {
}

///	@see	WM_CLOSE
bool CAlphaApp::OnClose() {
	DISPPARAMS	params = {0, 0, 0, 0};
	m_pEventHandlerScript->Invoke(OLESTR("OnApplicationTerminating"), &params);
	if(OnFileCloseAll(false)) {
		_SaveINISettings();
		m_pMainWindow->DestroyWindow();
		return true;
	}
	return false;	// [ULZ
}

///	@see	CWindow::OnCommand
bool CAlphaApp::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == CMD_SPECIAL_ILLEGAL2STROKE) {
		::MessageBeep(MB_OK);
		return true;
	} else if(wID >= CMD_VIEW_BUFFERLIST_START && wID < CMD_VIEW_BUFFERLIST_END) {
		if(m_pCommandManager->IsEnabled(wID, true))
			m_documents.SetActiveDocument(wID - CMD_VIEW_BUFFERLIST_START);
	} else
		m_pCommandManager->ExecuteCommand(static_cast<CommandId>(wID), true);

/*	case CMD_DEBUG_START:	// [fobO]-[Jn/s]
		OnToolDebugStart();
		break;
	case CMD_DEBUG_STOP:	// [fobO]-[~]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->Abort();
		break;
	case CMD_DEBUG_STEPOVER:	// [fobO]-[XebvI[o[]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOver();
		break;
	case CMD_DEBUG_STEPINTO:	// [fobO]-[XebvC]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepInto();
		break;
	case CMD_DEBUG_STEPOUT:	// [fobO]-[XebvAEg]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOut();
		break;
	case CMD_DEBUG_INSERTBREAKPOINT:	// [fobO]-[u[N|Cg̑}/폜]
		OnToolDebugInsertBreakPoint();
		break;
	case CMD_DEBUG_BREAKPOINTS:		// [fobO]-[u[N|Cg̊Ǘ]
		OnToolDebugBreakPoints();
		break;
	case CMD_DEBUG_ACTIVEDOCUMENTS:	// [fobO]-[s̃hLg]
		if(m_pdlgDebugRunningDocuments->IsWindowVisible())
			m_pdlgDebugRunningDocuments->SendMessage(WM_CLOSE);
		else
			m_pdlgDebugRunningDocuments->DoModeless();
		break;
	case CMD_DEBUG_CALLSTACK:	// [fobO]-[Ăяo]
		OnToolDebugCallStack();
		break;
	case CMD_DEBUG_IMMEDIATE:	// [fobO]-[C~fBGCg]
		OnToolDebugImmediate();
		break;
	case CMD_DEBUG_THREADS:	// [fobO]-[Xbh]
		OnToolDebugThreads();
		break;
	case CMD_DEBUG_VARIABLES:	// [fobO]-[ϐ]
		OnToolDebugVariables();
		break;*/

	return true;
}

///	@see	WM_COPYDATA
void CAlphaApp::OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds) {
	vector<wstring>	vecArguments;
	GetCommandLineArguments(static_cast<wchar_t*>(pcds->lpData), vecArguments);
	vecArguments.erase(vecArguments.begin());
	ParseCommandLine(vecArguments);
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugEnd
/*void CAlphaApp::OnDebugEnd() {
	if(m_pActiveDebugger != 0) {
		m_pActiveDebugger->Release();
		m_pActiveDebugger = 0;
		m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(-1);
		m_pDebuggingEditor->GetDocument()->SetReadOnly(false);
		m_pDebuggingEditor = 0;
		m_wndOutput.WriteLine(OTT_DEBUG, L"fobOI܂ ----------------\r\n");

		// fobO_CAOЕt
		if(m_pdlgDebugCallStack->IsWindow())	m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
		if(m_pdlgDebugImmediate->IsWindow())	m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
		if(m_pdlgDebugVariables->IsWindow())	m_pdlgDebugVariables->SendMessage(WM_CLOSE);
		if(m_pdlgDebugThreads->IsWindow())		m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugIllegalStatus
void CAlphaApp::OnDebugIllegalStatus(DebugStatus ds) {
	wstring	strPrompt;

	switch(ds) {
	case DS_OK:
		return;
	case DS_FAILEDTOGETPDM:
		MessageBox(MSG_DEBUG_FAILEDTOGETPDM, MB_ICONEXCLAMATION);
		break;
	case DS_UNKNOWNSCRIPTLANGUAGE:
		MessageBox(MSG_DEBUG_INVALIDLANGUAGENAME, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTPARSER:
		MessageBox(MSG_DEBUG_ENGINENOTSUPPORTPARSING, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTDEBUGGING:
		return;
//		strPrompt = IDS_SENOTSUPPORTDEBUG;
//		break;
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStart
void CAlphaApp::OnDebugStart() {
	m_pDebuggingEditor->GetDocument()->SetReadOnly(true);
	m_wndOutput.Clear(OTT_DEBUG);
	m_wndOutput.WriteLine(OTT_DEBUG, L"fobOJn܂ ----------------");
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStepTo
void CAlphaApp::OnDebugStepTo(unsigned long iLine) {
	if(m_pDebuggingEditor == 0)
		return;
	m_pDebuggingEditor->GetActiveView()->SetSelWithoutSelection(iLine, 0);
	m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(iLine);

	// fobO_CAO̍XV
	if(m_pdlgDebugCallStack->IsWindow())
		m_pdlgDebugCallStack->Update(m_pActiveDebugger);
	if(m_pdlgDebugVariables->IsWindow())
		m_pdlgDebugVariables->Update(m_pActiveDebugger);
	if(m_pdlgDebugThreads->IsWindow()) {
		CComPtr<IRemoteDebugApplication>	pApplication;
		m_pActiveDebugger->GetDebuggingApplication(&pApplication);
		m_pdlgDebugThreads->Update(pApplication);
	}

	// fobÕhLgANeBuɂ
	if(GetActiveTab()->GetTextEditor() != m_pDebuggingEditor) {
		for(unsigned int iTab = 0; iTab < m_vecDocuments.size(); ++iTab) {
			if(CAlphaEditController* pEditor = m_vecDocuments[iTab]->GetTextEditor()) {
				if(pEditor == m_pDebuggingEditor) {
					SetActiveTab(iTab);
					break;
				}
			}
		}
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopAtBreakPoint
void CAlphaApp::OnDebugStopAtBreakPoint(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"u[N|CgŒ~܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopByError
void CAlphaApp::OnDebugStopByError(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"^CG[܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}*/

///	@see	CWindow::OnDestroy
void CAlphaApp::OnDestroy() {
	// nȂ (CAlphaApp::OnClose Q)
	m_pMainWindow->KillTimer(ID_TIMER_QUERYCOMMAND);

	delete m_pMenu;
	delete m_pMRUManager;
//	m_toolbar.DestroyWindow();
//	m_bufferBar.DestroyWindow();
//	m_statusBar.DestroyWindow();

	// hLgSĔj
	for(size_t i = m_documents.GetCount(); i != 0; --i)
		m_documents.GetDocument(i - 1)->DeleteInstance();

	::PostQuitMessage(0);	// STA XbhI
}

///	@see	IEditDocEventListener::OnDocumentFoundUnconvertableChar
bool CAlphaApp::OnDocumentFoundUnconvertableChar() {
	return true;
}

///	@see	IEditDocEventListener::OnDocumentLoaded
void CAlphaApp::OnDocumentLoaded() {
	ApplyDocumentType(m_documents.GetActiveDocumentIndex());
}

///	@see	IEditDocEventListener::OnDocumentModified
void CAlphaApp::OnDocumentModified() {
	_UpdateTitleBar();
}

///	@see	IEditDocEventListener::OnDocumentOverwrittenByOtherProcess
void CAlphaApp::OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument) {
	if(IDYES == MessageBox(MSG_FILEHASBEENMODIFIEDBYOTHER,
			MB_YESNO | MB_ICONQUESTION, __MARGS__ % pDocument->GetPathName())) {
		size_t	i = 0;
		while(true) {
			if(i == m_documents.GetCount())
				return;	// ...
			if(m_documents.GetDocument(i) == reinterpret_cast<CAlphaEditController*>(pDocument->GetController()))
				break;
			++i;
		}
		m_documents.SetActiveDocument(i);
		OnFileReopen();
	}
}

///	@see	IEditViewEventListener::OnDrawIndicatorMargin
void CAlphaApp::OnDrawIndicatorMargin(length_t iLine,
		CDC<>& dc, const RECT& rcMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) {
	CPen	pen;
	CBrush	brush;
	HPEN	hOldPen;
	HBRUSH	hOldBrush;
	int		nMinWidth = min(rcMargin.right - rcMargin.left, rcMargin.bottom - rcMargin.top);

	nMinWidth -= (nMinWidth + 1) % 2;	// ~ȂȂ悤ɓK...

	if(toBoolean(dwParam & LA_BREAKPOINT_ENABLED)) {	// Lȃu[N|Cg
		RECT	rcCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		pen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		brush.CreateSolidBrush(RGB(0x80, 0x00, 0x00));
		hOldPen = dc.SelectObject(pen);
		hOldBrush = dc.SelectObject(brush);
		::OffsetRect(&rcCircle,
			rcMargin.left + (rcMargin.right - rcMargin.left) / 2 - nMinWidth / 2,
			rcMargin.top + (rcMargin.bottom - rcMargin.top) / 2 - nMinWidth / 2);
		dc.Ellipse(rcCircle);
		dc.SelectObject(hOldPen);
		dc.SelectObject(hOldBrush);
	} else if(toBoolean(dwParam & LA_BREAKPOINT_DISABLED)) {	// ȃu[N|Cg
		RECT	rcCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		pen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		brush.CreateSolidBrush(RGB(0xFF, 0xF9, 0xF9));
		hOldPen = dc.SelectObject(pen);
		hOldBrush = dc.SelectObject(brush);
		::OffsetRect(&rcCircle,
			rcMargin.left + (rcMargin.right - rcMargin.left) / 2 - nMinWidth / 2,
			rcMargin.top + (rcMargin.bottom - rcMargin.top) / 2 - nMinWidth / 2);
		dc.Ellipse(rcCircle);
		dc.SelectObject(hOldPen);
		dc.SelectObject(hOldBrush);
	}
	if(bSingleEmphasis) {	// fobOg[Xs
		// TODO: fobOg[Xs̖`
	}
}

///	@see	WM_DRAWITEM
void CAlphaApp::OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem) {
	CDC<>		dc;
	const RECT&	rcItem = lpDrawItem->rcItem;
	RECT		rcCaption;
	HPEN		hOldPen, hPen;
	HBRUSH		hOldBrush, hBrush;
	wchar_t*	pszCaption = 0;
	wchar_t*	pszAccel = 0;	// ANZ[^At@C

	const bool	bChecked = toBoolean(lpDrawItem->itemState & ODS_CHECKED);
	const bool	bDisabled = toBoolean(lpDrawItem->itemState & ODS_DISABLED);
	const bool	bSelected = toBoolean(lpDrawItem->itemState & ODS_SELECTED);

	dc.Attach(lpDrawItem->hDC);

	if(lpDrawItem->CtlType == ODT_MENU) {	// j[̕`
		const CommandId	id = lpDrawItem->itemID;
		const COLORREF	clrHighlight = ::GetSysColor(COLOR_HIGHLIGHT);
		const COLORREF	clrHighlightBack = RGB(GetRValue(clrHighlight) / 3 + 170,
										GetGValue(clrHighlight) / 3 + 170, GetBValue(clrHighlight) / 3 + 170);
		const COLORREF	clrHighlightIconBack = RGB((GetRValue(clrHighlightBack) + 0xFF) / 2,
										(GetGValue(clrHighlightBack) + 0xFF) / 2, (GetBValue(clrHighlightBack) + 0xFF) / 2);

		// wi̕`
		if(bSelected) {
			hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
			hBrush = ::CreateSolidBrush(clrHighlightBack);
			hOldPen = dc.SelectObject(hPen);
			hOldBrush = dc.SelectObject(hBrush);
			dc.Rectangle(rcItem);
			dc.SelectObject(hOldPen);
			dc.SelectObject(hOldBrush);
			::DeleteObject(hPen);
			::DeleteObject(hBrush);
		} else {
			dc.FillSolidRect(rcItem, ::GetSysColor(COLOR_MENU));
//			dc.FillSolidRect(rcItem.left, rcItem.top,
//				rcItem.bottom - rcItem.top, rcItem.bottom - rcItem.top,
//				::GetSysColor(COLOR_3DFACE));
		}

		if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {	// MRU Xg
			const wchar_t*	pwszNumber = _GetMenuLabel(id);
			const wchar_t*	pwszFilePath = wcsstr(pwszNumber, L"  ") + 2;
			const wchar_t*	pwszFileName = ::PathFindFileNameW(pwszFilePath);
			rcCaption = rcItem;
			rcCaption.left += 14;
			rcCaption.right -= 14;
			dc.SetBkMode(TRANSPARENT);

			// ԍ̕`
			dc.DrawText(pwszNumber, pwszFilePath - pwszNumber, rcCaption, DT_SINGLELINE | DT_VCENTER);
			dc.DrawText(pwszNumber, pwszFilePath - pwszNumber, rcCaption, DT_CALCRECT | DT_SINGLELINE | DT_VCENTER);
			::SetRect(&rcCaption, rcCaption.right, rcItem.top, rcItem.right, rcItem.bottom);

			// pX̕`
			if(pwszFilePath != pwszFileName) {
				dc.DrawText(pwszFilePath, pwszFileName - pwszFilePath, rcCaption, DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
				dc.DrawText(pwszFilePath, pwszFileName - pwszFilePath, rcCaption, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
				::SetRect(&rcCaption, rcCaption.right, rcItem.top, rcItem.right, rcItem.bottom);
			}

			// t@C̕`
			dc.DrawText(pwszFileName, -1, rcCaption, DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
			dc.DrawText(pwszFileName, -1, rcCaption, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);

			// t@C̉ɉ
			HPEN	hPen = ::CreatePen(PS_SOLID, 1, dc.GetTextColor());
			HPEN	hOldPen = dc.SelectObject(hPen);
			dc.MoveTo(rcCaption.left, rcCaption.bottom - 1);
			dc.LineTo(rcCaption.right, rcCaption.bottom - 1);
			dc.SelectObject(hOldPen);
			::DeleteObject(hPen);
		} else {
			// ACR̕`
			const bool		bIsBuffers = id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END;
			HIMAGELIST		hIconsEnabled = !bIsBuffers ? m_pCommandManager->GetImageList(true) : m_documents.GetImageList();
			HIMAGELIST		hIconsDisabled = !bIsBuffers ? m_pCommandManager->GetImageList(false) : 0;
			const size_t	iIcon = !bIsBuffers ? m_pCommandManager->GetIconIndex(id) : id - CMD_VIEW_BUFFERLIST_START;
			RECT			rcIcon;

			rcIcon.left = rcItem.left + (rcItem.bottom - rcItem.top - 16) / 2 - 1;
			rcIcon.top = rcItem.top + (rcItem.bottom - rcItem.top - 16) / 2 - 1;
			rcIcon.right = rcIcon.left + 18;
			rcIcon.bottom = rcIcon.top + 18;
			if((hIconsEnabled != 0 && iIcon != -1) || bIsBuffers) {	// ACRpłꍇ
				if(bChecked) {	// `FbN
					hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
					hBrush = ::CreateSolidBrush(clrHighlightIconBack);
					hOldPen = dc.SelectObject(hPen);
					hOldBrush = dc.SelectObject(hBrush);
					dc.Rectangle(rcIcon);
					dc.SelectObject(hOldPen);
					dc.SelectObject(hOldBrush);
					::DeleteObject(hPen);
					::DeleteObject(hBrush);
				}
				::InflateRect(&rcIcon, -1, -1);
				if(bDisabled)	// 
					::ImageList_Draw(hIconsDisabled, iIcon, dc, rcIcon.left, rcIcon.top, ILD_NORMAL);
//				else if(bSelected)	// I
//					::ImageList_Draw(hIconsEnabled, iIcon, dc, rcIcon.left, rcIcon.top, ILD_FOCUS);
				else	// L
					::ImageList_Draw(hIconsEnabled, iIcon, dc, rcIcon.left, rcIcon.top, ILD_NORMAL);
				::InflateRect(&rcIcon, 1, 1);
			} else if(bChecked) {
				const int	nCheckBoxWidth = rcItem.bottom - rcItem.top;
				hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
				hBrush = ::CreateSolidBrush(clrHighlightIconBack);
				hOldPen = dc.SelectObject(hPen);
				hOldBrush = dc.SelectObject(hBrush);
				dc.Rectangle(rcItem.left + 1, rcItem.top + 1, rcItem.left + rcItem.bottom - rcItem.top - 1, rcItem.bottom - 1);
				dc.SelectObject(hOldPen);
				dc.SelectObject(hOldBrush);
				::DeleteObject(hPen);
				::DeleteObject(hBrush);
				hPen = ::CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));	// v񂩂?
				hOldPen = dc.SelectObject(hPen);
				dc.MoveTo(rcItem.left + nCheckBoxWidth / 2 - 3, rcItem.top + nCheckBoxWidth / 2 - 1);	// `FbN}[N
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 - 1, rcItem.top + nCheckBoxWidth / 2 + 1);
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 + 4, rcItem.top + nCheckBoxWidth / 2 - 4);
				dc.MoveTo(rcItem.left + nCheckBoxWidth / 2 - 3, rcItem.top + nCheckBoxWidth / 2 + 0);
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 - 1, rcItem.top + nCheckBoxWidth / 2 + 2);
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 + 4, rcItem.top + nCheckBoxWidth / 2 - 3);
				dc.SelectObject(hOldPen);
				::DeleteObject(hPen);
			}

			if(id == 0	// ؂̕`
					&& (lpDrawItem->itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(lpDrawItem->itemData)) == 0)) {
				HPEN	hOldPen = dc.SelectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DSHADOW)));

				dc.MoveTo(lpDrawItem->rcItem.left + 1, lpDrawItem->rcItem.top + 1);
				dc.LineTo(lpDrawItem->rcItem.right - 1, lpDrawItem->rcItem.top + 1);
				::DeleteObject(dc.SelectObject(hOldPen));
				dc.SelectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DHIGHLIGHT)));
				dc.MoveTo(lpDrawItem->rcItem.left + 1, lpDrawItem->rcItem.top + 2);
				dc.LineTo(lpDrawItem->rcItem.right - 1, lpDrawItem->rcItem.top + 2);
				::DeleteObject(dc.SelectObject(hOldPen));
			} else {	// LvV̕`
				dc.SetBkMode(TRANSPARENT);
				rcCaption = lpDrawItem->rcItem;
		//		if(reinterpret_cast<HMENU>(lpDrawItem->hwndItem) != m_pMenu->GetSafeHmenu()) {
					COLORREF	clrCaption = ::GetSysColor(bDisabled ? COLOR_GRAYTEXT : COLOR_MENUTEXT);
					const wchar_t*	pwszOrgCaption = (lpDrawItem->itemData == 0) ?
						_GetMenuLabel(lpDrawItem->itemID) : reinterpret_cast<const wchar_t*>(lpDrawItem->itemData);
					if(id != 0 && m_pCommandManager->GetLastCommand() == id)
						clrCaption = RGB(GetRValue(clrCaption),
							(GetGValue(clrCaption) + 0xFF) / 2, GetBValue(clrCaption));
					dc.SetTextColor(clrCaption);
					rcCaption.left = rcIcon.right + 6;
					rcCaption.right -= 6;
					pszCaption = new wchar_t[wcslen(pwszOrgCaption) + 1];
					wcscpy(pszCaption, pwszOrgCaption);
					pszAccel = wcschr(pszCaption, L'\t');
					if(pszAccel != 0) {
						*pszAccel = 0;
						dc.DrawText(pszCaption, -1, rcCaption, DT_SINGLELINE | DT_VCENTER);
						dc.DrawText(pszAccel + 1, -1, rcCaption, DT_RIGHT | DT_SINGLELINE | DT_VCENTER);
					} else
						dc.DrawText(pszCaption, -1, rcCaption, DT_SINGLELINE | DT_VCENTER);
					delete[] pszCaption;
		//		} else {	// j[o[̏ꍇ
		//			if(lpDrawItem->itemState & ODS_SELECTED || lpDrawItem->itemState & ODS_HOTLIGHT) {
		//				dc.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_HIGHLIGHT));
		//				dc.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
		//			} else {
		//				dc.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_BTNFACE));
		//				dc.SetTextColor(::GetSysColor(COLOR_MENUTEXT));
		//			}
		//			dc.DrawText(reinterpret_cast<const wchar_t*>(lpDrawItem->itemData),
		//				-1, &rectCaption, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
		//		}
			}
		}
	}
	dc.Detach();
}

///	@see	WM_DROPFILES
void CAlphaApp::OnDropFiles(HDROP hDrop) {
	const unsigned int	cFiles = ::DragQueryFileW(hDrop, 0xFFFFFFFF, 0, 0);
	wchar_t				wszFilePath[MAX_PATH];

	for(unsigned int iFile = 0; iFile < cFiles; ++iFile) {
		::DragQueryFileW(hDrop, iFile, wszFilePath, MAX_PATH);
		OpenFile(wszFilePath);
	}
	::DragFinish(hDrop);

	HWND hWnd = m_documents.GetActiveDocument()->GetWindow();
	if(toBoolean(::IsWindow(hWnd)))
		::SetFocus(hWnd);
}

///	@see	WM_ENTERMENULOOP
void CAlphaApp::OnEnterMenuLoop(bool bIsTrackPopup) {
	m_statusBar.SetSimple(true);
}

///	@see	WM_EXITMENULOOP
void CAlphaApp::OnExitMenuLoop(bool bIsTrackPopup) {
	m_statusBar.SetSimple(false);
}

///	@see	WM_INITMENU
void CAlphaApp::OnInitMenu(HMENU hMenu) {
	// j[ACe̗L//`FbN

	// ͑1Kŵ
	for(int j = 0; j < m_pMenu->GetItemCount(); ++j) {
		CMenu		menu = m_pMenu->GetSubMenu(j);
		const int	cItems = menu.GetItemCount();

		for(int i = 0; i < cItems; ++i) {
			if(menu.HasSubMenu(i)) {
				CMenu		subMenu = menu.GetSubMenu(i);
				const int	cItems = subMenu.GetItemCount();

				for(int i = 0; i < cItems; ++i) {
					const CommandId	id = subMenu.GetMenuItemID(i);
					subMenu.EnableMenuItem(id, m_pCommandManager->IsEnabled(id, true));
					subMenu.CheckMenuItem(id, m_pCommandManager->IsChecked(id));
				}
			} else {
				const CommandId	id = menu.GetMenuItemID(i);
				menu.EnableMenuItem(id, m_pCommandManager->IsEnabled(id, true));
				menu.CheckMenuItem(id, m_pCommandManager->IsChecked(id));
			}
		}
	}

	// [ŋߎgt@C]
	m_pMenu->GetSubMenu(0).SetChildPopup(*m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);

	// obt@o[j[
	m_pBufferBarMenu->EnableMenuItem(CMD_FILE_CLOSEOTHERS, m_documents.GetCount() > 1);

	// t@C
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_RENAME, m_pCommandManager->IsEnabled(CMD_FILE_RENAME, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_COPY, m_pCommandManager->IsEnabled(CMD_FILE_COPY, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_MOVE, m_pCommandManager->IsEnabled(CMD_FILE_MOVE, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_DELETE, m_pCommandManager->IsEnabled(CMD_FILE_DELETE, true));
}

///	@see	WM_INITMENUPOPUP
void CAlphaApp::OnInitMenuPopup(HMENU hMenu, UINT nIndex, bool bSysMenu) {
	// Kp^Cv
	if(m_pAppDocTypeMenu->GetSafeHmenu() == hMenu) {
		const bool	bCtrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		while(m_pAppDocTypeMenu->GetItemCount() > 0)	// ׂč폜
			m_pAppDocTypeMenu->DeleteMenuItem(0, false);
		if(CAlphaEditController* pActiveEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
			for(size_t i = 0; i < m_documentTypes.GetCount(); ++i) {
				const TDocumentType&	type = m_documentTypes.GetAt(i);
				if(type.bPrivate && !bCtrlPressed)
					continue;
				m_pAppDocTypeMenu->AppendMenuItem(
					CMD_TOOL_DOCTYPELIST_START + i, MFT_OWNERDRAW, type.strName.c_str());
			}
			m_pAppDocTypeMenu->CheckMenuItem(
				CMD_TOOL_DOCTYPELIST_START + m_documentTypes.Find(pActiveEditor->GetDocument()->m_strDocType));
		}
	}
	// [obt@] j[ CDocumentManager Ă
}

///	@see	WM_KEYDOWN
bool CAlphaApp::OnKeyDown(UINT nChar, UINT nFlags) {
	KeyModifier	modifiers = 0;
	if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))	modifiers |= KM_CTRL;
	if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))		modifiers |= KM_SHIFT;
	if(toBoolean(::GetKeyState(VK_MENU) & 0x8000))		modifiers |= KM_ALT;
	return _HandleKeyDown(nChar, modifiers);
}

///	@see	IEditViewEventListener::OnMatchBracketFoundOutOfView
void CAlphaApp::OnMatchBracketFoundOutOfView(const CCharPos& pos) {
	if(pos.m_iLine == -1 && pos.m_iChar == -1)
		m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
	else if(const CAlphaEditController* pEditor = m_documents.GetActiveDocument()->GetTextEditor()) {
		const CAlphaDoc*	pDocument = pEditor->GetDocument();
		const CLexer&		lexer = pEditor->GetActiveView()->GetLexer();
		const length_t		cLines = pDocument->GetLineCount();
		CEditView::TOptions	options;
		char_t				wsz[50];

		// Ίʂ̎ӂ\ (NUL ܂ރeLXg͖Ή)
		wsz[0] = 0;
		pEditor->GetActiveView()->GetOptions(options);
		for(length_t iLine = pos.m_iLine; iLine < cLines; ++iLine) {
			const string_t	strLine = pDocument->GetLine(iLine);
			const length_t	cchIndent = lexer.IsWhiteSpace(strLine.c_str(), strLine.length(), true);

			if(iLine == pos.m_iLine) {	// Ίʂ̌s
				// Ίʂ̑O
				if(pos.m_iChar - cchIndent <= 20)
					wcsncat(wsz, strLine.c_str() + cchIndent, pos.m_iChar - cchIndent + 1);
				else {
					wcscpy(wsz, L"... ");
					wcsncat(wsz, strLine.c_str() + pos.m_iChar - 16, 17);
				}
				// ʂ̌
				if(strLine.length() - pos.m_iChar - 1 <= 20)
					wcscat(wsz, strLine.c_str() + pos.m_iChar + 1);
				else {
					wcsncat(wsz, strLine.c_str() + pos.m_iChar + 1, 16);
					wcscat(wsz, L" ...");
					break;
				}
			} else {
				wcscat(wsz, L"^J");	// s
				if(cchIndent != 0)
					wcscat(wsz, L" ");
				if(wcslen(wsz) >= 37) {
					wcscat(wsz, L" ...");
					break;
				}
				if(wcslen(wsz) + strLine.length() - cchIndent >= 41) {
					wcsncat(wsz, strLine.c_str() + cchIndent, 41 - wcslen(wsz));
					wcscat(wsz, L" ...");
					break;
				} else
					wcscat(wsz, strLine.c_str() + cchIndent);
			}

			// Ίʂ̌
		}
		for(char_t* p = wsz; *p != 0; ++p) {
			if(*p == L'\t')
				*p = L' ';
		}
		const wstring	str = LoadString(MSG_MATCHBRACKETOUTOFVIEW,
								__MARGS__ % (pos.m_iLine + options.iStartLine) % wsz);
		m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
	}
}

///	@see	WM_MEASUREITEM
void CAlphaApp::OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI) {
	NONCLIENTMETRICSW	ncm;
	RECT				rect;
	HFONT				hMenuFont, hOldFont;

	// j[
	if(lpMI->CtlType == ODT_MENU) {
		if(lpMI->itemID == 0	// ؂
				&& (lpMI->itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(lpMI->itemData)) == 0)) {
			lpMI->itemHeight = 4;
			lpMI->itemWidth = 30;	// ̒l͑gȂ
		} else {
			// j[̃tHg擾
			ncm.cbSize = sizeof(NONCLIENTMETRICSW);
			::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
			if(lpMI->itemID == CMD_FILE_CLOSE)	// 
				ncm.lfMenuFont.lfWeight = FW_BOLD;
			hMenuFont = ::CreateFontIndirectW(&ncm.lfMenuFont);

			CWindowDC	dc = m_pMainWindow->GetDC();
			hOldFont = static_cast<HFONT>(dc.SelectObject(hMenuFont));
			dc.DrawTextW(lpMI->itemData == 0 ?
				_GetMenuLabel(lpMI->itemID) : reinterpret_cast<wchar_t*>(lpMI->itemData),
				-1, rect, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE);
			dc.SelectObject(hOldFont);
			::DeleteObject(hMenuFont);

			if(lpMI->itemID == 0)	// |bvAbv̏ꍇA̕𑫂
				rect.right += 24;
			if(lpMI->itemID > COMMAND_END) {
				lpMI->itemHeight = rect.bottom - rect.top + 4;
				lpMI->itemWidth = rect.right - rect.left + 28;
			} else {
				lpMI->itemHeight = (rect.bottom - rect.top < 20) ? 20 : rect.bottom - rect.top;
				lpMI->itemWidth = rect.right - rect.left + ((lpMI->itemID >= COMMAND_START) ? 24 : 0);
			}
		}
	}
}

///	@see	WM_MENUCHAR
LRESULT CAlphaApp::OnMenuChar(wchar_t ch, UINT nFlags, CMenu* pMenu) {
	const UINT		cItems = pMenu->GetItemCount();
	MENUITEMINFOW	mii;

	ZeroMemory(&mii, sizeof(MENUITEMINFOW));
	mii.cbSize = sizeof(MENUITEMINFOW);
	mii.fMask = MIIM_FTYPE | MIIM_ID;

	if(ch >= L'a' && ch <= L'z')	// 啶ɂ
		ch -= 0x20;
	for(UINT iItem = 0; iItem < cItems; ++iItem) {
		pMenu->GetMenuItemInfo(iItem, mii, false);
		if(mii.wID != 0 && !toBoolean(mii.fType & MFT_SEPARATOR)) {
			const wchar_t*	pwszAccel = wcschr(_GetMenuLabel(mii.wID), L'&');
			if(pwszAccel != 0) {
				if(pwszAccel[1] == ch)
					return (iItem | 0x00020000);
			}
		}
	}
	return MNC_IGNORE;
}

///	@see	WM_MENUSELECT
void CAlphaApp::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu) {
	wchar_t	wszPrompt[200] = L"";

	// IڂɑΉXe[^Xo[ɕ\
	if(nItemID >= CMD_EDIT_PLUGINLIST_START && nItemID < CMD_EDIT_PLUGINLIST_END) {
		m_statusBar.SetText(m_statusBar.IsSimple() ? SB_SIMPLEID : 0,
			(m_pScriptMacroManager->GetCount() != 0) ?
			m_pScriptMacroManager->GetDescription(nItemID - CMD_EDIT_PLUGINLIST_START).c_str() : L"", SBT_NOBORDERS);
	} else {
		if(!toBoolean(nFlags & MF_POPUP) && !toBoolean(nFlags & MFT_SEPARATOR))
			LoadString(nItemID, wszPrompt, 200);
		m_statusBar.SetText(m_statusBar.IsSimple() ? SB_SIMPLEID : 0,
			(*wszPrompt != 0) ? wcschr(wszPrompt, L'\n') + 1 : L"", SBT_NOBORDERS);
	}
}

///	@see	WM_MOUSEMOVE
void CAlphaApp::OnMouseMove(UINT nFlags, POINT pt) {
	if(m_bSizingOutputWnd) {	// o̓EBhE̍ύX
	} 
}

///	@see	IEditViewEventListener::OnMoveCaret
void CAlphaApp::OnMoveCaret(const CCharPos& pos) {
	_UpdateStatusBar();
}

///	@see	IEditViewEventListener::OnMoveCursor
void CAlphaApp::OnMoveCursor(const POINT& pt) {
	m_pMainWindow->SetTimer(ID_TIMER_MOUSEMOVE, 1200, 0);
}

///	@see	CWindow::OnNotify
bool CAlphaApp::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	switch(lpNMHDR->code) {
	case NM_RCLICK:	// obt@o[̉ENbN
		if(idCtrl == IDC_BUFFERBAR) {
			const NMMOUSE*	pMouse = reinterpret_cast<NMMOUSE*>(lpNMHDR);
			if(pMouse->dwItemSpec != -1) {
				POINT	pt = pMouse->pt;

				m_bufferBar.ClientToScreen(pt);
				m_documents.SetActiveDocument(pMouse->dwItemSpec - CMD_VIEW_BUFFERLIST_START);
				m_pBufferBarMenu->TrackPopupMenu(
					TPM_LEFTALIGN | TPM_TOPALIGN | TPM_LEFTBUTTON, pt.x, pt.y, m_pMainWindow->GetSafeHwnd());
				return true;
			}
		}
		break;
	case RBN_HEIGHTCHANGE:	// o[̍ς
		OnSize(0, -1, -1);
		return true;
	case RBN_CHEVRONPUSHED:	// c[o[̃VFuꂽ
		OnRebarChevronPushed(reinterpret_cast<LPNMREBARCHEVRON>(lpNMHDR));
		return true;
	case TBN_DROPDOWN: {	// c[o[̃hbv_E
		RECT		rect;
		POINT		pt;
		const bool	bCtrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		m_toolbar.GetRect(reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem, rect);
		pt.x = rect.left;
		pt.y = rect.bottom;
		m_pMainWindow->ClientToScreen(pt);
		switch(reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem) {
		case CMD_FILE_NEW:
			while(m_pNewDocTypeMenu->GetItemCount() > 0)	// ׂč폜
				m_pNewDocTypeMenu->DeleteMenuItem(0, false);
			for(size_t i = 0; i < m_documentTypes.GetCount(); ++i) {
				const TDocumentType&	type = m_documentTypes.GetAt(i);
				if(type.bPrivate && !bCtrlPressed)
					continue;
				m_pNewDocTypeMenu->AppendMenuItem(
					CMD_FILE_DOCTYPELIST_START + i, MFT_OWNERDRAW, type.strName.c_str());
			}
			m_pNewDocTypeMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, m_pMainWindow->GetSafeHwnd());
			return true;
		case CMD_FILE_OPEN:
			m_pMRUManager->GetPopupMenu()->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, m_pMainWindow->GetSafeHwnd());
			return true;
		}
		break;
	}
	case TBN_GETOBJECT:
		OnCommand(reinterpret_cast<LPNMOBJECTNOTIFY>(lpNMHDR)->iItem, 0, 0);
		return 0;
	case TTN_GETDISPINFOW: {	// c[o[̃c[`bv
		static wchar_t	wszTipText[500];
		LPNMTTDISPINFOW	lpNMTTDI = reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR);

		lpNMTTDI->hinst = m_hInstance;
		if(lpNMTTDI->hdr.idFrom >= CMD_VIEW_BUFFERLIST_START && lpNMTTDI->hdr.idFrom < CMD_VIEW_BUFFERLIST_END) {
			const IDocumentContainer*	pDocument = m_documents.GetDocument(lpNMTTDI->hdr.idFrom - CMD_VIEW_BUFFERLIST_START);
			wcscpy(wszTipText, pDocument->GetDescription().c_str());
		} else {
			wchar_t*	pwsz = 0;
			wstring		strKey;

			LoadString(lpNMTTDI->hdr.idFrom, wszTipText, 500);
			pwsz = wcschr(wszTipText, L'(');
			if(pwsz != 0)
				pwsz[0] = 0;
			strKey = m_keyboardMap.GetKeyString(lpNMTTDI->hdr.idFrom, false);
			if(!strKey.empty()) {
				wcscat(wszTipText, L" (");
				wcscat(wszTipText, strKey.c_str());
				wcscat(wszTipText, L")");
			}
		}
		lpNMTTDI->lpszText = wszTipText;
		return true;
	}
//	case TBN_HOTITEMCHANGE:
//		lpNMTHI = reinterpret_cast<LPNMTBHOTITEM>(lpNMHDR);
//		if(0 != LoadString(lpNMTHI->idNew, wszCommandCaption, 200)) {
//			psz = wcschr(wszCommandCaption, L'\n');
//			if(psz != 0)
//				::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(psz + 1));
//		} else
//			::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(L""));
//		break;
	}
	return false;
}

///	@see	IEditView::OnQueryLineColor
void CAlphaApp::OnQueryLineColor(length_t, bool bBookmarked,
		DWORD dwParam, bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack) {
	if(bSingleEmphasis)
		clrBack = RGB(0xFF, 0xFF, 0xCC);
	else if(dwParam & LA_BREAKPOINT_ENABLED)
		clrBack = RGB(0xFF, 0xEE, 0xEE);
	else if(bBookmarked)
		clrBack = RGB(0xF0, 0xF0, 0xFF);
}

///	RBN_CHEVRONPUSHED ̏
void CAlphaApp::OnRebarChevronPushed(LPNMREBARCHEVRON lpNMRebarChevron) {
	assert(lpNMRebarChevron != 0);

	REBARBANDINFOW	rbi;
	RECT			rectBand;

	// c[o[𓾂 (obt@o[łʂ̃R[hg)
	m_rebar.GetRect(lpNMRebarChevron->uBand, rectBand);
	ZeroMemory(&rbi, sizeof(REBARBANDINFOW));
	rbi.cbSize = sizeof(REBARBANDINFOW);
	rbi.fMask = RBBIM_CHILD | RBBIM_IDEALSIZE;
	m_rebar.GetBandInfo(lpNMRebarChevron->uBand, rbi);
	const long	cButtons = ::SendMessage(rbi.hwndChild, TB_BUTTONCOUNT, 0, 0L);

	// \̃{^܂Ői
	long	iButton;
	RECT	rectButton;
	for(iButton = 0; iButton < cButtons; ++iButton) {
		::SendMessage(rbi.hwndChild, TB_GETITEMRECT, iButton, reinterpret_cast<LPARAM>(&rectButton));
		if(rectButton.right + rectBand.left > lpNMRebarChevron->rc.left)
			break;
	}

	// \̃{^j[ڂɕϊ
	HMENU			hPopupMenu = ::CreatePopupMenu();
	TBBUTTONINFOW	tbbi;
	MENUITEMINFOW	item;
	POINT			pt = {lpNMRebarChevron->rc.left, lpNMRebarChevron->rc.bottom};

	ZeroMemory(&tbbi, sizeof(TBBUTTONINFOW));
	tbbi.cbSize = sizeof(TBBUTTONINFOW);
	tbbi.dwMask = TBIF_BYINDEX | TBIF_COMMAND | TBIF_STYLE;
	ZeroMemory(&item, sizeof(MENUITEMINFOW));
	item.cbSize = sizeof(MENUITEMINFOW);
	item.fMask = MIIM_DATA | MIIM_FTYPE | MIIM_ID | MIIM_STATE;
	for(; iButton < cButtons; ++iButton) {
		::SendMessage(rbi.hwndChild, TB_GETBUTTONINFOW, iButton, reinterpret_cast<LPARAM>(&tbbi));
		if(toBoolean(tbbi.fsStyle & TBSTYLE_SEP))
			::AppendMenu(hPopupMenu, MFT_OWNERDRAW | MFT_SEPARATOR, 0, 0);
		else {
			item.fType = MFT_OWNERDRAW;
			item.fState = m_pCommandManager->IsEnabled(tbbi.idCommand, true) ? MFS_ENABLED : MFS_DISABLED;
			item.fState |= (m_pCommandManager->IsChecked(tbbi.idCommand)) ? MFS_CHECKED : 0;
			item.wID = tbbi.idCommand;
			item.dwItemData = 0/*reinterpret_cast<DWORD>(GetMenuLabel(tbbi.idCommand))*/;
			::InsertMenuItemW(hPopupMenu, ::GetMenuItemCount(hPopupMenu), true, &item);
		}
	}
	m_rebar.ClientToScreen(pt);
	::TrackPopupMenu(hPopupMenu, TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, 0, m_pMainWindow->GetSafeHwnd(), 0);
	::DestroyMenu(hPopupMenu);
}

///	@see	CWindow::OnSetCursor
bool CAlphaApp::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT	pt;		// J[\ʒu
	RECT	rectClient, rectStatusBar;

	m_pMainWindow->GetClientRect(rectClient);
	if(m_statusBar.IsWindowVisible())	m_statusBar.GetWindowRect(rectStatusBar);
	else								::SetRect(&rectStatusBar, 0, 0, 0, 0);
	::GetCursorPos(&pt);
	m_pMainWindow->ScreenToClient(pt);

	if(pt.y >= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top) - 3
			&& pt.y <= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top)) {
		::SetCursor(::LoadCursor(0, IDC_SIZENS));
		return true;
	}

	return false;
}

/**
 *	@see			CWindow::OnSize
 *	@param nType	CWindow::OnSize Q
 *	@param cx, cy	-1ɂƂ̃\bh݂͌̃EBhETCYgB
 *					̃\bhs̏PɎgpꍇɂĂяoƂł
 */
void CAlphaApp::OnSize(UINT nType, int cx, int cy) {
	RECT	rectRebar, rectStatusBar, rectEditor;

	if(cx == -1 && cy == -1) {
		RECT	rect;
		m_pMainWindow->GetClientRect(rect);
		cx = rect.right - rect.left;
		cy = rect.bottom - rect.top;
	}

	if(m_statusBar.IsWindowVisible()) {
		m_statusBar.SendMessage(WM_SIZE, cx, cy);
		m_statusBar.GetWindowRect(rectStatusBar);
		_UpdateStatusBar();
	} else
		::SetRect(&rectStatusBar, 0, 0, 0, 0);

	if(m_rebar.IsWindowVisible()) {
		m_rebar.SendMessage(WM_SIZE, cx, cy);
		m_rebar.GetWindowRect(rectRebar);
		m_toolbar.SendMessage(WM_SIZE, cx, rectRebar.bottom - rectRebar.top - 2);
	} else
		::SetRect(&rectRebar, 0, 0, 0, 0);

	rectEditor.left =  0;
	rectEditor.top = rectRebar.bottom - rectRebar.top;
	rectEditor.right = cx;
	rectEditor.bottom = cy
		- (m_statusBar.IsWindowVisible() ? rectStatusBar.bottom - rectStatusBar.top : 0);
//	if(m_wndOutput.IsWindow() && m_wndOutput.IsWindowVisible())
//		rectEditor.bottom -= m_nOutputWndHeight;
	if(m_documents.GetCount() != 0 && m_documents.GetActiveDocumentIndex() < m_documents.GetCount()) {	// [
		HWND	hwndBuffer = m_documents.GetActiveDocument()->GetWindow();
		if(::IsWindow(hwndBuffer))
			::MoveWindow(hwndBuffer, rectEditor.left, rectEditor.top,
				rectEditor.right - rectEditor.left, rectEditor.bottom - rectEditor.top, true);
	}

//	if(m_wndOutput.IsWindow()) {
//		m_wndOutput.MoveWindow(0, rectEditor.bottom + 2, cx, m_nOutputWndHeight);
//		m_wndOutput.ShowWindow(SW_SHOW);
//	}
}

///	@see	WM_SYSCHAR
bool CAlphaApp::OnSysChar(UINT nChar, UINT nFlags) {
	// L[gݍ킹L[{[hXL[ɓo^Ă邩ׂB
	// o^ĂΊ̏ (j[̃ANeBx[V) WQ
	const VirtualKey	key = LOBYTE(::VkKeyScanExW(nChar, ::GetKeyboardLayout(0)));
	KeyModifier			modifiers = KM_ALT;
	if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))	modifiers |= KM_CTRL;
	if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))		modifiers |= KM_SHIFT;

	if(m_2Stroke1stKey == VK_NULL)
		return m_keyboardMap.GetCommandID(key, modifiers) != 0;
	else
		return m_keyboardMap.GetCommandID(m_2Stroke1stKey, m_2Stroke1stModifiers, key, modifiers) != 0;
}

///	@see	WM_SYSKEYDOWN
bool CAlphaApp::OnSysKeyDown(UINT nChar, UINT nFlags) {
	KeyModifier	modifiers = KM_ALT;
	if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))	modifiers |= KM_CTRL;
	if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))		modifiers |= KM_SHIFT;
	return _HandleKeyDown(nChar, modifiers);
}

///	@see	WM_TIMER
void CAlphaApp::OnTimer(UINT nIDTimer) {
	if(nIDTimer == ID_TIMER_QUERYCOMMAND && m_documents.GetCount() != 0) {
		// c[o[ACe̗L/ƃobt@o[̗z̍ČvZ
		const size_t	cButtons = m_toolbar.GetButtonCount();
		TBBUTTON		button;

		for(size_t iButton = 0; iButton < cButtons; ++iButton) {
			m_toolbar.GetButton(iButton, button);
			m_toolbar.CheckButton(button.idCommand, m_pCommandManager->IsChecked(button.idCommand));
			m_toolbar.EnableButton(button.idCommand, m_pCommandManager->IsEnabled(button.idCommand, true));
		}

		REBARBANDINFOW	rbbi;
		RECT			rect;
		ZeroMemory(&rbbi, sizeof(REBARBANDINFOW));
		rbbi.cbSize = sizeof(REBARBANDINFOW);
		rbbi.fMask = RBBIM_IDEALSIZE;
		m_bufferBar.GetItemRect(m_bufferBar.GetButtonCount() - 1, rect);
		rbbi.cxIdeal = rect.right;
		m_rebar.SetBandInfo(m_rebar.IdToIndex(IDC_BUFFERBAR), rbbi);
	} else if(nIDTimer == ID_TIMER_MOUSEMOVE) {	// qg\
/*		if(GetActiveTab()->GetTextEditor() != 0
				&& m_pActiveDebugger != 0
				&& m_pActiveDebugger->IsDebugging()) {
			CAlphaView*			pActiveView = GetActiveTab()->GetTextEditor()->GetActiveView();
			DebugPropertyInfo	dpi;
			POINT				pt, ptView;
			wstring				strExpression;
			wostringstream		ssResult;

			::GetCursorPos(&pt);
			ptView = pt;
			pActiveView->ScreenToClient(&ptView);
			strExpression = (pActiveView->HasSelection() && pActiveView->IsOverSelection(ptView)) ?
				pActiveView->GetSelection() : pActiveView->GetNearestWordFromCursor();
			dpi.m_dwValidFields = DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE;
			if(!strExpression.empty()
						&& SUCCEEDED(m_pActiveDebugger->EvaluateExpression(strExpression, 10, true, &dpi))) {
				if(dpi.m_bstrType != 0
						&& wcscmp(dpi.m_bstrType, L"Error") != 0	// VC6
						&& wcscmp(dpi.m_bstrType, L"G[") != 0)	// VC7
					ssResult << dpi.m_bstrName << L" = " << dpi.m_bstrValue;
				if(dpi.m_dwValidFields & DBGPROP_INFO_NAME)		::SysFreeString(dpi.m_bstrName);
				if(dpi.m_dwValidFields & DBGPROP_INFO_TYPE)		::SysFreeString(dpi.m_bstrType);
				if(dpi.m_dwValidFields & DBGPROP_INFO_VALUE)	::SysFreeString(dpi.m_bstrValue);
			}
		}
*/		m_pMainWindow->KillTimer(ID_TIMER_MOUSEMOVE);
	}
}

/* [EOF] */