// AboutDlg.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "AboutDlg.h"
using Alpha::CAboutDlg;


namespace {
	const wchar_t	DS_PAGE_URL[] = L"http://www.interq.or.jp/student/exeal/dss/res/alpha/";
	const wchar_t	SF_PAGE_URL[] = L"http://sourceforge.jp/projects/alpha/";
}


bool CAboutDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LINK_HOMEPAGE) {
		::ShellExecuteW(0, 0, DS_PAGE_URL, 0, 0, SW_SHOWNORMAL);
		return true;
	} else if(wID == IDC_LINK_SOURCEFORGE) {
		::ShellExecuteW(0, 0, SF_PAGE_URL, 0, 0, SW_SHOWNORMAL);
		return true;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

bool CAboutDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	m_homePageLink.m_clrBackground = 0x80000000;
	m_homePageLink.Create(m_hWnd, ::GetModuleHandle(0), IDC_LINK_HOMEPAGE);
	m_homePageLink.SetWindowText(DS_PAGE_URL);
	m_homePageLink.SetWindowPos(0, 88, 98, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);
	m_sourceForgeLink.m_clrBackground = 0x80000000;
	m_sourceForgeLink.Create(m_hWnd, ::GetModuleHandle(0), IDC_LINK_SOURCEFORGE);
	m_sourceForgeLink.SetWindowText(SF_PAGE_URL);
	m_sourceForgeLink.SetWindowPos(0, 88, 114, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

	m_pToolTips = new Manah::Windows::Controls::CToolTipCtrl;
	m_pToolTips->Create(m_hWnd, ::GetModuleHandle(0), TTS_ALWAYSTIP);
	m_pToolTips->SetWindowPos(HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
	m_pToolTips->Activate(true);
	m_pToolTips->AddTool(m_homePageLink, TTF_SUBCLASS, L"Alpha @ Dynamic Scripting");
//	m_pToolTips->AddTool(m_sourceForgeLink, TTF_SUBCLASS, L"Alpha @ SourceForge.jp");
	TOOLINFOW	ti;
	ZeroMemory(&ti, sizeof(TOOLINFOW));
	ti.cbSize = sizeof(TOOLINFOW);
	ti.hinst = ::GetModuleHandle(0);
	ti.hwnd = m_pToolTips->GetParent();
	ti.lpszText = L"Alpha @ SourceForge.jp";
	ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
	ti.uId = reinterpret_cast<UINT_PTR>(m_sourceForgeLink.GetSafeHwnd());
	m_pToolTips->AddTool(ti);
/*	ti.lpszText = L"͕W̃{^ɒǉc[`bv";
	ti.uId = reinterpret_cast<UINT>(GetDlgItem(IDOK));
	m_pToolTips->AddTool(ti);
*/
	return true;
}

/* [EOF] */