// AbbreviationsDlg.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "AbbreviationsDlg.h"
#include "Ascension\EditView.h"
#include "..\Manah\ListCtrl.h"

using Alpha::CAbbreviationsDlg;
using namespace Ascension;
using namespace Manah::Windows::Controls;
using namespace std;


// CAbbreviationsDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CAbbreviationsDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_BTN_ADD) {	// [ǉ]
		CNewAbbreviationDlg	dlg;
		dlg.Create(reinterpret_cast<HINSTANCE>(GetWindowLongW(GWL_HINSTANCE)), IDD_DLG_NEWABBREV, m_hWnd);
		dlg.m_hAbbreviationsListCtrl = GetDlgItem(IDC_LIST_ABBREVIATIONS);
		if(IDOK == dlg.DoModal()) {
			CListCtrl	abbrList;
			abbrList.Attach(GetDlgItem(IDC_LIST_ABBREVIATIONS));
			const int	iItem = abbrList.InsertItem(0, dlg.m_wszAbbreviation);
			if(iItem != -1)
				abbrList.SetItem(iItem, 1, LVIF_TEXT, dlg.m_wszExpanded, 0, 0, 0, 0);
			abbrList.Detach();
			Update();
		}
	} else if(wID == IDC_BTN_DELETE) {	// [폜]
		SendDlgItemMessage(IDC_LIST_ABBREVIATIONS, LVM_DELETEITEM, 
			SendDlgItemMessage(IDC_LIST_ABBREVIATIONS, LVM_GETSELECTIONMARK, 0, 0L), 0L);
		Update();
	} else if(wID == IDC_BTN_CLEAR) {	// [ׂč폜]
		SendDlgItemMessage(IDC_LIST_ABBREVIATIONS, LVM_DELETEALLITEMS, 0, 0L);
		Update();
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CAbbreviationsDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CListCtrl		abbrList;
	list<string_t>	listAbbrevs;
	
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	abbrList.Attach(GetDlgItem(IDC_LIST_ABBREVIATIONS));
	abbrList.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	abbrList.InsertColumn(0, L"Zk", LVCFMT_LEFT, 80);
	abbrList.InsertColumn(1, L"WJ̕", LVCFMT_LEFT, 260);
	CEditView::GetAbbreviationList(listAbbrevs);
	for(list<string_t>::const_iterator it = listAbbrevs.begin(); it != listAbbrevs.end(); ++it) {
		const int	iItem = abbrList.InsertItem(0, it->c_str());
		abbrList.SetItem(iItem, 1, LVIF_TEXT, CEditView::ExpandAbbreviation(*it).c_str(), 0, 0, 0, 0);
	}
	abbrList.Detach();
	Update();

	return true;
}

///	@see	CDialog::OnOK
void CAbbreviationsDlg::OnOK() {
	CListCtrl		abbrList;
	list<string_t>	listAbbrevs;
	char_t			wszAbbrev[1000], wszExpanded[100];

	CEditView::RevokeAllAbbreviations();
	abbrList.Attach(GetDlgItem(IDC_LIST_ABBREVIATIONS));
	for(int i = 0; i < abbrList.GetItemCount(); ++i) {
		abbrList.GetItemText(i, 0, wszAbbrev, 1000);
		abbrList.GetItemText(i, 1, wszExpanded, 1000);
		CEditView::RegisterAbbreviation(wszAbbrev, wszExpanded);
	}
	abbrList.Detach();

	CDialog::OnOK();
}

///	{^̗L/Ȃ
void CAbbreviationsDlg::Update() {
	if(SendDlgItemMessage(IDC_LIST_ABBREVIATIONS, LVM_GETITEMCOUNT, 0, 0L) == 0) {
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), false);
		::EnableWindow(GetDlgItem(IDC_BTN_CLEAR), false);
		::SetFocus(GetDlgItem(IDC_BTN_ADD));	// 폜ñ{^ɂȂ̂
	} else {
		LVITEMW	item;
		item.iItem = 0;
		item.state = item.stateMask = LVIS_FOCUSED | LVIS_SELECTED;
		SendDlgItemMessage(IDC_LIST_ABBREVIATIONS, LVM_SETITEMSTATE, 0, reinterpret_cast<LPARAM>(&item));
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), true);
		::EnableWindow(GetDlgItem(IDC_BTN_CLEAR), true);
	}
}


// CNewAbbreviationDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CAbbreviationsDlg::CNewAbbreviationDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wNotifyCode == EN_CHANGE) {
		::EnableWindow(GetDlgItem(IDOK),
			::GetWindowTextLengthW(GetDlgItem(IDC_EDIT_INPUT)) != 0
			&& ::GetWindowTextLengthW(GetDlgItem(IDC_EDIT_OUTPUT)) != 0);
		return true;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CAbbreviationsDlg::CNewAbbreviationDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	SendDlgItemMessage(IDC_EDIT_INPUT, EM_LIMITTEXT, 999, 0L);
	SendDlgItemMessage(IDC_EDIT_OUTPUT, EM_LIMITTEXT, 999, 0L);
	::EnableWindow(GetDlgItem(IDOK), false);

	return true;
}

///	@see	CDialog::OnOK
void CAbbreviationsDlg::CNewAbbreviationDlg::OnOK() {
	GetDlgItemText(IDC_EDIT_INPUT, m_wszAbbreviation, 1000);
	GetDlgItemText(IDC_EDIT_OUTPUT, m_wszExpanded, 1000);

	if(m_wszAbbreviation[0] == 0 || m_wszExpanded[0] == 0)
		return;

	LVFINDINFOW	fi;
	int			iFound;

	fi.flags = LVFI_STRING;
	fi.psz = m_wszAbbreviation;
	iFound = ListView_FindItem(m_hAbbreviationsListCtrl, -1, &fi);
	if(iFound != -1) {
		wchar_t	wsz[1000];
		ListView_GetItemText(m_hAbbreviationsListCtrl, iFound, 0, wsz, 1000);
		if(wcscmp(wsz, m_wszAbbreviation) != 0)
			iFound = -1;
	}
	if(iFound != -1) {
		wchar_t	wsz[1000];
		::LoadStringW(reinterpret_cast<HINSTANCE>(
			GetWindowLongW(GWL_HINSTANCE)), MSG_CONFLICTEDABBREVIATION, wsz, 1000);
		MessageBox(wsz, IDS_APPNAME, MB_ICONEXCLAMATION);
		return;
	}

	CDialog::OnOK();
}

/* [EOF] */