#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#############################################################################
##
## Copyright (C) 2016 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of the test suite of Qt for Python.
##
## $QT_BEGIN_LICENSE:GPL-EXCEPT$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 3 as published by the Free Software
## Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

'''Test cases for <add-function> with const char* as argument'''

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from shiboken_paths import init_paths
init_paths()

from sample import Color, Pen, SampleNamespace

class TestPen(unittest.TestCase):
    '''Simple test case for Pen.'''

    def testPenWithEmptyConstructor(self):
        pen = Pen()
        self.assertEqual(pen.ctorType(), Pen.EmptyCtor)

    def testPenWithEnumConstructor(self):
        pen = Pen(SampleNamespace.RandomNumber)
        self.assertEqual(pen.ctorType(), Pen.EnumCtor)

    def testPenWithColorConstructor(self):
        pen = Pen(Color())
        self.assertEqual(pen.ctorType(), Pen.ColorCtor)

    def testPenWithCopyConstructor(self):
        pen = Pen(Pen())
        self.assertEqual(pen.ctorType(), Pen.CopyCtor)

    def testPenWithIntConvertedToColor(self):
        pen = Pen(1)
        self.assertEqual(pen.ctorType(), Pen.ColorCtor)
        pen.drawLine(0, 0, 5, 5)

    def testPenRenderHintsProperty(self):
        """Exercise the generated property setter and getters, checking
           against the C++ getter/setter functions."""
        pen = Pen(1)
        self.assertEqual(pen.getRenderHints(), Pen.RenderHints.None_)
        self.assertEqual(pen.renderHints, Pen.RenderHints.None_)
        pen.renderHints = Pen.RenderHints.TextAntialiasing
        self.assertEqual(pen.getRenderHints(), Pen.RenderHints.TextAntialiasing)
        self.assertEqual(pen.renderHints, Pen.RenderHints.TextAntialiasing)
        pen.setRenderHints(Pen.RenderHints.Antialiasing)
        self.assertEqual(pen.getRenderHints(), Pen.RenderHints.Antialiasing)
        self.assertEqual(pen.renderHints, Pen.RenderHints.Antialiasing)


if __name__ == '__main__':
    unittest.main()
