<?php
/*
  Author: Greg Feigenson
  File: invoice_detail.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/
require('includes/header.inc.php');
require_once("objects/workorder_object.php");

//Grab the workorder id from GET array
$woid = $_GET['invoice'];

//Query for workorders
$query = "SELECT * FROM $view_wo_cust WHERE workorder_id = $woid";

//Connect to db, run query
require("includes/db.inc.php");
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));

//If there's no record of the workorder
if (pg_num_rows($result) < 1)
{
	printNotice("Sorry, no records available for work order $woid");
	require('includes/footer.inc.php');
	exit;
}

//Grab the work order, create a new object
$row = pg_fetch_assoc($result);
$workorder = new workorder($row['start_date'],$row['promised_date'], $row['first_name'], $row['last_name'],$row['phone1'], $row['phone2'], $row['workorder_id'], $row['customer_id']);
$workorder->setStaff($row['staff']);
$workorder->email = $row[email];

echo "<div align=center>";
echo "<h2><u>Workorder $workorder->id</u></h2>";


/*----------------------------------------------------------------------------
  			         Workorders display
  ----------------------------------------------------------------------------*/


//Build left detail pane
$right = "Status: <b>".$workorder->checkStatus($workorder->status)."</b><br>";
$right .="Due: $workorder->due_date<br>";
$right .="Assigned to: $workorder->staff<br>";
//$right .="<br><a href='$_SERVER[PHP_SELF]?invoice=$woid&action=edit&target=workorder'>(edit)</a>";

//Build right detail pane
$left = "$workorder->first_name $workorder->last_name<br>";
$left .= "$workorder->phone1 <i>(primary)</i><br>";

if ($workorder->phone2 != "")
	$left .= "$workorder->phone2 <i>(secondary)</i><br>";
	
$left .= "$workorder->email<br>";
$left .= "$row[street1]<br>";

if ($row[street2] != "")
	$left .= "$row[street2]<br>";
	
$left .= "$row[city], $row[state], $row[zip]<br>";
//$left .="<br><a href='$_SERVER[PHP_SELF]?invoice=$woid&action=edit&target=custinfo'>(edit)</a>";

//Print the details
echo "<h3>Workorder details</h3>";
echo "<table border='1' width='40%' id='table1' cellspacing='0' cellpadding='15' bordercolorlight='#000000' bordercolordark='#000000' style='border-collapse: collapse'>";
echo "<tr>";

echo "<td><p align='center' width='50%'>$right</td>";
echo "<td><p align='center' width='50%'>$left</td>";

echo "</tr></table>";

//Seperator image
echo "<br><br><img src='images/seperator.jpg'>";

/*----------------------------------------------------------------------------
  			         Problems display
  ----------------------------------------------------------------------------*/
//Header
echo "<br><br><h3>Associated Problems</h3>";

//SQL stuff
$query = "SELECT * FROM $tbl_problems WHERE $tbl_problems.work_order_id = $workorder->id";

require("includes/db.inc.php");
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));

//Print the details
$i = 1;

while ($row = pg_fetch_object($result))
{
	echo "<table border='1' width='30%' id='table1' bordercolorlight='#000000' bordercolordark='#000000' style='border-collapse: collapse'>";
	echo "<tr>";
	echo "<td><p align='center'>";
	echo "<u><b>Problem $i</b></u><br><br>";
	echo "<i>Estimated cost: $row->cost</i><br>";
	echo "<i>Estimated time to fix: $row->estimated_time hours</i><br>";
	echo "<i>Actual time taken to fix: $row->actual_time hours</i><br><br>";
	echo "<i><u>Description of problem:</u><br> $row->description</i><br><br>";
	
	if (strlen($row->notes) <= 1)
		$note = "No notes were taken on this problem";
	else
		$note = $row->notes;
	
	echo "<i><u>Notes:</u><br>$note</i><br><br>";
	//echo "<br><a href='$_SERVER[PHP_SELF]?invoice=$woid&action=edit&problem=$row->problem_id'>(edit)</a>";
	echo "</p></td>";
	echo "</tr>";
	echo "</table>";
	echo "<br>";
	$i++;
}

//Seperator image
echo "<br><br><br><br><img src='images/seperator.jpg'>";


/*----------------------------------------------------------------------------
  				Notes display
  ----------------------------------------------------------------------------*/
//Header
echo "<br><br><h3>Notes</h3>";

//SQL stuff
$query = "SELECT * FROM $tbl_notes WHERE $tbl_notes.work_order_id = $workorder->id";

require("includes/db.inc.php");
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));

//Print the details
while ($row = pg_fetch_object($result))
{
	echo "<table border='1' width='30%' id='table1' bordercolorlight='#000000' bordercolordark='#000000' style='border-collapse: collapse'>";
	echo "<tr>";
	echo "<td><p align='center'>";
	echo "<u><b>Note:</b></u><br><br>";
	echo "<i>Author: $row->author</i><br>";
	echo "<i>Date/Time written: $row->date</i><br>";
	echo "<i><u>Note:</u><br>$row->text</i><br><br>";
	//echo "<br><a href='$_SERVER[PHP_SELF]?invoice=$woid&action=edit&note=$row->note_id'>(edit)</a>";
	echo "</p></td>";
	echo "</tr>";
	echo "</table>";
	echo "<br>";
}

echo "<br><br><a href='open_workorders.php'>BACK TO OPEN TICKETS</a>";
echo "</div>";

//close the DB connection
pg_close($connection);
require('includes/footer.inc.php');
?>
