using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.Text;

public partial class Account_Profile : System.Web.UI.Page
{
	protected void Page_Load(object sender, EventArgs e)
	{
		if (Page.IsPostBack)
			return;

		MembershipUser user = Membership.GetUser();
		if (user == null)
			return;

		UserNameLabel.Text = user.UserName;
		EmailLabel.Text = user.Email;

		StringBuilder rolesList = new StringBuilder();
		rolesList.AppendLine("<ul>");
		foreach (string role in Roles.GetRolesForUser(user.UserName))
			rolesList.AppendLine(string.Format("<li>{0}</li>", role));

		rolesList.AppendLine("</ul>");
		RolesLiteral.Text = rolesList.ToString();

		LastLoginLabel.Text = user.LastLoginDate.ToString();

		LastPasswordChangeLabel.Text = user.LastPasswordChangedDate.ToString();
		TimeSpan passwordAge = DateTime.Now - user.LastPasswordChangedDate;

		if (passwordAge.Days > 90)
			LastPasswordChangeLabel.ForeColor = Color.Red;

		else if (passwordAge.Days > 45)
			LastPasswordChangeLabel.ForeColor = Color.Orange;
	}
}
