#!/usr/sbin/dtrace -s
/*
 * USAGE      : ./dirty_wal_buffer_write.d
 *
 * DESCRIPTION:
 *   This script prints the number of writes performed by the server process
 *   because wal_buffers is too small. If wal_buffers is set to the appropriate
 *   value, you won't see the backend doing many writes on dirty WAL buffers.
 *
 * EXAMPLE    : (1) run pgbench (2) run dirty_wal_buffer_write.d
 * 
 * AUTHOR     : Robert Lor <robert.lor@sun.com>
 *
 * $Header$
 */

#pragma D option quiet

postgresql*:::wal-buffer-write-dirty-start
{
	self->ts = timestamp;
	self->pid = pid;
}
postgresql*:::wal-buffer-write-dirty-done
/self->ts && self->pid ==pid/
{
	@count[pid, "WAL buffers written    "] = count();
	@countpersec[pid, "WAL buffer writes/sec  "] = count();
	@avgtime[pid, "Average write time (ns)"] = avg (timestamp - self->ts);
        self->ts = 0;
        self->pid = 0;
}

profile:::tick-1s
{
	printf("%5s %15s %20s\n","PID", "Description", "Count/Time");
	printf("------------------------------------------\n");
        printa("%5d %20s %@12d\n",@count);
        printa("%5d %20s %@12d\n",@countpersec);
        printa("%5d %20s %@12d\n",@avgtime);
	printf("\n");

	clear(@countpersec);
}
