#ifndef __UUID_UTIL_H__
#define __UUID_UTIL_H__

#include <uuid.h>

/* define interface number
 * 0 is eth0
 * 1 is eth1
 * ......
 */
#define IF_NUMBER 0

#ifdef __cplusplus
extern "C" {
#endif

int get_clock(uuid_u32_t* clock_high, uuid_u32_t* clock_low, uuid_u16_t* ret_clock_seq);
int get_random_buffer(void *buf, size_t nbytes);
int get_if_mac(int if_number, unsigned char if_mac[]);

#ifdef __cplusplus
}
#endif

#endif /* __UUID_UTIL_H__ */
