//
//  PgSQLResult.h
//  PostgresSQL
//
//  Created by Pascal on Thu Dec 26 2002.
//  Copyright (c) 2002 P3 Consulting. All rights reserved.
//

#ifndef	DEMO_MODE
#define	DEMO_MODE	0
#endif

#import <Foundation/Foundation.h>
#import "PgSQLBindingProtocol.h"
#import "PgSQLResultSetProtocol.h"
#import "libpq-fe.h"

@class	PostgreSQL	;

/*!
@header PgSQLResult.h

	@discussion	
		PgSQLResult is a wrapper class for a PGresult *.<br>
		It's created by calling the getResultSet method of a PostgreSQL object.
		It implements PgSQLBindingProtocol and PgSQLResultSetProtocol, making possible
		to get results using bindXXX methods and to naviagte in the result set using nextRow, previousRow, etc.
*/

@interface PgSQLResult : NSObject <PgSQLBindingProtocol, PgSQLResultSetProtocol> {
	PGresult		*_result		;
    PostgreSQL		*_pgsql			;
	int				_curRowIndex	;	
	int				_rowsInResult	;
	int				_fieldsInResult	;	
	NSMutableArray	*_bindingArray	;
}

+(id)newWithPgResult:(PGresult *)result forConnection:(PostgreSQL *)conn	;
-(id)initWithPgResult:(PGresult *)result forConnection:(PostgreSQL *)conn	;
-(PGresult *)pgResult	;

@end

/*
@interface PgSQLResult(NSTableDataSource)

- (int)numberOfRowsInTableView:(NSTableView *)tableView;
- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;

@end
*/

