//
//  PgSQLBindingProtocol.h
//  PostgresSQL
//
//  Created by Pascal on Thu Dec 26 2002.
//  Copyright (c) 2002 P3 Consulting. All rights reserved.
//

/*!
@header PgSQLBindingProtocol.h

*/

#import "libpq-fe.h"
#import "pgtypes.h"

@protocol PgSQLBindingProtocol

/*! 
   @method bindDouble
   @abstract bindDouble binds the double variable <code>var</code> to the next result column.
*/
-(void)bindDouble:(double *)var;
/*! 
   @method bindDouble
   @abstract bindDouble binds the double variable <code>var</code> to the specific column <code>col</code>. (column count starts at 0)
   @discussion In case you skip columns in binding, they will be binded internally to a dummy item in order to avoid crashes or erroneous behavior.
*/
-(void)bindDouble:(double *)var column:(int)col;
/*! 
   @method bindFloat
*/
-(void)bindFloat:(float *)var;
/*! 
   @method bindFloat
*/
-(void)bindFloat:(float *)var column:(int)col;
/*! 
   @method bindShort
*/
-(void)bindShort:(short *)var;
/*! 
   @method bindShort
*/
-(void)bindShort:(short *)var column:(int)col;
/*! 
   @method bindInteger
*/
-(void)bindInteger:(int *)var;
/*! 
   @method bindInteger
*/
-(void)bindInteger:(int *)var column:(int)col;
/*! 
   @method bindBoolean
   @discussion Y,y,t,T,1 are converted to YES, any other character to NO
*/
-(void)bindBoolean:(BOOL *)var;
/*! 
   @method bindBoolean
*/
-(void)bindBoolean:(BOOL *)var column:(int)col;
/*! 
   @method bindLong
*/
-(void)bindLong:(long *)var;
/*! 
   @method bindLong
*/
-(void)bindLong:(long *)var column:(int)col;
/*! 
   @method bindLongLong
*/
-(void)bindLongLong:(long long *)var;
/*! 
   @method bindLongLong
*/
-(void)bindLongLong:(long long *)var column:(int)col;
/*! 
   @method bindString
*/
-(void)bindString:(char *)var;
/*! 
   @method bindString
*/
-(void)bindString:(char *)var column:(int)col;
/*! 
   @method bindBinaryString
*/
-(void)bindBinaryString:(BSTRING *)var;
/*! 
   @method bindBinaryString
*/
-(void)bindBinaryString:(BSTRING *)var column:(int)col;
/*! 
   @method bindText
*/
-(void)bindText:(TEXT *)var;
/*! 
   @method bindText
*/
-(void)bindText:(TEXT *)var column:(int)col;
/*! 
   @method bindChar
*/
-(void)bindChar:(char *)var;
/*! 
   @method bindChar
*/
-(void)bindChar:(char *)var column:(int)col;
/*! 
   @method bindBinary
*/
- (void)bindBinary:(Oid *)var;
/*! 
   @method bindBinary
*/
- (void)bindBinary:(Oid *)var column:(int)col;
/*! 
   @method bindPoint
*/
- (void)bindPoint:(POINT *)var;
/*! 
   @method bindPoint
*/
- (void)bindPoint:(POINT *)var column:(int)col;
/*! 
   @method bindPolygon
   @discussion	*var should be deallocated by free(*var) to avoid memeory leaks
*/
- (void)bindPolygon:(POLYGON **)var;
/*! 
   @method bindPolygon
*/
- (void)bindPolygon:(POLYGON **)var column:(int)col;
/*! 
   @method bindLSeg
*/
- (void)bindLSeg:(LSEG *)var;
/*! 
   @method bindLSeg
*/
- (void)bindLSeg:(LSEG *)var column:(int)col;
/*! 
   @method bindPath
   @discussion	*var should be deallocated by free(*var) to avoid memory leaks
*/
- (void)bindPath:(PATH **)var;
/*! 
   @method bindPath
*/
- (void)bindPath:(PATH **)var column:(int)col;
/*! 
   @method bindLine
*/
- (void)bindLine:(LINE *)var;
/*! 
   @method bindLine
*/
- (void)bindLine:(LINE *)var column:(int)col;
/*! 
   @method bindBox
*/
- (void)bindBox:(BOX *)var;
/*! 
   @method bindBox
*/
- (void)bindBox:(BOX *)var column:(int)col;
/*! 
   @method bindCircle
*/
- (void)bindCircle:(CIRCLE *)var;
/*! 
   @method bindCircle
*/
- (void)bindCircle:(CIRCLE *)var column:(int)col;
/*! 
   @method bindCIdr
   @discussion	var should point on 12 bytes memory area
*/
- (void)bindCIdr:(unsigned char *)var;
/*! 
   @method bindCIdr
   @discussion	var should point on 12 bytes memory area
*/
- (void)bindCIdr:(unsigned char *)var column:(int)col;
/*! 
   @method bindInet
   @discussion	var should point on 12 bytes memory area
*/
- (void)bindInet:(unsigned char *)var;
/*! 
   @method bindInet
   @discussion	var should point on 12 bytes memory area
*/
- (void)bindInet:(unsigned char *)var column:(int)col;
/*! 
   @method bindMACaddr
   @discussion	var should point on 6 bytes memory area
*/
- (void)bindMACaddr:(unsigned char *)var;
/*! 
   @method bindMACaddr
   @discussion	var should point on 6 bytes memory area
*/
- (void)bindMACaddr:(unsigned char *)var column:(int)col;
/*! 
   @method bindBIT
   @discussion	var should point on 6 bytes memory area
*/
- (void)bindBIT:(BOOLARRAY *)var;
/*! 
   @method bindBIT
   @discussion	var should point on 6 bytes memory area
*/
- (void)bindBIT:(BOOLARRAY *)var column:(int)col;
/*! 
   @method bindNSDecimal
   @discussion	var should point NSDecimalNumber*
*/
- (void)bindNSDecimal:(NSDecimalNumber **)var;
/*! 
   @method bindNSDecimal
   @discussion	var should point NSDecimalNumber*
*/
- (void)bindNSDecimal:(NSDecimalNumber **)var column:(int)col;
/*! 
   @method bindNSNumber
   @discussion	var should point on NSNumber*
*/
- (void)bindNSNumber:(NSNumber **)var;
/*! 
   @method bindNSNumber
   @discussion	var should point NSNumber*
*/
- (void)bindNSNumber:(NSNumber **)var column:(int)col;
/*! 
   @method bindNSString
   @discussion	var should point on NSString*
*/
- (void)bindNSString:(NSString **)var;
/*! 
   @method bindNSString
   @discussion	var should point on NSString*
*/
- (void)bindNSString:(NSString **)var column:(int)col;
/*! 
   @method bindNSData
   @discussion	var should point on NSData*
*/
- (void)bindNSData:(NSData **)var;
/*! 
   @method bindNSData
   @discussion	var should point on NSData*
*/
- (void)bindNSData:(NSData **)var column:(int)col;
/*! 
   @method bindNSArray
   @discussion	var should point on NSArray*
*/
- (void)bindNSArray:(NSArray **)var;
/*! 
   @method bindNSArray
   @discussion	var should point on NSArray*
*/
- (void)bindNSArray:(NSArray **)var column:(int)col;

@end