/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "debugger.h"

/**
 * This class contains some debugger utilities. Currently there are 3 types
 * of debugging messages. The types are messages that can be traced are:
 * 1. SQL query messages.
 * 2. Function entering/exiting signals.
 * 3. General debug messages.
 *
 * Currently all error messages are logged to the console. This will eventually
 * change to be able to trace messages to a file.
 */
	
	/**
	 * This boolean indicates if tracing of SQL queries has been turned on.
	 */
	bool Debugger::m_bLogSQL = true;

	/**
	 * This boolean indicates if tracing of entering/exiting functions
	 * has been turned on.
	 */		
	bool Debugger::m_bLogFunctions = true;
	
	/**
	 * This boolean indicates if tracing of general debug messages has been turned on.
	 */		
	bool Debugger::m_bLogTraces = true;

	/**
	 * This boolean indicates if tracing of exceptions has been turned on.
	 */		
	bool Debugger::m_bLogExceptions = true;
				
	/**
 	 * Used to set the sql trace messages on/off.
   */			    	
	void Debugger::setLogSQL(bool bLogSQL)
	{
		m_bLogSQL = bLogSQL;
	} // end setLogSQL
	
	/**
	 * Used to see if sql message tracing is on or off.
	 */
	bool Debugger::isLogSQL()
	{
		return m_bLogSQL;
	} // end isLogSQL

	/**
 	 * Used to set the functions trace messages on/off.
   */			    	
	void Debugger::setLogFunctions(bool bLogFunctions)
	{
		m_bLogFunctions = bLogFunctions;
	} // end setLogFunctions
	
	/**
	 * Used to see if functions message tracing is on or off.
	 */
	bool Debugger::isLogFunctions()
	{
		return m_bLogFunctions;
	} // end isLogFunctions

	/**
 	 * Used to set the debug trace messages on/off.
   */			    	
	void Debugger::setLogTraces(bool bLogTraces)
	{
		m_bLogTraces = bLogTraces;
	} // end setLogTraces
	
	/**
	 * Used to see if debug message tracing is on or off.
	 */
	bool Debugger::isLogTraces()
	{
		return m_bLogTraces;
	} // end isLogMessages

	/**
 	 * Used to set the tracing of exceptions on/off.
   */			    	
	void Debugger::setLogExceptions(bool bLogExceptions)
	{
		m_bLogExceptions = m_bLogExceptions;
	} // end setLogExceptions
	
	/**
	 * Used to see if the tracing of exceptions if on or off.
	 */
	bool Debugger::isLogExceptions()
	{
		return m_bLogExceptions;
	} // end isLogExceptions
		
	/**
	 * This method will trace a SQL query.
	 */
	void Debugger::logSQL(const string & rstrFunctionName, const string & rstrSQL)
	{
		if (m_bLogSQL == true)
		{
			cout << rstrFunctionName << " [TRACE SQL] : " << rstrSQL << "\n";
		} // end if debugging sql is on
	} // end debugSQL 				

	/**
	 * This method will trace when a function is entered.
	 */
	void Debugger::entered(const string & rstrFunctionName)
	{
		if (m_bLogFunctions == true)
		{
			cout << rstrFunctionName << " [ENTERED]\n";
		} // end if debugging of functions is on
	} // end entered 				

	/**
	 * This method will trace when a function is exited.
	 */
	void Debugger::exited(const string & rstrFunctionName)
	{
		if (m_bLogFunctions == true)
		{
			cout << rstrFunctionName << " [EXITED]\n";
		} // end if debugging of functions is on
	} // end exited 				

	/**
	 * This method will trace normal debug messages.
	 */
	void Debugger::logTrace(const string & rstrFunctionName, const string & rstrMessage)
	{
		if (m_bLogTraces == true)
		{
			cout << rstrFunctionName << " [TRACE MESSAGE] : " << rstrMessage << "\n";
		} // end if tracing of debug messages is on
	} // end logTrace

	/**
	 * This method will trace exceptions.
	 */
	void Debugger::logException(const string & rstrFunctionName, const VPException & roException)
	{
		if (m_bLogExceptions == true)
		{
			cout << rstrFunctionName << " [EXCEPTION] : " << roException.getExceptionDescription() << "\n";
			cout << "Exception name : " << roException.getExceptionName();
			cout << "Exception from : " << roException.getExceptionClassName() << "::" << roException.getExceptionMethodName() << "\n";
		} // end if debug exception is on
	} // end logException
