/*
 * SequenceList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package pgclibrary.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class SequenceList extends TreeInfo {
    
    /** Creates a new instance of SequenceList */
    public SequenceList(RootElement source) {
        super(source);
        setIcon("/images/sequence.png");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            PreparedStatement prep = getConnection().prepareStatement("SELECT OID FROM PG_CLASS WHERE RELKIND='S' ORDER BY RELNAME");
            ResultSet rs = prep.executeQuery();
            while(rs.next()){
                addProperty(new Element(this, new Sequence(getDatabase(), rs.getLong("OID"))));
            }
            rs.close();
            prep.close();
        } catch (SQLException e){}
    }
    
    public long getOID() {
        return -2;
    }
    
    public String toString(){
        return "Sequences";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
