/*
 * SQLExecution.java
 *
 * Created on 19 de julio de 2002, 10:15
 */

package frames;

import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.io.*;

/**
 *
 * @author  nestor
 */
public class SQLExecutionFrame extends JFrame {
    PrincipalFrame frame = null;
    SQLExecutionListener listener = null;
    SQLExecutionMenu menu = null;
    SQLExecutionToolbar toolbar = null;
    SQLExecutionComponent component = null;
    
    FileWriter log_writer = null;
    BufferedWriter log_output = null;
    
    /** Creates a new instance of SQLExecution */
    public SQLExecutionFrame(PrincipalFrame _frame) {
        super("SQL Execution");
        frame = _frame;
        
        listener = new SQLExecutionListener(this);
        
        menu = new SQLExecutionMenu(this);
        setJMenuBar(menu);
        toolbar = new SQLExecutionToolbar(this);
        getContentPane().add(toolbar, BorderLayout.NORTH);
        component = new SQLExecutionComponent(this);
        getContentPane().add(component, BorderLayout.CENTER);
        
        addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e) {
                close();
            }
        });
        
        addKeyListener(new KeyAdapter(){
            public void keyPressed(KeyEvent evt){
                int key_code = evt.getKeyCode();
                if(key_code == evt.VK_F5){
                    execute();
                }
                if(key_code == evt.VK_F4){
                    executeAll();
                }
                if ((key_code == evt.VK_ENTER) && ((evt.getModifiers() & evt.CTRL_MASK) != 0)){
                    execute();
                }
                if ((key_code == evt.VK_Z) && ((evt.getModifiers() & evt.CTRL_MASK) != 0)){
                    undo();
                }
                if ((key_code == evt.VK_R) && ((evt.getModifiers() & evt.CTRL_MASK) != 0)){
                    redo();
                }
            }
        });
        
        enableEvents(java.awt.Event.GOT_FOCUS);
        
        pack();
    }
    
    public void close(){
        cancelLog();
        disableEvents(java.awt.Event.GOT_FOCUS);
        this.dispose();
    }
    
    public void  refreshValidation(){
        if(frame != null){
            menu.refreshValidation();
            toolbar.refreshValidation();
            component.refreshValidation();
        }
    }
    
    public void saveFile(){
        JFileChooser fc = new JFileChooser();
        int retval = fc.showOpenDialog(this);
        if(retval == fc.APPROVE_OPTION){
            try{
                FileWriter write = new FileWriter(fc.getSelectedFile().getAbsolutePath(), false);
                BufferedWriter output = new BufferedWriter(write);
                output.write(component.getText().getText());
                output.close();
                write.close();
            } catch (Exception e){
                JOptionPane.showMessageDialog(this, e.getMessage(), "File operation error", JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    public void openFile(){
        JFileChooser fc = new JFileChooser();
        int retval = fc.showOpenDialog(this);
        if ((retval == fc.APPROVE_OPTION) && (fc.getSelectedFile().isFile())){
            try{
                FileReader read_options = new FileReader(fc.getSelectedFile().getAbsolutePath());
                BufferedReader input = new BufferedReader(read_options);
                component.getText().setText("");
                String tmp = input.readLine();
                while(tmp != null){
                    component.appendText(tmp);
                    component.appendText("\n");
                    tmp = input.readLine();
                }
                input.close();
                read_options.close();
            } catch (Exception e){
                JOptionPane.showMessageDialog(this, e.getMessage(), "File operation error", JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
    
    public boolean isLogActive(){
        return (log_writer != null) && (log_output!= null);
    }
    private void writeLog(String _log){
        if(isLogActive()){
            try{
                log_output.write(_log);
                log_output.write("\n");
            } catch (Exception e){}
        }
    }
    public void initLog(){
        if(!isLogActive()){
            JFileChooser fc = new JFileChooser();
            int retval = fc.showOpenDialog(this);
            if(retval == fc.APPROVE_OPTION){
                try{
                    log_writer = new FileWriter(fc.getSelectedFile().getAbsolutePath(), true);
                    log_output = new BufferedWriter(log_writer);
                    writeLog("Log initialized At :" + Utilities.formatDate(new java.util.Date(), Utilities.FORMAT_DATETIME));
                } catch (Exception e){
                    JOptionPane.showMessageDialog(this, e.getMessage(), "File operation error", JOptionPane.ERROR_MESSAGE);
                    log_writer = null;
                    log_output = null;
                }
            }
        }
        refreshValidation();
    }
    public void cancelLog(){
        if(isLogActive()){
            try{
                log_writer.flush();
                log_output.flush();
            } catch (Exception e){}
            try{
                log_writer.close();
                log_output.close();
            } catch (Exception e){}
            log_writer = null;
            log_output = null;
        }
        refreshValidation();
    }
    
    public void executeAll(){
        MainConnection tmp_con = new MainConnection(frame.getDatabase().getConnection());
        boolean executed_command = true;
        try{
            tmp_con.getConnection().setAutoCommit(false);
            
            SQLTextParser tp = new SQLTextParser(component.getText());
            String query = tp.getFirstCommand();
            while((query.length() > 0) && (executed_command)){
                executed_command = execute(tmp_con, query);
                query = tp.getNextCommand();
            }
        } catch (SQLException e){
        }
        try{
            if(executed_command){
                tmp_con.getConnection().commit();
            } else {
                tmp_con.getConnection().rollback();
            }
        } catch (SQLException ex){}
        tmp_con.close();
    }
    
    public void execute(){
        try{
            JTextPane text = component.getText();
            SQLTextParser tp = new SQLTextParser(component.getText());
            
            String query = tp.getCommand(text.getCaretPosition());
            execute(frame.getDatabase().getConnection(), query);
        } catch (Exception e){
        }
    }
    
    private boolean execute(MainConnection conn, String query) {
        boolean retorno = true;
        query = query.trim();
        if(query.length() > 0){
            if(conn.isQuery(query)){
                dataSourceResultSet dsrs = new dataSourceResultSet(conn, query);
                try{
                    dsrs.requery();
                    component.getTable().getTableModel().setDataSource(dsrs);
                } catch (SQLException e) {
                    component.getTable().getTableModel().setDataSource(null);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "SQL error", JOptionPane.ERROR_MESSAGE);
                    retorno = false;
                }
            } else {
                component.getTable().getTableModel().setDataSource(null);
                try{
                    int i = conn.executeUpdate(query);
                    JOptionPane.showMessageDialog(this, "Query executed \n rows updated: " + String.valueOf(i), "SQL message", JOptionPane.INFORMATION_MESSAGE);
                } catch (SQLException e){
                    JOptionPane.showMessageDialog(this, e.getMessage(), "SQL error", JOptionPane.ERROR_MESSAGE);
                    retorno = false;
                }
            }
            writeLog(query+";");
        }
        return retorno;
    }
    
    public void processFocusEvent(FocusEvent e){
        refreshValidation();
        super.processFocusEvent(e);
    }
    
    public SQLExecutionListener getListener(){
        return listener;
    }
    public PrincipalFrame getPrincipalFrame(){
        return frame;
    }
    
    public void undo(){
        component.undo();
    }
    public void redo(){
        component.redo();
    }
}

