/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;

public class TableIndex
extends DBObject {
    private boolean clustered = false;
    private boolean keytype = false;
    private boolean unique = false;
    private boolean primary = false;
    private Vector columns = null;

    public TableIndex(DBObject owner, long oid) {
        super(owner);
        this.search(oid);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append(" DROP INDEX ");
        retorno.append(this.getName()).append(";\n");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        if (this.isPrimary()) {
            retorno.append("CONSTRAINT ");
            retorno.append(this.getName());
            retorno.append(" PRIMARY KEY (");
            retorno.append(this.getColumnsText());
            retorno.append(" ) \n");
        } else {
            retorno.append("CREATE ");
            if (this.isUnique()) {
                retorno.append("UNIQUE ");
            }
            retorno.append("INDEX ");
            retorno.append(this.getName());
            retorno.append(" ON ");
            retorno.append(this.getOwner().getName());
            retorno.append(" ( ");
            retorno.append(this.getColumnsText());
            retorno.append(" ); \n");
        }
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(long _oid) {
        boolean retorno = false;
        try {
            PreparedStatement prep = this.getConnection().prepareStatement("select  indexrelid as oid, RELNAME as INDNAME,  INDISCLUSTERED, INDHASKEYTYPE,  INDISUNIQUE, INDISPRIMARY  from pg_index, pg_class  where pg_class.oid = indexrelid and indexrelid = ? ");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if (rs != null && rs.next()) {
                this.setOID(rs.getLong("OID"));
                this.setName(rs.getString("INDNAME"));
                this.setClustered(rs.getBoolean("INDISCLUSTERED"));
                this.setHasKeyType(rs.getBoolean("INDHASKEYTYPE"));
                this.setUnique(rs.getBoolean("INDISUNIQUE"));
                this.setPrimary(rs.getBoolean("INDISPRIMARY"));
                retorno = true;
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.clustered = false;
        this.keytype = false;
        this.unique = false;
        this.primary = false;
        this.columns = null;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                PreparedStatement prep = this.getConnection().prepareStatement("select *  from pg_attribute      where attrelid=? AND ATTNUM > 0");
                prep.setLong(1, this.getOID());
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    TableColumn tc = new TableColumn(this, rs.getLong("ATTNUM"));
                    this.columns.add(tc);
                }
                rs.close();
                prep.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.columns;
    }

    public String getColumnsText() {
        StringBuffer retorno = new StringBuffer();
        int i = 0;
        while (i < this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.columns.get(i);
            retorno.append(tc.getName());
            if (i < this.columns.size() - 1) {
                retorno.append(", ");
            }
            ++i;
        }
        return retorno.toString();
    }

    public int getColumnIndex(String _column_name) {
        _column_name = _column_name.toUpperCase();
        int retorno = -1;
        if (_column_name != null) {
            int i = 0;
            while (i < this.getColumns().size() && retorno < 0) {
                TableColumn tc = (TableColumn)this.columns.get(i);
                if (tc.getName().toUpperCase().equals(_column_name)) {
                    retorno = i;
                }
                ++i;
            }
        }
        return retorno;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean _clustered) {
        this.clustered = _clustered;
    }

    private void setHasKeyType(boolean _keytype) {
        this.keytype = _keytype;
    }

    public boolean hasKeyType() {
        return this.keytype;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean _unique) {
        this.unique = _unique;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean _primary) {
        this.primary = _primary;
    }
}

