/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.PrincipalFrame;
import frames.SQLExecutionComponent;
import frames.SQLExecutionListener;
import frames.SQLExecutionMenu;
import frames.SQLExecutionToolbar;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.dataaccess.dataSourceResultSet;
import pgclibrary.utilities.SQLTextParser;
import pgclibrary.utilities.Utilities;

public class SQLExecutionFrame
extends JFrame {
    PrincipalFrame frame = null;
    SQLExecutionListener listener = null;
    SQLExecutionMenu menu = null;
    SQLExecutionToolbar toolbar = null;
    SQLExecutionComponent component = null;
    FileWriter log_writer = null;
    BufferedWriter log_output = null;

    public SQLExecutionFrame(PrincipalFrame _frame) {
        super("SQL Execution");
        this.frame = _frame;
        this.listener = new SQLExecutionListener(this);
        this.menu = new SQLExecutionMenu(this);
        this.setJMenuBar(this.menu);
        this.toolbar = new SQLExecutionToolbar(this);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.component = new SQLExecutionComponent(this);
        this.getContentPane().add((Component)this.component, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SQLExecutionFrame.this.close();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int key_code = evt.getKeyCode();
                if (key_code == 116) {
                    SQLExecutionFrame.this.execute();
                }
                if (key_code == 115) {
                    SQLExecutionFrame.this.executeAll();
                }
                if (key_code == 10 && (evt.getModifiers() & 2) != 0) {
                    SQLExecutionFrame.this.execute();
                }
                if (key_code == 90 && (evt.getModifiers() & 2) != 0) {
                    SQLExecutionFrame.this.undo();
                }
                if (key_code == 82 && (evt.getModifiers() & 2) != 0) {
                    SQLExecutionFrame.this.redo();
                }
            }
        });
        this.enableEvents(1004L);
        this.pack();
    }

    public void close() {
        this.cancelLog();
        this.disableEvents(1004L);
        this.dispose();
    }

    public void refreshValidation() {
        if (this.frame != null) {
            this.menu.refreshValidation();
            this.toolbar.refreshValidation();
            this.component.refreshValidation();
        }
    }

    public void saveFile() {
        JFileChooser fc = new JFileChooser();
        int retval = fc.showOpenDialog(this);
        if (retval == 0) {
            try {
                FileWriter write = new FileWriter(fc.getSelectedFile().getAbsolutePath(), false);
                BufferedWriter output = new BufferedWriter(write);
                output.write(this.component.getText().getText());
                output.close();
                write.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "File operation error", 0);
            }
        }
    }

    public void openFile() {
        JFileChooser fc = new JFileChooser();
        int retval = fc.showOpenDialog(this);
        if (retval == 0 && fc.getSelectedFile().isFile()) {
            try {
                FileReader read_options = new FileReader(fc.getSelectedFile().getAbsolutePath());
                BufferedReader input = new BufferedReader(read_options);
                this.component.getText().setText("");
                String tmp = input.readLine();
                while (tmp != null) {
                    this.component.appendText(tmp);
                    this.component.appendText("\n");
                    tmp = input.readLine();
                }
                input.close();
                read_options.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "File operation error", 0);
            }
        }
    }

    public boolean isLogActive() {
        return this.log_writer != null && this.log_output != null;
    }

    private void writeLog(String _log) {
        if (this.isLogActive()) {
            try {
                this.log_output.write(_log);
                this.log_output.write("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initLog() {
        JFileChooser fc;
        int retval;
        if (!this.isLogActive() && (retval = (fc = new JFileChooser()).showOpenDialog(this)) == 0) {
            try {
                this.log_writer = new FileWriter(fc.getSelectedFile().getAbsolutePath(), true);
                this.log_output = new BufferedWriter(this.log_writer);
                this.writeLog("Log initialized At :" + Utilities.formatDate(new Date(), "dd/MM/yyyy HH:mm:ss"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "File operation error", 0);
                this.log_writer = null;
                this.log_output = null;
            }
        }
        this.refreshValidation();
    }

    public void cancelLog() {
        if (this.isLogActive()) {
            try {
                this.log_writer.flush();
                this.log_output.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.log_writer.close();
                this.log_output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log_writer = null;
            this.log_output = null;
        }
        this.refreshValidation();
    }

    public void executeAll() {
        MainConnection tmp_con = new MainConnection(this.frame.getDatabase().getConnection());
        boolean executed_command = true;
        try {
            tmp_con.getConnection().setAutoCommit(false);
            SQLTextParser tp = new SQLTextParser(this.component.getText());
            String query = tp.getFirstCommand();
            while (query.length() > 0 && executed_command) {
                executed_command = this.execute(tmp_con, query);
                query = tp.getNextCommand();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (executed_command) {
                tmp_con.getConnection().commit();
            } else {
                tmp_con.getConnection().rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        tmp_con.close();
    }

    public void execute() {
        try {
            JTextPane text = this.component.getText();
            SQLTextParser tp = new SQLTextParser(this.component.getText());
            String query = tp.getCommand(text.getCaretPosition());
            this.execute(this.frame.getDatabase().getConnection(), query);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean execute(MainConnection conn, String query) {
        boolean retorno = true;
        if ((query = query.trim()).length() > 0) {
            if (MainConnection.isQuery(query)) {
                dataSourceResultSet dsrs = new dataSourceResultSet(conn, query);
                try {
                    dsrs.requery();
                    this.component.getTable().getTableModel().setDataSource(dsrs);
                }
                catch (SQLException e) {
                    this.component.getTable().getTableModel().setDataSource(null);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "SQL error", 0);
                    retorno = false;
                }
            } else {
                this.component.getTable().getTableModel().setDataSource(null);
                try {
                    int i = conn.executeUpdate(query);
                    JOptionPane.showMessageDialog(this, "Query executed \n rows updated: " + String.valueOf(i), "SQL message", 1);
                }
                catch (SQLException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "SQL error", 0);
                    retorno = false;
                }
            }
            this.writeLog(query + ";");
        }
        return retorno;
    }

    public void processFocusEvent(FocusEvent e) {
        this.refreshValidation();
        super.processFocusEvent(e);
    }

    public SQLExecutionListener getListener() {
        return this.listener;
    }

    public PrincipalFrame getPrincipalFrame() {
        return this.frame;
    }

    public void undo() {
        this.component.undo();
    }

    public void redo() {
        this.component.redo();
    }
}

