/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.SQLTable;
import components.SQLTableModel;
import components.table.DataPanelListener;
import components.table.DataPanelOrderDialog;
import components.table.DataPanelToolbar;
import components.table.TableAddRecordDialog;
import components.table.TableEditRecordDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSourceResultSet;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.TableIndex;

public class DataPanel
extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private DataPanelListener listener = null;
    private Hashtable tales_order = new Hashtable(100);

    public DataPanel() {
        this.data_table = new SQLTable();
        this.listener = new DataPanelListener(this);
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SQLTableModel sql_tm = new SQLTableModel(this.data_table);
        this.data_table.setModel(sql_tm);
        this.add((Component)new DataPanelToolbar(this), "North");
        this.add((Component)new JScrollPane(this.data_table), "Center");
    }

    public void refresh() {
        this.data_table.getTableModel().setDataSource(new dataSourceResultSet(this.table.getConnection(), this.generateSQL()));
        this.repaint();
    }

    public void refresh(Table table_object) {
        this.table = table_object;
        this.refresh();
    }

    private String generateSQL() {
        StringBuffer retorno = new StringBuffer();
        if (this.table != null) {
            retorno.append("SELECT * FROM ").append(this.table.getName());
            Vector order = this.getOrder();
            if (order.size() > 0) {
                retorno.append(" ORDER BY ");
                int i = 0;
                while (i < order.size()) {
                    retorno.append(order.get(i));
                    if (i < order.size() - 1) {
                        retorno.append(", ");
                    } else {
                        retorno.append(" ");
                    }
                    ++i;
                }
            }
        }
        return retorno.toString();
    }

    public void addOrder(String _column) {
        if (_column != null && this.getOrderPos(_column) < 0) {
            this.getOrder().add(_column);
        }
    }

    public void clearOrder() {
        this.getOrder().removeAllElements();
    }

    public int getOrderPos(String _column) {
        int retorno = -1;
        Vector order = this.getOrder();
        int i = 0;
        while (i < order.size() && retorno < 0) {
            if (((String)order.get(i)).equals(_column)) {
                retorno = i;
            }
            ++i;
        }
        return retorno;
    }

    public Vector getOrder() {
        Vector retorno = (Vector)this.tales_order.get(this.table.getName());
        if (retorno == null) {
            retorno = new Vector();
            this.tales_order.put(this.table.getName(), retorno);
        }
        return retorno;
    }

    public Table getTable() {
        return this.table;
    }

    public DataPanelListener getListener() {
        return this.listener;
    }

    public void showOrderDialog() {
        new DataPanelOrderDialog(this).show();
    }

    public void newRecord() {
        new TableAddRecordDialog(this.getTable()).show();
        this.refresh();
    }

    public void editRecord() {
        int selected = this.data_table.getSelectedRow();
        if (this.table.getPrimaryKeys().size() > 0) {
            Vector<Object> index_data = new Vector<Object>();
            int i = 0;
            while (i < this.data_table.getColumnCount()) {
                index_data.add(this.data_table.getValueAt(selected, i));
                ++i;
            }
            new TableEditRecordDialog(this.getTable(), index_data).show();
        } else {
            JOptionPane.showMessageDialog(this, "Table has no primary keys defined.", "Error", 1);
        }
        this.refresh();
    }

    public void deleteRecord() {
        if (JOptionPane.showConfirmDialog(this, "Delete selected records ?", "Error.", 0) == 0) {
            if (this.table.getPrimaryKeys().size() > 0) {
                Vector columns = ((TableIndex)this.table.getPrimaryKeys().get(0)).getColumns();
                int[] columnsidx = new int[columns.size()];
                int i = 0;
                while (i < columns.size()) {
                    columnsidx[i] = this.table.getColumnIndex(((TableColumn)columns.get(i)).getName());
                    ++i;
                }
                int[] selected = this.data_table.getSelectedRows();
                int i2 = 0;
                while (i2 < selected.length) {
                    int j = 0;
                    while (j < columnsidx.length) {
                        Vector<Object> temp = new Vector<Object>();
                        temp.add(this.data_table.getValueAt(selected[i2], columnsidx[j] + 1));
                        try {
                            this.table.deleteRecord(temp);
                        }
                        catch (SQLException e) {
                            JOptionPane.showMessageDialog(this, e.getMessage(), "Error.", 1);
                        }
                        ++j;
                    }
                    ++i2;
                }
            } else {
                JOptionPane.showMessageDialog(this, "Table has no primary keys defined.", "Error", 1);
            }
        }
        this.refresh();
    }
}

