%{

#include "database.h"

int yylex(void);

%}

%union
{
 char str[55];
 int num;
}


%token <str> STRING
%token <num> NUM

%token <num> INTERVAL
%token <num> UNIT
%token <str> USERNAME
%token <str> PASSWORD
%token <num> INSERTTHRESHOLD
%token <num> UPDATETHRESHOLD
%token <num> DELETETHRESHOLD

%token <str> DATABASE
%token <str> ENDDATABASE

%%
config:		directiveList
			|   databases
			;
			
databases: startDatabase directiveList endDatabase
					;
	
directiveList:
						| directiveList directive	 			
						;	

directive: interval													
				 | username
				 | password
				 | insertThreshold
				 | updateThreshold
				 | deleteThreshold
				 | unit
				 ;	


startDatabase: DATABASE STRING 		{
																				tmpdb=new database();
																				
																				if(!tmpdb)
																				{
																				 fprintf(stderr,"No memory. Quitting..\n");
																				 _exit(-1);
																				}
																				/*inherit the global settings so far*/
																				*tmpdb=*global;
																				strncpy(tmpdb->dbname,$2,50);
																				/*OK Now. This is where new information should go*/
																				currentObject=tmpdb;		
																				
																				isGlobal=false;																	
																	};
endDatabase:	 ENDDATABASE 				{databaseList->add((void *)currentObject);
																	 currentObject->status = true;
  																 currentObject=global;
  																 isGlobal=true;
																	};

interval: INTERVAL '=' NUM					{ currentObject->interval=$3;};
unit:  		UNIT '=' NUM							{ if(isGlobal)unit=$3;};

username: USERNAME '=' STRING     { strncpy(currentObject->username,$3,50);};
password: PASSWORD '=' STRING			{ strncpy(currentObject->password,$3,50);};

insertThreshold: INSERTTHRESHOLD '=' NUM 		{ currentObject->insertThreshold=$3;};
updateThreshold: UPDATETHRESHOLD '=' NUM 		{ currentObject->updateThreshold=$3;};
deleteThreshold: DELETETHRESHOLD '=' NUM 		{ currentObject->deleteThreshold=$3;};
				
%%
