""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

import re
from string import *
from log import LOG
from object import *

class CSV(Object):
	def __init__(self, file, log = LOG('CSV.log'), separator = '|'):
		Object.__init__(self, 'CSV')

		self.file = file
		self.log = log
		self.sep = separator
		self.data = []
		self._load() # load file in memory

	def _load(self):
		fd = open(self.file,'r')
		content = fd.readlines()
		self.data = map(split,content,len(content)*[self.sep])
		for i in range(0,len(self.data)): # strip spaces
			self.data[i]=map(strip,self.data[i])
		fd.close()

	def default_value(self, index, rege, default):
		reg=re.compile(rege)
		for j in range(0,len(self.data)):
			val=self.data[j][index]
			m = reg.match(val)
			if (not m or m.end() != len(val)):
				self.data[j][index]=default
				
	def valeurDefaut(self, index, rege, defaut): # here for backward compatibility (deprecated)
		self.default_value(index, rege, defaut)

	def load(self):
		for line in self.data: 
			self.load_line(line)
		
	def chargeCSV(self): # here for backward compatibility (deprecated)
		self.load()
		
	def load_line(self, line): # need to be overloaded
		self.chargeLigne(line) # here for backward compatibility
		
	def chargeLigne(self, ligne): # here for backward compatibility (deprecated)
		print 'CSV ?? ',ligne
