#! /bin/bash

case $DEBUG in
  1) set -x
     ;;
  *)
     ;;
esac

error() { # juste pour usage
		echo $1 1>&2
}

usage() {
		error "usage : create-db.sh [-h] -H <host> -d <dbname> -u <user> -p <password> -l <log file>"
		error "example : create-db.sh -H bonnie -d barbie -u pimentech -p \"\" -l create-db.log"
}

while true
do
  case $1 in
	-H) host="$2"
		shift 2
		;;
    -u)	user="$2"
        shift 2
        ;;
    -p) password="$2"
        shift 2
        ;;
	-d) dbname="$2"
		shift 2
		;;
	-l) logfile="$2"
		shift 2
		;;
    -h) usage
		exit 0
		;;
     *)
		break
		;;
  esac
done

if [ -z "$dbname" -o -z "$host" -o -z "$user" -o -z "$logfile" ] 
then
		usage
		exit 1
fi

date=`date '+%d-%m-%Y'`
error() {
		echo "ERROR:create-db.sh:$date: $1" 1>&2
		echo "ERROR:create-db.sh:$date: $1" >> $logfile
}

expect -- <<EOC

#	exp_internal -f $logfile 0

 	log_user 0

	spawn -noecho createdb -h $host $dbname -U $user -W

	expect { 
		"Password: " { send -- "$password\r" }
		timeout { send_error -- "timeout detected on login\n" }
	} 

	set timeout -1

	expect {
		"\nCREATE DATABASE" { send_user -- "CREATE DATABASE\n" }
		-re "\n(ERROR.*)\r" { send_error -- "\$expect_out(1,string)\n" }
		-re "\n(psql: Password authentication failed for user.*)\r" { send_error -- "\$expect_out(1,string)\n" }
	}

    exit [ lindex [ wait ] 3 ]

EOC

err=$?

if [ $err -ne 0 ]
then
	error "cannot create $dbname@$host"
fi

exit $err
