/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.tree.AbstractBranch;

public class BackedList
extends ArrayList {
    private List branchContent;
    private AbstractBranch branch;

    public BackedList(AbstractBranch branch, List branchContent) {
        this(branch, branchContent, branchContent.size());
    }

    public BackedList(AbstractBranch branch, List branchContent, int capacity) {
        super(capacity);
        this.branch = branch;
        this.branchContent = branchContent;
    }

    public BackedList(AbstractBranch branch, List branchContent, List initialContent) {
        super(initialContent);
        this.branch = branch;
        this.branchContent = branchContent;
    }

    public void add(int index, Object object) {
        int realIndex = this.branchContent.indexOf(this.get(index));
        if (realIndex < 0) {
            int n = realIndex = index == 0 ? 0 : Integer.MAX_VALUE;
        }
        if (realIndex < this.branchContent.size()) {
            this.branchContent.add(realIndex, object);
        } else {
            this.branchContent.add(object);
        }
        this.branch.childAdded(this.asNode(object));
        super.add(index, object);
    }

    public boolean add(Object object) {
        this.branch.addNode(this.asNode(object));
        return super.add(object);
    }

    public boolean addAll(int index, Collection collection) {
        this.ensureCapacity(this.size() + collection.size());
        int count = this.size();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            --count;
        }
        return count != 0;
    }

    public boolean addAll(Collection collection) {
        this.ensureCapacity(this.size() + collection.size());
        int count = this.size();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
            --count;
        }
        return count != 0;
    }

    public void addLocal(Object object) {
        super.add(object);
    }

    protected Node asNode(Object object) {
        if (object instanceof Node) {
            return (Node)object;
        }
        throw new IllegalAddException("This list must contain instances of Node. Invalid type: " + object);
    }

    public void clear() {
        Iterator iter = ((AbstractList)this).iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            this.branchContent.remove(object);
            this.branch.childRemoved(this.asNode(object));
        }
        super.clear();
    }

    public Object remove(int index) {
        Object object = super.remove(index);
        if (object != null) {
            this.branch.removeNode(this.asNode(object));
        }
        return object;
    }

    public boolean remove(Object object) {
        this.branch.removeNode(this.asNode(object));
        return super.remove(object);
    }

    public Object set(int index, Object object) {
        int realIndex = this.branchContent.indexOf(this.get(index));
        if (realIndex < 0) {
            int n = realIndex = index == 0 ? 0 : Integer.MAX_VALUE;
        }
        if (realIndex < this.branchContent.size()) {
            this.branchContent.set(realIndex, object);
        } else {
            this.branchContent.add(object);
        }
        this.branch.childAdded(this.asNode(object));
        return super.set(index, object);
    }
}

