/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.EditableUserList;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;

public class GameAccessList
extends DFrame
implements ActionListener,
EventListener {
    private final Client client;
    private final CGame game;
    private final EditableUserList accessList;

    public GameAccessList(Client client, CGame game, Component parent) {
        super(Defs.getString(112, game.getGameSummary().getLocalDesc()), parent);
        this.client = client;
        this.game = game;
        this.accessList = new EditableUserList(client, Defs.getString(-903340819));
        this.getMainPanel().add("xGrow=t,yGrow=t", this.accessList);
        this.accessList.addListener(this);
        this.addButton(Defs.getString(1436228514), this);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 23: {
                this.accessList.clear();
                this.accessList.addAll(this.game.getAccessList().values());
                break;
            }
            case 25: {
                String name = (String)event.arg;
                this.accessList.setAddText(name);
                new Errout(Defs.getString(-903340718, name), this);
                break;
            }
            case 135: {
                this.game.sendAddAccess((String)event.arg);
                break;
            }
            case 137: {
                User u = (User)event.arg;
                if (u.name.equals(this.client.getMe().name)) {
                    new Errout(Defs.getString(-903340670), this);
                    return;
                }
                if (this.game.gameType.isMainRole(this.game.getRole(u.name))) {
                    new Errout(Defs.getString(149, u.name), this);
                    break;
                }
                this.game.sendRemoveAccess(u.name);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.dispose();
    }

    @Override
    public void addNotify() {
        this.game.addListener(this);
        this.accessList.clear();
        this.accessList.addAll(this.game.getAccessList().values());
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.game.removeListener(this);
        super.removeNotify();
    }

    @Override
    protected String getSavePositionPref() {
        return "JaX@ryJM";
    }
}

