.TH FBCLEAN 1 25-Jun-90
.CM 3
.SH NAME
fbclean \- flip isolated pixels in a 1bit image
.SH SYNOPSIS
.nf
fbclean [ -b<cleaner> -t<threshhold> -n<nbr> ] [ -<type> ] < bitmap > bitmap
.fi
.SH DESCRIPTION
.PP
Flips isolated pixels (this can be used to clean up "snow" in some
halftoned images.  Can also convert a grayscale image to bitmap by
theshholding before the cleaning is done.
.SH OPTIONS
.TP
.B -b
.I cleaner
option, specifies the minimum number of "nearby" like pixels to remain
the same color.
.TP
.B -n
.I neighbors,
the size of the neighborhood.  To be "nearby" means to be located in an
NxN square around the target pixel.
.TP
.B -t
.I threshhold
command, used to halftone the image before cleaning.  The default is no
theshholding.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.PP
.SH EXAMPLE
.PP
To take a bitmap and clean up pixels with fewer than 2 like neighbors
in the surrounding 5x5 square, outputing s Sun rasterfile:
.sp
   % fbclean -S -b2 -n5 < foo.1bit > bar.1bit
.sp
To do the same thing to a grayscale file (threshholding first with 128):
.sp
    % fbclean -S -b2 -n5 -t128 < foo.1bit > bar.1bit
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Gary Sherwin & Michael Mauldin.
Permission is granted to use this file in whole or in part for
any purpose, educational, recreational or commercial, provided
that this copyright notice is retained unchanged.  This software
is available to all free of charge by anonymous FTP and in the
UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
