/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.movie;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyleConstants;
import org.igoweb.go.Game;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.CommentLogViewer;
import org.igoweb.go.swing.GameLayout;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.Sounds;
import org.igoweb.go.swing.sgf.movie.Controller;
import org.igoweb.go.swing.sgf.movie.PointerGoban;
import org.igoweb.go.swing.sgf.movie.SpeexPlayer;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.LabelPair;
import org.igoweb.util.swing.SmartClip;

public class PlayerPanel
extends GamePanel
implements EventListener,
ChangeListener {
    private Controller controller;
    private SmartClip moveSound;
    private JSlider stoneVol;
    private JSlider voiceVol;
    private SpeexPlayer speexPlayer;
    private boolean audioSuppressed = false;

    public PlayerPanel(Tree tree, Controller controller, SpeexPlayer speexPlayer) {
        this.controller = controller;
        this.speexPlayer = speexPlayer;
        this.moveSound = Sounds.get("stone");
        this.init(tree, new GameLayout(this));
        tree.addListener(this);
    }

    public void clearComments() {
        ((CommentLogViewer)this.getCommentWidget()).clear();
    }

    public void clearTree() {
        while (this.getSgfTree().root.countChildren() > 0) {
            this.getSgfTree().delete(this.getSgfTree().root.getChild(0));
        }
        Iterator<Prop> iter = this.getSgfTree().root.iterator();
        while (iter.hasNext()) {
            if (iter.next().type == 0) continue;
            iter.remove();
        }
    }

    @Override
    protected JComponent buildCommentWidget() {
        CommentLogViewer comments = new CommentLogViewer(this.getSgfTree());
        StyleConstants.setForeground(comments.getAttributes(2), Color.black);
        return comments;
    }

    @Override
    public void changeActiveNode(Node node) {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
    }

    @Override
    public void closePressed() {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
    }

    @Override
    protected AFrame buildGameInfoWindow() {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
        return null;
    }

    @Override
    protected String helpUrl() {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
        return null;
    }

    @Override
    public void addProp(Node node, Prop param) {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
    }

    @Override
    public void removeProp(Node node, Prop param) {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
    }

    @Override
    public void addNode(Node parent, boolean makeActive) {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
    }

    @Override
    protected void changeScoreMarks(boolean tryToRemove) {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
    }

    @Override
    protected boolean changeWhoseMove(int newWhoseMove) {
        System.err.println("UNSUPPORTED OPERATION");
        Thread.dumpStack();
        return false;
    }

    @Override
    protected void buildControlButtonList(ArrayList<JComponent> list) {
        list.add(this.controller);
        list.add(this.controller.getReadoutPanel());
        list.add(this.controller.getButtonPanel());
        LabelPair.Group grp = new LabelPair.Group();
        if (this.stoneVol == null) {
            if (this.isStoneVolumeSliderNeeded()) {
                this.stoneVol = new JSlider(0, 1000);
                this.stoneVol.addChangeListener(this);
                this.stoneVol.setValue((int)(this.moveSound.getVolume() * 1000.0f));
            }
            if (this.speexPlayer != null) {
                this.voiceVol = new JSlider(0, 1000);
                this.voiceVol.addChangeListener(this);
                if (this.speexPlayer.isOpened()) {
                    this.voiceVol.setValue((int)(this.speexPlayer.getVolume() * 1000.0f));
                    this.voiceVol.setEnabled(true);
                } else {
                    this.voiceVol.setEnabled(false);
                    this.speexPlayer.addListener(this);
                }
            }
        }
        if (this.voiceVol != null || this.stoneVol != null) {
            list.add(new JLabel(Defs.getString(-2056691065), 0));
        }
        if (this.voiceVol != null) {
            list.add(new LabelPair(Defs.getString(1603296930), this.voiceVol, grp));
        }
        if (this.stoneVol != null) {
            list.add(new LabelPair(Defs.getString(-193705247), this.stoneVol, grp));
        }
    }

    @Override
    protected void buildButtonPanel(JPanel buttonPanel, ArrayList<JComponent> buttons, boolean wide) {
        super.buildButtonPanel(buttonPanel, buttons, false);
    }

    @Override
    protected GobanWidget buildGobanWidget(Game game) {
        return new PointerGoban(game);
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void handleEvent(Event event) {
        if (event.source == this.speexPlayer) {
            if (event.type == 0) {
                this.voiceStarted();
                this.speexPlayer.removeListener(this);
            }
        } else if (event.type == 0) {
            Prop prop = (Prop)event.arg;
            if (prop.type == 14 && (double)this.controller.getPlaybackSpeed() == 1.0 && !this.audioSuppressed) {
                this.moveSound.play();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.stoneVol) {
            this.moveSound.setVolume((float)this.stoneVol.getValue() / 1000.0f);
        } else {
            this.speexPlayer.setVolume((float)this.voiceVol.getValue() / 1000.0f);
        }
    }

    public void voiceStarted() {
        this.voiceVol.setEnabled(true);
        this.voiceVol.setValue((int)(this.speexPlayer.getVolume() * 1000.0f));
    }

    public void setAudioSuppressed(boolean val) {
        this.audioSuppressed = val;
    }

    protected boolean isStoneVolumeSliderNeeded() {
        return true;
    }
}

