<?php

    /**
     * Spanish language file for phpPgAdmin.
     * @maintainer 2003-2006 Martín Marqués (martin@bugs.unl.edu.ar)
     * @maintainer 2006-2010 xzilla
     * @maintainer 2010-2016 Miguel Useche (migueluseche@skatox.com)
     *
     */
	// Language and character set
	$lang['applang'] = 'Spanish';
	$lang['applocale'] = 'es-ES';
	$lang['applangdir'] = 'ltr';

	// Bienvenido
	$lang['strintro'] = 'Bienvenido a phpPgAdmin.';
	$lang['strppahome'] = 'Página web de phpPgAdmin';
	$lang['strpgsqlhome'] = 'Página web de PostgreSQL';
	$lang['strpgsqlhome_url'] = 'http://www.postgresql.org/';
	$lang['strlocaldocs'] = 'Documentación de PostgreSQL (local)';
	$lang['strreportbug'] = 'Reportar un problema';
	$lang['strviewfaq'] = 'Ver las preguntas frecuentes';
	$lang['strviewfaq_url'] = 'http://phppgadmin.sourceforge.net/doku.php?id=faq';

	// Basic strings
	$lang['strlogin'] = 'Autenticar';
	$lang['strloginfailed'] = 'Falló la autenticación';
	$lang['strlogindisallowed'] = 'Ingreso desactivado por razones de seguridad';
	$lang['strserver'] = 'Servidor';
	$lang['strservers']  =  'Servidores';
	$lang['strgroupservers'] = 'Servidores en el grupo "%s"';
	$lang['strallservers'] = 'Todo los servidores';
	$lang['strintroduction']  =  'Introducción';
	$lang['strhost']  =  'Host';
	$lang['strport']  =  'Puerto';
	$lang['strlogout'] = 'Cerrar sesión';
	$lang['strowner'] = 'Dueño';
	$lang['straction'] = 'Acción';
	$lang['stractions'] = 'Acciones';
	$lang['strname'] = 'Nombre';
	$lang['strdefinition'] = 'Definición';
	$lang['strproperties'] = 'Propiedades';
	$lang['strbrowse'] = 'Examinar';
	$lang['strenable']  =  'Activar';
	$lang['strdisable']  =  'Desactivar';
	$lang['strdrop'] = 'Eliminar';
	$lang['strdropped'] = 'Eliminado';
	$lang['strnull'] = 'Nulo';
	$lang['strnotnull'] = 'No Nulo';
	$lang['strprev'] = '< Previo';
	$lang['strnext'] = 'Siguiente >';
	$lang['strfirst'] = '<< Principio';
	$lang['strlast'] = 'Fin >>';
	$lang['strfailed'] = 'Falló';
	$lang['strcreate'] = 'Crear';
	$lang['strcreated'] = 'Creado';
	$lang['strcomment'] = 'Comentario';
	$lang['strlength'] = 'Longitud';
	$lang['strdefault'] = 'Predeterminado';
	$lang['stralter'] = 'Modificar';
	$lang['strok'] = 'Aceptar';
	$lang['strcancel'] = 'Cancelar';
	$lang['strkill'] = 'Terminar';
	$lang['strac'] = 'Activar AutoCompletado';
	$lang['strsave'] = 'Guardar';
	$lang['strreset'] = 'Reestablecer';
	$lang['strrestart'] = 'Reiniciar';
	$lang['strinsert'] = 'Insertar';
	$lang['strselect'] = 'Seleccionar';
	$lang['strdelete'] = 'Eliminar';
	$lang['strupdate'] = 'Actualizar';
	$lang['strreferences'] = 'Referencia';
	$lang['stryes'] = 'Si';
	$lang['strno'] = 'No';
	$lang['strtrue'] = 'VERDADERO';
	$lang['strfalse'] = 'FALSO';
	$lang['stredit'] = 'Editar';
	$lang['strcolumn']  =  'Columna';
	$lang['strcolumns'] = 'Columnas';
	$lang['strrows'] = 'fila(s)';
	$lang['strrowsaff'] = 'fila(s) afectadas.';
	$lang['strobjects'] = 'objeto(s)';
	$lang['strback'] = 'Atrás';
	$lang['strqueryresults'] = 'Resultado de la consulta';
	$lang['strshow'] = 'Mostrar';
	$lang['strempty'] = 'Vaciar';
	$lang['strlanguage'] = 'Idioma';
	$lang['strencoding'] = 'Codificación';
	$lang['strvalue'] = 'Valor';
	$lang['strunique'] = 'Único';
	$lang['strprimary'] = 'Primaria';
	$lang['strexport'] = 'Exportar';
	$lang['strimport'] = 'Importar';
	$lang['strallowednulls']  =  'Permitir valores nulos';
	$lang['strbackslashn']  =  '\N';
	$lang['stremptystring']  =  'Cadena o campo vacio';
	$lang['strsql'] = 'SQL';
	$lang['stradmin'] = 'Admin';
	$lang['strvacuum'] = 'Limpiar';
	$lang['stranalyze'] = 'Analizar';
	$lang['strclusterindex'] = 'Clúster';
	$lang['strclustered'] = '¿En Clúster?';
	$lang['strreindex'] = 'Actualizar índices';
	$lang['strexecute'] = 'Ejecutar';
	$lang['stradd'] = 'Agregar';
	$lang['strevent'] = 'Evento';
	$lang['strwhere'] = 'Dónde';
	$lang['strinstead'] = 'Hacer en su lugar';
	$lang['strwhen'] = 'Cuándo';
	$lang['strformat'] = 'Formato';
	$lang['strdata'] = 'Dato';
	$lang['strconfirm'] = 'Confirmar';
	$lang['strexpression'] = 'Expresión';
	$lang['strellipsis'] = '...';
	$lang['strseparator']  = ': ';
	$lang['strexpand'] = 'Expandir';
	$lang['strcollapse'] = 'Contraer';
	$lang['strfind'] = 'Buscar';
	$lang['stroptions'] = 'Opciones';
	$lang['strrefresh'] = 'Refrescar';
	$lang['strdownload'] = 'Descargar';
	$lang['strdownloadgzipped'] = 'Descargar comprimido con gzip';
	$lang['strinfo'] = 'Información';
	$lang['stroids'] = 'OIDs';
	$lang['stradvanced'] = 'Avanzado';
	$lang['strvariables'] = 'Variables';
	$lang['strprocess'] = 'Proceso';
	$lang['strprocesses'] = 'Procesos';
	$lang['strblocked'] = 'Bloqueados';
	$lang['strsetting'] = 'Configuración';
	$lang['streditsql'] = 'Editar SQL';
	$lang['strruntime'] = 'Tiempo total de ejecución: %s ms';
	$lang['strpaginate'] = 'Paginar resultados';
	$lang['struploadscript'] = 'o subir un script SQL:';
	$lang['strstarttime'] = 'Hora de comienzo';
	$lang['strfile'] = 'Archivo';
	$lang['strfileimported'] = 'Archivo importado.';
	$lang['strtrycred']  =  'Usar estas crendeciales para todos los servidores';
	$lang['strconfdropcred'] = 'Por razones de seguridad, al desconectar se destruirá tu información compartida. ¿Estás seguro que desea desconectarse?';
	$lang['stractionsonmultiplelines'] = 'Acciones en múltiples líneas';
	$lang['strselectall'] = 'Seleccionar todos';
	$lang['strunselectall'] = 'Seleccionar ninguno';
	$lang['strlocale'] = 'Localización';
	$lang['strcollation'] = 'Colación';
	$lang['strctype'] = 'Tipo de caracter';
	$lang['strdefaultvalues'] = 'Valores por defecto';
	$lang['strnewvalues'] = 'Nuevos valores';
	$lang['strstart'] = 'Iniciar';
	$lang['strstop'] = 'Detener';
	$lang['strgotoppage'] = 'subir al inicio';
	$lang['strtheme'] = 'Tema';
	$lang['strcluster'] = 'Clúster';

	// Admin
	$lang['stradminondatabase'] = 'Las siguientes tareas administrativas aplican a toda la base de datos %s.';
	$lang['stradminontable'] = 'Las siguientes tareas administrativas aplican a la tabla %s.';

	// User-supplied SQL history
	$lang['strhistory'] = 'Historial';
	$lang['strnohistory'] = 'Sin historial.';
	$lang['strclearhistory'] = 'Borrar historial';
	$lang['strdelhistory'] = 'Borrar del historial';
	$lang['strconfdelhistory'] = '¿Desea borrar esta solicitud del historial?';
	$lang['strconfclearhistory'] = '¿Desea borrar el historial?';
	$lang['strnodatabaseselected'] = 'Por favor, seleccione una base de datos.';

	// Database sizes
	$lang['strnoaccess'] = 'Sin acceso';
	$lang['strsize'] = 'Tamaño';
	$lang['strbytes'] = 'bytes';
	$lang['strkb'] = 'kB';
	$lang['strmb'] = 'MB';
	$lang['strgb'] = 'GB';
	$lang['strtb'] = 'TB';

	// Error handling
	$lang['strnoframes']  =  'Esta aplicación funciona mejor con un navegador con soporte para marcos, pero puede usarse sin marcos siguiendo el link de abajo.';
	$lang['strnoframeslink']  =  'Usar sin marcos';
	$lang['strbadconfig'] = 'Su archivo config.inc.php está desactualizado. Deberá regenerarlo a partir del nuevo archivo config.inc.php-dist.';
	$lang['strnotloaded'] = 'Su instalación de PHP no tiene el soporte correcto para PostgreSQL. Deberá recompilar PHP usando la opción --with-pgsql en el configure.';
	$lang['strpostgresqlversionnotsupported']  =  'Su versión de PostgreSQL no está soportada. Por favor actualice a la versión %s o mas reciente.';
	$lang['strbadschema'] = 'El esquema especificado es inválido.';
	$lang['strbadencoding'] = 'No se pudo configurar la codificación del cliente en la base de datos.';
	$lang['strsqlerror'] = 'Error de SQL:';
	$lang['strinstatement'] = 'En la setencia:';
	$lang['strinvalidparam'] = 'Parámetros inválidos del script.';
	$lang['strnodata'] = 'No se encontraron filas.';
	$lang['strnoobjects'] = 'No se encontraron objetos.';
	$lang['strrownotunique'] = 'No existe un identificador único para este registro.';
	$lang['strnouploads'] = 'Está deshabilitada la subida de archivos.';
	$lang['strimporterror'] = 'Error de importación.';
	$lang['strimporterror-fileformat']  =  'Error de importacion: Falló la detección del formato del archivo.';
	$lang['strimporterrorline'] = 'Error de importación en la línea %s.';
	$lang['strimporterrorline-badcolumnnum']  =  'Error de importación en la línea %s:  La línea no posee un número incorrecto de columnas.';
	$lang['strimporterror-uploadedfile']  =  'Error de importación: No se pudo subir el archivo al servidor';
	$lang['strcannotdumponwindows']  =  'El volcado de datos de tablas y esquemas con nombres complejos  no esta soportado en Windows.';
	$lang['strinvalidserverparam'] = 'Intento de conexión al servidor con un parámetro inválido. Posiblemente alguien está intentando atacar tu sistema.';
	$lang['strnoserversupplied'] = 'No se suministró un servidor';
	$lang['strbadpgdumppath'] = 'Error de exportación: Falló la ejecución de execute pg_dump (según la ruta dada en conf/config.inc.php : %s). Por favor, arregla esta ruta en tu configuración y vuelve a iniciar sesión.';
	$lang['strbadpgdumpallpath'] = 'Error de exportación: Falló la ejecución de pg_dumpall (según la ruta dada en conf/config.inc.php : %s). Por favor, arregla esta ruta en tu configuración y vuelve a iniciar sesión.';
	$lang['strconnectionfail'] = 'No se puede conectar al servidor.';

	// Tables
	$lang['strtable'] = 'Tabla';
	$lang['strtables'] = 'Tablas';
	$lang['strshowalltables'] = 'Mostrar todas las tablas';
	$lang['strnotables'] = 'No se encontraron tablas.';
	$lang['strnotable'] = 'No se encontró la tabla.';
	$lang['strcreatetable'] = 'Crear tabla';
	$lang['strcreatetablelike'] = 'Crear una tabla a partir de una existente';
	$lang['strcreatetablelikeparent'] = 'Tabla de origen';
	$lang['strcreatelikewithdefaults'] = 'INCLUIR VALORES POR DEFECTO';
	$lang['strcreatelikewithconstraints'] = 'INCLUIR RESTRICCIONES';
	$lang['strcreatelikewithindexes'] = 'INCLUIR ÍNDICES';
	$lang['strtablename'] = 'Nombre de la tabla';
	$lang['strtableneedsname'] = 'Debes darle un nombre a la tabla.';
	$lang['strtablelikeneedslike'] = 'Debes especificar una tabla para copiar sus propiedades.';
	$lang['strtableneedsfield'] = 'Debes especificar al menos un campo.';
	$lang['strtableneedscols'] = 'Debes especificar un número válido de columnas.';
	$lang['strtablecreated'] = 'Tabla creada.';
	$lang['strtablecreatedbad'] = 'Falló la creación de la tabla.';
	$lang['strconfdroptable'] = '¿Estás seguro que desea eliminar la tabla "%s"?';
	$lang['strtabledropped'] = 'Tabla eliminada.';
	$lang['strtabledroppedbad'] = 'Falló la eliminación de la tabla.';
	$lang['strconfemptytable'] = '¿Estás seguro que desea vaciar la tabla "%s"?';
	$lang['strtableemptied'] = 'Tabla vaciada.';
	$lang['strtableemptiedbad'] = 'Falló el vaciado de la tabla.';
	$lang['strinsertrow'] = 'Insertar Fila';
	$lang['strrowinserted'] = 'Fila insertada.';
	$lang['strrowinsertedbad'] = 'Falló la inserción de fila.';
	$lang['strnofkref'] = 'No se hay un valor coincidente en la clave foránea %s.';
	$lang['strrowduplicate']  =  'Falló la inserción de fila , se intentó hacer una inserción duplicada.';
	$lang['streditrow'] = 'Editar fila';
	$lang['strrowupdated'] = 'Fila actualizada.';
	$lang['strrowupdatedbad'] = 'Falló la actualización de la fila.';
	$lang['strdeleterow'] = 'Eliminar Fila';
	$lang['strconfdeleterow'] = '¿Estás seguro que quiere eliminar esta fila?';
	$lang['strrowdeleted'] = 'Fila eliminada.';
	$lang['strrowdeletedbad'] = 'Falló la eliminación de fila.';
	$lang['strinsertandrepeat']  =  'Insertar y Repite';
	$lang['strnumcols']  =  'Número de columnas';
	$lang['strcolneedsname']  =  'Debes especificar un nombre para la columna';
	$lang['strselectallfields'] = 'Seleccionar todos los campos.';
	$lang['strselectneedscol'] = 'Debes elegir al menos una columna';
	$lang['strselectunary'] = 'Los operadores unarios no pueden tener valores.';
	$lang['strcolumnaltered'] = 'Columna Modificada.';
	$lang['strcolumnalteredbad'] = 'Falló la modificación de columna.';
	$lang['strconfdropcolumn'] = '¿Estás seguro que quiere eliminar la columna "%s" de la tabla "%s"?';
	$lang['strcolumndropped'] = 'Columna eliminada.';
	$lang['strcolumndroppedbad'] = 'Falló la eliminación de columna.';
	$lang['straddcolumn'] = 'Agregar Columna';
	$lang['strcolumnadded'] = 'Columna agregada.';
	$lang['strcolumnaddedbad'] = 'Falló el agregado de columna.';
	$lang['strcascade'] = 'EN CASCADA';
	$lang['strtablealtered'] = 'Tabla modificada.';
	$lang['strtablealteredbad'] = 'Falló la modificación  de la Tabla.';
	$lang['strdataonly'] = 'Solamente datos';
	$lang['strstructureonly'] = 'Solo la estructura';
	$lang['strstructureanddata'] = 'Estructura y datos';
	$lang['strtabbed'] = 'Tabulado';
	$lang['strauto'] = 'Automático';
	$lang['strconfvacuumtable']  =  '¿Estás seguro que quiere limpiar "%s"?';
	$lang['strconfanalyzetable'] = '¿Estás seguro que quiere analizar "%s"?';
	$lang['strconfreindextable'] = '¿Estás seguro que quiere actualizar los índices "%s"?';
	$lang['strconfclustertable'] = '¿Estás seguro que quiere clusterizar "%s"?';
	$lang['strestimatedrowcount'] = 'Cantidad de filas estimadas';
	$lang['strspecifytabletoanalyze'] = 'Debes especificar al menos una tabla para analizar.';
	$lang['strspecifytabletoempty'] = 'Debes especificar al menos una tabla para vaciar.';
	$lang['strspecifytabletodrop'] = 'Debes especificar al menos una tabla para eliminar.';
	$lang['strspecifytabletovacuum'] = 'Debes especificar al menos una tabla para limpiar.';
	$lang['strspecifytabletoreindex'] = 'Debes especificar al menos una tabla para actualizar sus índices.';
	$lang['strspecifytabletocluster'] = 'Debes especificar al menos una tabla para clusterizar.';
	$lang['strnofieldsforinsert'] = 'No puedes insertar un registro en una tabla sin columnas.';

	// Columns
	$lang['strcolprop'] = 'Propiedades de la Columna';
	$lang['strnotableprovided'] = '¡No se suministró al menos una tabla!';

	// Users
	$lang['struser'] = 'Usuario';
	$lang['strusers'] = 'Usuarios';
	$lang['strusername'] = 'Nombre de usuario';
	$lang['strpassword'] = 'Contraseña';
	$lang['strsuper'] = '¿Superusuario?';
	$lang['strcreatedb'] = '¿Puede crear BD?';
	$lang['strexpires'] = 'Expira';
	$lang['strsessiondefaults'] = 'Valores predeterminados de la sesión.';
	$lang['strnousers'] = 'No se encontraron usuarios.';
	$lang['struserupdated'] = 'Usuario actualizado.';
	$lang['struserupdatedbad'] = 'Falló la actualización del usuario.';
	$lang['strshowallusers'] = 'Mostrar todos los usuarios';
	$lang['strcreateuser'] = 'Crear usuario';
	$lang['struserneedsname'] = 'Debes dar un nombre a su usuario.';
	$lang['strusercreated'] = 'Usuario creado.';
	$lang['strusercreatedbad'] = 'Falló la creación del usuario.';
	$lang['strconfdropuser'] = '¿Estás seguro de querer eliminar el usuario "%s"?';
	$lang['struserdropped'] = 'Usuario eliminado.';
	$lang['struserdroppedbad'] = 'Falló la eliminación del usuario.';
	$lang['straccount'] = 'Cuenta';
	$lang['strchangepassword'] = 'Cambiar Contraseña';
	$lang['strpasswordchanged'] = 'Contraseña modificada.';
	$lang['strpasswordchangedbad'] = 'Falló al modificar contraseña.';
	$lang['strpasswordshort'] = 'La contraseña es muy corta.';
	$lang['strpasswordconfirm'] = 'Las contraseñas no coinciden.';

	// Groups
	$lang['strgroup'] = 'Grupo';
	$lang['strgroups']  =  'Grupos';
	$lang['strgroupgroups']  =  'Groups in group "%s"';
	$lang['strshowallgroups'] = 'Mostrar todos los grupos';
	$lang['strnogroup'] = 'Grupo no encontrado.';
	$lang['strnogroups'] = 'No se encontraron grupos.';
	$lang['strcreategroup'] = 'Crear Grupo';
	$lang['strgroupneedsname'] = 'Debes darle un nombre al grupo.';
	$lang['strgroupcreated'] = 'Grupo creado.';
	$lang['strgroupcreatedbad'] = 'Falló la creación del grupo.';
	$lang['strconfdropgroup'] = '¿Estás seguro de querer eliminar el grupo "%s"?';
	$lang['strgroupdropped'] = 'Grupo eliminado.';
	$lang['strgroupdroppedbad'] = 'Falló la eliminación del grupo.';
	$lang['strmembers'] = 'Miembros';
	$lang['strmemberof']  =  'Miembro de';
	$lang['stradminmembers']  =  'Administadores ';
	$lang['straddmember'] = 'Agregar miembro';
	$lang['strmemberadded'] = 'Miembro agregado.';
	$lang['strmemberaddedbad'] = 'Falló la agregación de un nuevo miembro.';
	$lang['strdropmember'] = 'Retirar miembro';
	$lang['strconfdropmember'] = '¿Estás seguro de  retirar el miembro "%s" del grupo "%s"?';
	$lang['strmemberdropped'] = 'Miembro retirado.';
	$lang['strmemberdroppedbad'] = 'Falló al retirar un miembro del grupo.';

	// Roles
	$lang['strrole']  =  'Rol';
	$lang['strroles']  =  'Roles';
	$lang['strshowallroles'] = 'Mostrar todas los roles';
	$lang['strnoroles'] = 'No se encontraron roles.';
	$lang['strinheritsprivs']  =  '¿Hereda privilegios?';
	$lang['strcreaterole']  =  'Crear rol';
	$lang['strcancreaterole']  =  '¿Puede crear roles?';
	$lang['strrolecreated']  =  'Rol creado.';
	$lang['strrolecreatedbad']  =  'Falló la creación del rol.';
	$lang['strrolealtered'] = 'Rol modificado.';
	$lang['strrolealteredbad'] = 'Falló la modificación del rol.';
	$lang['strcanlogin']  =  '¿Puede iniciar sesión?';
	$lang['strconnlimit']  =  'Límite de conexión';
	$lang['strdroprole']  =  'Eliminar rol';
	$lang['strconfdroprole']  =  '¿Estás seguro de que desea eliminar el rol "%s"?';
	$lang['strroledropped']  =  'Rol eliminado.';
	$lang['strroledroppedbad']  =  'Falló la eliminación del rol.';
	$lang['strnolimit']  =  'Sin límite';
	$lang['strnever']  =  'Nunca';
	$lang['strroleneedsname']  =  'Debes darle un nombre al rol.';

	// Privileges
	$lang['strprivilege'] = 'Privilegio';
	$lang['strprivileges'] = 'Privilegios';
	$lang['strnoprivileges'] = 'Por defecto, este objeto tiene privilegios de usuario.';
	$lang['strgrant'] = 'Otorgar';
	$lang['strrevoke'] = 'Revocar';
	$lang['strgranted'] = 'Los privilegios cambiaron.';
	$lang['strgrantfailed'] = 'Falló la actualización de los privilegios.';
	$lang['strgrantbad'] = 'Debes especificar al menos un usuario o grupo y al menos un privilegio.';
	$lang['strgrantor']  =  'Cedente';
	$lang['strasterisk']  =  '*';

	// Databases
	$lang['strdatabase'] = 'Base de Datos';
	$lang['strdatabases'] = 'Bases de Datos';
	$lang['strshowalldatabases'] = 'Mostrar todas las bases de datos';
	$lang['strnodatabases'] = 'No se encontraron las bases de datos.';
	$lang['strcreatedatabase'] = 'Crear base de datos';
	$lang['strdatabasename'] = 'Nombre de la base de datos';
	$lang['strdatabaseneedsname'] = 'Debes darle un nombre a la base de datos.';
	$lang['strdatabasecreated'] = 'Base de datos creada.';
	$lang['strdatabasecreatedbad'] = 'Falló la creación de la base de datos.';    
	$lang['strconfdropdatabase'] = '¿Estás seguro que quiere eliminar la base de datos "%s"?';
	$lang['strdatabasedropped'] = 'Base de datos eliminada.';
	$lang['strdatabasedroppedbad'] = 'Falló al eliminar la base de datos.';
	$lang['strentersql'] = 'Ingrese la sentencia de SQL para ejecutar:';
	$lang['strsqlexecuted'] = 'SQL ejecutada.';
	$lang['strvacuumgood'] = 'Limpieza completada.';
	$lang['strvacuumbad'] = 'Falló la limpieza.';
	$lang['stranalyzegood'] = 'Análisis completado.';
	$lang['stranalyzebad'] = 'El analisis falló.';
	$lang['strreindexgood'] = 'Actualización de índices completada.';
	$lang['strreindexbad'] = 'Falló la actualización de índices.';
	$lang['strfull'] = 'Llena';
	$lang['strfreeze'] = 'Congelar';
	$lang['strforce'] = 'Forzar';
	$lang['strsignalsent']  =  'Señal enviada.';
	$lang['strsignalsentbad']  =  'Falló el envío de la señal.';
	$lang['strallobjects']  =  'Todos los objetos';
	$lang['strdatabasealtered']  =  'Base de Datos modificada.';
	$lang['strdatabasealteredbad']  =  'Falló al intentar modificar la base de datos.';
	$lang['strspecifydatabasetodrop'] = 'Debes especificar al menos una base de datos para eliminar.';
	$lang['strtemplatedb'] = 'Plantilla';
	$lang['strconfanalyzedatabase'] = '¿Estás seguro que desea analizar todas las tablas en la base de datos "%s"?';
	$lang['strconfvacuumdatabase'] = '¿Estás seguro que desea limpiar todas las tablas en la base de datos "%s"?';
	$lang['strconfreindexdatabase'] = '¿Estás seguro que desea actualizar los índices de  todas las tablas en la base de datos "%s"?';
	$lang['strconfclusterdatabase'] = '¿Estás seguro que desea ordenar todas las tablas en la base de datos  "%s"?';

	// Views
	$lang['strview'] = 'Vista';
	$lang['strviews'] = 'Vistas';
	$lang['strshowallviews'] = 'Mostrar todas las vistas';
	$lang['strnoview'] = 'No se encontró la vista.';
	$lang['strnoviews'] = 'No se encontraron vistas.';
	$lang['strcreateview'] = 'Crear Vista';
	$lang['strviewname'] = 'Ver el nombre';
	$lang['strviewneedsname'] = 'Debes darle un nombre a la vista.';
	$lang['strviewneedsdef'] = 'Debes darle una definición a su vista.';
	$lang['strviewneedsfields'] = 'Debes seleccionar las columnas deseadas en su vista.';
	$lang['strviewcreated'] = 'Vista creada.';
	$lang['strviewcreatedbad'] = 'Falló al crear la vista.';
	$lang['strconfdropview'] = '¿Estás seguro que quiere eliminar la vista "%s"?';
	$lang['strviewdropped'] = 'Vista eliminada.';
	$lang['strviewdroppedbad'] = 'Falló al intentar eliminar la vista.';
	$lang['strviewupdated'] = 'Vista actualizada.';
	$lang['strviewupdatedbad'] = 'Falló al actualizar la vista.';
	$lang['strviewlink'] = 'Claves de enlace';
	$lang['strviewconditions'] = 'Condiciones adicionales';
	$lang['strcreateviewwiz'] = 'Crear vista usando el asistente';
	$lang['strrenamedupfields'] = 'Renombrar campos duplicados';
	$lang['strdropdupfields'] = 'Eliminar campos duplicados';
	$lang['strerrordupfields'] = 'Error en campos duplicados';
	$lang['strviewaltered'] = 'Vista modificada.';
	$lang['strviewalteredbad'] = 'Falló en la modificación de la vista.';
	$lang['strspecifyviewtodrop'] = 'Debes especificar al menos una vista a eliminar.';

	// Sequences
	$lang['strsequence'] = 'Secuencia';
	$lang['strsequences'] = 'Secuencias';
	$lang['strshowallsequences'] = 'Mostrar todas las secuencias';
	$lang['strnosequence'] = 'No se encontró la secuencia.';
	$lang['strnosequences'] = 'No se encontraron las secuencias.';
	$lang['strcreatesequence'] = 'Crear secuencia';
	$lang['strlastvalue'] = 'Último Valor';
	$lang['strincrementby'] = 'Incremento';    
	$lang['strstartvalue'] = 'Valor inicial';
	$lang['strrestartvalue'] = 'Reiniciar valor';
	$lang['strmaxvalue'] = 'Valor máximo';
	$lang['strminvalue'] = 'Valor mínimo';
	$lang['strcachevalue'] = 'Valor de la  caché';
	$lang['strlogcount'] = 'Registrar cuenta';
	$lang['strcancycle'] = '¿Cíclica?';
	$lang['striscalled'] = '¿Incrementará el último valor antes de ser llamado (is_called)?';
	$lang['strsequenceneedsname'] = 'Debes especificar el nombre de la secuencia.';
	$lang['strsequencecreated'] = 'Secuencia creada.';
	$lang['strsequencecreatedbad'] = 'Falló la creación de la secuencia.'; 
	$lang['strconfdropsequence'] = '¿Estás seguro que quiere eliminar la secuencia "%s"?';
	$lang['strsequencedropped'] = 'Secuencia eliminada.';
	$lang['strsequencedroppedbad'] = 'Falló la eliminación de la secuencia.';
	$lang['strsequencerestart'] = 'Secuencia restablecida.';
	$lang['strsequencerestartbad'] = 'Falló al restablecer la secuencia.';
	$lang['strsequencereset'] = 'Secuencia reiniciada.';
	$lang['strsequenceresetbad'] = 'Falló al intentar reiniciar la secuencia.'; 
	$lang['strsequencealtered'] = 'Secuencia modificada.';
	$lang['strsequencealteredbad'] = 'Falló la modificación de la secuencia.';
	$lang['strsetval']  =  'Fijar el valor';
	$lang['strsequencesetval'] = 'Fijar el valor de la secuencia.';
	$lang['strsequencesetvalbad'] = 'Falló la fijación del valor en la secuencia.';
	$lang['strnextval'] = 'Valor de incremento';
	$lang['strsequencenextval'] = 'Secuencia incrementada.';
	$lang['strsequencenextvalbad'] = 'Falló el incremento de la secuencia.';
	$lang['strspecifysequencetodrop'] = 'Debes especificar al menos una secuencia a eliminar.';

	// Indexes
	$lang['strindex'] = 'Índice';
	$lang['strindexes'] = 'Índices';
	$lang['strindexname'] = 'Nombre del Índice';
	$lang['strshowallindexes'] = 'Mostrar Todos los Índices';
	$lang['strnoindex'] = 'No se encontró el índice.';
	$lang['strnoindexes'] = 'No se encontraron índices.';
	$lang['strcreateindex'] = 'Crear Índice';
	$lang['strtabname'] = 'Nombre de la pestaña';
	$lang['strcolumnname'] = 'Nombre de Columna';
	$lang['strindexneedsname'] = 'Debes darle un nombre al índice';
	$lang['strindexneedscols'] = 'Los índices requieren un número válido de columnas.';
	$lang['strindexcreated'] = 'Índice creado';
	$lang['strindexcreatedbad'] = 'Falló la creación del índice.';
	$lang['strconfdropindex'] = '¿Estás seguro d eliminar el índice "%s"?';
	$lang['strindexdropped'] = 'Índice eliminado.';
	$lang['strindexdroppedbad'] = 'Falló la eliminación del índice.';
	$lang['strkeyname'] = 'Nombre de la clave';
	$lang['struniquekey'] = 'Clave única';
	$lang['strprimarykey'] = 'Clave primaria';
	$lang['strindextype'] = 'Tipo de índice';
	$lang['strtablecolumnlist'] = 'Columnas en tabla';
	$lang['strindexcolumnlist'] = 'Columnas en el índice';
	$lang['strconfcluster'] = '¿Estás seguro de querer clusterizar en "%s"?';
	$lang['strclusteredgood'] = 'Clusterización completa.';
	$lang['strclusteredbad'] = 'Falló la clusterización de la tabla.';
	$lang['strconcurrently'] = 'Concurrente';
	$lang['strnoclusteravailable'] = 'Tabla no ordenada en un índice.';

	// Rules
	$lang['strrules'] = 'Reglas';
	$lang['strrule'] = 'Regla';
	$lang['strshowallrules'] = 'Mostrar todas las reglas';
	$lang['strnorule'] = 'No se encontró la regla.';
	$lang['strnorules'] = 'No se encontraron las reglas.';
	$lang['strcreaterule'] = 'Crear regla';
	$lang['strrulename'] = 'Nombre de regla';
	$lang['strruleneedsname'] = 'Debes darle un nombre a la regla.';
	$lang['strrulecreated'] = 'Regla creada.';
	$lang['strrulecreatedbad'] = 'Falló la creación de la regla.';
	$lang['strconfdroprule'] = '¿Estás seguro de querer eliminar la regla "%s" en "%s"?';
	$lang['strruledropped'] = 'Regla eliminada.';
	$lang['strruledroppedbad'] = 'Falló la eliminación de la regla.';

	// Constraints
	$lang['strconstraint']  =  'Restricción';
	$lang['strconstraints'] = 'Restricciones';
	$lang['strshowallconstraints'] = 'Mostrar todas las restricciones';
	$lang['strnoconstraints'] = 'No se encontraron restricciones.';
	$lang['strcreateconstraint'] = 'Crear restricción';
	$lang['strconstraintcreated'] = 'Restricción creada.';
	$lang['strconstraintcreatedbad'] = 'Falló la creación de la restricción.';
	$lang['strconfdropconstraint'] = '¿Estás seguro que quiere eliminar la restricción "%s" de "%s"?';
	$lang['strconstraintdropped'] = 'Restricción eliminada.';
	$lang['strconstraintdroppedbad'] = 'Falló al eliminar la restricción.';
	$lang['straddcheck'] = 'Agregar chequeo';
	$lang['strcheckneedsdefinition'] = 'La restricción de chequeo necesita una definición.';
	$lang['strcheckadded'] = 'Restricción de chequeo agregada.';
	$lang['strcheckaddedbad'] = 'Fallo al intentar agregar restricción de chequeo.';
	$lang['straddpk'] = 'Agregar clave primaria';
	$lang['strpkneedscols'] = 'La clave primaria necesita al menos un campo.';
	$lang['strpkadded'] = 'Clave primaria agregada.';
	$lang['strpkaddedbad'] = 'Falló al intentar crear la clave primaria.';
	$lang['stradduniq'] = 'Agregar clave única';
	$lang['struniqneedscols'] = 'La clave única necesita al menos un campo.';
	$lang['struniqadded'] = 'Clave única agregada.';
	$lang['struniqaddedbad'] = 'Falló al intentar agregar la clave única.';
	$lang['straddfk'] = 'Agregar clave foránea';
	$lang['strfkneedscols'] = 'La clave foránea necesita al menos un campo.';
	$lang['strfkneedstarget'] = 'La clave foránea necesita una tabla para referenciar.';
	$lang['strfkadded'] = 'Clave foránea agregada.';
	$lang['strfkaddedbad'] = 'Fallo al agregar la clave foránea.';
	$lang['strfktarget'] = 'Tabla de destino';
	$lang['strfkcolumnlist'] = 'Campos en la clave';
	$lang['strondelete'] = 'AL ELIMINAR';
	$lang['stronupdate'] = 'AL ACTUALIZAR';

	// Functions
	$lang['strfunction'] = 'Función';
	$lang['strfunctions'] = 'Funciones';
	$lang['strshowallfunctions'] = 'Mostrar todas las funciones';
	$lang['strnofunction'] = 'No se encontró la función.';
	$lang['strnofunctions'] = 'No se encontraron funciones.';
	$lang['strcreateplfunction']  =  'Crear función SQL/PL';
	$lang['strcreateinternalfunction']  =  'Crear función interna';
	$lang['strcreatecfunction']  =  'Crear función en C';
	$lang['strfunctionname'] = 'Nombre de la función';
	$lang['strreturns'] = 'Retorna';
	$lang['strproglanguage'] = 'Lenguaje de programación';
	$lang['strfunctionneedsname'] = 'Debes darle un nombre a la función.';
	$lang['strfunctionneedsdef'] = 'Debes darle una definición a la función.';
	$lang['strfunctioncreated'] = 'Función creada.';
	$lang['strfunctioncreatedbad'] = 'Falló la creación de la función.';
	$lang['strconfdropfunction'] = '¿Estás seguro que quiere eliminar la función "%s"?';
	$lang['strfunctiondropped'] = 'Función eliminada.';
	$lang['strfunctiondroppedbad'] = 'Falló al eliminar la función.';
	$lang['strfunctionupdated'] = 'Función actualizada.';
	$lang['strfunctionupdatedbad'] = 'Falló al actualizar la función.';
	$lang['strobjectfile']  =  'Archivo de objeto';
	$lang['strlinksymbol']  =  'Vinculo simbólico';
	$lang['strarguments']  =  'Argumentos';
	$lang['strargmode']  =  'Modo';
	$lang['strargtype']  =  'Tipo';
	$lang['strargadd']  =  'Agregar otro argumento';
	$lang['strargremove']  =  'Eliminar este argumento';
	$lang['strargnoargs']  =  'Esta función no tendrá argumentos.';
	$lang['strargenableargs']  =  'Habilitar argumentos pasados a esta función.';
	$lang['strargnorowabove'] = 'Debe existir una fila por encima de esta fila.';
	$lang['strargnorowbelow'] = 'Debe exisitr una fila por debajo de esta fila.';
	$lang['strargraise']  =  'Mover arriba.';
	$lang['strarglower']  =  'Mover abajo.';
	$lang['strargremoveconfirm']  =  '¿Esta seguro que quiere eliminar este argumento? Esto NO se puede deshacer.';
	$lang['strfunctioncosting'] = 'Costo de la función';
	$lang['strresultrows'] = 'Filas en el resultado';
	$lang['strexecutioncost'] = 'Costo de ejecución';
	$lang['strspecifyfunctiontodrop'] = 'Debes especificar al menos una función a eliminar.';

	// Triggers
	$lang['strtrigger'] = 'Disparador';
	$lang['strtriggers'] = 'Disparadores';
	$lang['strshowalltriggers'] = 'Mostrar todos los disparadores';
	$lang['strnotrigger'] = 'No se encontró el disparador.';
	$lang['strnotriggers'] = 'No se encontraron disparadores.';
	$lang['strcreatetrigger'] = 'Crear Disparador';
	$lang['strtriggerneedsname'] = 'Debes darle un nombre al disparador.';
	$lang['strtriggerneedsfunc'] = 'Debes especificar una función para el disparador.';
	$lang['strtriggercreated'] = 'Disparador creado.';
	$lang['strtriggercreatedbad'] = 'Falló la creación del disparador.';
	$lang['strconfdroptrigger'] = '¿Estás seguro que quiere eliminar el disparador "%s" en "%s"?';
	$lang['strconfenabletrigger'] = '¿Estás seguro que desea activar el disparador "%s" en "%s"?';
	$lang['strconfdisabletrigger'] = '¿Estás seguro que desea desactivar el disparador "%s" en "%s"?';
	$lang['strtriggerdropped'] = 'Disparador eliminado.';
	$lang['strtriggerdroppedbad'] = 'Falló al eliminar el disparador.';
	$lang['strtriggerenabled'] = 'Disparador activado.';
	$lang['strtriggerenabledbad'] = 'Falló la activación del disparador.';
	$lang['strtriggerdisabled'] = 'Disparador desactivado.';
	$lang['strtriggerdisabledbad'] = 'Falló la desactivación del disparador.';
	$lang['strtriggeraltered'] = 'Disparador modificado.';
	$lang['strtriggeralteredbad'] = 'Falló la modificación del disparador.';
	$lang['strforeach']  =  'Para cada uno';

	// Types
	$lang['strtype'] = 'Tipo de dato';
	$lang['strtypes'] = 'Tipos de datos';
	$lang['strshowalltypes'] = 'Mostrar todos los tipos';
	$lang['strnotype'] = 'No se encontró el tipo.';
	$lang['strnotypes'] = 'No se encontraron tipos.';
	$lang['strcreatetype'] = 'Crear Tipo';
	$lang['strcreatecomptype'] = 'Crear tipo compuesto';
	$lang['strcreateenumtype'] = 'Crear tipo enumerado';
	$lang['strtypeneedsfield'] = 'Debes especificar al menos un campo.';
	$lang['strtypeneedsvalue'] = 'Debes especificar al menos un valor.';
	$lang['strtypeneedscols'] = 'Tipos compuestos requieren de un número válido de columnas.';
	$lang['strtypeneedsvals'] = 'Debes especificar un número válido de valores.';
	$lang['strinputfn'] = 'Función de entrada';
	$lang['stroutputfn'] = 'Función de salida';
	$lang['strpassbyval'] = '¿Pasar por valor?';
	$lang['stralignment'] = 'Alineamiento';
	$lang['strelement'] = 'Elemento';
	$lang['strdelimiter'] = 'Delimitador';
	$lang['strstorage'] = 'Almacenamiento';
	$lang['strfield']  =  'Campo';
	$lang['strnumfields']  =  'Número de campos';
	$lang['strnumvalues'] = 'Número de valores';
	$lang['strtypeneedsname'] = 'Debes especificar un nombre para el tipo.';
	$lang['strtypeneedslen'] = 'Debes especificar una longitud para el tipo.';
	$lang['strtypecreated'] = 'Tipo creado';
	$lang['strtypecreatedbad'] = 'Falló la creación del tipo.';
	$lang['strconfdroptype'] = '¿Estás seguro de querer eliminar el tipo "%s"?';
	$lang['strtypedropped'] = 'Tipo eliminado.';
	$lang['strtypedroppedbad'] = 'Falló al eliminar el tipo.';
	$lang['strflavor'] = 'Tipo';
	$lang['strbasetype'] = 'Base';
	$lang['strcompositetype']  =  'Compuesto';
	$lang['strpseudotype']  =  'Seudo';
	$lang['strenum']  =  'Enumerado';
	$lang['strenumvalues'] = 'Valores enumerados';

	// Schemas
	$lang['strschema'] = 'Esquema';
	$lang['strschemas'] = 'Esquemas';
	$lang['strshowallschemas'] = 'Mostrar Todos los Esquemas';
	$lang['strnoschema'] = 'No se encontró el esquema.';
	$lang['strnoschemas'] = 'No se encontraron esquemas.';
	$lang['strcreateschema'] = 'Crear Esquema';
	$lang['strschemaname'] = 'Nombre del esquema';
	$lang['strschemaneedsname'] = 'Debes especificar un nombre para el esquema.';
	$lang['strschemacreated'] = 'Esquema creado';
	$lang['strschemacreatedbad'] = 'Falló la creación del esquema.';
	$lang['strconfdropschema'] = '¿Estás seguro que quiere eliminar el esquema "%s"?';
	$lang['strschemadropped'] = 'Esquema eliminado.';
	$lang['strschemadroppedbad'] = 'Falló la eliminación del esquema.';
	$lang['strschemaaltered'] = 'Esquema actualizado.';
	$lang['strschemaalteredbad'] = 'Falló la actualización del esquema.';
	$lang['strsearchpath']  =  'Ruta de la búsqueda en los esquemas';
	$lang['strspecifyschematodrop'] = 'Debes especificar al menos un esquema a eliminar.';

	// Reports

	//Domains
	$lang['strdomain'] = 'Dominio';
	$lang['strdomains'] = 'Dominios';
	$lang['strshowalldomains'] = 'Mostrar todos los dominios';
	$lang['strnodomains'] = 'No se encontraron dominios.';
	$lang['strcreatedomain'] = 'Crear dominio';
	$lang['strdomaindropped'] = 'Dominio eliminado.';
	$lang['strdomaindroppedbad'] = 'Falló la eliminación del dominio.';
	$lang['strconfdropdomain'] = '¿Esta seguro de querer eliminar el dominio "%s"?';
	$lang['strdomainneedsname'] = 'Debes dar un nombre para el dominio.';
	$lang['strdomaincreated'] = 'Dominio creado.';
	$lang['strdomaincreatedbad'] = 'Falló la creación del dominio.';
	$lang['strdomainaltered'] = 'Dominio modificado.';
	$lang['strdomainalteredbad'] = 'Falló al intentar modificar el dominio.';

	// Operators
	$lang['stroperator'] = 'Operador';
	$lang['stroperators'] = 'Operadores';
	$lang['strshowalloperators'] = 'Mostrar todos los operadores';
	$lang['strnooperator'] = 'No se encontró el operador.';
	$lang['strnooperators'] = 'No se encontraron operadores.';
	$lang['strcreateoperator'] = 'Crear operador';
	$lang['strleftarg'] = 'Tipo de datos del arg. izquierdo';
	$lang['strrightarg'] = 'Tipo de datos del arg. derecho';
	$lang['strcommutator'] = 'Conmutador';
	$lang['strnegator'] = 'Negación';
	$lang['strrestrict'] = 'Restringir';
	$lang['strjoin'] = 'Unión';
	$lang['strhashes'] = 'Llaves (Hash)';
	$lang['strmerges'] = 'Fusiones';
	$lang['strleftsort'] = 'Ordenado izquierdo';
	$lang['strrightsort'] = 'Ordenado derecho';
	$lang['strlessthan'] = 'Menor que';
	$lang['strgreaterthan'] = 'Mayor que';
	$lang['stroperatorneedsname'] = 'Debes darle un nombre al operador.';
	$lang['stroperatorcreated'] = 'Operador creado';
	$lang['stroperatorcreatedbad'] = 'Falló la creación del operador.';
	$lang['strconfdropoperator'] = '¿Estás seguro de querer eliminar el operador "%s"?';
	$lang['stroperatordropped'] = 'Operador eliminado.';
	$lang['stroperatordroppedbad'] = 'Falló en la eliminación del operador.';

	// Casts
	$lang['strcasts'] = 'Conversión de tipos';
	$lang['strnocasts'] = 'No se encontraron conversiones.';
	$lang['strsourcetype'] = 'Tipo del origen';
	$lang['strtargettype'] = 'Tipo del destino';
	$lang['strimplicit'] = 'Implícito';
	$lang['strinassignment'] = 'En asignación';
	$lang['strbinarycompat'] = '(Compatible con binario)';

	// Conversions
	$lang['strconversions'] = 'Conversiones';
	$lang['strnoconversions'] = 'No se encontraron conversiones.';
	$lang['strsourceencoding'] = 'Codificación de la fuente';
	$lang['strtargetencoding'] = 'Codificación del destino';

	// Languages
	$lang['strlanguages'] = 'Lenguajes';
	$lang['strnolanguages'] = 'No se encontraron lenguajes.';
	$lang['strtrusted'] = 'Confiable';

	// Info
	$lang['strnoinfo'] = 'No hay información disponible.';
	$lang['strreferringtables'] = 'Tablas referenciales';
	$lang['strparenttables'] = 'Tablas padre';
	$lang['strchildtables'] = 'Tablas hija';

	// Aggregates
	$lang['straggregate']  =  'Agregación';
	$lang['straggregates'] = 'Agregaciones';
	$lang['strnoaggregates'] = 'No se encontraron agregaciones.';
	$lang['stralltypes'] = '(Todos los tipos)';
	$lang['strcreateaggregate']  =  'Crear Agregación';
	$lang['straggrbasetype'] = 'Tipo del dato de entrada';
	$lang['straggrsfunc'] = 'Función de transición de estado';
	$lang['straggrstype'] = 'Tipo de dato para el valor de estado';
	$lang['straggrffunc'] = 'Función final';
	$lang['straggrinitcond'] = 'Condición inicial';
	$lang['straggrsortop'] = 'Operador de ordenamiento';
	$lang['strconfdropaggregate'] = '¿Estás seguro que desea eliminar la agregación "%s"?';
	$lang['straggregatedropped'] = 'Agregación eliminada.';
	$lang['straggregatedroppedbad'] = 'Falló en la eliminación de la agregación.';
	$lang['straggraltered']  =  'Agregación modificada.';
	$lang['straggralteredbad']  =  'Falló la modificación de la agregación.';
	$lang['straggrneedsname'] = 'Debes especificar un nombre para la agregación.';
	$lang['straggrneedsbasetype'] = 'Debes especificar un tipo de dato de entrada para la agregación.';
	$lang['straggrneedssfunc'] = 'Debes especificar el nombre de la función de transición de estado de la agregación.';
	$lang['straggrneedsstype'] = 'Debes especificar el tipo de dato para la el valor de estado de la agregación.';
	$lang['straggrcreated']  =  'Agregación creada.';
	$lang['straggrcreatedbad']  =  'Falló la creación de la agregación.';
	$lang['straggrshowall']  =  'Mostrar todas las agregaciones';

	// Operator Classes
	$lang['stropclasses'] = 'Clases de operadores';
	$lang['strnoopclasses'] = 'No se encontraron las clases de operadores.';
	$lang['straccessmethod'] = 'Método de acceso';

	// Stats and performance
	$lang['strrowperf'] = 'Rendimiento de fila';
	$lang['strioperf'] = 'Rentimiento de E/S';
	$lang['stridxrowperf'] = 'Rendimiento de índice de la fila';
	$lang['stridxioperf'] = 'Rendimiento de indexado de E/S';
	$lang['strpercent'] = '%';
	$lang['strsequential'] = 'Secuencial';
	$lang['strscan'] = 'Escanear';
	$lang['strread'] = 'Leer';
	$lang['strfetch'] = 'Extraer';
	$lang['strheap'] = 'Salto';
	$lang['strtoast'] = 'TOAST';
	$lang['strtoastindex'] = 'Indice TOAST';
	$lang['strcache'] = 'Caché';
	$lang['strdisk'] = 'Disco';
	$lang['strrows2'] = 'Filas';

	// Tablespaces
	$lang['strtablespace'] = 'Tablespace';
	$lang['strtablespaces'] = 'Tablespaces';
	$lang['strshowalltablespaces'] = 'Mostrar todos los tablespaces';
	$lang['strnotablespaces'] = 'No se encontraron tablespaces.';
	$lang['strcreatetablespace'] = 'Crear tablespace';
	$lang['strlocation'] = 'Ubicación';
	$lang['strtablespaceneedsname']  =  'Debes darle un nombre al tablespace.';
	$lang['strtablespaceneedsloc']  =  'Debes dar un directorio en donde crear el tablespace.';
	$lang['strtablespacecreated']  =  'Tablespace creado.';
	$lang['strtablespacecreatedbad']  =  'Falló la creación del tablespace.';
	$lang['strconfdroptablespace']  =  '¿Esta seguro que quiere eliminar el tablespace "%s"?';
	$lang['strtablespacedropped']  =  'Tablespace eliminado.';
	$lang['strtablespacedroppedbad']  =  'Falló la eliminación del tablespace.';
	$lang['strtablespacealtered']  =  'Tablespace modificado.';
	$lang['strtablespacealteredbad']  =  'Falló la modificación del Tablespace.';

	// Miscellaneous
	$lang['strtopbar'] = '%s corriendo en %s:%s -- Usted ha iniciado sesión con el usuario "%s"';
	$lang['strtimefmt'] = 'd/m/Y, G:i:s';
	$lang['strhelp'] = 'Ayuda';
	$lang['strhelpicon']  =  '?';
	$lang['strhelppagebrowser'] = 'Buscador de la  página de ayúda';
	$lang['strselecthelppage'] = 'Seleccione una página de ayuda';
	$lang['strinvalidhelppage'] = 'Página de ayuda inválida.';
	$lang['strlogintitle']  =  'Iniciar sesión en %s';
	$lang['strlogoutmsg']  =  'Saliendo de %s';
	$lang['strloading']  =  'Cargando...';
	$lang['strerrorloading']  =  'Error al cargar';
	$lang['strclicktoreload']  =  'Clic para recargar';

	// Autovacuum
	$lang['strautovacuum']  =  'Autolimpiado';
	$lang['strturnedon'] = 'Encendido';
	$lang['strturnedoff'] = 'Apagado';
	$lang['strenabled']  =  'Habilitado'; 
	$lang['strnovacuumconf'] = 'No se encontró configuración para autolimpiar.';
	$lang['strvacuumbasethreshold']  =  'Umbral de limpiar';
	$lang['strvacuumscalefactor'] = 'Factor de escala de limpiado';
	$lang['stranalybasethreshold'] = 'Analizar umbral base';
	$lang['stranalyzescalefactor'] = 'Analizar Facor de Escala';
	$lang['strvacuumcostdelay']  =  'Tiempo de retraso para limpiar';
	$lang['strvacuumcostlimit'] = 'Limite del costo de limpiar';
	$lang['strvacuumpertable'] = 'Configuración de autolimpiar de cada tabla';
	$lang['straddvacuumtable'] = 'Agregar configuración de autolimpiar a una tabla';
	$lang['streditvacuumtable'] = 'Editar configuración de autolimpiar para la tabla %s';
	$lang['strdelvacuumtable'] = '¿Eliminar configuración de autolimpiar para la tabla %s ?';
	$lang['strvacuumtablereset'] = 'Reiniciar configuración de autolimpiar para la tabla  %s ';
	$lang['strdelvacuumtablefail'] = 'Falló al remover la configuración de autolimpiar para la tabla %s';
	$lang['strsetvacuumtablesaved'] = 'Configuración de autolimpiar %s guardada.';
	$lang['strsetvacuumtablefail'] = 'Falló la configuración de autolimpiar para la tabla %s.';
	$lang['strspecifydelvacuumtable'] = 'Debes especificar la tabla a la que deseas removerle los parámetros de autolimpiar.';
	$lang['strspecifyeditvacuumtable'] = 'Debes especificar la tabla a la que deseeas editarle los parámetros de autolimpiar.';
	$lang['strnotdefaultinred'] = 'Los valores en rojo no son los valores por defecto.';

	// Table-level Locks
	$lang['strlocks']  =  'Bloqueos';
	$lang['strtransaction']  =  'ID de la transacción';
	$lang['strvirtualtransaction'] = 'ID de la transacción virtual';
	$lang['strprocessid']  =  'ID de proceso';
	$lang['strmode']  =  'Modo de bloqueo';
	$lang['strislockheld'] = '¿Se mantiene el bloqueo?';

	// Prepared transactions
	$lang['strpreparedxacts']  =  'Transacciones preparadas';
	$lang['strxactid']  =  'ID de la Transacción';
	$lang['strgid']  =  'ID Global';

	// Fulltext search
	$lang['strfulltext'] = 'Búsqueda de texto completo';
	$lang['strftsconfig'] = 'Configuración de BTC';
	$lang['strftsconfigs'] = 'Configuraciones';
	$lang['strftscreateconfig'] = 'Crear configuración de BTC';
	$lang['strftscreatedict'] = 'Crear diccionario';
	$lang['strftscreatedicttemplate'] = 'Crear plantilla de dicionario';
	$lang['strftscreateparser'] = 'Crear analizador';
	$lang['strftsnoconfigs'] = 'No se encontró configuración de búsqueda de texto completo.';
	$lang['strftsconfigdropped'] = 'Configuración de búsqueda de texto completo eliminada.';
	$lang['strftsconfigdroppedbad'] = 'Falló la eliminación de la configuración de búsqueda de texto completo.';
	$lang['strconfdropftsconfig'] = '¿Estás seguro de eliminar la configuración de búsqueda de texto completo "%s"?';
	$lang['strconfdropftsdict'] = '¿Estás seguro eliminar el diccionario de BTC "%s"?';
	$lang['strconfdropftsmapping'] = '¿Estás seguro de eliminar la asignación "%s" de la configuración de BTC "%s"?';
	$lang['strftstemplate'] = 'Plantilla';
	$lang['strftsparser'] = 'Analizador';
	$lang['strftsconfigneedsname'] = 'Debes suministrar un nombre para la configuración de la BTC.';
	$lang['strftsconfigcreated'] = 'Configuración de BTC creada.';
	$lang['strftsconfigcreatedbad'] = 'Falló la creación de BTC.';
	$lang['strftsmapping'] = 'Mapeo';
	$lang['strftsdicts'] = 'Diccionarios';
	$lang['strftsdict'] = 'Diccionario';
	$lang['strftsemptymap'] = 'Configuración vacía de la asignación de BTC .';
	$lang['strftsconfigaltered'] = 'Configuración de BTC modificada.';
	$lang['strftsconfigalteredbad'] = 'Falló la modificación de la configuración de BTC.';
	$lang['strftsconfigmap'] = 'Configuración de asignación de BTC';
	$lang['strftsparsers'] = 'Analizadores de BTC';
	$lang['strftsnoparsers'] = 'No hay analizadores de BTC disponibles.';
	$lang['strftsnodicts'] = 'No hay diccionarios de BTC disponibles.';
	$lang['strftsdictcreated'] = 'Diccionario de BTC creado.';
	$lang['strftsdictcreatedbad'] = 'Falló la creación del diccionario BTC.';
	$lang['strftslexize'] = 'Analizar léxicamente';
	$lang['strftsinit'] = 'Iniciar';
	$lang['strftsoptionsvalues'] = 'Opciones y valores';
	$lang['strftsdictneedsname'] = 'Debes suministrar un nombre para el diccionario de BTC.';
	$lang['strftsdictdropped'] = 'Diccionario de BTC eliminado.';
	$lang['strftsdictdroppedbad'] = 'Falló la eliminación del diccionario de BTC.';
	$lang['strftsdictaltered'] = 'Diccionario de BTC modificado.';
	$lang['strftsdictalteredbad'] = 'Falló la modificación del diccionario de BTC.';
	$lang['strftsaddmapping'] = 'Agregar nueva asignación';
	$lang['strftsspecifymappingtodrop'] = 'Debes especificar al menos una asignación a eliminar.';
	$lang['strftsspecifyconfigtoalter'] = 'Debes especificar una configuración de BTC a modificar';
	$lang['strftsmappingdropped'] = 'Asignación de BTC eliminada.';
	$lang['strftsmappingdroppedbad'] = 'Falló la eliminación de la asignación de BTC.';
	$lang['strftsnodictionaries'] = 'No se encontrarón diccionarios.';
	$lang['strftsmappingaltered'] = 'Asignación de BTC modificada.';
	$lang['strftsmappingalteredbad'] = 'Falló la modificación de la asignación de BTC.';
	$lang['strftsmappingadded'] = 'Asignación de BTC agregada.';
	$lang['strftsmappingaddedbad'] = 'Falló la asignación de BTC.';
	$lang['strftstabconfigs'] = 'Configuraciones';
	$lang['strftstabdicts'] = 'Diccionarios';
	$lang['strftstabparsers'] = 'Analizadores';
	$lang['strftscantparsercopy'] = 'No se puede especificar tanto el analizador como la plantilla durante la creación de la configuración de la búsqueda de texto.';

	//Plugins
	$lang['strpluginnotfound'] = 'Error: el plugin \'%s\' no se encontró. Chequea si existe en la carpeta plugins/ , o si el plugin contiene un archivo llamado plugin.php. Los nombres de los plugin son sensibles a las mayúsculas';
	$lang['stractionnotfound'] = 'Error: la acción \'%s\'  no se encontró en el \'%s\' del plugin, o no se especificó como acción.';
	$lang['strhooknotfound'] = 'Error: el hook \'%s\' no está disponible.';
?>
