/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.UIManager;
import org.igoweb.go.Loc;
import org.igoweb.go.swing.GobanController;
import org.igoweb.go.swing.StoneImages;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Prefs;

public class StoneWidget
extends Component
implements MouseListener {
    private static final int MIN_NONSKID_MS = 250;
    public static final int COLOR_CURSOR = 3;
    private boolean mouseOver;
    private boolean mousePressed = false;
    private int color = 2;
    private int cursorType = 2;
    private int mark = 0;
    private String label = null;
    private final int whiteImageId = StoneImages.whiteImageId();
    private int gridType;
    public final Loc loc;
    private GobanController controller = null;
    private long mouseEnterDate = 0L;
    private StoneImages images = null;
    public static String SHOW_KO_PREF = "i?AA3|zy";

    public StoneWidget(Loc loc, int boardSize, int curStone, int gridType) {
        this.color = curStone;
        this.loc = loc;
        this.addMouseListener(this);
        this.gridType = gridType;
    }

    public void setGridType(int newGridType) {
        this.gridType = newGridType;
    }

    public void clearImages() {
        this.images = null;
    }

    @Override
    public void paint(Graphics g) {
        int size = (int)Math.floor((double)this.getSize().width / (1.0 + StoneImages.shadowOffsetRatio));
        if (this.images == null || this.images.size != size) {
            this.images = StoneImages.create(size);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(Color.black);
        int shownMarks = this.mark;
        if ((shownMarks & 0x100) != 0 && !Prefs.getBoolean(SHOW_KO_PREF, true)) {
            shownMarks &= 0xFFFFFEFF;
        }
        switch (this.cursorType) {
            case 2: {
                break;
            }
            case 1: {
                shownMarks |= 0x400;
                break;
            }
            case 0: {
                shownMarks |= 0x200;
                break;
            }
            case 3: {
                shownMarks |= 1;
            }
        }
        this.images.paintStone(g2d, this.color, shownMarks, this.whiteImageId, this.label, this.gridType);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    @Override
    public Dimension getPreferredSize() {
        int fontH = UIManager.getInt("org.igoweb.fontH");
        return new Dimension(fontH, fontH);
    }

    public void setController(GobanController newController) {
        this.controller = newController;
        if (this.mouseOver && !this.mousePressed) {
            this.mouseEntered(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.controller == null || !this.controller.useAntiSkid() || !this.getParent().isEnabled() || System.currentTimeMillis() > this.mouseEnterDate + 250L) {
            this.mousePressed = true;
            if (this.controller != null && this.getParent().isEnabled()) {
                int oldCursorType = this.cursorType;
                int modifiers = event.getModifiers();
                this.cursorType = this.controller.getCursor(this.loc, modifiers, this.isShifted(modifiers));
                if (this.cursorType != oldCursorType) {
                    this.repaint();
                }
                if (this.cursorType != 2) {
                    return;
                }
            }
        } else if (this.controller != null && this.controller.useAntiSkid() && this.getParent().isEnabled()) {
            Defs.ringBell();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        boolean mouseWasPressed = this.mousePressed;
        this.mousePressed = false;
        int modifiers = event.getModifiers();
        boolean shifted = this.isShifted(modifiers);
        if (this.mouseOver && mouseWasPressed && this.controller != null && this.getParent().isEnabled()) {
            this.controller.boardClicked(this.loc, event.getModifiers(), shifted);
        }
        int oldCursorType = this.cursorType;
        this.cursorType = 2;
        if (this.mouseOver && this.controller != null && this.getParent().isEnabled()) {
            this.cursorType = this.controller.getCursor(this.loc, modifiers, shifted);
        }
        if (this.cursorType != oldCursorType) {
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.mouseOver = true;
        if (event != null) {
            this.mouseEnterDate = System.currentTimeMillis();
        }
        int oldCursorType = this.cursorType;
        this.cursorType = 2;
        if (this.controller != null && this.getParent().isEnabled()) {
            int modifiers = event == null ? 0 : event.getModifiers();
            this.cursorType = this.controller.getCursor(this.loc, modifiers, this.isShifted(modifiers));
        }
        if (oldCursorType != this.cursorType) {
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.mouseOver = false;
        if (this.cursorType != 2) {
            this.cursorType = 2;
            this.repaint();
        }
    }

    public void set(int newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            this.repaint();
        }
    }

    public void clearMark() {
        this.clearMark(-1538);
    }

    public boolean clearMark(int oldMarks) {
        if ((this.mark & oldMarks) != 0) {
            this.mark &= ~oldMarks;
            this.repaint();
            return true;
        }
        return false;
    }

    public final int getColor() {
        return this.color;
    }

    public final int getMark() {
        return this.mark;
    }

    public String getLabel() {
        if ((this.mark & 2) == 0) {
            return null;
        }
        return this.label;
    }

    public boolean setMark(int newMarks) {
        if ((this.mark & newMarks) != newMarks) {
            this.mark |= newMarks;
            this.repaint();
            return true;
        }
        return false;
    }

    public final void setLabel(String label) {
        if ((this.mark & 2) == 0 || !label.equals(this.label)) {
            this.label = label;
            this.mark |= 2;
            this.repaint();
        }
    }

    private boolean isShifted(int modifiers) {
        try {
            return (modifiers & 1) != 0 || this.controller != null && this.controller.isCapsLockShift() && this.getParent().isEnabled() && this.getToolkit().getLockingKeyState(20);
        }
        catch (UnsupportedOperationException excep) {
            return false;
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public String toString() {
        return "StoneWidget[" + this.loc.x + "," + this.loc.y + "]";
    }
}

